/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.tag.html;

import java.util.HashMap;

public class Img extends InlineElement {

    private static final String tagName = "img";

    private static HashMap<String, HashMap<String, String>> validParentMap;
    private static HashMap<String, String> attributeMap;

    static {

        validParentMap = new HashMap<String, HashMap<String, String>>();
        validParentMap.putAll(blockElementMap);
        validParentMap.putAll(inlineElementMap);
        validParentMap.remove("var");

        attributeMap = new HashMap<String, String>();
        attributeMap.put("align", "top, middle, bottom, left, center, right");
        attributeMap.put("alt", "");
        attributeMap.put("border", "");
        attributeMap.put("height", "");
        attributeMap.put("hspace", "");
        attributeMap.put("ismap", "");
        attributeMap.put("longdesc", "");
        attributeMap.put("name", "");
        attributeMap.put("src", "");
        attributeMap.put("usemap", "");
        attributeMap.put("vspace", "");
        attributeMap.put("width", "");
    }

    public Img() {

        setNodeName("img");
        setFormatType(FORMAT_INLINE);
        isEmpty(true);
        setAttribute("alt", "image");
        setAttribute("src", "image.png");
    }

    public static String getTag() {
        return tagName;
    }

    @Override
	public void init() {
    }

    public String getSrc() {
        return getAttribute("src");
    }

    public String getAlt() {
        return getAttribute("alt");
    }

    public String getWidth() {
        return getAttribute("width");
    }

    public String getHeight() {
        return getAttribute("height");
    }

    public String getAlign() {
        return getAttribute("align");
    }
}
