# Microchip PolarFire SoC Contributing Guidelines

[fork]: /fork
[pr]: /compare
[style]: https://standardjs.com/
[code-of-conduct]: CODE_OF_CONDUCT.md
[discussion-forum]: https://github.com/polarfire-soc/polarfire-soc-documentation/discussions

Hi there! We're thrilled that you'd like to contribute to this project. Your help is essential for keeping it great.

Please note that this project is released with a [Contributor Code of Conduct][code-of-conduct]. By participating in this project you agree to abide by its terms.

## Discussions, Issues and PRs

If you have suggestions for how this project or an individual component could be improved, have a question or need help please open a discussion thread in the organization's [discussion forum](discussion-forum).
Note: if your question is related to a fork of an external repository (e.g Zephyr) and the query isn't directly related to any Microchip code, please be aware that it may be better to open an discussion thread in the source repository.
If you want to report a bug, open an issue against the source repository containing the offending code.
We appreciate any contributions.

We also welcome PRs to add features, board support for new targets and fix issues. If you would like to add a new feature it is advised to make an enhancement request in our [discussion forum](discussion-forum) so the feature request can be discussed. If you would like to add board support please reach out to your Mi-V ecosystem contact before opening a PR. Look at the links below if you're not sure how to open a PR.

## Submitting a pull request

1. Fork and clone the repository.
1. Create a new branch: `git checkout -b my-branch-name`.
1. Make and test your changes.
1. When you're happy that your fix or improvement is stable commit your changes and push to your fork.
1. Verify that your changes apply to the head of the source branch.
1. Submit a pull request.
1. Wait for your pull request to be reviewed.
1. As we push to GitHub from an internal git repository, we may not merge your change directly on GitHub, it is more likely to be applied internally as a patch and mirrored to GitHub.
1. If this is the case we will let you know when change has been reviewed and if it has been accepted or not.
1. We will update the PR and let you know when the change has been released and subsequently close the PR.

Here are a few things you can do that will increase the likelihood of your pull request being accepted:

- Explain why this change is needed, what bugs are fixed or why this feature should be merged.
- Demonstrate how you have tested and verified your change is stable.
- Keep your changes as focused as possible. If there are multiple changes you would like to make that are not dependent upon each other, consider submitting them as separate pull requests.
- Write a [good commit message](http://tbaggery.com/2008/04/19/a-note-about-git-commit-messages.html).

## Resources

- [How to Contribute to Open Source](https://opensource.guide/how-to-contribute/)
- [Using Pull Requests](https://help.github.com/articles/about-pull-requests/)
- [GitHub Help](https://help.github.com)
