#
# pidgin_major_ver and pidgin_minor_ver should be defined to match the minimum
# Pidgin API version _required_ to build Guifications
# Due to the way Pidgin checks plugin versions, we need to also ensure that
# the correct minimum version of Pidgin is Require:'d based on what version of
# the Pidgin headers we actually build with.
#
# This allows --define 'pidginver 1' to be used to build an rpm for Pidgin 1.x
# default is to build for Pidgin 2.x
%{!?pidginver: %{expand: %%define pidginver 2}}
%define pidgin_major_ver %{pidginver}
%define pidgin_minor_ver 0
%define pidgin_next_major_ver %(echo $((%{pidgin_major_ver}+1)))
%define pidgin_build_minor_ver %(pkg-config --modversion pidgin | awk -F. '{ print $2 }')

Summary:    Guifications Plugin for Pidgin
Name:       pidgin-guifications
Version:    2.16
Release:    0%{?pidgindist:.%{pidgindist}}
License:    GPL
Group:      Applications/Internet
Url:        http://pidgin.guifications.org
Source:     http://downloads.guifications.org/pidgin-plugins/Guifications2/%{name}-%{version}.tar.bz2
BuildRoot:  %{_tmppath}/%{name}-%{version}-root

Requires:   pidgin >= %{pidgin_major_ver}.%{pidgin_build_minor_ver}, pidgin < %{pidgin_next_major_ver}

BuildRequires: pkgconfig, libtool, gettext
BuildRequires: pidgin-devel >= %{pidgin_major_ver}.%{pidgin_minor_ver}, pidgin-devel < %{pidgin_next_major_ver}
%if "%{_vendor}" == "MandrakeSoft"
BuildRequires: libgtk+2.0_0-devel
%else
BuildRequires: gtk2-devel
%endif

%description
Guifications is a graphical notification plugin for the open source instant messaging client Pidgin

To rebuild for a specific Pidgin version:
rpmbuild --rebuild %{name}-%{version}-%{release}.src.rpm --define 'pidgindist %{!?pidgindist:fc1}%{?pidgindist:%{pidgindist}}'

%prep
%setup -q

%build
%configure
make %{?_smp_mflags}

%install
rm -rf $RPM_BUILD_ROOT
make DESTDIR="$RPM_BUILD_ROOT" install

%if "%{_vendor}" == "MandrakeSoft"
mv -f $RPM_BUILD_ROOT%{_libdir}/pidgin/guifications $RPM_BUILD_ROOT%{_libdir}/pidgin/guifications.so || :
%endif

strip $RPM_BUILD_ROOT%{_libdir}/pidgin/*.so || :
rm -f $RPM_BUILD_ROOT%{_libdir}/pidgin/*.la $RPM_BUILD_ROOT%{_libdir}/pidgin/*.a

%find_lang guifications

%clean
rm -rf $RPM_BUILD_ROOT

%files -f guifications.lang
%defattr(-, root, root)
%doc AUTHORS ChangeLog COPYING README doc/flow.png doc/flow.dia doc/QUOTES
%{_libdir}/pidgin/*.so
%{_datadir}/pixmaps/pidgin/guifications

%changelog
* Mon Apr 30 2007 Stu Tomlinson <stu@nosnilmot.com>
- Pidgin dropped the epochs, yay!
- Use tar.bz2 for source

* Sun Apr 1 2007 John Bailey <rekkanoryo@rekkanoryo.org>
- :%s/gaim/pidgin/g and :%s/Gaim/Pidgin/g to prep for eventual Pidgin
  releases.

* Tue Dec 5 2006 John Bailey <rekkanoryo@rekkanoryo.org>
- Fix the source URL to point to our new download location

* Thu Oct 19 2006 Stu Tomlinson <stu@nosnilmot.com>
- Fix finding the translations

* Thu Nov  3 2005 Stu Tomlinson <stu@nosnilmot.com>
- Default to building for Pidgin 2.x with a bit of trickery to optionally
  build for Pidgin 1.x

* Fri Apr  8 2005 Stu Tomlinson <stu@nosnilmot.com>
- spec file cleanup, build vs. install dependency fixes, use %%find_lang,
  tidy up release version, fix directory ownership

* Fri Dec 17 2004 Stu Tomlinson <stu@nosnilmot.com>
- Tweaks to the Pidgin version dependencies

* Sat Oct  9 2004 Stu Tomlinson <stu@nosnilmot.com>
- Add Pidgin version checks to match new Pidgin versioning

* Wed Jun 30 2004 Stu Tomlinson <stu@nosnilmot.com>
- Initial spec file for Guifications 2
