/*
 * Decompiled with CFR 0.152.
 */
package com.dsi.ant.plugins.antplus.pcc.controls.defines;

import java.util.EnumSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ControlsMode {
    UNRECOGNIZED_MODE_PRESENT(1L, -1),
    AUDIO_MODE(2L, 300),
    VIDEO_MODE(4L, 301),
    GENERIC_MODE(8L, 302);

    private final long longValue;
    private final int reqAccValue;

    private ControlsMode(long longValue, int reqAccValue) {
        this.longValue = longValue;
        this.reqAccValue = reqAccValue;
    }

    public long getLongValue() {
        return this.longValue;
    }

    public int getRequestAccessModeValue() {
        return this.reqAccValue;
    }

    public static EnumSet<ControlsMode> getControlsModesFromLong(long longValue) {
        EnumSet<ControlsMode> controlsModes = EnumSet.noneOf(ControlsMode.class);
        for (ControlsMode mode : ControlsMode.values()) {
            long modeValue = mode.getLongValue();
            if ((modeValue & longValue) != modeValue) continue;
            controlsModes.add(mode);
            longValue -= modeValue;
        }
        if (longValue != 0L) {
            controlsModes.add(UNRECOGNIZED_MODE_PRESENT);
        }
        return controlsModes;
    }

    public static ControlsMode getControlsModeFromRequestAccessValue(int value) {
        ControlsMode result = UNRECOGNIZED_MODE_PRESENT;
        for (ControlsMode mode : ControlsMode.values()) {
            int modeReqAccValue = mode.getRequestAccessModeValue();
            if (modeReqAccValue != value) continue;
            result = mode;
            break;
        }
        return result;
    }

    public static long getLongFromControlsModes(EnumSet<ControlsMode> controlsModes) {
        long longValue = 0L;
        for (ControlsMode mode : controlsModes) {
            longValue |= mode.getLongValue();
        }
        return longValue;
    }
}

