/*
 * Decompiled with CFR 0.152.
 */
package com.dsi.ant.plugins.antplus.pcc.controls;

import android.content.Context;
import android.os.Bundle;
import android.os.Message;
import com.dsi.ant.plugins.antplus.pcc.controls.defines.AudioVideoCommandNumber;
import com.dsi.ant.plugins.antplus.pcc.controls.defines.ControlsMode;
import com.dsi.ant.plugins.antplus.pcc.controls.defines.VideoDeviceCapabilities;
import com.dsi.ant.plugins.antplus.pcc.controls.defines.VideoDeviceState;
import com.dsi.ant.plugins.antplus.pcc.controls.pccbase.AntPlusBaseRemoteControlPcc;
import com.dsi.ant.plugins.antplus.pcc.defines.EventFlag;
import com.dsi.ant.plugins.antplus.pcc.defines.RequestStatus;
import com.dsi.ant.plugins.antplus.pccbase.AntPluginPcc;
import com.dsi.ant.plugins.antplus.pccbase.PccReleaseHandle;
import com.dsi.ant.plugins.utility.log.LogAnt;
import java.util.EnumSet;
import java.util.concurrent.Semaphore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntPlusVideoRemoteControlPcc
extends AntPlusBaseRemoteControlPcc {
    private static final String TAG = AntPlusVideoRemoteControlPcc.class.getSimpleName();
    private static final int INVALIDCOMMANDDATA = 255;
    IVideoStatusReceiver mVideoStatusReceiver;
    IVideoCommandFinishedReceiver mVideoCommandFinishedReceiver;
    Semaphore mCommandLock = new Semaphore(1);

    public static AntPlusBaseRemoteControlPcc.RemoteControlAsyncScanController<AntPlusVideoRemoteControlPcc> requestRemoteControlAsyncScanController(EnumSet<ControlsMode> requestModes, Context bindToContext, int searchProximityThreshold, AntPlusBaseRemoteControlPcc.IRemoteControlAsyncScanResultReceiver scanResultReceiver) {
        AntPlusVideoRemoteControlPcc potentialRetObj = new AntPlusVideoRemoteControlPcc();
        return AntPlusVideoRemoteControlPcc.requestAccessRemoteControl_Helper(requestModes, bindToContext, searchProximityThreshold, potentialRetObj, scanResultReceiver);
    }

    public static PccReleaseHandle<AntPlusVideoRemoteControlPcc> requestAccessByDeviceNumber(EnumSet<ControlsMode> requestModes, Context bindToContext, int antDeviceNumber, int searchProximityThreshold, AntPluginPcc.IPluginAccessResultReceiver<AntPlusVideoRemoteControlPcc> resultReceiver, AntPluginPcc.IDeviceStateChangeReceiver stateReceiver) {
        AntPlusVideoRemoteControlPcc potentialRetObj = new AntPlusVideoRemoteControlPcc();
        return AntPlusVideoRemoteControlPcc.requestAccessRemoteControl_Helper(requestModes, bindToContext, antDeviceNumber, searchProximityThreshold, resultReceiver, stateReceiver, potentialRetObj);
    }

    private AntPlusVideoRemoteControlPcc() {
    }

    @Override
    protected String getPluginPrintableName() {
        return "ANT+ Plugin: Video Remote Control";
    }

    @Override
    protected void handlePluginEvent(Message eventMsg) {
        switch (eventMsg.arg1) {
            case 204: {
                if (this.mVideoStatusReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                int volume = b.getInt("int_volume");
                boolean muted = b.getBoolean("bool_muted");
                int timeRemaining = b.getInt("int_timeRemaining");
                int timeProgressed = b.getInt("int_timeProgressed");
                VideoDeviceCapabilities videoCapabilities = VideoDeviceCapabilities.readFromBundle(b);
                VideoDeviceState videoStateCode = VideoDeviceState.getValueFromInt(b.getInt("int_videoState"));
                this.mVideoStatusReceiver.onNewVideoStatus(estTimestamp, volume, muted, timeRemaining, timeProgressed, videoCapabilities, videoStateCode);
                break;
            }
            case 207: {
                if (this.mVideoCommandFinishedReceiver == null) break;
                this.mCommandLock.release();
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                RequestStatus status = RequestStatus.getValueFromInt(b.getInt("int_requestStatus"));
                this.mVideoCommandFinishedReceiver.onVideoCommandFinished(estTimestamp, eventFlags, status);
                break;
            }
            default: {
                super.handlePluginEvent(eventMsg);
            }
        }
    }

    public void subscribeVideoStatusEvent(IVideoStatusReceiver VideoStatusReceiver) {
        this.mVideoStatusReceiver = VideoStatusReceiver;
        if (VideoStatusReceiver != null) {
            this.subscribeToEvent(204);
        } else {
            this.unsubscribeFromEvent(204);
        }
    }

    public void RequestVideoCommand(IVideoCommandFinishedReceiver videoCommandFinishedReceiver, AudioVideoCommandNumber commandNumber, int commandData) {
        if (!this.mCommandLock.tryAcquire()) {
            LogAnt.e(TAG, "Cmd RequestVideoCommand failed to start because a local command is still processing.");
            return;
        }
        this.mVideoCommandFinishedReceiver = videoCommandFinishedReceiver;
        Message cmdMsg = Message.obtain();
        cmdMsg.what = 20004;
        Bundle params = new Bundle();
        cmdMsg.setData(params);
        params.putInt("int_commandNumber", commandNumber.getIntValue());
        params.putInt("int_commandData", commandData);
        Message ret = this.sendPluginCommand(cmdMsg);
        if (ret == null) {
            LogAnt.e(TAG, "Cmd RequestVideoCommand died in sendPluginCommand()");
            this.mCommandLock.release();
            return;
        }
        if (ret.arg1 != 0) {
            LogAnt.e(TAG, "Cmd RequestVideoCommand failed with code " + ret.arg1);
            this.mCommandLock.release();
            throw new RuntimeException("RequestVideoCommand cmd failed internally");
        }
        ret.recycle();
    }

    public void RequestVideoCommand(IVideoCommandFinishedReceiver videoCommandFinishedReceiver, AudioVideoCommandNumber commandNumber) {
        this.RequestVideoCommand(videoCommandFinishedReceiver, commandNumber, 255);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IVideoCommandFinishedReceiver {
        public void onVideoCommandFinished(long var1, EnumSet<EventFlag> var3, RequestStatus var4);
    }

    public static interface IVideoStatusReceiver {
        public void onNewVideoStatus(long var1, int var3, boolean var4, int var5, int var6, VideoDeviceCapabilities var7, VideoDeviceState var8);
    }

    public class IpcDefines {
        public static final int MSG_EVENT_REMOTECONTROL_whatVIDEOSTATUS = 204;
        public static final int MSG_CMD_REMOTECONTROL_whatVIDEOCOMMAND = 20004;
        public static final int MSG_EVENT_REMOTECONTROL_whatVIDEOCOMMANDFINISHED = 207;
        public static final String MSG_EVENT_REMOTECONTRL_VIDEOCOMMANDFINISHED_PARAM_intREQUESTSTATUS = "int_requestStatus";
    }
}

