/*
 * Decompiled with CFR 0.152.
 */
package com.dsi.ant.plugins.antplus.pcc.controls;

import android.content.Context;
import android.os.Bundle;
import android.os.Message;
import com.dsi.ant.plugins.antplus.pcc.controls.defines.CommandStatus;
import com.dsi.ant.plugins.antplus.pcc.controls.defines.ControlsMode;
import com.dsi.ant.plugins.antplus.pcc.controls.defines.GenericCommandNumber;
import com.dsi.ant.plugins.antplus.pcc.controls.pccbase.AntPlusBaseControllableDevicePcc;
import com.dsi.ant.plugins.antplus.pcc.defines.EventFlag;
import com.dsi.ant.plugins.antplus.pccbase.AntPluginPcc;
import com.dsi.ant.plugins.antplus.pccbase.PccReleaseHandle;
import com.dsi.ant.plugins.utility.log.LogAnt;
import java.util.EnumSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntPlusGenericControllableDevicePcc
extends AntPlusBaseControllableDevicePcc {
    private static final String TAG = AntPlusGenericControllableDevicePcc.class.getSimpleName();
    IGenericCommandReceiver mGenericCommandReceiver;

    @Override
    protected int getRequiredServiceVersionForBind() {
        return 0;
    }

    public static PccReleaseHandle<AntPlusGenericControllableDevicePcc> requestAccess(Context bindToContext, AntPluginPcc.IPluginAccessResultReceiver<AntPlusGenericControllableDevicePcc> resultReceiver, AntPluginPcc.IDeviceStateChangeReceiver stateReceiver, final IGenericCommandReceiver genericCommandReceiver, int channelDeviceId) {
        if (AntPlusGenericControllableDevicePcc.getInstalledPluginsVersionNumber(bindToContext) == 10000) {
            AntPlusBaseControllableDevicePcc.IpcDefines.PATH_ANTPLUS_CONTROLLABLEDEVICEPLUGIN_SERVICE = "com.dsi.ant.plugins.antplus.controls.ControlsService";
        }
        Bundle b = new Bundle();
        b.putInt("int_RequestAccessMode", ControlsMode.GENERIC_MODE.getRequestAccessModeValue());
        b.putInt("int_ChannelDeviceId", channelDeviceId);
        final AntPlusGenericControllableDevicePcc potentialRetObj = new AntPlusGenericControllableDevicePcc();
        return AntPlusGenericControllableDevicePcc.requestAccess_Helper_Main(bindToContext, b, potentialRetObj, new AntPluginPcc.RequestAccessResultHandler<AntPlusGenericControllableDevicePcc>(){

            @Override
            public boolean handleRequestAccessResult(Message msg) {
                boolean result = super.handleRequestAccessResult(msg);
                int resultCode = msg.what;
                if (resultCode == 0) {
                    potentialRetObj.subscribeGenericCommandEvent(genericCommandReceiver);
                }
                return result;
            }
        }, resultReceiver, stateReceiver);
    }

    private AntPlusGenericControllableDevicePcc() {
    }

    @Override
    protected String getPluginPrintableName() {
        return "ANT+ Plugin: Generic Controllable Device";
    }

    @Override
    protected void handlePluginEvent(Message eventMsg) {
        switch (eventMsg.arg1) {
            case 201: {
                if (this.mGenericCommandReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                int serialNumber = b.getInt("int_serialNumber");
                int manufacturerID = b.getInt("int_manufacturerID");
                final int sequenceNumber = b.getInt("int_sequenceNumber");
                final GenericCommandNumber commandNumber = GenericCommandNumber.getValueFromInt(b.getInt("int_commandNumber"));
                final CommandStatus status = this.mGenericCommandReceiver.onNewGenericCommand(estTimestamp, eventFlags, serialNumber, manufacturerID, sequenceNumber, commandNumber);
                Thread t = new Thread(new Runnable(){

                    public void run() {
                        AntPlusGenericControllableDevicePcc.this.updateGenericCommandStatus(sequenceNumber, status, commandNumber);
                    }
                });
                t.start();
                break;
            }
            default: {
                super.handlePluginEvent(eventMsg);
            }
        }
    }

    private void subscribeGenericCommandEvent(IGenericCommandReceiver GenericCommandReceiver) {
        this.mGenericCommandReceiver = GenericCommandReceiver;
        if (GenericCommandReceiver != null) {
            this.subscribeToEvent(201);
        } else {
            this.unsubscribeFromEvent(201);
        }
    }

    private void updateGenericCommandStatus(int sequenceNumber, CommandStatus commandStatus, GenericCommandNumber commandNumber) {
        Message cmdMsg = Message.obtain();
        cmdMsg.what = 20001;
        Bundle params = new Bundle();
        cmdMsg.setData(params);
        params.putInt("int_sequenceNumber", sequenceNumber);
        params.putInt("int_commandStatus", commandStatus.getIntValue());
        params.putInt("int_commandNumber", commandNumber.getIntValue());
        Message ret = this.sendPluginCommand(cmdMsg);
        if (ret == null) {
            LogAnt.e(TAG, "Cmd updateGenericCommandStatus died in sendPluginCommand()");
            return;
        }
        if (ret.arg1 != 0) {
            LogAnt.e(TAG, "Cmd updateGenericCommandStatus failed with code " + ret.arg1);
            throw new RuntimeException("updateGenericCommandStatus cmd failed internally");
        }
        ret.recycle();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IGenericCommandReceiver {
        public CommandStatus onNewGenericCommand(long var1, EnumSet<EventFlag> var3, int var4, int var5, int var6, GenericCommandNumber var7);
    }

    public static class IpcDefines {
        public static final int MSG_EVENT_CONTROLS_whatGENERICCOMMAND = 201;
        public static final String MSG_EVENT_CONTROLS_GENERICCOMMAND_PARAM_intSERIALNUMBER = "int_serialNumber";
        public static final String MSG_EVENT_CONTROLS_GENERICCOMMAND_PARAM_intMANUFACTURERID = "int_manufacturerID";
        public static final String MSG_EVENT_CONTROLS_GENERICCOMMAND_PARAM_intSEQUENCENUMBER = "int_sequenceNumber";
        public static final int MSG_CMD_CONTROLS_whatUPDATEGENERICCOMMANDSTATUS = 20001;
        public static final String MSG_CMD_CONTROLS_UPDATEGENERICCOMMANDSTATUS_PARAM_intSEQUENCENUMBER = "int_sequenceNumber";
        public static final String MSG_CMD_CONTROLS_UPDATEGENERICCOMMANDSTATUS_PARAM_intCOMMANDSTATUS = "int_commandStatus";
        public static final String MSG_CMD_CONTROLS_UPDATEGENERICCOMMANDSTATUS_PARAM_intCOMMANDNUMBER = "int_commandNumber";
    }
}

