/*
 * Decompiled with CFR 0.152.
 */
package com.dsi.ant.plugins.antplus.common;

import android.os.Parcel;
import android.os.Parcelable;
import com.dsi.ant.plugins.utility.log.LogAnt;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class FitFileCommon {
    private static final String TAG = FitFileCommon.class.getSimpleName();

    public static class FitFile
    implements Parcelable {
        private final int ipcVersionNumber;
        private byte[] mFitFileByteArray;
        private short mFitFileType;
        public static final Parcelable.Creator<FitFile> CREATOR = new Parcelable.Creator<FitFile>(){

            public FitFile createFromParcel(Parcel source) {
                return new FitFile(source);
            }

            public FitFile[] newArray(int size) {
                return new FitFile[size];
            }
        };

        public FitFile(byte[] fitFileBytes) {
            this.ipcVersionNumber = 1;
            this.mFitFileByteArray = fitFileBytes;
        }

        public byte[] getRawBytes() {
            return (byte[])this.mFitFileByteArray.clone();
        }

        public void setFileType(short fitFileType) {
            this.mFitFileType = fitFileType;
        }

        public short getFileType() {
            return this.mFitFileType;
        }

        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.mFitFileByteArray);
        }

        public FitFile(Parcel src) {
            this.ipcVersionNumber = 1;
            int incomingVersion = src.readInt();
            if (incomingVersion != 1) {
                LogAnt.i(TAG, "Decoding version " + incomingVersion + " FitFile parcel with version 1 parser.");
            }
            this.mFitFileType = (short)src.readInt();
            this.mFitFileByteArray = new byte[src.readInt()];
            src.readByteArray(this.mFitFileByteArray);
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.ipcVersionNumber);
            dest.writeInt((int)this.mFitFileType);
            dest.writeInt(this.mFitFileByteArray.length);
            dest.writeByteArray(this.mFitFileByteArray);
        }

        public int describeContents() {
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FitFileDataType {
        FIT_DATA_TYPE(128),
        BLOOD_PRESSURE(14),
        INVALID(-1),
        UNRECOGNIZED(-2);

        private int intValue;

        private FitFileDataType(int intValue) {
            this.intValue = intValue;
        }

        public int getIntValue() {
            return this.intValue;
        }

        public static FitFileDataType getValueFromInt(int intValue) {
            for (FitFileDataType dataType : FitFileDataType.values()) {
                if (dataType.getIntValue() != intValue) continue;
                return dataType;
            }
            FitFileDataType unrecognized = UNRECOGNIZED;
            unrecognized.intValue = intValue;
            return unrecognized;
        }
    }

    public static interface IFitFileDownloadedReceiver {
        public void onNewFitFileDownloaded(FitFile var1);
    }

    public class IpcDefines {
    }
}

