/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.ActivityLevel;
import com.garmin.fit.ActivitySubtype;
import com.garmin.fit.ActivityType;
import com.garmin.fit.DateTime;
import com.garmin.fit.Factory;
import com.garmin.fit.Field;
import com.garmin.fit.FieldComponent;
import com.garmin.fit.Mesg;
import com.garmin.fit.SubField;

public class MonitoringMesg
extends Mesg {
    protected static final Mesg monitoringMesg;

    public MonitoringMesg() {
        super(Factory.createMesg(55));
    }

    public MonitoringMesg(Mesg mesg) {
        super(mesg);
    }

    public DateTime getTimestamp() {
        return this.timestampToDateTime(this.getFieldLongValue(253, 0, 65535));
    }

    public void setTimestamp(DateTime dateTime) {
        this.setFieldValue(253, 0, (Object)dateTime.getTimestamp(), 65535);
    }

    public Short getDeviceIndex() {
        return this.getFieldShortValue(0, 0, 65535);
    }

    public void setDeviceIndex(Short s) {
        this.setFieldValue(0, 0, (Object)s, 65535);
    }

    public Integer getCalories() {
        return this.getFieldIntegerValue(1, 0, 65535);
    }

    public void setCalories(Integer n) {
        this.setFieldValue(1, 0, (Object)n, 65535);
    }

    public Float getDistance() {
        return this.getFieldFloatValue(2, 0, 65535);
    }

    public void setDistance(Float f) {
        this.setFieldValue(2, 0, (Object)f, 65535);
    }

    public Float getCycles() {
        return this.getFieldFloatValue(3, 0, 65535);
    }

    public void setCycles(Float f) {
        this.setFieldValue(3, 0, (Object)f, 65535);
    }

    public Long getSteps() {
        return this.getFieldLongValue(3, 0, 0);
    }

    public void setSteps(Long l) {
        this.setFieldValue(3, 0, (Object)l, 0);
    }

    public Float getStrokes() {
        return this.getFieldFloatValue(3, 0, 1);
    }

    public void setStrokes(Float f) {
        this.setFieldValue(3, 0, (Object)f, 1);
    }

    public Float getActiveTime() {
        return this.getFieldFloatValue(4, 0, 65535);
    }

    public void setActiveTime(Float f) {
        this.setFieldValue(4, 0, (Object)f, 65535);
    }

    public ActivityType getActivityType() {
        Short s = this.getFieldShortValue(5, 0, 65535);
        if (s == null) {
            return null;
        }
        return ActivityType.getByValue(s);
    }

    public void setActivityType(ActivityType activityType) {
        this.setFieldValue(5, 0, (Object)activityType.value, 65535);
    }

    public ActivitySubtype getActivitySubtype() {
        Short s = this.getFieldShortValue(6, 0, 65535);
        if (s == null) {
            return null;
        }
        return ActivitySubtype.getByValue(s);
    }

    public void setActivitySubtype(ActivitySubtype activitySubtype) {
        this.setFieldValue(6, 0, (Object)activitySubtype.value, 65535);
    }

    public ActivityLevel getActivityLevel() {
        Short s = this.getFieldShortValue(7, 0, 65535);
        if (s == null) {
            return null;
        }
        return ActivityLevel.getByValue(s);
    }

    public void setActivityLevel(ActivityLevel activityLevel) {
        this.setFieldValue(7, 0, (Object)activityLevel.value, 65535);
    }

    public Integer getDistance16() {
        return this.getFieldIntegerValue(8, 0, 65535);
    }

    public void setDistance16(Integer n) {
        this.setFieldValue(8, 0, (Object)n, 65535);
    }

    public Integer getCycles16() {
        return this.getFieldIntegerValue(9, 0, 65535);
    }

    public void setCycles16(Integer n) {
        this.setFieldValue(9, 0, (Object)n, 65535);
    }

    public Integer getActiveTime16() {
        return this.getFieldIntegerValue(10, 0, 65535);
    }

    public void setActiveTime16(Integer n) {
        this.setFieldValue(10, 0, (Object)n, 65535);
    }

    public Long getLocalTimestamp() {
        return this.getFieldLongValue(11, 0, 65535);
    }

    public void setLocalTimestamp(Long l) {
        this.setFieldValue(11, 0, (Object)l, 65535);
    }

    public Float getTemperature() {
        return this.getFieldFloatValue(12, 0, 65535);
    }

    public void setTemperature(Float f) {
        this.setFieldValue(12, 0, (Object)f, 65535);
    }

    public Float getTemperatureMin() {
        return this.getFieldFloatValue(14, 0, 65535);
    }

    public void setTemperatureMin(Float f) {
        this.setFieldValue(14, 0, (Object)f, 65535);
    }

    public Float getTemperatureMax() {
        return this.getFieldFloatValue(15, 0, 65535);
    }

    public void setTemperatureMax(Float f) {
        this.setFieldValue(15, 0, (Object)f, 65535);
    }

    public int getNumActivityTime() {
        return this.getNumFieldValues(16, 65535);
    }

    public Integer getActivityTime(int n) {
        return this.getFieldIntegerValue(16, n, 65535);
    }

    public void setActivityTime(int n, Integer n2) {
        this.setFieldValue(16, n, (Object)n2, 65535);
    }

    public Integer getActiveCalories() {
        return this.getFieldIntegerValue(19, 0, 65535);
    }

    public void setActiveCalories(Integer n) {
        this.setFieldValue(19, 0, (Object)n, 65535);
    }

    public Byte getCurrentActivityTypeIntensity() {
        return this.getFieldByteValue(24, 0, 65535);
    }

    public void setCurrentActivityTypeIntensity(Byte by) {
        this.setFieldValue(24, 0, (Object)by, 65535);
    }

    public Short getTimestampMin8() {
        return this.getFieldShortValue(25, 0, 65535);
    }

    public void setTimestampMin8(Short s) {
        this.setFieldValue(25, 0, (Object)s, 65535);
    }

    public Integer getTimestamp16() {
        return this.getFieldIntegerValue(26, 0, 65535);
    }

    public void setTimestamp16(Integer n) {
        this.setFieldValue(26, 0, (Object)n, 65535);
    }

    public Short getHeartRate() {
        return this.getFieldShortValue(27, 0, 65535);
    }

    public void setHeartRate(Short s) {
        this.setFieldValue(27, 0, (Object)s, 65535);
    }

    public Float getIntensity() {
        return this.getFieldFloatValue(28, 0, 65535);
    }

    public void setIntensity(Float f) {
        this.setFieldValue(28, 0, (Object)f, 65535);
    }

    public Integer getDurationMin() {
        return this.getFieldIntegerValue(29, 0, 65535);
    }

    public void setDurationMin(Integer n) {
        this.setFieldValue(29, 0, (Object)n, 65535);
    }

    public Long getDuration() {
        return this.getFieldLongValue(30, 0, 65535);
    }

    public void setDuration(Long l) {
        this.setFieldValue(30, 0, (Object)l, 65535);
    }

    static {
        int n = 0;
        int n2 = 0;
        monitoringMesg = new Mesg("monitoring", 55);
        monitoringMesg.addField(new Field("timestamp", 253, 134, 1.0, 0.0, "s", false));
        ++n;
        monitoringMesg.addField(new Field("device_index", 0, 2, 1.0, 0.0, "", false));
        ++n;
        monitoringMesg.addField(new Field("calories", 1, 132, 1.0, 0.0, "kcal", false));
        ++n;
        monitoringMesg.addField(new Field("distance", 2, 134, 100.0, 0.0, "m", false));
        monitoringMesg.addField(new Field("cycles", 3, 134, 2.0, 0.0, "cycles", false));
        n2 = 0;
        MonitoringMesg.monitoringMesg.fields.get((int)(++n)).subFields.add(new SubField("steps", 134, 1.0, 0.0, "steps"));
        MonitoringMesg.monitoringMesg.fields.get((int)n).subFields.get(n2).addMap(5, 6L);
        MonitoringMesg.monitoringMesg.fields.get((int)n).subFields.get(n2).addMap(5, 1L);
        MonitoringMesg.monitoringMesg.fields.get((int)n).subFields.add(new SubField("strokes", 134, 2.0, 0.0, "strokes"));
        MonitoringMesg.monitoringMesg.fields.get((int)n).subFields.get(++n2).addMap(5, 2L);
        MonitoringMesg.monitoringMesg.fields.get((int)n).subFields.get(n2).addMap(5, 5L);
        ++n2;
        ++n;
        monitoringMesg.addField(new Field("active_time", 4, 134, 1000.0, 0.0, "s", false));
        ++n;
        monitoringMesg.addField(new Field("activity_type", 5, 0, 1.0, 0.0, "", false));
        ++n;
        monitoringMesg.addField(new Field("activity_subtype", 6, 0, 1.0, 0.0, "", false));
        ++n;
        monitoringMesg.addField(new Field("activity_level", 7, 0, 1.0, 0.0, "", false));
        ++n;
        monitoringMesg.addField(new Field("distance_16", 8, 132, 1.0, 0.0, "100 * m", false));
        ++n;
        monitoringMesg.addField(new Field("cycles_16", 9, 132, 1.0, 0.0, "2 * cycles (steps)", false));
        ++n;
        monitoringMesg.addField(new Field("active_time_16", 10, 132, 1.0, 0.0, "s", false));
        ++n;
        monitoringMesg.addField(new Field("local_timestamp", 11, 134, 1.0, 0.0, "", false));
        ++n;
        monitoringMesg.addField(new Field("temperature", 12, 131, 100.0, 0.0, "C", false));
        ++n;
        monitoringMesg.addField(new Field("temperature_min", 14, 131, 100.0, 0.0, "C", false));
        ++n;
        monitoringMesg.addField(new Field("temperature_max", 15, 131, 100.0, 0.0, "C", false));
        ++n;
        monitoringMesg.addField(new Field("activity_time", 16, 132, 1.0, 0.0, "minutes", false));
        ++n;
        monitoringMesg.addField(new Field("active_calories", 19, 132, 1.0, 0.0, "kcal", false));
        monitoringMesg.addField(new Field("current_activity_type_intensity", 24, 13, 1.0, 0.0, "", false));
        MonitoringMesg.monitoringMesg.fields.get((int)(++n)).components.add(new FieldComponent(5, false, 5, 1.0, 0.0));
        MonitoringMesg.monitoringMesg.fields.get((int)n).components.add(new FieldComponent(28, false, 3, 1.0, 0.0));
        ++n;
        monitoringMesg.addField(new Field("timestamp_min_8", 25, 2, 1.0, 0.0, "min", false));
        ++n;
        monitoringMesg.addField(new Field("timestamp_16", 26, 132, 1.0, 0.0, "s", false));
        ++n;
        monitoringMesg.addField(new Field("heart_rate", 27, 2, 1.0, 0.0, "bpm", false));
        ++n;
        monitoringMesg.addField(new Field("intensity", 28, 2, 10.0, 0.0, "", false));
        ++n;
        monitoringMesg.addField(new Field("duration_min", 29, 132, 1.0, 0.0, "min", false));
        ++n;
        monitoringMesg.addField(new Field("duration", 30, 134, 1.0, 0.0, "s", false));
        ++n;
    }
}

