/*
 * Decompiled with CFR 0.152.
 */
package com.dsi.ant.plugins.antplus.pccbase;

import android.os.Bundle;
import android.os.Message;
import com.dsi.ant.plugins.antplus.pcc.defines.EventFlag;
import com.dsi.ant.plugins.antplus.pccbase.AntPluginPcc;
import com.dsi.ant.plugins.utility.log.LogAnt;
import java.util.EnumSet;

public abstract class AntPlusLegacyCommonPcc
extends AntPluginPcc {
    private static final String TAG = AntPlusLegacyCommonPcc.class.getSimpleName();
    ICumulativeOperatingTimeReceiver mCumulativeOperatingTimeReceiver;
    IManufacturerAndSerialReceiver mManufacturerAndSerialReceiver;
    IVersionAndModelReceiver mVersionAndModelReceiver;

    protected void handlePluginEvent(Message eventMsg) {
        switch (eventMsg.arg1) {
            case 204: {
                if (this.mCumulativeOperatingTimeReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                long cumulativeOperatingTime = b.getLong("long_cumulativeOperatingTime");
                this.mCumulativeOperatingTimeReceiver.onNewCumulativeOperatingTime(estTimestamp, eventFlags, cumulativeOperatingTime);
                break;
            }
            case 205: {
                if (this.mManufacturerAndSerialReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                int manufacturerID = b.getInt("int_manufacturerID");
                int serialNumber = b.getInt("int_serialNumber");
                this.mManufacturerAndSerialReceiver.onNewManufacturerAndSerial(estTimestamp, eventFlags, manufacturerID, serialNumber);
                break;
            }
            case 206: {
                if (this.mVersionAndModelReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                int hardwareVersion = b.getInt("int_hardwareVersion");
                int softwareVersion = b.getInt("int_softwareVersion");
                int modelNumber = b.getInt("int_modelNumber");
                this.mVersionAndModelReceiver.onNewVersionAndModel(estTimestamp, eventFlags, hardwareVersion, softwareVersion, modelNumber);
                break;
            }
            default: {
                LogAnt.d(TAG, "Unrecognized event received: " + eventMsg.arg1);
            }
        }
    }

    public void subscribeCumulativeOperatingTimeEvent(ICumulativeOperatingTimeReceiver CumulativeOperatingTimeReceiver) {
        this.mCumulativeOperatingTimeReceiver = CumulativeOperatingTimeReceiver;
        if (CumulativeOperatingTimeReceiver != null) {
            this.subscribeToEvent(204);
        } else {
            this.unsubscribeFromEvent(204);
        }
    }

    public void subscribeManufacturerAndSerialEvent(IManufacturerAndSerialReceiver ManufacturerAndSerialReceiver) {
        this.mManufacturerAndSerialReceiver = ManufacturerAndSerialReceiver;
        if (ManufacturerAndSerialReceiver != null) {
            this.subscribeToEvent(205);
        } else {
            this.unsubscribeFromEvent(205);
        }
    }

    public void subscribeVersionAndModelEvent(IVersionAndModelReceiver VersionAndModelReceiver) {
        this.mVersionAndModelReceiver = VersionAndModelReceiver;
        if (VersionAndModelReceiver != null) {
            this.subscribeToEvent(206);
        } else {
            this.unsubscribeFromEvent(206);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IVersionAndModelReceiver {
        public void onNewVersionAndModel(long var1, EnumSet<EventFlag> var3, int var4, int var5, int var6);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IManufacturerAndSerialReceiver {
        public void onNewManufacturerAndSerial(long var1, EnumSet<EventFlag> var3, int var4, int var5);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ICumulativeOperatingTimeReceiver {
        public void onNewCumulativeOperatingTime(long var1, EnumSet<EventFlag> var3, long var4);
    }

    public class IpcDefines {
        public static final int MSG_EVENT_LEGACYCOMMON_whatCUMULATIVEOPERATINGTIME = 204;
        public static final String MSG_EVENT_LEGACYCOMMON_CUMULATIVEOPERATINGTIME_PARAM_longCUMULATIVEOPERATINGTIME = "long_cumulativeOperatingTime";
        public static final int MSG_EVENT_LEGACYCOMMON_whatMANUFACTURERANDSERIAL = 205;
        public static final String MSG_EVENT_LEGACYCOMMON_MANUFACTURERANDSERIAL_PARAM_intMANUFACTURERID = "int_manufacturerID";
        public static final String MSG_EVENT_LEGACYCOMMON_MANUFACTURERANDSERIAL_PARAM_intSERIALNUMBER = "int_serialNumber";
        public static final int MSG_EVENT_LEGACYCOMMON_whatVERSIONANDMODEL = 206;
        public static final String MSG_EVENT_LEGACYCOMMON_VERSIONANDMODEL_PARAM_intHARDWAREVERSION = "int_hardwareVersion";
        public static final String MSG_EVENT_LEGACYCOMMON_VERSIONANDMODEL_PARAM_intSOFTWAREVERSION = "int_softwareVersion";
        public static final String MSG_EVENT_LEGACYCOMMON_VERSIONANDMODEL_PARAM_intMODELNUMBER = "int_modelNumber";
    }
}

