/*
 * Decompiled with CFR 0.152.
 */
package com.dsi.ant.plugins.antplus.pcc.controls;

import android.content.Context;
import android.os.Bundle;
import android.os.Message;
import com.dsi.ant.plugins.antplus.pcc.controls.defines.ControlsMode;
import com.dsi.ant.plugins.antplus.pcc.controls.defines.GenericCommandNumber;
import com.dsi.ant.plugins.antplus.pcc.controls.pccbase.AntPlusBaseRemoteControlPcc;
import com.dsi.ant.plugins.antplus.pcc.defines.EventFlag;
import com.dsi.ant.plugins.antplus.pcc.defines.RequestStatus;
import com.dsi.ant.plugins.antplus.pccbase.AntPluginPcc;
import com.dsi.ant.plugins.antplus.pccbase.PccReleaseHandle;
import com.dsi.ant.plugins.utility.log.LogAnt;
import java.util.EnumSet;
import java.util.concurrent.Semaphore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntPlusGenericRemoteControlPcc
extends AntPlusBaseRemoteControlPcc {
    private static final String TAG = AntPlusGenericRemoteControlPcc.class.getSimpleName();
    IGenericCommandFinishedReceiver mGenericCommandFinishedReceiver;
    Semaphore mCommandLock = new Semaphore(1);

    public static AntPlusBaseRemoteControlPcc.RemoteControlAsyncScanController<AntPlusGenericRemoteControlPcc> requestRemoteControlAsyncScanController(EnumSet<ControlsMode> requestModes, Context bindToContext, int searchProximityThreshold, AntPlusBaseRemoteControlPcc.IRemoteControlAsyncScanResultReceiver scanResultReceiver) {
        AntPlusGenericRemoteControlPcc potentialRetObj = new AntPlusGenericRemoteControlPcc();
        return AntPlusGenericRemoteControlPcc.requestAccessRemoteControl_Helper(requestModes, bindToContext, searchProximityThreshold, potentialRetObj, scanResultReceiver);
    }

    public static PccReleaseHandle<AntPlusGenericRemoteControlPcc> requestAccessByDeviceNumber(EnumSet<ControlsMode> requestModes, Context bindToContext, int antDeviceNumber, int searchProximityThreshold, AntPluginPcc.IPluginAccessResultReceiver<AntPlusGenericRemoteControlPcc> resultReceiver, AntPluginPcc.IDeviceStateChangeReceiver stateReceiver) {
        AntPlusGenericRemoteControlPcc potentialRetObj = new AntPlusGenericRemoteControlPcc();
        return AntPlusGenericRemoteControlPcc.requestAccessRemoteControl_Helper(requestModes, bindToContext, antDeviceNumber, searchProximityThreshold, resultReceiver, stateReceiver, potentialRetObj);
    }

    private AntPlusGenericRemoteControlPcc() {
    }

    @Override
    protected String getPluginPrintableName() {
        return "ANT+ Plugin: Generic Remote Control";
    }

    @Override
    protected void handlePluginEvent(Message eventMsg) {
        switch (eventMsg.arg1) {
            case 208: {
                if (this.mGenericCommandFinishedReceiver == null) break;
                this.mCommandLock.release();
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                RequestStatus status = RequestStatus.getValueFromInt(b.getInt("int_requestStatus"));
                this.mGenericCommandFinishedReceiver.onGenericCommandFinished(estTimestamp, eventFlags, status);
                break;
            }
            default: {
                super.handlePluginEvent(eventMsg);
            }
        }
    }

    public void RequestGenericCommand(IGenericCommandFinishedReceiver genericCommandFinishedReceiver, GenericCommandNumber commandNumber) {
        if (!this.mCommandLock.tryAcquire()) {
            LogAnt.e(TAG, "Cmd requestGenericCommand failed to start because a local command is still processing.");
            return;
        }
        this.mGenericCommandFinishedReceiver = genericCommandFinishedReceiver;
        Message cmdMsg = Message.obtain();
        cmdMsg.what = 20001;
        Bundle params = new Bundle();
        cmdMsg.setData(params);
        params.putInt("int_commandNumber", commandNumber.getIntValue());
        Message ret = this.sendPluginCommand(cmdMsg);
        if (ret == null) {
            LogAnt.e(TAG, "Cmd requestGenericCommand died in sendPluginCommand()");
            this.mCommandLock.release();
            return;
        }
        if (ret.arg1 != 0) {
            LogAnt.e(TAG, "Cmd requestGenericCommand failed with code " + ret.arg1);
            this.mCommandLock.release();
            throw new RuntimeException("requestGenericCommand cmd failed internally");
        }
        ret.recycle();
    }

    public void RequestGenericCommandSequence(byte[] rawCommandBytes) {
        if (!this.mCommandLock.tryAcquire()) {
            LogAnt.e(TAG, "Cmd RequestGenericCommandSequence failed to start because a local command is still processing.");
            return;
        }
        Message cmdMsg = Message.obtain();
        cmdMsg.what = 20002;
        Bundle params = new Bundle();
        cmdMsg.setData(params);
        params.putByteArray("arrayByte_rawCommandBytes", rawCommandBytes);
        Message ret = this.sendPluginCommand(cmdMsg);
        if (ret == null) {
            LogAnt.e(TAG, "Cmd RequestGenericCommandSequence died in sendPluginCommand()");
            this.mCommandLock.release();
            return;
        }
        if (ret.arg1 != 0) {
            LogAnt.e(TAG, "Cmd RequestGenericCommandSequence failed with code " + ret.arg1);
            this.mCommandLock.release();
            throw new RuntimeException("RequestGenericCommandSequence cmd failed internally");
        }
        ret.recycle();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IGenericCommandFinishedReceiver {
        public void onGenericCommandFinished(long var1, EnumSet<EventFlag> var3, RequestStatus var4);
    }

    public class IpcDefines {
        public static final int MSG_EVENT_REMOTECONTROL_whatGENERICCOMMANDFINISHED = 208;
        public static final String MSG_EVENT_REMOTECONTRL_GENERICCOMMANDFINISHED_PARAM_intREQUESTSTATUS = "int_requestStatus";
        public static final int MSG_CMD_REMOTECONTROL_whatGENERICCOMMAND = 20001;
        public static final int MSG_CMD_REMOTECONTROL_whatGENERICCOMMANDSEQUENCE = 20002;
        public static final String MSG_CMD_REMOTECONTROL_GENERICCOMMANDSEQUENCE_PARAM_arrayByteRAWCOMMANDBYTES = "arrayByte_rawCommandBytes";
    }
}

