/*
 * Decompiled with CFR 0.152.
 */
package com.dsi.ant.plugins.antplus.pcc;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import com.dsi.ant.plugins.antplus.common.AntFsCommon;
import com.dsi.ant.plugins.antplus.common.FitFileCommon;
import com.dsi.ant.plugins.antplus.pcc.defines.AntFsRequestStatus;
import com.dsi.ant.plugins.antplus.pcc.defines.AntFsState;
import com.dsi.ant.plugins.antplus.pccbase.AntPluginPcc;
import com.dsi.ant.plugins.antplus.pccbase.AsyncScanController;
import com.dsi.ant.plugins.antplus.pccbase.PccReleaseHandle;
import com.dsi.ant.plugins.utility.log.LogAnt;
import com.garmin.fit.BloodPressureMesg;
import com.garmin.fit.BpStatus;
import com.garmin.fit.DateTime;
import com.garmin.fit.HrType;
import java.util.GregorianCalendar;
import java.util.concurrent.Semaphore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntPlusBloodPressurePcc
extends AntPluginPcc {
    private static final String TAG = AntPlusBloodPressurePcc.class.getSimpleName();
    AntFsCommon.IAntFsProgressUpdateReceiver mAntFsProgressUpdateReceiver;
    FitFileCommon.IFitFileDownloadedReceiver mFitFileDownloadedReceiver;
    IDownloadAllHistoryFinishedReceiver mDownloadAllHistoryFinishedReceiver;
    IDownloadMeasurementsStatusReceiver mDownloadMeasurementsStatusReceiver;
    IMeasurementDownloadedReceiver mMeasurementDownloadedReceiver;
    IResetDataAndSetTimeFinishedReceiver mResetDataAndSetTimeFinishedReceiver;
    Semaphore mCommandLock = new Semaphore(1);

    @Override
    protected int getRequiredServiceVersionForBind() {
        return 10800;
    }

    public static PccReleaseHandle<AntPlusBloodPressurePcc> requestAccess(Activity userActivity, Context bindToContext, boolean skipPreferredSearch, int searchProximityThreshold, AntPluginPcc.IPluginAccessResultReceiver<AntPlusBloodPressurePcc> resultReceiver, AntPluginPcc.IDeviceStateChangeReceiver stateReceiver) {
        AntPlusBloodPressurePcc potentialRetObj = new AntPlusBloodPressurePcc();
        return AntPlusBloodPressurePcc.requestAccess_Helper_SearchActivity(userActivity, bindToContext, skipPreferredSearch, searchProximityThreshold, potentialRetObj, resultReceiver, stateReceiver);
    }

    public static PccReleaseHandle<AntPlusBloodPressurePcc> requestAccess(Activity userActivity, Context bindToContext, AntPluginPcc.IPluginAccessResultReceiver<AntPlusBloodPressurePcc> resultReceiver, AntPluginPcc.IDeviceStateChangeReceiver stateReceiver) {
        return AntPlusBloodPressurePcc.requestAccess(userActivity, bindToContext, false, -1, resultReceiver, stateReceiver);
    }

    public static PccReleaseHandle<AntPlusBloodPressurePcc> requestAccess(Context bindToContext, int antDeviceNumber, int searchProximityThreshold, AntPluginPcc.IPluginAccessResultReceiver<AntPlusBloodPressurePcc> resultReceiver, AntPluginPcc.IDeviceStateChangeReceiver stateReceiver) {
        AntPlusBloodPressurePcc potentialRetObj = new AntPlusBloodPressurePcc();
        return AntPlusBloodPressurePcc.requestAccess_Helper_AsyncSearchByDevNumber(bindToContext, antDeviceNumber, searchProximityThreshold, potentialRetObj, resultReceiver, stateReceiver);
    }

    public static AsyncScanController<AntPlusBloodPressurePcc> requestAsyncScanController(Context bindToContext, int searchProximityThreshold, AsyncScanController.IAsyncScanResultReceiver scanResultReceiver) {
        AntPlusBloodPressurePcc potentialRetObj = new AntPlusBloodPressurePcc();
        return AntPlusBloodPressurePcc.requestAccess_Helper_AsyncScanController(bindToContext, searchProximityThreshold, potentialRetObj, scanResultReceiver);
    }

    private AntPlusBloodPressurePcc() {
    }

    @Override
    protected Intent getServiceBindIntent() {
        Intent it = new Intent();
        it.setComponent(new ComponentName("com.dsi.ant.plugins.antplus", "com.dsi.ant.plugins.antplus.bloodpressure.BloodPressureService"));
        return it;
    }

    @Override
    protected String getPluginPrintableName() {
        return "ANT+ Plugin: Blood Pressure";
    }

    @Override
    protected void handlePluginEvent(Message eventMsg) {
        switch (eventMsg.arg1) {
            case 190: {
                if (this.mAntFsProgressUpdateReceiver == null) break;
                Bundle b = eventMsg.getData();
                AntFsState stateCode = AntFsState.getValueFromInt(b.getInt("int_stateCode"));
                long transferredBytes = b.getLong("long_transferredBytes");
                long totalBytes = b.getLong("long_totalBytes");
                this.mAntFsProgressUpdateReceiver.onNewAntFsProgressUpdate(stateCode, transferredBytes, totalBytes);
                break;
            }
            case 191: {
                if (this.mFitFileDownloadedReceiver == null) break;
                Bundle b = eventMsg.getData();
                byte[] fileBytes = b.getByteArray("arrayByte_rawFileBytes");
                this.mFitFileDownloadedReceiver.onNewFitFileDownloaded(new FitFileCommon.FitFile(fileBytes));
                break;
            }
            case 203: {
                if (this.mDownloadAllHistoryFinishedReceiver == null) break;
                this.mCommandLock.release();
                Bundle b = eventMsg.getData();
                AntFsRequestStatus statusCode = AntFsRequestStatus.getValueFromInt(b.getInt("int_statusCode"));
                this.mDownloadAllHistoryFinishedReceiver.onDownloadAllHistoryFinished(statusCode);
                break;
            }
            case 204: {
                if (this.mDownloadMeasurementsStatusReceiver == null) break;
                Bundle b = eventMsg.getData();
                DownloadMeasurementsStatusCode statusCode = DownloadMeasurementsStatusCode.getValueFromInt(b.getInt("int_statusCode"));
                AntFsRequestStatus finishedCode = AntFsRequestStatus.getValueFromInt(b.getInt("int_finishedCode"));
                if (statusCode == DownloadMeasurementsStatusCode.FINISHED) {
                    this.mCommandLock.release();
                }
                this.mDownloadMeasurementsStatusReceiver.onDownloadMeasurementsStatus(statusCode, finishedCode);
                break;
            }
            case 205: {
                if (this.mMeasurementDownloadedReceiver == null) break;
                Bundle b = eventMsg.getData();
                b.setClassLoader(this.getClass().getClassLoader());
                BloodPressureMeasurement measurement = (BloodPressureMeasurement)b.getParcelable("parcelable_measurement");
                this.mMeasurementDownloadedReceiver.onMeasurementDownloaded(measurement);
                break;
            }
            case 206: {
                if (this.mResetDataAndSetTimeFinishedReceiver == null) break;
                Bundle b = eventMsg.getData();
                AntFsRequestStatus statusCode = AntFsRequestStatus.getValueFromInt(b.getInt("int_statusCode"));
                this.mCommandLock.release();
                this.mResetDataAndSetTimeFinishedReceiver.onNewResetDataAndSetTimeFinished(statusCode);
                break;
            }
            default: {
                LogAnt.d(TAG, "Unrecognized event received: " + eventMsg.arg1);
            }
        }
    }

    public int getAntFsManufacturerID() {
        Message cmdMsg = Message.obtain();
        cmdMsg.what = 20002;
        Message ret = this.sendPluginCommand(cmdMsg);
        if (ret == null) {
            LogAnt.e(TAG, "Cmd requestAntFsMfgId died in sendPluginCommand()");
            return -1;
        }
        if (ret.arg1 != 0) {
            LogAnt.e(TAG, "Cmd requestAntFsMsgId failed with code " + ret.arg1);
            throw new RuntimeException("requestAntFsMsgId cmd failed internally");
        }
        int mfgID = ret.arg2;
        ret.recycle();
        return mfgID;
    }

    public boolean requestDownloadMeasurements(boolean downloadNewOnly, boolean monitorForNewMeasurements, IDownloadMeasurementsStatusReceiver downloadMeasurementStatusReceiver, IMeasurementDownloadedReceiver measurementDownloadedReceiver, AntFsCommon.IAntFsProgressUpdateReceiver antFsProgressUpdateRecevier) {
        if (this.reportedServiceVersion < 20202) {
            LogAnt.w(TAG, "requestDownloadMeasurements requires ANT+ Plugins Service >20202, installed: " + this.reportedServiceVersion);
            downloadMeasurementStatusReceiver.onDownloadMeasurementsStatus(DownloadMeasurementsStatusCode.FINISHED, AntFsRequestStatus.FAIL_PLUGINS_SERVICE_VERSION);
            return false;
        }
        if (!this.mCommandLock.tryAcquire()) {
            return false;
        }
        this.mAntFsProgressUpdateReceiver = antFsProgressUpdateRecevier;
        this.mDownloadMeasurementsStatusReceiver = downloadMeasurementStatusReceiver;
        this.mMeasurementDownloadedReceiver = measurementDownloadedReceiver;
        Message cmdMsg = Message.obtain();
        cmdMsg.what = 20003;
        Bundle params = new Bundle();
        cmdMsg.setData(params);
        params.putBoolean("bool_downloadNewOnly", downloadNewOnly);
        params.putBoolean("bool_monitorForNewMeasurements", monitorForNewMeasurements);
        params.putBoolean("bool_UseAntFsProgressUpdates", antFsProgressUpdateRecevier != null);
        Message ret = this.sendPluginCommand(cmdMsg);
        if (ret == null) {
            LogAnt.e(TAG, "Cmd requestDownloadMeasurements died in sendPluginCommand()");
            this.mCommandLock.release();
            return false;
        }
        if (ret.arg1 != 0) {
            LogAnt.e(TAG, "Cmd requestDownloadMeasurements failed with code " + ret.arg1);
            this.mCommandLock.release();
            throw new RuntimeException("requestAllHistory cmd failed internally");
        }
        ret.recycle();
        return true;
    }

    public boolean cancelDownloadMeasurementsMonitor() {
        if (this.reportedServiceVersion < 20202) {
            LogAnt.w(TAG, "cancelDownloadMeasurementsMonitor requires ANT+ Plugins Service >20202, installed: " + this.reportedServiceVersion);
            return false;
        }
        Message cmdMsg = Message.obtain();
        cmdMsg.what = 20004;
        Message ret = this.sendPluginCommand(cmdMsg);
        if (ret == null) {
            LogAnt.e(TAG, "Cmd requestAntFsMfgId died in sendPluginCommand()");
            return true;
        }
        if (ret.arg1 != 0) {
            LogAnt.e(TAG, "Cmd requestAntFsMsgId failed with code " + ret.arg1);
            return false;
        }
        ret.recycle();
        return true;
    }

    public boolean requestResetDataAndSetTime(boolean doSetTime, IResetDataAndSetTimeFinishedReceiver resetDataAndSetTimeFinishedReceiver, AntFsCommon.IAntFsProgressUpdateReceiver antFsProgressUpdateRecevier) {
        if (this.reportedServiceVersion < 20205) {
            LogAnt.w(TAG, "requestResetDataAndSetTime requires ANT+ Plugins Service >20205, installed: " + this.reportedServiceVersion);
            resetDataAndSetTimeFinishedReceiver.onNewResetDataAndSetTimeFinished(AntFsRequestStatus.FAIL_PLUGINS_SERVICE_VERSION);
            return false;
        }
        if (!this.mCommandLock.tryAcquire()) {
            return false;
        }
        this.mResetDataAndSetTimeFinishedReceiver = resetDataAndSetTimeFinishedReceiver;
        this.mAntFsProgressUpdateReceiver = antFsProgressUpdateRecevier;
        Message cmdMsg = Message.obtain();
        cmdMsg.what = 20005;
        Bundle params = new Bundle();
        cmdMsg.setData(params);
        params.putBoolean("bool_doSetTime", doSetTime);
        params.putBoolean("bool_UseAntFsProgressUpdates", antFsProgressUpdateRecevier != null);
        Message ret = this.sendPluginCommand(cmdMsg);
        if (ret == null) {
            LogAnt.e(TAG, "Cmd requestResetDataAndSetTime died in sendPluginCommand()");
            this.mCommandLock.release();
            return false;
        }
        if (ret.arg1 != 0) {
            LogAnt.e(TAG, "Cmd requestDataAndSetTime failed with code " + ret.arg1);
            this.mCommandLock.release();
            throw new RuntimeException("requestDataAndSetTime cmd failed internally");
        }
        ret.recycle();
        return true;
    }

    public static interface IResetDataAndSetTimeFinishedReceiver {
        public void onNewResetDataAndSetTimeFinished(AntFsRequestStatus var1);
    }

    public static interface IMeasurementDownloadedReceiver {
        public void onMeasurementDownloaded(BloodPressureMeasurement var1);
    }

    public static interface IDownloadMeasurementsStatusReceiver {
        public void onDownloadMeasurementsStatus(DownloadMeasurementsStatusCode var1, AntFsRequestStatus var2);
    }

    public static interface IDownloadAllHistoryFinishedReceiver {
        public void onDownloadAllHistoryFinished(AntFsRequestStatus var1);
    }

    public static class BloodPressureMeasurement
    implements Parcelable {
        public static final String KEY_DEFAULT_ADVANCEDMEASUREMENTKEY = "parcelable_bloodPressureMeasurement";
        private final int ipcVersionNumber;
        public GregorianCalendar timestamp_UTC;
        public Integer systolicPressure;
        public Integer diastolicPressure;
        public Integer meanArterialPressure;
        public Integer map3SampleMean;
        public Integer mapMorningValues;
        public Integer mapEveningValues;
        public Integer heartRate;
        public HrType heartRateType;
        public BpStatus bloodPressureStatus;
        public Integer userProfileIndex;
        public static final Parcelable.Creator<BloodPressureMeasurement> CREATOR = new Parcelable.Creator<BloodPressureMeasurement>(){

            public BloodPressureMeasurement createFromParcel(Parcel source) {
                return new BloodPressureMeasurement(source);
            }

            public BloodPressureMeasurement[] newArray(int size) {
                return new BloodPressureMeasurement[size];
            }
        };

        public BloodPressureMeasurement() {
            this.ipcVersionNumber = 1;
        }

        public BloodPressureMeasurement(BloodPressureMesg fitMesg) {
            this.ipcVersionNumber = 1;
            DateTime tempTimeStamp = fitMesg.getTimestamp();
            if (tempTimeStamp == null) {
                this.timestamp_UTC = null;
            } else {
                this.timestamp_UTC = new GregorianCalendar();
                this.timestamp_UTC.setTime(fitMesg.getTimestamp().getDate());
            }
            this.systolicPressure = fitMesg.getSystolicPressure();
            this.diastolicPressure = fitMesg.getDiastolicPressure();
            this.meanArterialPressure = fitMesg.getMeanArterialPressure();
            this.map3SampleMean = fitMesg.getMap3SampleMean();
            this.mapMorningValues = fitMesg.getMapMorningValues();
            this.mapEveningValues = fitMesg.getMapEveningValues();
            Short tempHeartRate = fitMesg.getHeartRate();
            this.heartRate = tempHeartRate == null ? null : Integer.valueOf(tempHeartRate.intValue());
            this.heartRateType = fitMesg.getHeartRateType();
            this.bloodPressureStatus = fitMesg.getStatus();
            this.userProfileIndex = fitMesg.getUserProfileIndex();
        }

        public BloodPressureMesg asBloodPressureFitMesg() {
            BloodPressureMesg retMesg = new BloodPressureMesg();
            if (this.timestamp_UTC != null) {
                retMesg.setTimestamp(new DateTime(this.timestamp_UTC.getTime()));
            }
            if (this.systolicPressure != null) {
                retMesg.setSystolicPressure(this.systolicPressure);
            }
            if (this.diastolicPressure != null) {
                retMesg.setDiastolicPressure(this.diastolicPressure);
            }
            if (this.meanArterialPressure != null) {
                retMesg.setMeanArterialPressure(this.meanArterialPressure);
            }
            if (this.map3SampleMean != null) {
                retMesg.setMap3SampleMean(this.map3SampleMean);
            }
            if (this.mapMorningValues != null) {
                retMesg.setMapMorningValues(this.mapMorningValues);
            }
            if (this.mapEveningValues != null) {
                retMesg.setMapEveningValues(this.mapEveningValues);
            }
            if (this.heartRate != null) {
                retMesg.setHeartRate(Short.valueOf(this.heartRate.shortValue()));
            }
            if (this.heartRateType != null) {
                retMesg.setHeartRateType(this.heartRateType);
            }
            if (this.bloodPressureStatus != null) {
                retMesg.setStatus(this.bloodPressureStatus);
            }
            if (this.userProfileIndex != null) {
                retMesg.setUserProfileIndex(this.userProfileIndex);
            }
            return retMesg;
        }

        public BloodPressureMeasurement(Parcel in) {
            this.ipcVersionNumber = 1;
            int incomingVersion = in.readInt();
            if (incomingVersion != 1) {
                LogAnt.i(TAG, "Decoding version " + incomingVersion + " AdvancedMeasurement parcel with version 1 parser.");
            }
            this.timestamp_UTC = (GregorianCalendar)in.readValue(null);
            this.systolicPressure = (Integer)in.readValue(null);
            this.diastolicPressure = (Integer)in.readValue(null);
            this.meanArterialPressure = (Integer)in.readValue(null);
            this.map3SampleMean = (Integer)in.readValue(null);
            this.mapMorningValues = (Integer)in.readValue(null);
            this.mapEveningValues = (Integer)in.readValue(null);
            this.heartRate = (Integer)in.readValue(null);
            int temp = in.readInt();
            this.heartRateType = temp == Integer.MIN_VALUE ? null : HrType.values()[temp];
            temp = in.readInt();
            this.bloodPressureStatus = temp == Integer.MIN_VALUE ? null : BpStatus.values()[temp];
            this.userProfileIndex = (Integer)in.readValue(null);
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.ipcVersionNumber);
            dest.writeValue((Object)this.timestamp_UTC);
            dest.writeValue((Object)this.systolicPressure);
            dest.writeValue((Object)this.diastolicPressure);
            dest.writeValue((Object)this.meanArterialPressure);
            dest.writeValue((Object)this.map3SampleMean);
            dest.writeValue((Object)this.mapMorningValues);
            dest.writeValue((Object)this.mapEveningValues);
            dest.writeValue((Object)this.heartRate);
            dest.writeInt(this.heartRateType == null ? Integer.MIN_VALUE : this.heartRateType.ordinal());
            dest.writeInt(this.bloodPressureStatus == null ? Integer.MIN_VALUE : this.bloodPressureStatus.ordinal());
            dest.writeValue((Object)this.userProfileIndex);
        }

        public int describeContents() {
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DownloadMeasurementsStatusCode {
        FINISHED(100),
        PROGRESS_SYNCING_WITH_DEVICE(1000),
        PROGRESS_MONITORING(1500),
        UNRECOGNIZED(-1);

        private int intValue;

        private DownloadMeasurementsStatusCode(int intValue) {
            this.intValue = intValue;
        }

        public int getIntValue() {
            return this.intValue;
        }

        public static DownloadMeasurementsStatusCode getValueFromInt(int intValue) {
            for (DownloadMeasurementsStatusCode status : DownloadMeasurementsStatusCode.values()) {
                if (status.getIntValue() != intValue) continue;
                return status;
            }
            DownloadMeasurementsStatusCode unrecognized = UNRECOGNIZED;
            unrecognized.intValue = intValue;
            return unrecognized;
        }
    }

    public class IpcDefines {
        public static final String PATH_ANTPLUS_BLOODPRESSUREPLUGIN_PKG = "com.dsi.ant.plugins.antplus";
        public static final String PATH_ANTPLUS_BLOODPRESSUREPLUGIN_SERVICE = "com.dsi.ant.plugins.antplus.bloodpressure.BloodPressureService";
        public static final int MSG_EVENT_BLOODPRESSURE_whatDOWNLOADALLHISTORYFINISHED = 203;
        public static final String MSG_EVENT_BLOODPRESSURE_DOWNLOADALLHISTORYFINISHED_PARAM_intSTATUSCODE = "int_statusCode";
        public static final int MSG_EVENT_BLOODPRESSURE_whatDOWNLOADMEASUREMENTSSTATUS = 204;
        public static final String MSG_EVENT_BLOODPRESSURE_DOWNLOADMEASUREMENTSSTATUS_PARAM_intSTATUSCODE = "int_statusCode";
        public static final String MSG_EVENT_BLOODPRESSURE_DOWNLOADMEASUREMENTSSTATUS_PARAM_intFINISHEDCODE = "int_finishedCode";
        public static final int MSG_EVENT_BLOODPRESSURE_whatMEASUREMENTDOWNLOADED = 205;
        public static final String MSG_EVENT_BLOODPRESSURE_MEASUREMENTDOWNLOADED_PARAM_parcelableMEASUREMENT = "parcelable_measurement";
        public static final int MSG_EVENT_BLOODPRESSURE_whatRESETDATAANDSETTIMEFINISHED = 206;
        public static final String MSG_EVENT_BLOODPRESSURE_RESETDATAANDSETTIMEFINISHED_PARAM_intSTATUSCODE = "int_statusCode";
        public static final int MSG_CMD_BLOODPRESSURE_whatREQUESTDOWNLOADALLHISTORY = 20001;
        public static final int MSG_CMD_BLOODPRESSURE_whatREQUESTANTFSMFGID = 20002;
        public static final int MSG_CMD_BLOODPRESSURE_whatREQUESTDOWNLOADMEASUREMENTS = 20003;
        public static final String MSG_CMD_BLOODPRESSURE_REQUESTDOWNLOADMEASUREMENTS_PARAM_boolDOWNLOADNEWONLY = "bool_downloadNewOnly";
        public static final String MSG_CMD_BLOODPRESSURE_REQUESTDOWNLOADMEASUREMENTS_PARAM_boolMONITORFORNEWMEASUREMENTS = "bool_monitorForNewMeasurements";
        public static final int MSG_CMD_BLOODPRESSURE_whatCANCELDOWNLOADMEASUREMENTSMONITOR = 20004;
        public static final int MSG_CMD_BLOODPRESSURE_whatREQUESTRESETDATAANDSETTIME = 20005;
        public static final String MSG_CMD_BLOODPRESSURE_REQUESTRESETDATAANDSETTIME_PARAM_boolDOSETTIME = "bool_doSetTime";
    }
}

