/*
 * Decompiled with CFR 0.152.
 */
package com.dsi.ant.plugins.antplus.pcc;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Message;
import com.dsi.ant.plugins.antplus.pcc.defines.EventFlag;
import com.dsi.ant.plugins.antplus.pccbase.AntPluginPcc;
import com.dsi.ant.plugins.antplus.pccbase.AntPlusBikeSpdCadCommonPcc;
import com.dsi.ant.plugins.antplus.pccbase.PccReleaseHandle;
import com.dsi.ant.plugins.utility.log.LogAnt;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.EnumSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntPlusBikeSpeedDistancePcc
extends AntPlusBikeSpdCadCommonPcc {
    private static final String TAG = AntPlusBikeSpeedDistancePcc.class.getSimpleName();
    CalculatedSpeedReceiver mCalculatedSpeedReceiver;
    CalculatedAccumulatedDistanceReceiver mCalculatedAccumulatedDistanceReceiver;
    IRawSpeedAndDistanceDataReceiver mRawSpeedAndDistanceDataReceiver;
    IMotionAndSpeedDataReceiver mMotionAndSpeedDataReceiver;

    public static PccReleaseHandle<AntPlusBikeSpeedDistancePcc> requestAccess(Activity userActivity, Context bindToContext, boolean skipPreferredSearch, int searchProximityThreshold, AntPluginPcc.IPluginAccessResultReceiver<AntPlusBikeSpeedDistancePcc> resultReceiver, AntPluginPcc.IDeviceStateChangeReceiver stateReceiver) {
        AntPlusBikeSpeedDistancePcc potentialRetObj = new AntPlusBikeSpeedDistancePcc();
        return AntPlusBikeSpeedDistancePcc.requestAccessBSC_helper(false, userActivity, bindToContext, skipPreferredSearch, searchProximityThreshold, resultReceiver, stateReceiver, potentialRetObj);
    }

    public static PccReleaseHandle<AntPlusBikeSpeedDistancePcc> requestAccess(Activity userActivity, Context bindToContext, AntPluginPcc.IPluginAccessResultReceiver<AntPlusBikeSpeedDistancePcc> resultReceiver, AntPluginPcc.IDeviceStateChangeReceiver stateReceiver) {
        return AntPlusBikeSpeedDistancePcc.requestAccess(userActivity, bindToContext, false, -1, resultReceiver, stateReceiver);
    }

    public static PccReleaseHandle<AntPlusBikeSpeedDistancePcc> requestAccess(Context bindToContext, int antDeviceNumber, int searchProximityThreshold, boolean isSpdCadCombinedSensor, AntPluginPcc.IPluginAccessResultReceiver<AntPlusBikeSpeedDistancePcc> resultReceiver, AntPluginPcc.IDeviceStateChangeReceiver stateReceiver) {
        AntPlusBikeSpeedDistancePcc potentialRetObj = new AntPlusBikeSpeedDistancePcc();
        return AntPlusBikeSpeedDistancePcc.requestAccessBSC_helper(false, bindToContext, antDeviceNumber, searchProximityThreshold, isSpdCadCombinedSensor, resultReceiver, stateReceiver, potentialRetObj);
    }

    public static AntPlusBikeSpdCadCommonPcc.BikeSpdCadAsyncScanController<AntPlusBikeSpeedDistancePcc> requestAsyncScanController(Context bindToContext, int searchProximityThreshold, AntPlusBikeSpdCadCommonPcc.IBikeSpdCadAsyncScanResultReceiver scanResultReceiver) {
        AntPlusBikeSpeedDistancePcc potentialRetObj = new AntPlusBikeSpeedDistancePcc();
        return AntPlusBikeSpeedDistancePcc.requestAccessBSC_Helper_AsyncScanController(false, bindToContext, searchProximityThreshold, potentialRetObj, scanResultReceiver);
    }

    private AntPlusBikeSpeedDistancePcc() {
        super(false);
    }

    @Override
    protected Intent getServiceBindIntent() {
        Intent it = new Intent();
        it.setComponent(new ComponentName("com.dsi.ant.plugins.antplus", "com.dsi.ant.plugins.antplus.bikespdcad.CombinedBikeSpdCadService"));
        return it;
    }

    @Override
    protected String getPluginPrintableName() {
        return "ANT+ Plugin: Bike Speed Distance";
    }

    @Override
    protected void handlePluginEvent(Message eventMsg) {
        switch (eventMsg.arg1) {
            case 201: {
                if (this.mCalculatedSpeedReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                BigDecimal calculatedSpeed = (BigDecimal)b.getSerializable("decimal_calculatedSpeed");
                this.mCalculatedSpeedReceiver.onNewCalculatedSpeedRaw(estTimestamp, eventFlags, calculatedSpeed);
                break;
            }
            case 202: {
                if (this.mCalculatedAccumulatedDistanceReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                BigDecimal calculatedAccumulatedDistance = (BigDecimal)b.getSerializable("decimal_calculatedAccumulatedDistance");
                this.mCalculatedAccumulatedDistanceReceiver.onNewCalculatedAccumulatedDistanceRaw(estTimestamp, eventFlags, calculatedAccumulatedDistance);
                break;
            }
            case 203: {
                if (this.mRawSpeedAndDistanceDataReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                BigDecimal timestampOfLastEvent = (BigDecimal)b.getSerializable("decimal_timestampOfLastEvent");
                long cumulativeRevolutions = b.getLong("long_cumulativeRevolutions");
                this.mRawSpeedAndDistanceDataReceiver.onNewRawSpeedAndDistanceData(estTimestamp, eventFlags, timestampOfLastEvent, cumulativeRevolutions);
                break;
            }
            case 303: {
                if (this.mMotionAndSpeedDataReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                boolean isStopped = b.getBoolean("bool_isStopped");
                this.mMotionAndSpeedDataReceiver.onNewMotionAndSpeedData(estTimestamp, eventFlags, isStopped);
            }
            default: {
                super.handlePluginEvent(eventMsg);
            }
        }
    }

    public void subscribeCalculatedSpeedEvent(CalculatedSpeedReceiver CalculatedSpeedReceiver2) {
        this.mCalculatedSpeedReceiver = CalculatedSpeedReceiver2;
        if (CalculatedSpeedReceiver2 != null) {
            this.subscribeToEvent(201);
        } else {
            this.unsubscribeFromEvent(201);
        }
    }

    public void subscribeCalculatedAccumulatedDistanceEvent(CalculatedAccumulatedDistanceReceiver CalculatedAccumulatedDistanceReceiver2) {
        this.mCalculatedAccumulatedDistanceReceiver = CalculatedAccumulatedDistanceReceiver2;
        if (CalculatedAccumulatedDistanceReceiver2 != null) {
            this.subscribeToEvent(202);
        } else {
            this.unsubscribeFromEvent(202);
        }
    }

    public void subscribeRawSpeedAndDistanceDataEvent(IRawSpeedAndDistanceDataReceiver RawSpeedAndDistanceDataReceiver) {
        this.mRawSpeedAndDistanceDataReceiver = RawSpeedAndDistanceDataReceiver;
        if (RawSpeedAndDistanceDataReceiver != null) {
            this.subscribeToEvent(203);
        } else {
            this.unsubscribeFromEvent(203);
        }
    }

    public boolean subscribeMotionAndSpeedDataEvent(IMotionAndSpeedDataReceiver motionAndSpeedDataReceiver) {
        if (this.reportedServiceVersion < 20208) {
            LogAnt.w(TAG, "subscribeMotionAndSpeedDataEvent requires ANT+ Plugins Service >20208, installed: " + this.reportedServiceVersion);
            return false;
        }
        this.mMotionAndSpeedDataReceiver = motionAndSpeedDataReceiver;
        if (motionAndSpeedDataReceiver != null) {
            return this.subscribeToEvent(303);
        }
        this.unsubscribeFromEvent(303);
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IMotionAndSpeedDataReceiver {
        public void onNewMotionAndSpeedData(long var1, EnumSet<EventFlag> var3, boolean var4);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IRawSpeedAndDistanceDataReceiver {
        public void onNewRawSpeedAndDistanceData(long var1, EnumSet<EventFlag> var3, BigDecimal var4, long var5);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class CalculatedAccumulatedDistanceReceiver {
        BigDecimal wheelCircumference;
        BigDecimal initialDistanceZeroVal = null;

        public CalculatedAccumulatedDistanceReceiver(BigDecimal wheelCircumference) {
            this.wheelCircumference = wheelCircumference;
        }

        public abstract void onNewCalculatedAccumulatedDistance(long var1, EnumSet<EventFlag> var3, BigDecimal var4);

        private void onNewCalculatedAccumulatedDistanceRaw(long estTimestamp, EnumSet<EventFlag> eventFlags, BigDecimal calculatedAccumulatedDistanceRaw) {
            if (this.initialDistanceZeroVal == null) {
                this.initialDistanceZeroVal = calculatedAccumulatedDistanceRaw.multiply(this.wheelCircumference).setScale(10, RoundingMode.HALF_UP);
            }
            this.onNewCalculatedAccumulatedDistance(estTimestamp, eventFlags, calculatedAccumulatedDistanceRaw.multiply(this.wheelCircumference).setScale(10, RoundingMode.HALF_UP).subtract(this.initialDistanceZeroVal));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class CalculatedSpeedReceiver {
        BigDecimal wheelCircumference;

        public CalculatedSpeedReceiver(BigDecimal wheelCircumference) {
            this.wheelCircumference = wheelCircumference;
        }

        public abstract void onNewCalculatedSpeed(long var1, EnumSet<EventFlag> var3, BigDecimal var4);

        private void onNewCalculatedSpeedRaw(long estTimestamp, EnumSet<EventFlag> eventFlags, BigDecimal calculatedSpeedRaw) {
            this.onNewCalculatedSpeed(estTimestamp, eventFlags, calculatedSpeedRaw.multiply(this.wheelCircumference).setScale(10, RoundingMode.HALF_UP));
        }
    }

    public class IpcDefines {
        public static final int MSG_EVENT_BIKESPEEDDISTANCE_whatCALCULATEDSPEED = 201;
        public static final String MSG_EVENT_BIKESPEEDDISTANCE_CALCULATEDSPEED_PARAM_decimalCALCULATEDSPEED = "decimal_calculatedSpeed";
        public static final int MSG_EVENT_BIKESPEEDDISTANCE_whatCALCULATEDACCUMULATEDDISTANCE = 202;
        public static final String MSG_EVENT_BIKESPEEDDISTANCE_CALCULATEDACCUMULATEDDISTANCE_PARAM_decimalCALCULATEDACCUMULATEDDISTANCE = "decimal_calculatedAccumulatedDistance";
        public static final int MSG_EVENT_BIKESPEEDDISTANCE_whatRAWSPEEDANDDISTANCEDATA = 203;
        public static final String MSG_EVENT_BIKESPEEDDISTANCE_RAWSPEEDANDDISTANCEDATA_PARAM_decimalTIMESTAMPOFLASTEVENT = "decimal_timestampOfLastEvent";
        public static final String MSG_EVENT_BIKESPEEDDISTANCE_RAWSPEEDANDDISTANCEDATA_PARAM_longCUMULATIVEREVOLUTIONS = "long_cumulativeRevolutions";
        public static final int MSG_EVENT_BIKESPEEDDISTANCE_whatMOTIONANDSPEEDDATA = 303;
        public static final String MSG_EVENT_BIKESPEEDDISTANCE_MOTIONANDSPEEDDATA_PARAM_boolISSTOPPED = "bool_isStopped";
    }
}

