#! /bin/sh
#
#		Written by Miquel van Smoorenburg <miquels@cistron.nl>.
#		Modified for Debian GNU/Linux
#		by Ian Murdock <imurdock@gnu.ai.mit.edu>.
#		Enhanced by Kilian Krause <kk@verfaction.de> for pkg-voip.

### BEGIN INIT INFO
# Provides:          gnugk
# Required-Start:    $syslog $remote_fs
# Required-Stop:     $syslog $remote_fs
# Should-Start:      $local_fs $network $named
# Should-Stop:       $local_fs $network $named
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# Short-Description: Start GnuGK
# Description:       Run the Gnu Gatekeeper daemon
### END INIT INFO

PATH=/sbin:/bin:/usr/sbin:/usr/bin
DAEMON=/usr/sbin/gnugk
CONFIG=/etc/gatekeeper.ini
NAME=gnugk
DESC='H.323 gatekeeper'
ARGS="--config $CONFIG --output /var/log/gnugk/gnugk.log --pid /var/run/gnugk/gnugk.pid"

test -x $DAEMON -a -f $CONFIG|| exit 0
# we need to be able to run the daemon, eh ;)

[ -f /etc/default/gnugk ]&&. /etc/default/gnugk
if [ "$START_ON_BOOT" != "yes" ]; then
	echo "$NAME : disabled in /etc/default/gnugk."
	exit 0
fi
if [ -n "$PARAMS" ]; then
	ARGS=" $PARAMS $ARGS "
fi

set -e

case "$1" in
  start)
	echo -n "Starting $DESC: "
	start-stop-daemon --start --quiet \
		--chuid $NAME --pidfile /var/run/$NAME/$NAME.pid \
		--background --exec $DAEMON -- $ARGS
	echo "$NAME."
	;;
  stop)
	echo -n "Stopping $DESC: "
		start-stop-daemon --stop --quiet \
		--pidfile /var/run/$NAME/$NAME.pid \
		--exec $DAEMON --oknodo
	echo "$NAME."
	;;
  reload)
	echo "Reloading $DESC configuration files."
	start-stop-daemon --stop --signal 1 --quiet --pidfile \
		/var/run/$NAME/$NAME.pid --exec $DAEMON
  ;;
  restart|force-reload)
	#
	#	If the "reload" option is implemented, move the "force-reload"
	#	option to the "reload" entry above. If not, "force-reload" is
	#	just the same as "restart".
	#
	$0 stop && $0 start
	;;
  *)
	N=/etc/init.d/$NAME
	# echo "Usage: $N {start|stop|restart|reload|force-reload}" >&2
	echo "Usage: $N {start|stop|restart|force-reload}" >&2
	exit 1
	;;
esac

exit 0
