from Observable import Observable
from ListBox import ListBox
import values

import gtk
import gobject

import os



#
# Class for a browser for skins.
#
class SkinBrowser(gtk.Dialog, Observable):

    OBS_SET_SKIN = 0



    #
    # Constructor.
    #
    def __init__(self):

        # the list of available skins
        self.__skins = []


        # widgets and layout
        gtk.Dialog.__init__(self)
        import icon; self.set_icon(icon.ICON)
        self.set_title(_("Skin Browser"))
        self.set_default_size(320, 320)
        self.connect("delete-event", self.__on_close)

        # list of skins
        self.__list = ListBox([_("Name of Skin")])
        self.__list.set_headers_visible(gtk.TRUE)
        self.__list.connect_select_row(self.__on_select)
        self.__list.show()
        self.vbox.pack_start(self.__list, gtk.TRUE, gtk.TRUE, 0)
        
        #scrwin = gtk.ScrolledWindow()
        #scrwin.set_shadow_type(gtk.SHADOW_ETCHED_IN)
        #scrwin.set_policy(gtk.POLICY_NEVER,
        #                  gtk.POLICY_AUTOMATIC)
        #scrwin.show()
        #self.vbox.pack_start(scrwin, gtk.TRUE, gtk.TRUE, 0)

        #self.__liststore = gtk.ListStore(gobject.TYPE_STRING)
        #self.__list = gtk.TreeView(self.__liststore)
        #self.__list.append_column(gtk.TreeViewColumn(_("Name of Skin"),
        #                                             gtk.CellRendererText(),
        #                                             text=0))
        #self.__list.show()

        #self.__list.connect("button-release-event", self.__on_select)
        #self.__list.connect("key-release-event", self.__on_select)
        #scrwin.add(self.__list)


        # drag and drop tip label
        hbox = gtk.HBox()
        hbox.show()

        img = gtk.Image()
        img.set_from_stock(gtk.STOCK_DIALOG_INFO, gtk.ICON_SIZE_DIALOG)
        img.show()
        hbox.pack_start(img, gtk.FALSE, gtk.FALSE, 4)

        lbl = gtk.Label(_("New skins can be installed by dragging\n"
                          "them into this window."))
        lbl.show()
        hbox.pack_start(lbl, gtk.FALSE, gtk.FALSE, 4)
        
        self.vbox.pack_end(hbox, gtk.FALSE, gtk.FALSE, 8)


        # close button
        btn = self.add_button(gtk.STOCK_CLOSE, 0)
        btn.connect("clicked", self.__on_close)


        self.__display_skins()


        self.drag_dest_set(gtk.DEST_DEFAULT_ALL,
                           [("text/uri-list", 0, -1)],
                           gtk.gdk.ACTION_COPY | gtk.gdk.ACTION_MOVE)

        self.connect("drag-data-received", self.__on_drop)



    #
    # Reacts on dropping items.
    #
    def __on_drop(self, src, context, x, y, data, info, time):

        files = data.data.splitlines()
        for f in files:
            protocol, filename = f[:f.index(":")], f[f.index(":") + 1:]
            # cut off null byte if there is one
            if (filename[-1] == chr(0)): filename = filename[:-1]
            # only allow local files
            if (protocol == "file"):
                self.__install_skin_from_file(filename)
            #end if
        #end for
        self.__display_skins()



    #
    # Displays the available skins in the list view.
    #
    def __display_skins(self):

        self.__list.clear()
        self.__skins = []
        skins = self.__get_installed_skins()
        skins.sort()
        
        for skin in skins:
            self.__skins.append(skin)
            name = skin.replace("_", " ")
            self.__list.append(name)
        #end for




    #
    # Reacts on selecting a skin.
    #
    def __on_select(self, src, index):

        skin = self.__skins[index]
        self.update_observer(self.OBS_SET_SKIN, skin)



    #
    # Reacts on closing the window.
    #
    def __on_close(self, *args):

        self.hide()
        return gtk.TRUE




    #
    # Finds and returns the names of all installed skins.
    #
    def __get_installed_skins(self):

        home = os.environ[values.DESKCALHOME]
        userhome = os.environ[values.DESKCALUSERHOME]
        skinhome = os.environ.get(values.SKINPATH, home)
        
        skins = {}
        for path in [os.path.join(skinhome, values.SKINDIR),
                     os.path.join(userhome, values.SKINDIR)]:
            dirs = os.listdir(path)

            for d in dirs:
                if (os.path.exists(os.path.join(path, d, values.SKINFILE))):
                    skins[d] = 1
            #end for
            
        #end for
        
        return skins.keys()



    #
    # Installs the given skin archive.
    #
    def __install_skin_from_file(self, filename):

        userhome = os.environ[values.DESKCALUSERHOME]
        skinpath = os.path.join(userhome, values.SKINDIR)

        os.system("cd \"%(skinpath)s\" 2>/dev/null && "
                  "gzip -d -c \"%(filename)s\" 2>/dev/null| "
                  "tar -x 2>/dev/null" % vars())

        


    #
    # Shows the window.
    #
    def show(self):

        self.__display_skins()
        gtk.Dialog.show(self)
        



    #
    # Marks the given skin as selected.
    #
    def set_current_skin(self, skin):

        try:
            index = self.__skins.index(skin)
            self.__list.set_cursor(index)
        except:
            pass
