/* PROGRAM:     eggsh
 * FILE:        $Header: /home/egg/src/RCS/ipproto.c,v 1.1 1998/07/21 11:37:21 ghn Exp $
 * PURPOSE:     Declarations/definitions of IP data protocols for Egg
 * AUTHOR:      Greg Nelson
 * DATE:        98-04-12
 *
 * REVISED:     $Log: ipproto.c,v $
 * REVISED:     Revision 1.1  1998/07/21 11:37:21  ghn
 * REVISED:     Initial revision
 * REVISED:
 * Copyright 1998 - Greg Nelson
 * Redistributable under the terms of the GNU Public Licence (GPL)
 */

#include <string.h>
#include "global.h"
#include "crc16.h"

int32 PackPacket(char *buf, uint32 bufsize, EggCarton *cart) {
  int32 rec, ntrl, llen;
  uint16 crc;

  if (bufsize < sizeof(EggHeader)) return -1;

  memcpy(buf, &(cart->hdr), sizeof(EggHeader));
  buf += sizeof(EggHeader);

  ntrl = card->hdr.reclen;
  llen = sizeof(uint32) + ntrl * sizeof(trial);

  for (rec = 0; rec < cart->hdr.numrec; rec++) {
    memcpy(buf, &(card->records[rec].timestamp), sizeof(uint32));
    memcpy(buf + sizeof(uint32),
	   &(card->records[rec].trials), ntrl * sizeof(trial));
    crc = BlockCRC16((byte *)buf, llen);
    memcpy(buf + llen, &crc, sizeof(uint16));
    buf += llen + sizeof(uint16);
  }
}
