/* PROGRAM:     eggsh
 * FILE:        $Header: /home/ghn/projects/PEAR/egg/eggsh/RCS/hwapi.h,v 1.1 1998/07/21 11:37:32 ghn Exp $
 * PURPOSE:     Define interface to hardware layer
 * AUTHOR:      Greg Nelson
 * DATE:        98-04-12
 *
 * REVISED:     $Log: hwapi.h,v $
 * REVISED:     Revision 1.1  1998/07/21 11:37:32  ghn
 * REVISED:     Initial revision
 * REVISED:
 * Copyright 1998 - Greg Nelson
 */

typedef struct devopts {
  uint16 type;	/* 0 = PEAR */
  uint16 port;
  uint32 baud;
} DevOpts;

/* Open a device. 

   DevOpts should contain any necessary information to determine how
   this is to be done.  The return value, if >= 0, is a device handle.
   Otherwise it indicated an error. */
int32 OpenDev(DevOpts *opts);

/* Evaluate speed.

   dd is the device handle returned by opening the device.  The
   function returns the estimated number of bits/second that the
   device will produce, which should be used as a limit in setting the
   data rate. */
int32 EvalSpeed(int32 dd);

/* Sample from a device.

   dd is the device handle returned by opening the device.  The number
   of bits requested will be sampled from the device immediately
   (waiting as needed to collect the data, with no discards) and the
   result will be returned. */
int32 Sample(int32 dd, uint16 bits);

/* Discard spare data from device.

   dd is the device handle returned by opening the device.  The input
   stream is consumed until a wait would be required.  The number of
   bits discarded is returned. */
int32 Discard(int32 dd);

/* Close a device.

   Closes a specified device handle. */
int32 CloseDev(int32 dd);
