;-*- Mode:     Lisp -*-
;;;; Author:   Paul Dietz
;;;; Created:  Sun Mar 15 13:19:57 1998
;;;; Contains: Test presence of symbols in the CL package,
;;;;           and symbol-related functions

(in-package :cl-test)

(declaim (optimize (safety 3)))

;;; Test for the presence of every darned symbol
;;; the standard says should be in the CL package.
;;; Also, test that they have no prohibited plist indicators (section 11.1.2.1.1)

(deftest symbol-&allow-other-keys (test-if-not-in-cl-package "&allow-other-keys") nil)
(deftest symbol-&aux (test-if-not-in-cl-package "&aux") nil)
(deftest symbol-&body (test-if-not-in-cl-package "&body") nil)
(deftest symbol-&environment (test-if-not-in-cl-package "&environment") nil)
(deftest symbol-&key (test-if-not-in-cl-package "&key") nil)
(deftest symbol-&optional (test-if-not-in-cl-package "&optional") nil)
(deftest symbol-&rest (test-if-not-in-cl-package "&rest") nil)
(deftest symbol-&whole (test-if-not-in-cl-package "&whole") nil)
(deftest symbol-* (test-if-not-in-cl-package "*") nil)
(deftest symbol-** (test-if-not-in-cl-package "**") nil)
(deftest symbol-*** (test-if-not-in-cl-package "***") nil)
(deftest symbol-*break-on-signals* (test-if-not-in-cl-package "*break-on-signals*") nil)
(deftest symbol-*compile-file-pathname* (test-if-not-in-cl-package "*compile-file-pathname*") nil)
(deftest symbol-*compile-file-truename* (test-if-not-in-cl-package "*compile-file-truename*") nil)
(deftest symbol-*compile-print* (test-if-not-in-cl-package "*compile-print*") nil)
(deftest symbol-*compile-verbose* (test-if-not-in-cl-package "*compile-verbose*") nil)
(deftest symbol-*debug-io* (test-if-not-in-cl-package "*debug-io*") nil)
(deftest symbol-*debugger-hook* (test-if-not-in-cl-package "*debugger-hook*") nil)
(deftest symbol-*default-pathname-defaults* (test-if-not-in-cl-package "*default-pathname-defaults*") nil)
(deftest symbol-*error-output* (test-if-not-in-cl-package "*error-output*") nil)
(deftest symbol-*features* (test-if-not-in-cl-package "*features*") nil)
(deftest symbol-*gensym-counter* (test-if-not-in-cl-package "*gensym-counter*") nil)
(deftest symbol-*load-pathname* (test-if-not-in-cl-package "*load-pathname*") nil)
(deftest symbol-*load-print* (test-if-not-in-cl-package "*load-print*") nil)
(deftest symbol-*load-truename* (test-if-not-in-cl-package "*load-truename*") nil)
(deftest symbol-*load-verbose* (test-if-not-in-cl-package "*load-verbose*") nil)
(deftest symbol-*macroexpand-hook* (test-if-not-in-cl-package "*macroexpand-hook*") nil)
(deftest symbol-*modules* (test-if-not-in-cl-package "*modules*") nil)
(deftest symbol-*package* (test-if-not-in-cl-package "*package*") nil)
(deftest symbol-*print-array* (test-if-not-in-cl-package "*print-array*") nil)
(deftest symbol-*print-base* (test-if-not-in-cl-package "*print-base*") nil)
(deftest symbol-*print-case* (test-if-not-in-cl-package "*print-case*") nil)
(deftest symbol-*print-circle* (test-if-not-in-cl-package "*print-circle*") nil)
(deftest symbol-*print-escape* (test-if-not-in-cl-package "*print-escape*") nil)
(deftest symbol-*print-gensym* (test-if-not-in-cl-package "*print-gensym*") nil)
(deftest symbol-*print-length* (test-if-not-in-cl-package "*print-length*") nil)
(deftest symbol-*print-level* (test-if-not-in-cl-package "*print-level*") nil)
(deftest symbol-*print-lines* (test-if-not-in-cl-package "*print-lines*") nil)
(deftest symbol-*print-miser-width* (test-if-not-in-cl-package "*print-miser-width*") nil)
(deftest symbol-*print-pprint-dispatch* (test-if-not-in-cl-package "*print-pprint-dispatch*") nil)
(deftest symbol-*print-pretty* (test-if-not-in-cl-package "*print-pretty*") nil)
(deftest symbol-*print-radix* (test-if-not-in-cl-package "*print-radix*") nil)
(deftest symbol-*print-readably* (test-if-not-in-cl-package "*print-readably*") nil)
(deftest symbol-*print-right-margin* (test-if-not-in-cl-package "*print-right-margin*") nil)
(deftest symbol-*query-io* (test-if-not-in-cl-package "*query-io*") nil)
(deftest symbol-*random-state* (test-if-not-in-cl-package "*random-state*") nil)
(deftest symbol-*read-base* (test-if-not-in-cl-package "*read-base*") nil)
(deftest symbol-*read-default-float-format* (test-if-not-in-cl-package "*read-default-float-format*") nil)
(deftest symbol-*read-eval* (test-if-not-in-cl-package "*read-eval*") nil)
(deftest symbol-*read-suppress* (test-if-not-in-cl-package "*read-suppress*") nil)
(deftest symbol-*readtable* (test-if-not-in-cl-package "*readtable*") nil)
(deftest symbol-*standard-input* (test-if-not-in-cl-package "*standard-input*") nil)
(deftest symbol-*standard-output* (test-if-not-in-cl-package "*standard-output*") nil)
(deftest symbol-*terminal-io* (test-if-not-in-cl-package "*terminal-io*") nil)
(deftest symbol-*trace-output* (test-if-not-in-cl-package "*trace-output*") nil)
(deftest symbol-+ (test-if-not-in-cl-package "+") nil)
(deftest symbol-++ (test-if-not-in-cl-package "++") nil)
(deftest symbol-+++ (test-if-not-in-cl-package "+++") nil)
(deftest symbol-- (test-if-not-in-cl-package "-") nil)
(deftest symbol-/ (test-if-not-in-cl-package "/") nil)
(deftest symbol-// (test-if-not-in-cl-package "//") nil)
(deftest symbol-/// (test-if-not-in-cl-package "///") nil)
(deftest symbol-/= (test-if-not-in-cl-package "/=") nil)
(deftest symbol-1+ (test-if-not-in-cl-package "1+") nil)
(deftest symbol-1- (test-if-not-in-cl-package "1-") nil)
(deftest symbol-< (test-if-not-in-cl-package "<") nil)
(deftest symbol-<= (test-if-not-in-cl-package "<=") nil)
(deftest symbol-= (test-if-not-in-cl-package "=") nil)
(deftest symbol-> (test-if-not-in-cl-package ">") nil)
(deftest symbol->= (test-if-not-in-cl-package ">=") nil)
(deftest symbol-abort (test-if-not-in-cl-package "abort") nil)
(deftest symbol-abs (test-if-not-in-cl-package "abs") nil)
(deftest symbol-acons (test-if-not-in-cl-package "acons") nil)
(deftest symbol-acos (test-if-not-in-cl-package "acos") nil)
(deftest symbol-acosh (test-if-not-in-cl-package "acosh") nil)
(deftest symbol-add-method (test-if-not-in-cl-package "add-method") nil)
(deftest symbol-adjoin (test-if-not-in-cl-package "adjoin") nil)
(deftest symbol-adjust-array (test-if-not-in-cl-package "adjust-array") nil)
(deftest symbol-adjustable-array-p (test-if-not-in-cl-package "adjustable-array-p") nil)
(deftest symbol-allocate-instance (test-if-not-in-cl-package "allocate-instance") nil)
(deftest symbol-alpha-char-p (test-if-not-in-cl-package "alpha-char-p") nil)
(deftest symbol-alphanumericp (test-if-not-in-cl-package "alphanumericp") nil)
(deftest symbol-and (test-if-not-in-cl-package "and") nil)
(deftest symbol-append (test-if-not-in-cl-package "append") nil)
(deftest symbol-apply (test-if-not-in-cl-package "apply") nil)
(deftest symbol-apropos (test-if-not-in-cl-package "apropos") nil)
(deftest symbol-apropos-list (test-if-not-in-cl-package "apropos-list") nil)
(deftest symbol-aref (test-if-not-in-cl-package "aref") nil)
(deftest symbol-arithmetic-error (test-if-not-in-cl-package "arithmetic-error") nil)
(deftest symbol-arithmetic-error-operands (test-if-not-in-cl-package "arithmetic-error-operands") nil)
(deftest symbol-arithmetic-error-operation (test-if-not-in-cl-package "arithmetic-error-operation") nil)
(deftest symbol-array (test-if-not-in-cl-package "array") nil)
(deftest symbol-array-dimension (test-if-not-in-cl-package "array-dimension") nil)
(deftest symbol-array-dimension-limit (test-if-not-in-cl-package "array-dimension-limit") nil)
(deftest symbol-array-dimensions (test-if-not-in-cl-package "array-dimensions") nil)
(deftest symbol-array-displacement (test-if-not-in-cl-package "array-displacement") nil)
(deftest symbol-array-element-type (test-if-not-in-cl-package "array-element-type") nil)
(deftest symbol-array-has-fill-pointer-p (test-if-not-in-cl-package "array-has-fill-pointer-p") nil)
(deftest symbol-array-in-bounds-p (test-if-not-in-cl-package "array-in-bounds-p") nil)
(deftest symbol-array-rank (test-if-not-in-cl-package "array-rank") nil)
(deftest symbol-array-rank-limit (test-if-not-in-cl-package "array-rank-limit") nil)
(deftest symbol-array-row-major-index (test-if-not-in-cl-package "array-row-major-index") nil)
(deftest symbol-array-total-size (test-if-not-in-cl-package "array-total-size") nil)
(deftest symbol-array-total-size-limit (test-if-not-in-cl-package "array-total-size-limit") nil)
(deftest symbol-arrayp (test-if-not-in-cl-package "arrayp") nil)
(deftest symbol-ash (test-if-not-in-cl-package "ash") nil)
(deftest symbol-asin (test-if-not-in-cl-package "asin") nil)
(deftest symbol-asinh (test-if-not-in-cl-package "asinh") nil)
(deftest symbol-assert (test-if-not-in-cl-package "assert") nil)
(deftest symbol-assoc (test-if-not-in-cl-package "assoc") nil)
(deftest symbol-assoc-if (test-if-not-in-cl-package "assoc-if") nil)
(deftest symbol-assoc-if-not (test-if-not-in-cl-package "assoc-if-not") nil)
(deftest symbol-atan (test-if-not-in-cl-package "atan") nil)
(deftest symbol-atanh (test-if-not-in-cl-package "atanh") nil)
(deftest symbol-atom (test-if-not-in-cl-package "atom") nil)
(deftest symbol-base-char (test-if-not-in-cl-package "base-char") nil)
(deftest symbol-base-string (test-if-not-in-cl-package "base-string") nil)
(deftest symbol-bignum (test-if-not-in-cl-package "bignum") nil)
(deftest symbol-bit (test-if-not-in-cl-package "bit") nil)
(deftest symbol-bit-and (test-if-not-in-cl-package "bit-and") nil)
(deftest symbol-bit-andc1 (test-if-not-in-cl-package "bit-andc1") nil)
(deftest symbol-bit-andc2 (test-if-not-in-cl-package "bit-andc2") nil)
(deftest symbol-bit-eqv (test-if-not-in-cl-package "bit-eqv") nil)
(deftest symbol-bit-ior (test-if-not-in-cl-package "bit-ior") nil)
(deftest symbol-bit-nand (test-if-not-in-cl-package "bit-nand") nil)
(deftest symbol-bit-nor (test-if-not-in-cl-package "bit-nor") nil)
(deftest symbol-bit-not (test-if-not-in-cl-package "bit-not") nil)
(deftest symbol-bit-orc1 (test-if-not-in-cl-package "bit-orc1") nil)
(deftest symbol-bit-orc2 (test-if-not-in-cl-package "bit-orc2") nil)
(deftest symbol-bit-vector (test-if-not-in-cl-package "bit-vector") nil)
(deftest symbol-bit-vector-p (test-if-not-in-cl-package "bit-vector-p") nil)
(deftest symbol-bit-xor (test-if-not-in-cl-package "bit-xor") nil)
(deftest symbol-block (test-if-not-in-cl-package "block") nil)
(deftest symbol-boole (test-if-not-in-cl-package "boole") nil)
(deftest symbol-boole-1 (test-if-not-in-cl-package "boole-1") nil)
(deftest symbol-boole-2 (test-if-not-in-cl-package "boole-2") nil)
(deftest symbol-boole-and (test-if-not-in-cl-package "boole-and") nil)
(deftest symbol-boole-andc1 (test-if-not-in-cl-package "boole-andc1") nil)
(deftest symbol-boole-andc2 (test-if-not-in-cl-package "boole-andc2") nil)
(deftest symbol-boole-c1 (test-if-not-in-cl-package "boole-c1") nil)
(deftest symbol-boole-c2 (test-if-not-in-cl-package "boole-c2") nil)
(deftest symbol-boole-clr (test-if-not-in-cl-package "boole-clr") nil)
(deftest symbol-boole-eqv (test-if-not-in-cl-package "boole-eqv") nil)
(deftest symbol-boole-ior (test-if-not-in-cl-package "boole-ior") nil)
(deftest symbol-boole-nand (test-if-not-in-cl-package "boole-nand") nil)
(deftest symbol-boole-nor (test-if-not-in-cl-package "boole-nor") nil)
(deftest symbol-boole-orc1 (test-if-not-in-cl-package "boole-orc1") nil)
(deftest symbol-boole-orc2 (test-if-not-in-cl-package "boole-orc2") nil)
(deftest symbol-boole-set (test-if-not-in-cl-package "boole-set") nil)
(deftest symbol-boole-xor (test-if-not-in-cl-package "boole-xor") nil)
(deftest symbol-boolean (test-if-not-in-cl-package "boolean") nil)
(deftest symbol-both-case-p (test-if-not-in-cl-package "both-case-p") nil)
(deftest symbol-boundp (test-if-not-in-cl-package "boundp") nil)
(deftest symbol-break (test-if-not-in-cl-package "break") nil)
(deftest symbol-broadcast-stream (test-if-not-in-cl-package "broadcast-stream") nil)
(deftest symbol-broadcast-stream-streams (test-if-not-in-cl-package "broadcast-stream-streams") nil)
(deftest symbol-built-in-class (test-if-not-in-cl-package "built-in-class") nil)
(deftest symbol-butlast (test-if-not-in-cl-package "butlast") nil)
(deftest symbol-byte (test-if-not-in-cl-package "byte") nil)
(deftest symbol-byte-position (test-if-not-in-cl-package "byte-position") nil)
(deftest symbol-byte-size (test-if-not-in-cl-package "byte-size") nil)
(deftest symbol-caaaar (test-if-not-in-cl-package "caaaar") nil)
(deftest symbol-caaadr (test-if-not-in-cl-package "caaadr") nil)
(deftest symbol-caaar (test-if-not-in-cl-package "caaar") nil)
(deftest symbol-caadar (test-if-not-in-cl-package "caadar") nil)
(deftest symbol-caaddr (test-if-not-in-cl-package "caaddr") nil)
(deftest symbol-caadr (test-if-not-in-cl-package "caadr") nil)
(deftest symbol-caar (test-if-not-in-cl-package "caar") nil)
(deftest symbol-cadaar (test-if-not-in-cl-package "cadaar") nil)
(deftest symbol-cadadr (test-if-not-in-cl-package "cadadr") nil)
(deftest symbol-cadar (test-if-not-in-cl-package "cadar") nil)
(deftest symbol-caddar (test-if-not-in-cl-package "caddar") nil)
(deftest symbol-cadddr (test-if-not-in-cl-package "cadddr") nil)
(deftest symbol-caddr (test-if-not-in-cl-package "caddr") nil)
(deftest symbol-cadr (test-if-not-in-cl-package "cadr") nil)
(deftest symbol-call-arguments-limit (test-if-not-in-cl-package "call-arguments-limit") nil)
(deftest symbol-call-method (test-if-not-in-cl-package "call-method") nil)
(deftest symbol-call-next-method (test-if-not-in-cl-package "call-next-method") nil)
(deftest symbol-car (test-if-not-in-cl-package "car") nil)
(deftest symbol-case (test-if-not-in-cl-package "case") nil)
(deftest symbol-catch (test-if-not-in-cl-package "catch") nil)
(deftest symbol-ccase (test-if-not-in-cl-package "ccase") nil)
(deftest symbol-cdaaar (test-if-not-in-cl-package "cdaaar") nil)
(deftest symbol-cdaadr (test-if-not-in-cl-package "cdaadr") nil)
(deftest symbol-cdaar (test-if-not-in-cl-package "cdaar") nil)
(deftest symbol-cdadar (test-if-not-in-cl-package "cdadar") nil)
(deftest symbol-cdaddr (test-if-not-in-cl-package "cdaddr") nil)
(deftest symbol-cdadr (test-if-not-in-cl-package "cdadr") nil)
(deftest symbol-cdar (test-if-not-in-cl-package "cdar") nil)
(deftest symbol-cddaar (test-if-not-in-cl-package "cddaar") nil)
(deftest symbol-cddadr (test-if-not-in-cl-package "cddadr") nil)
(deftest symbol-cddar (test-if-not-in-cl-package "cddar") nil)
(deftest symbol-cdddar (test-if-not-in-cl-package "cdddar") nil)
(deftest symbol-cddddr (test-if-not-in-cl-package "cddddr") nil)
(deftest symbol-cdddr (test-if-not-in-cl-package "cdddr") nil)
(deftest symbol-cddr (test-if-not-in-cl-package "cddr") nil)
(deftest symbol-cdr (test-if-not-in-cl-package "cdr") nil)
(deftest symbol-ceiling (test-if-not-in-cl-package "ceiling") nil)
(deftest symbol-cell-error (test-if-not-in-cl-package "cell-error") nil)
(deftest symbol-cell-error-name (test-if-not-in-cl-package "cell-error-name") nil)
(deftest symbol-cerror (test-if-not-in-cl-package "cerror") nil)
(deftest symbol-change-class (test-if-not-in-cl-package "change-class") nil)
(deftest symbol-char (test-if-not-in-cl-package "char") nil)
(deftest symbol-char-code (test-if-not-in-cl-package "char-code") nil)
(deftest symbol-char-code-limit (test-if-not-in-cl-package "char-code-limit") nil)
(deftest symbol-char-downcase (test-if-not-in-cl-package "char-downcase") nil)
(deftest symbol-char-equal (test-if-not-in-cl-package "char-equal") nil)
(deftest symbol-char-greaterp (test-if-not-in-cl-package "char-greaterp") nil)
(deftest symbol-char-int (test-if-not-in-cl-package "char-int") nil)
(deftest symbol-char-lessp (test-if-not-in-cl-package "char-lessp") nil)
(deftest symbol-char-name (test-if-not-in-cl-package "char-name") nil)
(deftest symbol-char-not-equal (test-if-not-in-cl-package "char-not-equal") nil)
(deftest symbol-char-not-greaterp (test-if-not-in-cl-package "char-not-greaterp") nil)
(deftest symbol-char-not-lessp (test-if-not-in-cl-package "char-not-lessp") nil)
(deftest symbol-char-upcase (test-if-not-in-cl-package "char-upcase") nil)
(deftest symbol-char/= (test-if-not-in-cl-package "char/=") nil)
(deftest symbol-char< (test-if-not-in-cl-package "char<") nil)
(deftest symbol-char<= (test-if-not-in-cl-package "char<=") nil)
(deftest symbol-char= (test-if-not-in-cl-package "char=") nil)
(deftest symbol-char> (test-if-not-in-cl-package "char>") nil)
(deftest symbol-char>= (test-if-not-in-cl-package "char>=") nil)
(deftest symbol-character (test-if-not-in-cl-package "character") nil)
(deftest symbol-characterp (test-if-not-in-cl-package "characterp") nil)
(deftest symbol-check-type (test-if-not-in-cl-package "check-type") nil)
(deftest symbol-cis (test-if-not-in-cl-package "cis") nil)
(deftest symbol-class (test-if-not-in-cl-package "class") nil)
(deftest symbol-class-name (test-if-not-in-cl-package "class-name") nil)
(deftest symbol-class-of (test-if-not-in-cl-package "class-of") nil)
(deftest symbol-clear-input (test-if-not-in-cl-package "clear-input") nil)
(deftest symbol-clear-output (test-if-not-in-cl-package "clear-output") nil)
(deftest symbol-close (test-if-not-in-cl-package "close") nil)
(deftest symbol-clrhash (test-if-not-in-cl-package "clrhash") nil)
(deftest symbol-code-char (test-if-not-in-cl-package "code-char") nil)
(deftest symbol-coerce (test-if-not-in-cl-package "coerce") nil)
(deftest symbol-compilation-speed (test-if-not-in-cl-package "compilation-speed") nil)
(deftest symbol-compile (test-if-not-in-cl-package "compile") nil)
(deftest symbol-compile-file (test-if-not-in-cl-package "compile-file") nil)
(deftest symbol-compile-file-pathname (test-if-not-in-cl-package "compile-file-pathname") nil)
(deftest symbol-compiled-function (test-if-not-in-cl-package "compiled-function") nil)
(deftest symbol-compiled-function-p (test-if-not-in-cl-package "compiled-function-p") nil)
(deftest symbol-compiler-macro (test-if-not-in-cl-package "compiler-macro") nil)
(deftest symbol-compiler-macro-function (test-if-not-in-cl-package "compiler-macro-function") nil)
(deftest symbol-complement (test-if-not-in-cl-package "complement") nil)
(deftest symbol-complex (test-if-not-in-cl-package "complex") nil)
(deftest symbol-complexp (test-if-not-in-cl-package "complexp") nil)
(deftest symbol-compute-applicable-methods (test-if-not-in-cl-package "compute-applicable-methods") nil)
(deftest symbol-compute-restarts (test-if-not-in-cl-package "compute-restarts") nil)
(deftest symbol-concatenate (test-if-not-in-cl-package "concatenate") nil)
(deftest symbol-concatenated-stream (test-if-not-in-cl-package "concatenated-stream") nil)
(deftest symbol-concatenated-stream-streams (test-if-not-in-cl-package "concatenated-stream-streams") nil)
(deftest symbol-cond (test-if-not-in-cl-package "cond") nil)
(deftest symbol-condition (test-if-not-in-cl-package "condition") nil)
(deftest symbol-conjugate (test-if-not-in-cl-package "conjugate") nil)
(deftest symbol-cons (test-if-not-in-cl-package "cons") nil)
(deftest symbol-consp (test-if-not-in-cl-package "consp") nil)
(deftest symbol-constantly (test-if-not-in-cl-package "constantly") nil)
(deftest symbol-constantp (test-if-not-in-cl-package "constantp") nil)
(deftest symbol-continue (test-if-not-in-cl-package "continue") nil)
(deftest symbol-control-error (test-if-not-in-cl-package "control-error") nil)
(deftest symbol-copy-alist (test-if-not-in-cl-package "copy-alist") nil)
(deftest symbol-copy-list (test-if-not-in-cl-package "copy-list") nil)
(deftest symbol-copy-pprint-dispatch (test-if-not-in-cl-package "copy-pprint-dispatch") nil)
(deftest symbol-copy-readtable (test-if-not-in-cl-package "copy-readtable") nil)
(deftest symbol-copy-seq (test-if-not-in-cl-package "copy-seq") nil)
(deftest symbol-copy-structure (test-if-not-in-cl-package "copy-structure") nil)
(deftest symbol-copy-symbol (test-if-not-in-cl-package "copy-symbol") nil)
(deftest symbol-copy-tree (test-if-not-in-cl-package "copy-tree") nil)
(deftest symbol-cos (test-if-not-in-cl-package "cos") nil)
(deftest symbol-cosh (test-if-not-in-cl-package "cosh") nil)
(deftest symbol-count (test-if-not-in-cl-package "count") nil)
(deftest symbol-count-if (test-if-not-in-cl-package "count-if") nil)
(deftest symbol-count-if-not (test-if-not-in-cl-package "count-if-not") nil)
(deftest symbol-ctypecase (test-if-not-in-cl-package "ctypecase") nil)
(deftest symbol-debug (test-if-not-in-cl-package "debug") nil)
(deftest symbol-decf (test-if-not-in-cl-package "decf") nil)
(deftest symbol-declaim (test-if-not-in-cl-package "declaim") nil)
(deftest symbol-declaration (test-if-not-in-cl-package "declaration") nil)
(deftest symbol-declare (test-if-not-in-cl-package "declare") nil)
(deftest symbol-decode-float (test-if-not-in-cl-package "decode-float") nil)
(deftest symbol-decode-universal-time (test-if-not-in-cl-package "decode-universal-time") nil)
(deftest symbol-defclass (test-if-not-in-cl-package "defclass") nil)
(deftest symbol-defconstant (test-if-not-in-cl-package "defconstant") nil)
(deftest symbol-defgeneric (test-if-not-in-cl-package "defgeneric") nil)
(deftest symbol-define-compiler-macro (test-if-not-in-cl-package "define-compiler-macro") nil)
(deftest symbol-define-condition (test-if-not-in-cl-package "define-condition") nil)
(deftest symbol-define-method-combination (test-if-not-in-cl-package "define-method-combination") nil)
(deftest symbol-define-modify-macro (test-if-not-in-cl-package "define-modify-macro") nil)
(deftest symbol-define-setf-expander (test-if-not-in-cl-package "define-setf-expander") nil)
(deftest symbol-define-symbol-macro (test-if-not-in-cl-package "define-symbol-macro") nil)
(deftest symbol-defmacro (test-if-not-in-cl-package "defmacro") nil)
(deftest symbol-defmethod (test-if-not-in-cl-package "defmethod") nil)
(deftest symbol-defpackage (test-if-not-in-cl-package "defpackage") nil)
(deftest symbol-defparameter (test-if-not-in-cl-package "defparameter") nil)
(deftest symbol-defsetf (test-if-not-in-cl-package "defsetf") nil)
(deftest symbol-defstruct (test-if-not-in-cl-package "defstruct") nil)
(deftest symbol-deftype (test-if-not-in-cl-package "deftype") nil)
(deftest symbol-defun (test-if-not-in-cl-package "defun") nil)
(deftest symbol-defvar (test-if-not-in-cl-package "defvar") nil)
(deftest symbol-delete (test-if-not-in-cl-package "delete") nil)
(deftest symbol-delete-duplicates (test-if-not-in-cl-package "delete-duplicates") nil)
(deftest symbol-delete-file (test-if-not-in-cl-package "delete-file") nil)
(deftest symbol-delete-if (test-if-not-in-cl-package "delete-if") nil)
(deftest symbol-delete-if-not (test-if-not-in-cl-package "delete-if-not") nil)
(deftest symbol-delete-package (test-if-not-in-cl-package "delete-package") nil)
(deftest symbol-denominator (test-if-not-in-cl-package "denominator") nil)
(deftest symbol-deposit-field (test-if-not-in-cl-package "deposit-field") nil)
(deftest symbol-describe (test-if-not-in-cl-package "describe") nil)
(deftest symbol-describe-object (test-if-not-in-cl-package "describe-object") nil)
(deftest symbol-destructuring-bind (test-if-not-in-cl-package "destructuring-bind") nil)
(deftest symbol-digit-char (test-if-not-in-cl-package "digit-char") nil)
(deftest symbol-digit-char-p (test-if-not-in-cl-package "digit-char-p") nil)
(deftest symbol-directory (test-if-not-in-cl-package "directory") nil)
(deftest symbol-directory-namestring (test-if-not-in-cl-package "directory-namestring") nil)
(deftest symbol-disassemble (test-if-not-in-cl-package "disassemble") nil)
(deftest symbol-division-by-zero (test-if-not-in-cl-package "division-by-zero") nil)
(deftest symbol-do (test-if-not-in-cl-package "do") nil)
(deftest symbol-do* (test-if-not-in-cl-package "do*") nil)
(deftest symbol-do-all-symbols (test-if-not-in-cl-package "do-all-symbols") nil)
(deftest symbol-do-external-symbols (test-if-not-in-cl-package "do-external-symbols") nil)
(deftest symbol-do-symbols (test-if-not-in-cl-package "do-symbols") nil)
(deftest symbol-documentation (test-if-not-in-cl-package "documentation") nil)
(deftest symbol-dolist (test-if-not-in-cl-package "dolist") nil)
(deftest symbol-dotimes (test-if-not-in-cl-package "dotimes") nil)
(deftest symbol-double-float (test-if-not-in-cl-package "double-float") nil)
(deftest symbol-double-float-epsilon (test-if-not-in-cl-package "double-float-epsilon") nil)
(deftest symbol-double-float-negative-epsilon (test-if-not-in-cl-package "double-float-negative-epsilon") nil)
(deftest symbol-dpb (test-if-not-in-cl-package "dpb") nil)
(deftest symbol-dribble (test-if-not-in-cl-package "dribble") nil)
(deftest symbol-dynamic-extent (test-if-not-in-cl-package "dynamic-extent") nil)
(deftest symbol-ecase (test-if-not-in-cl-package "ecase") nil)
(deftest symbol-echo-stream (test-if-not-in-cl-package "echo-stream") nil)
(deftest symbol-echo-stream-input-stream (test-if-not-in-cl-package "echo-stream-input-stream") nil)
(deftest symbol-echo-stream-output-stream (test-if-not-in-cl-package "echo-stream-output-stream") nil)
(deftest symbol-ed (test-if-not-in-cl-package "ed") nil)
(deftest symbol-eighth (test-if-not-in-cl-package "eighth") nil)
(deftest symbol-elt (test-if-not-in-cl-package "elt") nil)
(deftest symbol-encode-universal-time (test-if-not-in-cl-package "encode-universal-time") nil)
(deftest symbol-end-of-file (test-if-not-in-cl-package "end-of-file") nil)
(deftest symbol-endp (test-if-not-in-cl-package "endp") nil)
(deftest symbol-enough-namestring (test-if-not-in-cl-package "enough-namestring") nil)
(deftest symbol-ensure-directories-exist (test-if-not-in-cl-package "ensure-directories-exist") nil)
(deftest symbol-ensure-generic-function (test-if-not-in-cl-package "ensure-generic-function") nil)
(deftest symbol-eq (test-if-not-in-cl-package "eq") nil)
(deftest symbol-eql (test-if-not-in-cl-package "eql") nil)
(deftest symbol-equal (test-if-not-in-cl-package "equal") nil)
(deftest symbol-equalp (test-if-not-in-cl-package "equalp") nil)
(deftest symbol-error (test-if-not-in-cl-package "error") nil)
(deftest symbol-etypecase (test-if-not-in-cl-package "etypecase") nil)
(deftest symbol-eval (test-if-not-in-cl-package "eval") nil)
(deftest symbol-eval-when (test-if-not-in-cl-package "eval-when") nil)
(deftest symbol-evenp (test-if-not-in-cl-package "evenp") nil)
(deftest symbol-every (test-if-not-in-cl-package "every") nil)
(deftest symbol-exp (test-if-not-in-cl-package "exp") nil)
(deftest symbol-export (test-if-not-in-cl-package "export") nil)
(deftest symbol-expt (test-if-not-in-cl-package "expt") nil)
(deftest symbol-extended-char (test-if-not-in-cl-package "extended-char") nil)
(deftest symbol-fboundp (test-if-not-in-cl-package "fboundp") nil)
(deftest symbol-fceiling (test-if-not-in-cl-package "fceiling") nil)
(deftest symbol-fdefinition (test-if-not-in-cl-package "fdefinition") nil)
(deftest symbol-ffloor (test-if-not-in-cl-package "ffloor") nil)
(deftest symbol-fifth (test-if-not-in-cl-package "fifth") nil)
(deftest symbol-file-author (test-if-not-in-cl-package "file-author") nil)
(deftest symbol-file-error (test-if-not-in-cl-package "file-error") nil)
(deftest symbol-file-error-pathname (test-if-not-in-cl-package "file-error-pathname") nil)
(deftest symbol-file-length (test-if-not-in-cl-package "file-length") nil)
(deftest symbol-file-namestring (test-if-not-in-cl-package "file-namestring") nil)
(deftest symbol-file-position (test-if-not-in-cl-package "file-position") nil)
(deftest symbol-file-stream (test-if-not-in-cl-package "file-stream") nil)
(deftest symbol-file-string-length (test-if-not-in-cl-package "file-string-length") nil)
(deftest symbol-file-write-date (test-if-not-in-cl-package "file-write-date") nil)
(deftest symbol-fill (test-if-not-in-cl-package "fill") nil)
(deftest symbol-fill-pointer (test-if-not-in-cl-package "fill-pointer") nil)
(deftest symbol-find (test-if-not-in-cl-package "find") nil)
(deftest symbol-find-all-symbols (test-if-not-in-cl-package "find-all-symbols") nil)
(deftest symbol-find-class (test-if-not-in-cl-package "find-class") nil)
(deftest symbol-find-if (test-if-not-in-cl-package "find-if") nil)
(deftest symbol-find-if-not (test-if-not-in-cl-package "find-if-not") nil)
(deftest symbol-find-method (test-if-not-in-cl-package "find-method") nil)
(deftest symbol-find-package (test-if-not-in-cl-package "find-package") nil)
(deftest symbol-find-restart (test-if-not-in-cl-package "find-restart") nil)
(deftest symbol-find-symbol (test-if-not-in-cl-package "find-symbol") nil)
(deftest symbol-finish-output (test-if-not-in-cl-package "finish-output") nil)
(deftest symbol-first (test-if-not-in-cl-package "first") nil)
(deftest symbol-fixnum (test-if-not-in-cl-package "fixnum") nil)
(deftest symbol-flet (test-if-not-in-cl-package "flet") nil)
(deftest symbol-float (test-if-not-in-cl-package "float") nil)
(deftest symbol-float-digits (test-if-not-in-cl-package "float-digits") nil)
(deftest symbol-float-precision (test-if-not-in-cl-package "float-precision") nil)
(deftest symbol-float-radix (test-if-not-in-cl-package "float-radix") nil)
(deftest symbol-float-sign (test-if-not-in-cl-package "float-sign") nil)
(deftest symbol-floating-point-inexact (test-if-not-in-cl-package "floating-point-inexact") nil)
(deftest symbol-floating-point-invalid-operation (test-if-not-in-cl-package "floating-point-invalid-operation") nil)
(deftest symbol-floating-point-overflow (test-if-not-in-cl-package "floating-point-overflow") nil)
(deftest symbol-floating-point-underflow (test-if-not-in-cl-package "floating-point-underflow") nil)
(deftest symbol-floatp (test-if-not-in-cl-package "floatp") nil)
(deftest symbol-floor (test-if-not-in-cl-package "floor") nil)
(deftest symbol-fmakunbound (test-if-not-in-cl-package "fmakunbound") nil)
(deftest symbol-force-output (test-if-not-in-cl-package "force-output") nil)
(deftest symbol-format (test-if-not-in-cl-package "format") nil)
(deftest symbol-formatter (test-if-not-in-cl-package "formatter") nil)
(deftest symbol-fourth (test-if-not-in-cl-package "fourth") nil)
(deftest symbol-fresh-line (test-if-not-in-cl-package "fresh-line") nil)
(deftest symbol-fround (test-if-not-in-cl-package "fround") nil)
(deftest symbol-ftruncate (test-if-not-in-cl-package "ftruncate") nil)
(deftest symbol-ftype (test-if-not-in-cl-package "ftype") nil)
(deftest symbol-funcall (test-if-not-in-cl-package "funcall") nil)
(deftest symbol-function (test-if-not-in-cl-package "function") nil)
(deftest symbol-function-keywords (test-if-not-in-cl-package "function-keywords") nil)
(deftest symbol-function-lambda-expression (test-if-not-in-cl-package "function-lambda-expression") nil)
(deftest symbol-functionp (test-if-not-in-cl-package "functionp") nil)
(deftest symbol-gcd (test-if-not-in-cl-package "gcd") nil)
(deftest symbol-generic-function (test-if-not-in-cl-package "generic-function") nil)
(deftest symbol-gensym (test-if-not-in-cl-package "gensym") nil)
(deftest symbol-gentemp (test-if-not-in-cl-package "gentemp") nil)
(deftest symbol-get (test-if-not-in-cl-package "get") nil)
(deftest symbol-get-decoded-time (test-if-not-in-cl-package "get-decoded-time") nil)
(deftest symbol-get-dispatch-macro-character (test-if-not-in-cl-package "get-dispatch-macro-character") nil)
(deftest symbol-get-internal-real-time (test-if-not-in-cl-package "get-internal-real-time") nil)
(deftest symbol-get-internal-run-time (test-if-not-in-cl-package "get-internal-run-time") nil)
(deftest symbol-get-macro-character (test-if-not-in-cl-package "get-macro-character") nil)
(deftest symbol-get-output-stream-string (test-if-not-in-cl-package "get-output-stream-string") nil)
(deftest symbol-get-properties (test-if-not-in-cl-package "get-properties") nil)
(deftest symbol-get-setf-expansion (test-if-not-in-cl-package "get-setf-expansion") nil)
(deftest symbol-get-universal-time (test-if-not-in-cl-package "get-universal-time") nil)
(deftest symbol-getf (test-if-not-in-cl-package "getf") nil)
(deftest symbol-gethash (test-if-not-in-cl-package "gethash") nil)
(deftest symbol-go (test-if-not-in-cl-package "go") nil)
(deftest symbol-graphic-char-p (test-if-not-in-cl-package "graphic-char-p") nil)
(deftest symbol-handler-bind (test-if-not-in-cl-package "handler-bind") nil)
(deftest symbol-handler-case (test-if-not-in-cl-package "handler-case") nil)
(deftest symbol-hash-table (test-if-not-in-cl-package "hash-table") nil)
(deftest symbol-hash-table-count (test-if-not-in-cl-package "hash-table-count") nil)
(deftest symbol-hash-table-p (test-if-not-in-cl-package "hash-table-p") nil)
(deftest symbol-hash-table-rehash-size (test-if-not-in-cl-package "hash-table-rehash-size") nil)
(deftest symbol-hash-table-rehash-threshold (test-if-not-in-cl-package "hash-table-rehash-threshold") nil)
(deftest symbol-hash-table-size (test-if-not-in-cl-package "hash-table-size") nil)
(deftest symbol-hash-table-test (test-if-not-in-cl-package "hash-table-test") nil)
(deftest symbol-host-namestring (test-if-not-in-cl-package "host-namestring") nil)
(deftest symbol-identity (test-if-not-in-cl-package "identity") nil)
(deftest symbol-if (test-if-not-in-cl-package "if") nil)
(deftest symbol-ignorable (test-if-not-in-cl-package "ignorable") nil)
(deftest symbol-ignore (test-if-not-in-cl-package "ignore") nil)
(deftest symbol-ignore-errors (test-if-not-in-cl-package "ignore-errors") nil)
(deftest symbol-imagpart (test-if-not-in-cl-package "imagpart") nil)
(deftest symbol-import (test-if-not-in-cl-package "import") nil)
(deftest symbol-in-package (test-if-not-in-cl-package "in-package") nil)
(deftest symbol-incf (test-if-not-in-cl-package "incf") nil)
(deftest symbol-initialize-instance (test-if-not-in-cl-package "initialize-instance") nil)
(deftest symbol-inline (test-if-not-in-cl-package "inline") nil)
(deftest symbol-input-stream-p (test-if-not-in-cl-package "input-stream-p") nil)
(deftest symbol-inspect (test-if-not-in-cl-package "inspect") nil)
(deftest symbol-integer (test-if-not-in-cl-package "integer") nil)
(deftest symbol-integer-decode-float (test-if-not-in-cl-package "integer-decode-float") nil)
(deftest symbol-integer-length (test-if-not-in-cl-package "integer-length") nil)
(deftest symbol-integerp (test-if-not-in-cl-package "integerp") nil)
(deftest symbol-interactive-stream-p (test-if-not-in-cl-package "interactive-stream-p") nil)
(deftest symbol-intern (test-if-not-in-cl-package "intern") nil)
(deftest symbol-internal-time-units-per-second (test-if-not-in-cl-package "internal-time-units-per-second") nil)
(deftest symbol-intersection (test-if-not-in-cl-package "intersection") nil)
(deftest symbol-invalid-method-error (test-if-not-in-cl-package "invalid-method-error") nil)
(deftest symbol-invoke-debugger (test-if-not-in-cl-package "invoke-debugger") nil)
(deftest symbol-invoke-restart (test-if-not-in-cl-package "invoke-restart") nil)
(deftest symbol-invoke-restart-interactively (test-if-not-in-cl-package "invoke-restart-interactively") nil)
(deftest symbol-isqrt (test-if-not-in-cl-package "isqrt") nil)
(deftest symbol-keyword (test-if-not-in-cl-package "keyword") nil)
(deftest symbol-keywordp (test-if-not-in-cl-package "keywordp") nil)
(deftest symbol-labels (test-if-not-in-cl-package "labels") nil)
(deftest symbol-lambda (test-if-not-in-cl-package "lambda") nil)
(deftest symbol-lambda-list-keywords (test-if-not-in-cl-package "lambda-list-keywords") nil)
(deftest symbol-lambda-parameters-limit (test-if-not-in-cl-package "lambda-parameters-limit") nil)
(deftest symbol-last (test-if-not-in-cl-package "last") nil)
(deftest symbol-lcm (test-if-not-in-cl-package "lcm") nil)
(deftest symbol-ldb (test-if-not-in-cl-package "ldb") nil)
(deftest symbol-ldb-test (test-if-not-in-cl-package "ldb-test") nil)
(deftest symbol-ldiff (test-if-not-in-cl-package "ldiff") nil)
(deftest symbol-least-negative-double-float (test-if-not-in-cl-package "least-negative-double-float") nil)
(deftest symbol-least-negative-long-float (test-if-not-in-cl-package "least-negative-long-float") nil)
(deftest symbol-least-negative-normalized-double-float (test-if-not-in-cl-package "least-negative-normalized-double-float") nil)
(deftest symbol-least-negative-normalized-long-float (test-if-not-in-cl-package "least-negative-normalized-long-float") nil)
(deftest symbol-least-negative-normalized-short-float (test-if-not-in-cl-package "least-negative-normalized-short-float") nil)
(deftest symbol-least-negative-normalized-single-float (test-if-not-in-cl-package "least-negative-normalized-single-float") nil)
(deftest symbol-least-negative-short-float (test-if-not-in-cl-package "least-negative-short-float") nil)
(deftest symbol-least-negative-single-float (test-if-not-in-cl-package "least-negative-single-float") nil)
(deftest symbol-least-positive-double-float (test-if-not-in-cl-package "least-positive-double-float") nil)
(deftest symbol-least-positive-long-float (test-if-not-in-cl-package "least-positive-long-float") nil)
(deftest symbol-least-positive-normalized-double-float (test-if-not-in-cl-package "least-positive-normalized-double-float") nil)
(deftest symbol-least-positive-normalized-long-float (test-if-not-in-cl-package "least-positive-normalized-long-float") nil)
(deftest symbol-least-positive-normalized-short-float (test-if-not-in-cl-package "least-positive-normalized-short-float") nil)
(deftest symbol-least-positive-normalized-single-float (test-if-not-in-cl-package "least-positive-normalized-single-float") nil)
(deftest symbol-least-positive-short-float (test-if-not-in-cl-package "least-positive-short-float") nil)
(deftest symbol-least-positive-single-float (test-if-not-in-cl-package "least-positive-single-float") nil)
(deftest symbol-length (test-if-not-in-cl-package "length") nil)
(deftest symbol-let (test-if-not-in-cl-package "let") nil)
(deftest symbol-let* (test-if-not-in-cl-package "let*") nil)
(deftest symbol-lisp-implementation-type (test-if-not-in-cl-package "lisp-implementation-type") nil)
(deftest symbol-lisp-implementation-version (test-if-not-in-cl-package "lisp-implementation-version") nil)
(deftest symbol-list (test-if-not-in-cl-package "list") nil)
(deftest symbol-list* (test-if-not-in-cl-package "list*") nil)
(deftest symbol-list-all-packages (test-if-not-in-cl-package "list-all-packages") nil)
(deftest symbol-list-length (test-if-not-in-cl-package "list-length") nil)
(deftest symbol-listen (test-if-not-in-cl-package "listen") nil)
(deftest symbol-listp (test-if-not-in-cl-package "listp") nil)
(deftest symbol-load (test-if-not-in-cl-package "load") nil)
(deftest symbol-load-logical-pathname-translations (test-if-not-in-cl-package "load-logical-pathname-translations") nil)
(deftest symbol-load-time-value (test-if-not-in-cl-package "load-time-value") nil)
(deftest symbol-locally (test-if-not-in-cl-package "locally") nil)
(deftest symbol-log (test-if-not-in-cl-package "log") nil)
(deftest symbol-logand (test-if-not-in-cl-package "logand") nil)
(deftest symbol-logandc1 (test-if-not-in-cl-package "logandc1") nil)
(deftest symbol-logandc2 (test-if-not-in-cl-package "logandc2") nil)
(deftest symbol-logbitp (test-if-not-in-cl-package "logbitp") nil)
(deftest symbol-logcount (test-if-not-in-cl-package "logcount") nil)
(deftest symbol-logeqv (test-if-not-in-cl-package "logeqv") nil)
(deftest symbol-logical-pathname (test-if-not-in-cl-package "logical-pathname") nil)
(deftest symbol-logical-pathname-translations (test-if-not-in-cl-package "logical-pathname-translations") nil)
(deftest symbol-logior (test-if-not-in-cl-package "logior") nil)
(deftest symbol-lognand (test-if-not-in-cl-package "lognand") nil)
(deftest symbol-lognor (test-if-not-in-cl-package "lognor") nil)
(deftest symbol-lognot (test-if-not-in-cl-package "lognot") nil)
(deftest symbol-logorc1 (test-if-not-in-cl-package "logorc1") nil)
(deftest symbol-logorc2 (test-if-not-in-cl-package "logorc2") nil)
(deftest symbol-logtest (test-if-not-in-cl-package "logtest") nil)
(deftest symbol-logxor (test-if-not-in-cl-package "logxor") nil)
(deftest symbol-long-float (test-if-not-in-cl-package "long-float") nil)
(deftest symbol-long-float-epsilon (test-if-not-in-cl-package "long-float-epsilon") nil)
(deftest symbol-long-float-negative-epsilon (test-if-not-in-cl-package "long-float-negative-epsilon") nil)
(deftest symbol-long-site-name (test-if-not-in-cl-package "long-site-name") nil)
(deftest symbol-loop (test-if-not-in-cl-package "loop") nil)
(deftest symbol-loop-finish (test-if-not-in-cl-package "loop-finish") nil)
(deftest symbol-lower-case-p (test-if-not-in-cl-package "lower-case-p") nil)
(deftest symbol-machine-instance (test-if-not-in-cl-package "machine-instance") nil)
(deftest symbol-machine-type (test-if-not-in-cl-package "machine-type") nil)
(deftest symbol-machine-version (test-if-not-in-cl-package "machine-version") nil)
(deftest symbol-macro-function (test-if-not-in-cl-package "macro-function") nil)
(deftest symbol-macroexpand (test-if-not-in-cl-package "macroexpand") nil)
(deftest symbol-macroexpand-1 (test-if-not-in-cl-package "macroexpand-1") nil)
(deftest symbol-macrolet (test-if-not-in-cl-package "macrolet") nil)
(deftest symbol-make-array (test-if-not-in-cl-package "make-array") nil)
(deftest symbol-make-broadcast-stream (test-if-not-in-cl-package "make-broadcast-stream") nil)
(deftest symbol-make-concatenated-stream (test-if-not-in-cl-package "make-concatenated-stream") nil)
(deftest symbol-make-condition (test-if-not-in-cl-package "make-condition") nil)
(deftest symbol-make-dispatch-macro-character (test-if-not-in-cl-package "make-dispatch-macro-character") nil)
(deftest symbol-make-echo-stream (test-if-not-in-cl-package "make-echo-stream") nil)
(deftest symbol-make-hash-table (test-if-not-in-cl-package "make-hash-table") nil)
(deftest symbol-make-instance (test-if-not-in-cl-package "make-instance") nil)
(deftest symbol-make-instances-obsolete (test-if-not-in-cl-package "make-instances-obsolete") nil)
(deftest symbol-make-list (test-if-not-in-cl-package "make-list") nil)
(deftest symbol-make-load-form (test-if-not-in-cl-package "make-load-form") nil)
(deftest symbol-make-load-form-saving-slots (test-if-not-in-cl-package "make-load-form-saving-slots") nil)
(deftest symbol-make-method (test-if-not-in-cl-package "make-method") nil)
(deftest symbol-make-package (test-if-not-in-cl-package "make-package") nil)
(deftest symbol-make-pathname (test-if-not-in-cl-package "make-pathname") nil)
(deftest symbol-make-random-state (test-if-not-in-cl-package "make-random-state") nil)
(deftest symbol-make-sequence (test-if-not-in-cl-package "make-sequence") nil)
(deftest symbol-make-string (test-if-not-in-cl-package "make-string") nil)
(deftest symbol-make-string-input-stream (test-if-not-in-cl-package "make-string-input-stream") nil)
(deftest symbol-make-string-output-stream (test-if-not-in-cl-package "make-string-output-stream") nil)
(deftest symbol-make-symbol (test-if-not-in-cl-package "make-symbol") nil)
(deftest symbol-make-synonym-stream (test-if-not-in-cl-package "make-synonym-stream") nil)
(deftest symbol-make-two-way-stream (test-if-not-in-cl-package "make-two-way-stream") nil)
(deftest symbol-makunbound (test-if-not-in-cl-package "makunbound") nil)
(deftest symbol-map (test-if-not-in-cl-package "map") nil)
(deftest symbol-map-into (test-if-not-in-cl-package "map-into") nil)
(deftest symbol-mapc (test-if-not-in-cl-package "mapc") nil)
(deftest symbol-mapcan (test-if-not-in-cl-package "mapcan") nil)
(deftest symbol-mapcar (test-if-not-in-cl-package "mapcar") nil)
(deftest symbol-mapcon (test-if-not-in-cl-package "mapcon") nil)
(deftest symbol-maphash (test-if-not-in-cl-package "maphash") nil)
(deftest symbol-mapl (test-if-not-in-cl-package "mapl") nil)
(deftest symbol-maplist (test-if-not-in-cl-package "maplist") nil)
(deftest symbol-mask-field (test-if-not-in-cl-package "mask-field") nil)
(deftest symbol-max (test-if-not-in-cl-package "max") nil)
(deftest symbol-member (test-if-not-in-cl-package "member") nil)
(deftest symbol-member-if (test-if-not-in-cl-package "member-if") nil)
(deftest symbol-member-if-not (test-if-not-in-cl-package "member-if-not") nil)
(deftest symbol-merge (test-if-not-in-cl-package "merge") nil)
(deftest symbol-merge-pathnames (test-if-not-in-cl-package "merge-pathnames") nil)
(deftest symbol-method (test-if-not-in-cl-package "method") nil)
(deftest symbol-method-combination (test-if-not-in-cl-package "method-combination") nil)
(deftest symbol-method-combination-error (test-if-not-in-cl-package "method-combination-error") nil)
(deftest symbol-method-qualifiers (test-if-not-in-cl-package "method-qualifiers") nil)
(deftest symbol-min (test-if-not-in-cl-package "min") nil)
(deftest symbol-minusp (test-if-not-in-cl-package "minusp") nil)
(deftest symbol-mismatch (test-if-not-in-cl-package "mismatch") nil)
(deftest symbol-mod (test-if-not-in-cl-package "mod") nil)
(deftest symbol-most-negative-double-float (test-if-not-in-cl-package "most-negative-double-float") nil)
(deftest symbol-most-negative-fixnum (test-if-not-in-cl-package "most-negative-fixnum") nil)
(deftest symbol-most-negative-long-float (test-if-not-in-cl-package "most-negative-long-float") nil)
(deftest symbol-most-negative-short-float (test-if-not-in-cl-package "most-negative-short-float") nil)
(deftest symbol-most-negative-single-float (test-if-not-in-cl-package "most-negative-single-float") nil)
(deftest symbol-most-positive-double-float (test-if-not-in-cl-package "most-positive-double-float") nil)
(deftest symbol-most-positive-fixnum (test-if-not-in-cl-package "most-positive-fixnum") nil)
(deftest symbol-most-positive-long-float (test-if-not-in-cl-package "most-positive-long-float") nil)
(deftest symbol-most-positive-short-float (test-if-not-in-cl-package "most-positive-short-float") nil)
(deftest symbol-most-positive-single-float (test-if-not-in-cl-package "most-positive-single-float") nil)
(deftest symbol-muffle-warning (test-if-not-in-cl-package "muffle-warning") nil)
(deftest symbol-multiple-value-bind (test-if-not-in-cl-package "multiple-value-bind") nil)
(deftest symbol-multiple-value-call (test-if-not-in-cl-package "multiple-value-call") nil)
(deftest symbol-multiple-value-list (test-if-not-in-cl-package "multiple-value-list") nil)
(deftest symbol-multiple-value-prog1 (test-if-not-in-cl-package "multiple-value-prog1") nil)
(deftest symbol-multiple-value-setq (test-if-not-in-cl-package "multiple-value-setq") nil)
(deftest symbol-multiple-values-limit (test-if-not-in-cl-package "multiple-values-limit") nil)
(deftest symbol-name-char (test-if-not-in-cl-package "name-char") nil)
(deftest symbol-namestring (test-if-not-in-cl-package "namestring") nil)
(deftest symbol-nbutlast (test-if-not-in-cl-package "nbutlast") nil)
(deftest symbol-nconc (test-if-not-in-cl-package "nconc") nil)
(deftest symbol-next-method-p (test-if-not-in-cl-package "next-method-p") nil)
(deftest symbol-nil (test-if-not-in-cl-package "nil") nil)
(deftest symbol-nintersection (test-if-not-in-cl-package "nintersection") nil)
(deftest symbol-ninth (test-if-not-in-cl-package "ninth") nil)
(deftest symbol-no-applicable-method (test-if-not-in-cl-package "no-applicable-method") nil)
(deftest symbol-no-next-method (test-if-not-in-cl-package "no-next-method") nil)
(deftest symbol-not (test-if-not-in-cl-package "not") nil)
(deftest symbol-notany (test-if-not-in-cl-package "notany") nil)
(deftest symbol-notevery (test-if-not-in-cl-package "notevery") nil)
(deftest symbol-notinline (test-if-not-in-cl-package "notinline") nil)
(deftest symbol-nreconc (test-if-not-in-cl-package "nreconc") nil)
(deftest symbol-nreverse (test-if-not-in-cl-package "nreverse") nil)
(deftest symbol-nset-difference (test-if-not-in-cl-package "nset-difference") nil)
(deftest symbol-nset-exclusive-or (test-if-not-in-cl-package "nset-exclusive-or") nil)
(deftest symbol-nstring-capitalize (test-if-not-in-cl-package "nstring-capitalize") nil)
(deftest symbol-nstring-downcase (test-if-not-in-cl-package "nstring-downcase") nil)
(deftest symbol-nstring-upcase (test-if-not-in-cl-package "nstring-upcase") nil)
(deftest symbol-nsublis (test-if-not-in-cl-package "nsublis") nil)
(deftest symbol-nsubst (test-if-not-in-cl-package "nsubst") nil)
(deftest symbol-nsubst-if (test-if-not-in-cl-package "nsubst-if") nil)
(deftest symbol-nsubst-if-not (test-if-not-in-cl-package "nsubst-if-not") nil)
(deftest symbol-nsubstitute (test-if-not-in-cl-package "nsubstitute") nil)
(deftest symbol-nsubstitute-if (test-if-not-in-cl-package "nsubstitute-if") nil)
(deftest symbol-nsubstitute-if-not (test-if-not-in-cl-package "nsubstitute-if-not") nil)
(deftest symbol-nth (test-if-not-in-cl-package "nth") nil)
(deftest symbol-nth-value (test-if-not-in-cl-package "nth-value") nil)
(deftest symbol-nthcdr (test-if-not-in-cl-package "nthcdr") nil)
(deftest symbol-null (test-if-not-in-cl-package "null") nil)
(deftest symbol-number (test-if-not-in-cl-package "number") nil)
(deftest symbol-numberp (test-if-not-in-cl-package "numberp") nil)
(deftest symbol-numerator (test-if-not-in-cl-package "numerator") nil)
(deftest symbol-nunion (test-if-not-in-cl-package "nunion") nil)
(deftest symbol-oddp (test-if-not-in-cl-package "oddp") nil)
(deftest symbol-open (test-if-not-in-cl-package "open") nil)
(deftest symbol-open-stream-p (test-if-not-in-cl-package "open-stream-p") nil)
(deftest symbol-optimize (test-if-not-in-cl-package "optimize") nil)
(deftest symbol-or (test-if-not-in-cl-package "or") nil)
(deftest symbol-otherwise (test-if-not-in-cl-package "otherwise") nil)
(deftest symbol-output-stream-p (test-if-not-in-cl-package "output-stream-p") nil)
(deftest symbol-package (test-if-not-in-cl-package "package") nil)
(deftest symbol-package-error (test-if-not-in-cl-package "package-error") nil)
(deftest symbol-package-error-package (test-if-not-in-cl-package "package-error-package") nil)
(deftest symbol-package-name (test-if-not-in-cl-package "package-name") nil)
(deftest symbol-package-nicknames (test-if-not-in-cl-package "package-nicknames") nil)
(deftest symbol-package-shadowing-symbols (test-if-not-in-cl-package "package-shadowing-symbols") nil)
(deftest symbol-package-use-list (test-if-not-in-cl-package "package-use-list") nil)
(deftest symbol-package-used-by-list (test-if-not-in-cl-package "package-used-by-list") nil)
(deftest symbol-packagep (test-if-not-in-cl-package "packagep") nil)
(deftest symbol-pairlis (test-if-not-in-cl-package "pairlis") nil)
(deftest symbol-parse-error (test-if-not-in-cl-package "parse-error") nil)
(deftest symbol-parse-integer (test-if-not-in-cl-package "parse-integer") nil)
(deftest symbol-parse-namestring (test-if-not-in-cl-package "parse-namestring") nil)
(deftest symbol-pathname (test-if-not-in-cl-package "pathname") nil)
(deftest symbol-pathname-device (test-if-not-in-cl-package "pathname-device") nil)
(deftest symbol-pathname-directory (test-if-not-in-cl-package "pathname-directory") nil)
(deftest symbol-pathname-host (test-if-not-in-cl-package "pathname-host") nil)
(deftest symbol-pathname-match-p (test-if-not-in-cl-package "pathname-match-p") nil)
(deftest symbol-pathname-name (test-if-not-in-cl-package "pathname-name") nil)
(deftest symbol-pathname-type (test-if-not-in-cl-package "pathname-type") nil)
(deftest symbol-pathname-version (test-if-not-in-cl-package "pathname-version") nil)
(deftest symbol-pathnamep (test-if-not-in-cl-package "pathnamep") nil)
(deftest symbol-peek-char (test-if-not-in-cl-package "peek-char") nil)
(deftest symbol-phase (test-if-not-in-cl-package "phase") nil)
(deftest symbol-pi (test-if-not-in-cl-package "pi") nil)
(deftest symbol-plusp (test-if-not-in-cl-package "plusp") nil)
(deftest symbol-pop (test-if-not-in-cl-package "pop") nil)
(deftest symbol-position (test-if-not-in-cl-package "position") nil)
(deftest symbol-position-if (test-if-not-in-cl-package "position-if") nil)
(deftest symbol-position-if-not (test-if-not-in-cl-package "position-if-not") nil)
(deftest symbol-pprint (test-if-not-in-cl-package "pprint") nil)
(deftest symbol-pprint-dispatch (test-if-not-in-cl-package "pprint-dispatch") nil)
(deftest symbol-pprint-exit-if-list-exhausted (test-if-not-in-cl-package "pprint-exit-if-list-exhausted") nil)
(deftest symbol-pprint-fill (test-if-not-in-cl-package "pprint-fill") nil)
(deftest symbol-pprint-indent (test-if-not-in-cl-package "pprint-indent") nil)
(deftest symbol-pprint-linear (test-if-not-in-cl-package "pprint-linear") nil)
(deftest symbol-pprint-logical-block (test-if-not-in-cl-package "pprint-logical-block") nil)
(deftest symbol-pprint-newline (test-if-not-in-cl-package "pprint-newline") nil)
(deftest symbol-pprint-pop (test-if-not-in-cl-package "pprint-pop") nil)
(deftest symbol-pprint-tab (test-if-not-in-cl-package "pprint-tab") nil)
(deftest symbol-pprint-tabular (test-if-not-in-cl-package "pprint-tabular") nil)
(deftest symbol-prin1 (test-if-not-in-cl-package "prin1") nil)
(deftest symbol-prin1-to-string (test-if-not-in-cl-package "prin1-to-string") nil)
(deftest symbol-princ (test-if-not-in-cl-package "princ") nil)
(deftest symbol-princ-to-string (test-if-not-in-cl-package "princ-to-string") nil)
(deftest symbol-print (test-if-not-in-cl-package "print") nil)
(deftest symbol-print-not-readable (test-if-not-in-cl-package "print-not-readable") nil)
(deftest symbol-print-not-readable-object (test-if-not-in-cl-package "print-not-readable-object") nil)
(deftest symbol-print-object (test-if-not-in-cl-package "print-object") nil)
(deftest symbol-print-unreadable-object (test-if-not-in-cl-package "print-unreadable-object") nil)
(deftest symbol-probe-file (test-if-not-in-cl-package "probe-file") nil)
(deftest symbol-proclaim (test-if-not-in-cl-package "proclaim") nil)
(deftest symbol-prog (test-if-not-in-cl-package "prog") nil)
(deftest symbol-prog* (test-if-not-in-cl-package "prog*") nil)
(deftest symbol-prog1 (test-if-not-in-cl-package "prog1") nil)
(deftest symbol-prog2 (test-if-not-in-cl-package "prog2") nil)
(deftest symbol-progn (test-if-not-in-cl-package "progn") nil)
(deftest symbol-program-error (test-if-not-in-cl-package "program-error") nil)
(deftest symbol-progv (test-if-not-in-cl-package "progv") nil)
(deftest symbol-provide (test-if-not-in-cl-package "provide") nil)
(deftest symbol-psetf (test-if-not-in-cl-package "psetf") nil)
(deftest symbol-psetq (test-if-not-in-cl-package "psetq") nil)
(deftest symbol-push (test-if-not-in-cl-package "push") nil)
(deftest symbol-pushnew (test-if-not-in-cl-package "pushnew") nil)
(deftest symbol-quote (test-if-not-in-cl-package "quote") nil)
(deftest symbol-random (test-if-not-in-cl-package "random") nil)
(deftest symbol-random-state (test-if-not-in-cl-package "random-state") nil)
(deftest symbol-random-state-p (test-if-not-in-cl-package "random-state-p") nil)
(deftest symbol-rassoc (test-if-not-in-cl-package "rassoc") nil)
(deftest symbol-rassoc-if (test-if-not-in-cl-package "rassoc-if") nil)
(deftest symbol-rassoc-if-not (test-if-not-in-cl-package "rassoc-if-not") nil)
(deftest symbol-ratio (test-if-not-in-cl-package "ratio") nil)
(deftest symbol-rational (test-if-not-in-cl-package "rational") nil)
(deftest symbol-rationalize (test-if-not-in-cl-package "rationalize") nil)
(deftest symbol-rationalp (test-if-not-in-cl-package "rationalp") nil)
(deftest symbol-read (test-if-not-in-cl-package "read") nil)
(deftest symbol-read-byte (test-if-not-in-cl-package "read-byte") nil)
(deftest symbol-read-char (test-if-not-in-cl-package "read-char") nil)
(deftest symbol-read-char-no-hang (test-if-not-in-cl-package "read-char-no-hang") nil)
(deftest symbol-read-delimited-list (test-if-not-in-cl-package "read-delimited-list") nil)
(deftest symbol-read-from-string (test-if-not-in-cl-package "read-from-string") nil)
(deftest symbol-read-line (test-if-not-in-cl-package "read-line") nil)
(deftest symbol-read-preserving-whitespace (test-if-not-in-cl-package "read-preserving-whitespace") nil)
(deftest symbol-read-sequence (test-if-not-in-cl-package "read-sequence") nil)
(deftest symbol-reader-error (test-if-not-in-cl-package "reader-error") nil)
(deftest symbol-readtable (test-if-not-in-cl-package "readtable") nil)
(deftest symbol-readtable-case (test-if-not-in-cl-package "readtable-case") nil)
(deftest symbol-readtablep (test-if-not-in-cl-package "readtablep") nil)
(deftest symbol-real (test-if-not-in-cl-package "real") nil)
(deftest symbol-realp (test-if-not-in-cl-package "realp") nil)
(deftest symbol-realpart (test-if-not-in-cl-package "realpart") nil)
(deftest symbol-reduce (test-if-not-in-cl-package "reduce") nil)
(deftest symbol-reinitialize-instance (test-if-not-in-cl-package "reinitialize-instance") nil)
(deftest symbol-rem (test-if-not-in-cl-package "rem") nil)
(deftest symbol-remf (test-if-not-in-cl-package "remf") nil)
(deftest symbol-remhash (test-if-not-in-cl-package "remhash") nil)
(deftest symbol-remove (test-if-not-in-cl-package "remove") nil)
(deftest symbol-remove-duplicates (test-if-not-in-cl-package "remove-duplicates") nil)
(deftest symbol-remove-if (test-if-not-in-cl-package "remove-if") nil)
(deftest symbol-remove-if-not (test-if-not-in-cl-package "remove-if-not") nil)
(deftest symbol-remove-method (test-if-not-in-cl-package "remove-method") nil)
(deftest symbol-remprop (test-if-not-in-cl-package "remprop") nil)
(deftest symbol-rename-file (test-if-not-in-cl-package "rename-file") nil)
(deftest symbol-rename-package (test-if-not-in-cl-package "rename-package") nil)
(deftest symbol-replace (test-if-not-in-cl-package "replace") nil)
(deftest symbol-require (test-if-not-in-cl-package "require") nil)
(deftest symbol-rest (test-if-not-in-cl-package "rest") nil)
(deftest symbol-restart (test-if-not-in-cl-package "restart") nil)
(deftest symbol-restart-bind (test-if-not-in-cl-package "restart-bind") nil)
(deftest symbol-restart-case (test-if-not-in-cl-package "restart-case") nil)
(deftest symbol-restart-name (test-if-not-in-cl-package "restart-name") nil)
(deftest symbol-return (test-if-not-in-cl-package "return") nil)
(deftest symbol-return-from (test-if-not-in-cl-package "return-from") nil)
(deftest symbol-revappend (test-if-not-in-cl-package "revappend") nil)
(deftest symbol-reverse (test-if-not-in-cl-package "reverse") nil)
(deftest symbol-room (test-if-not-in-cl-package "room") nil)
(deftest symbol-rotatef (test-if-not-in-cl-package "rotatef") nil)
(deftest symbol-round (test-if-not-in-cl-package "round") nil)
(deftest symbol-row-major-aref (test-if-not-in-cl-package "row-major-aref") nil)
(deftest symbol-rplaca (test-if-not-in-cl-package "rplaca") nil)
(deftest symbol-rplacd (test-if-not-in-cl-package "rplacd") nil)
(deftest symbol-safety (test-if-not-in-cl-package "safety") nil)
(deftest symbol-satisfies (test-if-not-in-cl-package "satisfies") nil)
(deftest symbol-sbit (test-if-not-in-cl-package "sbit") nil)
(deftest symbol-scale-float (test-if-not-in-cl-package "scale-float") nil)
(deftest symbol-schar (test-if-not-in-cl-package "schar") nil)
(deftest symbol-search (test-if-not-in-cl-package "search") nil)
(deftest symbol-second (test-if-not-in-cl-package "second") nil)
(deftest symbol-sequence (test-if-not-in-cl-package "sequence") nil)
(deftest symbol-serious-condition (test-if-not-in-cl-package "serious-condition") nil)
(deftest symbol-set (test-if-not-in-cl-package "set") nil)
(deftest symbol-set-difference (test-if-not-in-cl-package "set-difference") nil)
(deftest symbol-set-dispatch-macro-character (test-if-not-in-cl-package "set-dispatch-macro-character") nil)
(deftest symbol-set-exclusive-or (test-if-not-in-cl-package "set-exclusive-or") nil)
(deftest symbol-set-macro-character (test-if-not-in-cl-package "set-macro-character") nil)
(deftest symbol-set-pprint-dispatch (test-if-not-in-cl-package "set-pprint-dispatch") nil)
(deftest symbol-set-syntax-from-char (test-if-not-in-cl-package "set-syntax-from-char") nil)
(deftest symbol-setf (test-if-not-in-cl-package "setf") nil)
(deftest symbol-setq (test-if-not-in-cl-package "setq") nil)
(deftest symbol-seventh (test-if-not-in-cl-package "seventh") nil)
(deftest symbol-shadow (test-if-not-in-cl-package "shadow") nil)
(deftest symbol-shadowing-import (test-if-not-in-cl-package "shadowing-import") nil)
(deftest symbol-shared-initialize (test-if-not-in-cl-package "shared-initialize") nil)
(deftest symbol-shiftf (test-if-not-in-cl-package "shiftf") nil)
(deftest symbol-short-float (test-if-not-in-cl-package "short-float") nil)
(deftest symbol-short-float-epsilon (test-if-not-in-cl-package "short-float-epsilon") nil)
(deftest symbol-short-float-negative-epsilon (test-if-not-in-cl-package "short-float-negative-epsilon") nil)
(deftest symbol-short-site-name (test-if-not-in-cl-package "short-site-name") nil)
(deftest symbol-signal (test-if-not-in-cl-package "signal") nil)
(deftest symbol-signed-byte (test-if-not-in-cl-package "signed-byte") nil)
(deftest symbol-signum (test-if-not-in-cl-package "signum") nil)
(deftest symbol-simple-array (test-if-not-in-cl-package "simple-array") nil)
(deftest symbol-simple-base-string (test-if-not-in-cl-package "simple-base-string") nil)
(deftest symbol-simple-bit-vector (test-if-not-in-cl-package "simple-bit-vector") nil)
(deftest symbol-simple-bit-vector-p (test-if-not-in-cl-package "simple-bit-vector-p") nil)
(deftest symbol-simple-condition (test-if-not-in-cl-package "simple-condition") nil)
(deftest symbol-simple-condition-format-arguments (test-if-not-in-cl-package "simple-condition-format-arguments") nil)
(deftest symbol-simple-condition-format-control (test-if-not-in-cl-package "simple-condition-format-control") nil)
(deftest symbol-simple-error (test-if-not-in-cl-package "simple-error") nil)
(deftest symbol-simple-string (test-if-not-in-cl-package "simple-string") nil)
(deftest symbol-simple-string-p (test-if-not-in-cl-package "simple-string-p") nil)
(deftest symbol-simple-type-error (test-if-not-in-cl-package "simple-type-error") nil)
(deftest symbol-simple-vector (test-if-not-in-cl-package "simple-vector") nil)
(deftest symbol-simple-vector-p (test-if-not-in-cl-package "simple-vector-p") nil)
(deftest symbol-simple-warning (test-if-not-in-cl-package "simple-warning") nil)
(deftest symbol-sin (test-if-not-in-cl-package "sin") nil)
(deftest symbol-single-float (test-if-not-in-cl-package "single-float") nil)
(deftest symbol-single-float-epsilon (test-if-not-in-cl-package "single-float-epsilon") nil)
(deftest symbol-single-float-negative-epsilon (test-if-not-in-cl-package "single-float-negative-epsilon") nil)
(deftest symbol-sinh (test-if-not-in-cl-package "sinh") nil)
(deftest symbol-sixth (test-if-not-in-cl-package "sixth") nil)
(deftest symbol-sleep (test-if-not-in-cl-package "sleep") nil)
(deftest symbol-slot-boundp (test-if-not-in-cl-package "slot-boundp") nil)
(deftest symbol-slot-exists-p (test-if-not-in-cl-package "slot-exists-p") nil)
(deftest symbol-slot-makunbound (test-if-not-in-cl-package "slot-makunbound") nil)
(deftest symbol-slot-missing (test-if-not-in-cl-package "slot-missing") nil)
(deftest symbol-slot-unbound (test-if-not-in-cl-package "slot-unbound") nil)
(deftest symbol-slot-value (test-if-not-in-cl-package "slot-value") nil)
(deftest symbol-software-type (test-if-not-in-cl-package "software-type") nil)
(deftest symbol-software-version (test-if-not-in-cl-package "software-version") nil)
(deftest symbol-some (test-if-not-in-cl-package "some") nil)
(deftest symbol-sort (test-if-not-in-cl-package "sort") nil)
(deftest symbol-space (test-if-not-in-cl-package "space") nil)
(deftest symbol-special (test-if-not-in-cl-package "special") nil)
(deftest symbol-special-operator-p (test-if-not-in-cl-package "special-operator-p") nil)
(deftest symbol-speed (test-if-not-in-cl-package "speed") nil)
(deftest symbol-sqrt (test-if-not-in-cl-package "sqrt") nil)
(deftest symbol-stable-sort (test-if-not-in-cl-package "stable-sort") nil)
(deftest symbol-standard (test-if-not-in-cl-package "standard") nil)
(deftest symbol-standard-char (test-if-not-in-cl-package "standard-char") nil)
(deftest symbol-standard-char-p (test-if-not-in-cl-package "standard-char-p") nil)
(deftest symbol-standard-class (test-if-not-in-cl-package "standard-class") nil)
(deftest symbol-standard-generic-function (test-if-not-in-cl-package "standard-generic-function") nil)
(deftest symbol-standard-method (test-if-not-in-cl-package "standard-method") nil)
(deftest symbol-standard-object (test-if-not-in-cl-package "standard-object") nil)
(deftest symbol-step (test-if-not-in-cl-package "step") nil)
(deftest symbol-storage-condition (test-if-not-in-cl-package "storage-condition") nil)
(deftest symbol-store-value (test-if-not-in-cl-package "store-value") nil)
(deftest symbol-stream (test-if-not-in-cl-package "stream") nil)
(deftest symbol-stream-element-type (test-if-not-in-cl-package "stream-element-type") nil)
(deftest symbol-stream-error (test-if-not-in-cl-package "stream-error") nil)
(deftest symbol-stream-error-stream (test-if-not-in-cl-package "stream-error-stream") nil)
(deftest symbol-stream-external-format (test-if-not-in-cl-package "stream-external-format") nil)
(deftest symbol-streamp (test-if-not-in-cl-package "streamp") nil)
(deftest symbol-string (test-if-not-in-cl-package "string") nil)
(deftest symbol-string-capitalize (test-if-not-in-cl-package "string-capitalize") nil)
(deftest symbol-string-downcase (test-if-not-in-cl-package "string-downcase") nil)
(deftest symbol-string-equal (test-if-not-in-cl-package "string-equal") nil)
(deftest symbol-string-greaterp (test-if-not-in-cl-package "string-greaterp") nil)
(deftest symbol-string-left-trim (test-if-not-in-cl-package "string-left-trim") nil)
(deftest symbol-string-lessp (test-if-not-in-cl-package "string-lessp") nil)
(deftest symbol-string-not-equal (test-if-not-in-cl-package "string-not-equal") nil)
(deftest symbol-string-not-greaterp (test-if-not-in-cl-package "string-not-greaterp") nil)
(deftest symbol-string-not-lessp (test-if-not-in-cl-package "string-not-lessp") nil)
(deftest symbol-string-right-trim (test-if-not-in-cl-package "string-right-trim") nil)
(deftest symbol-string-stream (test-if-not-in-cl-package "string-stream") nil)
(deftest symbol-string-trim (test-if-not-in-cl-package "string-trim") nil)
(deftest symbol-string-upcase (test-if-not-in-cl-package "string-upcase") nil)
(deftest symbol-string/= (test-if-not-in-cl-package "string/=") nil)
(deftest symbol-string< (test-if-not-in-cl-package "string<") nil)
(deftest symbol-string<= (test-if-not-in-cl-package "string<=") nil)
(deftest symbol-string= (test-if-not-in-cl-package "string=") nil)
(deftest symbol-string> (test-if-not-in-cl-package "string>") nil)
(deftest symbol-string>= (test-if-not-in-cl-package "string>=") nil)
(deftest symbol-stringp (test-if-not-in-cl-package "stringp") nil)
(deftest symbol-structure (test-if-not-in-cl-package "structure") nil)
(deftest symbol-structure-class (test-if-not-in-cl-package "structure-class") nil)
(deftest symbol-structure-object (test-if-not-in-cl-package "structure-object") nil)
(deftest symbol-style-warning (test-if-not-in-cl-package "style-warning") nil)
(deftest symbol-sublis (test-if-not-in-cl-package "sublis") nil)
(deftest symbol-subseq (test-if-not-in-cl-package "subseq") nil)
(deftest symbol-subsetp (test-if-not-in-cl-package "subsetp") nil)
(deftest symbol-subst (test-if-not-in-cl-package "subst") nil)
(deftest symbol-subst-if (test-if-not-in-cl-package "subst-if") nil)
(deftest symbol-subst-if-not (test-if-not-in-cl-package "subst-if-not") nil)
(deftest symbol-substitute (test-if-not-in-cl-package "substitute") nil)
(deftest symbol-substitute-if (test-if-not-in-cl-package "substitute-if") nil)
(deftest symbol-substitute-if-not (test-if-not-in-cl-package "substitute-if-not") nil)
(deftest symbol-subtypep (test-if-not-in-cl-package "subtypep") nil)
(deftest symbol-svref (test-if-not-in-cl-package "svref") nil)
(deftest symbol-sxhash (test-if-not-in-cl-package "sxhash") nil)
(deftest symbol-symbol (test-if-not-in-cl-package "symbol") nil)
(deftest symbol-symbol-function (test-if-not-in-cl-package "symbol-function") nil)
(deftest symbol-symbol-macrolet (test-if-not-in-cl-package "symbol-macrolet") nil)
(deftest symbol-symbol-name (test-if-not-in-cl-package "symbol-name") nil)
(deftest symbol-symbol-package (test-if-not-in-cl-package "symbol-package") nil)
(deftest symbol-symbol-plist (test-if-not-in-cl-package "symbol-plist") nil)
(deftest symbol-symbol-value (test-if-not-in-cl-package "symbol-value") nil)
(deftest symbol-symbolp (test-if-not-in-cl-package "symbolp") nil)
(deftest symbol-synonym-stream (test-if-not-in-cl-package "synonym-stream") nil)
(deftest symbol-synonym-stream-symbol (test-if-not-in-cl-package "synonym-stream-symbol") nil)
(deftest symbol-t (test-if-not-in-cl-package "t") nil)
(deftest symbol-tagbody (test-if-not-in-cl-package "tagbody") nil)
(deftest symbol-tailp (test-if-not-in-cl-package "tailp") nil)
(deftest symbol-tan (test-if-not-in-cl-package "tan") nil)
(deftest symbol-tanh (test-if-not-in-cl-package "tanh") nil)
(deftest symbol-tenth (test-if-not-in-cl-package "tenth") nil)
(deftest symbol-terpri (test-if-not-in-cl-package "terpri") nil)
(deftest symbol-the (test-if-not-in-cl-package "the") nil)
(deftest symbol-third (test-if-not-in-cl-package "third") nil)
(deftest symbol-throw (test-if-not-in-cl-package "throw") nil)
(deftest symbol-time (test-if-not-in-cl-package "time") nil)
(deftest symbol-trace (test-if-not-in-cl-package "trace") nil)
(deftest symbol-translate-logical-pathname (test-if-not-in-cl-package "translate-logical-pathname") nil)
(deftest symbol-translate-pathname (test-if-not-in-cl-package "translate-pathname") nil)
(deftest symbol-tree-equal (test-if-not-in-cl-package "tree-equal") nil)
(deftest symbol-truename (test-if-not-in-cl-package "truename") nil)
(deftest symbol-truncate (test-if-not-in-cl-package "truncate") nil)
(deftest symbol-two-way-stream (test-if-not-in-cl-package "two-way-stream") nil)
(deftest symbol-two-way-stream-input-stream (test-if-not-in-cl-package "two-way-stream-input-stream") nil)
(deftest symbol-two-way-stream-output-stream (test-if-not-in-cl-package "two-way-stream-output-stream") nil)
(deftest symbol-type (test-if-not-in-cl-package "type") nil)
(deftest symbol-type-error (test-if-not-in-cl-package "type-error") nil)
(deftest symbol-type-error-datum (test-if-not-in-cl-package "type-error-datum") nil)
(deftest symbol-type-error-expected-type (test-if-not-in-cl-package "type-error-expected-type") nil)
(deftest symbol-type-of (test-if-not-in-cl-package "type-of") nil)
(deftest symbol-typecase (test-if-not-in-cl-package "typecase") nil)
(deftest symbol-typep (test-if-not-in-cl-package "typep") nil)
(deftest symbol-unbound-slot (test-if-not-in-cl-package "unbound-slot") nil)
(deftest symbol-unbound-slot-instance (test-if-not-in-cl-package "unbound-slot-instance") nil)
(deftest symbol-unbound-variable (test-if-not-in-cl-package "unbound-variable") nil)
(deftest symbol-undefined-function (test-if-not-in-cl-package "undefined-function") nil)
(deftest symbol-unexport (test-if-not-in-cl-package "unexport") nil)
(deftest symbol-unintern (test-if-not-in-cl-package "unintern") nil)
(deftest symbol-union (test-if-not-in-cl-package "union") nil)
(deftest symbol-unless (test-if-not-in-cl-package "unless") nil)
(deftest symbol-unread-char (test-if-not-in-cl-package "unread-char") nil)
(deftest symbol-unsigned-byte (test-if-not-in-cl-package "unsigned-byte") nil)
(deftest symbol-untrace (test-if-not-in-cl-package "untrace") nil)
(deftest symbol-unuse-package (test-if-not-in-cl-package "unuse-package") nil)
(deftest symbol-unwind-protect (test-if-not-in-cl-package "unwind-protect") nil)
(deftest symbol-update-instance-for-different-class (test-if-not-in-cl-package "update-instance-for-different-class") nil)
(deftest symbol-update-instance-for-redefined-class (test-if-not-in-cl-package "update-instance-for-redefined-class") nil)
(deftest symbol-upgraded-array-element-type (test-if-not-in-cl-package "upgraded-array-element-type") nil)
(deftest symbol-upgraded-complex-part-type (test-if-not-in-cl-package "upgraded-complex-part-type") nil)
(deftest symbol-upper-case-p (test-if-not-in-cl-package "upper-case-p") nil)
(deftest symbol-use-package (test-if-not-in-cl-package "use-package") nil)
(deftest symbol-use-value (test-if-not-in-cl-package "use-value") nil)
(deftest symbol-user-homedir-pathname (test-if-not-in-cl-package "user-homedir-pathname") nil)
(deftest symbol-values (test-if-not-in-cl-package "values") nil)
(deftest symbol-values-list (test-if-not-in-cl-package "values-list") nil)
(deftest symbol-variable (test-if-not-in-cl-package "variable") nil)
(deftest symbol-vector (test-if-not-in-cl-package "vector") nil)
(deftest symbol-vector-pop (test-if-not-in-cl-package "vector-pop") nil)
(deftest symbol-vector-push (test-if-not-in-cl-package "vector-push") nil)
(deftest symbol-vector-push-extend (test-if-not-in-cl-package "vector-push-extend") nil)
(deftest symbol-vectorp (test-if-not-in-cl-package "vectorp") nil)
(deftest symbol-warn (test-if-not-in-cl-package "warn") nil)
(deftest symbol-warning (test-if-not-in-cl-package "warning") nil)
(deftest symbol-when (test-if-not-in-cl-package "when") nil)
(deftest symbol-wild-pathname-p (test-if-not-in-cl-package "wild-pathname-p") nil)
(deftest symbol-with-accessors (test-if-not-in-cl-package "with-accessors") nil)
(deftest symbol-with-compilation-unit (test-if-not-in-cl-package "with-compilation-unit") nil)
(deftest symbol-with-condition-restarts (test-if-not-in-cl-package "with-condition-restarts") nil)
(deftest symbol-with-hash-table-iterator (test-if-not-in-cl-package "with-hash-table-iterator") nil)
(deftest symbol-with-input-from-string (test-if-not-in-cl-package "with-input-from-string") nil)
(deftest symbol-with-open-file (test-if-not-in-cl-package "with-open-file") nil)
(deftest symbol-with-open-stream (test-if-not-in-cl-package "with-open-stream") nil)
(deftest symbol-with-output-to-string (test-if-not-in-cl-package "with-output-to-string") nil)
(deftest symbol-with-package-iterator (test-if-not-in-cl-package "with-package-iterator") nil)
(deftest symbol-with-simple-restart (test-if-not-in-cl-package "with-simple-restart") nil)
(deftest symbol-with-slots (test-if-not-in-cl-package "with-slots") nil)
(deftest symbol-with-standard-io-syntax (test-if-not-in-cl-package "with-standard-io-syntax") nil)
(deftest symbol-write (test-if-not-in-cl-package "write") nil)
(deftest symbol-write-byte (test-if-not-in-cl-package "write-byte") nil)
(deftest symbol-write-char (test-if-not-in-cl-package "write-char") nil)
(deftest symbol-write-line (test-if-not-in-cl-package "write-line") nil)
(deftest symbol-write-sequence (test-if-not-in-cl-package "write-sequence") nil)
(deftest symbol-write-string (test-if-not-in-cl-package "write-string") nil)
(deftest symbol-write-to-string (test-if-not-in-cl-package "write-to-string") nil)
(deftest symbol-y-or-n-p (test-if-not-in-cl-package "y-or-n-p") nil)
(deftest symbol-yes-or-no-p (test-if-not-in-cl-package "yes-or-no-p") nil)
(deftest symbol-zerop (test-if-not-in-cl-package "zerop") nil)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Test that all keywords have themselves as their value,
;;; are external if present in KEYWORD, and have themselves
;;; as their values (and are constant).  Symbols that are
;;; merely used in KEYWORD but not present there are exempt.

(deftest keyword-behavior
  (let ((result nil)
	(keyword-package (find-package "KEYWORD")))
    (do-symbols (s keyword-package result)
      (multiple-value-bind (sym status)
	  (find-symbol (symbol-name s) keyword-package)
	(cond
	 ((not (eqt s sym)) (push (list s sym) result))
	 ((eqt status :internal)
	  (push (list s status) result))
	 ((eqt status :external)
	  (unless (and (eqt (symbol-value s) s)
		       (constantp s))
	    (push (list s sym 'not-constant) result)))))))
  nil)


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; special-operator-p


;;; See section 3.1.2.1.2.1
(defparameter +special-operators+
  '(block let* return-from catch load-time-value setq eval-when
	  locally symbol-macrolet flet macrolet tagbody function
	  multiple-value-call the go multiple-value-prog1 throw if
	  progn unwind-protect labels progv let quote))


;;; All the symbols in +special-operators+ are special operators
(deftest special-operator-p.1
  (loop for s in +special-operators+
	unless (special-operator-p s)
	collect s)
  nil)

;;; None of the standard symbols except those in +special-operators+
;;; are special operators, unless they have a macro function
;;; (See the page for MACRO-FUNCTION)

(deftest special-operator-p.2
  (let ((p (find-package "CL")))
    (loop for name in *cl-symbol-names*
	  unless (or (member name +special-operators+ :test #'string=)
		     (let ((sym (find-symbol name p)))
		       (or (not (special-operator-p sym))
			   (macro-function sym))))
	  collect name))
  nil)

(deftest special-operator-p.order.1
  (let ((i 0))
    (values (notnot (special-operator-p (progn (incf i) 'catch)))
	    i))
  t 1)

(deftest special-operator-p.error.1
  (classify-error (special-operator-p 1))
  type-error)

(deftest special-operator-p.error.2
  (classify-error (special-operator-p))
  program-error)

(deftest special-operator-p.error.3
  (classify-error (special-operator-p 'cons 'cons))
  program-error)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; keywordp

(deftest keywordp.1 (keywordp 'hefalump)   nil)
(deftest keywordp.2 (keywordp 17)          nil)
(deftest keywordp.3 (notnot-mv (keywordp :stream))         t)
(deftest keywordp.4 (notnot-mv (keywordp ':stream))        t)
(deftest keywordp.5 (keywordp nil)         nil)
(deftest keywordp.6 (notnot-mv (keywordp :nil))          t)
(deftest keywordp.7 (keywordp '(:stream))    nil)
(deftest keywordp.8 (keywordp "rest")     nil)
(deftest keywordp.9 (keywordp ":rest")    nil)
(deftest keywordp.10 (keywordp '&body) nil)
;;; This next test was busted.  ::foo is not portable syntax
;;(deftest keywordp.11 (notnot-mv (keywordp ::foo))       t)
(deftest keywordp.12 (keywordp t)          nil)

(deftest keywordp.order.1
  (let ((i 0))
    (values (keywordp (progn (incf i) nil)) i))
  nil 1)

(deftest keywordp.error.1 (classify-error (keywordp)) program-error)
(deftest keywordp.error.2 (classify-error (keywordp :x :x)) program-error)

(deftest keywordp.error.3
  (classify-error (keywordp))
  program-error)

(deftest keywordp.error.4
  (classify-error (keywordp nil nil))
  program-error)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; symbol-name

(deftest symbol-name.1
  (symbol-name '|ABCD|)
  "ABCD")

(deftest symbol-name.2
  (symbol-name '|1234abcdABCD|)
  "1234abcdABCD")

(deftest symbol-name.3
  (classify-error (symbol-name 1))
  type-error)

(deftest symbol-name.4
  (classify-error (symbol-name '(a)))
  type-error)

(deftest symbol-name.5
  (classify-error (symbol-name "ABCDE"))
  type-error)

(deftest symbol-name.6
  (classify-error (symbol-name 12913.0213))
  type-error)

(deftest symbol-name.7
  (symbol-name :|abcdefg|)
  "abcdefg")

(deftest symbol-name.error.1
  (classify-error (symbol-name))
  program-error)

(deftest symbol-name.error.2
  (classify-error (symbol-name 'a 'b))
  program-error)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; make-symbol

(deftest make-symbol.1
  (notnot-mv (symbolp (make-symbol "FOO")))
  t)

(deftest make-symbol.2
  (symbol-package (make-symbol "BAR"))
  nil)

(deftest make-symbol.3
  (symbol-package (make-symbol "CL::FOO"))
  nil)

(deftest make-symbol.4
  (symbol-package (make-symbol "CL:FOO"))
  nil)

(deftest make-symbol.5
  (symbol-name (make-symbol "xyz"))
  "xyz")

(deftest make-symbol.6
    (eqt (make-symbol "A")
	(make-symbol "A"))
  nil)

(deftest make-symbol.7
  (boundp (make-symbol "B"))
  nil)

(deftest make-symbol.8
  (symbol-plist (make-symbol "C"))
  nil)

(deftest make-symbol.9
  (fboundp (make-symbol "D"))
  nil)

(deftest make-symbol.10
  (symbol-name (make-symbol ""))
  "")

(deftest make-symbol.order.1
  (let ((i 0))
    (values
     (symbol-name (make-symbol (progn (incf i) "ABC")))
     i))
  "ABC" 1)

(deftest make-symbol.error.1
  (classify-error (make-symbol nil))
  type-error)

(deftest make-symbol.error.2
  (classify-error (make-symbol 'a))
  type-error)

(deftest make-symbol.error.3
  (classify-error (make-symbol 1))
  type-error)

(deftest make-symbol.error.4
  (classify-error (make-symbol -1))
  type-error)

(deftest make-symbol.error.5
  (classify-error (make-symbol 1.213))
  type-error)

(deftest make-symbol.error.6
  (classify-error (make-symbol -1312.2))
  type-error)

(deftest make-symbol.error.7
  (classify-error (make-symbol #\w))
  type-error)

(deftest make-symbol.error.8
  (classify-error (make-symbol '(a)))
  type-error)

(deftest make-symbol.error.9
  (classify-error (make-symbol))
  program-error)

(deftest make-symbol.error.10
  (classify-error (make-symbol "a" "a"))
  program-error)

(deftest make-symbol.error.11
  (classify-error (make-symbol '(#\a #\b #\c)))
  type-error)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; copy-symbol

(deftest copy-symbol.1
  (notnot-mv
   (every
    #'(lambda (x)
	(let ((y (copy-symbol x)))
	  (and (null (symbol-plist y))
	       (symbolp y)
	       (not (boundp y))
	       (not (fboundp y))
	       (null (symbol-package y))
	       (string= (symbol-name x) (symbol-name y))
	       (symbolp (copy-symbol y))
	       )))
    '(nil t a b |a| |123|)))
  t)

(deftest copy-symbol.2
  (progn
    (setf (symbol-plist '|foo|) '(a b c d))
    (makunbound '|foo|)
    (notnot-mv
     (every
      #'(lambda (x)
	  (let ((y (copy-symbol x t)))
	    (and
	     (equal (symbol-plist y) (symbol-plist x))
	     (symbolp y)
	     (if (boundp x)
		 (boundp y)
	       (not (boundp y)))
	     (if (fboundp x) (fboundp y) (not (fboundp y)))
	     (null (symbol-package y))
	     (string= (symbol-name x) (symbol-name y))
	     )))
      '(nil t a b |foo| |a| |123|))))
  t)

(deftest copy-symbol.3
  (progn
    (setf (symbol-plist '|foo|) '(a b c d))
    (setf (symbol-value '|a|) 12345)
    (notnot-mv
     (every
      #'(lambda (x)
	  (let ((y (copy-symbol x t)))
	    (and
	     (eql (length (symbol-plist y))
		  (length (symbol-plist x)))
	     ;; Is a list copy
	     (every #'eq (symbol-plist y) (symbol-plist x))
	     (symbolp y)
	     (if (boundp x)
		 (eqt (symbol-value x)
		      (symbol-value y))
	       (not (boundp y)))
	     (if (fboundp x) (fboundp y) (not (fboundp y)))
	     (null (symbol-package y))
	     (string= (symbol-name x) (symbol-name y))
	     (eql (length (symbol-plist x))
		  (length (symbol-plist y)))
	     )))
      '(nil t a b |foo| |a| |123|))))
  t)

(deftest copy-symbol.4
  (eqt (copy-symbol 'a) (copy-symbol 'a))
  nil)

(deftest copy-symbol.5
  (let ((i 0) x y (s '#:|x|))
    (let ((s2 (copy-symbol
	       (progn (setf x (incf i)) s)
	       (progn (setf y (incf i)) nil))))
      (values
       (symbol-name s2)
       (eq s s2)
       i x y)))
  "x" nil 2 1 2)

(deftest copy-symbol.error.1
  (classify-error (copy-symbol))
  program-error)

(deftest copy-symbol.error.2
  (classify-error (copy-symbol 'a t 'foo))
  program-error)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; gensym

;;; Gensym returns unique symbols
(deftest gensym.1
  (equal (gensym) (gensym))
  nil)

;;; Gensym returns symbols with distinct print names
(deftest gensym.2
  (string= (symbol-name (gensym))
	   (symbol-name (gensym)))
  nil)

;;; Gensym uses the *gensym-counter* special variable,
;;; but does not increment it until after the symbol
;;; has been created.
(deftest gensym.3
  (let ((*gensym-counter* 1))
    (declare (special *gensym-counter*))
     (symbol-name (gensym)))
  #.(string '#:g1))

;;; Gensym uses the string argument instead of the default
(deftest gensym.4
  (let ((*gensym-counter* 1327))
    (declare (special *gensym-counter*))
    (symbol-name (gensym "FOO")))
  "FOO1327")

;;; The symbol returned by gensym should be unbound
(deftest gensym.5
  (boundp (gensym))
  nil)

;;; The symbol returned by gensym should have no function binding
(deftest gensym.6
  (fboundp (gensym))
  nil)

;;; The symbol returned by gensym should have no property list
(deftest gensym.7
  (symbol-plist (gensym))
  nil)

;;; The symbol returned by gensym should be uninterned
(deftest gensym.8
  (symbol-package (gensym))
  nil)

;;; *gensym-counter* is incremented by gensym
(deftest gensym.9
  (let ((*gensym-counter* 12345))
    (declare (special *gensym-counter*))
    (gensym)
    *gensym-counter*)
  12346)

;;; Gensym works when *gensym-counter* is Really Big
;;; (and does not increment the counter until after creating
;;; the symbol.)
(deftest gensym.10
  (let ((*gensym-counter* 1234567890123456789012345678901234567890))
    (declare (special *gensym-counter*))
    (symbol-name (gensym)))
  #.(string '#:g1234567890123456789012345678901234567890))

;;; gensym increments Really Big values of *gensym-counter*
(deftest gensym.11
  (let ((*gensym-counter* 12345678901234567890123456789012345678901234567890))
    (declare (special *gensym-counter*))
    (gensym)
    *gensym-counter*)
  12345678901234567890123456789012345678901234567891)

;;; Gensym uses an integer argument instead of the counter
(deftest gensym.12
  (let ((*gensym-counter* 10))
    (declare (special *gensym-counter*))
    (symbol-name (gensym 123)))
  #.(string '#:g123))

;;; When given an integer argument, gensym does not increment the
;;; *gensym-counter*
(deftest gensym.13
  (let ((*gensym-counter* 10))
    (declare (special *gensym-counter*))
    (gensym 123)
    *gensym-counter*)
  10)

;;; Check response to erroneous arguments
;;; Note! NIL is not the same as no argument
;;; gensym should be implemented so that its only
;;; argument defaults to "G", with NIL causing an error.

(deftest gensym.error.1
  (classify-error (gensym 'aaa))
  type-error)

(deftest gensym.error.2
  (classify-error (gensym 12.3))
  type-error)

(deftest gensym.error.3
  (classify-error (gensym t))
  type-error)

(deftest gensym.error.4
  (classify-error (gensym nil))
  type-error) ;; NIL /= no argument!

(deftest gensym.error.5
  (classify-error (gensym '(a)))
  type-error)

(deftest gensym.error.6
  (classify-error (gensym #\x))
  type-error)

(deftest gensym.error.7
  (classify-error (gensym 10 'foo))
  program-error)

(deftest gensym.error.8
  (classify-error (locally (gensym t) t))
  type-error)


;;;;;;;;;;;;;;;;;;;;

;;; Tests of CL package constraints from section 11.1.2.1.1

;;; Check that all symbols listed as 'functions' or 'accessors'
;;; are indeed functions.

(deftest cl-function-symbols.1
  (loop
   for s in (append *cl-function-symbols* *cl-accessor-symbols*)
   when (or (not (fboundp s))
	    (macro-function s)
	    (special-operator-p s)
	    (not (symbol-function s)))
   collect s)
  nil)

;;; Check that all symols listed as 'macros' are macros.

(deftest cl-macro-symbols.1
  (loop
   for s in *cl-macro-symbols*
   when (or (not (fboundp s))
	    (not (macro-function s)))
   collect s)
  nil)

;;; Check that all constants are indeed constant

(deftest cl-constant-symbols.1
  (loop
   for s in *cl-constant-symbols*
   when (or (not (boundp s))
	    (not (constantp s)))
   collect s)
  nil)

;;; Check that all global variables have values

(deftest cl-variable-symbols.1
  (loop
   for s in *cl-variable-symbols*
   when (not (boundp s))
   collect s)
  nil)
	    
;;; Check that all types that are classes name classes.

;;; "Many but not all of the predefined type specifiers have
;;;  a corresponding class with the same proper name as the type.
;;;  These type specifiers are listed in Figure 4-8." -- section 4.3.7

(deftest cl-types-that-are-classes.1
  ;; Collect class names that violate the condition in the
  ;; above quotation.
  (loop
   for s in *cl-types-that-are-classes-symbols*
   for c = (find-class s nil)
   unless (and c
	       (eq (class-name c) s)
	       (typep c 'class))
   collect s)
  nil)


(deftest cl-types-that-are-classes.2
  ;; The same as cl-types-that-are-classes.1
  ;; with an environment argument
  (loop
   for s in *cl-types-that-are-classes-symbols*
   for c = (find-class s nil nil)
   unless (and c
	       (eq (class-name c) s)
	       (typep c 'class))
   collect s)
  nil)

(deftest cl-types-that-are-classes.3
  ;; The same as cl-types-that-are-classes.1,
  ;; with an environment argument
  (loop
   for s in *cl-types-that-are-classes-symbols*
   for c = (eval `(macrolet ((%foo (&environment env)
				   (list 'quote
					 (find-class ',s nil env))))
		    (%foo)))
   unless (and c
	       (eq (class-name c) s)
	       (typep c 'class))
   collect s)
  nil)

;;; Various error cases for symbol-related functions

(deftest symbolp.error.1
  (classify-error (symbolp))
  program-error)

(deftest symbolp.error.2
  (classify-error (symbolp nil nil))
  program-error)

(deftest symbol-function.error.1
  (classify-error (symbol-function))
  program-error)

(deftest symbol-function.error.2
  (classify-error (symbol-function 'cons nil))
  program-error)

(deftest symbol-package.error.1
  (classify-error (symbol-package))
  program-error)

(deftest symbol-package.error.2
  (classify-error (symbol-package 'cons nil))
  program-error)

(deftest symbol-plist.error.1
  (classify-error (symbol-plist))
  program-error)

(deftest symbol-plist.error.2
  (classify-error (symbol-plist 'cons nil))
  program-error)

(deftest symbol-value.error.1
  (classify-error (symbol-value))
  program-error)

(deftest symbol-value.error.2
  (classify-error (symbol-value '*package* nil))
  program-error)

