;; Example 5-8  Different material properties

(use gl)
(use gl.glut)

(define (init)
  (gl-clear-color 0.0 0.0 0.0 0.0)
  (gl-enable GL_DEPTH_TEST)
  (gl-shade-model GL_SMOOTH)

  (gl-light GL_LIGHT0 GL_AMBIENT '#f32(0.0 0.0 0.0 1.0))
  (gl-light GL_LIGHT0 GL_DIFFUSE '#f32(1.0 1.0 1.0 1.0))
  (gl-light GL_LIGHT0 GL_POSITION '#f32(10.0 10.0 10.0 0.0))
  (gl-light-model GL_LIGHT_MODEL_AMBIENT '#f32(0.4 0.4 0.4 1.0))
;  (gl-light-model GL_LIGHT_MODEL_LOCAL_VIEWER 1.0)
  (gl-enable GL_LIGHTING)
  (gl-enable GL_LIGHT0)
  )

(define (disp)
  (gl-clear (logior GL_COLOR_BUFFER_BIT GL_DEPTH_BUFFER_BIT))

  ;; diffuse reflection only
  (gl-push-matrix)
  (gl-translate -3.75 3.0 0.0)
  (gl-material GL_FRONT GL_AMBIENT '#f32(0.0 0.0 0.0 1.0))
  (gl-material GL_FRONT GL_DIFFUSE '#f32(0.1 0.5 0.8 1.0))
  (gl-material GL_FRONT GL_SPECULAR '#f32(0.0 0.0 0.0 1.0))
  (gl-material GL_FRONT GL_SHININESS 0.0)
  (gl-material GL_FRONT GL_EMISSION '#f32(0.0 0.0 0.0 1.0))
  (glut-solid-sphere 1.0 16 16)
  (gl-pop-matrix)

  ;; diffuse and specular, low shininess
  (gl-push-matrix)
  (gl-translate -1.25 3.0 0.0)
  (gl-material GL_FRONT GL_AMBIENT '#f32(0.0 0.0 0.0 1.0))
  (gl-material GL_FRONT GL_DIFFUSE '#f32(0.1 0.5 0.8 1.0))
  (gl-material GL_FRONT GL_SPECULAR '#f32(1.0 1.0 1.0 1.0))
  (gl-material GL_FRONT GL_SHININESS 5.0)
  (gl-material GL_FRONT GL_EMISSION '#f32(0.0 0.0 0.0 1.0))
  (glut-solid-sphere 1.0 16 16)
  (gl-pop-matrix)

  ;; diffuse and specular, high shininess
  (gl-push-matrix)
  (gl-translate 1.25 3.0 0.0)
  (gl-material GL_FRONT GL_AMBIENT '#f32(0.0 0.0 0.0 1.0))
  (gl-material GL_FRONT GL_DIFFUSE '#f32(0.1 0.5 0.8 1.0))
  (gl-material GL_FRONT GL_SPECULAR '#f32(1.0 1.0 1.0 1.0))
  (gl-material GL_FRONT GL_SHININESS 100.0)
  (gl-material GL_FRONT GL_EMISSION '#f32(0.0 0.0 0.0 1.0))
  (glut-solid-sphere 1.0 16 16)
  (gl-pop-matrix)

  ;; diffuse and emission
  (gl-push-matrix)
  (gl-translate 3.75 3.0 0.0)
  (gl-material GL_FRONT GL_AMBIENT '#f32(0.0 0.0 0.0 1.0))
  (gl-material GL_FRONT GL_DIFFUSE '#f32(0.1 0.5 0.8 1.0))
  (gl-material GL_FRONT GL_SPECULAR '#f32(0.0 0.0 0.0 1.0))
  (gl-material GL_FRONT GL_SHININESS 0.0)
  (gl-material GL_FRONT GL_EMISSION '#f32(0.3 0.2 0.2 1.0))
  (glut-solid-sphere 1.0 16 16)
  (gl-pop-matrix)

  ;; ambient and diffuse
  (gl-push-matrix)
  (gl-translate -3.75 0.0 0.0)
  (gl-material GL_FRONT GL_AMBIENT '#f32(0.7 0.7 0.7 1.0))
  (gl-material GL_FRONT GL_DIFFUSE '#f32(0.1 0.5 0.8 1.0))
  (gl-material GL_FRONT GL_SPECULAR '#f32(0.0 0.0 0.0 1.0))
  (gl-material GL_FRONT GL_SHININESS 0.0)
  (gl-material GL_FRONT GL_EMISSION '#f32(0.0 0.0 0.0 1.0))
  (glut-solid-sphere 1.0 16 16)
  (gl-pop-matrix)

  ;; ambient, diffuse and specular, low shininess
  (gl-push-matrix)
  (gl-translate -1.25 0.0 0.0)
  (gl-material GL_FRONT GL_AMBIENT '#f32(0.7 0.7 0.7 1.0))
  (gl-material GL_FRONT GL_DIFFUSE '#f32(0.1 0.5 0.8 1.0))
  (gl-material GL_FRONT GL_SPECULAR '#f32(1.0 1.0 1.0 1.0))
  (gl-material GL_FRONT GL_SHININESS 5.0)
  (gl-material GL_FRONT GL_EMISSION '#f32(0.0 0.0 0.0 1.0))
  (glut-solid-sphere 1.0 16 16)
  (gl-pop-matrix)

  ;; ambient, diffuse and specular, high shininess
  (gl-push-matrix)
  (gl-translate 1.25 0.0 0.0)
  (gl-material GL_FRONT GL_AMBIENT '#f32(0.7 0.7 0.7 1.0))
  (gl-material GL_FRONT GL_DIFFUSE '#f32(0.1 0.5 0.8 1.0))
  (gl-material GL_FRONT GL_SPECULAR '#f32(1.0 1.0 1.0 1.0))
  (gl-material GL_FRONT GL_SHININESS 100.0)
  (gl-material GL_FRONT GL_EMISSION '#f32(0.0 0.0 0.0 1.0))
  (glut-solid-sphere 1.0 16 16)
  (gl-pop-matrix)

  ;; ambient, diffuse and emission
  (gl-push-matrix)
  (gl-translate 3.75 0.0 0.0)
  (gl-material GL_FRONT GL_AMBIENT '#f32(0.7 0.7 0.7 1.0))
  (gl-material GL_FRONT GL_DIFFUSE '#f32(0.1 0.5 0.8 1.0))
  (gl-material GL_FRONT GL_SPECULAR '#f32(0.0 0.0 0.0 1.0))
  (gl-material GL_FRONT GL_SHININESS 0.0)
  (gl-material GL_FRONT GL_EMISSION '#f32(0.3 0.2 0.2 1.0))
  (glut-solid-sphere 1.0 16 16)
  (gl-pop-matrix)

  ;; colored ambient and diffuse
  (gl-push-matrix)
  (gl-translate -3.75 -3.0 0.0)
  (gl-material GL_FRONT GL_AMBIENT '#f32(0.8 0.8 0.2 1.0))
  (gl-material GL_FRONT GL_DIFFUSE '#f32(0.1 0.5 0.8 1.0))
  (gl-material GL_FRONT GL_SPECULAR '#f32(0.0 0.0 0.0 1.0))
  (gl-material GL_FRONT GL_SHININESS 0.0)
  (gl-material GL_FRONT GL_EMISSION '#f32(0.0 0.0 0.0 1.0))
  (glut-solid-sphere 1.0 16 16)
  (gl-pop-matrix)
  
  ;; colored ambient, diffuse and specular, low shininess
  (gl-push-matrix)
  (gl-translate -1.25 -3.0 0.0)
  (gl-material GL_FRONT GL_AMBIENT '#f32(0.8 0.8 0.2 1.0))
  (gl-material GL_FRONT GL_DIFFUSE '#f32(0.1 0.5 0.8 1.0))
  (gl-material GL_FRONT GL_SPECULAR '#f32(1.0 1.0 1.0 1.0))
  (gl-material GL_FRONT GL_SHININESS 5.0)
  (gl-material GL_FRONT GL_EMISSION '#f32(0.0 0.0 0.0 1.0))
  (glut-solid-sphere 1.0 16 16)
  (gl-pop-matrix)

  ;; colored ambient, diffuse and specular, high shininess
  (gl-push-matrix)
  (gl-translate 1.25 -3.0 0.0)
  (gl-material GL_FRONT GL_AMBIENT '#f32(0.8 0.8 0.2 1.0))
  (gl-material GL_FRONT GL_DIFFUSE '#f32(0.1 0.5 0.8 1.0))
  (gl-material GL_FRONT GL_SPECULAR '#f32(1.0 1.0 1.0 1.0))
  (gl-material GL_FRONT GL_SHININESS 100.0)
  (gl-material GL_FRONT GL_EMISSION '#f32(0.0 0.0 0.0 1.0))
  (glut-solid-sphere 1.0 16 16)
  (gl-pop-matrix)

  ;; ambient, diffuse and emission
  (gl-push-matrix)
  (gl-translate 3.75 -3.0 0.0)
  (gl-material GL_FRONT GL_AMBIENT '#f32(0.8 0.8 0.2 1.0))
  (gl-material GL_FRONT GL_DIFFUSE '#f32(0.1 0.5 0.8 1.0))
  (gl-material GL_FRONT GL_SPECULAR '#f32(0.0 0.0 0.0 1.0))
  (gl-material GL_FRONT GL_SHININESS 0.0)
  (gl-material GL_FRONT GL_EMISSION '#f32(0.3 0.2 0.2 1.0))
  (glut-solid-sphere 1.0 16 16)
  (gl-pop-matrix)

  (gl-flush)
  )

(define (reshape w h)
  (gl-viewport 0 0 w h)
  (gl-matrix-mode GL_PROJECTION)
  (gl-load-identity)
  (if (<= w (* 2 h))
      (gl-ortho -6.0 6.0 (* -3.0 (/ (* 2 h) w)) (* 3.0 (/ (* 2 h) w)) -10.0 10.0)
      (gl-ortho (* -6.0 (/ w (* 2 h))) (* 6.0 (/ w (* 2 h))) -3.0 3.0 -10.0 10.0))
  (gl-matrix-mode GL_MODELVIEW)
  (gl-load-identity)
  )

(define (keyboard key x y)
  (when (= key 27) (exit 0)))

(define (main args)
  (glut-init args)
  (glut-init-display-mode (logior GLUT_SINGLE GLUT_RGB GLUT_DEPTH))
  (glut-init-window-size 600 450)
  (glut-create-window *program-name*)
  (init)
  (glut-display-func disp)
  (glut-reshape-func reshape)
  (glut-keyboard-func keyboard)
  (glut-main-loop)
  0)
