###########################################################################
##
## extract_examples.g                                   Alexander Konovalov
##
###########################################################################
## Fetched  from GitHub-Gist  <https://gist.github.com/alex-konovalov>  and
## adapted  with respect  to packaging needs for  Debian  by  Jerome Benoit
## <calculus@rezozer.net> on behalf of the Debian Science Team.
###########################################################################

# This GAP script extracts examples from package manuals in GAPDoc format
# (http://www.math.rwth-aachen.de/~Frank.Luebeck/GAPDoc/). The output will
# be stored in the 'tst' directory of the package in files 'pkgnameXX.tst'
# (one file per chapter for each chapter that contains examples).
#
# Extracted examples may be tested using the 'Test' function, for example:
# gap> Test("tst/pkgnameXX.tst");
# or
# gap> Test("tst/tomlib.tst",rec(compareFunction:="uptowhitespace"));
#
# This script is tested with GAP 4.7.5 and TomLib 1.2.4.
#
# To use this script, set up PKGNAME, PKGMAIN and PKGMANUALFILES files
# variables. The example below shows how to do this for the TomLib package.
#
###########################################################################

SetPackagePath("toric",".");

# The name of the package
####PKGNAME := "tomlib";
PKGNAME := "toric";

# The name of the main manual file (with extension)
####PKGMAIN := "tomlib.xml";
PKGMAIN := "toric.xml";

# List of source files containing parts of documentation
# (paths should be relative to the directory containing PKGMAIN file)
####PKGMANUALFILES:= ["../gap/tmadmin.tmd", "../gap/stdgen.gd"];
PKGMANUALFILES:= [ "../PackageInfo.g" ];

###########################################################################
#
# You do not need to edit anything below this line
#
###########################################################################

ExtractPackageManualExamples:=function( pkgname, main, files )
local path, tst, i, s, name, output, ch, a;
path:=Directory(
        Concatenation(PackageInfo(pkgname)[1].InstallationPath, "/doc") );
Print("Extracting manual examples for ", pkgname, " package ...\n" );
tst:=ExtractExamples( path, main, files, "Chapter" );
Print(Length(tst), " chapters detected\n");
for i in [ 1 .. Length(tst) ] do
  Print( "Chapter ", i, " : \c" );
  if Length( tst[i] ) > 0 then
    s := String(i);
    if Length(s)=1 then
      # works for <100 chapters (no packages with more chapters are known).
      s:=Concatenation("0",s);
    fi;
    name := Filename(
              Directory(
                Concatenation( PackageInfo(pkgname)[1].InstallationPath,
                               "/tst" ) ),
                Concatenation( LowercaseString(pkgname), "-examples-ch", s, ".tst" ) );
    output := OutputTextFile( name, false ); # to empty the file first
    SetPrintFormattingStatus( output, false ); # to avoid line breaks
    ch := tst[i];
    AppendTo(output, "# ", pkgname, ", chapter ",i,"\n");
    for a in ch do
      AppendTo(output, "\n# ",a[2], a[1]);
    od;
    Print("extracted ", Length(ch), " examples \n");
  else
    Print("no examples \n" );
  fi;
od;
end;

ExtractPackageManualExamples( PKGNAME, PKGMAIN, PKGMANUALFILES );

QUIT;
###########################################################################
##
#E
##
