/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

package org.apache.fop.complexscripts.fonts;

import java.io.File;

import org.junit.Test;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import org.apache.fop.complexscripts.fonts.ttx.TTXFile;

public class GDEFTestCase {

    private static String ttxFilesRoot = "test/resources/complexscripts";

    private static String[][] ttxFonts = {
        { "f0", "arab/ttx/arab-001.ttx" },              // simplified arabic
        { "f1", "arab/ttx/arab-002.ttx" },              // traditional arabic
        { "f2", "arab/ttx/arab-003.ttx" },              // lateef
        { "f3", "arab/ttx/arab-004.ttx" },              // scheherazade
    };

    private static Object[][] ltGlyphClass = {
        { GlyphDefinitionTable.GDEF_LOOKUP_TYPE_GLYPH_CLASS },
        // arab-001.ttx
        { "f0", "lu0",
          new String[][] {
              { "a", "1" },
              { "aacute", "1" },
              { "acircumflex", "1" },
              { "acute", "1" },
              { "adieresis", "1" },
              { "ae", "1" },
              { "agrave", "1" },
              { "ain", "1" },
              { "ainfinal", "1" },
              { "aininitial", "1" },
              { "ainisolated", "1" },
              { "ainmedial", "1" },
              { "aleffinal", "1" },
              { "alefisolated", "1" },
              { "alefmaksura", "1" },
              { "alefmaksurafinal", "1" },
              { "alefmaksuraisolated", "1" },
              { "alefwasla", "1" },
              { "alefwaslafinal", "1" },
              { "alefwaslaisolated", "1" },
              { "alefwithfathatanfinal", "1" },
              { "alefwithfathatanisolated", "1" },
              { "alefwithhamzaabove", "1" },
              { "alefwithhamzaabovefinal", "1" },
              { "alefwithhamzaaboveisolated", "1" },
              { "alefwithhamzabelow", "1" },
              { "alefwithhamzabelowfinal", "1" },
              { "alefwithhamzabelowisolated", "1" },
              { "alefwithmaddaabove", "1" },
              { "alefwithmaddaabovefinal", "1" },
              { "alefwithmaddaaboveisolated", "1" },
              { "allahisolated", "2" },
              { "ampersand", "1" },
              { "arabicae", "1" },
              { "arabicalef", "1" },
              { "arabiccomma", "1" },
              { "arabicfivepointedstar", "1" },
              { "arabicindicdigiteight", "1" },
              { "arabicindicdigitfive", "1" },
              { "arabicindicdigitfour", "1" },
              { "arabicindicdigitnine", "1" },
              { "arabicindicdigitone", "1" },
              { "arabicindicdigitseven", "1" },
              { "arabicindicdigitsix", "1" },
              { "arabicindicdigitthree", "1" },
              { "arabicindicdigittwo", "1" },
              { "arabicindicdigitzero", "1" },
              { "arabickaf", "1" },
              { "arabicpercentsign", "1" },
              { "arabicquestionmark", "1" },
              { "arabicsemicolon", "1" },
              { "aring", "1" },
              { "asciicircum", "1" },
              { "asciitilde", "1" },
              { "asterisk", "1" },
              { "at", "1" },
              { "atilde", "1" },
              { "b", "1" },
              { "backslash", "1" },
              { "bar", "1" },
              { "beh", "1" },
              { "behisolated", "1" },
              { "behmedial", "1" },
              { "braceleft", "1" },
              { "braceright", "1" },
              { "bracketleft", "1" },
              { "bracketright", "1" },
              { "brokenbar", "1" },
              { "bullet", "1" },
              { "c", "1" },
              { "caron", "1" },
              { "ccedilla", "1" },
              { "cedilla", "1" },
              { "cent", "1" },
              { "circumflex", "1" },
              { "colon", "1" },
              { "comma", "1" },
              { "copyright", "1" },
              { "currency", "1" },
              { "d", "1" },
              { "dad", "1" },
              { "dadisolated", "1" },
              { "dadmedial", "1" },
              { "dagger", "1" },
              { "daggerdbl", "1" },
              { "dal", "1" },
              { "dalisolated", "1" },
              { "damma", "3" },
              { "dammahontatweel", "3" },
              { "dammaisolated", "3" },
              { "dammalow", "1" },
              { "dammaonhamza", "3" },
              { "dammatan", "3" },
              { "dammatanisolated", "3" },
              { "dammatanlow", "1" },
              { "dammatanonhamza", "3" },
              { "degree", "1" },
              { "delete", "1" },
              { "dieresis", "1" },
              { "divide", "1" },
              { "dollar", "1" },
              { "dotlessi", "1" },
              { "e", "1" },
              { "eacute", "1" },
              { "ecircumflex", "1" },
              { "edieresis", "1" },
              { "egrave", "1" },
              { "eight", "1" },
              { "ellipsis", "1" },
              { "endash", "1" },
              { "equal", "1" },
              { "eth", "1" },
              { "exclam", "1" },
              { "exclamdown", "1" },
              { "extendedarabicindicdigiteight", "1" },
              { "extendedarabicindicdigitfive", "1" },
              { "extendedarabicindicdigitfour", "1" },
              { "extendedarabicindicdigitnine", "1" },
              { "extendedarabicindicdigitone", "1" },
              { "extendedarabicindicdigitseven", "1" },
              { "extendedarabicindicdigitsix", "1" },
              { "extendedarabicindicdigitthree", "1" },
              { "extendedarabicindicdigittwo", "1" },
              { "extendedarabicindicdigitzero", "1" },
              { "f", "1" },
              { "farsiyeh", "1" },
              { "farsiyehfinal", "1" },
              { "farsiyehisolated", "1" },
              { "fatha", "3" },
              { "fathahontatweel", "3" },
              { "fathaisolated", "3" },
              { "fathalow", "1" },
              { "fathaonhamza", "3" },
              { "fathatan", "3" },
              { "fathatanisolated", "3" },
              { "fathatanlow", "1" },
              { "fathatanonhamza", "3" },
              { "fathatanontatweel", "1" },
              { "feh", "1" },
              { "fehinitial", "1" },
              { "fehisolated", "1" },
              { "fehmedial", "1" },
              { "five", "1" },
              { "florin", "1" },
              { "four", "1" },
              { "g", "1" },
              { "gaf", "1" },
              { "gaffinal", "1" },
              { "gafinitial", "1" },
              { "gafisolated", "1" },
              { "gafmedial", "1" },
              { "germandbls", "1" },
              { "ghain", "1" },
              { "ghainfinal", "1" },
              { "ghaininitial", "1" },
              { "ghainisolated", "1" },
              { "ghainmedial", "1" },
              { "glyph1", "1" },
              { "glyph2", "1" },
              { "glyph99", "1" },
              { "grave", "1" },
              { "greater", "1" },
              { "guillemotleft", "1" },
              { "guillemotright", "1" },
              { "guilsinglleft", "1" },
              { "guilsinglright", "1" },
              { "h", "1" },
              { "hah", "1" },
              { "hahfinal", "1" },
              { "hahisolated", "1" },
              { "hahmedial", "1" },
              { "hamza", "1" },
              { "hamzaisolated", "3" },
              { "heh", "1" },
              { "hehfinal", "1" },
              { "hehinitial", "1" },
              { "hehisolated", "1" },
              { "hehmedial", "1" },
              { "highhamza", "1" },
              { "hyphenminus", "1" },
              { "i", "1" },
              { "iacute", "1" },
              { "icircumflex", "1" },
              { "idieresis", "1" },
              { "igrave", "1" },
              { "j", "1" },
              { "jeem", "1" },
              { "jeemfinal", "1" },
              { "jeemisolated", "1" },
              { "jeemmedial", "1" },
              { "jeh", "1" },
              { "jehisolated", "1" },
              { "k", "1" },
              { "kafisolated", "1" },
              { "kafmedial", "1" },
              { "kasra", "3" },
              { "kasrahontatweel", "3" },
              { "kasraisolated", "3" },
              { "kasralow", "1" },
              { "kasratan", "3" },
              { "kasratanisolated", "3" },
              { "kasratanlow", "1" },
              { "keheh", "1" },
              { "kehehfinal", "1" },
              { "kehehinitial", "1" },
              { "kehehisolated", "1" },
              { "kehehmedial", "1" },
              { "khah", "1" },
              { "khahfinal", "1" },
              { "khahisolated", "1" },
              { "khahmedial", "1" },
              { "l", "1" },
              { "lam", "1" },
              { "lamisolated", "1" },
              { "lammedial", "1" },
              { "lamwithaleffinal", "2" },
              { "lamwithalefhamzaabovefinal", "2" },
              { "lamwithalefhamzaaboveisolatedd", "2" },
              { "lamwithalefhamzabelowfinal", "2" },
              { "lamwithalefhamzabelowisolated", "2" },
              { "lamwithalefisolated", "2" },
              { "lamwithalefmaddaabovefinal", "2" },
              { "lamwithalefmaddaaboveisolatedd", "2" },
              { "lamwithmeemwithjeeminitial", "1" },
              { "lefttoright", "1" },
              { "less", "1" },
              { "logicalnot", "1" },
              { "m", "1" },
              { "macron", "1" },
              { "meem", "1" },
              { "meemisolated", "1" },
              { "meemmedial", "1" },
              { "micro", "1" },
              { "multiply", "1" },
              { "n", "1" },
              { "nbspace", "1" },
              { "nine", "1" },
              { "noon", "1" },
              { "noonisolated", "1" },
              { "noonmedial", "1" },
              { "ntilde", "1" },
              { "numbersign", "1" },
              { "o", "1" },
              { "oacute", "1" },
              { "ocircumflex", "1" },
              { "odieresis", "1" },
              { "oe", "1" },
              { "ograve", "1" },
              { "one", "1" },
              { "onehalf", "1" },
              { "onequarter", "1" },
              { "onesuperior", "1" },
              { "ordfeminine", "1" },
              { "ordmasculine", "1" },
              { "ornateleftparenthesis", "1" },
              { "ornaterightparenthesis", "1" },
              { "oslash", "1" },
              { "otilde", "1" },
              { "p", "1" },
              { "paragraph", "1" },
              { "parenleft", "1" },
              { "parenright", "1" },
              { "peh", "1" },
              { "pehisolated", "1" },
              { "pehmedial", "1" },
              { "percent", "1" },
              { "period", "1" },
              { "periodcentered", "1" },
              { "perthousand", "1" },
              { "plus", "1" },
              { "plusminus", "1" },
              { "q", "1" },
              { "qaf", "1" },
              { "qafinitial", "1" },
              { "qafisolated", "1" },
              { "qafmedial", "1" },
              { "question", "1" },
              { "questiondown", "1" },
              { "quotedash", "1" },
              { "quotedbl", "1" },
              { "quotedblbase", "1" },
              { "quotedblleft", "1" },
              { "quotedblright", "1" },
              { "quoteleft", "1" },
              { "quoteright", "1" },
              { "quotesinglbase", "1" },
              { "quotesingle", "1" },
              { "r", "1" },
              { "rayaleflam", "2" },
              { "registered", "1" },
              { "reh", "1" },
              { "rehisolated", "1" },
              { "righttoleft", "1" },
              { "s", "1" },
              { "sad", "1" },
              { "sadisolated", "1" },
              { "sadmedial", "1" },
              { "scaron", "1" },
              { "section", "1" },
              { "seen", "1" },
              { "seenisolated", "1" },
              { "seenmedial", "1" },
              { "semicolon", "1" },
              { "seven", "1" },
              { "sfthyphen", "1" },
              { "shadda", "3" },
              { "shaddahontatweel", "3" },
              { "shaddaisolated", "3" },
              { "shaddalow", "1" },
              { "shaddawithdammaisolated", "3" },
              { "shaddawithdammalow", "3" },
              { "shaddawithdammamedial", "1" },
              { "shaddawithdammatanisolated", "1" },
              { "shaddawithdammatanlow", "3" },
              { "shaddawithfathaisolated", "3" },
              { "shaddawithfathalow", "3" },
              { "shaddawithfathamedial", "1" },
              { "shaddawithfathatanisolated", "1" },
              { "shaddawithfathatanlow", "3" },
              { "shaddawithkasraisolated", "3" },
              { "shaddawithkasralow", "3" },
              { "shaddawithkasramedial", "1" },
              { "shaddawithkasratanisolated", "1" },
              { "shaddawithkasratanlow", "3" },
              { "sheen", "1" },
              { "sheenisolated", "1" },
              { "sheenmedial", "1" },
              { "six", "1" },
              { "slash", "1" },
              { "smallhighmadda", "3" },
              { "space", "1" },
              { "sterling", "1" },
              { "sukun", "3" },
              { "sukunisolated", "3" },
              { "sukunlow", "1" },
              { "sukunonhamza", "3" },
              { "sukunontatweel", "3" },
              { "superscriptalef", "3" },
              { "t", "1" },
              { "tah", "1" },
              { "tahisolated", "1" },
              { "tatweel", "1" },
              { "tcheh", "1" },
              { "tchehfinal", "1" },
              { "tchehisolated", "1" },
              { "tchehmedial", "1" },
              { "teh", "1" },
              { "tehisolated", "1" },
              { "tehmarbuta", "1" },
              { "tehmarbutafinal", "1" },
              { "tehmarbutaisolated", "1" },
              { "tehmedial", "1" },
              { "thal", "1" },
              { "thalisolated", "1" },
              { "theh", "1" },
              { "thehisolated", "1" },
              { "thehmedial", "1" },
              { "thorn", "1" },
              { "three", "1" },
              { "threequarters", "1" },
              { "threesuperior", "1" },
              { "tilde", "1" },
              { "trademark", "1" },
              { "two", "1" },
              { "twosuperior", "1" },
              { "u", "1" },
              { "uacute", "1" },
              { "ucircumflex", "1" },
              { "udieresis", "1" },
              { "ugrave", "1" },
              { "underscore", "1" },
              { "uni000D", "1" },
              { "uni0649.init", "1" },
              { "uni0654", "3" },
              { "uni0655", "3" },
              { "uni0655064D", "3" },
              { "uni06550650", "3" },
              { "uni06A5.init", "1" },
              { "uni25CC", "1" },
              { "v", "1" },
              { "veh", "1" },
              { "vehisolated", "1" },
              { "vehmedial", "1" },
              { "w", "1" },
              { "waw", "1" },
              { "wawisolated", "1" },
              { "wawwithhamzaabove", "1" },
              { "wawwithhamzaaboveisolated", "1" },
              { "x", "1" },
              { "y", "1" },
              { "yacute", "1" },
              { "ydieresis", "1" },
              { "yeh", "1" },
              { "yehfinal", "1" },
              { "yehisolated", "1" },
              { "yehmedial", "1" },
              { "yehwithhamzaabove", "1" },
              { "yehwithhamzaabovefinal", "1" },
              { "yehwithhamzaaboveisolated", "1" },
              { "yehwithhamzaabovemedial", "1" },
              { "yen", "1" },
              { "z", "1" },
              { "zah", "1" },
              { "zahisolated", "1" },
              { "zain", "1" },
              { "zainisolated", "1" },
              { "zcaron", "1" },
              { "zero", "1" },
              { "zerojoin", "1" },
              { "zeronojoin", "1" },
              { "zerowidthnobreakspace", "1" },
          },
        },
        // arab-002.ttx
        { "f1", "lu0",
          new String[][] {
              { "a", "1" },
              { "aacute", "1" },
              { "acircumflex", "1" },
              { "acute", "1" },
              { "adieresis", "1" },
              { "ae", "1" },
              { "agrave", "1" },
              { "ain", "1" },
              { "ainfinal", "1" },
              { "aininitial", "1" },
              { "ainisolated", "1" },
              { "ainmedial", "1" },
              { "aleffinal", "1" },
              { "alefisolated", "1" },
              { "alefmaksura", "1" },
              { "alefmaksurafinal", "1" },
              { "alefmaksuraisolated", "1" },
              { "alefwasla", "1" },
              { "alefwaslafinal", "1" },
              { "alefwaslaisolated", "1" },
              { "alefwithfathatanfinal", "1" },
              { "alefwithfathatanisolated", "1" },
              { "alefwithhamzaabove", "1" },
              { "alefwithhamzaabovefinal", "1" },
              { "alefwithhamzaaboveisolated", "1" },
              { "alefwithhamzabelow", "1" },
              { "alefwithhamzabelowfinal", "1" },
              { "alefwithhamzabelowisolated", "1" },
              { "alefwithmaddaabove", "1" },
              { "alefwithmaddaabovefinal", "1" },
              { "alefwithmaddaaboveisolated", "1" },
              { "allahisolated", "2" },
              { "ampersand", "1" },
              { "arabicae", "1" },
              { "arabicalef", "1" },
              { "arabiccomma", "1" },
              { "arabicfivepointedstar", "3" },
              { "arabicindicdigiteight", "1" },
              { "arabicindicdigitfive", "1" },
              { "arabicindicdigitfour", "1" },
              { "arabicindicdigitnine", "1" },
              { "arabicindicdigitone", "1" },
              { "arabicindicdigitseven", "1" },
              { "arabicindicdigitsix", "1" },
              { "arabicindicdigitthree", "1" },
              { "arabicindicdigittwo", "1" },
              { "arabicindicdigitzero", "1" },
              { "arabickaf", "1" },
              { "arabickaffinal", "1" },
              { "arabicpercentsign", "1" },
              { "arabicquestionmark", "1" },
              { "arabicsemicolon", "1" },
              { "aring", "1" },
              { "asciicircum", "1" },
              { "asciitilde", "1" },
              { "asterisk", "1" },
              { "at", "1" },
              { "atilde", "1" },
              { "b", "1" },
              { "backslash", "1" },
              { "bar", "1" },
              { "beh", "1" },
              { "behfinal", "1" },
              { "behinitial", "1" },
              { "behisolated", "1" },
              { "behmedial", "1" },
              { "behwithalefmaksurafinal", "2" },
              { "behwithalefmaksuraisolated", "2" },
              { "behwithhahinitial", "2" },
              { "behwithhehinitial", "2" },
              { "behwithjeeminitial", "2" },
              { "behwithkhahinitial", "2" },
              { "behwithmeeminitial", "2" },
              { "behwithmeemisolated", "2" },
              { "behwithnoonfinal", "2" },
              { "behwithrehfinal", "2" },
              { "behwithyehfinal", "2" },
              { "behwithyehisolated", "2" },
              { "braceleft", "1" },
              { "braceright", "1" },
              { "bracketleft", "1" },
              { "bracketright", "1" },
              { "brokenbar", "1" },
              { "bullet", "1" },
              { "c", "1" },
              { "caron", "1" },
              { "ccedilla", "1" },
              { "cedilla", "1" },
              { "cent", "1" },
              { "circumflex", "1" },
              { "colon", "1" },
              { "comma", "1" },
              { "copyright", "1" },
              { "currency", "1" },
              { "d", "1" },
              { "dad", "1" },
              { "dadfinal", "1" },
              { "dadinitial", "1" },
              { "dadisolated", "1" },
              { "dadmedial", "1" },
              { "dagger", "1" },
              { "daggerdbl", "1" },
              { "dal", "1" },
              { "dalfinal", "1" },
              { "dalisolated", "1" },
              { "damma", "3" },
              { "dammahontatweel", "1" },
              { "dammaisolated", "1" },
              { "dammalow", "1" },
              { "dammaonhamza", "3" },
              { "dammatan", "3" },
              { "dammatanisolated", "1" },
              { "dammatanlow", "1" },
              { "dammatanonhamza", "3" },
              { "degree", "1" },
              { "delete", "1" },
              { "dieresis", "1" },
              { "divide", "1" },
              { "dollar", "1" },
              { "dotlessi", "1" },
              { "e", "1" },
              { "eacute", "1" },
              { "ecircumflex", "1" },
              { "edieresis", "1" },
              { "egrave", "1" },
              { "eight", "1" },
              { "ellipsis", "1" },
              { "endash", "1" },
              { "equal", "1" },
              { "eth", "1" },
              { "exclam", "1" },
              { "exclamdown", "1" },
              { "extendedarabicindicdigiteight", "1" },
              { "extendedarabicindicdigitfive", "1" },
              { "extendedarabicindicdigitfour", "1" },
              { "extendedarabicindicdigitnine", "1" },
              { "extendedarabicindicdigitone", "1" },
              { "extendedarabicindicdigitseven", "1" },
              { "extendedarabicindicdigitsix", "1" },
              { "extendedarabicindicdigitthree", "1" },
              { "extendedarabicindicdigittwo", "1" },
              { "extendedarabicindicdigitzero", "1" },
              { "f", "1" },
              { "farsiyeh", "1" },
              { "farsiyehfinal", "1" },
              { "farsiyehisolated", "1" },
              { "fatha", "3" },
              { "fathahontatweel", "1" },
              { "fathaisolated", "1" },
              { "fathalow", "1" },
              { "fathaonhamza", "3" },
              { "fathatan", "3" },
              { "fathatanisolated", "1" },
              { "fathatanlow", "1" },
              { "fathatanonhamza", "3" },
              { "fathatanontatweel", "1" },
              { "feh", "1" },
              { "fehfinal", "1" },
              { "fehinitial", "1" },
              { "fehisolated", "1" },
              { "fehmedial", "1" },
              { "fehwithalefmaksuraisolated", "2" },
              { "fehwithyehisolated", "2" },
              { "five", "1" },
              { "florin", "1" },
              { "four", "1" },
              { "g", "1" },
              { "gaf", "1" },
              { "gaffinal", "1" },
              { "gafinitial", "1" },
              { "gafisolated", "1" },
              { "gafmedial", "1" },
              { "germandbls", "1" },
              { "ghain", "1" },
              { "ghainfinal", "1" },
              { "ghaininitial", "1" },
              { "ghainisolated", "1" },
              { "ghainmedial", "1" },
              { "grave", "1" },
              { "greater", "1" },
              { "guillemotleft", "1" },
              { "guillemotright", "1" },
              { "guilsinglleft", "1" },
              { "guilsinglright", "1" },
              { "h", "1" },
              { "hah", "1" },
              { "hahfinal", "1" },
              { "hahinitial", "1" },
              { "hahisolated", "1" },
              { "hahmedial", "1" },
              { "hahwithmeeminitial", "2" },
              { "hamza", "1" },
              { "hamzaisolated", "1" },
              { "heh", "1" },
              { "hehfinal", "1" },
              { "hehinitial", "1" },
              { "hehisolated", "1" },
              { "hehmedial", "1" },
              { "hehwithmeeminitial", "2" },
              { "highhamza", "1" },
              { "hyphenminus", "1" },
              { "i", "1" },
              { "iacute", "1" },
              { "icircumflex", "1" },
              { "idieresis", "1" },
              { "igrave", "1" },
              { "j", "1" },
              { "jeem", "1" },
              { "jeemfinal", "1" },
              { "jeeminitial", "1" },
              { "jeemisolated", "1" },
              { "jeemmedial", "1" },
              { "jeemwithmeeminitial", "2" },
              { "jeh", "1" },
              { "jehfinal", "1" },
              { "jehisolated", "1" },
              { "k", "1" },
              { "kafinitial", "1" },
              { "kafisolated", "1" },
              { "kafmedial", "1" },
              { "kasra", "3" },
              { "kasrahontatweel", "1" },
              { "kasraisolated", "1" },
              { "kasralow", "1" },
              { "kasratan", "3" },
              { "kasratanisolated", "1" },
              { "kasratanlow", "1" },
              { "keheh", "1" },
              { "kehehfinal", "1" },
              { "kehehinitial", "1" },
              { "kehehisolated", "1" },
              { "kehehmedial", "1" },
              { "khah", "1" },
              { "khahfinal", "1" },
              { "khahinitial", "1" },
              { "khahisolated", "1" },
              { "khahmedial", "1" },
              { "khahwithmeeminitial", "2" },
              { "l", "1" },
              { "lam", "1" },
              { "lamfinal", "1" },
              { "laminitial", "1" },
              { "lamisolated", "1" },
              { "lammedial", "1" },
              { "lamwithaleffinal", "2" },
              { "lamwithalefhamzaabovefinal", "2" },
              { "lamwithalefhamzaaboveisolatedd", "2" },
              { "lamwithalefhamzabelowfinal", "2" },
              { "lamwithalefhamzabelowisolated", "2" },
              { "lamwithalefisolated", "2" },
              { "lamwithalefmaddaabovefinal", "2" },
              { "lamwithalefmaddaaboveisolatedd", "2" },
              { "lamwithalefmaksuraisolated", "2" },
              { "lamwithhahinitial", "2" },
              { "lamwithhahisolated", "2" },
              { "lamwithhehinitial", "2" },
              { "lamwithjeeminitial", "2" },
              { "lamwithjeemisolated", "2" },
              { "lamwithkhahinitial", "2" },
              { "lamwithkhahisolated", "2" },
              { "lamwithmeeminitial", "2" },
              { "lamwithmeemisolated", "2" },
              { "lamwithmeemwithhahinitial", "2" },
              { "lamwithmeemwithjeeminitial", "2" },
              { "lamwithyehisolated", "2" },
              { "lefttoright", "1" },
              { "less", "1" },
              { "logicalnot", "1" },
              { "m", "1" },
              { "macron", "1" },
              { "meem", "1" },
              { "meemfinal", "1" },
              { "meeminitial", "1" },
              { "meemisolated", "1" },
              { "meemmedial", "1" },
              { "meemwithhahinitial", "2" },
              { "meemwithjeeminitial", "2" },
              { "meemwithkhahinitial", "2" },
              { "meemwithmeeminitial", "2" },
              { "micro", "1" },
              { "multiply", "1" },
              { "n", "1" },
              { "nine", "1" },
              { "nonbreakingspace", "1" },
              { "nonmarkingreturn", "1" },
              { "noon", "1" },
              { "noonfinal", "1" },
              { "nooninitial", "1" },
              { "noonisolated", "1" },
              { "noonmedial", "1" },
              { "noonwithalefmaksurafinal", "2" },
              { "noonwithalefmaksuraisolated", "2" },
              { "noonwithhahinitial", "2" },
              { "noonwithhehinitial", "2" },
              { "noonwithjeeminitial", "2" },
              { "noonwithkhahinitial", "2" },
              { "noonwithmeeminitial", "2" },
              { "noonwithmeemisolated", "2" },
              { "noonwithyehfinal", "2" },
              { "noonwithyehisolated", "2" },
              { "noonwithzainfinal", "2" },
              { "ntilde", "1" },
              { "numbersign", "1" },
              { "o", "1" },
              { "oacute", "1" },
              { "ocircumflex", "1" },
              { "odieresis", "1" },
              { "oe", "1" },
              { "ograve", "1" },
              { "one", "1" },
              { "onehalf", "1" },
              { "onequarter", "1" },
              { "onesuperior", "1" },
              { "ordfeminine", "1" },
              { "ordmasculine", "1" },
              { "ornateleftparenthesis", "1" },
              { "ornaterightparenthesis", "1" },
              { "oslash", "1" },
              { "otilde", "1" },
              { "p", "1" },
              { "paragraph", "1" },
              { "parenleft", "1" },
              { "parenright", "1" },
              { "peh", "1" },
              { "pehfinal", "1" },
              { "pehinitial", "1" },
              { "pehisolated", "1" },
              { "pehmedial", "1" },
              { "pehwithhehinitial", "2" },
              { "percent", "1" },
              { "period", "1" },
              { "periodcentered", "1" },
              { "perthousand", "1" },
              { "plus", "1" },
              { "plusminus", "1" },
              { "q", "1" },
              { "qaf", "1" },
              { "qaffinal", "1" },
              { "qafinitial", "1" },
              { "qafisolated", "1" },
              { "qafmedial", "1" },
              { "question", "1" },
              { "questiondown", "1" },
              { "quotedash", "1" },
              { "quotedbl", "1" },
              { "quotedblbase", "1" },
              { "quotedblleft", "1" },
              { "quotedblright", "1" },
              { "quoteleft", "1" },
              { "quoteright", "1" },
              { "quotesinglbase", "1" },
              { "quotesingle", "1" },
              { "r", "1" },
              { "rayaleflam", "2" },
              { "registered", "1" },
              { "reh", "1" },
              { "rehfinal", "1" },
              { "rehisolated", "1" },
              { "righttoleft", "1" },
              { "s", "1" },
              { "sad", "1" },
              { "sadfinal", "1" },
              { "sadinitial", "1" },
              { "sadisolated", "1" },
              { "sadmedial", "1" },
              { "scaron", "1" },
              { "section", "1" },
              { "seen", "1" },
              { "seenfinal", "1" },
              { "seeninitial", "1" },
              { "seenisolated", "1" },
              { "seenmedial", "1" },
              { "seenwithmeeminitial", "2" },
              { "semicolon", "1" },
              { "seven", "1" },
              { "sfthyphen", "1" },
              { "shadda", "3" },
              { "shaddahontatweel", "1" },
              { "shaddaisolated", "1" },
              { "shaddalow", "1" },
              { "shaddawithdammaisolated", "1" },
              { "shaddawithdammaisolatedlow", "3" },
              { "shaddawithdammamedial", "1" },
              { "shaddawithdammatanisolated", "1" },
              { "shaddawithdammatanisolatedlow", "3" },
              { "shaddawithfathaisolated", "1" },
              { "shaddawithfathaisolatedlow", "3" },
              { "shaddawithfathamedial", "1" },
              { "shaddawithfathatanisolated", "3" },
              { "shaddawithfathatanisolatedlow", "3" },
              { "shaddawithkasraisolated", "1" },
              { "shaddawithkasraisolatedlow", "3" },
              { "shaddawithkasramedial", "1" },
              { "shaddawithkasratanisolated", "1" },
              { "shaddawithkasratanisolatedlow", "3" },
              { "sheen", "1" },
              { "sheenfinal", "1" },
              { "sheeninitial", "1" },
              { "sheenisolated", "1" },
              { "sheenmedial", "1" },
              { "sheenwithmeeminitial", "2" },
              { "six", "1" },
              { "slash", "1" },
              { "smallhighmadda", "3" },
              { "space", "1" },
              { "sterling", "1" },
              { "sukun", "3" },
              { "sukunisolated", "1" },
              { "sukunlow", "1" },
              { "sukunonhamza", "3" },
              { "sukunontatweel", "1" },
              { "superscriptalef", "3" },
              { "t", "1" },
              { "tah", "1" },
              { "tahfinal", "1" },
              { "tahinitial", "1" },
              { "tahisolated", "1" },
              { "tahmedial", "1" },
              { "tatweel", "1" },
              { "tcheh", "1" },
              { "tchehfinal", "1" },
              { "tchehinitial", "1" },
              { "tchehisolated", "1" },
              { "tchehmedial", "1" },
              { "teh", "1" },
              { "tehfinal", "1" },
              { "tehinitial", "1" },
              { "tehisolated", "1" },
              { "tehmarbuta", "1" },
              { "tehmarbutafinal", "1" },
              { "tehmarbutaisolated", "1" },
              { "tehmedial", "1" },
              { "tehwithalefmaksurafinal", "2" },
              { "tehwithhahinitial", "2" },
              { "tehwithhehinitial", "2" },
              { "tehwithjeeminitial", "2" },
              { "tehwithkhahinitial", "2" },
              { "tehwithmeeminitial", "2" },
              { "tehwithmeemisolated", "2" },
              { "tehwithnoonfinal", "2" },
              { "tehwithyehfinal", "2" },
              { "tehwithyehisolated", "2" },
              { "thal", "1" },
              { "thalfinal", "1" },
              { "thalisolated", "1" },
              { "theh", "1" },
              { "thehfinal", "1" },
              { "thehinitial", "1" },
              { "thehisolated", "1" },
              { "thehmedial", "1" },
              { "thehwithmeeminitial", "2" },
              { "thehwithmeemisolated", "2" },
              { "thorn", "1" },
              { "three", "1" },
              { "threequarters", "1" },
              { "threesuperior", "1" },
              { "tilde", "1" },
              { "trademark", "1" },
              { "two", "1" },
              { "twosuperior", "1" },
              { "u", "1" },
              { "uacute", "1" },
              { "ucircumflex", "1" },
              { "udieresis", "1" },
              { "ugrave", "1" },
              { "underscore", "1" },
              { "uni000D", "1" },
              { "uni0649.init", "1" },
              { "uni0649.medi", "1" },
              { "uni0654", "3" },
              { "uni0655", "3" },
              { "uni0655064D", "3" },
              { "uni06550650", "3" },
              { "uni25CC", "1" },
              { "uniE817", "2" },
              { "v", "1" },
              { "veh", "1" },
              { "vehfinal", "1" },
              { "vehinitial", "1" },
              { "vehisolated", "1" },
              { "vehmedial", "1" },
              { "w", "1" },
              { "waw", "1" },
              { "wawfinal", "1" },
              { "wawisolated", "1" },
              { "wawwithhamzaabove", "1" },
              { "wawwithhamzaabovefinal", "1" },
              { "wawwithhamzaaboveisolated", "1" },
              { "x", "1" },
              { "y", "1" },
              { "yacute", "1" },
              { "ydieresis", "1" },
              { "yeh", "1" },
              { "yehfinal", "1" },
              { "yehinitial", "1" },
              { "yehisolated", "1" },
              { "yehmedial", "1" },
              { "yehwithalefmaksurafinal", "2" },
              { "yehwithalefmaksuraisolated", "2" },
              { "yehwithhahinitial", "2" },
              { "yehwithhamzaabove", "1" },
              { "yehwithhamzaabovefinal", "1" },
              { "yehwithhamzaaboveinitial", "1" },
              { "yehwithhamzaaboveisolated", "1" },
              { "yehwithhamzaabovemedial", "1" },
              { "yehwithjeeminitial", "2" },
              { "yehwithkhahinitial", "2" },
              { "yehwithmeeminitial", "2" },
              { "yehwithmeemisolated", "2" },
              { "yehwithnoonfinal", "2" },
              { "yehwithrehfinal", "2" },
              { "yen", "1" },
              { "z", "1" },
              { "zah", "1" },
              { "zahfinal", "1" },
              { "zahinitial", "1" },
              { "zahisolated", "1" },
              { "zahmedial", "1" },
              { "zain", "1" },
              { "zainfinal", "1" },
              { "zainisolated", "1" },
              { "zcaron", "1" },
              { "zero", "1" },
              { "zerojoin", "1" },
              { "zeronojoin", "1" },
              { "zerowidthnobreakspace", "1" },
          },
        },
        // arab-003.ttx
        { "f2", "lu0",
          new String[][] {
              { "_bar", "1" },
              { "_damma", "1" },
              { "_dot1", "1" },
              { "_dot1_hat", "1" },
              { "_dot1_smallV", "1" },
              { "_dot1_tah", "1" },
              { "_dot2h", "1" },
              { "_dot2h_tah", "1" },
              { "_dot2v", "1" },
              { "_dot3d", "1" },
              { "_dot3h", "1" },
              { "_dot3u", "1" },
              { "_dot3u_tah", "1" },
              { "_dot4", "1" },
              { "_gafBar", "1" },
              { "_gafBar_dot2h", "1" },
              { "_gafBar_dot3u", "1" },
              { "_hamza", "1" },
              { "_hamzaDamma", "1" },
              { "_hat", "1" },
              { "_highHamza", "1" },
              { "_hook", "1" },
              { "_invSmallV", "1" },
              { "_lines", "1" },
              { "_madda", "1" },
              { "_ring", "1" },
              { "_smallV", "1" },
              { "_tah", "1" },
              { "_vline", "1" },
              { "_wasla", "1" },
              { "_wavyHamza", "1" },
              { "_wavyHamza.b", "1" },
              { "a", "1" },
              { "absAutoKashida", "1" },
              { "absJeemRetro1", "1" },
              { "absJeemRetro1Fin", "1" },
              { "absJeemRetro1Ini", "1" },
              { "absJeemRetro1Med", "1" },
              { "absJeemRetro2", "1" },
              { "absJeemRetro2Fin", "1" },
              { "absJeemRetro2Ini", "1" },
              { "absJeemRetro2Med", "1" },
              { "absJeemRetro3", "1" },
              { "absJeemRetro3Fin", "1" },
              { "absJeemRetro3Ini", "1" },
              { "absJeemRetro3Med", "1" },
              { "absJehRetro1", "1" },
              { "absJehRetro1Fin", "1" },
              { "absJehRetro2", "1" },
              { "absJehRetro2Fin", "1" },
              { "absLamRetro", "1" },
              { "absLamRetroAlef", "2" },
              { "absLamRetroAlefFin", "2" },
              { "absLamRetroFin", "1" },
              { "absLamRetroIni", "1" },
              { "absLamRetroIni.preAlef", "1" },
              { "absLamRetroMed", "1" },
              { "absLamRetroMed.preAlef", "1" },
              { "absShaddaAlef", "3" },
              { "absSheenRetro1", "1" },
              { "absSheenRetro1Fin", "1" },
              { "absSheenRetro1Ini", "1" },
              { "absSheenRetro1Med", "1" },
              { "absSheenRetro2", "1" },
              { "absSheenRetro2Fin", "1" },
              { "absSheenRetro2Ini", "1" },
              { "absSheenRetro2Med", "1" },
              { "absTchehRetro1", "1" },
              { "absTchehRetro1Fin", "1" },
              { "absTchehRetro1Ini", "1" },
              { "absTchehRetro1Med", "1" },
              { "absTchehRetro2", "1" },
              { "absTchehRetro2Fin", "1" },
              { "absTchehRetro2Ini", "1" },
              { "absTchehRetro2Med", "1" },
              { "absWawDotBelow", "1" },
              { "absWawDotBelowFin", "1" },
              { "ampersand", "1" },
              { "asciicircum", "1" },
              { "asciitilde", "1" },
              { "asterisk", "1" },
              { "asterisk.arab", "1" },
              { "at", "1" },
              { "b", "1" },
              { "backslash", "1" },
              { "bar", "1" },
              { "braceleft", "1" },
              { "braceright", "1" },
              { "bracketleft", "1" },
              { "bracketright", "1" },
              { "c", "1" },
              { "colon", "1" },
              { "colon.arab", "1" },
              { "comma", "1" },
              { "d", "1" },
              { "dollar", "1" },
              { "e", "1" },
              { "eight", "1" },
              { "eightMedium", "3" },
              { "eightSmall", "3" },
              { "equal", "1" },
              { "exclam", "1" },
              { "exclam.arab", "1" },
              { "f", "1" },
              { "five", "1" },
              { "fiveMedium", "3" },
              { "fiveSmall", "3" },
              { "four", "1" },
              { "fourMedium", "3" },
              { "fourSmall", "3" },
              { "g", "1" },
              { "grave", "1" },
              { "greater", "1" },
              { "h", "1" },
              { "hyphen", "1" },
              { "i", "1" },
              { "j", "1" },
              { "k", "1" },
              { "l", "1" },
              { "less", "1" },
              { "m", "1" },
              { "n", "1" },
              { "nine", "1" },
              { "nineMedium", "3" },
              { "nineSmall", "3" },
              { "nonmarkingreturn", "1" },
              { "numbersign", "1" },
              { "o", "1" },
              { "one", "1" },
              { "oneMedium", "3" },
              { "oneSmall", "3" },
              { "p", "1" },
              { "parenleft", "1" },
              { "parenleft.arab", "1" },
              { "parenright", "1" },
              { "parenright.arab", "1" },
              { "percent", "1" },
              { "period", "1" },
              { "plus", "1" },
              { "q", "1" },
              { "question", "1" },
              { "quotedbl", "1" },
              { "quotedblleft.arab", "1" },
              { "quotedblright.arab", "1" },
              { "quoteleft.arab", "1" },
              { "quoteright.arab", "1" },
              { "quotesingle", "1" },
              { "r", "1" },
              { "s", "1" },
              { "semicolon", "1" },
              { "seven", "1" },
              { "sevenMedium", "3" },
              { "sevenSmall", "3" },
              { "six", "1" },
              { "sixMedium", "3" },
              { "sixSmall", "3" },
              { "slash", "1" },
              { "space", "1" },
              { "t", "1" },
              { "three", "1" },
              { "threeMedium", "3" },
              { "threeSmall", "3" },
              { "two", "1" },
              { "twoMedium", "3" },
              { "twoSmall", "3" },
              { "u", "1" },
              { "underscore", "1" },
              { "uni060C", "1" },
              { "uni060C.downward", "1" },
              { "uni0614", "3" },
              { "uni061B", "1" },
              { "uni061B.downward", "1" },
              { "uni061E", "1" },
              { "uni061F", "1" },
              { "uni0621", "1" },
              { "uni0622", "1" },
              { "uni0622.fina", "1" },
              { "uni0622.fina.postLamIni", "1" },
              { "uni0622.fina.postLamMed", "1" },
              { "uni0623", "1" },
              { "uni0623.fina", "1" },
              { "uni0623.fina.postLamIni", "1" },
              { "uni0623.fina.postLamMed", "1" },
              { "uni0624", "1" },
              { "uni0624.fina", "1" },
              { "uni0625", "1" },
              { "uni0625.fina", "1" },
              { "uni0625.fina.postLamIni", "1" },
              { "uni0625.fina.postLamMed", "1" },
              { "uni0626", "1" },
              { "uni0626.fina", "1" },
              { "uni0626.init", "1" },
              { "uni0626.medi", "1" },
              { "uni0627", "1" },
              { "uni0627.fina", "1" },
              { "uni0627.fina.postLamIni", "1" },
              { "uni0627.fina.postLamMed", "1" },
              { "uni0628", "1" },
              { "uni0628.fina", "1" },
              { "uni0628.init", "1" },
              { "uni0628.medi", "1" },
              { "uni0629", "1" },
              { "uni0629.fina", "1" },
              { "uni062A", "1" },
              { "uni062A.fina", "1" },
              { "uni062A.init", "1" },
              { "uni062A.medi", "1" },
              { "uni062B", "1" },
              { "uni062B.fina", "1" },
              { "uni062B.init", "1" },
              { "uni062B.medi", "1" },
              { "uni062C", "1" },
              { "uni062C.fina", "1" },
              { "uni062C.init", "1" },
              { "uni062C.medi", "1" },
              { "uni062D", "1" },
              { "uni062D.fina", "1" },
              { "uni062D.init", "1" },
              { "uni062D.medi", "1" },
              { "uni062E", "1" },
              { "uni062E.fina", "1" },
              { "uni062E.init", "1" },
              { "uni062E.medi", "1" },
              { "uni062F", "1" },
              { "uni062F.fina", "1" },
              { "uni0630", "1" },
              { "uni0630.fina", "1" },
              { "uni0631", "1" },
              { "uni0631.fina", "1" },
              { "uni0632", "1" },
              { "uni0632.fina", "1" },
              { "uni0633", "1" },
              { "uni0633.fina", "1" },
              { "uni0633.init", "1" },
              { "uni0633.medi", "1" },
              { "uni0634", "1" },
              { "uni0634.fina", "1" },
              { "uni0634.init", "1" },
              { "uni0634.medi", "1" },
              { "uni0635", "1" },
              { "uni0635.fina", "1" },
              { "uni0635.init", "1" },
              { "uni0635.medi", "1" },
              { "uni0636", "1" },
              { "uni0636.fina", "1" },
              { "uni0636.init", "1" },
              { "uni0636.medi", "1" },
              { "uni0637", "1" },
              { "uni0637.fina", "1" },
              { "uni0637.init", "1" },
              { "uni0637.medi", "1" },
              { "uni0638", "1" },
              { "uni0638.fina", "1" },
              { "uni0638.init", "1" },
              { "uni0638.medi", "1" },
              { "uni0639", "1" },
              { "uni0639.fina", "1" },
              { "uni0639.init", "1" },
              { "uni0639.medi", "1" },
              { "uni063A", "1" },
              { "uni063A.fina", "1" },
              { "uni063A.init", "1" },
              { "uni063A.medi", "1" },
              { "uni0640", "1" },
              { "uni0641", "1" },
              { "uni0641.fina", "1" },
              { "uni0641.init", "1" },
              { "uni0641.medi", "1" },
              { "uni0642", "1" },
              { "uni0642.fina", "1" },
              { "uni0642.init", "1" },
              { "uni0642.medi", "1" },
              { "uni0643", "1" },
              { "uni0643.fina", "1" },
              { "uni0643.init", "1" },
              { "uni0643.medi", "1" },
              { "uni0644", "1" },
              { "uni0644.fina", "1" },
              { "uni0644.init", "1" },
              { "uni0644.init.preAlef", "1" },
              { "uni0644.medi", "1" },
              { "uni0644.medi.preAlef", "1" },
              { "uni06440627", "2" },
              { "uni06440627.fina", "2" },
              { "uni0645", "1" },
              { "uni0645.fina", "1" },
              { "uni0645.fina.sindhi", "1" },
              { "uni0645.init", "1" },
              { "uni0645.medi", "1" },
              { "uni0645.sindhi", "1" },
              { "uni0646", "1" },
              { "uni0646.fina", "1" },
              { "uni0646.init", "1" },
              { "uni0646.medi", "1" },
              { "uni0647", "1" },
              { "uni0647.fina", "1" },
              { "uni0647.fina.hooked", "1" },
              { "uni0647.fina.knottedFlat", "1" },
              { "uni0647.fina.knottedHigh", "1" },
              { "uni0647.init", "1" },
              { "uni0647.init.hooked", "1" },
              { "uni0647.knotted", "1" },
              { "uni0647.medi", "1" },
              { "uni0647.medi.hooked", "1" },
              { "uni0647.medi.knottedHigh", "1" },
              { "uni0648", "1" },
              { "uni0648.fina", "1" },
              { "uni0649", "1" },
              { "uni0649.fina", "1" },
              { "uni0649.init", "1" },
              { "uni0649.medi", "1" },
              { "uni064A", "1" },
              { "uni064A.fina", "1" },
              { "uni064A.fina.noDots", "1" },
              { "uni064A.init", "1" },
              { "uni064A.init.noDots", "1" },
              { "uni064A.medi", "1" },
              { "uni064A.medi.noDots", "1" },
              { "uni064A.noDots", "1" },
              { "uni064B", "3" },
              { "uni064C", "3" },
              { "uni064C.sixNine", "3" },
              { "uni064D", "3" },
              { "uni064E", "3" },
              { "uni064F", "3" },
              { "uni0650", "3" },
              { "uni0651", "3" },
              { "uni0651064B", "3" },
              { "uni0651064C", "3" },
              { "uni0651064D", "3" },
              { "uni0651064E", "3" },
              { "uni0651064F", "3" },
              { "uni06510650", "3" },
              { "uni0652", "3" },
              { "uni0652.downOpen", "3" },
              { "uni0652.leftOpen", "3" },
              { "uni0653", "3" },
              { "uni0654", "3" },
              { "uni0654064E", "3" },
              { "uni0654064F", "3" },
              { "uni0655", "3" },
              { "uni0656", "3" },
              { "uni0657", "3" },
              { "uni0658", "3" },
              { "uni0659", "3" },
              { "uni065A", "3" },
              { "uni065B", "3" },
              { "uni065C", "3" },
              { "uni065D", "3" },
              { "uni065E", "3" },
              { "uni0660", "1" },
              { "uni0660.Medium", "3" },
              { "uni0660.Small", "3" },
              { "uni0661", "1" },
              { "uni0661.Medium", "3" },
              { "uni0661.Small", "3" },
              { "uni0662", "1" },
              { "uni0662.Medium", "3" },
              { "uni0662.Small", "3" },
              { "uni0663", "1" },
              { "uni0663.Medium", "3" },
              { "uni0663.Small", "3" },
              { "uni0664", "1" },
              { "uni0664.Medium", "3" },
              { "uni0664.Small", "3" },
              { "uni0665", "1" },
              { "uni0665.Medium", "3" },
              { "uni0665.Small", "3" },
              { "uni0666", "1" },
              { "uni0666.Medium", "3" },
              { "uni0666.Small", "3" },
              { "uni0667", "1" },
              { "uni0667.Medium", "3" },
              { "uni0667.Small", "3" },
              { "uni0668", "1" },
              { "uni0668.Medium", "3" },
              { "uni0668.Small", "3" },
              { "uni0669", "1" },
              { "uni0669.Medium", "3" },
              { "uni0669.Small", "3" },
              { "uni066A", "1" },
              { "uni066B", "1" },
              { "uni066C", "1" },
              { "uni066D", "1" },
              { "uni066E", "1" },
              { "uni066E.fina", "1" },
              { "uni066E.init", "1" },
              { "uni066E.medi", "1" },
              { "uni066F", "1" },
              { "uni066F.fina", "1" },
              { "uni066F.init", "1" },
              { "uni066F.medi", "1" },
              { "uni0670", "3" },
              { "uni0670.large", "3" },
              { "uni0671", "1" },
              { "uni0671.fina", "1" },
              { "uni0671.fina.postLamIni", "1" },
              { "uni0671.fina.postLamMed", "1" },
              { "uni0672", "1" },
              { "uni0672.fina", "1" },
              { "uni0672.fina.postLamIni", "1" },
              { "uni0672.fina.postLamMed", "1" },
              { "uni0673", "1" },
              { "uni0673.fina", "1" },
              { "uni0673.fina.postLamIni", "1" },
              { "uni0673.fina.postLamMed", "1" },
              { "uni0674", "3" },
              { "uni0675", "1" },
              { "uni0675.fina", "1" },
              { "uni0675.fina.postLamIni", "1" },
              { "uni0675.fina.postLamMed", "1" },
              { "uni0676", "1" },
              { "uni0676.fina", "1" },
              { "uni0677", "1" },
              { "uni0677.fina", "1" },
              { "uni0678", "1" },
              { "uni0678.fina", "1" },
              { "uni0678.init", "1" },
              { "uni0678.medi", "1" },
              { "uni0679", "1" },
              { "uni0679.fina", "1" },
              { "uni0679.init", "1" },
              { "uni0679.medi", "1" },
              { "uni067A", "1" },
              { "uni067A.fina", "1" },
              { "uni067A.init", "1" },
              { "uni067A.medi", "1" },
              { "uni067B", "1" },
              { "uni067B.fina", "1" },
              { "uni067B.init", "1" },
              { "uni067B.medi", "1" },
              { "uni067C", "1" },
              { "uni067C.fina", "1" },
              { "uni067C.init", "1" },
              { "uni067C.medi", "1" },
              { "uni067D", "1" },
              { "uni067D.fina", "1" },
              { "uni067D.init", "1" },
              { "uni067D.medi", "1" },
              { "uni067E", "1" },
              { "uni067E.fina", "1" },
              { "uni067E.init", "1" },
              { "uni067E.medi", "1" },
              { "uni067F", "1" },
              { "uni067F.fina", "1" },
              { "uni067F.init", "1" },
              { "uni067F.medi", "1" },
              { "uni0680", "1" },
              { "uni0680.fina", "1" },
              { "uni0680.init", "1" },
              { "uni0680.medi", "1" },
              { "uni0681", "1" },
              { "uni0681.fina", "1" },
              { "uni0681.init", "1" },
              { "uni0681.medi", "1" },
              { "uni0682", "1" },
              { "uni0682.fina", "1" },
              { "uni0682.init", "1" },
              { "uni0682.medi", "1" },
              { "uni0683", "1" },
              { "uni0683.fina", "1" },
              { "uni0683.init", "1" },
              { "uni0683.medi", "1" },
              { "uni0684", "1" },
              { "uni0684.fina", "1" },
              { "uni0684.init", "1" },
              { "uni0684.medi", "1" },
              { "uni0685", "1" },
              { "uni0685.fina", "1" },
              { "uni0685.init", "1" },
              { "uni0685.medi", "1" },
              { "uni0686", "1" },
              { "uni0686.fina", "1" },
              { "uni0686.init", "1" },
              { "uni0686.medi", "1" },
              { "uni0687", "1" },
              { "uni0687.fina", "1" },
              { "uni0687.init", "1" },
              { "uni0687.medi", "1" },
              { "uni0688", "1" },
              { "uni0688.fina", "1" },
              { "uni0689", "1" },
              { "uni0689.fina", "1" },
              { "uni068A", "1" },
              { "uni068A.fina", "1" },
              { "uni068B", "1" },
              { "uni068B.fina", "1" },
              { "uni068C", "1" },
              { "uni068C.fina", "1" },
              { "uni068D", "1" },
              { "uni068D.fina", "1" },
              { "uni068E", "1" },
              { "uni068E.fina", "1" },
              { "uni068F", "1" },
              { "uni068F.fina", "1" },
              { "uni0690", "1" },
              { "uni0690.fina", "1" },
              { "uni0691", "1" },
              { "uni0691.fina", "1" },
              { "uni0692", "1" },
              { "uni0692.fina", "1" },
              { "uni0693", "1" },
              { "uni0693.fina", "1" },
              { "uni0694", "1" },
              { "uni0694.fina", "1" },
              { "uni0695", "1" },
              { "uni0695.fina", "1" },
              { "uni0696", "1" },
              { "uni0696.fina", "1" },
              { "uni0697", "1" },
              { "uni0697.fina", "1" },
              { "uni0698", "1" },
              { "uni0698.dotHat", "1" },
              { "uni0698.fina", "1" },
              { "uni0698.fina.dotHat", "1" },
              { "uni0699", "1" },
              { "uni0699.fina", "1" },
              { "uni069A", "1" },
              { "uni069A.fina", "1" },
              { "uni069A.init", "1" },
              { "uni069A.medi", "1" },
              { "uni069B", "1" },
              { "uni069B.fina", "1" },
              { "uni069B.init", "1" },
              { "uni069B.medi", "1" },
              { "uni069C", "1" },
              { "uni069C.fina", "1" },
              { "uni069C.init", "1" },
              { "uni069C.medi", "1" },
              { "uni069D", "1" },
              { "uni069D.fina", "1" },
              { "uni069D.init", "1" },
              { "uni069D.medi", "1" },
              { "uni069E", "1" },
              { "uni069E.fina", "1" },
              { "uni069E.init", "1" },
              { "uni069E.medi", "1" },
              { "uni069F", "1" },
              { "uni069F.fina", "1" },
              { "uni069F.init", "1" },
              { "uni069F.medi", "1" },
              { "uni06A0", "1" },
              { "uni06A0.fina", "1" },
              { "uni06A0.init", "1" },
              { "uni06A0.medi", "1" },
              { "uni06A1", "1" },
              { "uni06A1.fina", "1" },
              { "uni06A1.init", "1" },
              { "uni06A1.medi", "1" },
              { "uni06A2", "1" },
              { "uni06A2.fina", "1" },
              { "uni06A2.init", "1" },
              { "uni06A2.medi", "1" },
              { "uni06A3", "1" },
              { "uni06A3.fina", "1" },
              { "uni06A3.init", "1" },
              { "uni06A3.medi", "1" },
              { "uni06A4", "1" },
              { "uni06A4.fina", "1" },
              { "uni06A4.init", "1" },
              { "uni06A4.medi", "1" },
              { "uni06A5", "1" },
              { "uni06A5.fina", "1" },
              { "uni06A5.init", "1" },
              { "uni06A5.medi", "1" },
              { "uni06A6", "1" },
              { "uni06A6.fina", "1" },
              { "uni06A6.init", "1" },
              { "uni06A6.medi", "1" },
              { "uni06A7", "1" },
              { "uni06A7.fina", "1" },
              { "uni06A7.init", "1" },
              { "uni06A7.medi", "1" },
              { "uni06A8", "1" },
              { "uni06A8.fina", "1" },
              { "uni06A8.init", "1" },
              { "uni06A8.medi", "1" },
              { "uni06A9", "1" },
              { "uni06A9.fina", "1" },
              { "uni06A9.init", "1" },
              { "uni06A9.medi", "1" },
              { "uni06AA", "1" },
              { "uni06AA.fina", "1" },
              { "uni06AA.init", "1" },
              { "uni06AA.medi", "1" },
              { "uni06AB", "1" },
              { "uni06AB.fina", "1" },
              { "uni06AB.init", "1" },
              { "uni06AB.medi", "1" },
              { "uni06AC", "1" },
              { "uni06AC.fina", "1" },
              { "uni06AC.init", "1" },
              { "uni06AC.medi", "1" },
              { "uni06AD", "1" },
              { "uni06AD.fina", "1" },
              { "uni06AD.init", "1" },
              { "uni06AD.medi", "1" },
              { "uni06AE", "1" },
              { "uni06AE.fina", "1" },
              { "uni06AE.init", "1" },
              { "uni06AE.medi", "1" },
              { "uni06AF", "1" },
              { "uni06AF.fina", "1" },
              { "uni06AF.init", "1" },
              { "uni06AF.medi", "1" },
              { "uni06B0", "1" },
              { "uni06B0.fina", "1" },
              { "uni06B0.init", "1" },
              { "uni06B0.medi", "1" },
              { "uni06B1", "1" },
              { "uni06B1.fina", "1" },
              { "uni06B1.init", "1" },
              { "uni06B1.medi", "1" },
              { "uni06B2", "1" },
              { "uni06B2.fina", "1" },
              { "uni06B2.init", "1" },
              { "uni06B2.medi", "1" },
              { "uni06B3", "1" },
              { "uni06B3.fina", "1" },
              { "uni06B3.init", "1" },
              { "uni06B3.medi", "1" },
              { "uni06B4", "1" },
              { "uni06B4.fina", "1" },
              { "uni06B4.init", "1" },
              { "uni06B4.medi", "1" },
              { "uni06B5", "1" },
              { "uni06B5.fina", "1" },
              { "uni06B5.init", "1" },
              { "uni06B5.init.preAlef", "1" },
              { "uni06B5.medi", "1" },
              { "uni06B5.medi.preAlef", "1" },
              { "uni06B50627", "2" },
              { "uni06B50627.fina", "2" },
              { "uni06B6", "1" },
              { "uni06B6.fina", "1" },
              { "uni06B6.init", "1" },
              { "uni06B6.init.preAlef", "1" },
              { "uni06B6.medi", "1" },
              { "uni06B6.medi.preAlef", "1" },
              { "uni06B60627", "2" },
              { "uni06B60627.fina", "2" },
              { "uni06B7", "1" },
              { "uni06B7.fina", "1" },
              { "uni06B7.init", "1" },
              { "uni06B7.init.preAlef", "1" },
              { "uni06B7.medi", "1" },
              { "uni06B7.medi.preAlef", "1" },
              { "uni06B70627", "2" },
              { "uni06B70627.fina", "2" },
              { "uni06B8", "1" },
              { "uni06B8.fina", "1" },
              { "uni06B8.init", "1" },
              { "uni06B8.init.preAlef", "1" },
              { "uni06B8.medi", "1" },
              { "uni06B8.medi.preAlef", "1" },
              { "uni06B80627", "2" },
              { "uni06B80627.fina", "2" },
              { "uni06B9", "1" },
              { "uni06B9.fina", "1" },
              { "uni06B9.init", "1" },
              { "uni06B9.medi", "1" },
              { "uni06BA", "1" },
              { "uni06BA.fina", "1" },
              { "uni06BA.init", "1" },
              { "uni06BA.medi", "1" },
              { "uni06BB", "1" },
              { "uni06BB.fina", "1" },
              { "uni06BB.init", "1" },
              { "uni06BB.medi", "1" },
              { "uni06BC", "1" },
              { "uni06BC.fina", "1" },
              { "uni06BC.init", "1" },
              { "uni06BC.medi", "1" },
              { "uni06BD", "1" },
              { "uni06BD.fina", "1" },
              { "uni06BD.init", "1" },
              { "uni06BD.medi", "1" },
              { "uni06BE", "1" },
              { "uni06BE.fina", "1" },
              { "uni06BE.init", "1" },
              { "uni06BE.medi", "1" },
              { "uni06BF", "1" },
              { "uni06BF.fina", "1" },
              { "uni06BF.init", "1" },
              { "uni06BF.medi", "1" },
              { "uni06C0", "1" },
              { "uni06C0.fina", "1" },
              { "uni06C0.init", "1" },
              { "uni06C0.medi", "1" },
              { "uni06C1", "1" },
              { "uni06C1.fina", "1" },
              { "uni06C1.init", "1" },
              { "uni06C1.medi", "1" },
              { "uni06C2", "1" },
              { "uni06C2.fina", "1" },
              { "uni06C2.init", "1" },
              { "uni06C2.medi", "1" },
              { "uni06C3", "1" },
              { "uni06C3.fina", "1" },
              { "uni06C4", "1" },
              { "uni06C4.fina", "1" },
              { "uni06C5", "1" },
              { "uni06C5.fina", "1" },
              { "uni06C6", "1" },
              { "uni06C6.fina", "1" },
              { "uni06C7", "1" },
              { "uni06C7.fina", "1" },
              { "uni06C8", "1" },
              { "uni06C8.fina", "1" },
              { "uni06C9", "1" },
              { "uni06C9.fina", "1" },
              { "uni06CA", "1" },
              { "uni06CA.fina", "1" },
              { "uni06CB", "1" },
              { "uni06CB.fina", "1" },
              { "uni06CC", "1" },
              { "uni06CC.fina", "1" },
              { "uni06CC.init", "1" },
              { "uni06CC.medi", "1" },
              { "uni06CD", "1" },
              { "uni06CD.fina", "1" },
              { "uni06CE", "1" },
              { "uni06CE.fina", "1" },
              { "uni06CE.init", "1" },
              { "uni06CE.medi", "1" },
              { "uni06CF", "1" },
              { "uni06CF.fina", "1" },
              { "uni06D0", "1" },
              { "uni06D0.fina", "1" },
              { "uni06D0.init", "1" },
              { "uni06D0.medi", "1" },
              { "uni06D1", "1" },
              { "uni06D1.fina", "1" },
              { "uni06D1.init", "1" },
              { "uni06D1.medi", "1" },
              { "uni06D2", "1" },
              { "uni06D2.fina", "1" },
              { "uni06D3", "1" },
              { "uni06D3.fina", "1" },
              { "uni06D4", "1" },
              { "uni06D5", "1" },
              { "uni06D6", "3" },
              { "uni06D7", "3" },
              { "uni06D8", "3" },
              { "uni06D9", "3" },
              { "uni06DA", "3" },
              { "uni06DB", "3" },
              { "uni06DC", "3" },
              { "uni06DD", "1" },
              { "uni06DD.2", "1" },
              { "uni06DD.3", "1" },
              { "uni06DD.aat1", "1" },
              { "uni06DD.aat2", "1" },
              { "uni06DD.aat3", "1" },
              { "uni06DD.sp1", "1" },
              { "uni06DD.sp2", "1" },
              { "uni06DD.sp3", "1" },
              { "uni06DE", "1" },
              { "uni06DF", "3" },
              { "uni06E0", "3" },
              { "uni06E1", "3" },
              { "uni06E2", "3" },
              { "uni06E3", "3" },
              { "uni06E4", "3" },
              { "uni06E5", "3" },
              { "uni06E6", "3" },
              { "uni06E7", "3" },
              { "uni06E8", "3" },
              { "uni06E9", "1" },
              { "uni06EA", "3" },
              { "uni06EB", "3" },
              { "uni06EC", "3" },
              { "uni06ED", "3" },
              { "uni06EE", "1" },
              { "uni06EE.fina", "1" },
              { "uni06EF", "1" },
              { "uni06EF.fina", "1" },
              { "uni06F0", "1" },
              { "uni06F0.Medium", "3" },
              { "uni06F0.Small", "3" },
              { "uni06F1", "1" },
              { "uni06F1.Medium", "3" },
              { "uni06F1.Small", "3" },
              { "uni06F2", "1" },
              { "uni06F2.Medium", "3" },
              { "uni06F2.Small", "3" },
              { "uni06F3", "1" },
              { "uni06F3.Medium", "3" },
              { "uni06F3.Small", "3" },
              { "uni06F4", "1" },
              { "uni06F4.Medium", "3" },
              { "uni06F4.Medium.urdu", "3" },
              { "uni06F4.Small", "3" },
              { "uni06F4.Small.urdu", "3" },
              { "uni06F4.urdu", "1" },
              { "uni06F5", "1" },
              { "uni06F5.Medium", "3" },
              { "uni06F5.Small", "3" },
              { "uni06F6", "1" },
              { "uni06F6.Medium", "3" },
              { "uni06F6.Medium.urdu", "3" },
              { "uni06F6.Small", "3" },
              { "uni06F6.Small.urdu", "3" },
              { "uni06F6.urdu", "1" },
              { "uni06F7", "1" },
              { "uni06F7.Medium", "3" },
              { "uni06F7.Medium.urdu", "3" },
              { "uni06F7.Small", "3" },
              { "uni06F7.Small.urdu", "3" },
              { "uni06F7.urdu", "1" },
              { "uni06F8", "1" },
              { "uni06F8.Medium", "3" },
              { "uni06F8.Small", "3" },
              { "uni06F9", "1" },
              { "uni06F9.Medium", "3" },
              { "uni06F9.Small", "3" },
              { "uni06FA", "1" },
              { "uni06FA.fina", "1" },
              { "uni06FA.init", "1" },
              { "uni06FA.medi", "1" },
              { "uni06FB", "1" },
              { "uni06FB.fina", "1" },
              { "uni06FB.init", "1" },
              { "uni06FB.medi", "1" },
              { "uni06FC", "1" },
              { "uni06FC.fina", "1" },
              { "uni06FC.init", "1" },
              { "uni06FC.medi", "1" },
              { "uni06FD", "1" },
              { "uni06FE", "1" },
              { "uni06FF", "1" },
              { "uni06FF.fina", "1" },
              { "uni06FF.init", "1" },
              { "uni06FF.medi", "1" },
              { "uni0750", "1" },
              { "uni0750.fina", "1" },
              { "uni0750.init", "1" },
              { "uni0750.medi", "1" },
              { "uni0751", "1" },
              { "uni0751.fina", "1" },
              { "uni0751.init", "1" },
              { "uni0751.medi", "1" },
              { "uni0752", "1" },
              { "uni0752.fina", "1" },
              { "uni0752.init", "1" },
              { "uni0752.medi", "1" },
              { "uni0753", "1" },
              { "uni0753.fina", "1" },
              { "uni0753.init", "1" },
              { "uni0753.medi", "1" },
              { "uni0754", "1" },
              { "uni0754.fina", "1" },
              { "uni0754.init", "1" },
              { "uni0754.medi", "1" },
              { "uni0755", "1" },
              { "uni0755.fina", "1" },
              { "uni0755.init", "1" },
              { "uni0755.medi", "1" },
              { "uni0756", "1" },
              { "uni0756.fina", "1" },
              { "uni0756.init", "1" },
              { "uni0756.medi", "1" },
              { "uni0757", "1" },
              { "uni0757.fina", "1" },
              { "uni0757.init", "1" },
              { "uni0757.medi", "1" },
              { "uni0758", "1" },
              { "uni0758.fina", "1" },
              { "uni0758.init", "1" },
              { "uni0758.medi", "1" },
              { "uni0759", "1" },
              { "uni0759.fina", "1" },
              { "uni075A", "1" },
              { "uni075A.fina", "1" },
              { "uni075B", "1" },
              { "uni075B.fina", "1" },
              { "uni075C", "1" },
              { "uni075C.fina", "1" },
              { "uni075C.init", "1" },
              { "uni075C.medi", "1" },
              { "uni075D", "1" },
              { "uni075D.fina", "1" },
              { "uni075D.init", "1" },
              { "uni075D.medi", "1" },
              { "uni075E", "1" },
              { "uni075E.fina", "1" },
              { "uni075E.init", "1" },
              { "uni075E.medi", "1" },
              { "uni075F", "1" },
              { "uni075F.fina", "1" },
              { "uni075F.init", "1" },
              { "uni075F.medi", "1" },
              { "uni0760", "1" },
              { "uni0760.fina", "1" },
              { "uni0760.init", "1" },
              { "uni0760.medi", "1" },
              { "uni0761", "1" },
              { "uni0761.fina", "1" },
              { "uni0761.init", "1" },
              { "uni0761.medi", "1" },
              { "uni0762", "1" },
              { "uni0762.fina", "1" },
              { "uni0762.init", "1" },
              { "uni0762.medi", "1" },
              { "uni0763", "1" },
              { "uni0763.fina", "1" },
              { "uni0763.init", "1" },
              { "uni0763.medi", "1" },
              { "uni0764", "1" },
              { "uni0764.fina", "1" },
              { "uni0764.init", "1" },
              { "uni0764.medi", "1" },
              { "uni0765", "1" },
              { "uni0765.fina", "1" },
              { "uni0765.init", "1" },
              { "uni0765.medi", "1" },
              { "uni0766", "1" },
              { "uni0766.fina", "1" },
              { "uni0766.init", "1" },
              { "uni0766.medi", "1" },
              { "uni0767", "1" },
              { "uni0767.fina", "1" },
              { "uni0767.init", "1" },
              { "uni0767.medi", "1" },
              { "uni0768", "1" },
              { "uni0768.fina", "1" },
              { "uni0768.init", "1" },
              { "uni0768.medi", "1" },
              { "uni0769", "1" },
              { "uni0769.fina", "1" },
              { "uni0769.init", "1" },
              { "uni0769.medi", "1" },
              { "uni076A", "1" },
              { "uni076A.fina", "1" },
              { "uni076A.init", "1" },
              { "uni076A.init.preAlef", "1" },
              { "uni076A.medi", "1" },
              { "uni076A.medi.preAlef", "1" },
              { "uni076A0627", "2" },
              { "uni076A0627.fina", "2" },
              { "uni076B", "1" },
              { "uni076B.fina", "1" },
              { "uni076C", "1" },
              { "uni076C.fina", "1" },
              { "uni076D", "1" },
              { "uni076D.fina", "1" },
              { "uni076D.init", "1" },
              { "uni076D.medi", "1" },
              { "uni2000", "1" },
              { "uni2001", "1" },
              { "uni2002", "1" },
              { "uni2003", "1" },
              { "uni2004", "1" },
              { "uni2005", "1" },
              { "uni2006", "1" },
              { "uni2007", "1" },
              { "uni2008", "1" },
              { "uni2009", "1" },
              { "uni200A", "1" },
              { "uni200B", "1" },
              { "uni200C", "1" },
              { "uni200D", "1" },
              { "uni200E", "1" },
              { "uni200F", "1" },
              { "uni202A", "1" },
              { "uni202B", "1" },
              { "uni202C", "1" },
              { "uni202D", "1" },
              { "uni202E", "1" },
              { "uni2060", "1" },
              { "uni206C", "1" },
              { "uni206D", "1" },
              { "uni25CC", "1" },
              { "uniFD3E", "1" },
              { "uniFD3F", "1" },
              { "uniFDF2", "1" },
              { "uniFDFC", "1" },
              { "uniFEFF", "1" },
              { "v", "1" },
              { "w", "1" },
              { "x", "1" },
              { "y", "1" },
              { "z", "1" },
              { "zero", "1" },
              { "zeroMedium", "3" },
              { "zeroSmall", "3" },
          },
        },
        // arab-004.ttx
        { "f3", "lu0",
          new String[][] {
              { "_bar", "1" },
              { "_damma", "1" },
              { "_dot1", "1" },
              { "_dot1_hat", "1" },
              { "_dot1_smallV", "1" },
              { "_dot1_tah", "1" },
              { "_dot2h", "1" },
              { "_dot2h_tah", "1" },
              { "_dot2v", "1" },
              { "_dot3d", "1" },
              { "_dot3h", "1" },
              { "_dot3u", "1" },
              { "_dot3u_tah", "1" },
              { "_dot4", "1" },
              { "_gafBar", "1" },
              { "_gafBarShort", "1" },
              { "_gafBarShort_dot2h", "1" },
              { "_gafBarShort_dot3u", "1" },
              { "_gafBar_dot2h", "1" },
              { "_gafBar_dot3u", "1" },
              { "_hamza", "1" },
              { "_hamzaDamma", "1" },
              { "_hat", "1" },
              { "_highHamza", "1" },
              { "_invSmallV", "1" },
              { "_lines", "1" },
              { "_madda", "1" },
              { "_ring", "1" },
              { "_smallV", "1" },
              { "_tah", "1" },
              { "_vline", "1" },
              { "_wasla", "1" },
              { "_wavyHamza", "1" },
              { "_wavyHamza.b", "1" },
              { "a", "1" },
              { "absAutoKashida", "1" },
              { "absJeemRetro1", "1" },
              { "absJeemRetro1Fin", "1" },
              { "absJeemRetro1Ini", "1" },
              { "absJeemRetro1Med", "1" },
              { "absJeemRetro2", "1" },
              { "absJeemRetro2Fin", "1" },
              { "absJeemRetro2Ini", "1" },
              { "absJeemRetro2Med", "1" },
              { "absJeemRetro3", "1" },
              { "absJeemRetro3Fin", "1" },
              { "absJeemRetro3Ini", "1" },
              { "absJeemRetro3Med", "1" },
              { "absJehRetro1", "1" },
              { "absJehRetro1Fin", "1" },
              { "absJehRetro2", "1" },
              { "absJehRetro2Fin", "1" },
              { "absLamRetro", "1" },
              { "absLamRetroAlef", "2" },
              { "absLamRetroAlefFin", "2" },
              { "absLamRetroFin", "1" },
              { "absLamRetroIni", "1" },
              { "absLamRetroIni.preAlef", "1" },
              { "absLamRetroMed", "1" },
              { "absLamRetroMed.preAlef", "1" },
              { "absShaddaAlef", "3" },
              { "absSheenRetro1", "1" },
              { "absSheenRetro1Fin", "1" },
              { "absSheenRetro1Ini", "1" },
              { "absSheenRetro1Med", "1" },
              { "absSheenRetro2", "1" },
              { "absSheenRetro2Fin", "1" },
              { "absSheenRetro2Ini", "1" },
              { "absSheenRetro2Med", "1" },
              { "absTchehRetro1", "1" },
              { "absTchehRetro1Fin", "1" },
              { "absTchehRetro1Ini", "1" },
              { "absTchehRetro1Med", "1" },
              { "absTchehRetro2", "1" },
              { "absTchehRetro2Fin", "1" },
              { "absTchehRetro2Ini", "1" },
              { "absTchehRetro2Med", "1" },
              { "absWawDotBelow", "1" },
              { "absWawDotBelowFin", "1" },
              { "ampersand", "1" },
              { "asciicircum", "1" },
              { "asciitilde", "1" },
              { "asterisk", "1" },
              { "at", "1" },
              { "b", "1" },
              { "backslash", "1" },
              { "bar", "1" },
              { "braceleft", "1" },
              { "braceright", "1" },
              { "bracketleft", "1" },
              { "bracketright", "1" },
              { "c", "1" },
              { "colon", "1" },
              { "comma", "1" },
              { "d", "1" },
              { "dollar", "1" },
              { "e", "1" },
              { "eight", "1" },
              { "eightMedium", "3" },
              { "eightSmall", "3" },
              { "equal", "1" },
              { "exclam", "1" },
              { "f", "1" },
              { "five", "1" },
              { "fiveMedium", "3" },
              { "fiveSmall", "3" },
              { "four", "1" },
              { "fourMedium", "3" },
              { "fourSmall", "3" },
              { "g", "1" },
              { "grave", "1" },
              { "greater", "1" },
              { "h", "1" },
              { "hyphen", "1" },
              { "i", "1" },
              { "j", "1" },
              { "k", "1" },
              { "l", "1" },
              { "less", "1" },
              { "m", "1" },
              { "n", "1" },
              { "nine", "1" },
              { "nineMedium", "3" },
              { "nineSmall", "3" },
              { "nonmarkingreturn", "1" },
              { "numbersign", "1" },
              { "o", "1" },
              { "one", "1" },
              { "oneMedium", "3" },
              { "oneSmall", "3" },
              { "p", "1" },
              { "parenleft", "1" },
              { "parenright", "1" },
              { "percent", "1" },
              { "period", "1" },
              { "plus", "1" },
              { "q", "1" },
              { "question", "1" },
              { "quotedbl", "1" },
              { "quotesingle", "1" },
              { "r", "1" },
              { "s", "1" },
              { "semicolon", "1" },
              { "seven", "1" },
              { "sevenMedium", "3" },
              { "sevenSmall", "3" },
              { "six", "1" },
              { "sixMedium", "3" },
              { "sixSmall", "3" },
              { "slash", "1" },
              { "space", "1" },
              { "t", "1" },
              { "three", "1" },
              { "threeMedium", "3" },
              { "threeSmall", "3" },
              { "two", "1" },
              { "twoMedium", "3" },
              { "twoSmall", "3" },
              { "u", "1" },
              { "underscore", "1" },
              { "uni0600", "1" },
              { "uni0600.2", "1" },
              { "uni0600.3", "1" },
              { "uni0600.aat1", "1" },
              { "uni0600.aat2", "1" },
              { "uni0600.aat3", "1" },
              { "uni0600.sp1", "1" },
              { "uni0600.sp2", "1" },
              { "uni0600.sp3", "1" },
              { "uni0601", "1" },
              { "uni0601.2", "1" },
              { "uni0601.3", "1" },
              { "uni0601.4", "1" },
              { "uni0601.aat1", "1" },
              { "uni0601.aat2", "1" },
              { "uni0601.aat3", "1" },
              { "uni0601.aat4", "1" },
              { "uni0601.sp1", "1" },
              { "uni0601.sp2", "1" },
              { "uni0601.sp3", "1" },
              { "uni0601.sp4", "1" },
              { "uni0602", "1" },
              { "uni0602.2", "1" },
              { "uni0602.aat1", "1" },
              { "uni0602.aat2", "1" },
              { "uni0602.sp1", "1" },
              { "uni0602.sp2", "1" },
              { "uni0603", "1" },
              { "uni0603.2", "1" },
              { "uni0603.3", "1" },
              { "uni0603.aat1", "1" },
              { "uni0603.aat2", "1" },
              { "uni0603.aat3", "1" },
              { "uni0603.sp1", "1" },
              { "uni0603.sp2", "1" },
              { "uni0603.sp3", "1" },
              { "uni060B", "1" },
              { "uni060C", "1" },
              { "uni060C.downward", "1" },
              { "uni060D", "1" },
              { "uni060E", "1" },
              { "uni060F", "1" },
              { "uni0610", "3" },
              { "uni0611", "3" },
              { "uni0612", "3" },
              { "uni0613", "3" },
              { "uni0614", "3" },
              { "uni0615", "3" },
              { "uni061B", "1" },
              { "uni061B.downward", "1" },
              { "uni061E", "1" },
              { "uni061F", "1" },
              { "uni0621", "1" },
              { "uni0622", "1" },
              { "uni0622.fina", "1" },
              { "uni0622.fina.postLamIni", "1" },
              { "uni0622.fina.postLamMed", "1" },
              { "uni0623", "1" },
              { "uni0623.fina", "1" },
              { "uni0623.fina.postLamIni", "1" },
              { "uni0623.fina.postLamMed", "1" },
              { "uni0624", "1" },
              { "uni0624.fina", "1" },
              { "uni0625", "1" },
              { "uni0625.fina", "1" },
              { "uni0625.fina.postLamIni", "1" },
              { "uni0625.fina.postLamMed", "1" },
              { "uni0626", "1" },
              { "uni0626.fina", "1" },
              { "uni0626.init", "1" },
              { "uni0626.medi", "1" },
              { "uni0627", "1" },
              { "uni0627.fina", "1" },
              { "uni0627.fina.postLamIni", "1" },
              { "uni0627.fina.postLamMed", "1" },
              { "uni0628", "1" },
              { "uni0628.fina", "1" },
              { "uni0628.init", "1" },
              { "uni0628.medi", "1" },
              { "uni0629", "1" },
              { "uni0629.fina", "1" },
              { "uni062A", "1" },
              { "uni062A.fina", "1" },
              { "uni062A.init", "1" },
              { "uni062A.medi", "1" },
              { "uni062B", "1" },
              { "uni062B.fina", "1" },
              { "uni062B.init", "1" },
              { "uni062B.medi", "1" },
              { "uni062C", "1" },
              { "uni062C.fina", "1" },
              { "uni062C.init", "1" },
              { "uni062C.medi", "1" },
              { "uni062D", "1" },
              { "uni062D.fina", "1" },
              { "uni062D.init", "1" },
              { "uni062D.medi", "1" },
              { "uni062E", "1" },
              { "uni062E.fina", "1" },
              { "uni062E.init", "1" },
              { "uni062E.medi", "1" },
              { "uni062F", "1" },
              { "uni062F.fina", "1" },
              { "uni0630", "1" },
              { "uni0630.fina", "1" },
              { "uni0631", "1" },
              { "uni0631.fina", "1" },
              { "uni0632", "1" },
              { "uni0632.fina", "1" },
              { "uni0633", "1" },
              { "uni0633.fina", "1" },
              { "uni0633.init", "1" },
              { "uni0633.medi", "1" },
              { "uni0634", "1" },
              { "uni0634.fina", "1" },
              { "uni0634.init", "1" },
              { "uni0634.medi", "1" },
              { "uni0635", "1" },
              { "uni0635.fina", "1" },
              { "uni0635.init", "1" },
              { "uni0635.medi", "1" },
              { "uni0636", "1" },
              { "uni0636.fina", "1" },
              { "uni0636.init", "1" },
              { "uni0636.medi", "1" },
              { "uni0637", "1" },
              { "uni0637.fina", "1" },
              { "uni0637.init", "1" },
              { "uni0637.medi", "1" },
              { "uni0638", "1" },
              { "uni0638.fina", "1" },
              { "uni0638.init", "1" },
              { "uni0638.medi", "1" },
              { "uni0639", "1" },
              { "uni0639.fina", "1" },
              { "uni0639.init", "1" },
              { "uni0639.medi", "1" },
              { "uni063A", "1" },
              { "uni063A.fina", "1" },
              { "uni063A.init", "1" },
              { "uni063A.medi", "1" },
              { "uni0640", "1" },
              { "uni0641", "1" },
              { "uni0641.fina", "1" },
              { "uni0641.init", "1" },
              { "uni0641.medi", "1" },
              { "uni0642", "1" },
              { "uni0642.fina", "1" },
              { "uni0642.init", "1" },
              { "uni0642.medi", "1" },
              { "uni0643", "1" },
              { "uni0643.fina", "1" },
              { "uni0643.init", "1" },
              { "uni0643.medi", "1" },
              { "uni0644", "1" },
              { "uni0644.fina", "1" },
              { "uni0644.init", "1" },
              { "uni0644.init.preAlef", "1" },
              { "uni0644.medi", "1" },
              { "uni0644.medi.preAlef", "1" },
              { "uni06440627", "2" },
              { "uni06440627.fina", "2" },
              { "uni0645", "1" },
              { "uni0645.fina", "1" },
              { "uni0645.fina.sindhi", "1" },
              { "uni0645.init", "1" },
              { "uni0645.medi", "1" },
              { "uni0645.sindhi", "1" },
              { "uni0646", "1" },
              { "uni0646.fina", "1" },
              { "uni0646.init", "1" },
              { "uni0646.medi", "1" },
              { "uni0647", "1" },
              { "uni0647.fina", "1" },
              { "uni0647.fina.hooked", "1" },
              { "uni0647.fina.knottedFlat", "1" },
              { "uni0647.fina.knottedHigh", "1" },
              { "uni0647.init", "1" },
              { "uni0647.init.hooked", "1" },
              { "uni0647.knotted", "1" },
              { "uni0647.medi", "1" },
              { "uni0647.medi.hooked", "1" },
              { "uni0647.medi.knottedHigh", "1" },
              { "uni0648", "1" },
              { "uni0648.fina", "1" },
              { "uni0649", "1" },
              { "uni0649.fina", "1" },
              { "uni0649.init", "1" },
              { "uni0649.medi", "1" },
              { "uni064A", "1" },
              { "uni064A.fina", "1" },
              { "uni064A.fina.noDots", "1" },
              { "uni064A.init", "1" },
              { "uni064A.init.noDots", "1" },
              { "uni064A.medi", "1" },
              { "uni064A.medi.noDots", "1" },
              { "uni064A.noDots", "1" },
              { "uni064B", "3" },
              { "uni064C", "3" },
              { "uni064C.sixNine", "3" },
              { "uni064D", "3" },
              { "uni064E", "3" },
              { "uni064F", "3" },
              { "uni0650", "3" },
              { "uni0651", "3" },
              { "uni0651064B", "3" },
              { "uni0651064C", "3" },
              { "uni0651064D", "3" },
              { "uni0651064E", "3" },
              { "uni0651064F", "3" },
              { "uni06510650", "3" },
              { "uni0652", "3" },
              { "uni0652.downOpen", "3" },
              { "uni0652.leftOpen", "3" },
              { "uni0653", "3" },
              { "uni0654", "3" },
              { "uni0654064E", "3" },
              { "uni0654064F", "3" },
              { "uni0655", "3" },
              { "uni0656", "3" },
              { "uni0657", "3" },
              { "uni0658", "3" },
              { "uni0659", "3" },
              { "uni065A", "3" },
              { "uni065B", "3" },
              { "uni065C", "3" },
              { "uni065D", "3" },
              { "uni065E", "3" },
              { "uni0660", "1" },
              { "uni0660.Medium", "3" },
              { "uni0660.Small", "3" },
              { "uni0661", "1" },
              { "uni0661.Medium", "3" },
              { "uni0661.Small", "3" },
              { "uni0662", "1" },
              { "uni0662.Medium", "3" },
              { "uni0662.Small", "3" },
              { "uni0663", "1" },
              { "uni0663.Medium", "3" },
              { "uni0663.Small", "3" },
              { "uni0664", "1" },
              { "uni0664.Medium", "3" },
              { "uni0664.Small", "3" },
              { "uni0665", "1" },
              { "uni0665.Medium", "3" },
              { "uni0665.Small", "3" },
              { "uni0666", "1" },
              { "uni0666.Medium", "3" },
              { "uni0666.Small", "3" },
              { "uni0667", "1" },
              { "uni0667.Medium", "3" },
              { "uni0667.Small", "3" },
              { "uni0668", "1" },
              { "uni0668.Medium", "3" },
              { "uni0668.Small", "3" },
              { "uni0669", "1" },
              { "uni0669.Medium", "3" },
              { "uni0669.Small", "3" },
              { "uni066A", "1" },
              { "uni066B", "1" },
              { "uni066C", "1" },
              { "uni066D", "1" },
              { "uni066E", "1" },
              { "uni066E.fina", "1" },
              { "uni066E.init", "1" },
              { "uni066E.medi", "1" },
              { "uni066F", "1" },
              { "uni066F.fina", "1" },
              { "uni066F.init", "1" },
              { "uni066F.medi", "1" },
              { "uni0670", "3" },
              { "uni0670.large", "3" },
              { "uni0671", "1" },
              { "uni0671.fina", "1" },
              { "uni0671.fina.postLamIni", "1" },
              { "uni0671.fina.postLamMed", "1" },
              { "uni0672", "1" },
              { "uni0672.fina", "1" },
              { "uni0672.fina.postLamIni", "1" },
              { "uni0672.fina.postLamMed", "1" },
              { "uni0673", "1" },
              { "uni0673.fina", "1" },
              { "uni0673.fina.postLamIni", "1" },
              { "uni0673.fina.postLamMed", "1" },
              { "uni0674", "3" },
              { "uni0675", "1" },
              { "uni0675.fina", "1" },
              { "uni0675.fina.postLamIni", "1" },
              { "uni0675.fina.postLamMed", "1" },
              { "uni0676", "1" },
              { "uni0676.fina", "1" },
              { "uni0677", "1" },
              { "uni0677.fina", "1" },
              { "uni0678", "1" },
              { "uni0678.fina", "1" },
              { "uni0678.init", "1" },
              { "uni0678.medi", "1" },
              { "uni0679", "1" },
              { "uni0679.fina", "1" },
              { "uni0679.init", "1" },
              { "uni0679.medi", "1" },
              { "uni067A", "1" },
              { "uni067A.fina", "1" },
              { "uni067A.init", "1" },
              { "uni067A.medi", "1" },
              { "uni067B", "1" },
              { "uni067B.fina", "1" },
              { "uni067B.init", "1" },
              { "uni067B.medi", "1" },
              { "uni067C", "1" },
              { "uni067C.fina", "1" },
              { "uni067C.init", "1" },
              { "uni067C.medi", "1" },
              { "uni067D", "1" },
              { "uni067D.fina", "1" },
              { "uni067D.init", "1" },
              { "uni067D.medi", "1" },
              { "uni067E", "1" },
              { "uni067E.fina", "1" },
              { "uni067E.init", "1" },
              { "uni067E.medi", "1" },
              { "uni067F", "1" },
              { "uni067F.fina", "1" },
              { "uni067F.init", "1" },
              { "uni067F.medi", "1" },
              { "uni0680", "1" },
              { "uni0680.fina", "1" },
              { "uni0680.init", "1" },
              { "uni0680.medi", "1" },
              { "uni0681", "1" },
              { "uni0681.fina", "1" },
              { "uni0681.init", "1" },
              { "uni0681.medi", "1" },
              { "uni0682", "1" },
              { "uni0682.fina", "1" },
              { "uni0682.init", "1" },
              { "uni0682.medi", "1" },
              { "uni0683", "1" },
              { "uni0683.fina", "1" },
              { "uni0683.init", "1" },
              { "uni0683.medi", "1" },
              { "uni0684", "1" },
              { "uni0684.fina", "1" },
              { "uni0684.init", "1" },
              { "uni0684.medi", "1" },
              { "uni0685", "1" },
              { "uni0685.fina", "1" },
              { "uni0685.init", "1" },
              { "uni0685.medi", "1" },
              { "uni0686", "1" },
              { "uni0686.fina", "1" },
              { "uni0686.init", "1" },
              { "uni0686.medi", "1" },
              { "uni0687", "1" },
              { "uni0687.fina", "1" },
              { "uni0687.init", "1" },
              { "uni0687.medi", "1" },
              { "uni0688", "1" },
              { "uni0688.fina", "1" },
              { "uni0689", "1" },
              { "uni0689.fina", "1" },
              { "uni068A", "1" },
              { "uni068A.fina", "1" },
              { "uni068B", "1" },
              { "uni068B.fina", "1" },
              { "uni068C", "1" },
              { "uni068C.fina", "1" },
              { "uni068D", "1" },
              { "uni068D.fina", "1" },
              { "uni068E", "1" },
              { "uni068E.fina", "1" },
              { "uni068F", "1" },
              { "uni068F.fina", "1" },
              { "uni0690", "1" },
              { "uni0690.fina", "1" },
              { "uni0691", "1" },
              { "uni0691.fina", "1" },
              { "uni0692", "1" },
              { "uni0692.fina", "1" },
              { "uni0693", "1" },
              { "uni0693.fina", "1" },
              { "uni0694", "1" },
              { "uni0694.fina", "1" },
              { "uni0695", "1" },
              { "uni0695.fina", "1" },
              { "uni0696", "1" },
              { "uni0696.fina", "1" },
              { "uni0697", "1" },
              { "uni0697.fina", "1" },
              { "uni0698", "1" },
              { "uni0698.dotHat", "1" },
              { "uni0698.fina", "1" },
              { "uni0698.fina.dotHat", "1" },
              { "uni0699", "1" },
              { "uni0699.fina", "1" },
              { "uni069A", "1" },
              { "uni069A.fina", "1" },
              { "uni069A.init", "1" },
              { "uni069A.medi", "1" },
              { "uni069B", "1" },
              { "uni069B.fina", "1" },
              { "uni069B.init", "1" },
              { "uni069B.medi", "1" },
              { "uni069C", "1" },
              { "uni069C.fina", "1" },
              { "uni069C.init", "1" },
              { "uni069C.medi", "1" },
              { "uni069D", "1" },
              { "uni069D.fina", "1" },
              { "uni069D.init", "1" },
              { "uni069D.medi", "1" },
              { "uni069E", "1" },
              { "uni069E.fina", "1" },
              { "uni069E.init", "1" },
              { "uni069E.medi", "1" },
              { "uni069F", "1" },
              { "uni069F.fina", "1" },
              { "uni069F.init", "1" },
              { "uni069F.medi", "1" },
              { "uni06A0", "1" },
              { "uni06A0.fina", "1" },
              { "uni06A0.init", "1" },
              { "uni06A0.medi", "1" },
              { "uni06A1", "1" },
              { "uni06A1.fina", "1" },
              { "uni06A1.init", "1" },
              { "uni06A1.medi", "1" },
              { "uni06A2", "1" },
              { "uni06A2.fina", "1" },
              { "uni06A2.init", "1" },
              { "uni06A2.medi", "1" },
              { "uni06A3", "1" },
              { "uni06A3.fina", "1" },
              { "uni06A3.init", "1" },
              { "uni06A3.medi", "1" },
              { "uni06A4", "1" },
              { "uni06A4.fina", "1" },
              { "uni06A4.init", "1" },
              { "uni06A4.medi", "1" },
              { "uni06A5", "1" },
              { "uni06A5.fina", "1" },
              { "uni06A5.init", "1" },
              { "uni06A5.medi", "1" },
              { "uni06A6", "1" },
              { "uni06A6.fina", "1" },
              { "uni06A6.init", "1" },
              { "uni06A6.medi", "1" },
              { "uni06A7", "1" },
              { "uni06A7.fina", "1" },
              { "uni06A7.init", "1" },
              { "uni06A7.medi", "1" },
              { "uni06A8", "1" },
              { "uni06A8.fina", "1" },
              { "uni06A8.init", "1" },
              { "uni06A8.medi", "1" },
              { "uni06A9", "1" },
              { "uni06A9.fina", "1" },
              { "uni06A9.init", "1" },
              { "uni06A9.medi", "1" },
              { "uni06AA", "1" },
              { "uni06AA.fina", "1" },
              { "uni06AA.init", "1" },
              { "uni06AA.medi", "1" },
              { "uni06AB", "1" },
              { "uni06AB.fina", "1" },
              { "uni06AB.init", "1" },
              { "uni06AB.medi", "1" },
              { "uni06AC", "1" },
              { "uni06AC.fina", "1" },
              { "uni06AC.init", "1" },
              { "uni06AC.medi", "1" },
              { "uni06AD", "1" },
              { "uni06AD.fina", "1" },
              { "uni06AD.init", "1" },
              { "uni06AD.medi", "1" },
              { "uni06AE", "1" },
              { "uni06AE.fina", "1" },
              { "uni06AE.init", "1" },
              { "uni06AE.medi", "1" },
              { "uni06AF", "1" },
              { "uni06AF.fina", "1" },
              { "uni06AF.init", "1" },
              { "uni06AF.medi", "1" },
              { "uni06B0", "1" },
              { "uni06B0.fina", "1" },
              { "uni06B0.init", "1" },
              { "uni06B0.medi", "1" },
              { "uni06B1", "1" },
              { "uni06B1.fina", "1" },
              { "uni06B1.init", "1" },
              { "uni06B1.medi", "1" },
              { "uni06B2", "1" },
              { "uni06B2.fina", "1" },
              { "uni06B2.init", "1" },
              { "uni06B2.medi", "1" },
              { "uni06B3", "1" },
              { "uni06B3.fina", "1" },
              { "uni06B3.init", "1" },
              { "uni06B3.medi", "1" },
              { "uni06B4", "1" },
              { "uni06B4.fina", "1" },
              { "uni06B4.init", "1" },
              { "uni06B4.medi", "1" },
              { "uni06B5", "1" },
              { "uni06B5.fina", "1" },
              { "uni06B5.init", "1" },
              { "uni06B5.init.preAlef", "1" },
              { "uni06B5.medi", "1" },
              { "uni06B5.medi.preAlef", "1" },
              { "uni06B50627", "2" },
              { "uni06B50627.fina", "2" },
              { "uni06B6", "1" },
              { "uni06B6.fina", "1" },
              { "uni06B6.init", "1" },
              { "uni06B6.init.preAlef", "1" },
              { "uni06B6.medi", "1" },
              { "uni06B6.medi.preAlef", "1" },
              { "uni06B60627", "2" },
              { "uni06B60627.fina", "2" },
              { "uni06B7", "1" },
              { "uni06B7.fina", "1" },
              { "uni06B7.init", "1" },
              { "uni06B7.init.preAlef", "1" },
              { "uni06B7.medi", "1" },
              { "uni06B7.medi.preAlef", "1" },
              { "uni06B70627", "2" },
              { "uni06B70627.fina", "2" },
              { "uni06B8", "1" },
              { "uni06B8.fina", "1" },
              { "uni06B8.init", "1" },
              { "uni06B8.init.preAlef", "1" },
              { "uni06B8.medi", "1" },
              { "uni06B8.medi.preAlef", "1" },
              { "uni06B80627", "2" },
              { "uni06B80627.fina", "2" },
              { "uni06B9", "1" },
              { "uni06B9.fina", "1" },
              { "uni06B9.init", "1" },
              { "uni06B9.medi", "1" },
              { "uni06BA", "1" },
              { "uni06BA.fina", "1" },
              { "uni06BA.init", "1" },
              { "uni06BA.medi", "1" },
              { "uni06BB", "1" },
              { "uni06BB.fina", "1" },
              { "uni06BB.init", "1" },
              { "uni06BB.medi", "1" },
              { "uni06BC", "1" },
              { "uni06BC.fina", "1" },
              { "uni06BC.init", "1" },
              { "uni06BC.medi", "1" },
              { "uni06BD", "1" },
              { "uni06BD.fina", "1" },
              { "uni06BD.init", "1" },
              { "uni06BD.medi", "1" },
              { "uni06BE", "1" },
              { "uni06BE.fina", "1" },
              { "uni06BE.init", "1" },
              { "uni06BE.medi", "1" },
              { "uni06BF", "1" },
              { "uni06BF.fina", "1" },
              { "uni06BF.init", "1" },
              { "uni06BF.medi", "1" },
              { "uni06C0", "1" },
              { "uni06C0.fina", "1" },
              { "uni06C0.init", "1" },
              { "uni06C0.medi", "1" },
              { "uni06C1", "1" },
              { "uni06C1.fina", "1" },
              { "uni06C1.init", "1" },
              { "uni06C1.medi", "1" },
              { "uni06C2", "1" },
              { "uni06C2.fina", "1" },
              { "uni06C2.init", "1" },
              { "uni06C2.medi", "1" },
              { "uni06C3", "1" },
              { "uni06C3.fina", "1" },
              { "uni06C4", "1" },
              { "uni06C4.fina", "1" },
              { "uni06C5", "1" },
              { "uni06C5.fina", "1" },
              { "uni06C6", "1" },
              { "uni06C6.fina", "1" },
              { "uni06C7", "1" },
              { "uni06C7.fina", "1" },
              { "uni06C8", "1" },
              { "uni06C8.fina", "1" },
              { "uni06C9", "1" },
              { "uni06C9.fina", "1" },
              { "uni06CA", "1" },
              { "uni06CA.fina", "1" },
              { "uni06CB", "1" },
              { "uni06CB.fina", "1" },
              { "uni06CC", "1" },
              { "uni06CC.fina", "1" },
              { "uni06CC.init", "1" },
              { "uni06CC.medi", "1" },
              { "uni06CD", "1" },
              { "uni06CD.fina", "1" },
              { "uni06CE", "1" },
              { "uni06CE.fina", "1" },
              { "uni06CE.init", "1" },
              { "uni06CE.medi", "1" },
              { "uni06CF", "1" },
              { "uni06CF.fina", "1" },
              { "uni06D0", "1" },
              { "uni06D0.fina", "1" },
              { "uni06D0.init", "1" },
              { "uni06D0.medi", "1" },
              { "uni06D1", "1" },
              { "uni06D1.fina", "1" },
              { "uni06D1.init", "1" },
              { "uni06D1.medi", "1" },
              { "uni06D2", "1" },
              { "uni06D2.fina", "1" },
              { "uni06D3", "1" },
              { "uni06D3.fina", "1" },
              { "uni06D4", "1" },
              { "uni06D5", "1" },
              { "uni06D6", "3" },
              { "uni06D7", "3" },
              { "uni06D8", "3" },
              { "uni06D9", "3" },
              { "uni06DA", "3" },
              { "uni06DB", "3" },
              { "uni06DC", "3" },
              { "uni06DD", "1" },
              { "uni06DD.2", "1" },
              { "uni06DD.3", "1" },
              { "uni06DD.aat1", "1" },
              { "uni06DD.aat2", "1" },
              { "uni06DD.aat3", "1" },
              { "uni06DD.alt", "1" },
              { "uni06DD.alt.2", "1" },
              { "uni06DD.alt.3", "1" },
              { "uni06DD.alt.aat1", "1" },
              { "uni06DD.alt.aat2", "1" },
              { "uni06DD.alt.aat3", "1" },
              { "uni06DD.altB", "1" },
              { "uni06DD.altB.2", "1" },
              { "uni06DD.altB.3", "1" },
              { "uni06DD.altB.aat1", "1" },
              { "uni06DD.altB.aat2", "1" },
              { "uni06DD.altB.aat3", "1" },
              { "uni06DD.sp1", "1" },
              { "uni06DD.sp2", "1" },
              { "uni06DD.sp3", "1" },
              { "uni06DE", "1" },
              { "uni06DF", "3" },
              { "uni06E0", "3" },
              { "uni06E1", "3" },
              { "uni06E2", "3" },
              { "uni06E3", "3" },
              { "uni06E4", "3" },
              { "uni06E5", "3" },
              { "uni06E6", "3" },
              { "uni06E7", "3" },
              { "uni06E8", "3" },
              { "uni06E9", "1" },
              { "uni06EA", "3" },
              { "uni06EB", "3" },
              { "uni06EC", "3" },
              { "uni06ED", "3" },
              { "uni06EE", "1" },
              { "uni06EE.fina", "1" },
              { "uni06EF", "1" },
              { "uni06EF.fina", "1" },
              { "uni06F0", "1" },
              { "uni06F0.Medium", "3" },
              { "uni06F0.Small", "3" },
              { "uni06F1", "1" },
              { "uni06F1.Medium", "3" },
              { "uni06F1.Small", "3" },
              { "uni06F2", "1" },
              { "uni06F2.Medium", "3" },
              { "uni06F2.Small", "3" },
              { "uni06F3", "1" },
              { "uni06F3.Medium", "3" },
              { "uni06F3.Small", "3" },
              { "uni06F4", "1" },
              { "uni06F4.Medium", "3" },
              { "uni06F4.Medium.urdu", "3" },
              { "uni06F4.Small", "3" },
              { "uni06F4.Small.urdu", "3" },
              { "uni06F4.urdu", "1" },
              { "uni06F5", "1" },
              { "uni06F5.Medium", "3" },
              { "uni06F5.Small", "3" },
              { "uni06F6", "1" },
              { "uni06F6.Medium", "3" },
              { "uni06F6.Medium.urdu", "3" },
              { "uni06F6.Small", "3" },
              { "uni06F6.Small.urdu", "3" },
              { "uni06F6.urdu", "1" },
              { "uni06F7", "1" },
              { "uni06F7.Medium", "3" },
              { "uni06F7.Medium.urdu", "3" },
              { "uni06F7.Small", "3" },
              { "uni06F7.Small.urdu", "3" },
              { "uni06F7.urdu", "1" },
              { "uni06F8", "1" },
              { "uni06F8.Medium", "3" },
              { "uni06F8.Small", "3" },
              { "uni06F9", "1" },
              { "uni06F9.Medium", "3" },
              { "uni06F9.Small", "3" },
              { "uni06FA", "1" },
              { "uni06FA.fina", "1" },
              { "uni06FA.init", "1" },
              { "uni06FA.medi", "1" },
              { "uni06FB", "1" },
              { "uni06FB.fina", "1" },
              { "uni06FB.init", "1" },
              { "uni06FB.medi", "1" },
              { "uni06FC", "1" },
              { "uni06FC.fina", "1" },
              { "uni06FC.init", "1" },
              { "uni06FC.medi", "1" },
              { "uni06FD", "1" },
              { "uni06FE", "1" },
              { "uni06FF", "1" },
              { "uni06FF.fina", "1" },
              { "uni06FF.init", "1" },
              { "uni06FF.medi", "1" },
              { "uni0750", "1" },
              { "uni0750.fina", "1" },
              { "uni0750.init", "1" },
              { "uni0750.medi", "1" },
              { "uni0751", "1" },
              { "uni0751.fina", "1" },
              { "uni0751.init", "1" },
              { "uni0751.medi", "1" },
              { "uni0752", "1" },
              { "uni0752.fina", "1" },
              { "uni0752.init", "1" },
              { "uni0752.medi", "1" },
              { "uni0753", "1" },
              { "uni0753.fina", "1" },
              { "uni0753.init", "1" },
              { "uni0753.medi", "1" },
              { "uni0754", "1" },
              { "uni0754.fina", "1" },
              { "uni0754.init", "1" },
              { "uni0754.medi", "1" },
              { "uni0755", "1" },
              { "uni0755.fina", "1" },
              { "uni0755.init", "1" },
              { "uni0755.medi", "1" },
              { "uni0756", "1" },
              { "uni0756.fina", "1" },
              { "uni0756.init", "1" },
              { "uni0756.medi", "1" },
              { "uni0757", "1" },
              { "uni0757.fina", "1" },
              { "uni0757.init", "1" },
              { "uni0757.medi", "1" },
              { "uni0758", "1" },
              { "uni0758.fina", "1" },
              { "uni0758.init", "1" },
              { "uni0758.medi", "1" },
              { "uni0759", "1" },
              { "uni0759.fina", "1" },
              { "uni075A", "1" },
              { "uni075A.fina", "1" },
              { "uni075B", "1" },
              { "uni075B.fina", "1" },
              { "uni075C", "1" },
              { "uni075C.fina", "1" },
              { "uni075C.init", "1" },
              { "uni075C.medi", "1" },
              { "uni075D", "1" },
              { "uni075D.fina", "1" },
              { "uni075D.init", "1" },
              { "uni075D.medi", "1" },
              { "uni075E", "1" },
              { "uni075E.fina", "1" },
              { "uni075E.init", "1" },
              { "uni075E.medi", "1" },
              { "uni075F", "1" },
              { "uni075F.fina", "1" },
              { "uni075F.init", "1" },
              { "uni075F.medi", "1" },
              { "uni0760", "1" },
              { "uni0760.fina", "1" },
              { "uni0760.init", "1" },
              { "uni0760.medi", "1" },
              { "uni0761", "1" },
              { "uni0761.fina", "1" },
              { "uni0761.init", "1" },
              { "uni0761.medi", "1" },
              { "uni0762", "1" },
              { "uni0762.fina", "1" },
              { "uni0762.init", "1" },
              { "uni0762.medi", "1" },
              { "uni0763", "1" },
              { "uni0763.fina", "1" },
              { "uni0763.init", "1" },
              { "uni0763.medi", "1" },
              { "uni0764", "1" },
              { "uni0764.fina", "1" },
              { "uni0764.init", "1" },
              { "uni0764.medi", "1" },
              { "uni0765", "1" },
              { "uni0765.fina", "1" },
              { "uni0765.init", "1" },
              { "uni0765.medi", "1" },
              { "uni0766", "1" },
              { "uni0766.fina", "1" },
              { "uni0766.init", "1" },
              { "uni0766.medi", "1" },
              { "uni0767", "1" },
              { "uni0767.fina", "1" },
              { "uni0767.init", "1" },
              { "uni0767.medi", "1" },
              { "uni0768", "1" },
              { "uni0768.fina", "1" },
              { "uni0768.init", "1" },
              { "uni0768.medi", "1" },
              { "uni0769", "1" },
              { "uni0769.fina", "1" },
              { "uni0769.init", "1" },
              { "uni0769.medi", "1" },
              { "uni076A", "1" },
              { "uni076A.fina", "1" },
              { "uni076A.init", "1" },
              { "uni076A.init.preAlef", "1" },
              { "uni076A.medi", "1" },
              { "uni076A.medi.preAlef", "1" },
              { "uni076A0627", "2" },
              { "uni076A0627.fina", "2" },
              { "uni076B", "1" },
              { "uni076B.fina", "1" },
              { "uni076C", "1" },
              { "uni076C.fina", "1" },
              { "uni076D", "1" },
              { "uni076D.fina", "1" },
              { "uni076D.init", "1" },
              { "uni076D.medi", "1" },
              { "uni2000", "1" },
              { "uni2001", "1" },
              { "uni2002", "1" },
              { "uni2003", "1" },
              { "uni2004", "1" },
              { "uni2005", "1" },
              { "uni2006", "1" },
              { "uni2007", "1" },
              { "uni2008", "1" },
              { "uni2009", "1" },
              { "uni200A", "1" },
              { "uni200B", "1" },
              { "uni200C", "1" },
              { "uni200D", "1" },
              { "uni200E", "1" },
              { "uni200F", "1" },
              { "uni202A", "1" },
              { "uni202B", "1" },
              { "uni202C", "1" },
              { "uni202D", "1" },
              { "uni202E", "1" },
              { "uni2060", "1" },
              { "uni206C", "1" },
              { "uni206D", "1" },
              { "uni25CC", "1" },
              { "uniFD3E", "1" },
              { "uniFD3F", "1" },
              { "uniFDF2", "1" },
              { "uniFDFC", "1" },
              { "uniFEFF", "1" },
              { "v", "1" },
              { "w", "1" },
              { "x", "1" },
              { "y", "1" },
              { "z", "1" },
              { "zero", "1" },
              { "zeroMedium", "3" },
              { "zeroSmall", "3" },
          },
        },
    };

    private static Object[][] ltAttachmentPoint = {
        { GlyphDefinitionTable.GDEF_LOOKUP_TYPE_ATTACHMENT_POINT },
        // arab-001.ttx - not present
        // arab-002.ttx - maybe add tests
        // arab-003.ttx - maybe add tests
        // arab-004.ttx - maybe add tests
    };

    private static Object[][] ltLigatureCaret = {
        { GlyphDefinitionTable.GDEF_LOOKUP_TYPE_LIGATURE_CARET },
        // arab-001.ttx - not present
        // arab-002.ttx - maybe add tests
        // arab-003.ttx - maybe add tests
        // arab-004.ttx - maybe add tests
    };

    private static Object[][] ltMarkAttachment = {
        { GlyphDefinitionTable.GDEF_LOOKUP_TYPE_MARK_ATTACHMENT },
        // arab-001.ttx - not present
        // arab-002.ttx - maybe add tests
        // arab-003.ttx - maybe add tests
        // arab-004.ttx - maybe add tests
    };

    @Test
    public void testGDEFGlyphClass() throws Exception {
        performLookups(ltGlyphClass);
    }

    @Test
    public void testGDEFAttachmentPoint() throws Exception {
        performLookups(ltAttachmentPoint);
    }

    @Test
    public void testGDEFLigatureCaret() throws Exception {
        performLookups(ltLigatureCaret);
    }

    @Test
    public void testGDEFMarkAttachment() throws Exception {
        performLookups(ltMarkAttachment);
    }

    /**
     * Perform lookups on all test data in test specification TS.
     * @param ts test specification
     */
    private void performLookups(Object[][] ts) {
        assert ts.length > 0;
        Object[] tp = ts[0];
        for (int i = 1; i < ts.length; i++) {
            performLookups(tp, ts[i]);
        }
    }

    /**
     * Perform lookups on all test data TD using test parameters TP.
     * @param tp test parameters
     * @param td test data
     */
    private void performLookups(Object[] tp, Object[] td) {
        assert tp.length > 0;
        if (td.length > 1) {
            String fid = (String) td[0];
            String lid = (String) td[1];
            TTXFile tf = findTTX(fid);
            assertTrue(tf != null);
            GlyphDefinitionTable gdef = tf.getGDEF();
            assertTrue(gdef != null);
            String[][] tia = (String[][]) td[2];
            switch ((int) ((Integer) tp[0])) {
            case GlyphDefinitionTable.GDEF_LOOKUP_TYPE_GLYPH_CLASS:
                performGlyphClassLookups(tf, lid, tia);
                break;
            case GlyphDefinitionTable.GDEF_LOOKUP_TYPE_ATTACHMENT_POINT:
                performAttachmentPointLookups(tf, lid, tia);
                break;
            case GlyphDefinitionTable.GDEF_LOOKUP_TYPE_LIGATURE_CARET:
                performLigatureCaretLookups(tf, lid, tia);
                break;
            case GlyphDefinitionTable.GDEF_LOOKUP_TYPE_MARK_ATTACHMENT:
                performMarkAttachmentLookups(tf, lid, tia);
                break;
            default:
                assertTrue("bad lookup type", false);
                break;
            }
        }
    }

    private void performGlyphClassLookups(TTXFile tf, String lid, String[][] tia) {
        GlyphDefinitionTable gdef = tf.getGDEF();
        assert gdef != null;
        for (String[] ti : tia) {
            assert ti != null;
            assert ti.length > 1;
            String gn = ti[0];
            assert gn != null;
            String cn = ti[1];
            assert cn != null;
            int g = tf.getGlyph(gn);
            assertTrue(g >= 0);
            int oc = Integer.parseInt(cn);
            int tc = gdef.getGlyphClass(g);
            assertEquals("bad glyph class for glyph \'" + gn + "\', gid(" + g + ")", oc, tc);
        }
    }

    private void performAttachmentPointLookups(TTXFile tf, String lid, String[][] tia) {
        // not yet supported by GDEF or test TTX files
    }

    private void performLigatureCaretLookups(TTXFile tf, String lid, String[][] tia) {
        // not yet supported by GDEF or test TTX files
    }

    private void performMarkAttachmentLookups(TTXFile tf, String lid, String[][] tia) {
        // not yet supported by GDEF or test TTX files
    }

    private String findTTXPath(String fid) {
        for (String[] fs : ttxFonts) {
            if ((fs != null) && (fs.length > 1)) {
                if (fs[0].equals(fid)) {
                    return ttxFilesRoot + File.separator + fs[1];
                }
            }
        }
        return null;
    }

    private TTXFile findTTX(String fid) {
        String pn = findTTXPath(fid);
        assertTrue(pn != null);
        try {
            TTXFile tf = TTXFile.getFromCache(pn);
            return tf;
        } catch (Exception e) {
            fail(e.getMessage());
            return null;
        }
    }

}
