/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import java.rmi.RemoteException;
import visad.DataDisplayLink;
import visad.DataRenderer;
import visad.DisplayImpl;
import visad.Flow1Control;
import visad.Flow2Control;
import visad.FlowControl;
import visad.MathType;
import visad.ShadowType;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADLineArray;
import visad.VisADTriangleArray;
import visad.bom.BarbManipulationRendererJ3D;
import visad.bom.BarbRenderer;
import visad.java3d.ShadowRealTupleTypeJ3D;

public class ShadowBarbRealTupleTypeJ3D
extends ShadowRealTupleTypeJ3D {
    private static final int NUM = 1024;

    public ShadowBarbRealTupleTypeJ3D(MathType t, DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        super(t, link, parent);
    }

    public VisADGeometryArray[] makeFlow(int which, float[][] flow_values, float flowScale, float[][] spatial_values, byte[][] color_values, boolean[][] range_select) throws VisADException {
        DataRenderer renderer = this.getLink().getRenderer();
        boolean direct = renderer.getIsDirectManipulation();
        if (direct && renderer instanceof BarbManipulationRendererJ3D) {
            return ShadowBarbRealTupleTypeJ3D.staticMakeFlow(this.getDisplay(), which, flow_values, flowScale, spatial_values, color_values, range_select, renderer, true);
        }
        return ShadowBarbRealTupleTypeJ3D.staticMakeFlow(this.getDisplay(), which, flow_values, flowScale, spatial_values, color_values, range_select, renderer, false);
    }

    public static VisADGeometryArray[] staticMakeFlow(DisplayImpl display, int which, float[][] flow_values, float flowScale, float[][] spatial_values, byte[][] color_values, boolean[][] range_select, DataRenderer renderer, boolean direct) throws VisADException {
        int numColors;
        if (flow_values[0] == null) {
            return null;
        }
        if (spatial_values[0] == null) {
            return null;
        }
        int len = spatial_values[0].length;
        int flen = flow_values[0].length;
        int rlen = 0;
        if (range_select[0] == null) {
            rlen = len;
        } else {
            for (int j = 0; j < range_select[0].length; ++j) {
                if (!range_select[0][j]) continue;
                ++rlen;
            }
        }
        if (rlen == 0) {
            return null;
        }
        boolean[] south = new boolean[len];
        float[][] earth_locs = renderer.spatialToEarth(spatial_values);
        if (earth_locs != null) {
            for (int i = 0; i < len; ++i) {
                south[i] = earth_locs[0][i] < 0.0f;
            }
        } else {
            FlowControl fcontrol = null;
            if (which == 0) {
                fcontrol = (FlowControl)display.getControl(Flow1Control.class);
            } else if (which == 1) {
                fcontrol = (FlowControl)display.getControl(Flow2Control.class);
            }
            if (fcontrol == null) {
                throw new VisADException("ShadowBarbRealTupleTypeJ3D: Unable to get FlowControl");
            }
            boolean isSouth = fcontrol.getBarbOrientation() == 1;
            for (int i = 0; i < len; ++i) {
                south[i] = isSouth;
            }
        }
        flow_values = ShadowBarbRealTupleTypeJ3D.adjustFlowToEarth(which, flow_values, spatial_values, 0.02f, renderer);
        float[] vx = new float[1024];
        float[] vy = new float[1024];
        float[] vz = new float[1024];
        float[] tx = new float[1024];
        float[] ty = new float[1024];
        float[] tz = new float[1024];
        byte[] vred = null;
        byte[] vgreen = null;
        byte[] vblue = null;
        byte[] valpha = null;
        byte[] tred = null;
        byte[] tgreen = null;
        byte[] tblue = null;
        byte[] talpha = null;
        int n = numColors = color_values != null ? color_values.length : 3;
        if (color_values != null) {
            vred = new byte[1024];
            vgreen = new byte[1024];
            vblue = new byte[1024];
            if (numColors == 4) {
                valpha = new byte[1024];
            }
            tred = new byte[1024];
            tgreen = new byte[1024];
            tblue = new byte[1024];
            if (numColors == 4) {
                talpha = new byte[1024];
            }
        }
        int[] numv = new int[]{0};
        int[] numt = new int[]{0};
        float scale = flowScale;
        float pt_size = 0.25f * flowScale;
        float f0 = 0.0f;
        float f1 = 0.0f;
        float f2 = 0.0f;
        for (int j = 0; j < len; ++j) {
            int i;
            byte[] calpha;
            byte[] cblue;
            byte[] cgreen;
            byte[] cred;
            int l;
            float[] cz;
            float[] cy;
            float[] cx;
            if (range_select[0] != null && !range_select[0][j]) continue;
            if (flen == 1) {
                f0 = flow_values[0][0];
                f1 = flow_values[1][0];
                f2 = flow_values[2][0];
            } else {
                f0 = flow_values[0][j];
                f1 = flow_values[1][j];
                f2 = flow_values[2][j];
            }
            if (numv[0] + 256 > vx.length) {
                cx = vx;
                cy = vy;
                cz = vz;
                l = 2 * vx.length;
                vx = new float[l];
                vy = new float[l];
                vz = new float[l];
                System.arraycopy(cx, 0, vx, 0, cx.length);
                System.arraycopy(cy, 0, vy, 0, cy.length);
                System.arraycopy(cz, 0, vz, 0, cz.length);
                if (color_values != null) {
                    cred = vred;
                    cgreen = vgreen;
                    cblue = vblue;
                    calpha = (byte[])(numColors == 4 ? valpha : null);
                    vred = new byte[l];
                    vgreen = new byte[l];
                    vblue = new byte[l];
                    if (calpha != null) {
                        valpha = new byte[l];
                    }
                    System.arraycopy(cred, 0, vred, 0, cred.length);
                    System.arraycopy(cgreen, 0, vgreen, 0, cgreen.length);
                    System.arraycopy(cblue, 0, vblue, 0, cblue.length);
                    if (calpha != null) {
                        System.arraycopy(calpha, 0, valpha, 0, calpha.length);
                    }
                }
            }
            if (numt[0] + 256 > tx.length) {
                cx = tx;
                cy = ty;
                cz = tz;
                l = 2 * tx.length;
                tx = new float[l];
                ty = new float[l];
                tz = new float[l];
                System.arraycopy(cx, 0, tx, 0, cx.length);
                System.arraycopy(cy, 0, ty, 0, cy.length);
                System.arraycopy(cz, 0, tz, 0, cz.length);
                if (color_values != null) {
                    cred = tred;
                    cgreen = tgreen;
                    cblue = tblue;
                    calpha = (byte[])(numColors == 4 ? talpha : null);
                    tred = new byte[l];
                    tgreen = new byte[l];
                    tblue = new byte[l];
                    if (calpha != null) {
                        talpha = new byte[l];
                    }
                    System.arraycopy(cred, 0, tred, 0, cred.length);
                    System.arraycopy(cgreen, 0, tgreen, 0, cgreen.length);
                    System.arraycopy(cblue, 0, tblue, 0, cblue.length);
                    if (calpha != null) {
                        System.arraycopy(calpha, 0, talpha, 0, calpha.length);
                    }
                }
            }
            int oldnv = numv[0];
            int oldnt = numt[0];
            float[] mbarb = ((BarbRenderer)((Object)renderer)).makeVector(south[j], spatial_values[0][j], spatial_values[1][j], spatial_values[2][j], scale, pt_size, f0, f1, vx, vy, vz, numv, tx, ty, tz, numt);
            if (direct) {
                ((BarbManipulationRendererJ3D)renderer).setVectorSpatialValues(mbarb, which);
            }
            int nv = numv[0];
            int nt = numt[0];
            if (color_values == null) continue;
            if (color_values[0].length > 1) {
                int i2;
                for (i2 = oldnv; i2 < nv; ++i2) {
                    vred[i2] = color_values[0][j];
                    vgreen[i2] = color_values[1][j];
                    vblue[i2] = color_values[2][j];
                    if (numColors != 4) continue;
                    valpha[i2] = color_values[3][j];
                }
                for (i2 = oldnt; i2 < nt; ++i2) {
                    tred[i2] = color_values[0][j];
                    tgreen[i2] = color_values[1][j];
                    tblue[i2] = color_values[2][j];
                    if (numColors != 4) continue;
                    talpha[i2] = color_values[3][j];
                }
                continue;
            }
            for (i = oldnv; i < nv; ++i) {
                vred[i] = color_values[0][0];
                vgreen[i] = color_values[1][0];
                vblue[i] = color_values[2][0];
                if (numColors != 4) continue;
                valpha[i] = color_values[3][0];
            }
            for (i = oldnt; i < nt; ++i) {
                tred[i] = color_values[0][0];
                tgreen[i] = color_values[1][0];
                tblue[i] = color_values[2][0];
                if (numColors != 4) continue;
                talpha[i] = color_values[3][0];
            }
        }
        int nv = numv[0];
        int nt = numt[0];
        if (nv == 0) {
            return null;
        }
        VisADGeometryArray[] arrays = null;
        VisADLineArray array = new VisADLineArray();
        array.vertexCount = nv;
        float[] coordinates = new float[3 * nv];
        int m = 0;
        for (int i = 0; i < nv; ++i) {
            coordinates[m++] = vx[i];
            coordinates[m++] = vy[i];
            coordinates[m++] = vz[i];
        }
        array.coordinates = coordinates;
        byte[] colors = null;
        if (color_values != null) {
            colors = new byte[numColors * nv];
            m = 0;
            for (int i = 0; i < nv; ++i) {
                colors[m++] = vred[i];
                colors[m++] = vgreen[i];
                colors[m++] = vblue[i];
                if (numColors != 4) continue;
                colors[m++] = valpha[i];
            }
            array.colors = colors;
        }
        VisADTriangleArray tarray = null;
        if (nt > 0) {
            int i;
            tarray = new VisADTriangleArray();
            tarray.vertexCount = nt;
            coordinates = new float[3 * nt];
            float[] normals = new float[3 * nt];
            m = 0;
            for (i = 0; i < nt; ++i) {
                coordinates[m++] = tx[i];
                coordinates[m++] = ty[i];
                coordinates[m++] = tz[i];
            }
            tarray.coordinates = coordinates;
            m = 0;
            for (i = 0; i < nt; ++i) {
                normals[m++] = 0.0f;
                normals[m++] = 0.0f;
                normals[m++] = 1.0f;
            }
            tarray.normals = normals;
            if (color_values != null) {
                colors = new byte[numColors * nt];
                m = 0;
                for (i = 0; i < nt; ++i) {
                    colors[m++] = tred[i];
                    colors[m++] = tgreen[i];
                    colors[m++] = tblue[i];
                    if (numColors != 4) continue;
                    colors[m++] = talpha[i];
                }
                tarray.colors = colors;
            }
            array = (VisADLineArray)array.adjustLongitudeBulk(renderer);
            tarray = (VisADTriangleArray)tarray.adjustLongitudeBulk(renderer);
            arrays = new VisADGeometryArray[]{array, tarray};
        } else {
            array = (VisADLineArray)array.adjustLongitudeBulk(renderer);
            arrays = new VisADGeometryArray[]{array};
        }
        return arrays;
    }
}

