/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.gempak;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArraySequence;
import ucar.ma2.ArrayStructure;
import ucar.ma2.ArrayStructureBB;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.FileWriter;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Sequence;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.CF;
import ucar.nc2.iosp.IOServiceProvider;
import ucar.nc2.iosp.gempak.AbstractGempakStationFileReader;
import ucar.nc2.iosp.gempak.GempakFileReader;
import ucar.nc2.iosp.gempak.GempakParameter;
import ucar.nc2.iosp.gempak.GempakSoundingFileReader;
import ucar.nc2.iosp.gempak.GempakStation;
import ucar.nc2.iosp.gempak.GempakStationFileIOSP;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;
import visad.util.Trace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GempakSoundingIOSP
extends GempakStationFileIOSP {
    protected static final Dimension DIM_MAXMERGELEVELS = new Dimension("maxMergeLevels", 50, true);

    @Override
    protected AbstractGempakStationFileReader makeStationReader() {
        return new GempakSoundingFileReader();
    }

    @Override
    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        if (!super.isValidFile(raf)) {
            return false;
        }
        return this.gemreader.getFileSubType().equals("merged") || this.gemreader.getFileSubType().equals("unmerged");
    }

    @Override
    public String getFileTypeId() {
        return "GempakSounding";
    }

    @Override
    public String getFileTypeDescription() {
        return "GEMPAK Sounding Obs Data";
    }

    @Override
    public String getCFFeatureType() {
        return CF.FeatureType.stationProfile.toString();
    }

    @Override
    public Array readData(Variable v2, Section section) throws IOException, InvalidRangeException {
        if (this.gemreader == null) {
            return null;
        }
        Array array = this.readSoundingData(v2, section, this.gemreader.getFileSubType().equals("merged"));
        return array;
    }

    private Array readSoundingData(Variable v2, Section section, boolean isMerged) throws IOException {
        ArrayStructureBB array = null;
        if (v2 instanceof Structure) {
            Range stationRange = section.getRange(0);
            Range timeRange = section.getRange(1);
            int size = stationRange.length() * timeRange.length();
            Structure pdata = (Structure)v2;
            StructureMembers members = pdata.makeStructureMembers();
            ArrayStructureBB.setOffsets(members);
            ArrayStructureBB abb = new ArrayStructureBB(members, new int[]{size});
            ByteBuffer buf = abb.getByteBuffer();
            for (int y = stationRange.first(); y <= stationRange.last(); y += stationRange.stride()) {
                for (int x = timeRange.first(); x <= timeRange.last(); x += timeRange.stride()) {
                    List<String> parts = isMerged ? ((GempakSoundingFileReader)this.gemreader).getMergedParts() : ((GempakSoundingFileReader)this.gemreader).getUnmergedParts();
                    boolean allMissing = true;
                    for (String part : parts) {
                        List<GempakParameter> params = this.gemreader.getParameters(part);
                        GempakFileReader.RData vals = this.gemreader.DM_RDTR(x + 1, y + 1, part);
                        ArraySequence aseq = null;
                        Sequence seq = (Sequence)pdata.findVariable(part);
                        if (vals == null) {
                            aseq = this.makeEmptySequence(seq);
                        } else {
                            allMissing = false;
                            aseq = this.makeArraySequence(seq, params, vals.data);
                        }
                        int index = abb.addObjectToHeap(aseq);
                        buf.putInt(index);
                    }
                    buf.put((byte)(allMissing ? 1 : 0));
                }
            }
            array = abb;
            Trace.call2("GEMPAKSIOSP: readMergedData");
        }
        return array;
    }

    private ArraySequence makeEmptySequence(Sequence seq) {
        StructureMembers members = seq.makeStructureMembers();
        return new ArraySequence(members, new EmptyStructureDataIterator(), -1);
    }

    private ArraySequence makeArraySequence(Sequence seq, List<GempakParameter> params, float[] values) {
        if (values == null) {
            return this.makeEmptySequence(seq);
        }
        int numLevels = values.length / params.size();
        StructureMembers members = seq.makeStructureMembers();
        int offset = ArrayStructureBB.setOffsets(members);
        members.setStructureSize(offset);
        int size = offset * numLevels;
        byte[] bytes = new byte[size];
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        ArrayStructureBB abb = new ArrayStructureBB(members, new int[]{numLevels}, buf, 0);
        int var = 0;
        for (int i = 0; i < numLevels; ++i) {
            for (GempakParameter param : params) {
                if (members.findMember(param.getName()) != null) {
                    buf.putFloat(values[var]);
                }
                ++var;
            }
        }
        return new ArraySequence(members, new SequenceIterator(numLevels, abb), numLevels);
    }

    public static void main(String[] args) throws IOException {
        GempakSoundingIOSP mciosp = new GempakSoundingIOSP();
        RandomAccessFile rf = new RandomAccessFile(args[0], "r", 2048);
        MakeNetcdfFile ncfile = new MakeNetcdfFile(mciosp, rf, args[0], null);
        if (args.length > 1) {
            FileWriter.writeToFile(ncfile, args[1]);
        } else {
            System.out.println(ncfile);
        }
    }

    @Override
    protected void fillNCFile() throws IOException {
        String fileType = this.gemreader.getFileSubType();
        this.buildFile(fileType.equals("merged"));
    }

    private void buildFile(boolean isMerged) {
        List<Object> sequenceNames;
        List<GempakStation> stations = this.gemreader.getStations();
        Dimension station = new Dimension("station", stations.size(), true);
        this.ncfile.addDimension(null, station);
        this.ncfile.addDimension(null, DIM_LEN8);
        this.ncfile.addDimension(null, DIM_LEN4);
        this.ncfile.addDimension(null, DIM_LEN2);
        List<Variable> stationVars = this.makeStationVars(stations, station);
        for (Variable stnVar : stationVars) {
            this.ncfile.addVariable(null, stnVar);
        }
        List<Date> timeList = this.gemreader.getDates();
        int numTimes = timeList.size();
        Dimension times = new Dimension("time", numTimes, true);
        this.ncfile.addDimension(null, times);
        ArrayDouble.D1 varArray = null;
        Variable timeVar = new Variable(this.ncfile, null, null, "time", DataType.DOUBLE, "time");
        timeVar.addAttribute(new Attribute("units", "seconds since 1970-01-01 00:00:00"));
        timeVar.addAttribute(new Attribute("long_name", "time"));
        varArray = new ArrayDouble.D1(numTimes);
        int i = 0;
        for (Date date : timeList) {
            varArray.set(i, (double)date.getTime() / 1000.0);
            ++i;
        }
        timeVar.setCachedData(varArray, false);
        this.ncfile.addVariable(null, timeVar);
        ArrayList<Dimension> stationTime = new ArrayList<Dimension>();
        stationTime.add(station);
        stationTime.add(times);
        String structName = isMerged ? "merged" : "unmerged";
        structName = structName + "Sounding";
        Structure sVar = new Structure(this.ncfile, null, null, structName);
        sVar.setDimensions(stationTime);
        sVar.addAttribute(new Attribute("coordinates", "time SLAT SLON SELV"));
        if (isMerged) {
            sequenceNames = new ArrayList<String>();
            sequenceNames.add("SNDT");
        } else {
            sequenceNames = ((GempakSoundingFileReader)this.gemreader).getUnmergedParts();
        }
        for (String string : sequenceNames) {
            Sequence paramData = this.makeSequence(sVar, string, false);
            if (paramData == null) continue;
            sVar.addMemberVariable(paramData);
        }
        sVar.addMemberVariable(this.makeMissingVariable());
        this.ncfile.addAttribute(null, new Attribute("CF:featureType", CF.FeatureType.stationProfile.toString()));
        this.ncfile.addVariable(null, sVar);
    }

    protected Sequence makeSequence(Structure parent, String partName, boolean includeMissing) {
        List<GempakParameter> params = this.gemreader.getParameters(partName);
        if (params == null) {
            return null;
        }
        Sequence sVar = new Sequence(this.ncfile, null, parent, partName);
        sVar.setDimensions("");
        for (GempakParameter param : params) {
            Variable v = this.makeParamVariable(param, null);
            this.addVerticalCoordAttribute(v);
            sVar.addMemberVariable(v);
        }
        if (includeMissing) {
            sVar.addMemberVariable(this.makeMissingVariable());
        }
        return sVar;
    }

    private void addVerticalCoordAttribute(Variable v) {
        GempakSoundingFileReader gsfr = (GempakSoundingFileReader)this.gemreader;
        int vertType = gsfr.getVerticalCoordinate();
        String pName = v.getName();
        if (this.gemreader.getFileSubType().equals("merged")) {
            if (vertType == 1 && pName.equals("PRES")) {
                v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Pressure.name()));
            } else if (vertType == 3 && (pName.equals("HGHT") || pName.equals("MHGT") || pName.equals("DHGT"))) {
                v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Height.name()));
            }
        } else if (pName.equals("PRES")) {
            v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Pressure.name()));
        }
    }

    private class SequenceIterator
    implements StructureDataIterator {
        private int count;
        private ArrayStructure abb;
        private StructureDataIterator siter;

        SequenceIterator(int count, ArrayStructure abb) {
            this.count = count;
            this.abb = abb;
        }

        public boolean hasNext() throws IOException {
            if (this.siter == null) {
                this.siter = this.abb.getStructureDataIterator();
            }
            return this.siter.hasNext();
        }

        public StructureData next() throws IOException {
            return this.siter.next();
        }

        public void setBufferSize(int bytes) {
            this.siter.setBufferSize(bytes);
        }

        public StructureDataIterator reset() {
            this.siter = null;
            return this;
        }

        public int getCurrentRecno() {
            return this.siter.getCurrentRecno();
        }
    }

    class EmptyStructureDataIterator
    implements StructureDataIterator {
        EmptyStructureDataIterator() {
        }

        public boolean hasNext() throws IOException {
            return false;
        }

        public StructureData next() throws IOException {
            return null;
        }

        public void setBufferSize(int bytes) {
        }

        public StructureDataIterator reset() {
            return this;
        }

        public int getCurrentRecno() {
            return -1;
        }
    }

    protected static class MakeNetcdfFile
    extends NetcdfFile {
        MakeNetcdfFile(IOServiceProvider spi, RandomAccessFile raf, String location, CancelTask cancelTask) throws IOException {
            super(spi, raf, location, cancelTask);
        }
    }
}

