/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib1;

import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ucar.grib.grib1.Grib1IndicatorSection;
import ucar.grib.grib1.Grib1ProductDefinitionSection;
import ucar.unidata.io.RandomAccessFile;

public final class Grib1SplitByGridID {
    private RandomAccessFile raf = null;
    private String header = "GRIB";
    public static String fileName;
    public static Map<String, DataOutputStream> gridFiles;
    private static final Pattern productID;

    public Grib1SplitByGridID(RandomAccessFile raf) {
        this.raf = raf;
    }

    public final boolean scan() throws IOException {
        Grib1ProductDefinitionSection pds = null;
        long start = this.raf.getFilePointer();
        while (this.raf.getFilePointer() < this.raf.length()) {
            start = this.raf.getFilePointer();
            if (!this.seekHeader(this.raf, this.raf.length())) continue;
            Grib1IndicatorSection is = new Grib1IndicatorSection(this.raf);
            long EOR = this.raf.getFilePointer() + is.getGribLength() - (long)is.getLength();
            if (is.getGribEdition() == 2) {
                System.out.println("Error Grib 2 record in Grib1 file");
                this.raf.seek(EOR);
                continue;
            }
            try {
                pds = new Grib1ProductDefinitionSection(this.raf);
                if (pds.getLengthErr()) {
                    this.raf.seek(EOR);
                    continue;
                }
                String gridID = Integer.toString(pds.getGrid_ID());
                DataOutputStream dos = this.getOS(gridID);
                long size = EOR - start;
                byte[] data = new byte[(int)size];
                this.raf.seek(start);
                this.raf.read(data);
                dos.write(data, 0, data.length);
                dos.flush();
                this.raf.seek(EOR);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.raf.seek(EOR);
            }
        }
        Set<String> ids = gridFiles.keySet();
        for (String id : ids) {
            DataOutputStream os = gridFiles.get(id);
            os.close();
        }
        return true;
    }

    private boolean seekHeader(RandomAccessFile raf, long stop) throws IOException {
        StringBuffer hdr = new StringBuffer();
        int match = 0;
        while (raf.getFilePointer() < stop) {
            char c = (char)raf.read();
            hdr.append(c);
            if (c == 'G') {
                match = 1;
                continue;
            }
            if (c == 'R' && match == 1) {
                match = 2;
                continue;
            }
            if (c == 'I' && match == 2) {
                match = 3;
                continue;
            }
            if (c == 'B' && match == 3) {
                match = 4;
                Matcher m = productID.matcher(hdr.toString());
                this.header = m.find() ? m.group(1) : "GRIB1";
                return true;
            }
            match = 0;
        }
        return false;
    }

    private DataOutputStream getOS(String gid) throws IOException {
        DataOutputStream os = gridFiles.get(gid);
        if (os != null) {
            return os;
        }
        int idx = fileName.indexOf("20");
        String gFile = fileName.substring(0, idx) + "G" + gid + "_" + fileName.substring(idx);
        os = new DataOutputStream(new FileOutputStream(gFile));
        gridFiles.put(gid, os);
        return os;
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.out.println("No file name given");
            return;
        }
        fileName = args[0];
        RandomAccessFile raf = new RandomAccessFile(fileName, "r");
        Grib1SplitByGridID sbgid = new Grib1SplitByGridID(raf);
        sbgid.scan();
    }

    static {
        gridFiles = new HashMap<String, DataOutputStream>();
        productID = Pattern.compile("(\\w{6} \\w{4} \\d{6})");
    }
}

