/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import loci.formats.AxisGuesser;
import loci.formats.CoreMetadata;
import loci.formats.FilePattern;
import loci.formats.FormatException;
import loci.formats.FormatHandler;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.ImageTools;
import loci.formats.Location;
import loci.formats.LogTools;
import loci.formats.MetadataStore;
import loci.formats.ReaderWrapper;
import loci.formats.StatusListener;

public class FileStitcher
implements IFormatReader {
    private IFormatReader reader;
    private boolean patternIds = false;
    private String currentId;
    private FilePattern fp;
    private AxisGuesser[] ag;
    private String[] files;
    private String[] usedFiles;
    private IFormatReader[] readers;
    private BufferedImage[] blankImage;
    private byte[][] blankBytes;
    private BufferedImage[] blankThumb;
    private byte[][] blankThumbBytes;
    private int[] imagesPerFile;
    private int[] sizeZ;
    private int[] sizeC;
    private int[] sizeT;
    private int[][] lenZ;
    private int[][] lenC;
    private int[][] lenT;
    private CoreMetadata core;

    public FileStitcher() {
        this(new ImageReader());
    }

    public FileStitcher(boolean patternIds) {
        this(new ImageReader(), patternIds);
    }

    public FileStitcher(IFormatReader r) {
        this(r, false);
    }

    public FileStitcher(IFormatReader r, boolean patternIds) {
        this.reader = r;
        this.patternIds = patternIds;
    }

    public IFormatReader getReader() {
        return this.reader;
    }

    public int[] getAxisTypes() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.ag[this.getSeries()].getAxisTypes();
    }

    public void setAxisTypes(int[] axes) throws FormatException {
        FormatTools.assertId(this.currentId, true, 2);
        this.ag[this.getSeries()].setAxisTypes(axes);
        this.computeAxisLengths();
    }

    public FilePattern getFilePattern() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.fp;
    }

    public AxisGuesser getAxisGuesser() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.ag[this.getSeries()];
    }

    public FilePattern findPattern(String id) {
        FormatTools.assertId(this.currentId, true, 2);
        if (!this.patternIds) {
            Hashtable map = Location.getIdMap();
            String pattern = null;
            if (map.containsKey(id)) {
                String[] idList = new String[map.size()];
                Enumeration en = map.keys();
                for (int i = 0; i < idList.length; ++i) {
                    idList[i] = (String)en.nextElement();
                }
                pattern = FilePattern.findPattern(id, null, idList);
            } else {
                pattern = FilePattern.findPattern(new Location(id));
            }
            if (pattern != null) {
                id = pattern;
            }
        }
        return new FilePattern(id);
    }

    public boolean isThisType(byte[] block) {
        return this.reader.isThisType(block);
    }

    public void setId(String id) throws FormatException, IOException {
        if (!id.equals(this.currentId)) {
            this.initFile(id);
        }
    }

    public void setId(String id, boolean force) throws FormatException, IOException {
        if (!id.equals(this.currentId) || force) {
            this.initFile(id);
        }
    }

    public int getImageCount() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.core.imageCount[this.getSeries()];
    }

    public boolean isRGB() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.core.rgb[this.getSeries()];
    }

    public int getSizeX() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.core.sizeX[this.getSeries()];
    }

    public int getSizeY() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.core.sizeY[this.getSeries()];
    }

    public int getSizeZ() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.core.sizeZ[this.getSeries()];
    }

    public int getSizeC() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.core.sizeC[this.getSeries()];
    }

    public int getSizeT() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.core.sizeT[this.getSeries()];
    }

    public int getPixelType() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.core.pixelType[this.getSeries()];
    }

    public int getEffectiveSizeC() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getImageCount() / (this.getSizeZ() * this.getSizeT());
    }

    public int getRGBChannelCount() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getSizeC() / this.getEffectiveSizeC();
    }

    public boolean isIndexed() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.reader.isIndexed();
    }

    public boolean isFalseColor() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.reader.isFalseColor();
    }

    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 2);
        return this.reader.get8BitLookupTable();
    }

    public short[][] get16BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 2);
        return this.reader.get16BitLookupTable();
    }

    public int[] getChannelDimLengths() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core.cLengths[this.getSeries()];
    }

    public String[] getChannelDimTypes() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core.cTypes[this.getSeries()];
    }

    public int getThumbSizeX() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.reader.getThumbSizeX();
    }

    public int getThumbSizeY() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.reader.getThumbSizeY();
    }

    public boolean isLittleEndian() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.reader.isLittleEndian();
    }

    public String getDimensionOrder() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.core.currentOrder[this.getSeries()];
    }

    public boolean isOrderCertain() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.core.orderCertain[this.getSeries()];
    }

    public boolean isInterleaved() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.reader.isInterleaved();
    }

    public boolean isInterleaved(int subC) {
        FormatTools.assertId(this.currentId, true, 2);
        return this.reader.isInterleaved(subC);
    }

    public BufferedImage openImage(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 2);
        int[] q = this.computeIndices(no);
        int fno = q[0];
        int ino = q[1];
        if (ino < this.readers[fno].getImageCount()) {
            return this.readers[fno].openImage(ino);
        }
        int sno = this.getSeries();
        if (this.blankImage[sno] == null) {
            this.blankImage[sno] = ImageTools.blankImage(this.core.sizeX[sno], this.core.sizeY[sno], this.sizeC[sno], this.getPixelType());
        }
        return this.blankImage[sno];
    }

    public byte[] openBytes(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 2);
        int[] q = this.computeIndices(no);
        int fno = q[0];
        int ino = q[1];
        if (ino < this.readers[fno].getImageCount()) {
            return this.readers[fno].openBytes(ino);
        }
        int sno = this.getSeries();
        if (this.blankBytes[sno] == null) {
            int bytes = FormatTools.getBytesPerPixel(this.getPixelType());
            this.blankBytes[sno] = new byte[this.core.sizeX[sno] * this.core.sizeY[sno] * bytes * this.getRGBChannelCount()];
        }
        return this.blankBytes[sno];
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 2);
        int[] q = this.computeIndices(no);
        int fno = q[0];
        int ino = q[1];
        if (ino < this.readers[fno].getImageCount()) {
            return this.readers[fno].openBytes(ino, buf);
        }
        Arrays.fill(buf, (byte)0);
        return buf;
    }

    public BufferedImage openThumbImage(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 2);
        int[] q = this.computeIndices(no);
        int fno = q[0];
        int ino = q[1];
        if (ino < this.readers[fno].getImageCount()) {
            return this.readers[fno].openThumbImage(ino);
        }
        int sno = this.getSeries();
        if (this.blankThumb[sno] == null) {
            this.blankThumb[sno] = ImageTools.blankImage(this.getThumbSizeX(), this.getThumbSizeY(), this.sizeC[sno], this.getPixelType());
        }
        return this.blankThumb[sno];
    }

    public byte[] openThumbBytes(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 2);
        int[] q = this.computeIndices(no);
        int fno = q[0];
        int ino = q[1];
        if (ino < this.readers[fno].getImageCount()) {
            return this.readers[fno].openThumbBytes(ino);
        }
        int sno = this.getSeries();
        if (this.blankThumbBytes[sno] == null) {
            int bytes = FormatTools.getBytesPerPixel(this.getPixelType());
            this.blankThumbBytes[sno] = new byte[this.getThumbSizeX() * this.getThumbSizeY() * bytes * this.getRGBChannelCount()];
        }
        return this.blankThumbBytes[sno];
    }

    public void close(boolean fileOnly) throws IOException {
        if (this.readers == null) {
            this.reader.close(fileOnly);
        } else {
            for (int i = 0; i < this.readers.length; ++i) {
                this.readers[i].close(fileOnly);
            }
        }
        if (!fileOnly) {
            this.readers = null;
            this.blankImage = null;
            this.blankBytes = null;
            this.currentId = null;
        }
    }

    public void close() throws IOException {
        if (this.readers == null) {
            this.reader.close();
        } else {
            for (int i = 0; i < this.readers.length; ++i) {
                this.readers[i].close();
            }
        }
        this.readers = null;
        this.blankImage = null;
        this.blankBytes = null;
        this.currentId = null;
    }

    public int getSeriesCount() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.reader.getSeriesCount();
    }

    public void setSeries(int no) {
        FormatTools.assertId(this.currentId, true, 2);
        this.reader.setSeries(no);
    }

    public int getSeries() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.reader.getSeries();
    }

    public void setGroupFiles(boolean group) {
        for (int i = 0; i < this.readers.length; ++i) {
            this.readers[i].setGroupFiles(group);
        }
    }

    public boolean isGroupFiles() {
        return this.readers[0].isGroupFiles();
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return this.readers[0].fileGroupOption(id);
    }

    public boolean isMetadataComplete() {
        return this.readers[0].isMetadataComplete();
    }

    public void setNormalized(boolean normalize) {
        FormatTools.assertId(this.currentId, false, 2);
        if (this.readers == null) {
            this.reader.setNormalized(normalize);
        } else {
            for (int i = 0; i < this.readers.length; ++i) {
                this.readers[i].setNormalized(normalize);
            }
        }
    }

    public boolean isNormalized() {
        return this.reader.isNormalized();
    }

    public void setMetadataCollected(boolean collect) {
        FormatTools.assertId(this.currentId, false, 2);
        if (this.readers == null) {
            this.reader.setMetadataCollected(collect);
        } else {
            for (int i = 0; i < this.readers.length; ++i) {
                this.readers[i].setMetadataCollected(collect);
            }
        }
    }

    public boolean isMetadataCollected() {
        return this.reader.isMetadataCollected();
    }

    public void setOriginalMetadataPopulated(boolean populate) {
        FormatTools.assertId(this.currentId, false, 1);
        if (this.readers == null) {
            this.reader.setOriginalMetadataPopulated(populate);
        } else {
            for (int i = 0; i < this.readers.length; ++i) {
                this.readers[i].setOriginalMetadataPopulated(populate);
            }
        }
    }

    public boolean isOriginalMetadataPopulated() {
        return this.reader.isOriginalMetadataPopulated();
    }

    public String[] getUsedFiles() {
        FormatTools.assertId(this.currentId, true, 2);
        if (this.reader.getUsedFiles().length > 1) {
            if (this.usedFiles == null) {
                int i;
                String[][] used = new String[this.files.length][];
                int total = 0;
                for (i = 0; i < this.files.length; ++i) {
                    try {
                        this.readers[i].setId(this.files[i]);
                    }
                    catch (FormatException exc) {
                        LogTools.trace(exc);
                        return null;
                    }
                    catch (IOException exc) {
                        LogTools.trace(exc);
                        return null;
                    }
                    used[i] = this.readers[i].getUsedFiles();
                    total += used[i].length;
                }
                this.usedFiles = new String[total];
                int off = 0;
                for (i = 0; i < used.length; ++i) {
                    System.arraycopy(used[i], 0, this.usedFiles, off, used[i].length);
                    off += used[i].length;
                }
            }
            return this.usedFiles;
        }
        return this.files;
    }

    public String getCurrentFile() {
        return this.currentId;
    }

    public int getIndex(int z, int c, int t) {
        return FormatTools.getIndex(this, z, c, t);
    }

    public int[] getZCTCoords(int index) {
        return FormatTools.getZCTCoords(this, index);
    }

    public Object getMetadataValue(String field) {
        FormatTools.assertId(this.currentId, true, 2);
        return this.reader.getMetadataValue(field);
    }

    public Hashtable getMetadata() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.reader.getMetadata();
    }

    public CoreMetadata getCoreMetadata() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.core;
    }

    public void setMetadataFiltered(boolean filter) {
        FormatTools.assertId(this.currentId, false, 2);
        this.reader.setMetadataFiltered(filter);
    }

    public boolean isMetadataFiltered() {
        return this.reader.isMetadataFiltered();
    }

    public void setMetadataStore(MetadataStore store) {
        FormatTools.assertId(this.currentId, false, 2);
        this.reader.setMetadataStore(store);
    }

    public MetadataStore getMetadataStore() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.reader.getMetadataStore();
    }

    public Object getMetadataStoreRoot() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.reader.getMetadataStoreRoot();
    }

    public boolean isThisType(String name) {
        return this.reader.isThisType(name);
    }

    public boolean isThisType(String name, boolean open) {
        return this.reader.isThisType(name, open);
    }

    public String getFormat() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.reader.getFormat();
    }

    public String[] getSuffixes() {
        return this.reader.getSuffixes();
    }

    public void addStatusListener(StatusListener l) {
        if (this.readers == null) {
            this.reader.addStatusListener(l);
        } else {
            for (int i = 0; i < this.readers.length; ++i) {
                this.readers[i].addStatusListener(l);
            }
        }
    }

    public void removeStatusListener(StatusListener l) {
        if (this.readers == null) {
            this.reader.removeStatusListener(l);
        } else {
            for (int i = 0; i < this.readers.length; ++i) {
                this.readers[i].removeStatusListener(l);
            }
        }
    }

    public StatusListener[] getStatusListeners() {
        return this.reader.getStatusListeners();
    }

    protected void initFile(String id) throws FormatException, IOException {
        int i;
        if (FormatHandler.debug) {
            LogTools.println("calling FileStitcher.initFile(" + id + ")");
        }
        this.currentId = id;
        this.fp = this.findPattern(id);
        String msg = " Please rename your files or disable file stitching.";
        if (!this.fp.isValid()) {
            throw new FormatException("Invalid " + (this.patternIds ? "file pattern" : "filename") + " (" + this.currentId + "): " + this.fp.getErrorMessage() + msg);
        }
        this.files = this.fp.getFiles();
        if (this.files == null) {
            throw new FormatException("No files matching pattern (" + this.fp.getPattern() + "). " + msg);
        }
        for (int i2 = 0; i2 < this.files.length; ++i2) {
            if (new Location(this.files[i2]).exists()) continue;
            throw new FormatException("File #" + i2 + " (" + this.files[i2] + ") does not exist.");
        }
        Vector classes = new Vector();
        IFormatReader r = this.reader;
        while (r instanceof ReaderWrapper) {
            classes.add(r.getClass());
            r = ((ReaderWrapper)r).getReader();
        }
        if (r instanceof ImageReader) {
            r = ((ImageReader)r).getReader(this.files[0]);
        }
        classes.add(r.getClass());
        this.readers = new IFormatReader[this.files.length];
        this.readers[0] = this.reader;
        for (int i3 = 1; i3 < this.readers.length; ++i3) {
            try {
                r = null;
                for (int j = classes.size() - 1; j >= 0; --j) {
                    Class c = (Class)classes.elementAt(j);
                    r = r == null ? (IFormatReader)c.newInstance() : (IFormatReader)c.getConstructor(IFormatReader.class).newInstance(r);
                }
                this.readers[i3] = r;
                continue;
            }
            catch (InstantiationException exc) {
                LogTools.trace(exc);
                continue;
            }
            catch (IllegalAccessException exc) {
                LogTools.trace(exc);
                continue;
            }
            catch (NoSuchMethodException exc) {
                LogTools.trace(exc);
                continue;
            }
            catch (InvocationTargetException exc) {
                LogTools.trace(exc);
            }
        }
        boolean normalized = this.reader.isNormalized();
        boolean metadataFiltered = this.reader.isMetadataFiltered();
        boolean metadataCollected = this.reader.isMetadataCollected();
        StatusListener[] statusListeners = this.reader.getStatusListeners();
        for (int i4 = 1; i4 < this.readers.length; ++i4) {
            this.readers[i4].setNormalized(normalized);
            this.readers[i4].setMetadataFiltered(metadataFiltered);
            this.readers[i4].setMetadataCollected(metadataCollected);
            for (int j = 0; j < statusListeners.length; ++j) {
                this.readers[i4].addStatusListener(statusListeners[j]);
            }
        }
        this.reader.setId(this.files[0]);
        int seriesCount = this.reader.getSeriesCount();
        this.ag = new AxisGuesser[seriesCount];
        this.blankImage = new BufferedImage[seriesCount];
        this.blankBytes = new byte[seriesCount][];
        this.blankThumb = new BufferedImage[seriesCount];
        this.blankThumbBytes = new byte[seriesCount][];
        this.imagesPerFile = new int[seriesCount];
        this.sizeZ = new int[seriesCount];
        this.sizeC = new int[seriesCount];
        this.sizeT = new int[seriesCount];
        boolean[] certain = new boolean[seriesCount];
        this.lenZ = new int[seriesCount][];
        this.lenC = new int[seriesCount][];
        this.lenT = new int[seriesCount][];
        this.core = new CoreMetadata(seriesCount);
        int oldSeries = this.reader.getSeries();
        for (i = 0; i < seriesCount; ++i) {
            this.reader.setSeries(i);
            this.core.sizeX[i] = this.reader.getSizeX();
            this.core.sizeY[i] = this.reader.getSizeY();
            this.core.pixelType[i] = this.reader.getPixelType();
            this.imagesPerFile[i] = this.reader.getImageCount();
            this.core.imageCount[i] = this.files.length * this.imagesPerFile[i];
            this.core.thumbSizeX[i] = this.reader.getThumbSizeX();
            this.core.thumbSizeY[i] = this.reader.getThumbSizeY();
            this.core.currentOrder[i] = this.reader.getDimensionOrder();
            this.core.rgb[i] = this.reader.isRGB();
            this.core.littleEndian[i] = this.reader.isLittleEndian();
            this.core.interleaved[i] = this.reader.isInterleaved();
            this.core.seriesMetadata[i] = this.reader.getMetadata();
            this.sizeZ[i] = this.reader.getSizeZ();
            this.sizeC[i] = this.reader.getSizeC();
            this.sizeT[i] = this.reader.getSizeT();
            certain[i] = this.reader.isOrderCertain();
        }
        this.reader.setSeries(oldSeries);
        for (i = 0; i < seriesCount; ++i) {
            this.ag[i] = new AxisGuesser(this.fp, this.core.currentOrder[i], this.sizeZ[i], this.sizeT[i], this.sizeC[i], certain[i]);
        }
        for (i = 0; i < seriesCount; ++i) {
            this.setSeries(i);
            this.core.currentOrder[i] = this.ag[i].getAdjustedOrder();
            this.core.orderCertain[i] = this.ag[i].isCertain();
            this.computeAxisLengths();
        }
        this.setSeries(oldSeries);
        this.usedFiles = null;
    }

    protected void computeAxisLengths() throws FormatException {
        int i;
        int i2;
        int sno = this.getSeries();
        int[] count = this.fp.getCount();
        int[] axes = this.ag[sno].getAxisTypes();
        int numZ = this.ag[sno].getAxisCountZ();
        int numC = this.ag[sno].getAxisCountC();
        int numT = this.ag[sno].getAxisCountT();
        this.core.sizeZ[sno] = this.sizeZ[sno];
        this.core.sizeC[sno] = this.sizeC[sno];
        this.core.sizeT[sno] = this.sizeT[sno];
        this.lenZ[sno] = new int[numZ + 1];
        this.lenC[sno] = new int[numC + 1];
        this.lenT[sno] = new int[numT + 1];
        this.lenZ[sno][0] = this.sizeZ[sno];
        this.lenC[sno][0] = this.sizeC[sno];
        this.lenT[sno][0] = this.sizeT[sno];
        int z = 1;
        int c = 1;
        int t = 1;
        block5: for (int i3 = 0; i3 < axes.length; ++i3) {
            switch (axes[i3]) {
                case 1: {
                    int n = sno;
                    this.core.sizeZ[n] = this.core.sizeZ[n] * count[i3];
                    this.lenZ[sno][z++] = count[i3];
                    continue block5;
                }
                case 3: {
                    int n = sno;
                    this.core.sizeC[n] = this.core.sizeC[n] * count[i3];
                    this.lenC[sno][c++] = count[i3];
                    continue block5;
                }
                case 2: {
                    int n = sno;
                    this.core.sizeT[n] = this.core.sizeT[n] * count[i3];
                    this.lenT[sno][t++] = count[i3];
                    continue block5;
                }
                default: {
                    throw new FormatException("Unknown axis type for axis #" + i3 + ": " + axes[i3]);
                }
            }
        }
        int[] cLengths = this.reader.getChannelDimLengths();
        String[] cTypes = this.reader.getChannelDimTypes();
        int cCount = 0;
        for (i2 = 0; i2 < cLengths.length; ++i2) {
            if (cLengths[i2] <= 1) continue;
            ++cCount;
        }
        for (i2 = 1; i2 < this.lenC[sno].length; ++i2) {
            if (this.lenC[sno][i2] <= 1) continue;
            ++cCount;
        }
        if (cCount == 0) {
            this.core.cLengths[sno] = new int[]{1};
            this.core.cTypes[sno] = new String[]{"Channel"};
        } else {
            this.core.cLengths[sno] = new int[cCount];
            this.core.cTypes[sno] = new String[cCount];
        }
        int c2 = 0;
        for (i = 0; i < cLengths.length; ++i) {
            if (cLengths[i] == 1) continue;
            this.core.cLengths[sno][c2] = cLengths[i];
            this.core.cTypes[sno][c2] = cTypes[i];
            ++c2;
        }
        for (i = 1; i < this.lenC[sno].length; ++i) {
            if (this.lenC[sno][i] == 1) continue;
            this.core.cLengths[sno][c2] = this.lenC[sno][i];
            this.core.cTypes[sno][c2] = "Channel";
        }
        int pixelType = this.getPixelType();
        boolean little = this.reader.isLittleEndian();
        MetadataStore s = this.reader.getMetadataStore();
        s.setPixels(new Integer(this.core.sizeX[sno]), new Integer(this.core.sizeY[sno]), new Integer(this.core.sizeZ[sno]), new Integer(this.core.sizeC[sno]), new Integer(this.core.sizeT[sno]), new Integer(pixelType), new Boolean(!little), this.core.currentOrder[sno], new Integer(sno), null);
    }

    protected int[] computeIndices(int no) throws FormatException, IOException {
        int sno = this.getSeries();
        int[] axes = this.ag[sno].getAxisTypes();
        int[] count = this.fp.getCount();
        int[] zct = this.getZCTCoords(no);
        zct[1] = zct[1] * this.getRGBChannelCount();
        int[] posZ = FormatTools.rasterToPosition(this.lenZ[sno], zct[0]);
        int[] posC = FormatTools.rasterToPosition(this.lenC[sno], zct[1]);
        int[] posT = FormatTools.rasterToPosition(this.lenT[sno], zct[2]);
        int[] pos = new int[axes.length];
        int z = 1;
        int c = 1;
        int t = 1;
        for (int i = 0; i < axes.length; ++i) {
            if (axes[i] == 1) {
                pos[i] = posZ[z++];
                continue;
            }
            if (axes[i] == 3) {
                pos[i] = posC[c++];
                continue;
            }
            if (axes[i] == 2) {
                pos[i] = posT[t++];
                continue;
            }
            throw new FormatException("Unknown axis type for axis #" + i + ": " + axes[i]);
        }
        int fno = FormatTools.positionToRaster(count, pos);
        this.readers[fno].setId(this.files[fno]);
        this.readers[fno].setSeries(this.reader.getSeries());
        int ino = posZ[0] < this.readers[fno].getSizeZ() && posC[0] < this.readers[fno].getSizeC() && posT[0] < this.readers[fno].getSizeT() ? FormatTools.getIndex(this.readers[fno], posZ[0], posC[0], posT[0]) : Integer.MAX_VALUE;
        return new int[]{fno, ino};
    }

    protected int[] getIncludeList(int theC) throws FormatException, IOException {
        int[] include = new int[this.readers.length];
        Arrays.fill(include, -1);
        for (int t = 0; t < this.sizeT[this.getSeries()]; ++t) {
            for (int z = 0; z < this.sizeZ[this.getSeries()]; ++z) {
                int ino;
                int no = this.getIndex(z, theC, t);
                int[] q = this.computeIndices(no);
                int fno = q[0];
                include[fno] = ino = q[1];
            }
        }
        return include;
    }

    public int[] getAxisTypes(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getAxisTypes();
    }

    public void setAxisTypes(String id, int[] axes) throws FormatException, IOException {
        this.setId(id);
        this.setAxisTypes(axes);
    }

    public FilePattern getFilePattern(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getFilePattern();
    }

    public AxisGuesser getAxisGuesser(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getAxisGuesser();
    }

    public int getImageCount(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getImageCount();
    }

    public boolean isRGB(String id) throws FormatException, IOException {
        this.setId(id);
        return this.isRGB();
    }

    public int getSizeX(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getSizeX();
    }

    public int getSizeY(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getSizeY();
    }

    public int getSizeZ(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getSizeZ();
    }

    public int getSizeC(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getSizeC();
    }

    public int getSizeT(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getSizeT();
    }

    public int getPixelType(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getPixelType();
    }

    public int getEffectiveSizeC(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getEffectiveSizeC();
    }

    public int getRGBChannelCount(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getSizeC() / this.getEffectiveSizeC();
    }

    public int[] getChannelDimLengths(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getChannelDimLengths();
    }

    public String[] getChannelDimTypes(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getChannelDimTypes();
    }

    public int getThumbSizeX(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getThumbSizeX();
    }

    public int getThumbSizeY(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getThumbSizeY();
    }

    public boolean isLittleEndian(String id) throws FormatException, IOException {
        this.setId(id);
        return this.isLittleEndian();
    }

    public String getDimensionOrder(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getDimensionOrder();
    }

    public boolean isOrderCertain(String id) throws FormatException, IOException {
        this.setId(id);
        return this.isOrderCertain();
    }

    public boolean isInterleaved(String id) throws FormatException, IOException {
        this.setId(id);
        return this.isInterleaved();
    }

    public boolean isInterleaved(String id, int subC) throws FormatException, IOException {
        this.setId(id);
        return this.isInterleaved(subC);
    }

    public BufferedImage openImage(String id, int no) throws FormatException, IOException {
        this.setId(id);
        return this.openImage(no);
    }

    public byte[] openBytes(String id, int no) throws FormatException, IOException {
        this.setId(id);
        return this.openBytes(no);
    }

    public byte[] openBytes(String id, int no, byte[] buf) throws FormatException, IOException {
        this.setId(id);
        return this.openBytes(no, buf);
    }

    public BufferedImage openThumbImage(String id, int no) throws FormatException, IOException {
        this.setId(id);
        return this.openThumbImage(no);
    }

    public byte[] openThumbBytes(String id, int no) throws FormatException, IOException {
        this.setId(id);
        return this.openThumbBytes(no);
    }

    public int getSeriesCount(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getSeriesCount();
    }

    public void setSeries(String id, int no) throws FormatException, IOException {
        this.setId(id);
        this.setSeries(no);
    }

    public int getSeries(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getSeries();
    }

    public String[] getUsedFiles(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getUsedFiles();
    }

    public int getIndex(String id, int z, int c, int t) throws FormatException, IOException {
        this.setId(id);
        return this.getIndex(z, c, t);
    }

    public int[] getZCTCoords(String id, int index) throws FormatException, IOException {
        this.setId(id);
        return this.getZCTCoords(index);
    }

    public Object getMetadataValue(String id, String field) throws FormatException, IOException {
        this.setId(id);
        return this.getMetadataValue(field);
    }

    public Hashtable getMetadata(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getMetadata();
    }

    public CoreMetadata getCoreMetadata(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getCoreMetadata();
    }

    public MetadataStore getMetadataStore(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getMetadataStore();
    }

    public Object getMetadataStoreRoot(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getMetadataStoreRoot();
    }
}

