/*
 * $Id: sig_manage.h,v 1.10 2012-03-06 14:46:49 siflkres Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SIG_MANAGE_H_INCLUDED
#define __SIG_MANAGE_H_INCLUDED

#include "sig_gen.h"

struct sig_manage_funcs {
	void (*connect)(void *s, const char *str, void *sig);
	void (*disconnect)(void *s, const char *str);
};

struct sig_manage {
	enum sig_gen_type type;
	struct {
		void *s;
		const struct sig_manage_funcs *f;
	} member[1];
	unsigned int nmembers;
};

extern void
sig_manage_connect_port(struct sig_manage *b, const char *str, void *sig);
extern void
sig_manage_disconnect_port(struct sig_manage *b, const char *str);

extern void
sig_manage_connect(struct sig_manage *b, void *s,
		const struct sig_manage_funcs *f);

extern struct sig_manage *
sig_manage_create(const char *name);
extern void
sig_manage_destroy(struct sig_manage *sig);

extern void
sig_manage_suspend(struct sig_manage *b, FILE *fSig);
extern void
sig_manage_resume(struct sig_manage *b, FILE *fSig);

#endif /* __SIG_MANAGE_H_INCLUDED */
