dnl Copyright (C) 1988 Eleftherios Gkioulekas <lf@amath.washington.edu>
dnl  
dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2 of the License, or
dnl (at your option) any later version.
dnl 
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl 
dnl You should have received a copy of the GNU General Public License
dnl along with this program; if not, write to the Free Software 
dnl Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
dnl 
dnl As a special exception to the GNU General Public License, if you 
dnl distribute this file as part of a program that contains a configuration 
dnl script generated by Autoconf, you may include it under the same 
dnl distribution terms that you use for the rest of that program.

 
#-----------------------------------------------------------------------
# This macro searches for Xlib and when it finds it it adds the 
# appropriate flags to CFLAGS and export the link sequence to 
# the variable XLIB. 
# In your configure.in file add:
#   LF_PATH_XLIB
# In your Makefile.am add
#   program_LDADD = .... $(XLIB)
#------------------------------------------------------------------------
#
# Just added EMBOSS into LF_PATH_XLIB so that on the systems where
# LF_PATH_XLIB exists there are no duplication errors.


AC_DEFUN([LF_EMBOSS_PATH_XLIB],[
  CFLAGS="$CFLAGS $X_CFLAGS"

case $host_os in
irix*)
    XLIB="-lX11 $X_EXTRA_LIBS"
    ;;
*)
    XLIB="$X_LIBS -lX11 $X_EXTRA_LIBS"
    ;;
esac

  AC_SUBST([XLIB])

AC_CHECK_HEADER(X11/Xlib.h,
[
	AC_DEFINE([PLD_xwin], [1], [Define to 1 if X11 support is available])
],
[
	echo ""
	echo "X11 graphics have been selected but no X11 header files"
        echo "have been found."
        echo ""
        echo "This error usually happens on Linux/MacOSX distributions"
	echo "where the optional X11 development files have not been installed."
        echo "On Linux RPM systems this package is usually called something"
        echo "like xorg-x11-proto-devel whereas on Debian/Ubuntu it may"
        echo "be called x-dev. On MacOSX installation DVDs the X11 files"
        echo "can usually be found as an explicitly named optional"
        echo "installation."
        echo ""
        echo "After installing the X11 development files you should do a"
        echo "'make clean' and perform the configure stage again."
        echo ""
        echo "Alternatively, to install EMBOSS without X11 support, you can add"
        echo "the --without-x switch to the configure command."
	echo ""
        exit $?
])

])

