Version 0.12 has been released six months after 0.11, bringing many new features
and bugfixes.

As usual, prebuilt binaries can be found in [get](../get).

# Breaking Changes

-   The `shared:` namespace has been removed.

-   Line continuations now use backslashes instead of backquotes, in line with
    POSIX syntax.

-   The `resolve` builtin now returns a string.

-   The variables `$edit:loc-{pinned,hidden}` have been moved into the
    `edit:location:` namespace, now `$edit:location:{pinned,hidden}`

-   The variable `$edit:arg-completer` has been moved to
    `$edit:completion:arg-completer`.

# Notable Fixes and Enhancements

-   The [Elvish package manager](../ref/epm.html) has landed (thanks to
    @zzamboni!).

-   A `str:` module has been added
    ([#576](https://github.com/elves/elvish/issues/576)).

-   Styling of the web interface (`elvish -web`) has been reworked, now
    featuring a dark theme as well as a light theme.

-   Namespaces can now be accessed by as variables with a trailing `:` in the
    name (e.g. the `edit:` namespace variable can be accessed as `$edit:`).
    These variables can be indexed like maps
    ([#492](https://github.com/elves/elvish/issues/492),
    ([#631](https://github.com/elves/elvish/issues/631))).

-   Support for urxvt-style key sequences has been improved
    ([#579](https://github.com/elves/elvish/issues/579)).

-   Numbers can now be used as normal variable names (e.g. `$1`).

-   The interactive namespace can now be built dynamically by assigning to the
    `$-exports-` variable in `rc.elv`
    ([#613](https://github.com/elves/elvish/issues/613)).

-   Closures can now be introspected
    ([#560](https://github.com/elves/elvish/issues/560),
    [#617](https://github.com/elves/elvish/issues/617)).

-   The variable for customizing matchers in completion mode has graduated from
    `$edit:-matcher` to `$edit:completion:matcher`.

-   The `joins` command no longer ignores leading empty values
    ([#616](https://github.com/elves/elvish/issues/616)).

-   The `while` special command no longer swallows exceptions
    ([#615](https://github.com/elves/elvish/issues/615)).

-   The `finally` block of the `try` special command no longer swallows
    exceptions ([#619](https://github.com/elves/elvish/issues/619)).

-   A set of builtin commands for manipulating environment variables -
    `has-env`, `get-env`, `set-env`, `unset-env` - has been added.

-   The prompts are now rendered asynchronously. The appearance of
    [stale prompts](../ref/edit.html#stale-prompt) can be customized.

-   Experimental support for customizing the
    [eagerness of prompts](https://elv.sh/ref/edit.html#prompt-eagerness).

-   Elvish now writes a `\r` to the terminal before suspending the editor
    ([#629](https://github.com/elves/elvish/issues/629); thanks to @krader1961
    for the analysis!).

-   New `edit:history:fast-forward` command to import command history after the
    current session started.

-   The completion mode no longer completes the longest common prefix
    ([#637](https://github.com/elves/elvish/issues/637)).

-   New `store:del-dir` command for deleting directory history.

-   Add chdir hooks [`$before-chdir`](../ref/builtin.html#before-chdir) and
    [`$after-chdir`](../ref/builtin.html#after-chdir).

-   Location mode now supports the notion of workspaces
    ([#643](https://github.com/elves/elvish/issues/643)).

-   The output of `elvish -buildinfo -json` is now actually valid JSON
    ([#682](https://github.com/elves/elvish/issues/682)).

-   New [`styled`](../ref/builtin.html#styled) and
    [`styled-segment`](../ref/builtin.html#styled-segment) commands (thanks to
    @fehnomenal!) ([#520](https://github.com/elves/elvish/issues/520),
    [#674](https://github.com/elves/elvish/issues/674)).

-   New builtin `$notify-bg-job-success` variable for suppressing notification
    of the success of background jobs (thanks to @iwoloschin!)
    ([#689](https://github.com/elves/elvish/issues/689)).

-   New builtin `$num-bg-jobs` variable for tracking number of background jobs
    ([#692](https://github.com/elves/elvish/issues/692)).

-   The `edit:complete-getopt` command now supports supplying a description for
    arguments of options (thanks to @zzamboni!)
    ([#693](https://github.com/elves/elvish/issues/693)).

-   Complex candidates built with `edit:complex-candidate` are now indexable
    (thanks to @zzamboni!) ([#691](https://github.com/elves/elvish/issues/691)).

-   New `-norc` flag for skipping `rc.elv` (thanks to @iwoloschin!)
    ([#707](https://github.com/elves/elvish/issues/707)).

-   Elvish now guards against commands messing up terminal attributes
    ([#706](https://github.com/elves/elvish/issues/706)).
