#!/usr/bin/zsh
#
# Michal 'GiM' Spadlinski
# Example amarok script,
# the API of dbus plugin is a subject to change
# so don't relay on it ;)

while :;
do
	read -A var
	case ${var[0]} in
		configure)
			dcop amarok playlist popupMessage "Sorry, no configuration at the moment ;)";
			;;
		engineStateChange:)
			case ${var[2]} in
				playing)
					artist=`dcop amarok player artist`
					title=`dcop amarok player title`
					#dbus-send --print-reply --dest=org.freedesktop.im /dupa/dupa org.freedesktop.im.ekg2.session.setStatus string:gg:numerek string:back string:" NP: $artist - $title "
					dbus-send --print-reply --dest=org.freedesktop.im /dupa/dupa org.freedesktop.im.setStatus string:back string:" now listening : $artist - $title "
					;;
				paused)
					artist=`dcop amarok player artist`
					title=`dcop amarok player title`
					#dbus-send --print-reply --dest=org.freedesktop.im /dupa/dupa org.freedesktop.im.ekg2.session.setStatus string:gg:numerek string:back string:" NP: $artist - $title (paused)"
					dbus-send --print-reply --dest=org.freedesktop.im /dupa/dupa org.freedesktop.im.setStatus string:back string:" now listening : $artist - $title (paused) "
					;;
				empty)
					#dbus-send --print-reply --dest=org.freedesktop.im /dupa/dupa org.freedesktop.im.ekg2.session.setStatus string:gg:numerek string:back string:" NP: muza stop"
					dbus-send --print-reply --dest=org.freedesktop.im /dupa/dupa org.freedesktop.im.setStatus string:back string:" now listening : muza nie gra stop "
					;;
			esac
			;;
	esac
done
