/*
 * Decompiled with CFR 0.152.
 */
package dumphd.core;

import bdvm.vm.BDVMException;
import bdvm.vm.BDVMInterface;
import dumphd.aacs.AACSDecrypter;
import dumphd.aacs.AACSException;
import dumphd.bdplus.BDVMLoader;
import dumphd.bdplus.ConversionTable;
import dumphd.bdplus.SubTable;
import dumphd.core.ACAException;
import dumphd.core.ACAPacker;
import dumphd.core.DiscSet;
import dumphd.core.KeyDataFile;
import dumphd.core.MultiplexedArf;
import dumphd.gui.Manager;
import dumphd.util.ByteSource;
import dumphd.util.FileSource;
import dumphd.util.MessagePrinter;
import dumphd.util.PrintStreamPrinter;
import dumphd.util.SimpleFilenameFilter;
import dumphd.util.StreamSource;
import dumphd.util.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public final class DumpHD {
    public static final String PROGRAM_NAME = "DumpHD";
    public static final String PROGRAM_VERSION = "0.61";
    public static final String PROGRAM_AUTHOR = "KenD00";
    private MessagePrinter out = null;
    private KeyDataFile keyDataFile = null;
    private AACSDecrypter aacsDec = null;
    private BDVMInterface bdvm = null;
    private ACAPacker acaPacker = null;
    private ArrayList<DiscSet> discSets = new ArrayList(6);
    private boolean streaming = false;

    public DumpHD(boolean streaming) throws Exception {
        this.out = Utils.getMessagePrinter();
        this.streaming = streaming;
        this.createDumpHD();
    }

    public DumpHD(MessagePrinter mp, boolean streaming) throws Exception {
        this.out = mp;
        this.streaming = streaming;
        this.createDumpHD();
    }

    private void createDumpHD() throws Exception {
        this.out.println("DumpHD 0.61 by KenD00");
        this.out.println();
        this.out.print("Opening Key Data File... ");
        try {
            this.keyDataFile = new KeyDataFile(new File("KEYDB.cfg"));
        }
        catch (FileNotFoundException e1) {
            this.out.println("FAILED");
            throw new Exception("Key Data File not found");
        }
        catch (IOException e2) {
            this.out.println("FAILED");
            throw new Exception("Could not open Key Data File");
        }
        this.out.println("OK");
        try {
            this.aacsDec = new AACSDecrypter(this.out, this.keyDataFile);
        }
        catch (AACSException e) {
            throw new Exception(e.getMessage());
        }
        try {
            this.out.print("Loading BDVM... ");
            BDVMLoader loader = new BDVMLoader();
            loader.loadClass(new File("bdvmdbg.jar"));
            this.bdvm = loader.newInstance();
            this.out.println("OK");
            this.out.println(this.bdvm.getVersionString());
        }
        catch (BDVMException e) {
            this.out.println("FAILED");
            this.out.println(e.getMessage());
            this.out.println("Automatic BD+ removal disabled, specify a Conversion Table manually to remove BD+ if necessary");
        }
        this.acaPacker = new ACAPacker(this.out, this.aacsDec);
        this.acaPacker.setContentChecking(true);
        this.out.println();
    }

    public void initSource(File src, ArrayList<String> inFiles, String convTable) throws IOException {
        DiscSet ds;
        File aacsDir;
        DiscSet ds2;
        File idFile;
        boolean HD_STANDARD = false;
        this.discSets.clear();
        this.out.println("Initializing source... ");
        if (!src.exists()) {
            throw new IOException(String.valueOf(src.toString()) + " does not exist");
        }
        if (!src.isDirectory()) {
            throw new IOException(String.valueOf(src.toString()) + " is not a directory");
        }
        if (inFiles != null && inFiles.isEmpty()) {
            inFiles = null;
        }
        if (convTable != null && convTable.isEmpty()) {
            convTable = null;
        }
        if ((idFile = new File(src, "HVDVD_TS" + File.separator + "HV000I01.IFO")).isFile()) {
            this.out.println("Disc type found: " + DiscSet.DISCTYPE_NAMES[1]);
            ds2 = new DiscSet(1, src);
            aacsDir = new File(src, "AACS");
            if (aacsDir.isDirectory()) {
                ds2.aacsDir = aacsDir;
            }
            this.discSets.add(ds2);
            HD_STANDARD = true;
        }
        if ((idFile = new File(src, "ADV_OBJ" + File.separator + "DISCID.DAT")).isFile()) {
            this.out.println("Disc type found: " + DiscSet.DISCTYPE_NAMES[3]);
            ds2 = new DiscSet(3, src);
            aacsDir = new File(src, "AACS");
            if (aacsDir.isDirectory()) {
                ds2.aacsDir = aacsDir;
            }
            this.discSets.add(ds2);
            if (HD_STANDARD) {
                this.discSets.remove(0);
                HD_STANDARD = false;
            }
        }
        if ((idFile = new File(src, "BDMV" + File.separator + "index.bdmv")).isFile()) {
            File aacsDir2 = new File(src, "AACS_mv");
            if (aacsDir2.isDirectory()) {
                this.out.println("Disc type found: " + DiscSet.DISCTYPE_NAMES[6]);
                ds = new DiscSet(6, src);
                ds.aacsDir = aacsDir2;
                this.discSets.add(ds);
            } else {
                this.out.println("Disc type found: " + DiscSet.DISCTYPE_NAMES[5]);
                ds = new DiscSet(5, src);
                aacsDir2 = new File(src, "AACS");
                if (aacsDir2.isDirectory()) {
                    ds.aacsDir = aacsDir2;
                }
                if (new File(src, "BDSVM").isDirectory()) {
                    ds.bdplus = true;
                }
                this.discSets.add(ds);
            }
        }
        if ((idFile = new File(src, "BDAV" + File.separator + "info.bdav")).isFile()) {
            this.out.println("Disc type found: " + DiscSet.DISCTYPE_NAMES[7]);
            ds2 = new DiscSet(7, src);
            aacsDir = new File(src, "AACS" + File.separator + "AACS_av");
            if (aacsDir.isDirectory()) {
                ds2.aacsDir = aacsDir;
            }
            this.discSets.add(ds2);
        }
        if (this.discSets.size() > 0) {
            if (inFiles == null) {
                this.out.println("Collecting input files...");
            } else {
                this.out.println("Processing input files...");
            }
        } else {
            this.out.println("No disc type found");
            return;
        }
        if (inFiles == null) {
            ArrayList<String> streamSet = null;
            block8: for (DiscSet ds3 : this.discSets) {
                switch (ds3.contentType) {
                    case 1: {
                        streamSet = new ArrayList<String>(8192);
                        if (this.streaming) {
                            Utils.scanForFilenames(new File(ds3.srcDir, "HVDVD_TS"), "HVDVD_TS", streamSet, true, new SimpleFilenameFilter(".*\\.EVO", true, false), true);
                        } else {
                            Utils.scanForFilenames(new File(ds3.srcDir, "HVDVD_TS"), "HVDVD_TS", streamSet, true, null, true);
                        }
                        Collections.sort(streamSet);
                        ds3.streamSets.put(0, streamSet);
                        break;
                    }
                    case 3: {
                        streamSet = new ArrayList(8192);
                        if (this.streaming) {
                            Utils.scanForFilenames(new File(ds3.srcDir, "HVDVD_TS"), "HVDVD_TS", streamSet, true, new SimpleFilenameFilter(".*\\.EVO", true, false), true);
                        } else {
                            Utils.scanForFilenames(new File(ds3.srcDir, "HVDVD_TS"), "HVDVD_TS", streamSet, true, null, true);
                            Utils.scanForFilenames(new File(ds3.srcDir, "ADV_OBJ"), "ADV_OBJ", ds3.fileSet, true, null, true);
                        }
                        Collections.sort(streamSet);
                        ds3.streamSets.put(0, streamSet);
                        Collections.sort(ds3.fileSet);
                        break;
                    }
                    case 5: 
                    case 6: {
                        streamSet = new ArrayList(8192);
                        if (this.streaming) {
                            Utils.scanForFilenames(new File(ds3.srcDir, "BDMV"), "BDMV", streamSet, true, new SimpleFilenameFilter(".*\\.M2TS", true, false), true);
                        } else {
                            Utils.scanForFilenames(new File(ds3.srcDir, "BDMV"), "BDMV", streamSet, true, null, true);
                            Utils.scanForFilenames(new File(ds3.srcDir, "CERTIFICATE"), "CERTIFICATE", ds3.fileSet, true, null, true);
                        }
                        Collections.sort(streamSet);
                        ds3.streamSets.put(0, streamSet);
                        Collections.sort(ds3.fileSet);
                        break;
                    }
                    case 7: {
                        int currentStreamSet = 0;
                        String checkString = "BDAV";
                        File checkDir = new File(ds3.srcDir, checkString);
                        while (checkDir.isDirectory()) {
                            streamSet = new ArrayList(8192);
                            if (this.streaming) {
                                Utils.scanForFilenames(checkDir, checkString, streamSet, true, new SimpleFilenameFilter(".*\\.M2TS", true, false), true);
                            } else {
                                Utils.scanForFilenames(checkDir, checkString, streamSet, true, null, true);
                            }
                            Collections.sort(streamSet);
                            ds3.streamSets.put(currentStreamSet, streamSet);
                            checkString = String.format("BDAV%1$d", ++currentStreamSet);
                            checkDir = new File(ds3.srcDir, checkString);
                        }
                        continue block8;
                    }
                }
            }
        } else if (this.discSets.size() > 0) {
            DiscSet currentDs = this.discSets.get(0);
            Iterator<String> fileIt = inFiles.iterator();
            ArrayList<String> fileSet = null;
            int fileSetNumber = 0;
            while (fileIt.hasNext()) {
                String inFile = fileIt.next();
                String upperInFile = inFile.toUpperCase();
                if (upperInFile.startsWith("HVDVD_TS")) {
                    if (!this.streaming || upperInFile.endsWith(".EVO")) {
                        if (currentDs.contentType != 1 && currentDs.contentType != 3) {
                            DiscSet tmp = this.getFirstDiscSet(3);
                            if (tmp != null) {
                                currentDs = tmp;
                                fileSet = null;
                            } else {
                                this.out.println("Disc does not contain the required content type, ignoring: " + inFile);
                                continue;
                            }
                        }
                        if (fileSet == null) {
                            fileSet = this.getStreamSet(currentDs, 0);
                        }
                        fileSet.add(inFile);
                        continue;
                    }
                    this.out.println("Ignored because of streaming: " + inFile);
                    continue;
                }
                if (upperInFile.startsWith("ADV_OBJ")) {
                    if (!this.streaming) {
                        if (currentDs.contentType != 3) {
                            DiscSet tmp = this.getFirstDiscSet(3);
                            if (tmp != null) {
                                currentDs = tmp;
                                fileSet = null;
                            } else {
                                this.out.println("Disc does not contain the required content type, ignoring: " + inFile);
                                continue;
                            }
                        }
                        currentDs.fileSet.add(inFile);
                        continue;
                    }
                    this.out.println("Ignored because of streaming: " + inFile);
                    continue;
                }
                if (upperInFile.startsWith("BDMV")) {
                    if (!this.streaming || upperInFile.endsWith(".M2TS")) {
                        if (currentDs.contentType != 5 && currentDs.contentType != 6) {
                            DiscSet tmp = this.getFirstDiscSet(7);
                            if (tmp != null) {
                                currentDs = tmp;
                                fileSet = null;
                            } else {
                                this.out.println("Disc does not contain the required content type, ignoring: " + inFile);
                                continue;
                            }
                        }
                        if (fileSet == null) {
                            fileSet = this.getStreamSet(currentDs, 0);
                        }
                        fileSet.add(inFile);
                        continue;
                    }
                    this.out.println("Ignored because of streaming: " + inFile);
                    continue;
                }
                if (upperInFile.startsWith("BDAV")) {
                    if (!this.streaming || upperInFile.endsWith(".M2TS")) {
                        block78: {
                            if (currentDs.contentType != 7) {
                                DiscSet tmp = this.getFirstDiscSet(7);
                                if (tmp != null) {
                                    currentDs = tmp;
                                    fileSet = null;
                                } else {
                                    this.out.println("Disc does not contain the required content type, ignoring: " + inFile);
                                    continue;
                                }
                            }
                            if (upperInFile.length() > 4) {
                                try {
                                    int tmp = Integer.parseInt(inFile.substring(4, 5));
                                    if (tmp > 0 && tmp < 5) {
                                        fileSetNumber = tmp;
                                        break block78;
                                    }
                                    this.out.println("Invalid BDAV Aux Directory number, ignoring: " + inFile);
                                    continue;
                                }
                                catch (NumberFormatException tmp) {
                                    break block78;
                                }
                            }
                            if (fileSetNumber != 0) {
                                fileSetNumber = 0;
                            }
                        }
                        if (fileSet == null) {
                            fileSet = this.getStreamSet(currentDs, fileSetNumber);
                        }
                        fileSet.add(inFile);
                        continue;
                    }
                    this.out.println("Ignored because of streaming: " + inFile);
                    continue;
                }
                if (upperInFile.startsWith("CERTIFICATE")) {
                    if (!this.streaming) {
                        if (currentDs.contentType != 5 && currentDs.contentType != 6) {
                            DiscSet tmp = this.getFirstDiscSet(7);
                            if (tmp != null) {
                                currentDs = tmp;
                                fileSet = null;
                            } else {
                                this.out.println("Disc does not contain the required content type, ignoring: " + inFile);
                                continue;
                            }
                        }
                        currentDs.fileSet.add(inFile);
                        continue;
                    }
                    this.out.println("Ignored because of streaming: " + inFile);
                    continue;
                }
                this.out.println("Unknown file type, ignoring: " + inFile);
            }
        }
        if (convTable != null) {
            File convTableFile = new File(convTable).getAbsoluteFile();
            ds = this.getFirstDiscSet(5);
            if (ds != null) {
                if (ds.bdplus) {
                    FileSource convTableSrc = new FileSource(convTableFile, 0);
                    ds.convTable = new ConversionTable(convTableSrc);
                } else {
                    this.out.println("Disc is not BD+ protected, ignoring Conversion Table: " + convTableFile);
                }
            } else {
                this.out.println("Disc does not contain the required content type, ignoring Conversion Table: " + convTableFile);
            }
        }
        this.out.println("Source initialized");
    }

    public Collection<DiscSet> identifySource() {
        for (DiscSet ds : this.discSets) {
            try {
                this.aacsDec.identifyDisc(ds);
            }
            catch (AACSException e) {
                this.out.println(e.getMessage());
            }
        }
        return Collections.unmodifiableList(this.discSets);
    }

    /*
     * Loose catch block
     */
    public void dumpSource() {
        ByteSource inSource = null;
        ByteSource outSource = null;
        HashSet<File> knownDirectories = new HashSet<File>(64);
        if (this.streaming) {
            outSource = new StreamSource(System.out, 1, false);
        }
        for (DiscSet ds : this.discSets) {
            block144: {
                if (!ds.selected) {
                    this.out.println("Skipping disc set:");
                    this.out.println(ds.toString());
                    continue;
                }
                this.out.println("Processing disc set:");
                this.out.println(ds.toString());
                if (!this.streaming) {
                    if (ds.dstDir == null) {
                        this.out.println("No destination set, skipping disc set");
                        continue;
                    }
                    if (ds.dstDir.exists() && !ds.dstDir.isDirectory()) {
                        this.out.println("Destination is not a directory, skipping disc set");
                        continue;
                    }
                    if (ds.srcDir.equals(ds.dstDir)) {
                        this.out.println("Source and destination are the same, skipping disc set");
                        continue;
                    }
                }
                boolean aacsInitialized = false;
                try {
                    this.aacsDec.initDisc(ds);
                    this.aacsDec.init(ds);
                    aacsInitialized = true;
                }
                catch (AACSException e) {
                    this.out.println("Error initializing AACS, skipping disc set");
                    this.out.println(e.getMessage());
                }
                if (!aacsInitialized) continue;
                if (ds.bdplus) {
                    if (ds.convTable == null && this.bdvm != null) {
                        try {
                            this.out.print("Initializing the BDVM... ");
                            this.bdvm.initVM(ds.srcDir, ds.keyData.getVid());
                            this.out.println("OK");
                            this.out.print("Executing the BDVM... ");
                            this.bdvm.run();
                            this.out.println("OK");
                            byte[] rawTable = this.bdvm.getRAWConversionTable();
                            if (rawTable != null) {
                                try {
                                    this.out.print("Parsing the Conversion Table... ");
                                    ConversionTable convTable = new ConversionTable();
                                    convTable.parse(rawTable, 0);
                                    this.out.println("OK");
                                    ds.convTable = convTable;
                                }
                                catch (IndexOutOfBoundsException e) {
                                    this.out.println("FAILED");
                                    this.out.println("Error! Parsing the Conversion Table failed, dumping may fail!");
                                }
                                break block144;
                            }
                            this.out.println("Error! The BDVM has not produced a Conversion Table, dumping may fail!");
                        }
                        catch (BDVMException e) {
                            this.out.println("ERROR");
                            this.out.println(e.getMessage());
                            this.out.println("Error! Failed to execute the BDVM, dumping may fail!");
                        }
                    } else {
                        this.out.println("Error! BD+ detected and no Conversion Table present, dumping may fail!");
                    }
                }
            }
            File inFile = null;
            File outFile = null;
            String filename2222 = null;
            for (Map.Entry<Integer, ArrayList<String>> currentEntry : ds.streamSets.entrySet()) {
                int currentSet = currentEntry.getKey();
                for (String filename2222 : currentEntry.getValue()) {
                    block145: {
                        this.out.println("Processing: " + filename2222);
                        inFile = new File(ds.srcDir, filename2222);
                        if (this.streaming) break block145;
                        outFile = new File(ds.dstDir, filename2222);
                        File outDir = outFile.getParentFile();
                        if (knownDirectories.add(outDir) && !outDir.exists()) {
                            try {
                                if (!outDir.mkdirs()) {
                                    throw new IOException("Failed creating destination directory: " + outDir);
                                }
                            }
                            catch (SecurityException e) {
                                throw new IOException("Insufficient rights to create destination directory: " + outDir);
                            }
                        }
                        if (!outFile.exists()) break block145;
                        this.out.println("Destination file already exists, skipping file");
                        try {
                            if (inSource != null) {
                                inSource.close();
                            }
                        }
                        catch (IOException e) {
                            this.out.println("Error closing input file: " + e.getMessage());
                        }
                        inSource = null;
                        if (this.streaming) continue;
                        try {
                            if (outSource != null) {
                                outSource.close();
                            }
                        }
                        catch (IOException e) {
                            this.out.println("Error closing output file: " + e.getMessage());
                        }
                        outSource = null;
                        continue;
                    }
                    try {
                        inSource = new FileSource(inFile, 0);
                        if (!this.streaming) {
                            outSource = new FileSource(outFile, 2);
                        }
                        switch (ds.contentType) {
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: {
                                if (filename2222.toUpperCase().endsWith(".EVO")) {
                                    Collection<MultiplexedArf> arfs = this.aacsDec.decryptEvob(inSource, outSource);
                                    if (this.streaming || arfs.size() <= 0) break;
                                    this.out.println("Processing multiplexed ARFs...");
                                    for (MultiplexedArf arf : arfs) {
                                        ByteSource inArf = arf.getReader();
                                        ByteSource outArf = arf.getWriter();
                                        this.out.println(inArf.getFile().getName());
                                        if (inArf.getFile().getName().toUpperCase().endsWith(".ACA")) {
                                            try {
                                                this.acaPacker.rePack(inArf, outArf);
                                            }
                                            catch (ACAException acae) {
                                                this.out.println("ACA-Exception: " + acae.getMessage());
                                                this.out.println("Skipping ARF");
                                            }
                                        } else {
                                            try {
                                                this.aacsDec.decryptArf(inArf, outArf);
                                            }
                                            catch (AACSException aacse) {
                                                this.out.println("AACS-Exception: " + aacse.getMessage());
                                                this.out.println("Skipping ARF");
                                            }
                                        }
                                        arf.close();
                                    }
                                    this.out.println("Multiplexed ARFs processed");
                                    break;
                                }
                                if (!this.streaming) {
                                    Utils.copyBs(inSource, outSource, inSource.size());
                                }
                                break;
                            }
                            case 5: {
                                if (filename2222.toUpperCase().endsWith(".M2TS")) {
                                    int clipNr = Utils.getClipNumber(inFile.getName());
                                    if (clipNr < 0) {
                                        this.out.println("Error parsing filename, assuming clip number 0");
                                        clipNr = 0;
                                    }
                                    SubTable subTable = null;
                                    if (ds.bdplus) {
                                        if (ds.convTable != null) {
                                            subTable = ds.convTable.getSubTable(clipNr);
                                        }
                                        if (subTable == null) {
                                            this.out.println("Error! BD+ SubTable not found, dumping may fail");
                                        }
                                    }
                                    this.aacsDec.decryptTs(inSource, outSource, null, subTable);
                                    break;
                                }
                                if (!this.streaming) {
                                    Utils.copyBs(inSource, outSource, inSource.size());
                                }
                                break;
                            }
                            case 6: 
                            case 7: {
                                String plainFilename = inFile.getName();
                                int keyIndex = 0;
                                if (filename2222.toUpperCase().endsWith(".M2TS")) {
                                    int clipNr = Utils.getClipNumber(plainFilename);
                                    if (clipNr < 0) {
                                        this.out.println("Error parsing filename, assuming clip number 0");
                                        clipNr = 0;
                                    }
                                    if ((keyIndex = ds.keyData.getTcUnit(currentSet, clipNr)) != 0) {
                                        this.aacsDec.decryptTs(inSource, outSource, ds.keyData.getTuk(keyIndex), null);
                                        break;
                                    }
                                    this.aacsDec.decryptTs(inSource, outSource, null, null);
                                    break;
                                }
                                if (!this.streaming) {
                                    if (ds.contentType == 7) {
                                        boolean isTdf = false;
                                        if (plainFilename.equals("menu.tdt1")) {
                                            isTdf = true;
                                            keyIndex = ds.keyData.getHeadUnit(currentSet, 0);
                                        } else if (plainFilename.equals("mark.tdt1")) {
                                            isTdf = true;
                                            keyIndex = ds.keyData.getHeadUnit(currentSet, 1);
                                        }
                                        if (isTdf) {
                                            if (keyIndex != 0) {
                                                this.aacsDec.decryptTdf(inSource, outSource, ds.keyData.getTuk(keyIndex));
                                                break;
                                            }
                                            this.out.println("Error! CPS Unit Key index for Thumbnail Data file not found, copying file");
                                            Utils.copyBs(inSource, outSource, inSource.size());
                                            break;
                                        }
                                        Utils.copyBs(inSource, outSource, inSource.size());
                                        break;
                                    }
                                    Utils.copyBs(inSource, outSource, inSource.size());
                                }
                                break;
                            }
                            default: {
                                this.out.println("Error! Unknown disc type: " + ds.contentType + ", skipping file");
                                break;
                            }
                        }
                    }
                    catch (IOException ei) {
                        this.out.println("I/O-Exception: " + ei.getMessage());
                        this.out.println("Skipping file");
                        try {
                            if (inSource != null) {
                                inSource.close();
                            }
                        }
                        catch (IOException e) {
                            this.out.println("Error closing input file: " + e.getMessage());
                        }
                        inSource = null;
                        if (this.streaming) continue;
                        try {
                            if (outSource != null) {
                                outSource.close();
                            }
                        }
                        catch (IOException e) {
                            this.out.println("Error closing output file: " + e.getMessage());
                        }
                        outSource = null;
                        continue;
                    }
                    catch (AACSException ea) {
                        try {
                            this.out.println("AACS-Exception: " + ea.getMessage());
                            this.out.println("Skipping file");
                            continue;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            try {
                                if (inSource != null) {
                                    inSource.close();
                                }
                            }
                            catch (IOException e) {
                                this.out.println("Error closing input file: " + e.getMessage());
                            }
                            inSource = null;
                            if (!this.streaming) {
                                try {
                                    if (outSource != null) {
                                        outSource.close();
                                    }
                                }
                                catch (IOException e) {
                                    this.out.println("Error closing output file: " + e.getMessage());
                                }
                                outSource = null;
                            }
                        }
                    }
                    try {
                        if (inSource != null) {
                            inSource.close();
                        }
                    }
                    catch (IOException e) {
                        this.out.println("Error closing input file: " + e.getMessage());
                    }
                    inSource = null;
                    if (this.streaming) continue;
                    try {
                        if (outSource != null) {
                            outSource.close();
                        }
                    }
                    catch (IOException e) {
                        this.out.println("Error closing output file: " + e.getMessage());
                    }
                    outSource = null;
                }
            }
            if (this.streaming) continue;
            for (String filename2222 : ds.fileSet) {
                block147: {
                    this.out.println("Processing: " + filename2222);
                    inFile = new File(ds.srcDir, filename2222);
                    outFile = new File(ds.dstDir, filename2222);
                    File outDir = outFile.getParentFile();
                    if (knownDirectories.add(outDir) && !outDir.exists()) {
                        try {
                            if (!outDir.mkdirs()) {
                                throw new IOException("Failed creating destination directory: " + outDir);
                            }
                        }
                        catch (SecurityException e) {
                            throw new IOException("Insufficient rights to create destination directory: " + outDir);
                        }
                    }
                    if (!outFile.exists()) break block147;
                    this.out.println("Destination file already exists, skipping file");
                    try {
                        if (inSource != null) {
                            inSource.close();
                        }
                    }
                    catch (IOException e) {
                        this.out.println("Error closing input file: " + e.getMessage());
                    }
                    inSource = null;
                    try {
                        if (outSource != null) {
                            outSource.close();
                        }
                    }
                    catch (IOException e) {
                        this.out.println("Error closing output file: " + e.getMessage());
                    }
                    outSource = null;
                    continue;
                }
                try {
                    inSource = new FileSource(inFile, 0);
                    outSource = new FileSource(outFile, 2);
                    switch (ds.contentType) {
                        case 3: 
                        case 4: {
                            if (filename2222.toUpperCase().endsWith(".ACA")) {
                                this.acaPacker.rePack(inSource, outSource);
                                break;
                            }
                            this.aacsDec.decryptArf(inSource, outSource);
                            break;
                        }
                        default: {
                            Utils.copyBs(inSource, outSource, inSource.size());
                            break;
                        }
                    }
                }
                catch (IOException ei) {
                    this.out.println("I/O-Exception: " + ei.getMessage());
                    this.out.println("Skipping file");
                    try {
                        if (inSource != null) {
                            inSource.close();
                        }
                    }
                    catch (IOException e) {
                        this.out.println("Error closing input file: " + e.getMessage());
                    }
                    inSource = null;
                    try {
                        if (outSource != null) {
                            outSource.close();
                        }
                    }
                    catch (IOException e) {
                        this.out.println("Error closing output file: " + e.getMessage());
                    }
                    outSource = null;
                    continue;
                }
                catch (ACAException ea) {
                    this.out.println("ACA-Exception: " + ea.getMessage());
                    this.out.println("Skipping file");
                    continue;
                }
                catch (AACSException eaa) {
                    this.out.println("AACS-Exception: " + eaa.getMessage());
                    this.out.println("Skipping file");
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    try {
                        if (inSource != null) {
                            inSource.close();
                        }
                    }
                    catch (IOException e) {
                        this.out.println("Error closing input file: " + e.getMessage());
                    }
                    inSource = null;
                    try {
                        if (outSource != null) {
                            outSource.close();
                        }
                    }
                    catch (IOException e) {
                        this.out.println("Error closing output file: " + e.getMessage());
                    }
                    outSource = null;
                    continue;
                }
                {
                    finally {
                        try {
                            if (inSource != null) {
                                inSource.close();
                            }
                        }
                        catch (IOException e) {
                            this.out.println("Error closing input file: " + e.getMessage());
                        }
                        inSource = null;
                        try {
                            if (outSource != null) {
                                outSource.close();
                            }
                        }
                        catch (IOException e) {
                            this.out.println("Error closing output file: " + e.getMessage());
                        }
                        outSource = null;
                    }
                }
                try {
                    if (inSource != null) {
                        inSource.close();
                    }
                }
                catch (IOException e) {
                    this.out.println("Error closing input file: " + e.getMessage());
                }
                inSource = null;
                try {
                    if (outSource != null) {
                        outSource.close();
                    }
                }
                catch (IOException e) {
                    this.out.println("Error closing output file: " + e.getMessage());
                }
                outSource = null;
            }
            this.out.println("Disc set processed");
        }
    }

    public boolean dump(String srcStr, String dstStr, ArrayList<String> inFiles, String convTable) {
        File src = new File(srcStr).getAbsoluteFile();
        File dst = null;
        if (!this.streaming) {
            dst = new File(dstStr).getAbsoluteFile();
        }
        this.out.println("Start time: " + new Date());
        this.out.println();
        this.out.println("Checking source...");
        this.out.println("Source path: " + src.getPath());
        try {
            this.initSource(src, inFiles, convTable);
            if (this.discSets.size() == 0) {
                this.endMsg("Aborting");
                return false;
            }
        }
        catch (IOException e) {
            this.endMsg(e.getMessage());
            return false;
        }
        this.out.println("Identifying source...");
        this.identifySource();
        this.out.println("Finished identifying source");
        if (!this.streaming) {
            this.out.println("Checking destination...");
            this.out.println("Destination path: " + dst.getPath());
            if (!dst.exists() || dst.isDirectory()) {
                for (DiscSet ds : this.discSets) {
                    ds.dstDir = dst;
                }
            } else {
                this.endMsg("Destination is not a directory, aborting");
                return false;
            }
        }
        this.out.println("Dumping source...");
        this.dumpSource();
        this.endMsg("Dump complete");
        return true;
    }

    public void close() {
        try {
            this.keyDataFile.close();
        }
        catch (IOException e) {
            this.out.println("Error closing Key Data File: " + e.getMessage());
        }
        this.keyDataFile = null;
    }

    public KeyDataFile getKeyDataFile() {
        return this.keyDataFile;
    }

    private void endMsg(String reason) {
        this.out.println(reason);
        this.out.println();
        this.out.println("End time: " + new Date());
        this.out.println();
    }

    private DiscSet getFirstDiscSet(int type) {
        for (DiscSet ds : this.discSets) {
            if ((ds.contentType & type) == 0) continue;
            return ds;
        }
        return null;
    }

    private ArrayList<String> getStreamSet(DiscSet ds, int number) {
        if (!ds.streamSets.containsKey(number)) {
            ArrayList<String> streamSet = new ArrayList<String>(64);
            ds.streamSets.put(number, streamSet);
            return streamSet;
        }
        return ds.streamSets.get(number);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            new Manager();
        } else {
            boolean streaming = false;
            ArrayList<String> inFiles = new ArrayList<String>(64);
            String convTable = null;
            String input = null;
            String output = null;
            int currentArg = 0;
            String option = null;
            while (currentArg < args.length) {
                if (args[currentArg].startsWith("--")) {
                    option = args[currentArg].substring(2);
                    if (option.startsWith("infile:")) {
                        String tmp = option.substring(7);
                        if (!tmp.isEmpty()) {
                            inFiles.add(tmp);
                        } else {
                            System.out.println("No file given for infile");
                            System.exit(1);
                        }
                    } else if (option.startsWith("convtable:")) {
                        convTable = option.substring(10);
                        if (convTable.isEmpty()) {
                            System.out.println("No file given for convtable");
                            System.exit(1);
                        }
                    } else {
                        System.out.println(String.format("Unknown long option: \"%1$s\"", option));
                        System.exit(1);
                    }
                } else {
                    if (!args[currentArg].startsWith("-")) break;
                    option = args[currentArg].substring(1);
                    if (option.equals("h")) {
                        System.out.println("DumpHD 0.61 by KenD00");
                        System.out.println();
                        System.out.println("Usage : DumpHD [options] source [destination]");
                        System.out.println();
                        System.out.println("Options:");
                        System.out.println("-h                 : This help screen");
                        System.out.println("--convtable:<file> : Use this Conversion Table to remove BD+");
                        System.out.println("--infile:<file>    : Only process the specified file. It must be given");
                        System.out.println("                     relative to source. This parameter can be specified");
                        System.out.println("                     multiple times, the files will be processed in the");
                        System.out.println("                     given order.");
                        System.out.println();
                        System.out.println("source             : Source to dump, must be the root directory of the disc");
                        System.out.println("destination        : directory where the dump is written");
                        System.out.println("                     If destination is omitted streaming mode is used.");
                        System.out.println("                     In streaming mode only EVO / M2TS files are processed,");
                        System.out.println("                     they are decrypted to stdout (EVOs without decrypting");
                        System.out.println("                     ADV_PCKs) in alphabetical order.");
                        System.out.println("                     Pipe the output to another program which can read from");
                        System.out.println("                     stdin.");
                        System.out.println("                     Textual output is written to stderr.");
                        System.out.println();
                        System.out.println("If started without arguments, the GUI is loaded");
                        System.exit(0);
                    } else {
                        System.out.println(String.format("Unknown option: \"%1$s\"", option));
                        System.exit(1);
                    }
                }
                ++currentArg;
            }
            if (currentArg < args.length) {
                input = args[currentArg++];
            } else {
                System.out.println("No source specified");
                System.exit(1);
            }
            if (currentArg < args.length) {
                output = args[currentArg++];
            } else {
                streaming = true;
            }
            if (currentArg < args.length) {
                System.out.println(String.format("Invalid parameter: \"%1$s\"", args[currentArg]));
                System.exit(1);
            }
            try {
                DumpHD dumpHD = null;
                if (!streaming) {
                    dumpHD = new DumpHD(false);
                } else {
                    PrintStreamPrinter errPrinter = new PrintStreamPrinter(System.err);
                    Utils.setMessagePrinter(errPrinter);
                    dumpHD = new DumpHD(errPrinter, true);
                }
                dumpHD.dump(input, output, inFiles, convTable);
                dumpHD.close();
            }
            catch (Exception e) {
                Utils.getMessagePrinter().println(e.getMessage());
                System.exit(2);
            }
        }
    }
}

