ad_page_contract {
    Upload and imports an IMS Content Package file
    Initial form data

    @author Ernie Ghiglione (ErnieG@mm.st)
    @creation-date 19 March 2003
    @cvs-id $Id: course-add.tcl,v 1.5 2009/07/10 15:59:52 emmar Exp $

} {
    man_id:optional
}

set user_id [ad_conn user_id]
set community_id [lors::get_community_id]

if { ![info exists man_id] } {
   set man_id ""
}

# Gets file-storage root folder_id
# eventually, we should provide an option so it can be imported in
# different subfolders
ns_log Notice "EMAR: package_id for the group ([lors::get_community_id]) is [lors::get_community_package_id]. FYI node_id is [ad_conn node_id]"
set fs_package_id [site_node_apm_integration::get_child_package_id \
               -package_id [lors::get_community_package_id] \
               -package_key "file-storage"]

#set fs_package_id [apm_package_id_from_key "file-storage"] -- if used
# with OpenACS

# Gets root folder and root folder name
set folder_id [fs::get_root_folder -package_id $fs_package_id]
set folder_name [fs::get_object_name -object_id $folder_id]

# Gets whether the file-storage instance is a indb_p or file system
# (StoreFilesInDatabaseP) one not that we use it now -since we are
# currently putting everything on the file system, but eventually we
# will have the option to put it on the db.

set indb_p [parameter::get \
                -parameter "StoreFilesInDatabaseP" \
                -package_id $fs_package_id]

# Gets URL for file-storage package

set fs_url [apm_package_url_from_id $fs_package_id]

set user_id [ad_conn user_id]
set package_id [ad_conn package_id]

# set course id
set course_id 1

# set context
set context [list "[_ lorsm.lt_Upload_IMS_Content_Pa]"]

template::form create course_upload \
    -action course-add-2 \
    -html {enctype multipart/form-data}

template::element create course_upload course_id \
    -label "[_ lorsm.course_id]" \
    -datatype integer \
    -widget hidden

template::element create course_upload indb_p \
    -label "[_ lorsm.indb_p]" \
    -datatype integer \
    -widget hidden

template::element create course_upload fs_package_id \
    -label "[_ lorsm.fs_package_id]" \
    -datatype integer \
    -widget hidden

template::element create course_upload folder_id \
    -label "[_ lorsm.folder_id]" \
    -datatype integer \
    -widget hidden

template::element create course_upload upload_file \
    -label "[_ lorsm.lt_Choose_the_course_zip]" \
    -help_text "[_ lorsm.lt_Use_the_Browse_button]" \
    -datatype text \
    -widget file

# To support course versions
template::element create course_upload man_id \
    -datatype integer \
    -widget hidden

ns_log notice "EMAR: lorsm/www/admin/course-add set folder_id($folder_id), indb_p($indb_p), fs_package_id($fs_package_id)"

template::element set_properties course_upload course_id -value $course_id
template::element set_properties course_upload folder_id -value $folder_id
template::element set_properties course_upload indb_p -value $indb_p
template::element set_properties course_upload fs_package_id -value $fs_package_id
template::element set_properties course_upload man_id -value $man_id

ad_return_template


