/*
 *   This file is part of Dianara
 *   Copyright 2012-2014  JanKusanagi <janjabber@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#ifndef CONTACTLIST_H
#define CONTACTLIST_H

#include <QWidget>
#include <QLabel>
#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QVariantList>
#include <QMap>
#include <QString>
#include <QPushButton>
#include <QLineEdit>
#include <QTabWidget>
#include <QScrollArea>
#include <QMenu>
#include <QFileDialog>

#include <QDebug>

#include "pumpcontroller.h"
#include "contactcard.h"
#include "listsmanager.h"


class ContactList : public QWidget
{
    Q_OBJECT

public:
    ContactList(PumpController *pumpController, QWidget *parent = 0);
    ~ContactList();

    void clearFollowingListContents();
    void clearFollowersListContents();

    void setTabLabels();

    void exportContactsToFile(QString listType);

signals:

public slots:
    void setContactListContents(QString listType,
                                QVariantList contactList,
                                int totalReceivedCount);
    void setListsListContents(QVariantList listsList);

    void refreshFollowing();
    void refreshFollowers();

    void exportFollowing();
    void exportFollowers();

    void refreshLists();

    void followContact();

private:
    QVBoxLayout *mainLayout;

    QHBoxLayout *topLayout;
    QLabel *enterAddressLabel;
    QLineEdit *addressLineEdit;
    QPushButton *followButton;

    QTabWidget *tabWidget;

    QWidget *followingWidget;
    QVBoxLayout *followingLayout;
    QScrollArea *followingScrollArea;
    int followingCount;
    QString followingListString;


    QWidget *followersWidget;
    QVBoxLayout *followersLayout;
    QScrollArea *followersScrollArea;
    int followersCount;
    QString followersListString;


    ListsManager *listsManager;
    QScrollArea *listsScrollArea;
    int listsCount;


    QPushButton *optionsButton;
    QMenu *optionsMenu;

    PumpController *pController;
};

#endif // CONTACTLIST_H
