package DhMakeELPA::Config;

use strict;
use warnings;

our $VERSION = '0.1.0';

use base 'DhMakePerl::Config';

use Getopt::Long;

=head1 NAME

DhMakeELPA::Config - dh-make-elpa configuration class

=cut

my @OPTIONS = ( 'pkg-emacsen!', 'version=s' );

my @COMMANDS = ( 'make' );

# black magic from dh-make-perl:
__PACKAGE__->mk_accessors(
    do {
        my @opts = ( @OPTIONS, @COMMANDS );
        for (@opts) {
            s/[=:!|].*//;
            s/-/_/g;
        }
        @opts;
    },
    'command',
    '_explicitly_set',
);

use constant DEFAULTS => {
                          dh            => 10,
                          data_dir      => '/usr/share/dh-make-elpa',
                          home_dir      => "$ENV{HOME}/.dh-make-elpa",
                          source_format => '3.0 (quilt)',
                         };

# most of this function is from dh-make-perl
sub parse_command_line_options {
    my $self = shift;

    Getopt::Long::Configure( qw( pass_through no_auto_abbrev no_ignore_case ) );
    my %opts;
    GetOptions( \%opts, @OPTIONS )
      or die "Error parsing command-line options\n";

    while ( my ( $k, $v ) = each %opts ) {
        my $field = $k;
        $field =~ s/-/_/g;
        $self->$field( $opts{$k} );
        $self->_explicitly_set->{$k} = 1;
    }

    # TODO
    $self->command("make");
}

1;
