## SKK の誕生秘話

以下は、「bit」（1991年，4月号）に掲載された佐藤雅彦氏の記事「かな漢字変換システム SKK」よりの引用です（強調、改行などは、読み易さのため後で付加したものです）。

文中において「筆者」とは、SKK　の原作者、佐藤雅彦氏（京都大学名誉教授）を指します。

なお、引用については佐藤先生のご承諾を得ています。

> 筆者が **Nemacs の上で動く自分用のかな漢字変換プログラムをつくろう** と思いたった直接のきっかけは, 1987 年の 9 月から約 2 ヶ月フランスに出張することになったことである. フランスでの日本語環境をどうするかという問題が発生したのである. 当時の Unix 上の日本語環境がどうなっていたかというと, 電総研の半田剣一氏が中心になり GNU Emacs を日本語化した Nemacs はすでに使えるようになっていたが, その上での日本語入力環境を提供する **「たまご (EGG)」** はまだ配布されていなかった. (実際, たまごは SKK より数ヶ月遅れて JUNET で配布されるようになった.) したがって, 当時 Nemacs を用いて日本語入力を行うためには, かな漢字変換のためのフロントエンドプロセッサが必要であった.
>
> 筆者も, Nemacs で日本語入力を行うときは, Unix ワークステーションに PC からログインして, PC のかな漢字変換機能を用いて日本語入力を行っていた. 一方日本語の表示に関しては X ウィンドウのもとで kterm が利用できたので, Unix ワークステーションのモニターで問題なく表示できた. ということで, ラップトップ PC を持参すれば, フランスでも Unix ワークステーションの上で日本語環境をつくることができたのであるが, 当時のラップトップ PC はまだかなり重量があったのでこの考えはすてることにした. それに, PC のフロントエンドを必要とするということは, Unix の中で閉じた環境にならないので日本における環境としても不満であった.
>
> それでは, **Emacs Lisp でかな漢字変換プログラムをかけばよいのではないか** と考えた. これが可能ではないかと思うようになった原因のひとつは, その少し前に NTT の竹内郁雄氏が中心になって設計, 開発した **かな漢字変換システム Kanzen** を竹内氏の実演によりみたことがある. Kanzen はひとことでいうと漢字の開始点をローマ字入力を大文字にすることにより指定し, 文法的な解析は 1 文節だけ行うというかな漢字変換法である. こうして Kanzen の影響を受けて **SKK** のプログラムを **Emacs Lisp** で書き始めたのは **1987年の 7 月頃** であったと思う. ファイルに開発の記録を残すようにしたのは 8 月になってからであった. 他の仕事もしながら 2, 3 週間で一応動くものをつくろうと考えたので, 当然設計方針も簡単なものになった.


## "SKK = I"

SKK の名前を考えたときに Combinatory Logic での有名な等式 SKK = I が念頭にあったのは事実です．ずい分昔に Henk Barendregt さんにこの話をしたこともありました．Combinatory Logic は一般にはあまり知られていないので簡単に紹介をしてみます．

Combinatory Logic は，λ 計算と同様，すべての項 (term, 計算機の言葉で言えば，プログラムに相当するもの) が関数であるような体系である．Logic という名前がついているのは，その上に論理を展開することを目的としていたからであるが，論理の体系としては成功しなかった．しかし，λ 計算と密接な関係があることから，計算の体系としては重要なものである．

Combinatory Logic の項 (combinator) は以下の文法規則で定義される．

        項 ::= 変数 | 定数 | 項(項)

すなわち，項は，変数であるか，定数であるか，(関数としての) 項 f に (引数としての) 項 a を適用した項 f(a) のいずれかである． 通常よく用いられる定数には S, K, I がある．したがって，たとえば，I, S, S(K), S(K)(K) はすべて上の定義により項になる．

なお，通常，Combinatory Logic では f の a への適用 f(a) のことを適用の演算子 * を用いて f*a のように書いて，* は左に結合すると約束する．したがって，f*x*y と書けば，これは (f*x)*y のことであり，f*(x*y)のことではない．その上で，さらに，通常は，* も省略することを許しているので，今の例は fxy となる．しかし，ここでは，そのような省略はしない．fxy とは書かないで，f(x)(y) と書くことにする．ふつう，Combinatory Logic で SKK と書かれる項は，S(K)(K) のことである．

Combinatory Logic の項は引数をひとつだけとるので，apply を用いて app を定義しておく．これにより，項 f(x) を Emacs Lisp で (app f x) と書くことができるようになる．

        (defun app (f x) (apply f (list x)))

Combinatory Logic の定数 S は等式 S(f)(g)(x) = f(x)(g(x)) を満足する combinator として定義される．

        i.e., (app (app (app S f) g) x) = (app (app f x) (app g x))

λ 計算では S を以下のように定義できる ( λ 計算の解説は省略するが，第 0 近似としては Lisp だと思ってよい:-) もちろん，歴史的には λ 計算が Lisp に影響を与えているのであるが．．．)．

        S = λ(f)[λ(g)[λ(x)[f(x)(g(x))]]]

この S を Emacs Lisp で定義すると次のようになる．

        (defconst S
          (lambda (f) `(lambda (g) (let ((f ,f))
                                     `(lambda (x) (app (app ,f x) (app ,g x)))))))

3 つ目の引数 x がコピーされてふたつになることが S のポイントである．

K combinator は等式 K(x)(y) = x を満足する定数として定義される．

        i.e., (app (app K x) y) = x

λ 計算では K を以下のように定義できる．

        K = λ(x)[λ(y)[x]]

この K を Emacs Lisp で定義すると次のようになる．

        (defconst K (lambda (x) `(lambda (y) ,x)))

2 つ目の引数をすてることが K のポイントである．

I combinator は恒等関数を表し，等式 I(x) = x を満足する．

        i.e., (app I x) = x

λ 計算では I を以下のように定義できる．

        I = λ(x)[x]

I を Emacs Lisp で定義すると次のようになる．

        (defconst I (lambda (x) x))

Combinatory Logic で S(K)(K) = I という等式が成り立つということの意味は，任意の combinator x に対して，S(K)(K)(x) を計算してみると

        S(K)(K)(x) = K(x)(K(x)) = x

となり，I についても I(x) = x なので，どちらも，任意の入力 x について何も変更を加えないで x をそのまま出力する関数と考えられということである．日本語入力システム SKK という名前には，ユーザの頭の中にある日本語のテキストを，なるべくストレスなしに，そのままディスプレイに出力するプログラムにしたいという気持ちが込められている．

Emacs Lisp でも S(K)(K) を以下のように定義することにより，恒等関数をつくることができる．

        (defconst SKK (app (app S K) K))

examples

        (app SKK 2) ;; -> 2
        (app I 2) ;; -> 2
        (app SKK "SKK") ;; -> "SKK"
        (app I "SKK") ;; -> "SKK"
        (equal SKK (app SKK SKK)) ;; -> t
        (equal I (app I I)) ;; -> t
        (equal SKK I) ;; -> nil となるのは，SKK と I はプログラムとしては同じふるまい
                      ;;    をするが，コードとしては異るからである．

        (defun SKK (x) (app SKK x))
        (SKK 2) ;; -> 2
        (SKK "SKK") ;; -> "SKK"

Combinatory Logic のすごいところは， S と K だけで計算可能な関数をすべて記述できるということです．あまりにすごいのでプログラミング言語として使う人はいないようです．これに対して，λ 計算は，同じようにすごい言語ですが，Lisp や型付の関数型言語として姿を変て現在もよく使われています．その理由は自然演繹とよばれる論理の体系との関係が深いからだと私は考えています．

この小文の草稿について有益な質問，コメントを寄せてくださった中島幹夫氏に感謝します．

Copyright (C) 2002 佐藤雅彦 (京都大学名誉教授)


## SKK の 25年

http://mail.ring.gr.jp/skk/201212/msg00007.html

皆様，

おかげさまで 1987年に Emacs の上で SKK が動くようになってから25年が過
ぎました．私も相変わらず，昔の設定のまま SKK を使っています．最初の頃
は，個人辞書への項目の追加に追われていましたが，最近では辞書に新しい登
録をすることもほとんどなくなりました．

最初は自分専用で開発したのですが，研究室や，外部の人にも使ってもらえる
ようになりました．現在出張でドイツにきていますが，数日前にあった日本人
の研究者も，英語版の Ubuntu で SKK が問題なく使えているといっていまし
た．これも open source での開発の結果であると感謝しています．

私事ですが，この3月末で京大を退職し，京都大学の名誉教授になりました．SKK
Openlab の記述を修正していただけるとありがたいです．

なお，私の最終講義および関連行事の資料が以下にありますので，ご覧いただ
ければ幸いです．SKK についても少しだけですがふれています．

    http://www.sato.kuis.kyoto-u.ac.jp/~masahiko/taikan.html

佐藤雅彦


## SKK の歴史

| 西暦   | SKK                                                                                                                              | GNU Emacs (https://www.gnu.org/software/emacs/emacs.html)                                                                                                                                                                                                                                                   | XEmacs (http://www.xemacs.org/)                   |
| ------ | -----------------------------------------------------------------------------                                                    | -------------------------------------------------------------------------                                                                                                                                                                                                                                   | ------------------------------------------------- |
| 1987   | 佐藤雅彦氏が SKK の開発に着手 (7月頃)                                                                                            | Nemacs 1.1 (Emacs 18.47) (06/12)                                                                                                                                                                                                                                                                            |                                                   |
| 1988   | SKK 1.13 (04/22)                                                                                                                 | Nemacs 2.1 (06/15)                                                                                                                                                                                                                                                                                          |                                                   |
| 1989   | SKK 2.25 (04/15)                                                                                                                 | Nemacs 3.1 (06/14)                                                                                                                                                                                                                                                                                          |                                                   |
| 1990   | 東北大学において SKK メーリングリスト開設(4月頃)。                                                                               | Nemacs 3.3.2 (Emacs 18.55) (06/06) -- SKK 2.25 を収録 (世間では 3.47 と言われているが、肝心の Nemacs を展開すると 2.25 しか見当たらない)。                                                                                                                                                                  |                                                   |
|        | SKK 3.47 (04/29) -- 送りありエントリの送り仮名サポートが実装される。                                                             |                                                                                                                                                                                                                                                                                                             |                                                   |
| 1991   | 雑誌「bit」が1991年4月号に佐藤氏のSKKに関する記事を掲載(4月頃)。                                                                 | Demacs 1.2.0 (Emacs 18.55) (12/12(?))                                                                                                                                                                                                                                                                       |                                                   |
|        | SKK 4.33 (05/09)                                                                                                                 |                                                                                                                                                                                                                                                                                                             |                                                   |
| 1992   | SKK 5.30 (05/09) -- このころから Mule 対応が進められる。                                                                         | Mule 0.9.0 Beta (03/04)                                                                                                                                                                                                                                                                                     |                                                   |
|        | 辞書が、送りありエントリと送りなしエントリが一つのファイルに納めた形式になった。                                                 |                                                                                                                                                                                                                                                                                                             |                                                   |
| 1993   | SKK 6.32 (04/24) -- 変換時に個人辞書以外を検索する機能、Emacs のバッファに読み込んだ辞書のバイナリサーチ機能が実装される。       |                                                                                                                                                                                                                                                                                                             |                                                   |
| 1994   | SKK 7.18 (06/07)                                                                                                                 | Mule 1.1 (Emacs 18.59) (02/08)                                                                                                                                                                                                                                                                              |                                                   |
|        |                                                                                                                                  | Mule 2.0 (Emacs 19.25) (08/06) -- Emacs 19 になり GUI が進化。                                                                                                                                                                                                                                              |                                                   |
| 1995   | SKK 8.6 (05/17) -- Emacs 19 に対応した i-search 機能を搭載。                                                                     | Mule 2.3 (Emacs 19.28) (07/24)                                                                                                                                                                                                                                                                              |                                                   |
| 1996   | 佐藤氏とともに開発の場が京大に移動。                                                                                             | Mule 2.3 (Emacs 19.34) 非公式版 (8月(?))。                                                                                                                                                                                                                                                                  |                                                   |
|        |                                                                                                                                  | このころ FSF, XEmacs とも Mule の統合が行われた。                                                                                                                                                                                                                                                           |                                                   |
| 1997   | SKK 9.6 (02/07) -- face を利用したカラフルな UI は SKK のイメージを変えた。                                                      | Emacs 20.1 (MULE 3.0) (09/14) -- SKK 9.6 がそのままでは動かなかった。                                                                                                                                                                                                                                       | XEmacs 20.0 (02/09)                               |
|        | SKK 10 の開発が始まる (2月頃) -- いわゆる「非公式」時代。                                                                        |                                                                                                                                                                                                                                                                                                             |                                                   |
|        | Mule, Emacs, XEmacs など多様な環境で動作することが求められるようになる。                                                         |                                                                                                                                                                                                                                                                                                             |                                                   |
| 1998   | SKK 10.39 (03/01)                                                                                                                | Emacs 20.3 (MULE 4.0) (08/19) -- このバージョンにおける変更は SKK にとって重大で、一部では混乱がみられた。                                                                                                                                                                                                  | XEmacs 20.4 (02/23) -- SKK 10.38 を同梱。         |
|        | SKK 10.44.8 (07/27)                                                                                                              |                                                                                                                                                                                                                                                                                                             | Mule をサポートした XEmacs にユーザが流れ始める。 |
|        | APEL が採用される (10月頃) -- この頃から XEmacs での動作が安定し始める。                                                         |                                                                                                                                                                                                                                                                                                             |                                                   |
| 1999   | SKK 10.56 (10/23)                                                                                                                | Emacs 20.4 (MULE 4.0) (07/12) -- 20.3 から 1, 2週間の予定が1 年近くかかってやっと安定。                                                                                                                                                                                                                     | XEmacs 21.0.67 (03/25)                            |
|        | SKK オープンラボ開設(11月頃) -- Daredevil SKK の開発を開始。京大の本家とは別の道を歩み始める。                                   |                                                                                                                                                                                                                                                                                                             |                                                   |
| 2000   | SKK 10.62a (10/30) -- SKK 10 の開発が凍結され、Daredevil SKK が開発の幹に。                                                      | Emacs 20.7 (MULE 4.0) (06/14)                                                                                                                                                                                                                                                                               |                                                   |
|        | 京大での開発終了が宣言される (11月頃)。                                                                                          |                                                                                                                                                                                                                                                                                                             |                                                   |
| 2001   | Daredevil SKK 11.4 (01/02)                                                                                                       | Emacs 21.1 (MULE 5.0) (10/20) -- このころより GUI が強化され，XEmacs と遜色なくなってきた．                                                                                                                                                                                                                 | XEmacs 21.2.46 (03/21) (旧安定版)                 |
|        | Daredevil SKK 11.5.2 (12/02)                                                                                                     |                                                                                                                                                                                                                                                                                                             | XEmacs 21.4.0 (04/16) (新安定版)                  |
|        | Daredevil SKK 11.6.0 (12/16)                                                                                                     |                                                                                                                                                                                                                                                                                                             | XEmacs 21.5.1 (05/09) (開発版)                    |
|        | Emacs 21 の GUI 強化に伴い XEmacs と同等の機能を実装                                                                             |                                                                                                                                                                                                                                                                                                             |                                                   |
| 2002   |                                                                                                                                  | Emacs 開発版が anonymous CVS で取得可能になる。                                                                                                                                                                                                                                                             |                                                   |
| 2003   | Daredevil SKK 12.2.0 (08/03)                                                                                                     |                                                                                                                                                                                                                                                                                                             |                                                   |
| 2004   | Emacs 21 の tooltip の機能をいかした候補・注釈表示が 利用可能になった。                                                          |                                                                                                                                                                                                                                                                                                             | XEmacs 21.4.16 (12/11)                            |
|        | 新しい学習機能 (skk-bayesian.el)                                                                                                 |                                                                                                                                                                                                                                                                                                             | XEmacs 21.5.18 (10/22)                            |
| 2005   | (uim や scim のめざましい発展)                                                                                                   | Emacs 21.4 (MULE 5.0) (02/06)                                                                                                                                                                                                                                                                               |                                                   |
|        | 候補表示の装飾機能、インライン候補表示、サーバー補完機能に対応 など多数の機能追加                                                |                                                                                                                                                                                                                                                                                                             |                                                   |
|        | Emacs 22 対応の本格化                                                                                                            |                                                                                                                                                                                                                                                                                                             |                                                   |
| 2006   | 補完機能の大幅な拡張 (プログラマブル補完、prefix 補完、 look の日本語対応、任意辞書補完機能など)                                 |                                                                                                                                                                                                                                                                                                             | XEmacs 21.4.20 (12/10)                            |
| 2007   | Daredevil SKK 13.1 (08/18)                                                                                                       | Emacs 22.1 (MULE 5.0) (06/02) -- GTK 対応可能となる                                                                                                                                                                                                                                                         | XEmacs 21.5.28 (05/21)                            |
| 2008   | 動的補完が複数候補表示に対応、Sticky shift 的入力に対応                                                                          | Emacs 22.3 (MULE 5.0) (09/05)                                                                                                                                                                                                                                                                               | XEmacs 21.4.22 (12/28)                            |
| 2009   |                                                                                                                                  | Emacs 23.1 (MULE 6.0) (07/29) -- UNICODE 対応と内部コード変更 (utf-8-emacs)、Xft 対応、multi-tty 対応                                                                                                                                                                                                       | XEmacs 21.5.29 (05/18)                            |
| 2010   | Daredevil SKK 14.1 (09/15) -- CDB 辞書が直接検索可能、単漢字変換機能の改善                                                       | Emacs 23.2 (MULE 6.0) (05/07)                                                                                                                                                                                                                                                                               |                                                   |
| 2011   | Daredevil SKK 14.2 (01/01) -- GNU Emacs 22 以上で APEL は不要に                                                                  | Emacs 23.3 (MULE 6.0) (03/10)                                                                                                                                                                                                                                                                               | XEmacs 21.5.31 (04/29)                            |
|        | Daredevil SKK 14.3 (07/01)                                                                                                       |                                                                                                                                                                                                                                                                                                             |                                                   |
| 2012   | Daredevil SKK 14.4 (01/01) -- アノテーション表示の強化。skk-search-web.el の追加。skk-show-mode.el の追加                        | Emacs 23.4 (MULE 6.0) (01/29)                                                                                                                                                                                                                                                                               | XEmacs 21.5.32 (08/02)                            |
|        | SKK の 25年 (http://mail.ring.gr.jp/skk/201212/msg00007.html)                                                                    | Emacs 24.1 (MULE 6.0) (06/10)                                                                                                                                                                                                                                                                               |                                                   |
|        |                                                                                                                                  | Emacs 24.2 (MULE 6.0) (08/27)                                                                                                                                                                                                                                                                               |                                                   |
| 2013   | Daredevil SKK 15.1 (03/16) -- GNU Emacs 21 のサポート廃止。新たな数値変換タイプ #8 を追加。新たな関数 skk-relative-date() を追加 | Emacs 24.3 (MULE 6.0) (03/11) -- フェイス modeline が削除され、以降はフェイス mode-line                                                                                                                                                                                                                     | XEmacs 21.5.33 (01/04)                            |
|        |                                                                                                                                  |                                                                                                                                                                                                                                                                                                             | XEmacs 21.5.34 (06/24)                            |
| 2014   | Daredevil SKK 15.2 (11/24)                                                                                                       | Emacs 24.4 (MULE 6.0) (10/20) -- eww, org8, nadvice.el, more. NTEmacs のディレクトリ構成が変更(Using the Posix configure script and Makefiles also means a change in the directory structure of the Emacs installation on Windows. It is now the same as on GNU and Unix systems.)。ddskk-15.2 で対策済み。 |                                                   |
|        | 開発ツールを github へ変更 (12/21)。ddskk(旧main) skktools(旧tools)                                                              |                                                                                                                                                                                                                                                                                                             |                                                   |
| 2015   | MELPA 登録。M-x list-packages でインストール可能に。                                                                             | Emacs 24.5 (MULE 6.0) (04/10)                                                                                                                                                                                                                                                                               |                                                   |
| 2016   | Daredevil SKK 16.1 (10/01) -- GNU Emacs 25 対応など                                                                              | Emacs 25.1 (MULE 6.0) (09/17) -- dynamic module, Xwidgets, more.                                                                                                                                                                                                                                            |                                                   |
| 2017   | Daredevil SKK 16.2 (03/04) -- GNU Emacs 22 のサポート廃止。Ruby 2.4 対応など                                                     | Emacs 25.2 (04/21)                                                                                                                                                                                                                                                                                          |                                                   |
|        |                                                                                                                                  | Emacs 25.3 (09/11)                                                                                                                                                                                                                                                                                          |                                                   |
| 2018   |                                                                                                                                  | Emacs 26.1 (05/28)                                                                                                                                                                                                                                                                                          |                                                   |
| 2019   |                                                                                                                                  | Emacs 26.2 (04/12)                                                                                                                                                                                                                                                                                          |                                                   |
|        |                                                                                                                                  | Emacs 26.3 (08/28)                                                                                                                                                                                                                                                                                          |                                                   |
| 2020   | Daredevil SKK 16.3 (02/09) -- 元号「令和」をサポート                                                                             | Emacs 27.1 (08/10)                                                                                                                                                                                                                                                                                          |                                                   |
|        | Daredevil SKK 17.1 (08/15) -- XEmacs のサポート廃止、GNU Emacs 23 のサポート廃止、インストーラの挙動を変更、など。               |                                                                                                                                                                                                                                                                                                             |                                                   |
