/*
* Copyright (C) 2019 ~ 2020 Uniontech Software Technology Co.,Ltd.
*
* Author:     leilong  <leilong@uniontech.com>
*
* Maintainer: leilong  <leilong@uniontech.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "test_colorslider.h"

test_colorslider::test_colorslider(QObject *parent) : QObject(parent)
{

}

TEST_F(test_colorslider, getColor_001)
{
    EXPECT_EQ(mWidget->getColor(0, 0, 0).name(), "#000000");
    EXPECT_EQ(mWidget->getColor(1, 0.5, 0.5).name(), "#3f7e7f");;
    EXPECT_EQ(mWidget->getColor(1, 0.2, 0.5).name(), "#667f7f");
    EXPECT_EQ(mWidget->getColor(1, 0.1, 0.9).name(), "#cee5e5");
    EXPECT_EQ(mWidget->getColor(1, 0.3, 0.4).name(), "#476566");
    EXPECT_EQ(mWidget->getColor(2, 0.5, 0.5).name(), "#3f7d7f");
    EXPECT_EQ(mWidget->getColor(0.5, 0.5, 0.5).name(), "#3f7e7f");
    EXPECT_EQ(mWidget->getColor(5, 0.5, 0.5).name(), "#3f7a7f");
    EXPECT_EQ(mWidget->getColor(1, 0.5, 0.5).name(), "#3f7e7f");
    EXPECT_EQ(mWidget->getColor(10, 0, 0).name(), "#000000");
    EXPECT_EQ(mWidget->getColor(60, 0, 0).name(), "#000000");
    EXPECT_EQ(mWidget->getColor(71, 0, 0).name(), "#000000");
}

TEST_F(test_colorslider, paintEvent_001)
{
    QPaintEvent *e = new QPaintEvent(QRect());
    mWidget->paintEvent(e);
    delete e;
}
