/* 
  DB Mixer 
  ======== 
  Description: 
    interface controller for an external mixer to work with the DBMix system. 
 
    Copyright (c) 2000, 2001 Simon Mark Werner 
 
    DBMix Author: Robert Michael S Dean 
    exmixer Author: Simon Mark Werner 
    Version: 1.0 
 
 
   This program is free software; you can redistribute it and/or modify 
   it under the terms of the GNU General Public License as published by 
   the Free Software Foundation; either version 2 of the License, or 
   (at your option) any later version. 
 
   This program is distributed in the hope that it will be useful, 
   but WITHOUT ANY WARRANTY; without even the implied warranty of 
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
   GNU General Public License for more details. 
 
   You should have received a copy of the GNU General Public License 
   along with this program; if not, write to the Free Software 
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. 
 
 */ 
 
#include <sys/types.h> 
#include <sys/stat.h> 
#include <sys/time.h> 
#include <unistd.h> 
#include <string.h> 
#include <stdio.h> 
#include <stdlib.h> 
#include <errno.h> 
 
#include <gtk/gtk.h> 
 
#include <dbdebug.h>

#include "dbmixer.h" 
#include "exmixer.h" 
#include "save_prefs.h" 
 
extern int errno; 
extern int exmixer_enabled; 
extern dbfsd_data * sysdata; 
extern gint fade_time_base; 

/* Shamelessly pillaged from gIDE */ 
gchar *SK_CutLeadingBlanks( gchar *source ) 
{ 
    gint i; 
    gchar *dest = ""; 
 
    if( !source ) 
    { 
       printf( "SK_CutLeadingBlanks: NULL-Pointer uebergeben\n" ); 
       return( "" ); 
    } 
 
    if( strlen( source ) == 0 ) 
    { 
       printf( "SK_CutLeadingBlanks: Leerer String uebergeben\n" ); 
       return( "" ); 
    } 
 
    for(i=0;i<=(strlen( source ));i++) 
       if( source[i] != ' ' ) 
       { 
           dest = &source[i]; 
           break; 
       } 
 
    return( dest ); 
 
} 
 
gint iscomment( gchar *arg ) 
{ 
    if( arg[0] == '#' || arg[0] == ';' ) 
        return( 1 ); 
    else 
        return( 0 ); 
} 
 
gint __isblank( gchar *arg ) 
{ 
    if( strlen( arg ) == 0 ) 
        return( 1 ); 
    else 
          return( 0 ); 
} 
 
int read_js_settings( void ) 
{ 
    gchar *buf = (gchar *) malloc(STR_LEN); 
    gchar *key = (gchar *) malloc(STR_LEN); 
    gchar *arg = (gchar *) malloc(STR_LEN);    
    FILE *fHandle; 
    char *js_file; 
    int dev_id = -1, axis_id = 0; 
    
    /* Read preferences */ 
    js_file = g_get_home_dir(); 
    if ( !js_file ) 
    { 
		Debug( "Home directory not found!\n" ); 
		return FALSE; 
    } 
    
    /* Needs to be incorperated with dbmixer to have a universal file */ 
    js_file = g_strconcat(js_file, "/.joystick", NULL); 
    Debug("Opening file %s \n", js_file); 
    
    fHandle = fopen(js_file, "r"); 
    if ( !fHandle ) 
    { 
		/* Try "/etc/joystick.cal" */ 
		fHandle = fopen("/etc/joystick.cal", "r"); 
		if ( !fHandle ) 
		{ 
			printf("Unable to find joystick calibration file needed to calibrate the exmixer."); 
			return FALSE; 
		}        
    } 
    
	while ( fgets( buf, STR_LEN, fHandle ) ) 
    { 
        strcpy( buf, SK_CutLeadingBlanks( buf ) ); 
        if ( !iscomment( buf ) && !__isblank( buf ) ) 
        { 
            if ( sscanf( buf, "%s = %s", key, arg ) == 2 ) 
            { 
                if ( !strcmp( key, "BeginJoystick" ) ) 
                { 
					dev_id++; 
					sscanf( arg, "%s", D_FILENAME); 
					continue; 
                } 
                if ( !strcmp( key, "BeginAxis" ) ) 
                { 
					axis_id = atoi( arg ); 
					continue; 
                } 
                if ( !strcmp( key, "Minimum" ) ) 
                { 
					A_MIN = atoi( arg ); 
					continue; 
                } 
                if ( !strcmp( key, "Center" ) ) 
                { 
					A_CEN = atoi( arg ); 
					continue; 
                } 
                if ( !strcmp( key, "Maximum" ) ) 
                { 
					A_MAX = atoi( arg ); 
					continue; 
                } 
			} 
        
            if ( sscanf( buf, "%s", key ) == 1 ) 
            { 
                if ( !strcmp( key, "Flip" ) ) 
                { 
					A_FLIP = TRUE; 
					continue; 
                } 
			} 
		} 
    } 
    
    fclose( fHandle ); 
    free(buf); 
    free(key); 
    free(arg); 
    return TRUE; 
} 
 
 
/* Read ~/.dbmix to get the saved settings */ 
int read_settings( void ) 
{ 
    gchar *buf = (gchar *) malloc(STR_LEN); 
    gchar *key = (gchar *) malloc(STR_LEN);    
    gchar *arg = (gchar *) malloc(STR_LEN); 
    FILE *fHandle; 
    gchar *pref_file; 
    int dev_id = -1; 
    int axis_id=0, but_id=0; 
    
    /* Read preferences */ 
    pref_file = g_get_home_dir(); 
    if( !pref_file ) 
    { 
       printf( "Home directory not found! Unable to read preferences file.\n" ); 
       return FALSE; 
    } 
    
    /* Needs to be incorperated with dbmixer to have a universal file */ 
    pref_file = g_strconcat(pref_file, PREF_FILENAME, NULL); 
    Debug("Opening file %s\n", pref_file); 
    
    fHandle = fopen(pref_file, "r"); 
    if ( !fHandle ) 
    { 
       printf("%s not found, using default preferences.\n", pref_file); 
       return FALSE; 
    }    
    
	while( fgets( buf, STR_LEN, fHandle ) ) 
    { 
        strcpy( buf, SK_CutLeadingBlanks( buf ) ); 
        if( !iscomment( buf ) && !__isblank( buf ) ) 
        { 
            if( sscanf( buf, "%s = %s", key, arg ) == 2 ) 
            { 
#ifdef EXT_MIXER                
                if( !strcmp( key, "exmixer_enabled" ) ) 
                { 
					exmixer_enabled = atoi( arg ); 
					continue; 
                } 
                if( !strcmp( key, "device_filename" ) ) 
                { 
					dev_id++; 
					continue; 
                } 
                if( !strcmp( key, "enabled" ) ) 
                { 
					/* Make sure the device opened OK */ 
					D_ENABLED = atoi( arg ); 
					continue; 
                } 
				
                if( !strcmp( key, "slider" ) ) 
                { 
					axis_id = atoi(arg); 
					if (axis_id > MAX_AXES || (axis_id < 0)) 
					{   /* Error checking */ 
						printf("Error in %s\n", pref_file); 
						axis_id = 0; 
					} 
					continue; 
                } 
				
                if( !strcmp( key, "slider_channel" ) ) 
                { 
					A_CHAN = atoi(arg); 
					if ((A_CHAN > sysdata->num_channels) || (A_CHAN < 0)) 
					{   /* Error checking */ 
						printf("Error in %s\n", pref_file); 
						A_CHAN = 0; 
					} 
					continue; 
                } 
				
                if( !strcmp( key, "slider_assigned" ) ) 
                { 
					A_ASSIGN = atoi( arg ); 
					continue; 
                } 
				
                if( !strcmp( key, "button" ) ) 
                { 
					but_id = atoi(arg); 
					if (but_id > MAX_BUT || (but_id < 0)) 
					{   /* Error checking */ 
						printf("Error in %s\n", pref_file); 
						but_id = 0; 
					} 
					continue; 
                } 
				
                if( !strcmp( key, "button_channel" ) ) 
                { 
					B_CHAN = atoi(arg); 
					if ((B_CHAN > sysdata->num_channels) || (B_CHAN < 0)) 
					{   /* Error checking */ 
						printf("Error in %s\n", pref_file); 
						B_CHAN = 0; 
					} 
					continue; 
                } 
				
                if( !strcmp( key, "button_assigned" ) ) 
                { 
					B_ASSIGN = atoi( arg ); 
					continue; 
                } 
#endif 
                if( !strcmp( key, "main_audio_device" ) ) 
                { 
					sprintf(sysdata->main_audio_device, arg); 
					continue; 
                } 
				
                if( !strcmp( key, "main_audio_device" ) ) 
                { 
					sprintf(sysdata->main_audio_device, arg); 
					continue; 
                } 
				
                if( !strcmp( key, "cue_audio_device" ) ) 
                { 
					sprintf(sysdata->cue_audio_device, arg); 
					continue; 
                } 
				
                if( !strcmp( key, "main_mixer_device" ) ) 
                { 
					sprintf(sysdata->main_mixer_device, arg); 
					continue; 
                } 
				
                if( !strcmp( key, "cue_mixer_device" ) ) 
                { 
					sprintf(sysdata->cue_mixer_device, arg); 
					continue; 
                } 
				
                if( !strcmp( key, "num_main_buffs" ) ) 
                { 
					sysdata->num_main_buffs = atoi( arg ); 
					continue; 
                } 
				
                if( !strcmp( key, "num_cue_buffs" ) ) 
                { 
					sysdata->num_cue_buffs = atoi( arg ); 
					continue; 
                } 
				
                if( !strcmp( key, "clipping_threshold" ) ) 
                { 
					sysdata->clipping_threshold = atoi( arg ); 
					continue; 
                } 

                if( !strcmp( key, "skip_value" ) ) 
                { 
					sysdata->skip_max = atoi( arg ); 
					continue; 
                } 
	
#if 0
				if ( !strcmp( key, "fade_time_base" ) )
				{
					fade_time_base = atoi( arg );
					continue;
				}
#endif		
	
			} /* if sscanf() */ 
		} /* if */ 
    } /* While */ 
    
    fclose( fHandle ); 
    free(buf); 
    free(key); 
    free(arg); 
    return TRUE; 
} 
 
/* Write the settings to disk */ 
void write_settings( void ) 
{ 
    FILE *fHandle; 
    gchar *pref_file;//= (gchar *)malloc(STR_LEN); 
    gchar *label = (gchar *)malloc(STR_LEN); 
    int dev_id = 0; 
    int axis_id, but_id; 
 
    /* Read preferences */ 
    pref_file = g_get_home_dir(); 
    if( !pref_file ) 
    { 
       printf( "Home directory not found! Unable to save preferences.\n" ); 
       return; 
    } 
    
    /* Needs to be incorperated with dbmixer to have a universal file */ 
    pref_file = g_strconcat(pref_file, PREF_FILENAME, NULL); 
    Debug("Saving settings to %s\n", pref_file); 
    
    fHandle = fopen(pref_file, "w"); 
    if ( !fHandle ) 
    { 
       perror("Error while saving preferences:\n"); 
       return; 
    }    
    
    fputs("# File automaticaly created by DBmix.\n", fHandle); 
    fputs("# Do not edit this file.\n\n", fHandle); 
 
#ifdef EXT_MIXER                
    sprintf(label, "exmixer_enabled = %d\n", exmixer_enabled); 
    fputs(label, fHandle); 
    
    for (dev_id=0; dev_id<MAX_DEV; dev_id++) 
    { 
       sprintf(label, "\ndevice_filename = %s\n", D_FILENAME); 
       fputs(label, fHandle); 
          sprintf(label, "  enabled = %d\n", D_ENABLED); 
       fputs(label, fHandle); 
        
        for (axis_id=0; axis_id<N_AXES; axis_id++) 
        { 
           sprintf(label, "  slider = %d\n", axis_id); 
           fputs(label, fHandle); 
           sprintf(label, "    slider_assigned = %d\n", A_ASSIGN); 
           fputs(label, fHandle); 
           switch (A_ASSIGN) 
           { 
           case EM_A_VOLUME: 
           case EM_A_PITCH: 
               sprintf(label, "    slider_channel = %d\n", A_CHAN); 
              fputs(label, fHandle); 
             default: 
                 /* Write nothing */ 
           } 
       } 
        
       for(but_id=0; but_id < N_BUT; but_id++) 
       { 
           sprintf(label, "  button = %d\n", but_id); 
           fputs(label, fHandle); 
           sprintf(label, "    button_assigned = %d\n", B_ASSIGN); 
           fputs(label, fHandle); 
           switch (B_ASSIGN) 
           { 
             case EM_B_PLAY: 
             case EM_B_STOP: 
             case EM_B_CUE: 
             case EM_B_FAST_FORWARD: 
             case EM_B_REWIND: 
             case EM_B_MUTE: 
             case EM_B_EJECT: 
             case EM_B_NEXT: 
             case EM_B_PREV: 
                 sprintf(label, "    button_channel = %d\n", B_CHAN); 
                 fputs(label, fHandle); 
             default: 
                 /* Write nothing */ 
           } 
        } /* but_id */ 
    } /* dev_id */ 
#endif 
    
    /* DBMix settings device settings */ 
    sprintf(label, "\nmain_audio_device = %s\n", sysdata->main_audio_device); 
    fputs(label, fHandle); 
    sprintf(label, "cue_audio_device = %s\n", sysdata->cue_audio_device); 
    fputs(label, fHandle); 
    sprintf(label, "main_mixer_device = %s\n", sysdata->main_mixer_device); 
    fputs(label, fHandle); 
    sprintf(label, "cue_mixer_device = %s\n", sysdata->cue_mixer_device); 
    fputs(label, fHandle); 
    
    /* DBMix settings buffs settings */ 
    sprintf(label, "num_main_buffs = %d\n", sysdata->num_main_buffs); 
    fputs(label, fHandle); 
    sprintf(label, "num_cue_buffs = %d\n", sysdata->num_cue_buffs); 
    fputs(label, fHandle); 
    sprintf(label, "clipping_threshold = %d\n", sysdata->clipping_threshold); 
    fputs(label, fHandle); 
    sprintf(label, "skip_value = %d\n", sysdata->skip_max); 
    fputs(label, fHandle); 
    
	/* DBMix settings autofade settings */
#if 0
    sprintf(label, "fade_time_base = %d\n", fade_time_base); 
    fputs(label, fHandle); 	
#endif

    fclose(fHandle);    
    free(pref_file); 
    free(label); 
} 
