% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbCanConnect.R
\name{dbCanConnect}
\alias{dbCanConnect}
\title{Check if a connection to a DBMS can be established}
\usage{
dbCanConnect(drv, ...)
}
\arguments{
\item{drv}{an object that inherits from \linkS4class{DBIDriver},
or an existing \linkS4class{DBIConnection}
object (in order to clone an existing connection).}

\item{...}{authentication arguments needed by the DBMS instance; these
typically include \code{user}, \code{password}, \code{host}, \code{port}, \code{dbname}, etc.
For details see the appropriate \code{DBIDriver}.}
}
\value{
A scalar logical.  If \code{FALSE}, the \code{"reason"} attribute indicates
a reason for failure.
}
\description{
Like \code{\link[=dbConnect]{dbConnect()}}, but only checks validity without actually returning
a connection object.  The default implementation opens a connection
and disconnects on success, but individual backends might implement
a lighter-weight check.

\Sexpr[results=rd,stage=render]{DBI:::methods_as_rd("dbCanConnect")}
}
\examples{
\dontshow{if (requireNamespace("RSQLite", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# SQLite only needs a path to the database. (Here, ":memory:" is a special
# path that creates an in-memory database.) Other database drivers
# will require more details (like user, password, host, port, etc.)
dbCanConnect(RSQLite::SQLite(), ":memory:")
\dontshow{\}) # examplesIf}
}
\seealso{
Other DBIDriver generics: 
\code{\link{DBIDriver-class}},
\code{\link{dbConnect}()},
\code{\link{dbDataType}()},
\code{\link{dbDriver}()},
\code{\link{dbGetInfo}()},
\code{\link{dbIsReadOnly}()},
\code{\link{dbIsValid}()},
\code{\link{dbListConnections}()}
}
\concept{DBIDriver generics}
