#include "config"

void Config::setbackend (string const &str, string const &host,
			 string const &url,
			 BackendCheck const &backend_check) {
    vector<string> parts = str2parts (str, ':');
    if (parts.size() < 2 || parts.size() > 4)
	throw Error("Bad back end specifier in '-b" + str +
		    "', expected: SERVER:PORT or SERVER:PORT:MAXCONNECTIONS"
		    " or SERVER:PORT:MAXCONNECTIONS:WEIGHT");

    BackendDef *bdp = 0;
    if (parts.size() == 2)
	bdp = new BackendDef(parts[0], parts[1]);
    else if (parts.size() == 3)
	bdp = new BackendDef(parts[0], parts[1], parts[2]);
    else if (parts.size() == 4)
	bdp = new BackendDef(parts[0], parts[1], parts[2], parts[3]);
    if (!bdp)
	throw Error("Memory fault in Config::setbackend");
    bdp->hostmatch(host);
    bdp->urlmatch(url);
    bdp->backendcheck(backend_check);
    blist.push_back (*bdp);
    delete bdp;
}
