#include "sys"
#include "../config/config"

bool ipmatch (struct in_addr adr, struct in_addr mask) {
    PROFILE("ipmatch");
    
    long laddr = 0, lmask = 0;
    memcpy (&laddr, &adr,  sizeof(adr));
    memcpy (&lmask, &mask, sizeof(mask));
    bool match = ( (laddr & lmask) == laddr );

    debugmsg ("Matching ip " + (string)inet_ntoa(adr) + " against mask " +
	      (string)inet_ntoa(mask) + ": " +
	      (match ? "match" : "miss") + "\n");
    
    return (match);
}
