#   Copyright (c) 2014 Kevin M. Godby <kevin@godby.org>
#   
#   Boost Software License - Version 1.0 - August 17th, 2003
#   
#   Permission is hereby granted, free of charge, to any person or organization
#   obtaining a copy of the software and accompanying documentation covered by
#   this license (the "Software") to use, reproduce, display, distribute,
#   execute, and transmit the Software, and to prepare derivative works of the
#   Software, and to permit third-parties to whom the Software is furnished to
#   do so, all subject to the following:
#   
#   The copyright notices in the Software and this entire statement, including
#   the above license grant, this restriction and the following disclaimer,
#   must be included in all copies of the Software, in whole or in part, and
#   all derivative works of the Software, unless such copies or derivative
#   works are solely in the form of machine-executable object code generated by
#   a source language processor.
#   
#   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
#   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
#   FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
#   SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
#   FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
#   ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
#   DEALINGS IN THE SOFTWARE.

#   - Try to find the udev library
#   
#   Cache Variables: (probably not for direct use in your scripts)
#       UDEV_INCLUDE_DIR
#       UDEV_SOURCE_DIR
#       UDEV_LIBRARY
#   
#   Non-cache variables you might use in your CMakeLists.txt:
#       UDEV_FOUND
#       UDEV_INCLUDE_DIRS
#       UDEV_LIBRARIES
#   
#   Requires these CMake modules:
#       FindPackageHandleStandardArgs (known included with CMake >=2.6.2)

set(UDEV_ROOT_DIR
        "${UDEV_ROOT_DIR}"
        CACHE
        PATH
        "Directory to search for udev")

find_package(PkgConfig QUIET)
if (PKG_CONFIG_FOUND)
    pkg_check_modules(PC_LIBUDEV libudev)
endif ()

find_library(UDEV_LIBRARY
        NAMES
        udev
        PATHS
        ${PC_LIBUDEV_LIBRARY_DIRS}
        ${PC_LIBUDEV_LIBDIR}
        HINTS
        "${UDEV_ROOT_DIR}"
        PATH_SUFFIXES
        lib
        )

get_filename_component(_libdir "${UDEV_LIBRARY}" PATH)

find_path(UDEV_INCLUDE_DIR
        NAMES
        libudev.h
        PATHS
        ${PC_LIBUDEV_INCLUDE_DIRS}
        ${PC_LIBUDEV_INCLUDEDIR}
        HINTS
        "${_libdir}"
        "${_libdir}/.."
        "${UDEV_ROOT_DIR}"
        PATH_SUFFIXES
        include
        )

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(UDEV
        DEFAULT_MSG
        UDEV_LIBRARY
        UDEV_INCLUDE_DIR
        )

if (UDEV_FOUND)
    list(APPEND UDEV_LIBRARIES ${UDEV_LIBRARY})
    list(APPEND UDEV_INCLUDE_DIRS ${UDEV_INCLUDE_DIR})
    mark_as_advanced(UDEV_ROOT_DIR)
endif ()

mark_as_advanced(UDEV_INCLUDE_DIR
        UDEV_LIBRARY)
