# -*- coding: utf-8 -*-

# Bluemindo: A really simple but powerful audio player in Python/PyGTK.
# Copyright (C) 2007-2009  Erwan Briand

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation version 3 of the License.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from common.functions import Functions
functions = Functions()

from gtk.glade import bindtextdomain as gtk_glade_bindtextdomain
gtk_glade_bindtextdomain('bluemindo', functions.localedir)

from gobject import threads_init

from gtk.gdk import pixbuf_new_from_file
from gtk.glade import XML as glade_XML
from gtk import (main as gtk_main, window_set_default_icon_list, pygtk_version,
                 gtk_version, image_new_from_file)
from os.path import join
from os import getcwd

# Raise if GTK is not up-to-date
if pygtk_version < (2, 12) or gtk_version < (2, 12):
    raise ImportError, 'Bluemindo needs GTK >= 2.12'

from media.gstreamer import GStreamer
from common.config import ConfigLoader
from handlers import main as hmain
from gui.volumemanagement import VolumeManagement
from gui.gnomemultimediakeys import GnomeMultimediaKeys

config = ConfigLoader()
gst = GStreamer()

class MainWindow(object):
    def __init__(self, extensions):
        # Start threads
        threads_init()

        self.extensions = extensions

        # GUI initialization
        glade_file = join(functions.datadir, 'glade', 'mainwindow.glade')
        self.widgets = glade_XML(glade_file, 'window1', domain='bluemindo')

        self.handler = hmain.MainHandlers(self.extensions, config,
                                          self.widgets, gst)
        window = self.widgets.get_widget('window1')
        functions.open_bluemindo(window)
        window.connect('delete_event', self.handler.on_window_close)

        # Add the pretty logo to all windows
        icon_file = join(functions.datadir, 'image', 'logo_head_small.png')
        pixbuf = pixbuf_new_from_file(icon_file)
        window_set_default_icon_list(pixbuf)
        window.set_icon(pixbuf)
        window.set_title('Bluemindo')

        # Registering a few GTK handlers
        tool_previous = self.widgets.get_widget('tool-previous')
        tool_previous.connect('clicked', self.handler.on_tool_previous)

        tool_stop = self.widgets.get_widget('tool-stop')
        tool_stop.connect('clicked', self.handler.on_tool_stop)

        tool_play = self.widgets.get_widget('tool-play')
        tool_play.connect('clicked', self.handler.on_tool_play)

        tool_next = self.widgets.get_widget('tool-next')
        tool_next.connect('clicked', self.handler.on_tool_next)

        tool_lyrics = self.widgets.get_widget('tool-lyrics')
        tool_lyrics.connect('clicked', self.handler.on_tool_lyrics)

        tool_reloadlyrics = self.widgets.get_widget('tool-reloadlyrics')
        tool_reloadlyrics.connect('clicked', self.handler.on_tool_reloadlyrics)

        tool_savelyrics = self.widgets.get_widget('tool-savelyrics')
        tool_savelyrics.connect('clicked', self.handler.on_tool_savelyrics)

        tool_show_fullscreen = self.widgets.get_widget('menu-show-fullscreen')
        tool_show_fullscreen.connect('activate',
                                     self.handler.on_menu_fullscreen)

        tool_quit = self.widgets.get_widget('menu-quit')
        tool_quit.connect('activate', self.handler.on_menu_quit)

        tool_prefs = self.widgets.get_widget('menu-prefs')
        tool_prefs.connect('activate', self.handler.on_menu_prefs)

        tool_refresh = self.widgets.get_widget('menu-refresh')
        tool_refresh.connect('activate', self.handler.on_menu_refresh)

        tool_about = self.widgets.get_widget('menu-about')
        tool_about.connect('activate', self.handler.on_menu_about)

        # GNOME multimedia keys
        GnomeMultimediaKeys(extensions)

        # Only-player functionnality
        self.has_left_panel = False

        radio_player = self.widgets.get_widget('view-player')
        radio_all = self.widgets.get_widget('view-all')

        radio_player.set_group(radio_all)
        radio_player.set_active(False)
        radio_player.connect('activate', self.change_view, 'player')

        radio_all.set_active(True)
        radio_all.connect('activate', self.change_view, 'all')

        # Volume management
        self.volume = VolumeManagement(self.widgets)

    def change_view(self, widget, view):
        """ This function selects the view (player or all)."""
        vbox = self.widgets.get_widget('vbox2')

        if view == 'player':
            if vbox.get_property('visible'):
                vbox.hide()
                self.has_left_panel = True
            self.widgets.get_widget('vpaned1').hide()
            self.widgets.get_widget('toolbar4').hide()

            window = self.widgets.get_widget('window1')
            width = window.get_size()[0]
            window.resize(width, 120)

        elif view == 'all':
            if self.has_left_panel:
                vbox.show()
            self.widgets.get_widget('vpaned1').show()
            self.widgets.get_widget('toolbar4').show()

            window = self.widgets.get_widget('window1')
            width = window.get_size()[0]
            window.resize(width, 240)

    def get_classes(self):
        return [self.handler, self.volume]

    def start_thread(self):
        # Tell extensions that Bluemindo is now launched
        self.extensions.load_event('OnBluemindoStarted', self.widgets)

        # Start the GTK main thread
        gtk_main()