;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.
;; RUN: foreach %s %t wasm-opt --nominal --remove-unused-names --cfp -all -S -o - | filecheck %s
;; (remove-unused-names is added to test fallthrough values without a block
;; name getting in the way)

(module
  ;; CHECK:      (type $none_=>_none (func_subtype func))

  ;; CHECK:      (type $struct (struct_subtype (field i32) data))
  (type $struct (struct i32))
  ;; CHECK:      (func $impossible-get (type $none_=>_none)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (block
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (ref.null $struct)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (unreachable)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $impossible-get
    (drop
      ;; This type is never created, so a get is impossible, and we will trap
      ;; anyhow. So we can turn this into an unreachable (plus a drop of the
      ;; reference).
      (struct.get $struct 0
        (ref.null $struct)
      )
    )
  )
)

(module
  ;; CHECK:      (type $struct (struct_subtype (field i64) data))
  (type $struct (struct i64))
  ;; CHECK:      (type $none_=>_none (func_subtype func))

  ;; CHECK:      (func $test (type $none_=>_none)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.new_default_with_rtt $struct
  ;; CHECK-NEXT:    (rtt.canon $struct)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (block (result i64)
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (ref.as_non_null
  ;; CHECK-NEXT:      (ref.null $struct)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (i64.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $test
    ;; The only place this type is created is with a default value, and so we
    ;; can optimize the later get into a constant (plus a drop of the ref).
    ;;
    ;; (Note that the allocated reference is dropped here, so it is not actually
    ;; used anywhere, but this pass does not attempt to trace the paths of
    ;; references escaping and being stored etc. - it just thinks at the type
    ;; level.)
    (drop
      (struct.new_default_with_rtt $struct
        (rtt.canon $struct)
      )
    )
    (drop
      (struct.get $struct 0
        (ref.null $struct)
      )
    )
  )
)

(module
  ;; CHECK:      (type $struct (struct_subtype (field f32) data))
  (type $struct (struct f32))
  ;; CHECK:      (type $none_=>_none (func_subtype func))

  ;; CHECK:      (func $test (type $none_=>_none)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.new_with_rtt $struct
  ;; CHECK-NEXT:    (f32.const 42)
  ;; CHECK-NEXT:    (rtt.canon $struct)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (block (result f32)
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (ref.as_non_null
  ;; CHECK-NEXT:      (ref.null $struct)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (f32.const 42)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $test
    ;; The only place this type is created is with a constant value, and so we
    ;; can optimize the later get into a constant (plus a drop of the ref).
    (drop
      (struct.new_with_rtt $struct
        (f32.const 42)
        (rtt.canon $struct)
      )
    )
    (drop
      (struct.get $struct 0
        (ref.null $struct)
      )
    )
  )
)

(module
  ;; CHECK:      (type $struct (struct_subtype (field f32) data))
  (type $struct (struct f32))
  ;; CHECK:      (type $f32_=>_none (func_subtype (param f32) func))

  ;; CHECK:      (func $test (type $f32_=>_none) (param $f f32)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.new_with_rtt $struct
  ;; CHECK-NEXT:    (local.get $f)
  ;; CHECK-NEXT:    (rtt.canon $struct)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.get $struct 0
  ;; CHECK-NEXT:    (ref.null $struct)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $test (param $f f32)
    ;; The value given is not a constant, and so we cannot optimize.
    (drop
      (struct.new_with_rtt $struct
        (local.get $f)
        (rtt.canon $struct)
      )
    )
    (drop
      (struct.get $struct 0
        (ref.null $struct)
      )
    )
  )
)

;; Create in one function, get in another. The 10 should be forwarded to the
;; get.
(module
  ;; CHECK:      (type $none_=>_none (func_subtype func))

  ;; CHECK:      (type $struct (struct_subtype (field i32) data))
  (type $struct (struct i32))
  ;; CHECK:      (func $create (type $none_=>_none)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.new_with_rtt $struct
  ;; CHECK-NEXT:    (i32.const 10)
  ;; CHECK-NEXT:    (rtt.canon $struct)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $create
    (drop
      (struct.new_with_rtt $struct
        (i32.const 10)
        (rtt.canon $struct)
      )
    )
  )
  ;; CHECK:      (func $get (type $none_=>_none)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (block (result i32)
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (ref.as_non_null
  ;; CHECK-NEXT:      (ref.null $struct)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (i32.const 10)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $get
    (drop
      (struct.get $struct 0
        (ref.null $struct)
      )
    )
  )
)

;; As before, but with the order of functions reversed to check for any ordering
;; issues.
(module
  ;; CHECK:      (type $none_=>_none (func_subtype func))

  ;; CHECK:      (type $struct (struct_subtype (field i32) data))
  (type $struct (struct i32))

  ;; CHECK:      (func $get (type $none_=>_none)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (block (result i32)
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (ref.as_non_null
  ;; CHECK-NEXT:      (ref.null $struct)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (i32.const 10)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $get
    (drop
      (struct.get $struct 0
        (ref.null $struct)
      )
    )
  )

  ;; CHECK:      (func $create (type $none_=>_none)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.new_with_rtt $struct
  ;; CHECK-NEXT:    (i32.const 10)
  ;; CHECK-NEXT:    (rtt.canon $struct)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $create
    (drop
      (struct.new_with_rtt $struct
        (i32.const 10)
        (rtt.canon $struct)
      )
    )
  )
)

;; Different values assigned in the same function, in different struct.news,
;; so we cannot optimize the struct.get away.
(module
  ;; CHECK:      (type $struct (struct_subtype (field f32) data))
  (type $struct (struct f32))
  ;; CHECK:      (type $none_=>_none (func_subtype func))

  ;; CHECK:      (func $test (type $none_=>_none)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.new_with_rtt $struct
  ;; CHECK-NEXT:    (f32.const 42)
  ;; CHECK-NEXT:    (rtt.canon $struct)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.new_with_rtt $struct
  ;; CHECK-NEXT:    (f32.const 1337)
  ;; CHECK-NEXT:    (rtt.canon $struct)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.get $struct 0
  ;; CHECK-NEXT:    (ref.null $struct)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $test
    (drop
      (struct.new_with_rtt $struct
        (f32.const 42)
        (rtt.canon $struct)
      )
    )
    (drop
      (struct.new_with_rtt $struct
        (f32.const 1337)
        (rtt.canon $struct)
      )
    )
    (drop
      (struct.get $struct 0
        (ref.null $struct)
      )
    )
  )
)

;; Different values assigned in different functions, and one is a struct.set.
(module
  ;; CHECK:      (type $struct (struct_subtype (field (mut f32)) data))
  (type $struct (struct (mut f32)))
  ;; CHECK:      (type $none_=>_none (func_subtype func))

  ;; CHECK:      (func $create (type $none_=>_none)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.new_with_rtt $struct
  ;; CHECK-NEXT:    (f32.const 42)
  ;; CHECK-NEXT:    (rtt.canon $struct)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $create
    (drop
      (struct.new_with_rtt $struct
        (f32.const 42)
        (rtt.canon $struct)
      )
    )
  )
  ;; CHECK:      (func $set (type $none_=>_none)
  ;; CHECK-NEXT:  (struct.set $struct 0
  ;; CHECK-NEXT:   (ref.null $struct)
  ;; CHECK-NEXT:   (f32.const 1337)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $set
    (struct.set $struct 0
      (ref.null $struct)
      (f32.const 1337)
    )
  )
  ;; CHECK:      (func $get (type $none_=>_none)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.get $struct 0
  ;; CHECK-NEXT:    (ref.null $struct)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $get
    (drop
      (struct.get $struct 0
        (ref.null $struct)
      )
    )
  )
)

;; As the last testcase, but the values happen to coincide, so we can optimize
;; the get into a constant.
(module
  ;; CHECK:      (type $struct (struct_subtype (field (mut f32)) data))
  (type $struct (struct (mut f32)))
  ;; CHECK:      (type $none_=>_none (func_subtype func))

  ;; CHECK:      (func $create (type $none_=>_none)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.new_with_rtt $struct
  ;; CHECK-NEXT:    (f32.const 42)
  ;; CHECK-NEXT:    (rtt.canon $struct)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $create
    (drop
      (struct.new_with_rtt $struct
        (f32.const 42)
        (rtt.canon $struct)
      )
    )
  )
  ;; CHECK:      (func $set (type $none_=>_none)
  ;; CHECK-NEXT:  (struct.set $struct 0
  ;; CHECK-NEXT:   (ref.null $struct)
  ;; CHECK-NEXT:   (f32.const 42)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $set
    (struct.set $struct 0
      (ref.null $struct)
      (f32.const 42) ;; The last testcase had 1337 here.
    )
  )
  ;; CHECK:      (func $get (type $none_=>_none)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (block (result f32)
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (ref.as_non_null
  ;; CHECK-NEXT:      (ref.null $struct)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (f32.const 42)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $get
    (drop
      (struct.get $struct 0
        (ref.null $struct)
      )
    )
  )
)

;; Check that we look into the fallthrough value that is assigned.
(module
  ;; CHECK:      (type $struct (struct_subtype (field (mut f32)) data))
  (type $struct (struct (mut f32)))
  ;; CHECK:      (type $none_=>_none (func_subtype func))

  ;; CHECK:      (type $i32_=>_none (func_subtype (param i32) func))

  ;; CHECK:      (func $create (type $none_=>_none)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.new_with_rtt $struct
  ;; CHECK-NEXT:    (block (result f32)
  ;; CHECK-NEXT:     (nop)
  ;; CHECK-NEXT:     (f32.const 42)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (rtt.canon $struct)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $create
    (drop
      (struct.new_with_rtt $struct
        ;; Fall though a 42 via a block.
        (block (result f32)
          (nop)
          (f32.const 42)
        )
        (rtt.canon $struct)
      )
    )
  )
  ;; CHECK:      (func $set (type $i32_=>_none) (param $x i32)
  ;; CHECK-NEXT:  (struct.set $struct 0
  ;; CHECK-NEXT:   (ref.null $struct)
  ;; CHECK-NEXT:   (if (result f32)
  ;; CHECK-NEXT:    (local.get $x)
  ;; CHECK-NEXT:    (unreachable)
  ;; CHECK-NEXT:    (f32.const 42)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $set (param $x i32)
    (struct.set $struct 0
      (ref.null $struct)
      ;; Fall though a 42 via an if.
      (if (result f32)
        (local.get $x)
        (unreachable)
        (f32.const 42)
      )
    )
  )
  ;; CHECK:      (func $get (type $none_=>_none)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (block (result f32)
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (ref.as_non_null
  ;; CHECK-NEXT:      (ref.null $struct)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (f32.const 42)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $get
    (drop
      (struct.get $struct 0
        (ref.null $struct)
      )
    )
  )
)

;; Test a function reference instead of a number.
(module
  ;; CHECK:      (type $none_=>_none (func_subtype func))

  ;; CHECK:      (type $struct (struct_subtype (field funcref) data))
  (type $struct (struct funcref))
  ;; CHECK:      (elem declare func $test)

  ;; CHECK:      (func $test (type $none_=>_none)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.new_with_rtt $struct
  ;; CHECK-NEXT:    (ref.func $test)
  ;; CHECK-NEXT:    (rtt.canon $struct)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (block (result (ref $none_=>_none))
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (ref.as_non_null
  ;; CHECK-NEXT:      (ref.null $struct)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (ref.func $test)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $test
    (drop
      (struct.new_with_rtt $struct
        (ref.func $test)
        (rtt.canon $struct)
      )
    )
    (drop
      (struct.get $struct 0
        (ref.null $struct)
      )
    )
  )
)

;; Test for unreachable creations, sets, and gets.
(module
  (type $struct (struct (mut i32)))
  ;; CHECK:      (type $none_=>_none (func_subtype func))

  ;; CHECK:      (func $test (type $none_=>_none)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (block ;; (replaces something unreachable we can't emit)
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (i32.const 10)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (unreachable)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (block ;; (replaces something unreachable we can't emit)
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (unreachable)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (block ;; (replaces something unreachable we can't emit)
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (unreachable)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (i32.const 20)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $test
    (drop
      (struct.new_with_rtt $struct
        (i32.const 10)
        (unreachable)
      )
    )
    (drop
      (struct.get $struct 0
        (unreachable)
      )
    )
    (struct.set $struct 0
      (unreachable)
      (i32.const 20)
    )
  )
)

;; Subtyping: Create a supertype and get a subtype. As we never create a
;;            subtype, the get must trap anyhow (the reference it receives can
;;            only be null in this closed world).
(module
  ;; CHECK:      (type $none_=>_none (func_subtype func))

  ;; CHECK:      (type $struct (struct_subtype (field i32) data))
  (type $struct (struct i32))
  ;; CHECK:      (type $substruct (struct_subtype (field i32) $struct))
  (type $substruct (struct_subtype i32 $struct))

  ;; CHECK:      (func $create (type $none_=>_none)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.new_with_rtt $struct
  ;; CHECK-NEXT:    (i32.const 10)
  ;; CHECK-NEXT:    (rtt.canon $struct)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $create
    (drop
      (struct.new_with_rtt $struct
        (i32.const 10)
        (rtt.canon $struct)
      )
    )
  )
  ;; CHECK:      (func $get (type $none_=>_none)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (block
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (ref.null $substruct)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (unreachable)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $get
    (drop
      (struct.get $substruct 0
        (ref.null $substruct)
      )
    )
  )
)

;; As above, but in addition to a new of $struct also add a set. The set could
;; in principle be relevant for the get as far as this pass knows, and so we
;; will optimize the result to the only possible value. (In practice, though,
;; it will trap anyhow.)
(module
  ;; CHECK:      (type $struct (struct_subtype (field (mut i32)) data))
  (type $struct (struct (mut i32)))
  ;; CHECK:      (type $none_=>_none (func_subtype func))

  ;; CHECK:      (type $substruct (struct_subtype (field (mut i32)) $struct))
  (type $substruct (struct_subtype (mut i32) $struct))

  ;; CHECK:      (func $create (type $none_=>_none)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.new_with_rtt $struct
  ;; CHECK-NEXT:    (i32.const 10)
  ;; CHECK-NEXT:    (rtt.canon $struct)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (struct.set $struct 0
  ;; CHECK-NEXT:   (ref.null $struct)
  ;; CHECK-NEXT:   (i32.const 10)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $create
    (drop
      (struct.new_with_rtt $struct
        (i32.const 10)
        (rtt.canon $struct)
      )
    )
    (struct.set $struct 0
      (ref.null $struct)
      (i32.const 10)
    )
  )
  ;; CHECK:      (func $get (type $none_=>_none)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (block (result i32)
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (ref.as_non_null
  ;; CHECK-NEXT:      (ref.null $substruct)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (i32.const 10)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $get
    (drop
      (struct.get $substruct 0
        (ref.null $substruct)
      )
    )
  )
)

;; Subtyping: Create a subtype and get a supertype. The get must receive a
;;            reference to the subtype (we never create a supertype) and so we
;;            can optimize.
(module
  ;; CHECK:      (type $none_=>_none (func_subtype func))

  ;; CHECK:      (type $struct (struct_subtype (field i32) data))

  ;; CHECK:      (type $substruct (struct_subtype (field i32) (field f64) $struct))
  (type $substruct (struct_subtype i32 f64 $struct))

  (type $struct (struct i32))

  ;; CHECK:      (func $create (type $none_=>_none)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.new_with_rtt $substruct
  ;; CHECK-NEXT:    (i32.const 10)
  ;; CHECK-NEXT:    (f64.const 3.14159)
  ;; CHECK-NEXT:    (rtt.canon $substruct)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $create
    (drop
      (struct.new_with_rtt $substruct
        (i32.const 10)
        (f64.const 3.14159)
        (rtt.canon $substruct)
      )
    )
  )
  ;; CHECK:      (func $get (type $none_=>_none)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (block (result i32)
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (ref.as_non_null
  ;; CHECK-NEXT:      (ref.null $struct)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (i32.const 10)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $get
    (drop
      (struct.get $struct 0
        (ref.null $struct)
      )
    )
  )
)

;; Subtyping: Create both a subtype and a supertype, with identical constants
;;            for the shared field, and get the supertype.
(module
  ;; CHECK:      (type $none_=>_none (func_subtype func))

  ;; CHECK:      (type $struct (struct_subtype (field i32) data))
  (type $struct (struct i32))
  ;; CHECK:      (type $substruct (struct_subtype (field i32) (field f64) $struct))
  (type $substruct (struct_subtype i32 f64 $struct))

  ;; CHECK:      (func $create (type $none_=>_none)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.new_with_rtt $struct
  ;; CHECK-NEXT:    (i32.const 10)
  ;; CHECK-NEXT:    (rtt.canon $struct)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.new_with_rtt $substruct
  ;; CHECK-NEXT:    (i32.const 10)
  ;; CHECK-NEXT:    (f64.const 3.14159)
  ;; CHECK-NEXT:    (rtt.canon $substruct)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $create
    (drop
      (struct.new_with_rtt $struct
        (i32.const 10)
        (rtt.canon $struct)
      )
    )
    (drop
      (struct.new_with_rtt $substruct
        (i32.const 10)
        (f64.const 3.14159)
        (rtt.canon $substruct)
      )
    )
  )
  ;; CHECK:      (func $get (type $none_=>_none)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (block (result i32)
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (ref.as_non_null
  ;; CHECK-NEXT:      (ref.null $struct)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (i32.const 10)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $get
    (drop
      (struct.get $struct 0
        (ref.null $struct)
      )
    )
  )
)

;; Subtyping: Create both a subtype and a supertype, with different constants
;;            for the shared field, preventing optimization, as a get of the
;;            supertype may receive an instance of the subtype.
(module
  ;; CHECK:      (type $struct (struct_subtype (field i32) data))
  (type $struct (struct i32))
  ;; CHECK:      (type $none_=>_none (func_subtype func))

  ;; CHECK:      (type $substruct (struct_subtype (field i32) (field f64) $struct))
  (type $substruct (struct_subtype i32 f64 $struct))

  ;; CHECK:      (func $create (type $none_=>_none)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.new_with_rtt $struct
  ;; CHECK-NEXT:    (i32.const 10)
  ;; CHECK-NEXT:    (rtt.canon $struct)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.new_with_rtt $substruct
  ;; CHECK-NEXT:    (i32.const 20)
  ;; CHECK-NEXT:    (f64.const 3.14159)
  ;; CHECK-NEXT:    (rtt.canon $substruct)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $create
    (drop
      (struct.new_with_rtt $struct
        (i32.const 10)
        (rtt.canon $struct)
      )
    )
    (drop
      (struct.new_with_rtt $substruct
        (i32.const 20)
        (f64.const 3.14159)
        (rtt.canon $substruct)
      )
    )
  )
  ;; CHECK:      (func $get (type $none_=>_none)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.get $struct 0
  ;; CHECK-NEXT:    (ref.null $struct)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $get
    (drop
      (struct.get $struct 0
        (ref.null $struct)
      )
    )
  )
)

;; Subtyping: Create both a subtype and a supertype, with different constants
;;            for the shared field, but get from the subtype. The field is
;;            shared between the types, but we only create the substruct with
;;            one value, so we can optimize.
(module
  ;; CHECK:      (type $none_=>_none (func_subtype func))

  ;; CHECK:      (type $struct (struct_subtype (field i32) data))

  ;; CHECK:      (type $substruct (struct_subtype (field i32) (field f64) $struct))
  (type $substruct (struct_subtype i32 f64 $struct))

  (type $struct (struct i32))

  ;; CHECK:      (func $create (type $none_=>_none)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.new_with_rtt $struct
  ;; CHECK-NEXT:    (i32.const 10)
  ;; CHECK-NEXT:    (rtt.canon $struct)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.new_with_rtt $substruct
  ;; CHECK-NEXT:    (i32.const 20)
  ;; CHECK-NEXT:    (f64.const 3.14159)
  ;; CHECK-NEXT:    (rtt.canon $substruct)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $create
    (drop
      (struct.new_with_rtt $struct
        (i32.const 10)
        (rtt.canon $struct)
      )
    )
    (drop
      (struct.new_with_rtt $substruct
        (i32.const 20)
        (f64.const 3.14159)
        (rtt.canon $substruct)
      )
    )
  )
  ;; CHECK:      (func $get (type $none_=>_none)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (block (result i32)
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (ref.as_non_null
  ;; CHECK-NEXT:      (ref.null $substruct)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (i32.const 20)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $get
    (drop
      (struct.get $substruct 0
        (ref.null $substruct)
      )
    )
  )
)

;; As above, but add a set of $struct. The set prevents the optimization.
(module
  ;; CHECK:      (type $struct (struct_subtype (field (mut i32)) data))
  (type $struct (struct (mut i32)))

  ;; CHECK:      (type $substruct (struct_subtype (field (mut i32)) (field f64) $struct))
  (type $substruct (struct_subtype (mut i32) f64 $struct))

  ;; CHECK:      (type $none_=>_none (func_subtype func))

  ;; CHECK:      (func $create (type $none_=>_none)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.new_with_rtt $struct
  ;; CHECK-NEXT:    (i32.const 10)
  ;; CHECK-NEXT:    (rtt.canon $struct)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (struct.set $struct 0
  ;; CHECK-NEXT:   (ref.null $struct)
  ;; CHECK-NEXT:   (i32.const 10)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.new_with_rtt $substruct
  ;; CHECK-NEXT:    (i32.const 20)
  ;; CHECK-NEXT:    (f64.const 3.14159)
  ;; CHECK-NEXT:    (rtt.canon $substruct)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $create
    (drop
      (struct.new_with_rtt $struct
        (i32.const 10)
        (rtt.canon $struct)
      )
    )
    (struct.set $struct 0
      (ref.null $struct)
      (i32.const 10)
    )
    (drop
      (struct.new_with_rtt $substruct
        (i32.const 20)
        (f64.const 3.14159)
        (rtt.canon $substruct)
      )
    )
  )
  ;; CHECK:      (func $get (type $none_=>_none)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.get $substruct 0
  ;; CHECK-NEXT:    (ref.null $substruct)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $get
    (drop
      (struct.get $substruct 0
        (ref.null $substruct)
      )
    )
  )
)

;; Multi-level subtyping, check that we propagate not just to the immediate
;; supertype but all the way as needed.
(module
  ;; CHECK:      (type $struct1 (struct_subtype (field i32) data))

  ;; CHECK:      (type $struct2 (struct_subtype (field i32) (field f64) $struct1))

  ;; CHECK:      (type $struct3 (struct_subtype (field i32) (field f64) (field anyref) $struct2))
  (type $struct3 (struct_subtype i32 f64 anyref $struct2))

  (type $struct2 (struct_subtype i32 f64 $struct1))

  (type $struct1 (struct i32))

  ;; CHECK:      (type $none_=>_none (func_subtype func))

  ;; CHECK:      (func $create (type $none_=>_none)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.new_with_rtt $struct3
  ;; CHECK-NEXT:    (i32.const 20)
  ;; CHECK-NEXT:    (f64.const 3.14159)
  ;; CHECK-NEXT:    (ref.null any)
  ;; CHECK-NEXT:    (rtt.canon $struct3)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $create
    (drop
      (struct.new_with_rtt $struct3
        (i32.const 20)
        (f64.const 3.14159)
        (ref.null any)
        (rtt.canon $struct3)
      )
    )
  )
  ;; CHECK:      (func $get (type $none_=>_none)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (block (result i32)
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (ref.as_non_null
  ;; CHECK-NEXT:      (ref.null $struct1)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (i32.const 20)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (block (result i32)
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (ref.as_non_null
  ;; CHECK-NEXT:      (ref.null $struct2)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (i32.const 20)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (block (result f64)
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (ref.as_non_null
  ;; CHECK-NEXT:      (ref.null $struct2)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (f64.const 3.14159)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (block (result i32)
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (ref.as_non_null
  ;; CHECK-NEXT:      (ref.null $struct3)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (i32.const 20)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (block (result f64)
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (ref.as_non_null
  ;; CHECK-NEXT:      (ref.null $struct3)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (f64.const 3.14159)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (block (result anyref)
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (ref.as_non_null
  ;; CHECK-NEXT:      (ref.null $struct3)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (ref.null any)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $get
    ;; Get field 0 from the $struct1. This can be optimized to a constant
    ;; since we only ever created an instance of struct3 with a constant there.
    (drop
      (struct.get $struct1 0
        (ref.null $struct1)
      )
    )
    ;; Get both fields of $struct2.
    (drop
      (struct.get $struct2 0
        (ref.null $struct2)
      )
    )
    (drop
      (struct.get $struct2 1
        (ref.null $struct2)
      )
    )
    ;; Get all 3 fields of $struct3
    (drop
      (struct.get $struct3 0
        (ref.null $struct3)
      )
    )
    (drop
      (struct.get $struct3 1
        (ref.null $struct3)
      )
    )
    (drop
      (struct.get $struct3 2
        (ref.null $struct3)
      )
    )
  )
)

;; Multi-level subtyping with conflicts. The even-numbered fields will get
;; different values in the sub-most type. Create the top and bottom types, but
;; not the middle one.
(module
  ;; CHECK:      (type $struct1 (struct_subtype (field i32) (field i32) data))

  ;; CHECK:      (type $struct2 (struct_subtype (field i32) (field i32) (field f64) (field f64) $struct1))

  ;; CHECK:      (type $struct3 (struct_subtype (field i32) (field i32) (field f64) (field f64) (field anyref) (field anyref) $struct2))
  (type $struct3 (struct_subtype i32 i32 f64 f64 anyref anyref $struct2))

  (type $struct1 (struct i32 i32))

  (type $struct2 (struct_subtype i32 i32 f64 f64 $struct1))

  ;; CHECK:      (type $anyref_=>_none (func_subtype (param anyref) func))

  ;; CHECK:      (type $none_=>_none (func_subtype func))

  ;; CHECK:      (func $create (type $anyref_=>_none) (param $any anyref)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.new_with_rtt $struct1
  ;; CHECK-NEXT:    (i32.const 10)
  ;; CHECK-NEXT:    (i32.const 20)
  ;; CHECK-NEXT:    (rtt.canon $struct1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.new_with_rtt $struct3
  ;; CHECK-NEXT:    (i32.const 10)
  ;; CHECK-NEXT:    (i32.const 999)
  ;; CHECK-NEXT:    (f64.const 2.71828)
  ;; CHECK-NEXT:    (f64.const 9.9999999)
  ;; CHECK-NEXT:    (ref.null any)
  ;; CHECK-NEXT:    (local.get $any)
  ;; CHECK-NEXT:    (rtt.canon $struct3)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $create (param $any anyref)
    (drop
      (struct.new_with_rtt $struct1
        (i32.const 10)
        (i32.const 20)
        (rtt.canon $struct1)
      )
    )
    (drop
      (struct.new_with_rtt $struct3
        (i32.const 10)
        (i32.const 999) ;; use a different value here
        (f64.const 2.71828)
        (f64.const 9.9999999)
        (ref.null any)
        (local.get $any) ;; use a non-constant value here, which can never be
                         ;; optimized.
        (rtt.canon $struct3)
      )
    )
  )
  ;; CHECK:      (func $get (type $none_=>_none)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (block (result i32)
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (ref.as_non_null
  ;; CHECK-NEXT:      (ref.null $struct1)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (i32.const 10)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.get $struct1 1
  ;; CHECK-NEXT:    (ref.null $struct1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (block (result i32)
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (ref.as_non_null
  ;; CHECK-NEXT:      (ref.null $struct2)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (i32.const 10)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (block (result i32)
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (ref.as_non_null
  ;; CHECK-NEXT:      (ref.null $struct2)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (i32.const 999)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (block (result f64)
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (ref.as_non_null
  ;; CHECK-NEXT:      (ref.null $struct2)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (f64.const 2.71828)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (block (result f64)
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (ref.as_non_null
  ;; CHECK-NEXT:      (ref.null $struct2)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (f64.const 9.9999999)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (block (result i32)
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (ref.as_non_null
  ;; CHECK-NEXT:      (ref.null $struct3)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (i32.const 10)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (block (result i32)
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (ref.as_non_null
  ;; CHECK-NEXT:      (ref.null $struct3)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (i32.const 999)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (block (result f64)
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (ref.as_non_null
  ;; CHECK-NEXT:      (ref.null $struct3)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (f64.const 2.71828)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (block (result f64)
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (ref.as_non_null
  ;; CHECK-NEXT:      (ref.null $struct3)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (f64.const 9.9999999)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (block (result anyref)
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (ref.as_non_null
  ;; CHECK-NEXT:      (ref.null $struct3)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (ref.null any)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.get $struct3 5
  ;; CHECK-NEXT:    (ref.null $struct3)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $get
    ;; Get all the fields of all the structs.
    (drop
      (struct.get $struct1 0
        (ref.null $struct1)
      )
    )
    (drop
      (struct.get $struct1 1
        (ref.null $struct1)
      )
    )
    (drop
      (struct.get $struct2 0
        (ref.null $struct2)
      )
    )
    (drop
      (struct.get $struct2 1
        (ref.null $struct2)
      )
    )
    (drop
      (struct.get $struct2 2
        (ref.null $struct2)
      )
    )
    (drop
      (struct.get $struct2 3
        (ref.null $struct2)
      )
    )
    (drop
      (struct.get $struct3 0
        (ref.null $struct3)
      )
    )
    (drop
      (struct.get $struct3 1
        (ref.null $struct3)
      )
    )
    (drop
      (struct.get $struct3 2
        (ref.null $struct3)
      )
    )
    (drop
      (struct.get $struct3 3
        (ref.null $struct3)
      )
    )
    (drop
      (struct.get $struct3 4
        (ref.null $struct3)
      )
    )
    (drop
      (struct.get $struct3 5
        (ref.null $struct3)
      )
    )
  )
)

;; Multi-level subtyping with a different value in the middle of the chain. We
;; can only optimize $struct3.
(module
  ;; CHECK:      (type $struct1 (struct_subtype (field (mut i32)) data))
  (type $struct1 (struct (mut i32)))
  ;; CHECK:      (type $struct2 (struct_subtype (field (mut i32)) (field f64) $struct1))
  (type $struct2 (struct_subtype (mut i32) f64 $struct1))
  ;; CHECK:      (type $none_=>_none (func_subtype func))

  ;; CHECK:      (type $struct3 (struct_subtype (field (mut i32)) (field f64) (field anyref) $struct2))
  (type $struct3 (struct_subtype (mut i32) f64 anyref $struct2))

  ;; CHECK:      (func $create (type $none_=>_none)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.new_with_rtt $struct1
  ;; CHECK-NEXT:    (i32.const 10)
  ;; CHECK-NEXT:    (rtt.canon $struct1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.new_with_rtt $struct2
  ;; CHECK-NEXT:    (i32.const 9999)
  ;; CHECK-NEXT:    (f64.const 0)
  ;; CHECK-NEXT:    (rtt.canon $struct2)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.new_with_rtt $struct3
  ;; CHECK-NEXT:    (i32.const 10)
  ;; CHECK-NEXT:    (f64.const 0)
  ;; CHECK-NEXT:    (ref.null any)
  ;; CHECK-NEXT:    (rtt.canon $struct3)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $create
    (drop
      (struct.new_with_rtt $struct1
        (i32.const 10)
        (rtt.canon $struct1)
      )
    )
    (drop
      (struct.new_with_rtt $struct2
        (i32.const 9999) ;; use a different value here
        (f64.const 0)
        (rtt.canon $struct2)
      )
    )
    (drop
      (struct.new_with_rtt $struct3
        (i32.const 10)
        (f64.const 0)
        (ref.null any)
        (rtt.canon $struct3)
      )
    )
  )
  ;; CHECK:      (func $get (type $none_=>_none)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.get $struct1 0
  ;; CHECK-NEXT:    (ref.null $struct1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.get $struct2 0
  ;; CHECK-NEXT:    (ref.null $struct2)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (block (result i32)
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (ref.as_non_null
  ;; CHECK-NEXT:      (ref.null $struct3)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (i32.const 10)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $get
    ;; Get field 0 in all the types.
    (drop
      (struct.get $struct1 0
        (ref.null $struct1)
      )
    )
    (drop
      (struct.get $struct2 0
        (ref.null $struct2)
      )
    )
    (drop
      (struct.get $struct3 0
        (ref.null $struct3)
      )
    )
  )
)

;; As above, but add not just a new of the middle class with a different value
;; but also a set. That prevents all optimizations.
(module
  ;; CHECK:      (type $struct1 (struct_subtype (field (mut i32)) data))

  ;; CHECK:      (type $struct2 (struct_subtype (field (mut i32)) (field f64) $struct1))
  (type $struct2 (struct_subtype (mut i32) f64 $struct1))

  (type $struct1 (struct (mut i32)))

  ;; CHECK:      (type $struct3 (struct_subtype (field (mut i32)) (field f64) (field anyref) $struct2))
  (type $struct3 (struct_subtype (mut i32) f64 anyref $struct2))

  ;; CHECK:      (type $none_=>_none (func_subtype func))

  ;; CHECK:      (func $create (type $none_=>_none)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.new_with_rtt $struct1
  ;; CHECK-NEXT:    (i32.const 10)
  ;; CHECK-NEXT:    (rtt.canon $struct1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.new_with_rtt $struct2
  ;; CHECK-NEXT:    (i32.const 9999)
  ;; CHECK-NEXT:    (f64.const 0)
  ;; CHECK-NEXT:    (rtt.canon $struct2)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (struct.set $struct2 0
  ;; CHECK-NEXT:   (ref.null $struct2)
  ;; CHECK-NEXT:   (i32.const 9999)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.new_with_rtt $struct3
  ;; CHECK-NEXT:    (i32.const 10)
  ;; CHECK-NEXT:    (f64.const 0)
  ;; CHECK-NEXT:    (ref.null any)
  ;; CHECK-NEXT:    (rtt.canon $struct3)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $create
    (drop
      (struct.new_with_rtt $struct1
        (i32.const 10)
        (rtt.canon $struct1)
      )
    )
    (drop
      (struct.new_with_rtt $struct2
        (i32.const 9999) ;; use a different value here
        (f64.const 0)
        (rtt.canon $struct2)
      )
    )
    (struct.set $struct2 0
      (ref.null $struct2)
      (i32.const 9999) ;; use a different value here
      (f64.const 0)
    )
    (drop
      (struct.new_with_rtt $struct3
        (i32.const 10)
        (f64.const 0)
        (ref.null any)
        (rtt.canon $struct3)
      )
    )
  )
  ;; CHECK:      (func $get (type $none_=>_none)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.get $struct1 0
  ;; CHECK-NEXT:    (ref.null $struct1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.get $struct2 0
  ;; CHECK-NEXT:    (ref.null $struct2)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.get $struct3 0
  ;; CHECK-NEXT:    (ref.null $struct3)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $get
    ;; Get field 0 in all the types.
    (drop
      (struct.get $struct1 0
        (ref.null $struct1)
      )
    )
    (drop
      (struct.get $struct2 0
        (ref.null $struct2)
      )
    )
    (drop
      (struct.get $struct3 0
        (ref.null $struct3)
      )
    )
  )
)

;; Test for a struct with multiple fields, some of which are constant and hence
;; optimizable, and some not. Also test that some have the same type.
(module
  ;; CHECK:      (type $struct (struct_subtype (field i32) (field f64) (field i32) (field f64) (field i32) data))
  (type $struct (struct i32 f64 i32 f64 i32))

  ;; CHECK:      (type $none_=>_none (func_subtype func))

  ;; CHECK:      (func $create (type $none_=>_none)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.new_with_rtt $struct
  ;; CHECK-NEXT:    (i32.eqz
  ;; CHECK-NEXT:     (i32.const 10)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (f64.const 3.14159)
  ;; CHECK-NEXT:    (i32.const 20)
  ;; CHECK-NEXT:    (f64.abs
  ;; CHECK-NEXT:     (f64.const 2.71828)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:    (rtt.canon $struct)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $create
    (drop
      (struct.new_with_rtt $struct
        (i32.eqz (i32.const 10)) ;; not a constant (as far as this pass knows)
        (f64.const 3.14159)
        (i32.const 20)
        (f64.abs (f64.const 2.71828)) ;; not a constant
        (i32.const 30)
        (rtt.canon $struct)
      )
    )
  )
  ;; CHECK:      (func $get (type $none_=>_none)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.get $struct 0
  ;; CHECK-NEXT:    (ref.null $struct)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (block (result f64)
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (ref.as_non_null
  ;; CHECK-NEXT:      (ref.null $struct)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (f64.const 3.14159)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (block (result i32)
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (ref.as_non_null
  ;; CHECK-NEXT:      (ref.null $struct)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (i32.const 20)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.get $struct 3
  ;; CHECK-NEXT:    (ref.null $struct)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (block (result i32)
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (ref.as_non_null
  ;; CHECK-NEXT:      (ref.null $struct)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (block (result i32)
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (ref.as_non_null
  ;; CHECK-NEXT:      (ref.null $struct)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $get
    (drop
      (struct.get $struct 0
        (ref.null $struct)
      )
    )
    (drop
      (struct.get $struct 1
        (ref.null $struct)
      )
    )
    (drop
      (struct.get $struct 2
        (ref.null $struct)
      )
    )
    (drop
      (struct.get $struct 3
        (ref.null $struct)
      )
    )
    (drop
      (struct.get $struct 4
        (ref.null $struct)
      )
    )
    ;; Also test for multiple gets of the same field.
    (drop
      (struct.get $struct 4
        (ref.null $struct)
      )
    )
  )
)

;; Never create A, but have a set to its field. A subtype B has no creates nor
;; sets, and the final subtype C has a create and a get. The set to A should
;; apply to it, preventing optimization.
(module
  ;; CHECK:      (type $A (struct_subtype (field (mut i32)) data))

  ;; CHECK:      (type $B (struct_subtype (field (mut i32)) $A))

  ;; CHECK:      (type $C (struct_subtype (field (mut i32)) $B))
  (type $C (struct_subtype (mut i32) $B))

  (type $A (struct (mut i32)))

  (type $B (struct_subtype (mut i32) $A))

  ;; CHECK:      (type $none_=>_none (func_subtype func))

  ;; CHECK:      (type $ref|$A|_=>_none (func_subtype (param (ref $A)) func))

  ;; CHECK:      (type $ref|$C|_=>_none (func_subtype (param (ref $C)) func))

  ;; CHECK:      (func $create (type $none_=>_none)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.new_with_rtt $C
  ;; CHECK-NEXT:    (i32.const 10)
  ;; CHECK-NEXT:    (rtt.canon $C)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $create
    (drop
      (struct.new_with_rtt $C
        (i32.const 10)
        (rtt.canon $C)
      )
    )
  )
  ;; CHECK:      (func $set (type $ref|$A|_=>_none) (param $a (ref $A))
  ;; CHECK-NEXT:  (struct.set $A 0
  ;; CHECK-NEXT:   (local.get $a)
  ;; CHECK-NEXT:   (i32.const 20)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $set (param $a (ref $A))
    (struct.set $A 0
      (local.get $a)
      (i32.const 20)
    )
  )
  ;; CHECK:      (func $get (type $ref|$C|_=>_none) (param $c (ref $C))
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.get $C 0
  ;; CHECK-NEXT:    (local.get $c)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $get (param $c (ref $C))
    (drop
      (struct.get $C 0
        (local.get $c)
      )
    )
  )
)

;; Copies of a field to itself can be ignored. As a result, we can optimize both
;; of the gets here.
(module
  ;; CHECK:      (type $struct (struct_subtype (field (mut i32)) data))
  (type $struct (struct (mut i32)))

  ;; CHECK:      (type $none_=>_none (func_subtype func))

  ;; CHECK:      (func $test (type $none_=>_none)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.new_default_with_rtt $struct
  ;; CHECK-NEXT:    (rtt.canon $struct)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (struct.set $struct 0
  ;; CHECK-NEXT:   (ref.null $struct)
  ;; CHECK-NEXT:   (block (result i32)
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (ref.as_non_null
  ;; CHECK-NEXT:      (ref.null $struct)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (block (result i32)
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (ref.as_non_null
  ;; CHECK-NEXT:      (ref.null $struct)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $test
    (drop
      (struct.new_default_with_rtt $struct
        (rtt.canon $struct)
      )
    )
    ;; This copy does not actually introduce any new possible values, and so it
    ;; remains true that the only possible value is the default.
    (struct.set $struct 0
      (ref.null $struct)
      (struct.get $struct 0
        (ref.null $struct)
      )
    )
    (drop
      (struct.get $struct 0
        (ref.null $struct)
      )
    )
  )
)

;; Test of a near-copy, of a similar looking field (same index, and same field
;; type) but in a different struct.
(module
  ;; CHECK:      (type $struct (struct_subtype (field (mut f32)) (field (mut i32)) data))
  (type $struct (struct (mut f32) (mut i32)))
  ;; CHECK:      (type $none_=>_none (func_subtype func))

  ;; CHECK:      (type $other (struct_subtype (field (mut f64)) (field (mut i32)) data))
  (type $other (struct (mut f64) (mut i32)))

  ;; CHECK:      (func $test (type $none_=>_none)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.new_default_with_rtt $struct
  ;; CHECK-NEXT:    (rtt.canon $struct)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (struct.set $struct 1
  ;; CHECK-NEXT:   (ref.null $struct)
  ;; CHECK-NEXT:   (block
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (ref.null $other)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (unreachable)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.get $struct 1
  ;; CHECK-NEXT:    (ref.null $struct)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $test
    (drop
      (struct.new_default_with_rtt $struct
        (rtt.canon $struct)
      )
    )
    ;; As this is not a copy, we cannot optimize struct.1's get lower down.
    (struct.set $struct 1
      (ref.null $struct)
      (struct.get $other 1
        (ref.null $other)
      )
    )
    (drop
      (struct.get $struct 1
        (ref.null $struct)
      )
    )
  )
)

;; Test of a near-copy, of a different index.
(module
  ;; CHECK:      (type $struct (struct_subtype (field (mut i32)) (field (mut i32)) data))
  (type $struct (struct (mut i32) (mut i32)))

  ;; CHECK:      (type $none_=>_none (func_subtype func))

  ;; CHECK:      (func $test (type $none_=>_none)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.new_default_with_rtt $struct
  ;; CHECK-NEXT:    (rtt.canon $struct)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (struct.set $struct 0
  ;; CHECK-NEXT:   (ref.null $struct)
  ;; CHECK-NEXT:   (block (result i32)
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (ref.as_non_null
  ;; CHECK-NEXT:      (ref.null $struct)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.get $struct 0
  ;; CHECK-NEXT:    (ref.null $struct)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $test
    (drop
      (struct.new_default_with_rtt $struct
        (rtt.canon $struct)
      )
    )
    ;; As this is not a copy, we cannot optimize struct.0's get lower down.
    (struct.set $struct 0
      (ref.null $struct)
      (struct.get $struct 1
        (ref.null $struct)
      )
    )
    (drop
      (struct.get $struct 0
        (ref.null $struct)
      )
    )
  )
)

(module
  ;; CHECK:      (type $struct (struct_subtype (field i32) data))
  (type $struct (struct i32))

  ;; CHECK:      (type $none_=>_none (func_subtype func))

  ;; CHECK:      (global $global i32 (i32.const 42))
  (global $global i32 (i32.const 42))

  ;; CHECK:      (func $test (type $none_=>_none)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.new $struct
  ;; CHECK-NEXT:    (global.get $global)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (block (result i32)
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (ref.as_non_null
  ;; CHECK-NEXT:      (ref.null $struct)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (global.get $global)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $test
    ;; An immutable global is the only thing written to this field, so we can
    ;; propagate the value to the struct.get and replace it with a global.get.
    (drop
      (struct.new $struct
        (global.get $global)
      )
    )
    (drop
      (struct.get $struct 0
        (ref.null $struct)
      )
    )
  )
)

(module
  ;; CHECK:      (type $struct (struct_subtype (field i32) data))
  (type $struct (struct i32))

  ;; CHECK:      (type $none_=>_none (func_subtype func))

  ;; CHECK:      (global $global (mut i32) (i32.const 42))
  (global $global (mut i32) (i32.const 42))

  ;; CHECK:      (func $test (type $none_=>_none)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.new $struct
  ;; CHECK-NEXT:    (global.get $global)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.get $struct 0
  ;; CHECK-NEXT:    (ref.null $struct)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $test
    ;; As above, but the global is *not* immutable, so we cannot optimize.
    (drop
      (struct.new $struct
        (global.get $global)
      )
    )
    (drop
      (struct.get $struct 0
        (ref.null $struct)
      )
    )
  )
)

(module
  ;; CHECK:      (type $struct (struct_subtype (field (mut i32)) data))
  (type $struct (struct (mut i32)))

  ;; CHECK:      (type $none_=>_none (func_subtype func))

  ;; CHECK:      (global $global i32 (i32.const 42))
  (global $global i32 (i32.const 42))

  ;; CHECK:      (func $test (type $none_=>_none)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.new $struct
  ;; CHECK-NEXT:    (global.get $global)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (struct.set $struct 0
  ;; CHECK-NEXT:   (ref.null $struct)
  ;; CHECK-NEXT:   (global.get $global)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (block (result i32)
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (ref.as_non_null
  ;; CHECK-NEXT:      (ref.null $struct)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (global.get $global)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $test
    (drop
      (struct.new $struct
        (global.get $global)
      )
    )
    ;; As above, but there is another set of the field. It is the same, though,
    ;; so that is fine. Also, the struct's field is now mutable as well to allow
    ;; that, and that also does not prevent optimization.
    (struct.set $struct 0
      (ref.null $struct)
      (global.get $global)
    )
    (drop
      (struct.get $struct 0
        (ref.null $struct)
      )
    )
  )
)

(module
  ;; CHECK:      (type $struct (struct_subtype (field (mut i32)) data))
  (type $struct (struct (mut i32)))

  ;; CHECK:      (type $none_=>_none (func_subtype func))

  ;; CHECK:      (global $global i32 (i32.const 42))
  (global $global i32 (i32.const 42))
  ;; CHECK:      (global $global-2 i32 (i32.const 1337))
  (global $global-2 i32 (i32.const 1337))

  ;; CHECK:      (func $test (type $none_=>_none)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.new $struct
  ;; CHECK-NEXT:    (global.get $global)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (struct.set $struct 0
  ;; CHECK-NEXT:   (ref.null $struct)
  ;; CHECK-NEXT:   (global.get $global-2)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.get $struct 0
  ;; CHECK-NEXT:    (ref.null $struct)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $test
    (drop
      (struct.new $struct
        (global.get $global)
      )
    )
    ;; As above, but set a different global, which prevents optimization.
    (struct.set $struct 0
      (ref.null $struct)
      (global.get $global-2)
    )
    (drop
      (struct.get $struct 0
        (ref.null $struct)
      )
    )
  )
)

(module
  ;; CHECK:      (type $struct (struct_subtype (field (mut i32)) data))
  (type $struct (struct (mut i32)))

  ;; CHECK:      (type $none_=>_none (func_subtype func))

  ;; CHECK:      (global $global i32 (i32.const 42))
  (global $global i32 (i32.const 42))
  ;; CHECK:      (global $global-2 i32 (i32.const 1337))
  (global $global-2 i32 (i32.const 1337))

  ;; CHECK:      (func $test (type $none_=>_none)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.new $struct
  ;; CHECK-NEXT:    (global.get $global)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (struct.set $struct 0
  ;; CHECK-NEXT:   (ref.null $struct)
  ;; CHECK-NEXT:   (i32.const 1337)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.get $struct 0
  ;; CHECK-NEXT:    (ref.null $struct)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $test
    (drop
      (struct.new $struct
        (global.get $global)
      )
    )
    ;; As above, but set a constant, which means we are mixing constants with
    ;; globals, which prevents the optimization.
    (struct.set $struct 0
      (ref.null $struct)
      (i32.const 1337)
    )
    (drop
      (struct.get $struct 0
        (ref.null $struct)
      )
    )
  )
)

(module
  ;; Test a global type other than i32. Arrays of structs are a realistic case
  ;; as they are used to implement itables.

  ;; CHECK:      (type $vtable (struct_subtype (field funcref) data))
  (type $vtable (struct funcref))

  ;; CHECK:      (type $itable (array_subtype (ref $vtable) data))
  (type $itable (array (ref $vtable)))

  ;; CHECK:      (type $object (struct_subtype (field $itable (ref $itable)) data))
  (type $object (struct (field $itable (ref $itable))))

  ;; CHECK:      (type $none_=>_funcref (func_subtype (result funcref) func))

  ;; CHECK:      (global $global (ref $itable) (array.init_static $itable
  ;; CHECK-NEXT:  (struct.new $vtable
  ;; CHECK-NEXT:   (ref.null func)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (struct.new $vtable
  ;; CHECK-NEXT:   (ref.func $test)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: ))
  (global $global (ref $itable) (array.init_static $itable
    (struct.new $vtable
      (ref.null func)
    )
    (struct.new $vtable
      (ref.func $test)
    )
  ))

  ;; CHECK:      (func $test (type $none_=>_funcref) (result funcref)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.new $object
  ;; CHECK-NEXT:    (global.get $global)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (struct.get $vtable 0
  ;; CHECK-NEXT:   (array.get $itable
  ;; CHECK-NEXT:    (block (result (ref $itable))
  ;; CHECK-NEXT:     (drop
  ;; CHECK-NEXT:      (ref.as_non_null
  ;; CHECK-NEXT:       (ref.null $object)
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (global.get $global)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $test (result funcref)
    (drop
      (struct.new $object
        (global.get $global)
      )
    )
    ;; Realistic usage of an itable: read an item from it, then a func from
    ;; that, and return the value (all verifying that the types are correct
    ;; after optimization). Note how after optimization everything is lined up
    ;; so that precompute-propagate can infer from the global.get the specific
    ;; object the array.get is on, allowing us to emit a constant value for the
    ;; outer struct.get in principle.
    (struct.get $vtable 0
      (array.get $itable
        (struct.get $object $itable
          (ref.null $object)
        )
        (i32.const 1)
      )
    )
  )
)

