#!/usr/bin/env python
# -*- coding: utf-8 -*-
# generated by wxGlade 0.6.3 on Wed Jun 17 23:30:23 2009

import wx

# begin wxGlade: extracode
# end wxGlade



class Pref_PubMed_Base(wx.Panel):
    def __init__(self, *args, **kwds):
        # begin wxGlade: Pref_PubMed_Base.__init__
        kwds["style"] = wx.TAB_TRAVERSAL
        wx.Panel.__init__(self, *args, **kwds)
        self.label_3 = wx.StaticText(self, -1, _("Preferred PubMed site and connection settings"))
        self.label_1 = wx.StaticText(self, -1, _("PubMed eutils site"))
        self.text_ctrl_pubmed = wx.TextCtrl(self, -1, _("http://eutils.ncbi.nlm.nih.gov/entrez/eutils"))
        self.label_5 = wx.StaticText(self, -1, _("PubMed view site"))
        self.text_ctrl_view = wx.TextCtrl(self, -1, _("http://view.ncbi.nlm.nih.gov/pubmed"))
        self.label_2 = wx.StaticText(self, -1, _("Proxy settings"))
        self.radio_box_proxy = wx.RadioBox(self, -1, "", choices=[_("System parameters"), _("Manual settings")], majorDimension=1, style=wx.RA_SPECIFY_ROWS)
        self.text_ctrl_proxy = wx.TextCtrl(self, -1, "")
        self.label_4 = wx.StaticText(self, -1, _("Exemple of proxy settings: http://www.someproxy.com:3128"))

        self.__set_properties()
        self.__do_layout()

        self.Bind(wx.EVT_RADIOBOX, self.onProxy, self.radio_box_proxy)
        # end wxGlade

    def __set_properties(self):
        # begin wxGlade: Pref_PubMed_Base.__set_properties
        self.label_3.SetFont(wx.Font(14, wx.SWISS, wx.NORMAL, wx.BOLD, 0, ""))
        self.radio_box_proxy.SetSelection(0)
        self.text_ctrl_proxy.Enable(False)
        # end wxGlade

    def __do_layout(self):
        # begin wxGlade: Pref_PubMed_Base.__do_layout
        sizer_1 = wx.BoxSizer(wx.VERTICAL)
        grid_sizer_1 = wx.FlexGridSizer(3, 2, 10, 5)
        sizer_1_copy = wx.BoxSizer(wx.VERTICAL)
        sizer_1.Add(self.label_3, 0, wx.ALL|wx.ALIGN_CENTER_HORIZONTAL, 10)
        grid_sizer_1.Add(self.label_1, 0, wx.ALIGN_CENTER_VERTICAL, 0)
        grid_sizer_1.Add(self.text_ctrl_pubmed, 0, wx.EXPAND, 0)
        grid_sizer_1.Add(self.label_5, 0, wx.ALIGN_CENTER_VERTICAL, 0)
        grid_sizer_1.Add(self.text_ctrl_view, 0, wx.EXPAND, 0)
        grid_sizer_1.Add(self.label_2, 0, wx.RIGHT|wx.ALIGN_CENTER_VERTICAL, 5)
        sizer_1_copy.Add(self.radio_box_proxy, 0, 0, 0)
        sizer_1_copy.Add(self.text_ctrl_proxy, 0, wx.EXPAND, 0)
        sizer_1_copy.Add(self.label_4, 0, wx.TOP, 5)
        grid_sizer_1.Add(sizer_1_copy, 1, wx.EXPAND, 0)
        grid_sizer_1.AddGrowableCol(1)
        sizer_1.Add(grid_sizer_1, 1, wx.ALL|wx.EXPAND, 5)
        self.SetSizer(sizer_1)
        sizer_1.Fit(self)
        # end wxGlade

    def onProxy(self, event): # wxGlade: Pref_PubMed_Base.<event_handler>
        self.text_ctrl_proxy.Enable( self.radio_box_proxy.GetSelection() )

# end of class Pref_PubMed_Base


class Pref_PubMed(Pref_PubMed_Base):
    def __init__(self, parent, id, (PUBMED,PUBMEDVIEW,PROXIES) ):
        Pref_PubMed_Base.__init__(self, parent, id)
        self.pubmed = PUBMED
        self.view = PUBMEDVIEW
        self.proxies = PROXIES
        self.__set_properties()
        
    def __set_properties(self):
        self.text_ctrl_pubmed.SetValue(self.pubmed)
        self.text_ctrl_view.SetValue(self.view)
        if self.proxies == None:
            self.radio_box_proxy.SetSelection(0)
            self.text_ctrl_proxy.SetValue("")
        elif self.proxies == {}:
            self.radio_box_proxy.SetSelection(1)
            self.text_ctrl_proxy.SetValue("")          
        else:
            self.radio_box_proxy.SetSelection(1)
            self.text_ctrl_proxy.SetValue(self.proxies["http"])
        self.onProxy(None)
            
    def getSettings(self):
        if self.radio_box_proxy.GetSelection() == 0:    # system proxy
            return self.text_ctrl_pubmed.GetValue(),\
                    self.text_ctrl_view.GetValue()\
                    ,None
        elif self.text_ctrl_proxy.GetValue().strip():   # manual proxy
            return self.text_ctrl_pubmed.GetValue(),\
                    self.text_ctrl_view.GetValue(),\
                    {"http":self.text_ctrl_proxy.GetValue().strip()}
        else:                                           # overwriting system proxy with no proxy
            return self.text_ctrl_pubmed.GetValue(),\
                    self.text_ctrl_view.GetValue(),\
                    {}
                    
    
# end of class Pref_PubMed


