# Copyright 2004,2005 Pierre Martineau <pmartino@users.sourceforge.net>
# This file is part of Bibus, a bibliographic database that can
# work together with OpenOffice.org to generate bibliographic indexes.
#
# Bibus is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Bibus is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Bibus; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA.
#
# -*- coding: ISO-8859-1 -*-
# generated by wxGlade 0.4cvs on Sun Mar 19 14:11:37 2006

import wx
import KeyTree,BIB

class KeyTree_Search_Base(wx.Panel):
	def __init__(self, *args, **kwds):
		# begin wxGlade: KeyTree_Search_Base.__init__
		kwds["style"] = wx.TAB_TRAVERSAL
		wx.Panel.__init__(self, *args, **kwds)
		self.sizer_3_staticbox = wx.StaticBox(self, -1, _("Display only keys like:"))
		self.keytree = KeyTree.KeyTree(self.bibus_frame, self)
		self.RestrictKey = wx.TextCtrl(self, -1, "")

		self.__set_properties()
		self.__do_layout()

		self.Bind(wx.EVT_TEXT, self.onRestrict, self.RestrictKey)
		# end wxGlade

	def __set_properties(self):
		# begin wxGlade: KeyTree_Search_Base.__set_properties
		pass
		# end wxGlade

	def __do_layout(self):
		# begin wxGlade: KeyTree_Search_Base.__do_layout
		sizer_2 = wx.BoxSizer(wx.VERTICAL)
		sizer_3 = wx.StaticBoxSizer(self.sizer_3_staticbox, wx.HORIZONTAL)
		sizer_2.Add(self.keytree, 1, wx.EXPAND, 0)
		sizer_3.Add(self.RestrictKey, 1, wx.ADJUST_MINSIZE, 0)
		sizer_2.Add(sizer_3, 0, wx.EXPAND, 0)
		self.SetAutoLayout(True)
		self.SetSizer(sizer_2)
		sizer_2.Fit(self)
		sizer_2.SetSizeHints(self)
		# end wxGlade

	def onRestrict(self, event): # wxGlade: KeyTree_Search_Base.<event_handler>
		self.keytree.restrict = self.RestrictKey.GetValue()
		self.keytree.Collapse(self.keytree.keyRef)
		self.keytree.Collapse(self.keytree.keyQueryRoot)

# end of class KeyTree_Search_Base

class KeyTree_Search(KeyTree_Search_Base):
	def __init__(self, bibus_frame, *args, **kwds):
		self.bibus_frame = bibus_frame
		KeyTree_Search_Base.__init__(self,*args, **kwds)

	def __getattr__(self,attr):
		""" When a funtion is not defined
		We try to use the function of the keytree
		This way, the KeyTree_Search looks like a keytree
		and we don't have to change the BibFrame.py code"""
		#
		return getattr(self.keytree,attr)

	def HitTest(self,pos):
		"""We must also overload the HitTest function for drag/drop of keys
		Because the function exists in panels and does not return the same
		values than in TreeCtrl
		"""
		return self.keytree.HitTest(pos)

# end of class KeyTree_Search

class Multi_KeyTree(wx.Panel):
	def __init__(self, bibus_frame, *args, **kwds):
		self.bibus_frame = bibus_frame
		# begin wxGlade: Multi_KeyTree.__init__
		kwds["style"] = wx.TAB_TRAVERSAL
		wx.Panel.__init__(self, *args, **kwds)
		self.nb_keytree = wx.Notebook(self, -1, style=0)
		self.keys_perso = KeyTree.KeyTree(self.bibus_frame, self.nb_keytree)
		self.keys_common = KeyTree.KeyTree(self.bibus_frame, self.nb_keytree)

		self.__set_properties()
		self.__do_layout()

		self.Bind(wx.EVT_NOTEBOOK_PAGE_CHANGED, self.onPageChanged, self.nb_keytree)
		# end wxGlade

	def __set_properties(self):
		# begin wxGlade: Multi_KeyTree.__set_properties
		self.nb_keytree.SetFont(wx.Font(9, wx.ROMAN, wx.NORMAL, wx.NORMAL, 0, ""))
		# end wxGlade

	def __do_layout(self):
		# begin wxGlade: Multi_KeyTree.__do_layout
		sizer_1 = wx.BoxSizer(wx.HORIZONTAL)
		self.nb_keytree.AddPage(self.keys_perso, _("Perso"))
		self.nb_keytree.AddPage(self.keys_common, _("Common"))
		sizer_1.Add(self.nb_keytree, 1, wx.EXPAND, 0)
		self.SetAutoLayout(True)
		self.SetSizer(sizer_1)
		sizer_1.Fit(self)
		sizer_1.SetSizeHints(self)
		# end wxGlade

	def __getattr__(self,attr):
		""" When a funtion is not defined
		We try to use the function of the keytree in the current page
		This way, the Mult_KeyTree looks like a keytree
		and we don't have to change the BibFrame.py code"""
		#
		return getattr(self.nb_keytree.GetCurrentPage(),attr)

	def HitTest(self,pos):
		"""We must also overload the HitTest function for drag/drop of keys
		Because the function exists in panels and does not return the same
		values than in TreeCtrl
		"""
		return self.nb_keytree.GetCurrentPage().HitTest(pos)
		
	def getGrants(self):
		return self.keys_perso.getGrants()

	def setkeytree(self):
		"""We set the keytree for all the panes"""
		#for page in xrange(self.nb_keytree.GetPageCount()):
		#	self.nb_keytree.GetPage(page).keytree.setkeytree()
		self.nb_keytree.SetPageText(0,self.bibus_frame.db.user)
		self.keys_perso.setkeytree(self.bibus_frame.db.user)
		self.nb_keytree.SetPageText(1,BIB.SHARED_NAME)
		self.keys_common.setkeytree(BIB.SHARED_DBNAME)
		# if we have rk grants we just use the shared keytree
		if self.keys_perso.getGrants() == 'rk':
			self.keys_perso.Show(False)
		# we cannot use the shared keytree since we don't have read access
		if self.keys_common.getGrants() == 'rr':
			self.keys_common.Show(False) # we thus hide it
		self.nb_keytree.SetSelection(0)
                
	def SelectUserTree(self):
		self.nb_keytree.SetSelection(0)

	def onPageChanged(self,evt):
		page = self.nb_keytree.GetPage(evt.GetSelection())
		if page.GetSelection().IsOk():
			page.KeySelect(page.GetSelection())
		else:
			page.SelectItem(page.keyAll)
			#page.KeySelect(page.keyAll)
		self.bibus_frame.set_grants()
		self.bibus_frame.set_menu(page.GetSelection())
		
