/*
Copyright &copy; 2014-2015 by Steven G. Johnson, Jiahao Chen, Tony Kelman, Jonas Fonseca, and other contributors listed in the git history.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
*/

const utf8proc_int32_t utf8proc_sequences[] = {
  97, -1, 98, -1, 99, -1, 100, 
  -1, 101, -1, 102, -1, 103, -1, 104, 
  -1, 105, -1, 106, -1, 107, -1, 108, 
  -1, 109, -1, 110, -1, 111, -1, 112, 
  -1, 113, -1, 114, -1, 115, -1, 116, 
  -1, 117, -1, 118, -1, 119, -1, 120, 
  -1, 121, -1, 122, -1, 32, -1, 32, 
  776, -1, 32, 772, -1, 50, -1, 51, 
  -1, 32, 769, -1, 956, -1, 32, 807, 
  -1, 49, -1, 49, 8260, 52, -1, 49, 
  8260, 50, -1, 51, 8260, 52, -1, 65, 
  768, -1, 224, -1, 65, 769, -1, 225, 
  -1, 65, 770, -1, 226, -1, 65, 771, 
  -1, 227, -1, 65, 776, -1, 228, -1, 
  65, 778, -1, 229, -1, 230, -1, 67, 
  807, -1, 231, -1, 69, 768, -1, 232, 
  -1, 69, 769, -1, 233, -1, 69, 770, 
  -1, 234, -1, 69, 776, -1, 235, -1, 
  73, 768, -1, 236, -1, 73, 769, -1, 
  237, -1, 73, 770, -1, 238, -1, 73, 
  776, -1, 239, -1, 240, -1, 78, 771, 
  -1, 241, -1, 79, 768, -1, 242, -1, 
  79, 769, -1, 243, -1, 79, 770, -1, 
  244, -1, 79, 771, -1, 245, -1, 79, 
  776, -1, 246, -1, 248, -1, 85, 768, 
  -1, 249, -1, 85, 769, -1, 250, -1, 
  85, 770, -1, 251, -1, 85, 776, -1, 
  252, -1, 89, 769, -1, 253, -1, 254, 
  -1, 115, 115, -1, 97, 768, -1, 97, 
  769, -1, 97, 770, -1, 97, 771, -1, 
  97, 776, -1, 97, 778, -1, 99, 807, 
  -1, 101, 768, -1, 101, 769, -1, 101, 
  770, -1, 101, 776, -1, 105, 768, -1, 
  105, 769, -1, 105, 770, -1, 105, 776, 
  -1, 110, 771, -1, 111, 768, -1, 111, 
  769, -1, 111, 770, -1, 111, 771, -1, 
  111, 776, -1, 117, 768, -1, 117, 769, 
  -1, 117, 770, -1, 117, 776, -1, 121, 
  769, -1, 121, 776, -1, 65, 772, -1, 
  257, -1, 97, 772, -1, 65, 774, -1, 
  259, -1, 97, 774, -1, 65, 808, -1, 
  261, -1, 97, 808, -1, 67, 769, -1, 
  263, -1, 99, 769, -1, 67, 770, -1, 
  265, -1, 99, 770, -1, 67, 775, -1, 
  267, -1, 99, 775, -1, 67, 780, -1, 
  269, -1, 99, 780, -1, 68, 780, -1, 
  271, -1, 100, 780, -1, 273, -1, 69, 
  772, -1, 275, -1, 101, 772, -1, 69, 
  774, -1, 277, -1, 101, 774, -1, 69, 
  775, -1, 279, -1, 101, 775, -1, 69, 
  808, -1, 281, -1, 101, 808, -1, 69, 
  780, -1, 283, -1, 101, 780, -1, 71, 
  770, -1, 285, -1, 103, 770, -1, 71, 
  774, -1, 287, -1, 103, 774, -1, 71, 
  775, -1, 289, -1, 103, 775, -1, 71, 
  807, -1, 291, -1, 103, 807, -1, 72, 
  770, -1, 293, -1, 104, 770, -1, 295, 
  -1, 73, 771, -1, 297, -1, 105, 771, 
  -1, 73, 772, -1, 299, -1, 105, 772, 
  -1, 73, 774, -1, 301, -1, 105, 774, 
  -1, 73, 808, -1, 303, -1, 105, 808, 
  -1, 73, 775, -1, 105, 775, -1, 73, 
  74, -1, 307, -1, 105, 106, -1, 74, 
  770, -1, 309, -1, 106, 770, -1, 75, 
  807, -1, 311, -1, 107, 807, -1, 76, 
  769, -1, 314, -1, 108, 769, -1, 76, 
  807, -1, 316, -1, 108, 807, -1, 76, 
  780, -1, 318, -1, 108, 780, -1, 76, 
  183, -1, 320, -1, 108, 183, -1, 322, 
  -1, 78, 769, -1, 324, -1, 110, 769, 
  -1, 78, 807, -1, 326, -1, 110, 807, 
  -1, 78, 780, -1, 328, -1, 110, 780, 
  -1, 700, 110, -1, 331, -1, 79, 772, 
  -1, 333, -1, 111, 772, -1, 79, 774, 
  -1, 335, -1, 111, 774, -1, 79, 779, 
  -1, 337, -1, 111, 779, -1, 339, -1, 
  82, 769, -1, 341, -1, 114, 769, -1, 
  82, 807, -1, 343, -1, 114, 807, -1, 
  82, 780, -1, 345, -1, 114, 780, -1, 
  83, 769, -1, 347, -1, 115, 769, -1, 
  83, 770, -1, 349, -1, 115, 770, -1, 
  83, 807, -1, 351, -1, 115, 807, -1, 
  83, 780, -1, 353, -1, 115, 780, -1, 
  84, 807, -1, 355, -1, 116, 807, -1, 
  84, 780, -1, 357, -1, 116, 780, -1, 
  359, -1, 85, 771, -1, 361, -1, 117, 
  771, -1, 85, 772, -1, 363, -1, 117, 
  772, -1, 85, 774, -1, 365, -1, 117, 
  774, -1, 85, 778, -1, 367, -1, 117, 
  778, -1, 85, 779, -1, 369, -1, 117, 
  779, -1, 85, 808, -1, 371, -1, 117, 
  808, -1, 87, 770, -1, 373, -1, 119, 
  770, -1, 89, 770, -1, 375, -1, 121, 
  770, -1, 89, 776, -1, 255, -1, 90, 
  769, -1, 378, -1, 122, 769, -1, 90, 
  775, -1, 380, -1, 122, 775, -1, 90, 
  780, -1, 382, -1, 122, 780, -1, 595, 
  -1, 387, -1, 389, -1, 596, -1, 392, 
  -1, 598, -1, 599, -1, 396, -1, 477, 
  -1, 601, -1, 603, -1, 402, -1, 608, 
  -1, 611, -1, 617, -1, 616, -1, 409, 
  -1, 623, -1, 626, -1, 629, -1, 79, 
  795, -1, 417, -1, 111, 795, -1, 419, 
  -1, 421, -1, 640, -1, 424, -1, 643, 
  -1, 429, -1, 648, -1, 85, 795, -1, 
  432, -1, 117, 795, -1, 650, -1, 651, 
  -1, 436, -1, 438, -1, 658, -1, 441, 
  -1, 445, -1, 68, 381, -1, 454, -1, 
  68, 382, -1, 100, 382, -1, 76, 74, 
  -1, 457, -1, 76, 106, -1, 108, 106, 
  -1, 78, 74, -1, 460, -1, 78, 106, 
  -1, 110, 106, -1, 65, 780, -1, 462, 
  -1, 97, 780, -1, 73, 780, -1, 464, 
  -1, 105, 780, -1, 79, 780, -1, 466, 
  -1, 111, 780, -1, 85, 780, -1, 468, 
  -1, 117, 780, -1, 220, 772, -1, 470, 
  -1, 252, 772, -1, 220, 769, -1, 472, 
  -1, 252, 769, -1, 220, 780, -1, 474, 
  -1, 252, 780, -1, 220, 768, -1, 476, 
  -1, 252, 768, -1, 196, 772, -1, 479, 
  -1, 228, 772, -1, 550, 772, -1, 481, 
  -1, 551, 772, -1, 198, 772, -1, 483, 
  -1, 230, 772, -1, 485, -1, 71, 780, 
  -1, 487, -1, 103, 780, -1, 75, 780, 
  -1, 489, -1, 107, 780, -1, 79, 808, 
  -1, 491, -1, 111, 808, -1, 490, 772, 
  -1, 493, -1, 491, 772, -1, 439, 780, 
  -1, 495, -1, 658, 780, -1, 106, 780, 
  -1, 68, 90, -1, 499, -1, 68, 122, 
  -1, 100, 122, -1, 71, 769, -1, 501, 
  -1, 103, 769, -1, 405, -1, 447, -1, 
  78, 768, -1, 505, -1, 110, 768, -1, 
  197, 769, -1, 507, -1, 229, 769, -1, 
  198, 769, -1, 509, -1, 230, 769, -1, 
  216, 769, -1, 511, -1, 248, 769, -1, 
  65, 783, -1, 513, -1, 97, 783, -1, 
  65, 785, -1, 515, -1, 97, 785, -1, 
  69, 783, -1, 517, -1, 101, 783, -1, 
  69, 785, -1, 519, -1, 101, 785, -1, 
  73, 783, -1, 521, -1, 105, 783, -1, 
  73, 785, -1, 523, -1, 105, 785, -1, 
  79, 783, -1, 525, -1, 111, 783, -1, 
  79, 785, -1, 527, -1, 111, 785, -1, 
  82, 783, -1, 529, -1, 114, 783, -1, 
  82, 785, -1, 531, -1, 114, 785, -1, 
  85, 783, -1, 533, -1, 117, 783, -1, 
  85, 785, -1, 535, -1, 117, 785, -1, 
  83, 806, -1, 537, -1, 115, 806, -1, 
  84, 806, -1, 539, -1, 116, 806, -1, 
  541, -1, 72, 780, -1, 543, -1, 104, 
  780, -1, 414, -1, 547, -1, 549, -1, 
  65, 775, -1, 551, -1, 97, 775, -1, 
  69, 807, -1, 553, -1, 101, 807, -1, 
  214, 772, -1, 555, -1, 246, 772, -1, 
  213, 772, -1, 557, -1, 245, 772, -1, 
  79, 775, -1, 559, -1, 111, 775, -1, 
  558, 772, -1, 561, -1, 559, 772, -1, 
  89, 772, -1, 563, -1, 121, 772, -1, 
  11365, -1, 572, -1, 410, -1, 11366, -1, 
  578, -1, 384, -1, 649, -1, 652, -1, 
  583, -1, 585, -1, 587, -1, 589, -1, 
  591, -1, 614, -1, 633, -1, 635, -1, 
  641, -1, 32, 774, -1, 32, 775, -1, 
  32, 778, -1, 32, 808, -1, 32, 771, 
  -1, 32, 779, -1, 661, -1, 768, -1, 
  769, -1, 787, -1, 776, 769, -1, 953, 
  -1, 881, -1, 883, -1, 697, -1, 887, 
  -1, 32, 837, -1, 59, -1, 1011, -1, 
  168, 769, -1, 913, 769, -1, 940, -1, 
  183, -1, 917, 769, -1, 941, -1, 919, 
  769, -1, 942, -1, 921, 769, -1, 943, 
  -1, 927, 769, -1, 972, -1, 933, 769, 
  -1, 973, -1, 937, 769, -1, 974, -1, 
  970, 769, -1, 953, 776, 769, -1, 945, 
  -1, 946, -1, 947, -1, 948, -1, 949, 
  -1, 950, -1, 951, -1, 952, -1, 954, 
  -1, 955, -1, 957, -1, 958, -1, 959, 
  -1, 960, -1, 961, -1, 963, -1, 964, 
  -1, 965, -1, 966, -1, 967, -1, 968, 
  -1, 969, -1, 921, 776, -1, 970, -1, 
  933, 776, -1, 971, -1, 945, 769, -1, 
  949, 769, -1, 951, 769, -1, 953, 769, 
  -1, 971, 769, -1, 965, 776, 769, -1, 
  953, 776, -1, 965, 776, -1, 959, 769, 
  -1, 965, 769, -1, 969, 769, -1, 983, 
  -1, 933, -1, 978, 769, -1, 978, 776, 
  -1, 985, -1, 987, -1, 989, -1, 991, 
  -1, 993, -1, 995, -1, 997, -1, 999, 
  -1, 1001, -1, 1003, -1, 1005, -1, 1007, 
  -1, 962, -1, 920, -1, 1016, -1, 931, 
  -1, 1010, -1, 1019, -1, 891, -1, 892, 
  -1, 893, -1, 1045, 768, -1, 1104, -1, 
  1045, 776, -1, 1105, -1, 1106, -1, 1043, 
  769, -1, 1107, -1, 1108, -1, 1109, -1, 
  1110, -1, 1030, 776, -1, 1111, -1, 1112, 
  -1, 1113, -1, 1114, -1, 1115, -1, 1050, 
  769, -1, 1116, -1, 1048, 768, -1, 1117, 
  -1, 1059, 774, -1, 1118, -1, 1119, -1, 
  1072, -1, 1073, -1, 1074, -1, 1075, -1, 
  1076, -1, 1077, -1, 1078, -1, 1079, -1, 
  1080, -1, 1048, 774, -1, 1081, -1, 1082, 
  -1, 1083, -1, 1084, -1, 1085, -1, 1086, 
  -1, 1087, -1, 1088, -1, 1089, -1, 1090, 
  -1, 1091, -1, 1092, -1, 1093, -1, 1094, 
  -1, 1095, -1, 1096, -1, 1097, -1, 1098, 
  -1, 1099, -1, 1100, -1, 1101, -1, 1102, 
  -1, 1103, -1, 1080, 774, -1, 1077, 768, 
  -1, 1077, 776, -1, 1075, 769, -1, 1110, 
  776, -1, 1082, 769, -1, 1080, 768, -1, 
  1091, 774, -1, 1121, -1, 1123, -1, 1125, 
  -1, 1127, -1, 1129, -1, 1131, -1, 1133, 
  -1, 1135, -1, 1137, -1, 1139, -1, 1141, 
  -1, 1140, 783, -1, 1143, -1, 1141, 783, 
  -1, 1145, -1, 1147, -1, 1149, -1, 1151, 
  -1, 1153, -1, 1163, -1, 1165, -1, 1167, 
  -1, 1169, -1, 1171, -1, 1173, -1, 1175, 
  -1, 1177, -1, 1179, -1, 1181, -1, 1183, 
  -1, 1185, -1, 1187, -1, 1189, -1, 1191, 
  -1, 1193, -1, 1195, -1, 1197, -1, 1199, 
  -1, 1201, -1, 1203, -1, 1205, -1, 1207, 
  -1, 1209, -1, 1211, -1, 1213, -1, 1215, 
  -1, 1231, -1, 1046, 774, -1, 1218, -1, 
  1078, 774, -1, 1220, -1, 1222, -1, 1224, 
  -1, 1226, -1, 1228, -1, 1230, -1, 1040, 
  774, -1, 1233, -1, 1072, 774, -1, 1040, 
  776, -1, 1235, -1, 1072, 776, -1, 1237, 
  -1, 1045, 774, -1, 1239, -1, 1077, 774, 
  -1, 1241, -1, 1240, 776, -1, 1243, -1, 
  1241, 776, -1, 1046, 776, -1, 1245, -1, 
  1078, 776, -1, 1047, 776, -1, 1247, -1, 
  1079, 776, -1, 1249, -1, 1048, 772, -1, 
  1251, -1, 1080, 772, -1, 1048, 776, -1, 
  1253, -1, 1080, 776, -1, 1054, 776, -1, 
  1255, -1, 1086, 776, -1, 1257, -1, 1256, 
  776, -1, 1259, -1, 1257, 776, -1, 1069, 
  776, -1, 1261, -1, 1101, 776, -1, 1059, 
  772, -1, 1263, -1, 1091, 772, -1, 1059, 
  776, -1, 1265, -1, 1091, 776, -1, 1059, 
  779, -1, 1267, -1, 1091, 779, -1, 1063, 
  776, -1, 1269, -1, 1095, 776, -1, 1271, 
  -1, 1067, 776, -1, 1273, -1, 1099, 776, 
  -1, 1275, -1, 1277, -1, 1279, -1, 1281, 
  -1, 1283, -1, 1285, -1, 1287, -1, 1289, 
  -1, 1291, -1, 1293, -1, 1295, -1, 1297, 
  -1, 1299, -1, 1301, -1, 1303, -1, 1305, 
  -1, 1307, -1, 1309, -1, 1311, -1, 1313, 
  -1, 1315, -1, 1317, -1, 1319, -1, 1321, 
  -1, 1323, -1, 1325, -1, 1327, -1, 1377, 
  -1, 1378, -1, 1379, -1, 1380, -1, 1381, 
  -1, 1382, -1, 1383, -1, 1384, -1, 1385, 
  -1, 1386, -1, 1387, -1, 1388, -1, 1389, 
  -1, 1390, -1, 1391, -1, 1392, -1, 1393, 
  -1, 1394, -1, 1395, -1, 1396, -1, 1397, 
  -1, 1398, -1, 1399, -1, 1400, -1, 1401, 
  -1, 1402, -1, 1403, -1, 1404, -1, 1405, 
  -1, 1406, -1, 1407, -1, 1408, -1, 1409, 
  -1, 1410, -1, 1411, -1, 1412, -1, 1413, 
  -1, 1414, -1, 1381, 1410, -1, 1575, 1619, 
  -1, 1575, 1620, -1, 1608, 1620, -1, 1575, 
  1621, -1, 1610, 1620, -1, 1575, 1652, -1, 
  1608, 1652, -1, 1735, 1652, -1, 1610, 1652, 
  -1, 1749, 1620, -1, 1729, 1620, -1, 1746, 
  1620, -1, 2344, 2364, -1, 2352, 2364, -1, 
  2355, 2364, -1, 2325, 2364, -1, 2326, 2364, 
  -1, 2327, 2364, -1, 2332, 2364, -1, 2337, 
  2364, -1, 2338, 2364, -1, 2347, 2364, -1, 
  2351, 2364, -1, 2503, 2494, -1, 2503, 2519, 
  -1, 2465, 2492, -1, 2466, 2492, -1, 2479, 
  2492, -1, 2610, 2620, -1, 2616, 2620, -1, 
  2582, 2620, -1, 2583, 2620, -1, 2588, 2620, 
  -1, 2603, 2620, -1, 2887, 2902, -1, 2887, 
  2878, -1, 2887, 2903, -1, 2849, 2876, -1, 
  2850, 2876, -1, 2962, 3031, -1, 3014, 3006, 
  -1, 3015, 3006, -1, 3014, 3031, -1, 3142, 
  3158, -1, 3263, 3285, -1, 3270, 3285, -1, 
  3270, 3286, -1, 3270, 3266, -1, 3274, 3285, 
  -1, 3398, 3390, -1, 3399, 3390, -1, 3398, 
  3415, -1, 3545, 3530, -1, 3545, 3535, -1, 
  3548, 3530, -1, 3545, 3551, -1, 3661, 3634, 
  -1, 3789, 3762, -1, 3755, 3737, -1, 3755, 
  3745, -1, 3851, -1, 3906, 4023, -1, 3916, 
  4023, -1, 3921, 4023, -1, 3926, 4023, -1, 
  3931, 4023, -1, 3904, 4021, -1, 3953, 3954, 
  -1, 3953, 3956, -1, 4018, 3968, -1, 4018, 
  3969, -1, 4019, 3968, -1, 4019, 3969, -1, 
  3953, 3968, -1, 3986, 4023, -1, 3996, 4023, 
  -1, 4001, 4023, -1, 4006, 4023, -1, 4011, 
  4023, -1, 3984, 4021, -1, 4133, 4142, -1, 
  11520, -1, 11521, -1, 11522, -1, 11523, -1, 
  11524, -1, 11525, -1, 11526, -1, 11527, -1, 
  11528, -1, 11529, -1, 11530, -1, 11531, -1, 
  11532, -1, 11533, -1, 11534, -1, 11535, -1, 
  11536, -1, 11537, -1, 11538, -1, 11539, -1, 
  11540, -1, 11541, -1, 11542, -1, 11543, -1, 
  11544, -1, 11545, -1, 11546, -1, 11547, -1, 
  11548, -1, 11549, -1, 11550, -1, 11551, -1, 
  11552, -1, 11553, -1, 11554, -1, 11555, -1, 
  11556, -1, 11557, -1, 11559, -1, 11565, -1, 
  4316, -1, 5104, -1, 5105, -1, 5106, -1, 
  5107, -1, 5108, -1, 5109, -1, 6917, 6965, 
  -1, 6919, 6965, -1, 6921, 6965, -1, 6923, 
  6965, -1, 6925, 6965, -1, 6929, 6965, -1, 
  6970, 6965, -1, 6972, 6965, -1, 6974, 6965, 
  -1, 6975, 6965, -1, 6978, 6965, -1, 65, 
  -1, 198, -1, 66, -1, 68, -1, 69, 
  -1, 398, -1, 71, -1, 72, -1, 73, 
  -1, 74, -1, 75, -1, 76, -1, 77, 
  -1, 78, -1, 79, -1, 546, -1, 80, 
  -1, 82, -1, 84, -1, 85, -1, 87, 
  -1, 592, -1, 593, -1, 7426, -1, 604, 
  -1, 7446, -1, 7447, -1, 7453, -1, 7461, 
  -1, 594, -1, 597, -1, 607, -1, 609, 
  -1, 613, -1, 618, -1, 7547, -1, 669, 
  -1, 621, -1, 7557, -1, 671, -1, 625, 
  -1, 624, -1, 627, -1, 628, -1, 632, 
  -1, 642, -1, 427, -1, 7452, -1, 656, 
  -1, 657, -1, 65, 805, -1, 7681, -1, 
  97, 805, -1, 66, 775, -1, 7683, -1, 
  98, 775, -1, 66, 803, -1, 7685, -1, 
  98, 803, -1, 66, 817, -1, 7687, -1, 
  98, 817, -1, 199, 769, -1, 7689, -1, 
  231, 769, -1, 68, 775, -1, 7691, -1, 
  100, 775, -1, 68, 803, -1, 7693, -1, 
  100, 803, -1, 68, 817, -1, 7695, -1, 
  100, 817, -1, 68, 807, -1, 7697, -1, 
  100, 807, -1, 68, 813, -1, 7699, -1, 
  100, 813, -1, 274, 768, -1, 7701, -1, 
  275, 768, -1, 274, 769, -1, 7703, -1, 
  275, 769, -1, 69, 813, -1, 7705, -1, 
  101, 813, -1, 69, 816, -1, 7707, -1, 
  101, 816, -1, 552, 774, -1, 7709, -1, 
  553, 774, -1, 70, 775, -1, 7711, -1, 
  102, 775, -1, 71, 772, -1, 7713, -1, 
  103, 772, -1, 72, 775, -1, 7715, -1, 
  104, 775, -1, 72, 803, -1, 7717, -1, 
  104, 803, -1, 72, 776, -1, 7719, -1, 
  104, 776, -1, 72, 807, -1, 7721, -1, 
  104, 807, -1, 72, 814, -1, 7723, -1, 
  104, 814, -1, 73, 816, -1, 7725, -1, 
  105, 816, -1, 207, 769, -1, 7727, -1, 
  239, 769, -1, 75, 769, -1, 7729, -1, 
  107, 769, -1, 75, 803, -1, 7731, -1, 
  107, 803, -1, 75, 817, -1, 7733, -1, 
  107, 817, -1, 76, 803, -1, 7735, -1, 
  108, 803, -1, 7734, 772, -1, 7737, -1, 
  7735, 772, -1, 76, 817, -1, 7739, -1, 
  108, 817, -1, 76, 813, -1, 7741, -1, 
  108, 813, -1, 77, 769, -1, 7743, -1, 
  109, 769, -1, 77, 775, -1, 7745, -1, 
  109, 775, -1, 77, 803, -1, 7747, -1, 
  109, 803, -1, 78, 775, -1, 7749, -1, 
  110, 775, -1, 78, 803, -1, 7751, -1, 
  110, 803, -1, 78, 817, -1, 7753, -1, 
  110, 817, -1, 78, 813, -1, 7755, -1, 
  110, 813, -1, 213, 769, -1, 7757, -1, 
  245, 769, -1, 213, 776, -1, 7759, -1, 
  245, 776, -1, 332, 768, -1, 7761, -1, 
  333, 768, -1, 332, 769, -1, 7763, -1, 
  333, 769, -1, 80, 769, -1, 7765, -1, 
  112, 769, -1, 80, 775, -1, 7767, -1, 
  112, 775, -1, 82, 775, -1, 7769, -1, 
  114, 775, -1, 82, 803, -1, 7771, -1, 
  114, 803, -1, 7770, 772, -1, 7773, -1, 
  7771, 772, -1, 82, 817, -1, 7775, -1, 
  114, 817, -1, 83, 775, -1, 7777, -1, 
  115, 775, -1, 83, 803, -1, 7779, -1, 
  115, 803, -1, 346, 775, -1, 7781, -1, 
  347, 775, -1, 352, 775, -1, 7783, -1, 
  353, 775, -1, 7778, 775, -1, 7785, -1, 
  7779, 775, -1, 84, 775, -1, 7787, -1, 
  116, 775, -1, 84, 803, -1, 7789, -1, 
  116, 803, -1, 84, 817, -1, 7791, -1, 
  116, 817, -1, 84, 813, -1, 7793, -1, 
  116, 813, -1, 85, 804, -1, 7795, -1, 
  117, 804, -1, 85, 816, -1, 7797, -1, 
  117, 816, -1, 85, 813, -1, 7799, -1, 
  117, 813, -1, 360, 769, -1, 7801, -1, 
  361, 769, -1, 362, 776, -1, 7803, -1, 
  363, 776, -1, 86, 771, -1, 7805, -1, 
  118, 771, -1, 86, 803, -1, 7807, -1, 
  118, 803, -1, 87, 768, -1, 7809, -1, 
  119, 768, -1, 87, 769, -1, 7811, -1, 
  119, 769, -1, 87, 776, -1, 7813, -1, 
  119, 776, -1, 87, 775, -1, 7815, -1, 
  119, 775, -1, 87, 803, -1, 7817, -1, 
  119, 803, -1, 88, 775, -1, 7819, -1, 
  120, 775, -1, 88, 776, -1, 7821, -1, 
  120, 776, -1, 89, 775, -1, 7823, -1, 
  121, 775, -1, 90, 770, -1, 7825, -1, 
  122, 770, -1, 90, 803, -1, 7827, -1, 
  122, 803, -1, 90, 817, -1, 7829, -1, 
  122, 817, -1, 104, 817, -1, 116, 776, 
  -1, 119, 778, -1, 121, 778, -1, 97, 
  702, -1, 383, 775, -1, 223, -1, 65, 
  803, -1, 7841, -1, 97, 803, -1, 65, 
  777, -1, 7843, -1, 97, 777, -1, 194, 
  769, -1, 7845, -1, 226, 769, -1, 194, 
  768, -1, 7847, -1, 226, 768, -1, 194, 
  777, -1, 7849, -1, 226, 777, -1, 194, 
  771, -1, 7851, -1, 226, 771, -1, 7840, 
  770, -1, 7853, -1, 7841, 770, -1, 258, 
  769, -1, 7855, -1, 259, 769, -1, 258, 
  768, -1, 7857, -1, 259, 768, -1, 258, 
  777, -1, 7859, -1, 259, 777, -1, 258, 
  771, -1, 7861, -1, 259, 771, -1, 7840, 
  774, -1, 7863, -1, 7841, 774, -1, 69, 
  803, -1, 7865, -1, 101, 803, -1, 69, 
  777, -1, 7867, -1, 101, 777, -1, 69, 
  771, -1, 7869, -1, 101, 771, -1, 202, 
  769, -1, 7871, -1, 234, 769, -1, 202, 
  768, -1, 7873, -1, 234, 768, -1, 202, 
  777, -1, 7875, -1, 234, 777, -1, 202, 
  771, -1, 7877, -1, 234, 771, -1, 7864, 
  770, -1, 7879, -1, 7865, 770, -1, 73, 
  777, -1, 7881, -1, 105, 777, -1, 73, 
  803, -1, 7883, -1, 105, 803, -1, 79, 
  803, -1, 7885, -1, 111, 803, -1, 79, 
  777, -1, 7887, -1, 111, 777, -1, 212, 
  769, -1, 7889, -1, 244, 769, -1, 212, 
  768, -1, 7891, -1, 244, 768, -1, 212, 
  777, -1, 7893, -1, 244, 777, -1, 212, 
  771, -1, 7895, -1, 244, 771, -1, 7884, 
  770, -1, 7897, -1, 7885, 770, -1, 416, 
  769, -1, 7899, -1, 417, 769, -1, 416, 
  768, -1, 7901, -1, 417, 768, -1, 416, 
  777, -1, 7903, -1, 417, 777, -1, 416, 
  771, -1, 7905, -1, 417, 771, -1, 416, 
  803, -1, 7907, -1, 417, 803, -1, 85, 
  803, -1, 7909, -1, 117, 803, -1, 85, 
  777, -1, 7911, -1, 117, 777, -1, 431, 
  769, -1, 7913, -1, 432, 769, -1, 431, 
  768, -1, 7915, -1, 432, 768, -1, 431, 
  777, -1, 7917, -1, 432, 777, -1, 431, 
  771, -1, 7919, -1, 432, 771, -1, 431, 
  803, -1, 7921, -1, 432, 803, -1, 89, 
  768, -1, 7923, -1, 121, 768, -1, 89, 
  803, -1, 7925, -1, 121, 803, -1, 89, 
  777, -1, 7927, -1, 121, 777, -1, 89, 
  771, -1, 7929, -1, 121, 771, -1, 7931, 
  -1, 7933, -1, 7935, -1, 945, 787, -1, 
  945, 788, -1, 7936, 768, -1, 7937, 768, 
  -1, 7936, 769, -1, 7937, 769, -1, 7936, 
  834, -1, 7937, 834, -1, 913, 787, -1, 
  7936, -1, 913, 788, -1, 7937, -1, 7944, 
  768, -1, 7938, -1, 7945, 768, -1, 7939, 
  -1, 7944, 769, -1, 7940, -1, 7945, 769, 
  -1, 7941, -1, 7944, 834, -1, 7942, -1, 
  7945, 834, -1, 7943, -1, 949, 787, -1, 
  949, 788, -1, 7952, 768, -1, 7953, 768, 
  -1, 7952, 769, -1, 7953, 769, -1, 917, 
  787, -1, 7952, -1, 917, 788, -1, 7953, 
  -1, 7960, 768, -1, 7954, -1, 7961, 768, 
  -1, 7955, -1, 7960, 769, -1, 7956, -1, 
  7961, 769, -1, 7957, -1, 951, 787, -1, 
  951, 788, -1, 7968, 768, -1, 7969, 768, 
  -1, 7968, 769, -1, 7969, 769, -1, 7968, 
  834, -1, 7969, 834, -1, 919, 787, -1, 
  7968, -1, 919, 788, -1, 7969, -1, 7976, 
  768, -1, 7970, -1, 7977, 768, -1, 7971, 
  -1, 7976, 769, -1, 7972, -1, 7977, 769, 
  -1, 7973, -1, 7976, 834, -1, 7974, -1, 
  7977, 834, -1, 7975, -1, 953, 787, -1, 
  953, 788, -1, 7984, 768, -1, 7985, 768, 
  -1, 7984, 769, -1, 7985, 769, -1, 7984, 
  834, -1, 7985, 834, -1, 921, 787, -1, 
  7984, -1, 921, 788, -1, 7985, -1, 7992, 
  768, -1, 7986, -1, 7993, 768, -1, 7987, 
  -1, 7992, 769, -1, 7988, -1, 7993, 769, 
  -1, 7989, -1, 7992, 834, -1, 7990, -1, 
  7993, 834, -1, 7991, -1, 959, 787, -1, 
  959, 788, -1, 8000, 768, -1, 8001, 768, 
  -1, 8000, 769, -1, 8001, 769, -1, 927, 
  787, -1, 8000, -1, 927, 788, -1, 8001, 
  -1, 8008, 768, -1, 8002, -1, 8009, 768, 
  -1, 8003, -1, 8008, 769, -1, 8004, -1, 
  8009, 769, -1, 8005, -1, 965, 787, -1, 
  965, 788, -1, 8016, 768, -1, 965, 787, 
  768, -1, 8017, 768, -1, 8016, 769, -1, 
  965, 787, 769, -1, 8017, 769, -1, 8016, 
  834, -1, 965, 787, 834, -1, 8017, 834, 
  -1, 933, 788, -1, 8017, -1, 8025, 768, 
  -1, 8019, -1, 8025, 769, -1, 8021, -1, 
  8025, 834, -1, 8023, -1, 969, 787, -1, 
  969, 788, -1, 8032, 768, -1, 8033, 768, 
  -1, 8032, 769, -1, 8033, 769, -1, 8032, 
  834, -1, 8033, 834, -1, 937, 787, -1, 
  8032, -1, 937, 788, -1, 8033, -1, 8040, 
  768, -1, 8034, -1, 8041, 768, -1, 8035, 
  -1, 8040, 769, -1, 8036, -1, 8041, 769, 
  -1, 8037, -1, 8040, 834, -1, 8038, -1, 
  8041, 834, -1, 8039, -1, 945, 768, -1, 
  949, 768, -1, 951, 768, -1, 953, 768, 
  -1, 959, 768, -1, 965, 768, -1, 969, 
  768, -1, 7936, 837, -1, 7936, 953, -1, 
  7937, 837, -1, 7937, 953, -1, 7938, 837, 
  -1, 7938, 953, -1, 7939, 837, -1, 7939, 
  953, -1, 7940, 837, -1, 7940, 953, -1, 
  7941, 837, -1, 7941, 953, -1, 7942, 837, 
  -1, 7942, 953, -1, 7943, 837, -1, 7943, 
  953, -1, 7944, 837, -1, 8064, -1, 7945, 
  837, -1, 8065, -1, 7946, 837, -1, 8066, 
  -1, 7947, 837, -1, 8067, -1, 7948, 837, 
  -1, 8068, -1, 7949, 837, -1, 8069, -1, 
  7950, 837, -1, 8070, -1, 7951, 837, -1, 
  8071, -1, 7968, 837, -1, 7968, 953, -1, 
  7969, 837, -1, 7969, 953, -1, 7970, 837, 
  -1, 7970, 953, -1, 7971, 837, -1, 7971, 
  953, -1, 7972, 837, -1, 7972, 953, -1, 
  7973, 837, -1, 7973, 953, -1, 7974, 837, 
  -1, 7974, 953, -1, 7975, 837, -1, 7975, 
  953, -1, 7976, 837, -1, 8080, -1, 7977, 
  837, -1, 8081, -1, 7978, 837, -1, 8082, 
  -1, 7979, 837, -1, 8083, -1, 7980, 837, 
  -1, 8084, -1, 7981, 837, -1, 8085, -1, 
  7982, 837, -1, 8086, -1, 7983, 837, -1, 
  8087, -1, 8032, 837, -1, 8032, 953, -1, 
  8033, 837, -1, 8033, 953, -1, 8034, 837, 
  -1, 8034, 953, -1, 8035, 837, -1, 8035, 
  953, -1, 8036, 837, -1, 8036, 953, -1, 
  8037, 837, -1, 8037, 953, -1, 8038, 837, 
  -1, 8038, 953, -1, 8039, 837, -1, 8039, 
  953, -1, 8040, 837, -1, 8096, -1, 8041, 
  837, -1, 8097, -1, 8042, 837, -1, 8098, 
  -1, 8043, 837, -1, 8099, -1, 8044, 837, 
  -1, 8100, -1, 8045, 837, -1, 8101, -1, 
  8046, 837, -1, 8102, -1, 8047, 837, -1, 
  8103, -1, 945, 774, -1, 945, 772, -1, 
  8048, 837, -1, 8048, 953, -1, 945, 837, 
  -1, 945, 953, -1, 940, 837, -1, 940, 
  953, -1, 945, 834, -1, 8118, 837, -1, 
  945, 834, 953, -1, 913, 774, -1, 8112, 
  -1, 913, 772, -1, 8113, -1, 913, 768, 
  -1, 8048, -1, 902, -1, 8049, -1, 913, 
  837, -1, 8115, -1, 32, 787, -1, 32, 
  834, -1, 168, 834, -1, 8052, 837, -1, 
  8052, 953, -1, 951, 837, -1, 951, 953, 
  -1, 942, 837, -1, 942, 953, -1, 951, 
  834, -1, 8134, 837, -1, 951, 834, 953, 
  -1, 917, 768, -1, 8050, -1, 904, -1, 
  8051, -1, 919, 768, -1, 8052, -1, 905, 
  -1, 8053, -1, 919, 837, -1, 8131, -1, 
  8127, 768, -1, 8127, 769, -1, 8127, 834, 
  -1, 953, 774, -1, 953, 772, -1, 970, 
  768, -1, 953, 776, 768, -1, 912, -1, 
  953, 834, -1, 970, 834, -1, 953, 776, 
  834, -1, 921, 774, -1, 8144, -1, 921, 
  772, -1, 8145, -1, 921, 768, -1, 8054, 
  -1, 906, -1, 8055, -1, 8190, 768, -1, 
  8190, 769, -1, 8190, 834, -1, 965, 774, 
  -1, 965, 772, -1, 971, 768, -1, 965, 
  776, 768, -1, 944, -1, 961, 787, -1, 
  961, 788, -1, 965, 834, -1, 971, 834, 
  -1, 965, 776, 834, -1, 933, 774, -1, 
  8160, -1, 933, 772, -1, 8161, -1, 933, 
  768, -1, 8058, -1, 910, -1, 8059, -1, 
  929, 788, -1, 8165, -1, 168, 768, -1, 
  901, -1, 96, -1, 8060, 837, -1, 8060, 
  953, -1, 969, 837, -1, 969, 953, -1, 
  974, 837, -1, 974, 953, -1, 969, 834, 
  -1, 8182, 837, -1, 969, 834, 953, -1, 
  927, 768, -1, 8056, -1, 908, -1, 8057, 
  -1, 937, 768, -1, 8060, -1, 911, -1, 
  8061, -1, 937, 837, -1, 8179, -1, 180, 
  -1, 32, 788, -1, 8194, -1, 8195, -1, 
  8208, -1, 32, 819, -1, 46, -1, 46, 
  46, -1, 46, 46, 46, -1, 8242, 8242, 
  -1, 8242, 8242, 8242, -1, 8245, 8245, -1, 
  8245, 8245, 8245, -1, 33, 33, -1, 32, 
  773, -1, 63, 63, -1, 63, 33, -1, 
  33, 63, -1, 8242, 8242, 8242, 8242, -1, 
  48, -1, 52, -1, 53, -1, 54, -1, 
  55, -1, 56, -1, 57, -1, 43, -1, 
  8722, -1, 61, -1, 40, -1, 41, -1, 
  82, 115, -1, 97, 47, 99, -1, 97, 
  47, 115, -1, 67, -1, 176, 67, -1, 
  99, 47, 111, -1, 99, 47, 117, -1, 
  400, -1, 176, 70, -1, 78, 111, -1, 
  81, -1, 83, 77, -1, 84, 69, 76, 
  -1, 84, 77, -1, 90, -1, 937, -1, 
  197, -1, 70, -1, 8526, -1, 1488, -1, 
  1489, -1, 1490, -1, 1491, -1, 70, 65, 
  88, -1, 915, -1, 928, -1, 8721, -1, 
  49, 8260, 55, -1, 49, 8260, 57, -1, 
  49, 8260, 49, 48, -1, 49, 8260, 51, 
  -1, 50, 8260, 51, -1, 49, 8260, 53, 
  -1, 50, 8260, 53, -1, 51, 8260, 53, 
  -1, 52, 8260, 53, -1, 49, 8260, 54, 
  -1, 53, 8260, 54, -1, 49, 8260, 56, 
  -1, 51, 8260, 56, -1, 53, 8260, 56, 
  -1, 55, 8260, 56, -1, 49, 8260, -1, 
  8560, -1, 73, 73, -1, 8561, -1, 73, 
  73, 73, -1, 8562, -1, 73, 86, -1, 
  8563, -1, 86, -1, 8564, -1, 86, 73, 
  -1, 8565, -1, 86, 73, 73, -1, 8566, 
  -1, 86, 73, 73, 73, -1, 8567, -1, 
  73, 88, -1, 8568, -1, 88, -1, 8569, 
  -1, 88, 73, -1, 8570, -1, 88, 73, 
  73, -1, 8571, -1, 8572, -1, 8573, -1, 
  8574, -1, 8575, -1, 105, 105, -1, 105, 
  105, 105, -1, 105, 118, -1, 118, 105, 
  -1, 118, 105, 105, -1, 118, 105, 105, 
  105, -1, 105, 120, -1, 120, 105, -1, 
  120, 105, 105, -1, 8580, -1, 48, 8260, 
  51, -1, 8592, 824, -1, 8594, 824, -1, 
  8596, 824, -1, 8656, 824, -1, 8660, 824, 
  -1, 8658, 824, -1, 8707, 824, -1, 8712, 
  824, -1, 8715, 824, -1, 8739, 824, -1, 
  8741, 824, -1, 8747, 8747, -1, 8747, 8747, 
  8747, -1, 8750, 8750, -1, 8750, 8750, 8750, 
  -1, 8764, 824, -1, 8771, 824, -1, 8773, 
  824, -1, 8776, 824, -1, 61, 824, -1, 
  8801, 824, -1, 8781, 824, -1, 60, 824, 
  -1, 62, 824, -1, 8804, 824, -1, 8805, 
  824, -1, 8818, 824, -1, 8819, 824, -1, 
  8822, 824, -1, 8823, 824, -1, 8826, 824, 
  -1, 8827, 824, -1, 8834, 824, -1, 8835, 
  824, -1, 8838, 824, -1, 8839, 824, -1, 
  8866, 824, -1, 8872, 824, -1, 8873, 824, 
  -1, 8875, 824, -1, 8828, 824, -1, 8829, 
  824, -1, 8849, 824, -1, 8850, 824, -1, 
  8882, 824, -1, 8883, 824, -1, 8884, 824, 
  -1, 8885, 824, -1, 12296, -1, 12297, -1, 
  49, 48, -1, 49, 49, -1, 49, 50, 
  -1, 49, 51, -1, 49, 52, -1, 49, 
  53, -1, 49, 54, -1, 49, 55, -1, 
  49, 56, -1, 49, 57, -1, 50, 48, 
  -1, 40, 49, 41, -1, 40, 50, 41, 
  -1, 40, 51, 41, -1, 40, 52, 41, 
  -1, 40, 53, 41, -1, 40, 54, 41, 
  -1, 40, 55, 41, -1, 40, 56, 41, 
  -1, 40, 57, 41, -1, 40, 49, 48, 
  41, -1, 40, 49, 49, 41, -1, 40, 
  49, 50, 41, -1, 40, 49, 51, 41, 
  -1, 40, 49, 52, 41, -1, 40, 49, 
  53, 41, -1, 40, 49, 54, 41, -1, 
  40, 49, 55, 41, -1, 40, 49, 56, 
  41, -1, 40, 49, 57, 41, -1, 40, 
  50, 48, 41, -1, 49, 46, -1, 50, 
  46, -1, 51, 46, -1, 52, 46, -1, 
  53, 46, -1, 54, 46, -1, 55, 46, 
  -1, 56, 46, -1, 57, 46, -1, 49, 
  48, 46, -1, 49, 49, 46, -1, 49, 
  50, 46, -1, 49, 51, 46, -1, 49, 
  52, 46, -1, 49, 53, 46, -1, 49, 
  54, 46, -1, 49, 55, 46, -1, 49, 
  56, 46, -1, 49, 57, 46, -1, 50, 
  48, 46, -1, 40, 97, 41, -1, 40, 
  98, 41, -1, 40, 99, 41, -1, 40, 
  100, 41, -1, 40, 101, 41, -1, 40, 
  102, 41, -1, 40, 103, 41, -1, 40, 
  104, 41, -1, 40, 105, 41, -1, 40, 
  106, 41, -1, 40, 107, 41, -1, 40, 
  108, 41, -1, 40, 109, 41, -1, 40, 
  110, 41, -1, 40, 111, 41, -1, 40, 
  112, 41, -1, 40, 113, 41, -1, 40, 
  114, 41, -1, 40, 115, 41, -1, 40, 
  116, 41, -1, 40, 117, 41, -1, 40, 
  118, 41, -1, 40, 119, 41, -1, 40, 
  120, 41, -1, 40, 121, 41, -1, 40, 
  122, 41, -1, 9424, -1, 9425, -1, 9426, 
  -1, 9427, -1, 9428, -1, 9429, -1, 9430, 
  -1, 9431, -1, 9432, -1, 9433, -1, 9434, 
  -1, 9435, -1, 9436, -1, 9437, -1, 9438, 
  -1, 9439, -1, 9440, -1, 9441, -1, 83, 
  -1, 9442, -1, 9443, -1, 9444, -1, 9445, 
  -1, 9446, -1, 9447, -1, 89, -1, 9448, 
  -1, 9449, -1, 8747, 8747, 8747, 8747, -1, 
  58, 58, 61, -1, 61, 61, -1, 61, 
  61, 61, -1, 10973, 824, -1, 11312, -1, 
  11313, -1, 11314, -1, 11315, -1, 11316, -1, 
  11317, -1, 11318, -1, 11319, -1, 11320, -1, 
  11321, -1, 11322, -1, 11323, -1, 11324, -1, 
  11325, -1, 11326, -1, 11327, -1, 11328, -1, 
  11329, -1, 11330, -1, 11331, -1, 11332, -1, 
  11333, -1, 11334, -1, 11335, -1, 11336, -1, 
  11337, -1, 11338, -1, 11339, -1, 11340, -1, 
  11341, -1, 11342, -1, 11343, -1, 11344, -1, 
  11345, -1, 11346, -1, 11347, -1, 11348, -1, 
  11349, -1, 11350, -1, 11351, -1, 11352, -1, 
  11353, -1, 11354, -1, 11355, -1, 11356, -1, 
  11357, -1, 11358, -1, 11361, -1, 619, -1, 
  7549, -1, 637, -1, 11368, -1, 11370, -1, 
  11372, -1, 11379, -1, 11382, -1, 575, -1, 
  576, -1, 11393, -1, 11395, -1, 11397, -1, 
  11399, -1, 11401, -1, 11403, -1, 11405, -1, 
  11407, -1, 11409, -1, 11411, -1, 11413, -1, 
  11415, -1, 11417, -1, 11419, -1, 11421, -1, 
  11423, -1, 11425, -1, 11427, -1, 11429, -1, 
  11431, -1, 11433, -1, 11435, -1, 11437, -1, 
  11439, -1, 11441, -1, 11443, -1, 11445, -1, 
  11447, -1, 11449, -1, 11451, -1, 11453, -1, 
  11455, -1, 11457, -1, 11459, -1, 11461, -1, 
  11463, -1, 11465, -1, 11467, -1, 11469, -1, 
  11471, -1, 11473, -1, 11475, -1, 11477, -1, 
  11479, -1, 11481, -1, 11483, -1, 11485, -1, 
  11487, -1, 11489, -1, 11491, -1, 11500, -1, 
  11502, -1, 11507, -1, 11617, -1, 27597, -1, 
  40863, -1, 19968, -1, 20008, -1, 20022, -1, 
  20031, -1, 20057, -1, 20101, -1, 20108, -1, 
  20128, -1, 20154, -1, 20799, -1, 20837, -1, 
  20843, -1, 20866, -1, 20886, -1, 20907, -1, 
  20960, -1, 20981, -1, 20992, -1, 21147, -1, 
  21241, -1, 21269, -1, 21274, -1, 21304, -1, 
  21313, -1, 21340, -1, 21353, -1, 21378, -1, 
  21430, -1, 21448, -1, 21475, -1, 22231, -1, 
  22303, -1, 22763, -1, 22786, -1, 22794, -1, 
  22805, -1, 22823, -1, 22899, -1, 23376, -1, 
  23424, -1, 23544, -1, 23567, -1, 23586, -1, 
  23608, -1, 23662, -1, 23665, -1, 24027, -1, 
  24037, -1, 24049, -1, 24062, -1, 24178, -1, 
  24186, -1, 24191, -1, 24308, -1, 24318, -1, 
  24331, -1, 24339, -1, 24400, -1, 24417, -1, 
  24435, -1, 24515, -1, 25096, -1, 25142, -1, 
  25163, -1, 25903, -1, 25908, -1, 25991, -1, 
  26007, -1, 26020, -1, 26041, -1, 26080, -1, 
  26085, -1, 26352, -1, 26376, -1, 26408, -1, 
  27424, -1, 27490, -1, 27513, -1, 27571, -1, 
  27595, -1, 27604, -1, 27611, -1, 27663, -1, 
  27668, -1, 27700, -1, 28779, -1, 29226, -1, 
  29238, -1, 29243, -1, 29247, -1, 29255, -1, 
  29273, -1, 29275, -1, 29356, -1, 29572, -1, 
  29577, -1, 29916, -1, 29926, -1, 29976, -1, 
  29983, -1, 29992, -1, 30000, -1, 30091, -1, 
  30098, -1, 30326, -1, 30333, -1, 30382, -1, 
  30399, -1, 30446, -1, 30683, -1, 30690, -1, 
  30707, -1, 31034, -1, 31160, -1, 31166, -1, 
  31348, -1, 31435, -1, 31481, -1, 31859, -1, 
  31992, -1, 32566, -1, 32593, -1, 32650, -1, 
  32701, -1, 32769, -1, 32780, -1, 32786, -1, 
  32819, -1, 32895, -1, 32905, -1, 33251, -1, 
  33258, -1, 33267, -1, 33276, -1, 33292, -1, 
  33307, -1, 33311, -1, 33390, -1, 33394, -1, 
  33400, -1, 34381, -1, 34411, -1, 34880, -1, 
  34892, -1, 34915, -1, 35198, -1, 35211, -1, 
  35282, -1, 35328, -1, 35895, -1, 35910, -1, 
  35925, -1, 35960, -1, 35997, -1, 36196, -1, 
  36208, -1, 36275, -1, 36523, -1, 36554, -1, 
  36763, -1, 36784, -1, 36789, -1, 37009, -1, 
  37193, -1, 37318, -1, 37324, -1, 37329, -1, 
  38263, -1, 38272, -1, 38428, -1, 38582, -1, 
  38585, -1, 38632, -1, 38737, -1, 38750, -1, 
  38754, -1, 38761, -1, 38859, -1, 38893, -1, 
  38899, -1, 38913, -1, 39080, -1, 39131, -1, 
  39135, -1, 39318, -1, 39321, -1, 39340, -1, 
  39592, -1, 39640, -1, 39647, -1, 39717, -1, 
  39727, -1, 39730, -1, 39740, -1, 39770, -1, 
  40165, -1, 40565, -1, 40575, -1, 40613, -1, 
  40635, -1, 40643, -1, 40653, -1, 40657, -1, 
  40697, -1, 40701, -1, 40718, -1, 40723, -1, 
  40736, -1, 40763, -1, 40778, -1, 40786, -1, 
  40845, -1, 40860, -1, 40864, -1, 12306, -1, 
  21316, -1, 21317, -1, 12363, 12441, -1, 12365, 
  12441, -1, 12367, 12441, -1, 12369, 12441, -1, 
  12371, 12441, -1, 12373, 12441, -1, 12375, 12441, 
  -1, 12377, 12441, -1, 12379, 12441, -1, 12381, 
  12441, -1, 12383, 12441, -1, 12385, 12441, -1, 
  12388, 12441, -1, 12390, 12441, -1, 12392, 12441, 
  -1, 12399, 12441, -1, 12399, 12442, -1, 12402, 
  12441, -1, 12402, 12442, -1, 12405, 12441, -1, 
  12405, 12442, -1, 12408, 12441, -1, 12408, 12442, 
  -1, 12411, 12441, -1, 12411, 12442, -1, 12358, 
  12441, -1, 32, 12441, -1, 32, 12442, -1, 
  12445, 12441, -1, 12424, 12426, -1, 12459, 12441, 
  -1, 12461, 12441, -1, 12463, 12441, -1, 12465, 
  12441, -1, 12467, 12441, -1, 12469, 12441, -1, 
  12471, 12441, -1, 12473, 12441, -1, 12475, 12441, 
  -1, 12477, 12441, -1, 12479, 12441, -1, 12481, 
  12441, -1, 12484, 12441, -1, 12486, 12441, -1, 
  12488, 12441, -1, 12495, 12441, -1, 12495, 12442, 
  -1, 12498, 12441, -1, 12498, 12442, -1, 12501, 
  12441, -1, 12501, 12442, -1, 12504, 12441, -1, 
  12504, 12442, -1, 12507, 12441, -1, 12507, 12442, 
  -1, 12454, 12441, -1, 12527, 12441, -1, 12528, 
  12441, -1, 12529, 12441, -1, 12530, 12441, -1, 
  12541, 12441, -1, 12467, 12488, -1, 4352, -1, 
  4353, -1, 4522, -1, 4354, -1, 4524, -1, 
  4525, -1, 4355, -1, 4356, -1, 4357, -1, 
  4528, -1, 4529, -1, 4530, -1, 4531, -1, 
  4532, -1, 4533, -1, 4378, -1, 4358, -1, 
  4359, -1, 4360, -1, 4385, -1, 4361, -1, 
  4362, -1, 4363, -1, 4364, -1, 4365, -1, 
  4366, -1, 4367, -1, 4368, -1, 4369, -1, 
  4370, -1, 4449, -1, 4450, -1, 4451, -1, 
  4452, -1, 4453, -1, 4454, -1, 4455, -1, 
  4456, -1, 4457, -1, 4458, -1, 4459, -1, 
  4460, -1, 4461, -1, 4462, -1, 4463, -1, 
  4464, -1, 4465, -1, 4466, -1, 4467, -1, 
  4468, -1, 4469, -1, 4448, -1, 4372, -1, 
  4373, -1, 4551, -1, 4552, -1, 4556, -1, 
  4558, -1, 4563, -1, 4567, -1, 4569, -1, 
  4380, -1, 4573, -1, 4575, -1, 4381, -1, 
  4382, -1, 4384, -1, 4386, -1, 4387, -1, 
  4391, -1, 4393, -1, 4395, -1, 4396, -1, 
  4397, -1, 4398, -1, 4399, -1, 4402, -1, 
  4406, -1, 4416, -1, 4423, -1, 4428, -1, 
  4593, -1, 4594, -1, 4439, -1, 4440, -1, 
  4441, -1, 4484, -1, 4485, -1, 4488, -1, 
  4497, -1, 4498, -1, 4500, -1, 4510, -1, 
  4513, -1, 19977, -1, 22235, -1, 19978, -1, 
  20013, -1, 19979, -1, 30002, -1, 19993, -1, 
  19969, -1, 22825, -1, 22320, -1, 40, 4352, 
  41, -1, 40, 4354, 41, -1, 40, 4355, 
  41, -1, 40, 4357, 41, -1, 40, 4358, 
  41, -1, 40, 4359, 41, -1, 40, 4361, 
  41, -1, 40, 4363, 41, -1, 40, 4364, 
  41, -1, 40, 4366, 41, -1, 40, 4367, 
  41, -1, 40, 4368, 41, -1, 40, 4369, 
  41, -1, 40, 4370, 41, -1, 40, 4352, 
  4449, 41, -1, 40, 4354, 4449, 41, -1, 
  40, 4355, 4449, 41, -1, 40, 4357, 4449, 
  41, -1, 40, 4358, 4449, 41, -1, 40, 
  4359, 4449, 41, -1, 40, 4361, 4449, 41, 
  -1, 40, 4363, 4449, 41, -1, 40, 4364, 
  4449, 41, -1, 40, 4366, 4449, 41, -1, 
  40, 4367, 4449, 41, -1, 40, 4368, 4449, 
  41, -1, 40, 4369, 4449, 41, -1, 40, 
  4370, 4449, 41, -1, 40, 4364, 4462, 41, 
  -1, 40, 4363, 4457, 4364, 4453, 4523, 41, 
  -1, 40, 4363, 4457, 4370, 4462, 41, -1, 
  40, 19968, 41, -1, 40, 20108, 41, -1, 
  40, 19977, 41, -1, 40, 22235, 41, -1, 
  40, 20116, 41, -1, 40, 20845, 41, -1, 
  40, 19971, 41, -1, 40, 20843, 41, -1, 
  40, 20061, 41, -1, 40, 21313, 41, -1, 
  40, 26376, 41, -1, 40, 28779, 41, -1, 
  40, 27700, 41, -1, 40, 26408, 41, -1, 
  40, 37329, 41, -1, 40, 22303, 41, -1, 
  40, 26085, 41, -1, 40, 26666, 41, -1, 
  40, 26377, 41, -1, 40, 31038, 41, -1, 
  40, 21517, 41, -1, 40, 29305, 41, -1, 
  40, 36001, 41, -1, 40, 31069, 41, -1, 
  40, 21172, 41, -1, 40, 20195, 41, -1, 
  40, 21628, 41, -1, 40, 23398, 41, -1, 
  40, 30435, 41, -1, 40, 20225, 41, -1, 
  40, 36039, 41, -1, 40, 21332, 41, -1, 
  40, 31085, 41, -1, 40, 20241, 41, -1, 
  40, 33258, 41, -1, 40, 33267, 41, -1, 
  21839, -1, 24188, -1, 31631, -1, 80, 84, 
  69, -1, 50, 49, -1, 50, 50, -1, 
  50, 51, -1, 50, 52, -1, 50, 53, 
  -1, 50, 54, -1, 50, 55, -1, 50, 
  56, -1, 50, 57, -1, 51, 48, -1, 
  51, 49, -1, 51, 50, -1, 51, 51, 
  -1, 51, 52, -1, 51, 53, -1, 4352, 
  4449, -1, 4354, 4449, -1, 4355, 4449, -1, 
  4357, 4449, -1, 4358, 4449, -1, 4359, 4449, 
  -1, 4361, 4449, -1, 4363, 4449, -1, 4364, 
  4449, -1, 4366, 4449, -1, 4367, 4449, -1, 
  4368, 4449, -1, 4369, 4449, -1, 4370, 4449, 
  -1, 4366, 4449, 4535, 4352, 4457, -1, 4364, 
  4462, 4363, 4468, -1, 4363, 4462, -1, 20116, 
  -1, 20845, -1, 19971, -1, 20061, -1, 26666, 
  -1, 26377, -1, 31038, -1, 21517, -1, 29305, 
  -1, 36001, -1, 31069, -1, 21172, -1, 31192, 
  -1, 30007, -1, 36969, -1, 20778, -1, 21360, 
  -1, 27880, -1, 38917, -1, 20241, -1, 20889, 
  -1, 27491, -1, 24038, -1, 21491, -1, 21307, 
  -1, 23447, -1, 23398, -1, 30435, -1, 20225, 
  -1, 36039, -1, 21332, -1, 22812, -1, 51, 
  54, -1, 51, 55, -1, 51, 56, -1, 
  51, 57, -1, 52, 48, -1, 52, 49, 
  -1, 52, 50, -1, 52, 51, -1, 52, 
  52, -1, 52, 53, -1, 52, 54, -1, 
  52, 55, -1, 52, 56, -1, 52, 57, 
  -1, 53, 48, -1, 49, 26376, -1, 50, 
  26376, -1, 51, 26376, -1, 52, 26376, -1, 
  53, 26376, -1, 54, 26376, -1, 55, 26376, 
  -1, 56, 26376, -1, 57, 26376, -1, 49, 
  48, 26376, -1, 49, 49, 26376, -1, 49, 
  50, 26376, -1, 72, 103, -1, 101, 114, 
  103, -1, 101, 86, -1, 76, 84, 68, 
  -1, 12450, -1, 12452, -1, 12454, -1, 12456, 
  -1, 12458, -1, 12459, -1, 12461, -1, 12463, 
  -1, 12465, -1, 12467, -1, 12469, -1, 12471, 
  -1, 12473, -1, 12475, -1, 12477, -1, 12479, 
  -1, 12481, -1, 12484, -1, 12486, -1, 12488, 
  -1, 12490, -1, 12491, -1, 12492, -1, 12493, 
  -1, 12494, -1, 12495, -1, 12498, -1, 12501, 
  -1, 12504, -1, 12507, -1, 12510, -1, 12511, 
  -1, 12512, -1, 12513, -1, 12514, -1, 12516, 
  -1, 12518, -1, 12520, -1, 12521, -1, 12522, 
  -1, 12523, -1, 12524, -1, 12525, -1, 12527, 
  -1, 12528, -1, 12529, -1, 12530, -1, 12450, 
  12497, 12540, 12488, -1, 12450, 12523, 12501, 12449, 
  -1, 12450, 12531, 12506, 12450, -1, 12450, 12540, 
  12523, -1, 12452, 12491, 12531, 12464, -1, 12452, 
  12531, 12481, -1, 12454, 12457, 12531, -1, 12456, 
  12473, 12463, 12540, 12489, -1, 12456, 12540, 12459, 
  12540, -1, 12458, 12531, 12473, -1, 12458, 12540, 
  12512, -1, 12459, 12452, 12522, -1, 12459, 12521, 
  12483, 12488, -1, 12459, 12525, 12522, 12540, -1, 
  12460, 12525, 12531, -1, 12460, 12531, 12510, -1, 
  12462, 12460, -1, 12462, 12491, 12540, -1, 12461, 
  12517, 12522, 12540, -1, 12462, 12523, 12480, 12540, 
  -1, 12461, 12525, -1, 12461, 12525, 12464, 12521, 
  12512, -1, 12461, 12525, 12513, 12540, 12488, 12523, 
  -1, 12461, 12525, 12527, 12483, 12488, -1, 12464, 
  12521, 12512, -1, 12464, 12521, 12512, 12488, 12531, 
  -1, 12463, 12523, 12476, 12452, 12525, -1, 12463, 
  12525, 12540, 12493, -1, 12465, 12540, 12473, -1, 
  12467, 12523, 12490, -1, 12467, 12540, 12509, -1, 
  12469, 12452, 12463, 12523, -1, 12469, 12531, 12481, 
  12540, 12512, -1, 12471, 12522, 12531, 12464, -1, 
  12475, 12531, 12481, -1, 12475, 12531, 12488, -1, 
  12480, 12540, 12473, -1, 12487, 12471, -1, 12489, 
  12523, -1, 12488, 12531, -1, 12490, 12494, -1, 
  12494, 12483, 12488, -1, 12495, 12452, 12484, -1, 
  12497, 12540, 12475, 12531, 12488, -1, 12497, 12540, 
  12484, -1, 12496, 12540, 12524, 12523, -1, 12500, 
  12450, 12473, 12488, 12523, -1, 12500, 12463, 12523, 
  -1, 12500, 12467, -1, 12499, 12523, -1, 12501, 
  12449, 12521, 12483, 12489, -1, 12501, 12451, 12540, 
  12488, -1, 12502, 12483, 12471, 12455, 12523, -1, 
  12501, 12521, 12531, -1, 12504, 12463, 12479, 12540, 
  12523, -1, 12506, 12477, -1, 12506, 12491, 12498, 
  -1, 12504, 12523, 12484, -1, 12506, 12531, 12473, 
  -1, 12506, 12540, 12472, -1, 12505, 12540, 12479, 
  -1, 12509, 12452, 12531, 12488, -1, 12508, 12523, 
  12488, -1, 12507, 12531, -1, 12509, 12531, 12489, 
  -1, 12507, 12540, 12523, -1, 12507, 12540, 12531, 
  -1, 12510, 12452, 12463, 12525, -1, 12510, 12452, 
  12523, -1, 12510, 12483, 12495, -1, 12510, 12523, 
  12463, -1, 12510, 12531, 12471, 12519, 12531, -1, 
  12511, 12463, 12525, 12531, -1, 12511, 12522, -1, 
  12511, 12522, 12496, 12540, 12523, -1, 12513, 12460, 
  -1, 12513, 12460, 12488, 12531, -1, 12513, 12540, 
  12488, 12523, -1, 12516, 12540, 12489, -1, 12516, 
  12540, 12523, -1, 12518, 12450, 12531, -1, 12522, 
  12483, 12488, 12523, -1, 12522, 12521, -1, 12523, 
  12500, 12540, -1, 12523, 12540, 12502, 12523, -1, 
  12524, 12512, -1, 12524, 12531, 12488, 12466, 12531, 
  -1, 12527, 12483, 12488, -1, 48, 28857, -1, 
  49, 28857, -1, 50, 28857, -1, 51, 28857, 
  -1, 52, 28857, -1, 53, 28857, -1, 54, 
  28857, -1, 55, 28857, -1, 56, 28857, -1, 
  57, 28857, -1, 49, 48, 28857, -1, 49, 
  49, 28857, -1, 49, 50, 28857, -1, 49, 
  51, 28857, -1, 49, 52, 28857, -1, 49, 
  53, 28857, -1, 49, 54, 28857, -1, 49, 
  55, 28857, -1, 49, 56, 28857, -1, 49, 
  57, 28857, -1, 50, 48, 28857, -1, 50, 
  49, 28857, -1, 50, 50, 28857, -1, 50, 
  51, 28857, -1, 50, 52, 28857, -1, 104, 
  80, 97, -1, 100, 97, -1, 65, 85, 
  -1, 98, 97, 114, -1, 111, 86, -1, 
  112, 99, -1, 100, 109, -1, 100, 109, 
  178, -1, 100, 109, 179, -1, 73, 85, 
  -1, 24179, 25104, -1, 26157, 21644, -1, 22823, 
  27491, -1, 26126, 27835, -1, 26666, 24335, 20250, 
  31038, -1, 112, 65, -1, 110, 65, -1, 
  956, 65, -1, 109, 65, -1, 107, 65, 
  -1, 75, 66, -1, 77, 66, -1, 71, 
  66, -1, 99, 97, 108, -1, 107, 99, 
  97, 108, -1, 112, 70, -1, 110, 70, 
  -1, 956, 70, -1, 956, 103, -1, 109, 
  103, -1, 107, 103, -1, 72, 122, -1, 
  107, 72, 122, -1, 77, 72, 122, -1, 
  71, 72, 122, -1, 84, 72, 122, -1, 
  956, 8467, -1, 109, 8467, -1, 100, 8467, 
  -1, 107, 8467, -1, 102, 109, -1, 110, 
  109, -1, 956, 109, -1, 109, 109, -1, 
  99, 109, -1, 107, 109, -1, 109, 109, 
  178, -1, 99, 109, 178, -1, 109, 178, 
  -1, 107, 109, 178, -1, 109, 109, 179, 
  -1, 99, 109, 179, -1, 109, 179, -1, 
  107, 109, 179, -1, 109, 8725, 115, -1, 
  109, 8725, 115, 178, -1, 80, 97, -1, 
  107, 80, 97, -1, 77, 80, 97, -1, 
  71, 80, 97, -1, 114, 97, 100, -1, 
  114, 97, 100, 8725, 115, -1, 114, 97, 
  100, 8725, 115, 178, -1, 112, 115, -1, 
  110, 115, -1, 956, 115, -1, 109, 115, 
  -1, 112, 86, -1, 110, 86, -1, 956, 
  86, -1, 109, 86, -1, 107, 86, -1, 
  77, 86, -1, 112, 87, -1, 110, 87, 
  -1, 956, 87, -1, 109, 87, -1, 107, 
  87, -1, 77, 87, -1, 107, 937, -1, 
  77, 937, -1, 97, 46, 109, 46, -1, 
  66, 113, -1, 99, 99, -1, 99, 100, 
  -1, 67, 8725, 107, 103, -1, 67, 111, 
  46, -1, 100, 66, -1, 71, 121, -1, 
  104, 97, -1, 72, 80, -1, 105, 110, 
  -1, 75, 75, -1, 75, 77, -1, 107, 
  116, -1, 108, 109, -1, 108, 110, -1, 
  108, 111, 103, -1, 108, 120, -1, 109, 
  98, -1, 109, 105, 108, -1, 109, 111, 
  108, -1, 80, 72, -1, 112, 46, 109, 
  46, -1, 80, 80, 77, -1, 80, 82, 
  -1, 115, 114, -1, 83, 118, -1, 87, 
  98, -1, 86, 8725, 109, -1, 65, 8725, 
  109, -1, 49, 26085, -1, 50, 26085, -1, 
  51, 26085, -1, 52, 26085, -1, 53, 26085, 
  -1, 54, 26085, -1, 55, 26085, -1, 56, 
  26085, -1, 57, 26085, -1, 49, 48, 26085, 
  -1, 49, 49, 26085, -1, 49, 50, 26085, 
  -1, 49, 51, 26085, -1, 49, 52, 26085, 
  -1, 49, 53, 26085, -1, 49, 54, 26085, 
  -1, 49, 55, 26085, -1, 49, 56, 26085, 
  -1, 49, 57, 26085, -1, 50, 48, 26085, 
  -1, 50, 49, 26085, -1, 50, 50, 26085, 
  -1, 50, 51, 26085, -1, 50, 52, 26085, 
  -1, 50, 53, 26085, -1, 50, 54, 26085, 
  -1, 50, 55, 26085, -1, 50, 56, 26085, 
  -1, 50, 57, 26085, -1, 51, 48, 26085, 
  -1, 51, 49, 26085, -1, 103, 97, 108, 
  -1, 42561, -1, 42563, -1, 42565, -1, 42567, 
  -1, 42569, -1, 42571, -1, 42573, -1, 42575, 
  -1, 42577, -1, 42579, -1, 42581, -1, 42583, 
  -1, 42585, -1, 42587, -1, 42589, -1, 42591, 
  -1, 42593, -1, 42595, -1, 42597, -1, 42599, 
  -1, 42601, -1, 42603, -1, 42605, -1, 42625, 
  -1, 42627, -1, 42629, -1, 42631, -1, 42633, 
  -1, 42635, -1, 42637, -1, 42639, -1, 42641, 
  -1, 42643, -1, 42645, -1, 42647, -1, 42649, 
  -1, 42651, -1, 42787, -1, 42789, -1, 42791, 
  -1, 42793, -1, 42795, -1, 42797, -1, 42799, 
  -1, 42803, -1, 42805, -1, 42807, -1, 42809, 
  -1, 42811, -1, 42813, -1, 42815, -1, 42817, 
  -1, 42819, -1, 42821, -1, 42823, -1, 42825, 
  -1, 42827, -1, 42829, -1, 42831, -1, 42833, 
  -1, 42835, -1, 42837, -1, 42839, -1, 42841, 
  -1, 42843, -1, 42845, -1, 42847, -1, 42849, 
  -1, 42851, -1, 42853, -1, 42855, -1, 42857, 
  -1, 42859, -1, 42861, -1, 42863, -1, 42874, 
  -1, 42876, -1, 7545, -1, 42879, -1, 42881, 
  -1, 42883, -1, 42885, -1, 42887, -1, 42892, 
  -1, 42897, -1, 42899, -1, 42903, -1, 42905, 
  -1, 42907, -1, 42909, -1, 42911, -1, 42913, 
  -1, 42915, -1, 42917, -1, 42919, -1, 42921, 
  -1, 620, -1, 670, -1, 647, -1, 43859, 
  -1, 42933, -1, 42935, -1, 294, -1, 43831, 
  -1, 43858, -1, 5024, -1, 5025, -1, 5026, 
  -1, 5027, -1, 5028, -1, 5029, -1, 5030, 
  -1, 5031, -1, 5032, -1, 5033, -1, 5034, 
  -1, 5035, -1, 5036, -1, 5037, -1, 5038, 
  -1, 5039, -1, 5040, -1, 5041, -1, 5042, 
  -1, 5043, -1, 5044, -1, 5045, -1, 5046, 
  -1, 5047, -1, 5048, -1, 5049, -1, 5050, 
  -1, 5051, -1, 5052, -1, 5053, -1, 5054, 
  -1, 5055, -1, 5056, -1, 5057, -1, 5058, 
  -1, 5059, -1, 5060, -1, 5061, -1, 5062, 
  -1, 5063, -1, 5064, -1, 5065, -1, 5066, 
  -1, 5067, -1, 5068, -1, 5069, -1, 5070, 
  -1, 5071, -1, 5072, -1, 5073, -1, 5074, 
  -1, 5075, -1, 5076, -1, 5077, -1, 5078, 
  -1, 5079, -1, 5080, -1, 5081, -1, 5082, 
  -1, 5083, -1, 5084, -1, 5085, -1, 5086, 
  -1, 5087, -1, 5088, -1, 5089, -1, 5090, 
  -1, 5091, -1, 5092, -1, 5093, -1, 5094, 
  -1, 5095, -1, 5096, -1, 5097, -1, 5098, 
  -1, 5099, -1, 5100, -1, 5101, -1, 5102, 
  -1, 5103, -1, 35912, -1, 26356, -1, 36040, 
  -1, 28369, -1, 20018, -1, 21477, -1, 22865, 
  -1, 21895, -1, 22856, -1, 25078, -1, 30313, 
  -1, 32645, -1, 34367, -1, 34746, -1, 35064, 
  -1, 37007, -1, 27138, -1, 27931, -1, 28889, 
  -1, 29662, -1, 33853, -1, 37226, -1, 39409, 
  -1, 20098, -1, 21365, -1, 27396, -1, 29211, 
  -1, 34349, -1, 40478, -1, 23888, -1, 28651, 
  -1, 34253, -1, 35172, -1, 25289, -1, 33240, 
  -1, 34847, -1, 24266, -1, 26391, -1, 28010, 
  -1, 29436, -1, 37070, -1, 20358, -1, 20919, 
  -1, 21214, -1, 25796, -1, 27347, -1, 29200, 
  -1, 30439, -1, 34310, -1, 34396, -1, 36335, 
  -1, 38706, -1, 39791, -1, 40442, -1, 30860, 
  -1, 31103, -1, 32160, -1, 33737, -1, 37636, 
  -1, 35542, -1, 22751, -1, 24324, -1, 31840, 
  -1, 32894, -1, 29282, -1, 30922, -1, 36034, 
  -1, 38647, -1, 22744, -1, 23650, -1, 27155, 
  -1, 28122, -1, 28431, -1, 32047, -1, 32311, 
  -1, 38475, -1, 21202, -1, 32907, -1, 20956, 
  -1, 20940, -1, 31260, -1, 32190, -1, 33777, 
  -1, 38517, -1, 35712, -1, 25295, -1, 35582, 
  -1, 20025, -1, 23527, -1, 24594, -1, 29575, 
  -1, 30064, -1, 21271, -1, 30971, -1, 20415, 
  -1, 24489, -1, 19981, -1, 27852, -1, 25976, 
  -1, 32034, -1, 21443, -1, 22622, -1, 30465, 
  -1, 33865, -1, 35498, -1, 27578, -1, 27784, 
  -1, 25342, -1, 33509, -1, 25504, -1, 30053, 
  -1, 20142, -1, 20841, -1, 20937, -1, 26753, 
  -1, 31975, -1, 33391, -1, 35538, -1, 37327, 
  -1, 21237, -1, 21570, -1, 24300, -1, 26053, 
  -1, 28670, -1, 31018, -1, 38317, -1, 39530, 
  -1, 40599, -1, 40654, -1, 26310, -1, 27511, 
  -1, 36706, -1, 24180, -1, 24976, -1, 25088, 
  -1, 25754, -1, 28451, -1, 29001, -1, 29833, 
  -1, 31178, -1, 32244, -1, 32879, -1, 36646, 
  -1, 34030, -1, 36899, -1, 37706, -1, 21015, 
  -1, 21155, -1, 21693, -1, 28872, -1, 35010, 
  -1, 24265, -1, 24565, -1, 25467, -1, 27566, 
  -1, 31806, -1, 29557, -1, 20196, -1, 22265, 
  -1, 23994, -1, 24604, -1, 29618, -1, 29801, 
  -1, 32666, -1, 32838, -1, 37428, -1, 38646, 
  -1, 38728, -1, 38936, -1, 20363, -1, 31150, 
  -1, 37300, -1, 38584, -1, 24801, -1, 20102, 
  -1, 20698, -1, 23534, -1, 23615, -1, 26009, 
  -1, 29134, -1, 30274, -1, 34044, -1, 36988, 
  -1, 26248, -1, 38446, -1, 21129, -1, 26491, 
  -1, 26611, -1, 27969, -1, 28316, -1, 29705, 
  -1, 30041, -1, 30827, -1, 32016, -1, 39006, 
  -1, 25134, -1, 38520, -1, 20523, -1, 23833, 
  -1, 28138, -1, 36650, -1, 24459, -1, 24900, 
  -1, 26647, -1, 38534, -1, 21033, -1, 21519, 
  -1, 23653, -1, 26131, -1, 26446, -1, 26792, 
  -1, 27877, -1, 29702, -1, 30178, -1, 32633, 
  -1, 35023, -1, 35041, -1, 38626, -1, 21311, 
  -1, 28346, -1, 21533, -1, 29136, -1, 29848, 
  -1, 34298, -1, 38563, -1, 40023, -1, 40607, 
  -1, 26519, -1, 28107, -1, 33256, -1, 31520, 
  -1, 31890, -1, 29376, -1, 28825, -1, 35672, 
  -1, 20160, -1, 33590, -1, 21050, -1, 20999, 
  -1, 24230, -1, 25299, -1, 31958, -1, 23429, 
  -1, 27934, -1, 26292, -1, 36667, -1, 38477, 
  -1, 24275, -1, 20800, -1, 21952, -1, 22618, 
  -1, 26228, -1, 20958, -1, 29482, -1, 30410, 
  -1, 31036, -1, 31070, -1, 31077, -1, 31119, 
  -1, 38742, -1, 31934, -1, 34322, -1, 35576, 
  -1, 36920, -1, 37117, -1, 39151, -1, 39164, 
  -1, 39208, -1, 40372, -1, 37086, -1, 38583, 
  -1, 20398, -1, 20711, -1, 20813, -1, 21193, 
  -1, 21220, -1, 21329, -1, 21917, -1, 22022, 
  -1, 22120, -1, 22592, -1, 22696, -1, 23652, 
  -1, 24724, -1, 24936, -1, 24974, -1, 25074, 
  -1, 25935, -1, 26082, -1, 26257, -1, 26757, 
  -1, 28023, -1, 28186, -1, 28450, -1, 29038, 
  -1, 29227, -1, 29730, -1, 30865, -1, 31049, 
  -1, 31048, -1, 31056, -1, 31062, -1, 31117, 
  -1, 31118, -1, 31296, -1, 31361, -1, 31680, 
  -1, 32265, -1, 32321, -1, 32626, -1, 32773, 
  -1, 33261, -1, 33401, -1, 33879, -1, 35088, 
  -1, 35222, -1, 35585, -1, 35641, -1, 36051, 
  -1, 36104, -1, 36790, -1, 38627, -1, 38911, 
  -1, 38971, -1, 24693, -1, 148206, -1, 33304, 
  -1, 20006, -1, 20917, -1, 20840, -1, 20352, 
  -1, 20805, -1, 20864, -1, 21191, -1, 21242, 
  -1, 21845, -1, 21913, -1, 21986, -1, 22707, 
  -1, 22852, -1, 22868, -1, 23138, -1, 23336, 
  -1, 24274, -1, 24281, -1, 24425, -1, 24493, 
  -1, 24792, -1, 24910, -1, 24840, -1, 24928, 
  -1, 25140, -1, 25540, -1, 25628, -1, 25682, 
  -1, 25942, -1, 26395, -1, 26454, -1, 28379, 
  -1, 28363, -1, 28702, -1, 30631, -1, 29237, 
  -1, 29359, -1, 29809, -1, 29958, -1, 30011, 
  -1, 30237, -1, 30239, -1, 30427, -1, 30452, 
  -1, 30538, -1, 30528, -1, 30924, -1, 31409, 
  -1, 31867, -1, 32091, -1, 32574, -1, 33618, 
  -1, 33775, -1, 34681, -1, 35137, -1, 35206, 
  -1, 35519, -1, 35531, -1, 35565, -1, 35722, 
  -1, 36664, -1, 36978, -1, 37273, -1, 37494, 
  -1, 38524, -1, 38875, -1, 38923, -1, 39698, 
  -1, 141386, -1, 141380, -1, 144341, -1, 15261, 
  -1, 16408, -1, 16441, -1, 152137, -1, 154832, 
  -1, 163539, -1, 40771, -1, 40846, -1, 102, 
  102, -1, 102, 105, -1, 102, 108, -1, 
  102, 102, 105, -1, 102, 102, 108, -1, 
  383, 116, -1, 115, 116, -1, 1396, 1398, 
  -1, 1396, 1381, -1, 1396, 1387, -1, 1406, 
  1398, -1, 1396, 1389, -1, 1497, 1460, -1, 
  1522, 1463, -1, 1506, -1, 1492, -1, 1499, 
  -1, 1500, -1, 1501, -1, 1512, -1, 1514, 
  -1, 1513, 1473, -1, 1513, 1474, -1, 64329, 
  1473, -1, 64329, 1474, -1, 1488, 1463, -1, 
  1488, 1464, -1, 1488, 1468, -1, 1489, 1468, 
  -1, 1490, 1468, -1, 1491, 1468, -1, 1492, 
  1468, -1, 1493, 1468, -1, 1494, 1468, -1, 
  1496, 1468, -1, 1497, 1468, -1, 1498, 1468, 
  -1, 1499, 1468, -1, 1500, 1468, -1, 1502, 
  1468, -1, 1504, 1468, -1, 1505, 1468, -1, 
  1507, 1468, -1, 1508, 1468, -1, 1510, 1468, 
  -1, 1511, 1468, -1, 1512, 1468, -1, 1513, 
  1468, -1, 1514, 1468, -1, 1493, 1465, -1, 
  1489, 1471, -1, 1499, 1471, -1, 1508, 1471, 
  -1, 1488, 1500, -1, 1649, -1, 1659, -1, 
  1662, -1, 1664, -1, 1658, -1, 1663, -1, 
  1657, -1, 1700, -1, 1702, -1, 1668, -1, 
  1667, -1, 1670, -1, 1671, -1, 1677, -1, 
  1676, -1, 1678, -1, 1672, -1, 1688, -1, 
  1681, -1, 1705, -1, 1711, -1, 1715, -1, 
  1713, -1, 1722, -1, 1723, -1, 1728, -1, 
  1729, -1, 1726, -1, 1746, -1, 1747, -1, 
  1709, -1, 1735, -1, 1734, -1, 1736, -1, 
  1655, -1, 1739, -1, 1733, -1, 1737, -1, 
  1744, -1, 1609, -1, 1574, 1575, -1, 1574, 
  1749, -1, 1574, 1608, -1, 1574, 1735, -1, 
  1574, 1734, -1, 1574, 1736, -1, 1574, 1744, 
  -1, 1574, 1609, -1, 1740, -1, 1574, 1580, 
  -1, 1574, 1581, -1, 1574, 1605, -1, 1574, 
  1610, -1, 1576, 1580, -1, 1576, 1581, -1, 
  1576, 1582, -1, 1576, 1605, -1, 1576, 1609, 
  -1, 1576, 1610, -1, 1578, 1580, -1, 1578, 
  1581, -1, 1578, 1582, -1, 1578, 1605, -1, 
  1578, 1609, -1, 1578, 1610, -1, 1579, 1580, 
  -1, 1579, 1605, -1, 1579, 1609, -1, 1579, 
  1610, -1, 1580, 1581, -1, 1580, 1605, -1, 
  1581, 1580, -1, 1581, 1605, -1, 1582, 1580, 
  -1, 1582, 1581, -1, 1582, 1605, -1, 1587, 
  1580, -1, 1587, 1581, -1, 1587, 1582, -1, 
  1587, 1605, -1, 1589, 1581, -1, 1589, 1605, 
  -1, 1590, 1580, -1, 1590, 1581, -1, 1590, 
  1582, -1, 1590, 1605, -1, 1591, 1581, -1, 
  1591, 1605, -1, 1592, 1605, -1, 1593, 1580, 
  -1, 1593, 1605, -1, 1594, 1580, -1, 1594, 
  1605, -1, 1601, 1580, -1, 1601, 1581, -1, 
  1601, 1582, -1, 1601, 1605, -1, 1601, 1609, 
  -1, 1601, 1610, -1, 1602, 1581, -1, 1602, 
  1605, -1, 1602, 1609, -1, 1602, 1610, -1, 
  1603, 1575, -1, 1603, 1580, -1, 1603, 1581, 
  -1, 1603, 1582, -1, 1603, 1604, -1, 1603, 
  1605, -1, 1603, 1609, -1, 1603, 1610, -1, 
  1604, 1580, -1, 1604, 1581, -1, 1604, 1582, 
  -1, 1604, 1605, -1, 1604, 1609, -1, 1604, 
  1610, -1, 1605, 1580, -1, 1605, 1581, -1, 
  1605, 1582, -1, 1605, 1605, -1, 1605, 1609, 
  -1, 1605, 1610, -1, 1606, 1580, -1, 1606, 
  1581, -1, 1606, 1582, -1, 1606, 1605, -1, 
  1606, 1609, -1, 1606, 1610, -1, 1607, 1580, 
  -1, 1607, 1605, -1, 1607, 1609, -1, 1607, 
  1610, -1, 1610, 1580, -1, 1610, 1581, -1, 
  1610, 1582, -1, 1610, 1605, -1, 1610, 1609, 
  -1, 1610, 1610, -1, 1584, 1648, -1, 1585, 
  1648, -1, 1609, 1648, -1, 32, 1612, 1617, 
  -1, 32, 1613, 1617, -1, 32, 1614, 1617, 
  -1, 32, 1615, 1617, -1, 32, 1616, 1617, 
  -1, 32, 1617, 1648, -1, 1574, 1585, -1, 
  1574, 1586, -1, 1574, 1606, -1, 1576, 1585, 
  -1, 1576, 1586, -1, 1576, 1606, -1, 1578, 
  1585, -1, 1578, 1586, -1, 1578, 1606, -1, 
  1579, 1585, -1, 1579, 1586, -1, 1579, 1606, 
  -1, 1605, 1575, -1, 1606, 1585, -1, 1606, 
  1586, -1, 1606, 1606, -1, 1610, 1585, -1, 
  1610, 1586, -1, 1610, 1606, -1, 1574, 1582, 
  -1, 1574, 1607, -1, 1576, 1607, -1, 1578, 
  1607, -1, 1589, 1582, -1, 1604, 1607, -1, 
  1606, 1607, -1, 1607, 1648, -1, 1610, 1607, 
  -1, 1579, 1607, -1, 1587, 1607, -1, 1588, 
  1605, -1, 1588, 1607, -1, 1600, 1614, 1617, 
  -1, 1600, 1615, 1617, -1, 1600, 1616, 1617, 
  -1, 1591, 1609, -1, 1591, 1610, -1, 1593, 
  1609, -1, 1593, 1610, -1, 1594, 1609, -1, 
  1594, 1610, -1, 1587, 1609, -1, 1587, 1610, 
  -1, 1588, 1609, -1, 1588, 1610, -1, 1581, 
  1609, -1, 1581, 1610, -1, 1580, 1609, -1, 
  1580, 1610, -1, 1582, 1609, -1, 1582, 1610, 
  -1, 1589, 1609, -1, 1589, 1610, -1, 1590, 
  1609, -1, 1590, 1610, -1, 1588, 1580, -1, 
  1588, 1581, -1, 1588, 1582, -1, 1588, 1585, 
  -1, 1587, 1585, -1, 1589, 1585, -1, 1590, 
  1585, -1, 1575, 1611, -1, 1578, 1580, 1605, 
  -1, 1578, 1581, 1580, -1, 1578, 1581, 1605, 
  -1, 1578, 1582, 1605, -1, 1578, 1605, 1580, 
  -1, 1578, 1605, 1581, -1, 1578, 1605, 1582, 
  -1, 1580, 1605, 1581, -1, 1581, 1605, 1610, 
  -1, 1581, 1605, 1609, -1, 1587, 1581, 1580, 
  -1, 1587, 1580, 1581, -1, 1587, 1580, 1609, 
  -1, 1587, 1605, 1581, -1, 1587, 1605, 1580, 
  -1, 1587, 1605, 1605, -1, 1589, 1581, 1581, 
  -1, 1589, 1605, 1605, -1, 1588, 1581, 1605, 
  -1, 1588, 1580, 1610, -1, 1588, 1605, 1582, 
  -1, 1588, 1605, 1605, -1, 1590, 1581, 1609, 
  -1, 1590, 1582, 1605, -1, 1591, 1605, 1581, 
  -1, 1591, 1605, 1605, -1, 1591, 1605, 1610, 
  -1, 1593, 1580, 1605, -1, 1593, 1605, 1605, 
  -1, 1593, 1605, 1609, -1, 1594, 1605, 1605, 
  -1, 1594, 1605, 1610, -1, 1594, 1605, 1609, 
  -1, 1601, 1582, 1605, -1, 1602, 1605, 1581, 
  -1, 1602, 1605, 1605, -1, 1604, 1581, 1605, 
  -1, 1604, 1581, 1610, -1, 1604, 1581, 1609, 
  -1, 1604, 1580, 1580, -1, 1604, 1582, 1605, 
  -1, 1604, 1605, 1581, -1, 1605, 1581, 1580, 
  -1, 1605, 1581, 1605, -1, 1605, 1581, 1610, 
  -1, 1605, 1580, 1581, -1, 1605, 1580, 1605, 
  -1, 1605, 1582, 1580, -1, 1605, 1582, 1605, 
  -1, 1605, 1580, 1582, -1, 1607, 1605, 1580, 
  -1, 1607, 1605, 1605, -1, 1606, 1581, 1605, 
  -1, 1606, 1581, 1609, -1, 1606, 1580, 1605, 
  -1, 1606, 1580, 1609, -1, 1606, 1605, 1610, 
  -1, 1606, 1605, 1609, -1, 1610, 1605, 1605, 
  -1, 1576, 1582, 1610, -1, 1578, 1580, 1610, 
  -1, 1578, 1580, 1609, -1, 1578, 1582, 1610, 
  -1, 1578, 1582, 1609, -1, 1578, 1605, 1610, 
  -1, 1578, 1605, 1609, -1, 1580, 1605, 1610, 
  -1, 1580, 1581, 1609, -1, 1580, 1605, 1609, 
  -1, 1587, 1582, 1609, -1, 1589, 1581, 1610, 
  -1, 1588, 1581, 1610, -1, 1590, 1581, 1610, 
  -1, 1604, 1580, 1610, -1, 1604, 1605, 1610, 
  -1, 1610, 1581, 1610, -1, 1610, 1580, 1610, 
  -1, 1610, 1605, 1610, -1, 1605, 1605, 1610, 
  -1, 1602, 1605, 1610, -1, 1606, 1581, 1610, 
  -1, 1593, 1605, 1610, -1, 1603, 1605, 1610, 
  -1, 1606, 1580, 1581, -1, 1605, 1582, 1610, 
  -1, 1604, 1580, 1605, -1, 1603, 1605, 1605, 
  -1, 1580, 1581, 1610, -1, 1581, 1580, 1610, 
  -1, 1605, 1580, 1610, -1, 1601, 1605, 1610, 
  -1, 1576, 1581, 1610, -1, 1587, 1582, 1610, 
  -1, 1606, 1580, 1610, -1, 1589, 1604, 1746, 
  -1, 1602, 1604, 1746, -1, 1575, 1604, 1604, 
  1607, -1, 1575, 1603, 1576, 1585, -1, 1605, 
  1581, 1605, 1583, -1, 1589, 1604, 1593, 1605, 
  -1, 1585, 1587, 1608, 1604, -1, 1593, 1604, 
  1610, 1607, -1, 1608, 1587, 1604, 1605, -1, 
  1589, 1604, 1609, -1, 1589, 1604, 1609, 32, 
  1575, 1604, 1604, 1607, 32, 1593, 1604, 1610, 
  1607, 32, 1608, 1587, 1604, 1605, -1, 1580, 
  1604, 32, 1580, 1604, 1575, 1604, 1607, -1, 
  1585, 1740, 1575, 1604, -1, 44, -1, 12289, 
  -1, 12290, -1, 58, -1, 33, -1, 63, 
  -1, 12310, -1, 12311, -1, 8230, -1, 8229, 
  -1, 8212, -1, 8211, -1, 95, -1, 123, 
  -1, 125, -1, 12308, -1, 12309, -1, 12304, 
  -1, 12305, -1, 12298, -1, 12299, -1, 12300, 
  -1, 12301, -1, 12302, -1, 12303, -1, 91, 
  -1, 93, -1, 8254, -1, 35, -1, 38, 
  -1, 42, -1, 45, -1, 60, -1, 62, 
  -1, 92, -1, 36, -1, 37, -1, 64, 
  -1, 32, 1611, -1, 1600, 1611, -1, 32, 
  1612, -1, 32, 1613, -1, 32, 1614, -1, 
  1600, 1614, -1, 32, 1615, -1, 1600, 1615, 
  -1, 32, 1616, -1, 1600, 1616, -1, 32, 
  1617, -1, 1600, 1617, -1, 32, 1618, -1, 
  1600, 1618, -1, 1569, -1, 1570, -1, 1571, 
  -1, 1572, -1, 1573, -1, 1574, -1, 1575, 
  -1, 1576, -1, 1577, -1, 1578, -1, 1579, 
  -1, 1580, -1, 1581, -1, 1582, -1, 1583, 
  -1, 1584, -1, 1585, -1, 1586, -1, 1587, 
  -1, 1588, -1, 1589, -1, 1590, -1, 1591, 
  -1, 1592, -1, 1593, -1, 1594, -1, 1601, 
  -1, 1602, -1, 1603, -1, 1604, -1, 1605, 
  -1, 1606, -1, 1607, -1, 1608, -1, 1610, 
  -1, 1604, 1570, -1, 1604, 1571, -1, 1604, 
  1573, -1, 1604, 1575, -1, 34, -1, 39, 
  -1, 47, -1, 65345, -1, 65346, -1, 65347, 
  -1, 65348, -1, 65349, -1, 65350, -1, 65351, 
  -1, 65352, -1, 65353, -1, 65354, -1, 65355, 
  -1, 65356, -1, 65357, -1, 65358, -1, 65359, 
  -1, 65360, -1, 65361, -1, 65362, -1, 65363, 
  -1, 65364, -1, 65365, -1, 65366, -1, 65367, 
  -1, 65368, -1, 65369, -1, 65370, -1, 94, 
  -1, 124, -1, 126, -1, 10629, -1, 10630, 
  -1, 12539, -1, 12449, -1, 12451, -1, 12453, 
  -1, 12455, -1, 12457, -1, 12515, -1, 12517, 
  -1, 12519, -1, 12483, -1, 12540, -1, 12531, 
  -1, 12441, -1, 12442, -1, 12644, -1, 12593, 
  -1, 12594, -1, 12595, -1, 12596, -1, 12597, 
  -1, 12598, -1, 12599, -1, 12600, -1, 12601, 
  -1, 12602, -1, 12603, -1, 12604, -1, 12605, 
  -1, 12606, -1, 12607, -1, 12608, -1, 12609, 
  -1, 12610, -1, 12611, -1, 12612, -1, 12613, 
  -1, 12614, -1, 12615, -1, 12616, -1, 12617, 
  -1, 12618, -1, 12619, -1, 12620, -1, 12621, 
  -1, 12622, -1, 12623, -1, 12624, -1, 12625, 
  -1, 12626, -1, 12627, -1, 12628, -1, 12629, 
  -1, 12630, -1, 12631, -1, 12632, -1, 12633, 
  -1, 12634, -1, 12635, -1, 12636, -1, 12637, 
  -1, 12638, -1, 12639, -1, 12640, -1, 12641, 
  -1, 12642, -1, 12643, -1, 162, -1, 163, 
  -1, 172, -1, 175, -1, 166, -1, 165, 
  -1, 8361, -1, 9474, -1, 8592, -1, 8593, 
  -1, 8594, -1, 8595, -1, 9632, -1, 9675, 
  -1, 66600, -1, 66601, -1, 66602, -1, 66603, 
  -1, 66604, -1, 66605, -1, 66606, -1, 66607, 
  -1, 66608, -1, 66609, -1, 66610, -1, 66611, 
  -1, 66612, -1, 66613, -1, 66614, -1, 66615, 
  -1, 66616, -1, 66617, -1, 66618, -1, 66619, 
  -1, 66620, -1, 66621, -1, 66622, -1, 66623, 
  -1, 66624, -1, 66625, -1, 66626, -1, 66627, 
  -1, 66628, -1, 66629, -1, 66630, -1, 66631, 
  -1, 66632, -1, 66633, -1, 66634, -1, 66635, 
  -1, 66636, -1, 66637, -1, 66638, -1, 66639, 
  -1, 68800, -1, 68801, -1, 68802, -1, 68803, 
  -1, 68804, -1, 68805, -1, 68806, -1, 68807, 
  -1, 68808, -1, 68809, -1, 68810, -1, 68811, 
  -1, 68812, -1, 68813, -1, 68814, -1, 68815, 
  -1, 68816, -1, 68817, -1, 68818, -1, 68819, 
  -1, 68820, -1, 68821, -1, 68822, -1, 68823, 
  -1, 68824, -1, 68825, -1, 68826, -1, 68827, 
  -1, 68828, -1, 68829, -1, 68830, -1, 68831, 
  -1, 68832, -1, 68833, -1, 68834, -1, 68835, 
  -1, 68836, -1, 68837, -1, 68838, -1, 68839, 
  -1, 68840, -1, 68841, -1, 68842, -1, 68843, 
  -1, 68844, -1, 68845, -1, 68846, -1, 68847, 
  -1, 68848, -1, 68849, -1, 68850, -1, 69785, 
  69818, -1, 69787, 69818, -1, 69797, 69818, -1, 
  69937, 69927, -1, 69938, 69927, -1, 70471, 70462, 
  -1, 70471, 70487, -1, 70841, 70842, -1, 70841, 
  70832, -1, 70841, 70845, -1, 71096, 71087, -1, 
  71097, 71087, -1, 71872, -1, 71873, -1, 71874, 
  -1, 71875, -1, 71876, -1, 71877, -1, 71878, 
  -1, 71879, -1, 71880, -1, 71881, -1, 71882, 
  -1, 71883, -1, 71884, -1, 71885, -1, 71886, 
  -1, 71887, -1, 71888, -1, 71889, -1, 71890, 
  -1, 71891, -1, 71892, -1, 71893, -1, 71894, 
  -1, 71895, -1, 71896, -1, 71897, -1, 71898, 
  -1, 71899, -1, 71900, -1, 71901, -1, 71902, 
  -1, 71903, -1, 119127, 119141, -1, 119128, 119141, 
  -1, 119135, 119150, -1, 119135, 119151, -1, 119135, 
  119152, -1, 119135, 119153, -1, 119135, 119154, -1, 
  119225, 119141, -1, 119226, 119141, -1, 119227, 119150, 
  -1, 119228, 119150, -1, 119227, 119151, -1, 119228, 
  119151, -1, 305, -1, 567, -1, 913, -1, 
  914, -1, 916, -1, 917, -1, 918, -1, 
  919, -1, 921, -1, 922, -1, 923, -1, 
  924, -1, 925, -1, 926, -1, 927, -1, 
  929, -1, 1012, -1, 932, -1, 934, -1, 
  935, -1, 936, -1, 8711, -1, 8706, -1, 
  1013, -1, 977, -1, 1008, -1, 981, -1, 
  1009, -1, 982, -1, 988, -1, 1646, -1, 
  1697, -1, 1647, -1, 48, 46, -1, 48, 
  44, -1, 49, 44, -1, 50, 44, -1, 
  51, 44, -1, 52, 44, -1, 53, 44, 
  -1, 54, 44, -1, 55, 44, -1, 56, 
  44, -1, 57, 44, -1, 40, 65, 41, 
  -1, 40, 66, 41, -1, 40, 67, 41, 
  -1, 40, 68, 41, -1, 40, 69, 41, 
  -1, 40, 70, 41, -1, 40, 71, 41, 
  -1, 40, 72, 41, -1, 40, 73, 41, 
  -1, 40, 74, 41, -1, 40, 75, 41, 
  -1, 40, 76, 41, -1, 40, 77, 41, 
  -1, 40, 78, 41, -1, 40, 79, 41, 
  -1, 40, 80, 41, -1, 40, 81, 41, 
  -1, 40, 82, 41, -1, 40, 83, 41, 
  -1, 40, 84, 41, -1, 40, 85, 41, 
  -1, 40, 86, 41, -1, 40, 87, 41, 
  -1, 40, 88, 41, -1, 40, 89, 41, 
  -1, 40, 90, 41, -1, 12308, 83, 12309, 
  -1, 67, 68, -1, 87, 90, -1, 72, 
  86, -1, 83, 68, -1, 83, 83, -1, 
  80, 80, 86, -1, 87, 67, -1, 77, 
  67, -1, 77, 68, -1, 68, 74, -1, 
  12411, 12363, -1, 12467, 12467, -1, 23383, -1, 
  21452, -1, 12487, -1, 22810, -1, 35299, -1, 
  20132, -1, 26144, -1, 28961, -1, 21069, -1, 
  24460, -1, 20877, -1, 26032, -1, 21021, -1, 
  32066, -1, 36009, -1, 22768, -1, 21561, -1, 
  28436, -1, 25237, -1, 25429, -1, 36938, -1, 
  25351, -1, 25171, -1, 31105, -1, 31354, -1, 
  21512, -1, 28288, -1, 30003, -1, 21106, -1, 
  21942, -1, 12308, 26412, 12309, -1, 12308, 19977, 
  12309, -1, 12308, 20108, 12309, -1, 12308, 23433, 
  12309, -1, 12308, 28857, 12309, -1, 12308, 25171, 
  12309, -1, 12308, 30423, 12309, -1, 12308, 21213, 
  12309, -1, 12308, 25943, 12309, -1, 24471, -1, 
  21487, -1, 20029, -1, 20024, -1, 20033, -1, 
  131362, -1, 20320, -1, 20411, -1, 20482, -1, 
  20602, -1, 20633, -1, 20687, -1, 13470, -1, 
  132666, -1, 20820, -1, 20836, -1, 20855, -1, 
  132380, -1, 13497, -1, 20839, -1, 132427, -1, 
  20887, -1, 20900, -1, 20172, -1, 20908, -1, 
  168415, -1, 20995, -1, 13535, -1, 21051, -1, 
  21062, -1, 21111, -1, 13589, -1, 21253, -1, 
  21254, -1, 21321, -1, 21338, -1, 21363, -1, 
  21373, -1, 21375, -1, 133676, -1, 28784, -1, 
  21450, -1, 21471, -1, 133987, -1, 21483, -1, 
  21489, -1, 21510, -1, 21662, -1, 21560, -1, 
  21576, -1, 21608, -1, 21666, -1, 21750, -1, 
  21776, -1, 21843, -1, 21859, -1, 21892, -1, 
  21931, -1, 21939, -1, 21954, -1, 22294, -1, 
  22295, -1, 22097, -1, 22132, -1, 22766, -1, 
  22478, -1, 22516, -1, 22541, -1, 22411, -1, 
  22578, -1, 22577, -1, 22700, -1, 136420, -1, 
  22770, -1, 22775, -1, 22790, -1, 22818, -1, 
  22882, -1, 136872, -1, 136938, -1, 23020, -1, 
  23067, -1, 23079, -1, 23000, -1, 23142, -1, 
  14062, -1, 14076, -1, 23304, -1, 23358, -1, 
  137672, -1, 23491, -1, 23512, -1, 23539, -1, 
  138008, -1, 23551, -1, 23558, -1, 24403, -1, 
  14209, -1, 23648, -1, 23744, -1, 23693, -1, 
  138724, -1, 23875, -1, 138726, -1, 23918, -1, 
  23915, -1, 23932, -1, 24033, -1, 24034, -1, 
  14383, -1, 24061, -1, 24104, -1, 24125, -1, 
  24169, -1, 14434, -1, 139651, -1, 14460, -1, 
  24240, -1, 24243, -1, 24246, -1, 172946, -1, 
  140081, -1, 33281, -1, 24354, -1, 14535, -1, 
  144056, -1, 156122, -1, 24418, -1, 24427, -1, 
  14563, -1, 24474, -1, 24525, -1, 24535, -1, 
  24569, -1, 24705, -1, 14650, -1, 14620, -1, 
  141012, -1, 24775, -1, 24904, -1, 24908, -1, 
  24954, -1, 25010, -1, 24996, -1, 25007, -1, 
  25054, -1, 25104, -1, 25115, -1, 25181, -1, 
  25265, -1, 25300, -1, 25424, -1, 142092, -1, 
  25405, -1, 25340, -1, 25448, -1, 25475, -1, 
  25572, -1, 142321, -1, 25634, -1, 25541, -1, 
  25513, -1, 14894, -1, 25705, -1, 25726, -1, 
  25757, -1, 25719, -1, 14956, -1, 25964, -1, 
  143370, -1, 26083, -1, 26360, -1, 26185, -1, 
  15129, -1, 15112, -1, 15076, -1, 20882, -1, 
  20885, -1, 26368, -1, 26268, -1, 32941, -1, 
  17369, -1, 26401, -1, 26462, -1, 26451, -1, 
  144323, -1, 15177, -1, 26618, -1, 26501, -1, 
  26706, -1, 144493, -1, 26766, -1, 26655, -1, 
  26900, -1, 26946, -1, 27043, -1, 27114, -1, 
  27304, -1, 145059, -1, 27355, -1, 15384, -1, 
  27425, -1, 145575, -1, 27476, -1, 15438, -1, 
  27506, -1, 27551, -1, 27579, -1, 146061, -1, 
  138507, -1, 146170, -1, 27726, -1, 146620, -1, 
  27839, -1, 27853, -1, 27751, -1, 27926, -1, 
  27966, -1, 28009, -1, 28024, -1, 28037, -1, 
  146718, -1, 27956, -1, 28207, -1, 28270, -1, 
  15667, -1, 28359, -1, 147153, -1, 28153, -1, 
  28526, -1, 147294, -1, 147342, -1, 28614, -1, 
  28729, -1, 28699, -1, 15766, -1, 28746, -1, 
  28797, -1, 28791, -1, 28845, -1, 132389, -1, 
  28997, -1, 148067, -1, 29084, -1, 148395, -1, 
  29224, -1, 29264, -1, 149000, -1, 29312, -1, 
  29333, -1, 149301, -1, 149524, -1, 29562, -1, 
  29579, -1, 16044, -1, 29605, -1, 16056, -1, 
  29767, -1, 29788, -1, 29829, -1, 29898, -1, 
  16155, -1, 29988, -1, 150582, -1, 30014, -1, 
  150674, -1, 139679, -1, 30224, -1, 151457, -1, 
  151480, -1, 151620, -1, 16380, -1, 16392, -1, 
  151795, -1, 151794, -1, 151833, -1, 151859, -1, 
  30494, -1, 30495, -1, 30603, -1, 16454, -1, 
  16534, -1, 152605, -1, 30798, -1, 16611, -1, 
  153126, -1, 153242, -1, 153285, -1, 31211, -1, 
  16687, -1, 31306, -1, 31311, -1, 153980, -1, 
  154279, -1, 31470, -1, 16898, -1, 154539, -1, 
  31686, -1, 31689, -1, 16935, -1, 154752, -1, 
  31954, -1, 17056, -1, 31976, -1, 31971, -1, 
  32000, -1, 155526, -1, 32099, -1, 17153, -1, 
  32199, -1, 32258, -1, 32325, -1, 17204, -1, 
  156200, -1, 156231, -1, 17241, -1, 156377, -1, 
  32634, -1, 156478, -1, 32661, -1, 32762, -1, 
  156890, -1, 156963, -1, 32864, -1, 157096, -1, 
  32880, -1, 144223, -1, 17365, -1, 32946, -1, 
  33027, -1, 17419, -1, 33086, -1, 23221, -1, 
  157607, -1, 157621, -1, 144275, -1, 144284, -1, 
  33284, -1, 36766, -1, 17515, -1, 33425, -1, 
  33419, -1, 33437, -1, 21171, -1, 33457, -1, 
  33459, -1, 33469, -1, 33510, -1, 158524, -1, 
  33565, -1, 33635, -1, 33709, -1, 33571, -1, 
  33725, -1, 33767, -1, 33619, -1, 33738, -1, 
  33740, -1, 33756, -1, 158774, -1, 159083, -1, 
  158933, -1, 17707, -1, 34033, -1, 34035, -1, 
  34070, -1, 160714, -1, 34148, -1, 159532, -1, 
  17757, -1, 17761, -1, 159665, -1, 159954, -1, 
  17771, -1, 34384, -1, 34407, -1, 34409, -1, 
  34473, -1, 34440, -1, 34574, -1, 34530, -1, 
  34600, -1, 34667, -1, 34694, -1, 17879, -1, 
  34785, -1, 34817, -1, 17913, -1, 34912, -1, 
  161383, -1, 35031, -1, 35038, -1, 17973, -1, 
  35066, -1, 13499, -1, 161966, -1, 162150, -1, 
  18110, -1, 18119, -1, 35488, -1, 162984, -1, 
  36011, -1, 36033, -1, 36123, -1, 36215, -1, 
  163631, -1, 133124, -1, 36299, -1, 36284, -1, 
  36336, -1, 133342, -1, 36564, -1, 165330, -1, 
  165357, -1, 37012, -1, 37105, -1, 37137, -1, 
  165678, -1, 37147, -1, 37432, -1, 37591, -1, 
  37592, -1, 37500, -1, 37881, -1, 37909, -1, 
  166906, -1, 38283, -1, 18837, -1, 38327, -1, 
  167287, -1, 18918, -1, 38595, -1, 23986, -1, 
  38691, -1, 168261, -1, 168474, -1, 19054, -1, 
  19062, -1, 38880, -1, 168970, -1, 19122, -1, 
  169110, -1, 38953, -1, 169398, -1, 39138, -1, 
  19251, -1, 39209, -1, 39335, -1, 39362, -1, 
  39422, -1, 19406, -1, 170800, -1, 40000, -1, 
  40189, -1, 19662, -1, 19693, -1, 40295, -1, 
  172238, -1, 19704, -1, 172293, -1, 172558, -1, 
  172689, -1, 19798, -1, 40702, -1, 40709, -1, 
  40719, -1, 40726, -1, 173568, -1, };

const utf8proc_uint16_t utf8proc_stage1table[] = {
  0, 256, 512, 768, 1024, 1280, 1536, 
  1792, 2048, 2304, 2560, 2816, 3072, 3328, 3584, 
  3840, 4096, 4352, 4608, 4864, 5120, 5376, 5632, 
  5888, 6144, 6400, 6656, 6912, 7168, 7424, 7680, 
  7936, 8192, 8448, 8704, 8960, 9216, 9472, 9728, 
  9984, 10240, 10496, 10752, 11008, 11264, 11520, 11776, 
  12032, 12288, 12544, 12800, 13056, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13568, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13824, 14080, 13312, 13312, 13312, 14336, 13312, 14592, 
  14848, 15104, 15360, 15616, 15872, 16128, 16384, 16640, 
  16896, 17152, 17408, 17664, 16128, 16384, 16640, 16896, 
  17152, 17408, 17664, 16128, 16384, 16640, 16896, 17152, 
  17408, 17664, 16128, 16384, 16640, 16896, 17152, 17408, 
  17664, 16128, 16384, 16640, 16896, 17152, 17408, 17664, 
  16128, 16384, 16640, 16896, 17152, 17408, 17664, 16128, 
  17920, 18176, 18176, 18176, 18176, 18176, 18176, 18176, 
  18176, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18688, 18944, 19200, 19456, 19712, 19968, 
  20224, 20480, 20736, 20992, 21248, 21504, 21760, 22016, 
  22272, 22528, 22784, 23040, 23296, 23552, 23808, 24064, 
  23808, 24320, 24576, 24832, 25088, 25344, 25600, 25856, 
  26112, 26368, 23808, 26624, 23808, 23808, 23808, 23808, 
  23808, 26880, 26880, 26880, 27136, 27392, 27648, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 26880, 26880, 26880, 26880, 27904, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 26880, 26880, 28160, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 26880, 26880, 28416, 28672, 23808, 23808, 23808, 
  28928, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 29184, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 29440, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 29696, 29952, 30208, 30464, 30720, 30976, 31232, 
  31488, 10240, 10240, 31744, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 32000, 23808, 23808, 23808, 23808, 23808, 32256, 
  23808, 32512, 32768, 33024, 33280, 33536, 33792, 34048, 
  34304, 34560, 34816, 23808, 23808, 23808, 23808, 23808, 
  23808, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 35072, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  35328, 35584, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 35840, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 36096, 36352, 36608, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 36864, 37120, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 23808, 23808, 23808, 23808, 23808, 23808, 23808, 
  23808, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  37376, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 
  37376, };

const utf8proc_uint16_t utf8proc_stage2table[] = {
  1, 2, 2, 2, 2, 2, 2, 
  2, 2, 3, 4, 3, 5, 6, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 7, 7, 7, 
  3, 8, 9, 9, 10, 11, 10, 9, 
  9, 12, 13, 9, 14, 15, 16, 15, 
  15, 17, 17, 17, 17, 17, 17, 17, 
  17, 17, 17, 15, 9, 18, 19, 20, 
  9, 9, 21, 22, 23, 24, 25, 26, 
  27, 28, 29, 30, 31, 32, 33, 34, 
  35, 36, 37, 38, 39, 40, 41, 42, 
  43, 44, 45, 46, 12, 9, 13, 47, 
  48, 47, 49, 50, 51, 52, 53, 54, 
  55, 56, 57, 58, 59, 60, 61, 62, 
  63, 64, 65, 66, 67, 68, 69, 70, 
  71, 72, 73, 74, 12, 75, 13, 75, 
  2, 2, 2, 2, 2, 2, 7, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 
  2, 76, 9, 11, 11, 11, 11, 77, 
  9, 78, 77, 79, 80, 75, 81, 77, 
  82, 83, 84, 85, 86, 87, 88, 9, 
  9, 89, 90, 91, 92, 93, 94, 95, 
  9, 96, 97, 98, 99, 100, 101, 102, 
  103, 104, 105, 106, 107, 108, 109, 110, 
  111, 112, 113, 114, 115, 116, 117, 118, 
  75, 119, 120, 121, 122, 123, 124, 125, 
  126, 127, 128, 129, 130, 131, 132, 133, 
  134, 135, 136, 137, 138, 139, 140, 141, 
  142, 143, 144, 145, 146, 147, 148, 149, 
  75, 150, 151, 152, 153, 154, 155, 156, 
  157, 158, 159, 160, 161, 162, 163, 164, 
  165, 166, 167, 168, 169, 170, 171, 172, 
  173, 174, 175, 176, 177, 178, 179, 180, 
  181, 182, 183, 184, 185, 186, 187, 188, 
  189, 190, 191, 192, 193, 194, 195, 196, 
  197, 198, 199, 200, 201, 202, 203, 204, 
  205, 206, 207, 208, 209, 210, 211, 212, 
  213, 214, 215, 216, 217, 218, 219, 220, 
  221, 222, 223, 224, 225, 226, 227, 228, 
  229, 230, 231, 232, 233, 234, 235, 236, 
  237, 238, 239, 240, 241, 242, 243, 244, 
  245, 246, 247, 248, 249, 250, 251, 252, 
  253, 254, 255, 256, 257, 258, 259, 260, 
  261, 262, 263, 264, 265, 266, 267, 268, 
  269, 270, 271, 272, 273, 274, 275, 276, 
  277, 278, 279, 280, 281, 282, 283, 284, 
  285, 286, 287, 288, 289, 290, 291, 292, 
  293, 294, 295, 296, 297, 298, 214, 299, 
  300, 301, 302, 303, 304, 305, 306, 307, 
  308, 309, 310, 311, 214, 312, 313, 314, 
  315, 316, 317, 318, 319, 320, 321, 322, 
  323, 324, 325, 214, 214, 326, 327, 328, 
  329, 330, 331, 332, 333, 334, 335, 336, 
  337, 338, 339, 214, 340, 341, 342, 214, 
  343, 340, 340, 340, 340, 344, 345, 346, 
  347, 348, 349, 350, 351, 352, 353, 354, 
  355, 356, 357, 358, 359, 360, 361, 362, 
  363, 364, 365, 366, 367, 368, 369, 370, 
  371, 372, 373, 374, 375, 376, 377, 378, 
  379, 380, 381, 382, 383, 384, 385, 386, 
  387, 388, 389, 390, 391, 392, 393, 394, 
  395, 396, 397, 398, 399, 400, 401, 402, 
  403, 404, 405, 406, 407, 408, 409, 410, 
  411, 412, 413, 414, 415, 416, 417, 418, 
  419, 420, 421, 422, 423, 424, 425, 426, 
  427, 428, 429, 430, 431, 432, 433, 434, 
  435, 436, 214, 437, 438, 439, 440, 441, 
  442, 443, 444, 445, 446, 447, 448, 449, 
  450, 451, 452, 453, 454, 214, 214, 214, 
  214, 214, 214, 455, 456, 457, 458, 459, 
  460, 461, 462, 463, 464, 465, 466, 467, 
  468, 469, 470, 471, 472, 473, 474, 475, 
  476, 477, 478, 479, 480, 481, 214, 482, 
  483, 214, 484, 214, 485, 486, 214, 214, 
  214, 487, 488, 214, 489, 214, 490, 491, 
  214, 492, 493, 214, 494, 495, 214, 214, 
  496, 214, 497, 498, 214, 214, 499, 214, 
  214, 214, 214, 214, 214, 214, 500, 214, 
  214, 501, 214, 214, 502, 214, 214, 214, 
  503, 504, 505, 506, 507, 508, 214, 214, 
  214, 214, 214, 509, 214, 340, 214, 214, 
  214, 214, 214, 214, 214, 214, 510, 511, 
  214, 214, 214, 214, 214, 214, 214, 214, 
  214, 214, 214, 214, 214, 214, 214, 214, 
  214, 512, 513, 514, 515, 516, 517, 518, 
  519, 520, 521, 521, 522, 522, 522, 522, 
  522, 522, 522, 47, 47, 47, 47, 521, 
  521, 521, 521, 521, 521, 521, 521, 521, 
  521, 522, 522, 47, 47, 47, 47, 47, 
  47, 523, 524, 525, 526, 527, 528, 47, 
  47, 529, 530, 531, 532, 533, 47, 47, 
  47, 47, 47, 47, 47, 521, 47, 522, 
  47, 47, 47, 47, 47, 47, 47, 47, 
  47, 47, 47, 47, 47, 47, 47, 47, 
  47, 534, 535, 536, 537, 538, 539, 540, 
  541, 542, 543, 544, 545, 546, 539, 539, 
  547, 539, 548, 539, 549, 550, 551, 552, 
  552, 552, 552, 551, 553, 552, 552, 552, 
  552, 552, 554, 554, 555, 556, 557, 558, 
  559, 560, 552, 552, 552, 552, 561, 562, 
  552, 563, 564, 552, 552, 565, 565, 565, 
  565, 566, 552, 552, 552, 552, 539, 539, 
  539, 567, 568, 569, 570, 571, 572, 539, 
  552, 552, 552, 539, 539, 539, 552, 552, 
  573, 539, 539, 539, 552, 552, 552, 552, 
  539, 551, 552, 552, 539, 574, 575, 575, 
  574, 575, 575, 574, 539, 539, 539, 539, 
  539, 539, 539, 539, 539, 539, 539, 539, 
  539, 576, 577, 578, 579, 580, 47, 581, 
  582, 0, 0, 583, 584, 585, 586, 587, 
  588, 0, 0, 0, 0, 87, 589, 590, 
  591, 592, 593, 594, 0, 595, 0, 596, 
  597, 598, 599, 600, 601, 602, 603, 604, 
  605, 606, 607, 608, 609, 610, 611, 612, 
  613, 614, 615, 0, 616, 617, 618, 619, 
  620, 621, 622, 623, 624, 625, 626, 627, 
  628, 629, 630, 631, 632, 633, 634, 635, 
  636, 637, 638, 639, 640, 641, 642, 643, 
  644, 645, 646, 647, 648, 649, 650, 651, 
  652, 653, 654, 655, 656, 657, 658, 659, 
  660, 661, 662, 663, 664, 665, 666, 667, 
  668, 669, 670, 671, 672, 673, 674, 675, 
  676, 677, 678, 679, 680, 681, 682, 683, 
  684, 685, 686, 687, 688, 689, 690, 691, 
  692, 693, 694, 695, 696, 697, 698, 75, 
  699, 700, 701, 702, 703, 214, 704, 705, 
  706, 707, 708, 709, 710, 711, 712, 713, 
  714, 715, 716, 717, 718, 719, 720, 721, 
  722, 723, 724, 725, 726, 727, 728, 729, 
  730, 731, 732, 733, 734, 735, 736, 737, 
  738, 739, 740, 741, 742, 743, 744, 745, 
  746, 747, 748, 749, 750, 751, 752, 753, 
  754, 755, 756, 757, 758, 759, 760, 761, 
  762, 763, 764, 765, 766, 767, 768, 769, 
  770, 771, 772, 773, 774, 775, 776, 777, 
  778, 779, 780, 781, 782, 783, 784, 785, 
  786, 787, 788, 789, 790, 791, 792, 793, 
  794, 795, 796, 797, 798, 799, 800, 801, 
  802, 803, 804, 805, 806, 807, 808, 809, 
  810, 811, 812, 813, 814, 815, 816, 817, 
  818, 819, 820, 821, 822, 823, 824, 825, 
  826, 827, 828, 829, 830, 831, 832, 833, 
  834, 835, 836, 837, 539, 539, 539, 539, 
  539, 838, 838, 839, 840, 841, 842, 843, 
  844, 845, 846, 847, 848, 849, 850, 851, 
  852, 853, 854, 855, 856, 857, 858, 859, 
  860, 861, 862, 863, 864, 865, 866, 867, 
  868, 869, 870, 871, 872, 873, 874, 875, 
  876, 877, 878, 879, 880, 881, 882, 883, 
  884, 885, 886, 887, 888, 889, 890, 891, 
  892, 893, 894, 895, 896, 897, 898, 899, 
  900, 901, 902, 903, 904, 905, 906, 907, 
  908, 909, 910, 911, 912, 913, 914, 915, 
  916, 917, 918, 919, 920, 921, 922, 923, 
  924, 925, 926, 927, 928, 929, 930, 931, 
  932, 933, 934, 935, 936, 937, 938, 939, 
  940, 941, 942, 943, 944, 945, 946, 947, 
  948, 949, 950, 951, 952, 953, 954, 955, 
  956, 957, 958, 959, 960, 961, 962, 963, 
  964, 965, 966, 967, 968, 969, 970, 971, 
  972, 973, 974, 975, 976, 977, 978, 979, 
  980, 981, 982, 983, 984, 985, 986, 987, 
  988, 989, 990, 991, 992, 993, 994, 995, 
  996, 997, 998, 999, 1000, 1001, 1002, 1003, 
  1004, 0, 1005, 1006, 1007, 1008, 1009, 1010, 
  1011, 1012, 1013, 1014, 1015, 1016, 1017, 1018, 
  1019, 1020, 1021, 1022, 1023, 1024, 1025, 1026, 
  1027, 1028, 1029, 1030, 1031, 1032, 1033, 1034, 
  1035, 1036, 1037, 1038, 1039, 1040, 1041, 1042, 
  0, 0, 522, 1043, 1043, 1043, 1043, 1043, 
  1043, 0, 1044, 1045, 1046, 1047, 1048, 1049, 
  1050, 1051, 1052, 1053, 1054, 1055, 1056, 1057, 
  1058, 1059, 1060, 1061, 1062, 1063, 1064, 1065, 
  1066, 1067, 1068, 1069, 1070, 1071, 1072, 1073, 
  1074, 1075, 1076, 1077, 1078, 1079, 1080, 1081, 
  1082, 0, 1043, 1083, 0, 0, 1084, 1084, 
  11, 0, 552, 539, 539, 539, 539, 552, 
  539, 539, 539, 1085, 552, 539, 539, 539, 
  539, 539, 539, 552, 552, 552, 552, 552, 
  552, 539, 539, 552, 539, 539, 1085, 1086, 
  539, 1087, 1088, 1089, 1090, 1091, 1092, 1093, 
  1094, 1095, 1096, 1096, 1097, 1098, 1099, 1100, 
  1101, 1102, 1103, 1104, 1102, 539, 552, 1102, 
  1095, 0, 0, 0, 0, 0, 0, 0, 
  0, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 1105, 1105, 0, 0, 0, 0, 
  0, 1105, 1105, 1105, 1102, 1102, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1106, 1107, 1107, 1107, 1106, 1106, 1108, 
  1108, 1109, 10, 10, 1110, 15, 1111, 1084, 
  1084, 539, 539, 539, 539, 539, 539, 539, 
  539, 1112, 1113, 1114, 1111, 1115, 0, 1116, 
  1111, 1117, 1117, 1118, 1119, 1120, 1121, 1122, 
  1123, 1117, 1117, 1117, 1117, 1117, 1117, 1117, 
  1117, 1117, 1117, 1117, 1117, 1117, 1117, 1117, 
  1117, 1117, 1117, 1117, 1117, 1117, 1117, 1117, 
  1117, 1124, 1117, 1117, 1117, 1117, 1117, 1117, 
  1125, 1126, 1117, 1127, 1128, 1129, 1130, 1112, 
  1113, 1114, 1131, 1132, 1133, 1134, 1135, 552, 
  539, 539, 539, 539, 539, 552, 539, 539, 
  552, 1136, 1136, 1136, 1136, 1136, 1136, 1136, 
  1136, 1136, 1136, 10, 1137, 1137, 1111, 1117, 
  1117, 1138, 1117, 1117, 1117, 1117, 1139, 1140, 
  1141, 1142, 1117, 1117, 1117, 1117, 1117, 1117, 
  1117, 1117, 1117, 1117, 1117, 1117, 1117, 1117, 
  1117, 1117, 1117, 1117, 1117, 1117, 1117, 1117, 
  1117, 1117, 1117, 1117, 1117, 1117, 1117, 1117, 
  1117, 1117, 1117, 1117, 1117, 1117, 1117, 1117, 
  1117, 1117, 1117, 1117, 1117, 1117, 1117, 1117, 
  1117, 1117, 1117, 1125, 1117, 1117, 1117, 1117, 
  1117, 1117, 1117, 1117, 1117, 1117, 1117, 1117, 
  1117, 1117, 1117, 1117, 1117, 1117, 1117, 1117, 
  1117, 1143, 1144, 1145, 1117, 1117, 1117, 1117, 
  1117, 1117, 1117, 1117, 1117, 1117, 1117, 1117, 
  1117, 1117, 1117, 1146, 1147, 1111, 1148, 539, 
  539, 539, 539, 539, 539, 539, 1107, 1084, 
  539, 539, 539, 539, 552, 539, 1124, 1124, 
  539, 539, 1084, 552, 539, 539, 552, 1117, 
  1117, 17, 17, 17, 17, 17, 17, 17, 
  17, 17, 17, 1117, 1117, 1117, 1149, 1149, 
  1125, 1116, 1116, 1116, 1116, 1116, 1116, 1116, 
  1116, 1116, 1116, 1116, 1116, 1116, 1116, 0, 
  1150, 1125, 1151, 1125, 1125, 1125, 1125, 1125, 
  1125, 1125, 1125, 1125, 1125, 1125, 1125, 1125, 
  1125, 1125, 1125, 1125, 1125, 1125, 1125, 1125, 
  1125, 1125, 1125, 1125, 1125, 1125, 1125, 1125, 
  1125, 539, 552, 539, 539, 552, 539, 539, 
  552, 552, 552, 539, 552, 552, 539, 552, 
  539, 539, 539, 552, 539, 552, 539, 552, 
  539, 552, 539, 539, 0, 0, 1125, 1125, 
  1125, 1117, 1117, 1117, 1117, 1117, 1117, 1117, 
  1117, 1117, 1117, 1117, 1117, 1117, 1117, 1117, 
  1117, 1117, 1117, 1117, 1117, 1117, 1117, 1117, 
  1117, 1117, 1117, 1117, 1117, 1117, 1117, 1117, 
  1117, 1117, 1117, 1117, 1117, 1117, 1117, 1117, 
  1117, 1117, 1117, 1117, 1117, 1117, 1117, 1117, 
  1117, 1117, 1117, 1117, 1117, 1117, 1117, 1117, 
  1117, 1117, 1117, 1117, 1117, 1117, 1117, 1117, 
  1117, 1125, 1117, 1117, 1117, 1117, 1117, 1117, 
  1117, 1117, 1117, 1117, 1117, 1117, 1125, 1125, 
  1125, 1117, 1117, 1117, 1117, 1117, 1117, 1152, 
  1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 
  1152, 1152, 1117, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1153, 1153, 1153, 1153, 1153, 1153, 1153, 
  1153, 1153, 1153, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 1105, 1105, 539, 539, 539, 539, 
  539, 539, 539, 552, 539, 1154, 1154, 77, 
  9, 9, 9, 1154, 0, 0, 0, 0, 
  0, 1155, 1155, 1155, 1155, 1155, 1155, 1155, 
  1155, 1155, 1155, 1155, 1155, 1155, 1155, 1155, 
  1155, 1155, 1155, 1155, 1155, 1155, 1155, 539, 
  539, 539, 539, 1156, 539, 539, 539, 539, 
  539, 539, 539, 539, 539, 1156, 539, 539, 
  539, 1156, 539, 539, 539, 539, 539, 0, 
  0, 1157, 1157, 1157, 1157, 1157, 1157, 1157, 
  1157, 1157, 1157, 1157, 1157, 1157, 1157, 1157, 
  0, 1155, 1155, 1155, 1155, 1155, 1155, 1155, 
  1155, 1155, 1155, 1155, 1155, 1155, 1155, 1155, 
  1155, 1155, 1155, 1155, 1155, 1155, 1155, 1155, 
  1155, 1155, 552, 552, 552, 0, 0, 1157, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1117, 1117, 1117, 1117, 1117, 1117, 1117, 
  1117, 1117, 1117, 1117, 1117, 1117, 1117, 1117, 
  1117, 1117, 1117, 1117, 1117, 1117, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 552, 539, 539, 552, 
  539, 539, 552, 539, 539, 539, 552, 552, 
  552, 1128, 1129, 1130, 539, 539, 539, 552, 
  539, 539, 552, 552, 539, 539, 539, 539, 
  539, 1152, 1152, 1152, 1158, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1160, 1161, 1159, 1159, 1159, 1159, 1159, 
  1159, 1162, 1163, 1159, 1164, 1165, 1159, 1159, 
  1159, 1159, 1159, 1152, 1158, 1166, 1159, 1158, 
  1158, 1158, 1152, 1152, 1152, 1152, 1152, 1152, 
  1152, 1152, 1158, 1158, 1158, 1158, 1167, 1158, 
  1158, 1159, 539, 552, 539, 539, 1152, 1152, 
  1152, 1168, 1169, 1170, 1171, 1172, 1173, 1174, 
  1175, 1159, 1159, 1152, 1152, 1176, 1176, 1177, 
  1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 
  1177, 1176, 1178, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1152, 1158, 1158, 0, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 0, 0, 
  1159, 1159, 0, 0, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 0, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 0, 1159, 0, 0, 0, 1159, 
  1159, 1159, 1159, 0, 0, 1179, 1159, 1180, 
  1158, 1158, 1152, 1152, 1152, 1152, 0, 0, 
  1181, 1158, 0, 0, 1182, 1183, 1167, 1159, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  1184, 0, 0, 0, 0, 1185, 1186, 0, 
  1187, 1159, 1159, 1152, 1152, 0, 0, 1177, 
  1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 
  1177, 1159, 1159, 1188, 1188, 1189, 1189, 1189, 
  1189, 1189, 1189, 1190, 1188, 0, 0, 0, 
  0, 0, 1152, 1152, 1158, 0, 1159, 1159, 
  1159, 1159, 1159, 1159, 0, 0, 0, 0, 
  1159, 1159, 0, 0, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 0, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 0, 1159, 1191, 0, 1159, 1192, 
  0, 1159, 1159, 0, 0, 1179, 0, 1158, 
  1158, 1158, 1152, 1152, 0, 0, 0, 0, 
  1152, 1152, 0, 0, 1152, 1152, 1167, 0, 
  0, 0, 1152, 0, 0, 0, 0, 0, 
  0, 0, 1193, 1194, 1195, 1159, 0, 1196, 
  0, 0, 0, 0, 0, 0, 0, 1177, 
  1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 
  1177, 1152, 1152, 1159, 1159, 1159, 1152, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 1152, 1152, 1158, 0, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 0, 
  1159, 1159, 1159, 0, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 0, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 0, 1159, 1159, 0, 1159, 1159, 
  1159, 1159, 1159, 0, 0, 1179, 1159, 1158, 
  1158, 1158, 1152, 1152, 1152, 1152, 1152, 0, 
  1152, 1152, 1158, 0, 1158, 1158, 1167, 0, 
  0, 1159, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1159, 1159, 1152, 1152, 0, 0, 1177, 
  1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 
  1177, 1176, 1188, 0, 0, 0, 0, 0, 
  0, 0, 1159, 0, 0, 0, 0, 0, 
  0, 0, 1152, 1158, 1158, 0, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 0, 0, 
  1159, 1159, 0, 0, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 0, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 0, 1159, 1159, 0, 1159, 1159, 
  1159, 1159, 1159, 0, 0, 1179, 1159, 1197, 
  1152, 1158, 1152, 1152, 1152, 1152, 0, 0, 
  1198, 1199, 0, 0, 1200, 1201, 1167, 0, 
  0, 0, 0, 0, 0, 0, 0, 1202, 
  1203, 0, 0, 0, 0, 1204, 1205, 0, 
  1159, 1159, 1159, 1152, 1152, 0, 0, 1177, 
  1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 
  1177, 1190, 1159, 1189, 1189, 1189, 1189, 1189, 
  1189, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 1152, 1159, 0, 1159, 1159, 
  1159, 1159, 1159, 1159, 0, 0, 0, 1159, 
  1159, 1159, 0, 1206, 1159, 1207, 1159, 0, 
  0, 0, 1159, 1159, 0, 1159, 0, 1159, 
  1159, 0, 0, 0, 1159, 1159, 0, 0, 
  0, 1159, 1159, 1159, 0, 0, 0, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 0, 0, 0, 0, 1208, 
  1158, 1152, 1158, 1158, 0, 0, 0, 1209, 
  1210, 1158, 0, 1211, 1212, 1213, 1167, 0, 
  0, 1159, 0, 0, 0, 0, 0, 0, 
  1214, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 1177, 
  1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 
  1177, 1189, 1189, 1189, 1084, 1084, 1084, 1084, 
  1084, 1084, 1188, 1084, 0, 0, 0, 0, 
  0, 1152, 1158, 1158, 1158, 0, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 0, 1159, 
  1159, 1159, 0, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 0, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 0, 0, 0, 1159, 1152, 
  1152, 1152, 1158, 1158, 1158, 1158, 0, 1215, 
  1152, 1216, 0, 1152, 1152, 1152, 1167, 0, 
  0, 0, 0, 0, 0, 0, 1217, 1218, 
  0, 1159, 1159, 1159, 0, 0, 0, 0, 
  0, 1159, 1159, 1152, 1152, 0, 0, 1177, 
  1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 
  1177, 0, 0, 0, 0, 0, 0, 0, 
  0, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 
  1190, 0, 1152, 1158, 1158, 0, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 0, 1159, 
  1159, 1159, 0, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 0, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 0, 1159, 1159, 
  1159, 1159, 1159, 0, 0, 1179, 1159, 1158, 
  1220, 1221, 1158, 1222, 1158, 1158, 0, 1223, 
  1224, 1225, 0, 1226, 1227, 1152, 1167, 0, 
  0, 0, 0, 0, 0, 0, 1228, 1229, 
  0, 0, 0, 0, 0, 0, 0, 1159, 
  0, 1159, 1159, 1152, 1152, 0, 0, 1177, 
  1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 
  1177, 0, 1159, 1159, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 1152, 1158, 1158, 0, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 0, 1159, 
  1159, 1159, 0, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 0, 0, 1159, 1230, 
  1158, 1158, 1152, 1152, 1152, 1152, 0, 1231, 
  1232, 1158, 0, 1233, 1234, 1235, 1167, 1159, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  1236, 0, 0, 0, 0, 0, 0, 0, 
  1159, 1159, 1159, 1152, 1152, 0, 0, 1177, 
  1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 
  1177, 1189, 1189, 1189, 1189, 1189, 1189, 0, 
  0, 0, 1190, 1159, 1159, 1159, 1159, 1159, 
  1159, 0, 0, 1158, 1158, 0, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  0, 0, 0, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 0, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 0, 1159, 0, 
  0, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  0, 0, 0, 1237, 0, 0, 0, 0, 
  1238, 1158, 1158, 1152, 1152, 1152, 0, 1152, 
  0, 1158, 1239, 1240, 1158, 1241, 1242, 1243, 
  1244, 0, 0, 0, 0, 0, 0, 1177, 
  1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 
  1177, 0, 0, 1158, 1158, 1176, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 1152, 340, 1245, 1152, 1152, 1152, 
  1152, 1246, 1246, 1167, 0, 0, 0, 0, 
  11, 340, 340, 340, 340, 340, 340, 522, 
  1152, 1247, 1247, 1247, 1247, 1152, 1152, 1152, 
  1043, 1248, 1248, 1248, 1248, 1248, 1248, 1248, 
  1248, 1248, 1248, 1043, 1043, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 340, 340, 0, 340, 0, 0, 
  340, 340, 0, 340, 0, 0, 340, 0, 
  0, 0, 0, 0, 0, 340, 340, 340, 
  340, 0, 340, 340, 340, 340, 340, 340, 
  340, 0, 340, 340, 340, 0, 340, 0, 
  340, 0, 0, 340, 340, 0, 340, 340, 
  340, 340, 1152, 340, 1249, 1152, 1152, 1152, 
  1152, 1250, 1250, 0, 1152, 1152, 340, 0, 
  0, 340, 340, 340, 340, 340, 0, 522, 
  0, 1251, 1251, 1251, 1251, 1152, 1152, 0, 
  0, 1248, 1248, 1248, 1248, 1248, 1248, 1248, 
  1248, 1248, 1248, 0, 0, 1252, 1253, 340, 
  340, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1159, 1190, 1190, 1190, 1176, 1176, 1176, 
  1176, 1176, 1176, 1176, 1176, 1254, 1176, 1176, 
  1176, 1176, 1176, 1176, 1190, 1176, 1190, 1190, 
  1190, 552, 552, 1190, 1190, 1190, 1190, 1190, 
  1190, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 
  1177, 1177, 1177, 1189, 1189, 1189, 1189, 1189, 
  1189, 1189, 1189, 1189, 1189, 1190, 552, 1190, 
  552, 1190, 1255, 1256, 1257, 1256, 1257, 1158, 
  1158, 1159, 1159, 1159, 1258, 1159, 1159, 1159, 
  1159, 0, 1159, 1159, 1159, 1159, 1259, 1159, 
  1159, 1159, 1159, 1260, 1159, 1159, 1159, 1159, 
  1261, 1159, 1159, 1159, 1159, 1262, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1263, 1159, 1159, 1159, 0, 0, 
  0, 0, 1264, 1265, 1266, 1267, 1268, 1269, 
  1270, 1271, 1272, 1265, 1265, 1265, 1265, 1152, 
  1158, 1265, 1273, 539, 539, 1167, 1176, 539, 
  539, 1159, 1159, 1159, 1159, 1159, 1152, 1152, 
  1152, 1152, 1152, 1152, 1274, 1152, 1152, 1152, 
  1152, 0, 1152, 1152, 1152, 1152, 1275, 1152, 
  1152, 1152, 1152, 1276, 1152, 1152, 1152, 1152, 
  1277, 1152, 1152, 1152, 1152, 1278, 1152, 1152, 
  1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 
  1152, 1152, 1279, 1152, 1152, 1152, 0, 1190, 
  1190, 1190, 1190, 1190, 1190, 1190, 1190, 552, 
  1190, 1190, 1190, 1190, 1190, 1190, 0, 1190, 
  1190, 1176, 1176, 1176, 1176, 1176, 1190, 1190, 
  1190, 1190, 1176, 1176, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 340, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 340, 1159, 1159, 1159, 1159, 1280, 1281, 
  1159, 1159, 1159, 1159, 1282, 1282, 1152, 1283, 
  1152, 1152, 1158, 1152, 1152, 1152, 1152, 1152, 
  1179, 1282, 1167, 1167, 1158, 1158, 1152, 1152, 
  1159, 1177, 1177, 1248, 1248, 1177, 1177, 1177, 
  1177, 1177, 1177, 1043, 1043, 1043, 1176, 1176, 
  1176, 1159, 1159, 1159, 1159, 340, 1159, 1158, 
  1158, 1152, 1152, 1159, 1159, 1159, 1159, 1152, 
  1152, 1152, 1159, 1282, 1282, 1282, 1159, 1159, 
  1282, 1282, 1282, 1282, 1282, 1282, 1282, 1159, 
  1159, 1159, 1152, 1152, 1152, 1152, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1152, 1282, 1158, 1152, 1152, 
  1282, 1282, 1282, 1282, 1282, 1282, 552, 1159, 
  1282, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 
  1177, 1177, 1177, 1282, 1282, 1282, 1152, 1190, 
  1190, 1284, 1285, 1286, 1287, 1288, 1289, 1290, 
  1291, 1292, 1293, 1294, 1295, 1296, 1297, 1298, 
  1299, 1300, 1301, 1302, 1303, 1304, 1305, 1306, 
  1307, 1308, 1309, 1310, 1311, 1312, 1313, 1314, 
  1315, 1316, 1317, 1318, 1319, 1320, 1321, 0, 
  1322, 0, 0, 0, 0, 0, 1323, 0, 
  0, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 1043, 1324, 340, 340, 
  340, 1325, 1325, 1325, 1325, 1325, 1325, 1325, 
  1325, 1325, 1325, 1325, 1325, 1325, 1325, 1325, 
  1325, 1325, 1325, 1325, 1325, 1325, 1325, 1325, 
  1325, 1325, 1325, 1325, 1325, 1325, 1325, 1325, 
  1325, 1325, 1325, 1325, 1325, 1325, 1325, 1325, 
  1325, 1325, 1325, 1325, 1325, 1325, 1325, 1325, 
  1325, 1325, 1325, 1325, 1325, 1325, 1325, 1325, 
  1325, 1325, 1325, 1325, 1325, 1325, 1325, 1325, 
  1325, 1325, 1325, 1325, 1325, 1325, 1325, 1325, 
  1325, 1325, 1325, 1325, 1325, 1325, 1325, 1325, 
  1325, 1325, 1325, 1325, 1325, 1325, 1325, 1325, 
  1325, 1325, 1325, 1325, 1325, 1325, 1325, 1325, 
  1326, 1327, 1328, 1328, 1328, 1328, 1328, 1328, 
  1328, 1328, 1328, 1328, 1328, 1328, 1328, 1328, 
  1328, 1328, 1328, 1328, 1328, 1328, 1328, 1328, 
  1328, 1328, 1328, 1328, 1328, 1328, 1328, 1328, 
  1328, 1328, 1328, 1328, 1328, 1328, 1328, 1328, 
  1328, 1328, 1328, 1328, 1328, 1328, 1328, 1328, 
  1328, 1328, 1328, 1328, 1328, 1328, 1328, 1328, 
  1328, 1328, 1328, 1328, 1328, 1328, 1328, 1328, 
  1328, 1328, 1328, 1328, 1328, 1328, 1328, 1328, 
  1328, 1329, 1329, 1329, 1329, 1329, 1329, 1329, 
  1329, 1329, 1329, 1329, 1329, 1329, 1329, 1329, 
  1329, 1329, 1329, 1329, 1329, 1329, 1329, 1329, 
  1329, 1329, 1329, 1329, 1329, 1329, 1329, 1329, 
  1329, 1329, 1329, 1329, 1329, 1329, 1329, 1329, 
  1329, 1329, 1329, 1329, 1329, 1329, 1329, 1329, 
  1329, 1329, 1329, 1329, 1329, 1329, 1329, 1329, 
  1329, 1329, 1329, 1329, 1329, 1329, 1329, 1329, 
  1329, 1329, 1329, 1329, 1329, 1329, 1329, 1329, 
  1329, 1329, 1329, 1329, 1329, 1329, 1329, 1329, 
  1329, 1329, 1329, 1329, 1329, 1329, 1329, 1329, 
  1329, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 0, 1159, 1159, 1159, 1159, 0, 
  0, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  0, 1159, 0, 1159, 1159, 1159, 1159, 0, 
  0, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 0, 1159, 1159, 1159, 1159, 0, 
  0, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 0, 1159, 1159, 1159, 1159, 0, 
  0, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  0, 1159, 0, 1159, 1159, 1159, 1159, 0, 
  0, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  0, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 0, 1159, 1159, 1159, 1159, 0, 
  0, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 340, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 0, 0, 539, 539, 
  539, 1176, 1043, 1176, 1176, 1176, 1176, 1176, 
  1176, 1176, 1189, 1189, 1189, 1189, 1189, 1189, 
  1189, 1189, 1189, 1189, 1189, 1189, 1189, 1189, 
  1189, 1189, 1189, 1189, 1189, 1189, 0, 0, 
  0, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 77, 77, 77, 77, 77, 1084, 77, 
  1084, 1084, 77, 0, 0, 0, 0, 0, 
  0, 1330, 1331, 1332, 1333, 1334, 1335, 1336, 
  1337, 1338, 1339, 1340, 1341, 1342, 1343, 1344, 
  1345, 1346, 1347, 1348, 1349, 1350, 1351, 1352, 
  1353, 1354, 1355, 1356, 1357, 1358, 1359, 1360, 
  1361, 1362, 1363, 1364, 1365, 1366, 1367, 1368, 
  1369, 1370, 1371, 1372, 1373, 1374, 1375, 1376, 
  1377, 1378, 1379, 1380, 1381, 1382, 1383, 1384, 
  1385, 1386, 1387, 1388, 1389, 1390, 1391, 1392, 
  1393, 1394, 1395, 1396, 1397, 1398, 1399, 1400, 
  1401, 1402, 1403, 1404, 1405, 1406, 1407, 1408, 
  1409, 1410, 1411, 1412, 1413, 1414, 1415, 0, 
  0, 1416, 1417, 1418, 1419, 1420, 1421, 0, 
  0, 1083, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 1159, 1159, 1159, 
  1159, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  1159, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 340, 1159, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 340, 340, 340, 
  340, 1159, 1159, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 1159, 1159, 340, 
  340, 340, 340, 1159, 1159, 1159, 1159, 1159, 
  1159, 340, 340, 1159, 1159, 1159, 1159, 340, 
  340, 340, 340, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 340, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1043, 1043, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 1422, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1256, 1257, 0, 0, 
  0, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 1159, 340, 1159, 340, 340, 340, 340, 
  340, 340, 340, 340, 1043, 1043, 1043, 1423, 
  1423, 1423, 340, 340, 340, 340, 340, 340, 
  340, 340, 0, 0, 0, 0, 0, 0, 
  0, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 0, 1159, 
  1159, 1159, 1159, 1152, 1152, 1167, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1152, 1152, 1167, 1176, 1176, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1152, 1152, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1159, 1159, 340, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 0, 1159, 
  1159, 1159, 0, 1152, 1152, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 573, 573, 1158, 
  1152, 1152, 1152, 1152, 1152, 1152, 1152, 1158, 
  1158, 1158, 1158, 1158, 1158, 1158, 1158, 1152, 
  1158, 1158, 1152, 1152, 1152, 1152, 1152, 1152, 
  1152, 1152, 1152, 1167, 1152, 1176, 1176, 1043, 
  1178, 1176, 1176, 1176, 1188, 340, 539, 0, 
  0, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 
  1177, 1177, 1177, 0, 0, 0, 0, 0, 
  0, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 
  1424, 1424, 1424, 0, 0, 0, 0, 0, 
  0, 1425, 1425, 1425, 1425, 1425, 1425, 1426, 
  1425, 1425, 1425, 1425, 573, 573, 573, 81, 
  0, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 
  1177, 1177, 1177, 0, 0, 0, 0, 0, 
  0, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1178, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 0, 0, 0, 0, 0, 0, 0, 
  0, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1086, 1159, 0, 0, 0, 0, 
  0, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 1159, 340, 340, 340, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  0, 1152, 1152, 1152, 1158, 1158, 1158, 1158, 
  1152, 1152, 1158, 1158, 1158, 0, 0, 0, 
  0, 1158, 1158, 1152, 1158, 1158, 1158, 1158, 
  1158, 1158, 1085, 539, 552, 0, 0, 0, 
  0, 1084, 0, 0, 0, 1425, 1425, 1177, 
  1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 
  1177, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 0, 
  0, 340, 340, 340, 340, 340, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 0, 0, 0, 
  0, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 0, 0, 0, 0, 0, 
  0, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 
  1177, 1177, 1177, 1189, 0, 0, 0, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  539, 552, 1158, 1158, 1152, 0, 0, 1176, 
  1176, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1158, 1152, 
  1158, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 
  0, 1167, 1282, 1152, 1282, 1282, 1152, 1152, 
  1152, 1152, 1152, 1152, 1152, 1152, 1158, 1158, 
  1158, 1158, 1158, 1158, 1152, 1152, 539, 539, 
  539, 539, 539, 539, 539, 539, 0, 0, 
  552, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 
  1177, 1177, 1177, 0, 0, 0, 0, 0, 
  0, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 
  1177, 1177, 1177, 0, 0, 0, 0, 0, 
  0, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 
  1178, 1176, 1176, 1176, 1176, 1176, 1176, 0, 
  0, 539, 539, 539, 539, 539, 552, 552, 
  552, 552, 552, 552, 539, 539, 552, 838, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1152, 1152, 1152, 1152, 1158, 1427, 1428, 
  1429, 1430, 1431, 1432, 1433, 1434, 1435, 1436, 
  1159, 1159, 1437, 1438, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1179, 1439, 1152, 
  1152, 1152, 1152, 1440, 1441, 1442, 1443, 1444, 
  1445, 1446, 1447, 1448, 1449, 1450, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 0, 0, 0, 
  0, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 
  1177, 1177, 1177, 1176, 1176, 1176, 1176, 1176, 
  1176, 1176, 1190, 1190, 1190, 1190, 1190, 1190, 
  1190, 1190, 1190, 1190, 539, 552, 539, 539, 
  539, 539, 539, 539, 539, 1190, 1190, 1190, 
  1190, 1190, 1190, 1190, 1190, 1190, 0, 0, 
  0, 1152, 1152, 1158, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1158, 1152, 1152, 1152, 1152, 1158, 
  1158, 1152, 1152, 1450, 1167, 1152, 1152, 1159, 
  1159, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 
  1177, 1177, 1177, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1179, 
  1158, 1152, 1152, 1158, 1158, 1158, 1152, 1158, 
  1152, 1152, 1152, 1450, 1450, 0, 0, 0, 
  0, 0, 0, 0, 0, 1176, 1176, 1176, 
  1176, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1158, 1158, 1158, 
  1158, 1158, 1158, 1158, 1158, 1152, 1152, 1152, 
  1152, 1152, 1152, 1152, 1152, 1158, 1158, 1152, 
  1179, 0, 0, 0, 1176, 1176, 1176, 1176, 
  1176, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 
  1177, 1177, 1177, 0, 0, 0, 1159, 1159, 
  1159, 1248, 1248, 1248, 1248, 1248, 1248, 1248, 
  1248, 1248, 1248, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 522, 522, 522, 522, 522, 522, 1043, 
  1043, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 
  1176, 0, 0, 0, 0, 0, 0, 0, 
  0, 539, 539, 539, 1176, 565, 552, 552, 
  552, 552, 552, 539, 539, 552, 552, 552, 
  552, 539, 1158, 565, 565, 565, 565, 565, 
  565, 565, 1159, 1159, 1159, 1159, 552, 1159, 
  1159, 1159, 1159, 1158, 1158, 539, 1159, 1159, 
  0, 539, 539, 0, 0, 0, 0, 0, 
  0, 214, 214, 214, 214, 214, 214, 214, 
  214, 214, 214, 214, 214, 214, 214, 214, 
  214, 214, 214, 214, 214, 214, 214, 214, 
  214, 214, 214, 214, 214, 214, 214, 214, 
  214, 214, 214, 214, 214, 214, 214, 214, 
  214, 214, 214, 214, 214, 1451, 1452, 1453, 
  522, 1454, 1455, 1456, 1457, 1458, 1459, 1460, 
  1461, 1462, 1463, 1464, 522, 1465, 1466, 1467, 
  1468, 1469, 1470, 1471, 1472, 1473, 1474, 1475, 
  1476, 1477, 1478, 1479, 1480, 1481, 1482, 522, 
  1483, 1484, 1485, 1486, 1487, 1488, 1489, 1490, 
  1491, 1492, 1493, 1494, 1495, 1496, 1497, 1498, 
  1499, 1500, 1501, 1502, 1503, 1504, 1505, 1506, 
  1507, 1508, 1509, 1510, 214, 214, 214, 214, 
  214, 214, 214, 214, 214, 214, 214, 214, 
  214, 1511, 1512, 1513, 214, 214, 1514, 214, 
  214, 214, 214, 214, 214, 214, 214, 214, 
  214, 214, 214, 214, 214, 214, 214, 214, 
  214, 214, 214, 214, 214, 214, 1513, 214, 
  214, 214, 214, 214, 1515, 1516, 1517, 1518, 
  1481, 1519, 1520, 1521, 1522, 1523, 1524, 1525, 
  1526, 1527, 1528, 1529, 1530, 1531, 1532, 1533, 
  1534, 1535, 1536, 1537, 1538, 1539, 1540, 1541, 
  1542, 1543, 1544, 1545, 1546, 1547, 1548, 1549, 
  1550, 539, 539, 552, 539, 539, 539, 539, 
  539, 539, 539, 552, 539, 539, 575, 1551, 
  552, 554, 539, 539, 539, 539, 539, 539, 
  539, 539, 539, 539, 539, 539, 539, 539, 
  539, 539, 539, 539, 539, 539, 539, 539, 
  539, 539, 539, 539, 539, 539, 539, 539, 
  539, 539, 539, 539, 539, 539, 539, 0, 
  0, 0, 0, 0, 0, 574, 552, 539, 
  552, 1552, 1553, 1554, 1555, 1556, 1557, 1558, 
  1559, 1560, 1561, 1562, 1563, 1564, 1565, 1566, 
  1567, 1568, 1569, 1570, 1571, 1572, 1573, 1574, 
  1575, 1576, 1577, 1578, 1579, 1580, 1581, 1582, 
  1583, 1584, 1585, 1586, 1587, 1588, 1589, 1590, 
  1591, 1592, 1593, 1594, 1595, 1596, 1597, 1598, 
  1599, 1600, 1601, 1602, 1603, 1604, 1605, 1606, 
  1607, 1608, 1609, 1610, 1611, 1612, 1613, 1614, 
  1615, 1616, 1617, 1618, 1619, 1620, 1621, 1622, 
  1623, 1624, 1625, 1626, 1627, 1628, 1629, 1630, 
  1631, 1632, 1633, 1634, 1635, 1636, 1637, 1638, 
  1639, 1640, 1641, 1642, 1643, 1644, 1645, 1646, 
  1647, 1648, 1649, 1650, 1651, 1652, 1653, 1654, 
  1655, 1656, 1657, 1658, 1659, 1660, 1661, 1662, 
  1663, 1664, 1665, 1666, 1667, 1668, 1669, 1670, 
  1671, 1672, 1673, 1674, 1675, 1676, 1677, 1678, 
  1679, 1680, 1681, 1682, 1683, 1684, 1685, 1686, 
  1687, 1688, 1689, 1690, 1691, 1692, 1693, 1694, 
  1695, 1696, 1697, 1698, 1699, 1700, 1701, 1702, 
  1703, 1704, 1705, 1706, 1707, 214, 214, 1708, 
  214, 1709, 1710, 1711, 1712, 1713, 1714, 1715, 
  1716, 1717, 1718, 1719, 1720, 1721, 1722, 1723, 
  1724, 1725, 1726, 1727, 1728, 1729, 1730, 1731, 
  1732, 1733, 1734, 1735, 1736, 1737, 1738, 1739, 
  1740, 1741, 1742, 1743, 1744, 1745, 1746, 1747, 
  1748, 1749, 1750, 1751, 1752, 1753, 1754, 1755, 
  1756, 1757, 1758, 1759, 1760, 1761, 1762, 1763, 
  1764, 1765, 1766, 1767, 1768, 1769, 1770, 1771, 
  1772, 1773, 1774, 1775, 1776, 1777, 1778, 1779, 
  1780, 1781, 1782, 1783, 1784, 1785, 1786, 1787, 
  1788, 1789, 1790, 1791, 1792, 1793, 1794, 1795, 
  1796, 1797, 1798, 1799, 1800, 1801, 1802, 1803, 
  1804, 1805, 1806, 1807, 1808, 1809, 1810, 1811, 
  1812, 1813, 1814, 1815, 1816, 1817, 1818, 1819, 
  1820, 1821, 1822, 1823, 1824, 1825, 1826, 0, 
  0, 1827, 1828, 1829, 1830, 1831, 1832, 0, 
  0, 1833, 1834, 1835, 1836, 1837, 1838, 1839, 
  1840, 1841, 1842, 1843, 1844, 1845, 1846, 1847, 
  1848, 1849, 1850, 1851, 1852, 1853, 1854, 1855, 
  1856, 1857, 1858, 1859, 1860, 1861, 1862, 1863, 
  1864, 1865, 1866, 1867, 1868, 1869, 1870, 0, 
  0, 1871, 1872, 1873, 1874, 1875, 1876, 0, 
  0, 1877, 1878, 1879, 1880, 1881, 1882, 1883, 
  1884, 0, 1885, 0, 1886, 0, 1887, 0, 
  1888, 1889, 1890, 1891, 1892, 1893, 1894, 1895, 
  1896, 1897, 1898, 1899, 1900, 1901, 1902, 1903, 
  1904, 1905, 1906, 1907, 1908, 1909, 1910, 1911, 
  1912, 1913, 1914, 1915, 1916, 1917, 1918, 0, 
  0, 1919, 1920, 1921, 1922, 1923, 1924, 1925, 
  1926, 1927, 1928, 1929, 1930, 1931, 1932, 1933, 
  1934, 1935, 1936, 1937, 1938, 1939, 1940, 1941, 
  1942, 1943, 1944, 1945, 1946, 1947, 1948, 1949, 
  1950, 1951, 1952, 1953, 1954, 1955, 1956, 1957, 
  1958, 1959, 1960, 1961, 1962, 1963, 1964, 1965, 
  1966, 1967, 1968, 1969, 1970, 1971, 0, 1972, 
  1973, 1974, 1975, 1976, 1977, 1978, 1979, 1980, 
  1981, 1982, 1983, 1984, 1985, 1986, 0, 1987, 
  1988, 1989, 1990, 1991, 1992, 1993, 1994, 1995, 
  1996, 1997, 1998, 1999, 2000, 0, 0, 2001, 
  2002, 2003, 2004, 2005, 2006, 0, 2007, 2008, 
  2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 
  2017, 2018, 2019, 2020, 2021, 2022, 2023, 2024, 
  2025, 0, 0, 2026, 2027, 2028, 0, 2029, 
  2030, 2031, 2032, 2033, 2034, 2035, 2036, 2037, 
  0, 2038, 2039, 2040, 2041, 2040, 2040, 2040, 
  2042, 2040, 2040, 2040, 81, 2043, 2043, 2044, 
  2045, 1083, 2046, 1083, 1083, 1083, 1083, 9, 
  2047, 2048, 2049, 2050, 2048, 2048, 2049, 2050, 
  2048, 9, 9, 9, 9, 2051, 2052, 2053, 
  9, 2054, 2055, 2056, 2057, 2058, 2059, 2060, 
  76, 10, 10, 10, 2061, 2062, 9, 2063, 
  2064, 9, 80, 92, 9, 2065, 9, 2066, 
  48, 48, 9, 9, 9, 2067, 12, 13, 
  2068, 2069, 2070, 9, 9, 9, 9, 9, 
  9, 9, 9, 75, 9, 48, 9, 9, 
  2071, 9, 9, 9, 9, 9, 9, 9, 
  2040, 81, 81, 81, 81, 81, 0, 2072, 
  2073, 2074, 2075, 81, 81, 81, 81, 81, 
  81, 2076, 2077, 0, 0, 2078, 2079, 2080, 
  2081, 2082, 2083, 2084, 2085, 2086, 2087, 2088, 
  2089, 2090, 2091, 2092, 2093, 2094, 2095, 2096, 
  2097, 2098, 2099, 2100, 2101, 2102, 2103, 2104, 
  0, 2105, 2106, 2107, 2108, 2109, 2110, 2111, 
  2112, 2113, 2114, 2115, 2116, 2117, 0, 0, 
  0, 11, 11, 11, 11, 11, 11, 11, 
  11, 2118, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 1188, 11, 11, 11, 11, 11, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 539, 539, 565, 565, 539, 539, 539, 
  539, 565, 565, 565, 539, 539, 838, 838, 
  838, 838, 539, 838, 838, 838, 565, 565, 
  539, 552, 539, 565, 565, 552, 552, 552, 
  552, 539, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 2119, 2120, 2121, 2122, 77, 2123, 2124, 
  2125, 77, 2126, 2127, 2128, 2128, 2128, 2129, 
  2130, 2131, 2131, 2132, 2133, 77, 2134, 2135, 
  77, 75, 2136, 2137, 2138, 2138, 2138, 77, 
  77, 2139, 2140, 2141, 77, 2142, 77, 2143, 
  77, 2142, 77, 2144, 2145, 2146, 2121, 83, 
  2147, 2148, 2149, 2150, 2151, 2152, 2153, 2154, 
  2155, 2156, 2157, 1084, 2158, 2159, 2160, 2161, 
  2162, 2163, 75, 75, 75, 75, 2164, 2165, 
  2147, 2157, 2166, 77, 75, 1084, 77, 2167, 
  1190, 2168, 2169, 2170, 2171, 2172, 2173, 2174, 
  2175, 2176, 2177, 2178, 2179, 2180, 2181, 2182, 
  2183, 2184, 2185, 2186, 2187, 2188, 2189, 2190, 
  2191, 2192, 2193, 2194, 2195, 2196, 2197, 2198, 
  2199, 2200, 2201, 2202, 2203, 2204, 2205, 2206, 
  2207, 2208, 2209, 2210, 2211, 2212, 2213, 2214, 
  2215, 1423, 1423, 2216, 2217, 2218, 1423, 1423, 
  1423, 2216, 2219, 77, 77, 0, 0, 0, 
  0, 2220, 75, 2221, 75, 2222, 77, 77, 
  77, 77, 77, 2223, 2224, 77, 77, 77, 
  77, 75, 77, 77, 75, 77, 77, 75, 
  77, 77, 77, 77, 77, 77, 77, 2225, 
  77, 77, 77, 77, 77, 77, 77, 77, 
  77, 77, 77, 77, 77, 77, 77, 77, 
  77, 77, 77, 77, 77, 77, 77, 77, 
  77, 77, 77, 77, 77, 77, 2226, 2227, 
  2228, 2229, 77, 2230, 77, 2231, 77, 77, 
  77, 77, 77, 77, 77, 77, 77, 77, 
  77, 77, 77, 77, 77, 77, 77, 77, 
  77, 77, 77, 77, 77, 77, 77, 77, 
  77, 77, 77, 77, 77, 1108, 75, 75, 
  75, 75, 1108, 1108, 1108, 1108, 75, 75, 
  1108, 75, 2232, 2232, 2233, 2234, 75, 75, 
  75, 2235, 2236, 2232, 2237, 2238, 2232, 75, 
  75, 75, 2232, 14, 84, 75, 2232, 2232, 
  75, 75, 75, 2232, 2232, 2232, 2232, 75, 
  2232, 2232, 2232, 2232, 2239, 2240, 2241, 2242, 
  75, 75, 75, 75, 2232, 2243, 2244, 2232, 
  2245, 2246, 2232, 2232, 2232, 75, 75, 75, 
  75, 75, 2232, 75, 2232, 2247, 2232, 2232, 
  2232, 2232, 2248, 2232, 2249, 2250, 2251, 2232, 
  2252, 2253, 2254, 2232, 2232, 2232, 2255, 75, 
  75, 75, 75, 2232, 2232, 2232, 2232, 75, 
  75, 75, 75, 75, 75, 75, 75, 75, 
  2232, 2256, 2257, 2258, 75, 2259, 2260, 2232, 
  2232, 2232, 2232, 2232, 2232, 75, 2261, 2262, 
  2263, 2264, 2265, 2266, 2267, 2268, 2269, 2270, 
  2271, 2272, 2273, 2274, 2275, 2276, 2277, 2232, 
  2232, 2278, 2279, 2280, 2281, 2282, 2283, 2284, 
  2285, 2286, 2287, 2232, 2232, 2232, 75, 75, 
  2232, 2232, 2288, 2289, 75, 75, 75, 75, 
  75, 2232, 75, 75, 75, 75, 75, 75, 
  75, 75, 75, 2290, 2232, 75, 75, 2232, 
  2232, 2291, 2292, 2232, 2293, 2294, 2295, 2296, 
  2297, 2232, 2232, 2298, 2299, 2300, 2301, 2232, 
  2232, 2232, 75, 75, 75, 75, 75, 2232, 
  2232, 75, 75, 75, 75, 75, 75, 75, 
  75, 75, 2232, 2232, 2232, 2232, 2232, 75, 
  75, 2232, 2232, 75, 75, 75, 75, 2232, 
  2232, 2232, 2232, 2232, 2232, 2232, 2232, 2232, 
  2232, 2302, 2303, 2304, 2305, 2232, 2232, 2232, 
  2232, 2232, 2232, 2306, 2307, 2308, 2309, 75, 
  75, 2232, 2232, 2310, 2310, 2232, 2310, 2310, 
  2232, 2232, 2310, 2310, 2310, 2232, 2310, 2232, 
  2310, 77, 77, 77, 77, 77, 77, 77, 
  77, 12, 13, 12, 13, 77, 77, 77, 
  77, 77, 77, 77, 77, 77, 77, 77, 
  77, 77, 77, 77, 77, 77, 77, 77, 
  77, 2232, 2232, 77, 77, 77, 77, 77, 
  77, 77, 2311, 2312, 77, 77, 77, 77, 
  77, 77, 77, 77, 77, 77, 77, 837, 
  837, 837, 837, 837, 837, 837, 837, 837, 
  837, 837, 837, 837, 837, 837, 837, 837, 
  837, 837, 837, 837, 837, 837, 837, 837, 
  837, 837, 837, 837, 837, 837, 837, 837, 
  837, 837, 837, 837, 837, 837, 837, 837, 
  837, 837, 837, 837, 837, 837, 837, 837, 
  837, 837, 837, 837, 837, 837, 837, 837, 
  837, 837, 837, 837, 837, 837, 837, 837, 
  837, 837, 837, 837, 1084, 1108, 1084, 1084, 
  77, 77, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 837, 77, 
  1084, 1084, 1084, 1084, 75, 75, 75, 75, 
  75, 75, 75, 75, 75, 75, 75, 75, 
  75, 75, 75, 75, 75, 75, 75, 75, 
  75, 75, 75, 1108, 1108, 1084, 1084, 1084, 
  77, 77, 77, 77, 77, 77, 77, 77, 
  77, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 77, 77, 1084, 1084, 
  77, 77, 77, 77, 77, 1084, 1084, 1084, 
  1084, 1084, 1084, 77, 1084, 1108, 1108, 1108, 
  1108, 1108, 1108, 1084, 1084, 1084, 1084, 1084, 
  1084, 77, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 0, 0, 0, 0, 
  0, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 77, 77, 77, 77, 77, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 77, 77, 77, 77, 77, 77, 77, 
  77, 77, 77, 77, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 2313, 2314, 2315, 2316, 2317, 2318, 2319, 
  2320, 2321, 2322, 2323, 2324, 2325, 2326, 2327, 
  2328, 2329, 2330, 2331, 2332, 2333, 2334, 2335, 
  2336, 2337, 2338, 2339, 2340, 2341, 2342, 2343, 
  2344, 2345, 2346, 2347, 2348, 2349, 2350, 2351, 
  2352, 2353, 2354, 2355, 2356, 2357, 2358, 2359, 
  2360, 2361, 2362, 2363, 2364, 2365, 2366, 2367, 
  2368, 2369, 2370, 2371, 2372, 2373, 2374, 2375, 
  2376, 2377, 2378, 2379, 2380, 2381, 2382, 2383, 
  2384, 2385, 2386, 2387, 2388, 2389, 2390, 2391, 
  2392, 2393, 2394, 2395, 2396, 2397, 2398, 2399, 
  2400, 2401, 2402, 2403, 2404, 2405, 2406, 2407, 
  2408, 2409, 2410, 2411, 2412, 2413, 2414, 2415, 
  2416, 2417, 2418, 2419, 2420, 2421, 2422, 2423, 
  2424, 2425, 2426, 2427, 2428, 2429, 2430, 2431, 
  2432, 2433, 2434, 2435, 2436, 2437, 2438, 2439, 
  2440, 2441, 2442, 2443, 2444, 2445, 2446, 2447, 
  2448, 2449, 2450, 2451, 1219, 1219, 1219, 1219, 
  1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 
  1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 
  1219, 77, 77, 77, 77, 77, 77, 77, 
  77, 77, 77, 77, 77, 77, 77, 77, 
  77, 77, 77, 77, 77, 77, 77, 77, 
  77, 77, 77, 77, 77, 77, 77, 77, 
  77, 77, 77, 77, 77, 77, 77, 77, 
  77, 77, 77, 77, 77, 77, 77, 77, 
  77, 77, 77, 77, 77, 77, 77, 77, 
  77, 77, 77, 77, 77, 77, 77, 77, 
  77, 77, 77, 77, 77, 77, 77, 77, 
  77, 77, 77, 77, 77, 77, 77, 77, 
  77, 77, 77, 77, 77, 77, 77, 77, 
  77, 77, 77, 77, 77, 77, 77, 77, 
  77, 77, 77, 77, 77, 77, 77, 77, 
  77, 77, 77, 77, 77, 77, 77, 77, 
  77, 77, 77, 77, 77, 77, 77, 77, 
  77, 77, 77, 77, 77, 77, 77, 77, 
  77, 77, 77, 77, 77, 77, 77, 77, 
  77, 77, 77, 77, 77, 77, 77, 77, 
  77, 77, 77, 77, 77, 77, 77, 77, 
  77, 77, 77, 77, 77, 77, 77, 77, 
  77, 77, 77, 77, 77, 77, 77, 77, 
  77, 77, 77, 77, 77, 77, 77, 77, 
  77, 77, 77, 77, 77, 77, 77, 77, 
  75, 77, 77, 77, 77, 77, 77, 77, 
  77, 77, 75, 77, 77, 77, 77, 77, 
  77, 77, 77, 77, 77, 77, 77, 77, 
  77, 77, 77, 77, 77, 77, 77, 77, 
  77, 77, 77, 77, 77, 77, 77, 77, 
  77, 77, 77, 77, 77, 77, 77, 77, 
  77, 77, 77, 77, 77, 77, 77, 77, 
  77, 77, 77, 77, 77, 77, 77, 77, 
  77, 75, 75, 75, 75, 75, 75, 75, 
  75, 77, 77, 77, 1084, 77, 77, 77, 
  77, 77, 77, 77, 77, 77, 77, 77, 
  77, 77, 77, 77, 77, 77, 1084, 1084, 
  1084, 1084, 1084, 77, 77, 77, 77, 77, 
  77, 77, 77, 1084, 1084, 1084, 77, 77, 
  77, 77, 77, 77, 1084, 1084, 77, 77, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 77, 77, 77, 77, 77, 77, 77, 
  77, 77, 77, 77, 77, 77, 77, 77, 
  77, 77, 77, 77, 77, 77, 77, 77, 
  77, 77, 77, 77, 77, 77, 77, 77, 
  77, 77, 77, 77, 77, 77, 77, 77, 
  77, 77, 77, 77, 77, 77, 77, 77, 
  77, 77, 77, 77, 77, 77, 77, 77, 
  75, 77, 77, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 77, 77, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 77, 1084, 1084, 1084, 1084, 1084, 
  1084, 77, 1084, 77, 77, 837, 1084, 1084, 
  1084, 1084, 1084, 77, 77, 77, 77, 1084, 
  77, 77, 77, 77, 77, 77, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 77, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 12, 13, 12, 13, 12, 13, 12, 
  13, 12, 13, 12, 13, 12, 13, 1219, 
  1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 
  1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 
  1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 
  1219, 1219, 1219, 1219, 1219, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 77, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 2232, 1108, 75, 2310, 2310, 12, 13, 
  75, 2310, 2310, 75, 2310, 2310, 2310, 1108, 
  1108, 1108, 75, 1108, 2232, 2232, 2310, 2310, 
  1108, 1108, 1108, 1108, 1108, 2310, 2310, 2310, 
  1108, 75, 1108, 2310, 2310, 2310, 2310, 12, 
  13, 12, 13, 12, 13, 12, 13, 12, 
  13, 1108, 1108, 1108, 1108, 1108, 1108, 1108, 
  1108, 1108, 1108, 1108, 1108, 1108, 1108, 1108, 
  1108, 837, 837, 837, 837, 837, 837, 837, 
  837, 837, 837, 837, 837, 837, 837, 837, 
  837, 837, 837, 837, 837, 837, 837, 837, 
  837, 837, 837, 837, 837, 837, 837, 837, 
  837, 837, 837, 837, 837, 837, 837, 837, 
  837, 837, 837, 837, 837, 837, 837, 837, 
  837, 837, 837, 837, 837, 837, 837, 837, 
  837, 837, 837, 837, 837, 837, 837, 837, 
  837, 837, 837, 837, 837, 837, 837, 837, 
  837, 837, 837, 837, 837, 837, 837, 837, 
  837, 837, 837, 837, 837, 837, 837, 837, 
  837, 837, 837, 837, 837, 837, 837, 837, 
  837, 837, 837, 837, 837, 837, 837, 837, 
  837, 837, 837, 837, 837, 837, 837, 837, 
  837, 837, 837, 837, 837, 837, 837, 837, 
  837, 837, 837, 837, 837, 837, 837, 837, 
  837, 837, 837, 837, 837, 837, 837, 837, 
  837, 837, 837, 837, 837, 837, 837, 837, 
  837, 837, 837, 837, 837, 837, 837, 837, 
  837, 837, 837, 837, 837, 837, 837, 837, 
  837, 837, 837, 837, 837, 837, 837, 837, 
  837, 837, 837, 837, 837, 837, 837, 837, 
  837, 837, 837, 837, 837, 837, 837, 837, 
  837, 837, 837, 837, 837, 837, 837, 837, 
  837, 837, 837, 837, 837, 837, 837, 837, 
  837, 837, 837, 837, 837, 837, 837, 837, 
  837, 837, 837, 837, 837, 837, 837, 837, 
  837, 837, 837, 837, 837, 837, 837, 837, 
  837, 837, 837, 837, 837, 837, 837, 837, 
  837, 837, 837, 837, 837, 837, 837, 837, 
  837, 837, 837, 837, 837, 837, 837, 837, 
  837, 837, 837, 837, 837, 837, 837, 837, 
  837, 1108, 1108, 1108, 1108, 1108, 1108, 1108, 
  1108, 75, 75, 1108, 1108, 1108, 1108, 1108, 
  1108, 1108, 1108, 75, 75, 1108, 1108, 1108, 
  1108, 1108, 1108, 1108, 1108, 1108, 1108, 1108, 
  1108, 1108, 1108, 1108, 1108, 1108, 1108, 1108, 
  1108, 1108, 1108, 1108, 1108, 1108, 1108, 1108, 
  1108, 1108, 1108, 1108, 1108, 1108, 1108, 1108, 
  1108, 75, 75, 1108, 1108, 1108, 1108, 1108, 
  1108, 1108, 1108, 1108, 1108, 1108, 1108, 1108, 
  1108, 1108, 75, 1108, 1108, 75, 75, 1108, 
  75, 1108, 75, 1108, 1108, 75, 75, 1108, 
  1108, 75, 75, 1108, 1108, 75, 75, 1108, 
  1108, 75, 75, 1108, 1108, 1108, 1108, 1108, 
  1108, 1108, 1108, 1108, 1108, 1108, 1108, 1108, 
  1108, 1108, 1108, 1108, 1108, 1108, 1108, 1108, 
  1108, 1108, 1108, 1108, 1108, 75, 75, 1108, 
  1108, 75, 1108, 75, 12, 13, 12, 13, 
  12, 13, 12, 13, 12, 13, 12, 13, 
  12, 13, 12, 13, 1256, 1257, 1256, 1257, 
  12, 13, 75, 1108, 2310, 2310, 2310, 2310, 
  2310, 2310, 2310, 2310, 2310, 2310, 2310, 2232, 
  2232, 2310, 2310, 2310, 2310, 2310, 2310, 2310, 
  2310, 1108, 1108, 1108, 1108, 1108, 1108, 1108, 
  1108, 2310, 1108, 1108, 1108, 1108, 1108, 1108, 
  1108, 2310, 2310, 2310, 2310, 2310, 2310, 1108, 
  1108, 1108, 2310, 1108, 1108, 1108, 1108, 2310, 
  2310, 2310, 2232, 2232, 75, 2232, 2232, 75, 
  75, 12, 13, 1256, 1257, 2310, 1108, 1108, 
  1108, 1108, 2310, 1108, 2310, 2310, 2310, 1108, 
  1108, 2310, 2310, 1108, 75, 1108, 1108, 1108, 
  1108, 1108, 1108, 1108, 1108, 2310, 2232, 2232, 
  2232, 2232, 2232, 75, 75, 12, 13, 1108, 
  1108, 1108, 1108, 1108, 1108, 1108, 1108, 1108, 
  1108, 1108, 1108, 2310, 2310, 2452, 2310, 2310, 
  2310, 2310, 2310, 2310, 2310, 2310, 2310, 2310, 
  2310, 2310, 2310, 2310, 2310, 2310, 1108, 2232, 
  2232, 2310, 2232, 75, 75, 2232, 75, 2232, 
  1108, 75, 2232, 75, 2232, 2232, 2310, 2310, 
  75, 75, 75, 75, 1108, 2310, 2310, 1108, 
  1108, 1108, 1108, 1108, 1108, 2232, 2232, 2232, 
  1108, 1108, 1108, 1108, 1108, 1108, 1108, 75, 
  75, 75, 75, 75, 75, 1108, 1108, 1108, 
  1108, 1108, 1108, 1108, 1108, 1108, 1108, 1108, 
  2310, 2310, 1108, 1108, 1108, 1108, 1108, 1108, 
  1108, 1108, 1108, 1108, 1108, 2310, 2310, 75, 
  75, 1108, 1108, 2232, 2232, 2232, 2232, 1108, 
  2232, 2232, 75, 75, 2232, 2453, 2454, 2455, 
  75, 1108, 2310, 2310, 2310, 2310, 2310, 2310, 
  2310, 2310, 2310, 2310, 2310, 2310, 2310, 2310, 
  2310, 2310, 2310, 2310, 2232, 2232, 2310, 2310, 
  2232, 2232, 2232, 2232, 2232, 2232, 2310, 2310, 
  2310, 2310, 2310, 2310, 2310, 2310, 2310, 2310, 
  2310, 2310, 2310, 2310, 2310, 1108, 1108, 2310, 
  2310, 2310, 2310, 2310, 2310, 2310, 2310, 1108, 
  2310, 2310, 2310, 2310, 2310, 2310, 2310, 2310, 
  2310, 2310, 2310, 2310, 2310, 2310, 2310, 2310, 
  2232, 2232, 2232, 2232, 2232, 2232, 2232, 2232, 
  2310, 2310, 2232, 2232, 2232, 2232, 2310, 2310, 
  2310, 2310, 2310, 2310, 2232, 2232, 2232, 2232, 
  1108, 1108, 1108, 1108, 1108, 2456, 2457, 2232, 
  1108, 1108, 1108, 2310, 2310, 2310, 2310, 2310, 
  1108, 1108, 1108, 1108, 1108, 2310, 2310, 2232, 
  75, 75, 75, 75, 2310, 1108, 1108, 75, 
  2310, 2310, 2310, 2310, 2310, 1108, 2310, 75, 
  75, 1084, 1084, 1084, 1084, 1084, 1084, 77, 
  77, 1084, 1084, 1084, 1084, 1084, 77, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 77, 77, 
  1084, 1084, 1084, 1084, 1084, 1084, 77, 77, 
  77, 77, 77, 77, 77, 1084, 1084, 77, 
  77, 1108, 1108, 1108, 1108, 1108, 1108, 1108, 
  1108, 1108, 1108, 1108, 1108, 1108, 1108, 1108, 
  1108, 1108, 1108, 1108, 1108, 1108, 1084, 1084, 
  1108, 1108, 1108, 1108, 1108, 1108, 1084, 77, 
  77, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 0, 0, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 0, 
  0, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 0, 0, 0, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 0, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 1084, 1084, 1084, 
  1084, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 2458, 2459, 2460, 2461, 2462, 2463, 2464, 
  2465, 2466, 2467, 2468, 2469, 2470, 2471, 2472, 
  2473, 2474, 2475, 2476, 2477, 2478, 2479, 2480, 
  2481, 2482, 2483, 2484, 2485, 2486, 2487, 2488, 
  2489, 2490, 2491, 2492, 2493, 2494, 2495, 2496, 
  2497, 2498, 2499, 2500, 2501, 2502, 2503, 2504, 
  0, 2505, 2506, 2507, 2508, 2509, 2510, 2511, 
  2512, 2513, 2514, 2515, 2516, 2517, 2518, 2519, 
  2520, 2521, 2522, 2523, 2524, 2525, 2526, 2527, 
  2528, 2529, 2530, 2531, 2532, 2533, 2534, 2535, 
  2536, 2537, 2538, 2539, 2540, 2541, 2542, 2543, 
  2544, 2545, 2546, 2547, 2548, 2549, 2550, 2551, 
  0, 2552, 2553, 2554, 2555, 2556, 2557, 2558, 
  2559, 2560, 2561, 2562, 2563, 2564, 2565, 2566, 
  2567, 2568, 214, 2569, 2570, 214, 2571, 2572, 
  214, 214, 214, 214, 214, 2573, 2574, 2575, 
  2576, 2577, 2578, 2579, 2580, 2581, 2582, 2583, 
  2584, 2585, 2586, 2587, 2588, 2589, 2590, 2591, 
  2592, 2593, 2594, 2595, 2596, 2597, 2598, 2599, 
  2600, 2601, 2602, 2603, 2604, 2605, 2606, 2607, 
  2608, 2609, 2610, 2611, 2612, 2613, 2614, 2615, 
  2616, 2617, 2618, 2619, 2620, 2621, 2622, 2623, 
  2624, 2625, 2626, 2627, 2628, 2629, 2630, 2631, 
  2632, 2633, 2634, 2635, 2636, 2637, 2638, 2639, 
  2640, 2641, 2642, 2643, 2644, 2645, 2646, 2647, 
  2648, 2649, 2650, 2651, 2652, 2653, 2654, 2655, 
  2656, 2657, 2658, 2659, 2660, 2661, 2662, 2663, 
  2664, 2665, 2666, 2667, 2668, 2669, 2670, 2671, 
  2672, 2673, 2674, 2675, 2676, 214, 77, 77, 
  1084, 77, 77, 1084, 2677, 2678, 2679, 2680, 
  539, 539, 539, 2681, 2682, 0, 0, 0, 
  0, 0, 9, 9, 9, 9, 1424, 9, 
  9, 2683, 2684, 2685, 2686, 2687, 2688, 2689, 
  2690, 2691, 2692, 2693, 2694, 2695, 2696, 2697, 
  2698, 2699, 2700, 2701, 2702, 2703, 2704, 2705, 
  2706, 2707, 2708, 2709, 2710, 2711, 2712, 2713, 
  2714, 2715, 2716, 2717, 2718, 2719, 2720, 0, 
  2721, 0, 0, 0, 0, 0, 2722, 0, 
  0, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 1159, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 0, 0, 0, 0, 0, 0, 0, 
  2723, 1043, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  1167, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  0, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  0, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  0, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  0, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  0, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  0, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  0, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  0, 539, 539, 539, 539, 539, 539, 539, 
  539, 539, 539, 539, 539, 539, 539, 539, 
  539, 539, 539, 539, 539, 539, 539, 539, 
  539, 539, 539, 539, 539, 539, 539, 539, 
  539, 9, 9, 80, 92, 80, 92, 9, 
  9, 9, 80, 92, 9, 80, 92, 1425, 
  1425, 1425, 1425, 9, 1425, 1425, 1425, 9, 
  1083, 9, 9, 1083, 9, 80, 92, 9, 
  9, 80, 92, 12, 13, 12, 13, 12, 
  13, 12, 13, 9, 9, 9, 9, 9, 
  521, 9, 9, 9, 9, 9, 9, 9, 
  9, 9, 9, 1083, 1083, 9, 9, 9, 
  9, 1083, 9, 2050, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 0, 1084, 1084, 1084, 1084, 
  2724, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 2725, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 2726, 2727, 2728, 2729, 2730, 2731, 2732, 
  2733, 2734, 2735, 2736, 2737, 2738, 2739, 2740, 
  2741, 2742, 2743, 2744, 2745, 2746, 2747, 2748, 
  2749, 2750, 2751, 2752, 2753, 2754, 2755, 2756, 
  2757, 2758, 2759, 2760, 2761, 2762, 2763, 2764, 
  2765, 2766, 2767, 2768, 2769, 2770, 2771, 2772, 
  2773, 2774, 2775, 2776, 2777, 2778, 2779, 2780, 
  2781, 2782, 2783, 2784, 2785, 2786, 2787, 2788, 
  2789, 2790, 2791, 2792, 2793, 2794, 2795, 2796, 
  2797, 2798, 2799, 2800, 2801, 2802, 2803, 2804, 
  2805, 2806, 2807, 2808, 2809, 2810, 2811, 2812, 
  2813, 2814, 2815, 2816, 2817, 2818, 2819, 2820, 
  2821, 2822, 2823, 2824, 2825, 2826, 2827, 2828, 
  2829, 2830, 2831, 2832, 2833, 2834, 2835, 2836, 
  2837, 2838, 2839, 2840, 2841, 2842, 2843, 2844, 
  2845, 2846, 2847, 2848, 2849, 2850, 2851, 2852, 
  2853, 2854, 2855, 2856, 2857, 2858, 2859, 2860, 
  2861, 2862, 2863, 2864, 2865, 2866, 2867, 2868, 
  2869, 2870, 2871, 2872, 2873, 2874, 2875, 2876, 
  2877, 2878, 2879, 2880, 2881, 2882, 2883, 2884, 
  2885, 2886, 2887, 2888, 2889, 2890, 2891, 2892, 
  2893, 2894, 2895, 2896, 2897, 2898, 2899, 2900, 
  2901, 2902, 2903, 2904, 2905, 2906, 2907, 2908, 
  2909, 2910, 2911, 2912, 2913, 2914, 2915, 2916, 
  2917, 2918, 2919, 2920, 2921, 2922, 2923, 2924, 
  2925, 2926, 2927, 2928, 2929, 2930, 2931, 2932, 
  2933, 2934, 2935, 2936, 2937, 2938, 2939, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 0, 0, 0, 
  0, 2940, 1425, 1425, 1425, 1084, 1178, 1159, 
  2216, 1256, 1257, 1256, 1257, 1256, 1257, 1256, 
  1257, 1256, 1257, 1084, 1084, 1256, 1257, 1256, 
  1257, 1256, 1257, 1256, 1257, 1426, 2941, 2942, 
  2942, 1084, 2216, 2216, 2216, 2216, 2216, 2216, 
  2216, 2216, 2216, 2943, 1086, 551, 1085, 2944, 
  2944, 1426, 1178, 1178, 1178, 1178, 1178, 2945, 
  1084, 2946, 2947, 2948, 1178, 1159, 1425, 1084, 
  77, 0, 1159, 1159, 1159, 1159, 1159, 2949, 
  1159, 1159, 1159, 1159, 2950, 2951, 2952, 2953, 
  2954, 2955, 2956, 2957, 2958, 2959, 2960, 2961, 
  2962, 2963, 2964, 2965, 2966, 2967, 2968, 2969, 
  2970, 2971, 2972, 2973, 1159, 2974, 2975, 2976, 
  2977, 2978, 2979, 1159, 1159, 1159, 1159, 1159, 
  2980, 2981, 2982, 2983, 2984, 2985, 2986, 2987, 
  2988, 2989, 2990, 2991, 2992, 2993, 2994, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 2995, 1159, 1159, 
  0, 0, 2996, 2997, 2998, 2999, 3000, 3001, 
  3002, 1426, 1159, 1159, 1159, 1159, 1159, 3003, 
  1159, 1159, 1159, 1159, 3004, 3005, 3006, 3007, 
  3008, 3009, 3010, 3011, 3012, 3013, 3014, 3015, 
  3016, 3017, 3018, 3019, 3020, 3021, 3022, 3023, 
  3024, 3025, 3026, 3027, 1159, 3028, 3029, 3030, 
  3031, 3032, 3033, 1159, 1159, 1159, 1159, 1159, 
  3034, 3035, 3036, 3037, 3038, 3039, 3040, 3041, 
  3042, 3043, 3044, 3045, 3046, 3047, 3048, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  3049, 3050, 3051, 3052, 1159, 3053, 1159, 1159, 
  3054, 3055, 3056, 3057, 1425, 1178, 3058, 3059, 
  3060, 0, 0, 0, 0, 0, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 0, 
  0, 0, 3061, 3062, 3063, 3064, 3065, 3066, 
  3067, 3068, 3069, 3070, 3071, 3072, 3073, 3074, 
  3075, 3076, 3077, 3078, 3079, 3080, 3081, 3082, 
  3083, 3084, 3085, 3086, 3087, 3088, 3089, 3090, 
  3091, 3092, 3093, 3094, 3095, 3096, 3097, 3098, 
  3099, 3100, 3101, 3102, 3103, 3104, 3105, 3106, 
  3107, 3108, 3109, 3110, 3111, 3112, 3113, 3114, 
  3115, 3116, 3117, 3118, 3119, 3120, 3121, 3122, 
  3123, 3124, 3125, 3126, 3127, 3128, 3129, 3130, 
  3131, 3132, 3133, 3134, 3135, 3136, 3137, 3138, 
  3139, 3140, 3141, 3142, 3143, 3144, 3145, 3146, 
  3147, 3148, 3149, 3150, 3151, 3152, 3153, 3154, 
  0, 1190, 1190, 3155, 3156, 3157, 3158, 3159, 
  3160, 3161, 3162, 3163, 3164, 3165, 3166, 3167, 
  3168, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 0, 0, 0, 0, 
  0, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 3169, 3170, 3171, 3172, 3173, 3174, 3175, 
  3176, 3177, 3178, 3179, 3180, 3181, 3182, 3183, 
  3184, 3185, 3186, 3187, 3188, 3189, 3190, 3191, 
  3192, 3193, 3194, 3195, 3196, 3197, 3198, 3199, 
  0, 3200, 3201, 3202, 3203, 3204, 3205, 3206, 
  3207, 3208, 3209, 3210, 3211, 3212, 3213, 3214, 
  3215, 3216, 3217, 3218, 3219, 3220, 3221, 3222, 
  3223, 3224, 3225, 3226, 3227, 3228, 3229, 3230, 
  3231, 3232, 3233, 3234, 3235, 3236, 3237, 3238, 
  3239, 1189, 1189, 1189, 1189, 1189, 1189, 1189, 
  1189, 3240, 3241, 3242, 3243, 3244, 3245, 3246, 
  3247, 3248, 3249, 3250, 3251, 3252, 3253, 3254, 
  3255, 3256, 3257, 3258, 3259, 3260, 3261, 3262, 
  3263, 3264, 3265, 3266, 3267, 3268, 3269, 3270, 
  3271, 3272, 3273, 3274, 3275, 3276, 3277, 3278, 
  3279, 3280, 3281, 3282, 3283, 3284, 3285, 3286, 
  1190, 3287, 3288, 3289, 3290, 3291, 3292, 3293, 
  3294, 3295, 3296, 3297, 3298, 3299, 3300, 3301, 
  3302, 3303, 3304, 3305, 3306, 3307, 3308, 3309, 
  3310, 3311, 3312, 3313, 3314, 3315, 3316, 3317, 
  3318, 3319, 3320, 3321, 3322, 3323, 3324, 3325, 
  3326, 3327, 3328, 3329, 3330, 3331, 3332, 3333, 
  3334, 3335, 3336, 3337, 3338, 3339, 3340, 3341, 
  3342, 3343, 3344, 3345, 3346, 3347, 3348, 3349, 
  3350, 3351, 3352, 3353, 3354, 3355, 3356, 3357, 
  3358, 3359, 3360, 3361, 3362, 3363, 3364, 3365, 
  3366, 3367, 3368, 3369, 3370, 3371, 3372, 3373, 
  3374, 3375, 3376, 3377, 3378, 3379, 3380, 3381, 
  3382, 3383, 3384, 3385, 3386, 3387, 3388, 3389, 
  3390, 3391, 3392, 3393, 3394, 3395, 3396, 3397, 
  3398, 3399, 3400, 3401, 3402, 3403, 3404, 3405, 
  3406, 3407, 3408, 3409, 3410, 3411, 3412, 3413, 
  0, 3414, 3415, 3416, 3417, 3418, 3419, 3420, 
  3421, 3422, 3423, 3424, 3425, 3426, 3427, 3428, 
  3429, 3430, 3431, 3432, 3433, 3434, 3435, 3436, 
  3437, 3438, 3439, 3440, 3441, 3442, 3443, 3444, 
  3445, 3446, 3447, 3448, 3449, 3450, 3451, 3452, 
  3453, 3454, 3455, 3456, 3457, 3458, 3459, 3460, 
  3461, 3462, 3463, 3464, 3465, 3466, 3467, 3468, 
  3469, 3470, 3471, 3472, 3473, 3474, 3475, 3476, 
  3477, 3478, 3479, 3480, 3481, 3482, 3483, 3484, 
  3485, 3486, 3487, 3488, 3489, 3490, 3491, 3492, 
  3493, 3494, 3495, 3496, 3497, 3498, 3499, 3500, 
  3501, 3502, 3503, 3504, 3505, 3506, 3507, 3508, 
  3509, 3510, 3511, 3512, 3513, 3514, 3515, 3516, 
  3517, 3518, 3519, 3520, 3521, 3522, 3523, 3524, 
  3525, 3526, 3527, 3528, 3529, 3530, 3531, 3532, 
  3533, 3534, 3535, 3536, 3537, 3538, 3539, 3540, 
  3541, 3542, 3543, 3544, 3545, 3546, 3547, 3548, 
  3549, 3550, 3551, 3552, 3553, 3554, 3555, 3556, 
  3557, 3558, 3559, 3560, 3561, 3562, 3563, 3564, 
  3565, 3566, 3567, 3568, 3569, 3570, 3571, 3572, 
  3573, 3574, 3575, 3576, 3577, 3578, 3579, 3580, 
  3581, 3582, 3583, 3584, 3585, 3586, 3587, 3588, 
  3589, 3590, 3591, 3592, 3593, 3594, 3595, 3596, 
  3597, 3598, 3599, 3600, 3601, 3602, 3603, 3604, 
  3605, 3606, 3607, 3608, 3609, 3610, 3611, 3612, 
  3613, 3614, 3615, 3616, 3617, 3618, 3619, 3620, 
  3621, 3622, 3623, 3624, 3625, 3626, 3627, 3628, 
  3629, 3630, 3631, 3632, 3633, 3634, 3635, 3636, 
  3637, 3638, 3639, 3640, 3641, 3642, 3643, 3644, 
  3645, 3646, 3647, 3648, 3649, 3650, 3651, 3652, 
  3653, 3654, 3655, 3656, 3657, 3658, 3659, 3660, 
  3661, 3662, 3663, 3664, 3665, 3666, 3667, 3668, 
  3669, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1178, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 0, 0, 
  0, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 522, 522, 522, 522, 522, 522, 1043, 
  1043, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1178, 1425, 1425, 
  1425, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 
  1177, 1177, 1177, 1159, 1159, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 3670, 3671, 3672, 3673, 3674, 3675, 3676, 
  3677, 3678, 3679, 3680, 3681, 3682, 3683, 3684, 
  3685, 3686, 3687, 3688, 3689, 3690, 3691, 3692, 
  3693, 3694, 3695, 3696, 3697, 3698, 3699, 3700, 
  3701, 3702, 3703, 3704, 3705, 3706, 3707, 3708, 
  3709, 3710, 3711, 3712, 3713, 3714, 3715, 1159, 
  539, 838, 838, 838, 9, 539, 539, 539, 
  539, 539, 539, 539, 539, 539, 539, 9, 
  521, 3716, 3717, 3718, 3719, 3720, 3721, 3722, 
  3723, 3724, 3725, 3726, 3727, 3728, 3729, 3730, 
  3731, 3732, 3733, 3734, 3735, 3736, 3737, 3738, 
  3739, 3740, 3741, 3742, 3743, 3744, 3745, 539, 
  539, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 1423, 
  1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
  1423, 539, 539, 1043, 1043, 1043, 1043, 1043, 
  1043, 0, 0, 0, 0, 0, 0, 0, 
  0, 47, 47, 47, 47, 47, 47, 47, 
  47, 47, 47, 47, 47, 47, 47, 47, 
  47, 47, 47, 47, 47, 47, 47, 47, 
  521, 521, 521, 521, 521, 521, 521, 521, 
  521, 47, 47, 3746, 3747, 3748, 3749, 3750, 
  3751, 3752, 3753, 3754, 3755, 3756, 3757, 3758, 
  3759, 214, 214, 3760, 3761, 3762, 3763, 3764, 
  3765, 3766, 3767, 3768, 3769, 3770, 3771, 3772, 
  3773, 3774, 3775, 3776, 3777, 3778, 3779, 3780, 
  3781, 3782, 3783, 3784, 3785, 3786, 3787, 3788, 
  3789, 3790, 3791, 3792, 3793, 3794, 3795, 3796, 
  3797, 3798, 3799, 3800, 3801, 3802, 3803, 3804, 
  3805, 3806, 3807, 3808, 3809, 3810, 3811, 3812, 
  3813, 3814, 3815, 3816, 3817, 3818, 3819, 3820, 
  3821, 3822, 1513, 1513, 1513, 1513, 1513, 1513, 
  1513, 214, 3823, 3824, 3825, 3826, 3827, 3828, 
  3829, 3830, 3831, 3832, 3833, 3834, 3835, 3836, 
  3837, 521, 3838, 3838, 3839, 3840, 3841, 214, 
  340, 3842, 3843, 3844, 3845, 214, 214, 3846, 
  3847, 3848, 3849, 3850, 3851, 3852, 3853, 3854, 
  3855, 3856, 3857, 3858, 3859, 3860, 3861, 3862, 
  3863, 3864, 3865, 3866, 3867, 3868, 3869, 0, 
  0, 3870, 3871, 3872, 3873, 3874, 3875, 3876, 
  3877, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  340, 3878, 3879, 214, 340, 340, 340, 340, 
  1159, 1159, 1159, 1152, 1159, 1159, 1159, 1167, 
  1159, 1159, 1159, 1159, 1152, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1158, 1158, 1152, 1152, 
  1158, 77, 77, 1084, 1084, 0, 0, 0, 
  0, 1189, 1189, 1189, 1189, 1189, 1189, 1190, 
  1190, 1188, 3880, 0, 0, 0, 0, 0, 
  0, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1425, 1425, 1425, 
  1425, 0, 0, 0, 0, 0, 0, 0, 
  0, 1158, 1158, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1158, 1158, 1158, 
  1158, 1158, 1158, 1158, 1158, 1158, 1158, 1158, 
  1158, 1158, 1158, 1158, 1158, 1167, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 1176, 
  1176, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 
  1177, 1177, 1177, 0, 0, 0, 0, 0, 
  0, 539, 539, 539, 539, 539, 539, 539, 
  539, 539, 539, 539, 539, 539, 539, 539, 
  539, 539, 539, 1159, 1159, 1159, 1159, 1159, 
  1159, 1176, 1176, 1176, 1159, 1176, 1159, 0, 
  0, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 
  1177, 1177, 1177, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1152, 
  1152, 1152, 1152, 1152, 552, 552, 552, 1176, 
  1176, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 
  1152, 1152, 1152, 1158, 1450, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  1176, 1325, 1325, 1325, 1325, 1325, 1325, 1325, 
  1325, 1325, 1325, 1325, 1325, 1325, 1325, 1325, 
  1325, 1325, 1325, 1325, 1325, 1325, 1325, 1325, 
  1325, 1325, 1325, 1325, 1325, 1325, 0, 0, 
  0, 1152, 1152, 1152, 1158, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1179, 1158, 1158, 1152, 
  1152, 1152, 1152, 1158, 1158, 1152, 1158, 1158, 
  1158, 1450, 1176, 1176, 1176, 1176, 1176, 1176, 
  1176, 1176, 1176, 1176, 1176, 1176, 1176, 0, 
  1178, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 
  1177, 1177, 1177, 0, 0, 0, 0, 1176, 
  1176, 340, 1159, 1159, 1159, 1159, 1152, 522, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  340, 1248, 1248, 1248, 1248, 1248, 1248, 1248, 
  1248, 1248, 1177, 1159, 1159, 1159, 340, 1159, 
  0, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1152, 1152, 1152, 1152, 1152, 1152, 
  1158, 1158, 1152, 1152, 1158, 1158, 1152, 1152, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1159, 1159, 1159, 1152, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1152, 1158, 0, 
  0, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 
  1177, 1177, 1177, 0, 0, 1176, 1176, 1176, 
  1176, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1178, 1159, 1159, 1159, 1159, 1159, 1159, 
  1190, 1190, 1190, 1159, 1282, 1152, 1282, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 539, 1159, 539, 539, 552, 1159, 1159, 
  539, 539, 1159, 1159, 1159, 1159, 1159, 539, 
  539, 1159, 539, 1159, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 1159, 1159, 1178, 1176, 
  1176, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1158, 1152, 1152, 1158, 
  1158, 1176, 1176, 1159, 1178, 1178, 1158, 1167, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 1159, 1159, 1159, 1159, 1159, 1159, 
  0, 0, 1159, 1159, 1159, 1159, 1159, 1159, 
  0, 0, 1159, 1159, 1159, 1159, 1159, 1159, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  0, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  0, 214, 214, 214, 214, 214, 214, 214, 
  214, 214, 214, 214, 214, 214, 214, 214, 
  214, 214, 214, 214, 214, 214, 214, 214, 
  214, 214, 214, 214, 214, 214, 214, 214, 
  214, 214, 214, 214, 3881, 214, 214, 214, 
  214, 214, 214, 214, 3838, 3882, 3883, 3884, 
  3885, 214, 214, 214, 214, 214, 214, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 3886, 3887, 3888, 3889, 3890, 3891, 3892, 
  3893, 3894, 3895, 3896, 3897, 3898, 3899, 3900, 
  3901, 3902, 3903, 3904, 3905, 3906, 3907, 3908, 
  3909, 3910, 3911, 3912, 3913, 3914, 3915, 3916, 
  3917, 3918, 3919, 3920, 3921, 3922, 3923, 3924, 
  3925, 3926, 3927, 3928, 3929, 3930, 3931, 3932, 
  3933, 3934, 3935, 3936, 3937, 3938, 3939, 3940, 
  3941, 3942, 3943, 3944, 3945, 3946, 3947, 3948, 
  3949, 3950, 3951, 3952, 3953, 3954, 3955, 3956, 
  3957, 3958, 3959, 3960, 3961, 3962, 3963, 3964, 
  3965, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1158, 1158, 1152, 1158, 
  1158, 1152, 1158, 1158, 1176, 1158, 1167, 0, 
  0, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 
  1177, 1177, 1177, 0, 0, 0, 0, 0, 
  0, 3966, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3966, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3966, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3966, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3966, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3966, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3966, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3966, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3966, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3966, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3966, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3966, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3966, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3966, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3966, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3966, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3966, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3966, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3966, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3966, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3966, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3966, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3966, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3966, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3966, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3966, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3966, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3966, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3966, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3966, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3966, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3966, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3966, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3966, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3966, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3966, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3966, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3966, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3966, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3966, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3966, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3966, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3966, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3966, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3966, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3966, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3966, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3966, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3966, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3966, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3966, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3966, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3966, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3966, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3966, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3966, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3966, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3966, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3966, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3966, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3966, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3966, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3966, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3966, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3966, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3966, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3966, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3966, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3966, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 3967, 3967, 3967, 
  3967, 3967, 3967, 3967, 3967, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1328, 1328, 1328, 1328, 1328, 1328, 1328, 
  1328, 1328, 1328, 1328, 1328, 1328, 1328, 1328, 
  1328, 1328, 1328, 1328, 1328, 1328, 1328, 1328, 
  0, 0, 0, 0, 1329, 1329, 1329, 1329, 
  1329, 1329, 1329, 1329, 1329, 1329, 1329, 1329, 
  1329, 1329, 1329, 1329, 1329, 1329, 1329, 1329, 
  1329, 1329, 1329, 1329, 1329, 1329, 1329, 1329, 
  1329, 1329, 1329, 1329, 1329, 1329, 1329, 1329, 
  1329, 1329, 1329, 1329, 1329, 1329, 1329, 1329, 
  1329, 1329, 1329, 1329, 1329, 0, 0, 0, 
  0, 3968, 3968, 3968, 3968, 3968, 3968, 3968, 
  3968, 3968, 3968, 3968, 3968, 3968, 3968, 3968, 
  3968, 3968, 3968, 3968, 3968, 3968, 3968, 3968, 
  3968, 3968, 3968, 3968, 3968, 3968, 3968, 3968, 
  3968, 3968, 3968, 3968, 3968, 3968, 3968, 3968, 
  3968, 3968, 3968, 3968, 3968, 3968, 3968, 3968, 
  3968, 3968, 3968, 3968, 3968, 3968, 3968, 3968, 
  3968, 3968, 3968, 3968, 3968, 3968, 3968, 3968, 
  3968, 3968, 3968, 3968, 3968, 3968, 3968, 3968, 
  3968, 3968, 3968, 3968, 3968, 3968, 3968, 3968, 
  3968, 3968, 3968, 3968, 3968, 3968, 3968, 3968, 
  3968, 3968, 3968, 3968, 3968, 3968, 3968, 3968, 
  3968, 3968, 3968, 3968, 3968, 3968, 3968, 3968, 
  3968, 3968, 3968, 3968, 3968, 3968, 3968, 3968, 
  3968, 3968, 3968, 3968, 3968, 3968, 3968, 3968, 
  3968, 3968, 3968, 3968, 3968, 3968, 3968, 3968, 
  3968, 3968, 3968, 3968, 3968, 3968, 3968, 3968, 
  3968, 3968, 3968, 3968, 3968, 3968, 3968, 3968, 
  3968, 3968, 3968, 3968, 3968, 3968, 3968, 3968, 
  3968, 3968, 3968, 3968, 3968, 3968, 3968, 3968, 
  3968, 3968, 3968, 3968, 3968, 3968, 3968, 3968, 
  3968, 3968, 3968, 3968, 3968, 3968, 3968, 3968, 
  3968, 3968, 3968, 3968, 3968, 3968, 3968, 3968, 
  3968, 3968, 3968, 3968, 3968, 3968, 3968, 3968, 
  3968, 3968, 3968, 3968, 3968, 3968, 3968, 3968, 
  3968, 3968, 3968, 3968, 3968, 3968, 3968, 3968, 
  3968, 3968, 3968, 3968, 3968, 3968, 3968, 3968, 
  3968, 3968, 3968, 3968, 3968, 3968, 3968, 3968, 
  3968, 3968, 3968, 3968, 3968, 3968, 3968, 3968, 
  3968, 3968, 3968, 3968, 3968, 3968, 3968, 3968, 
  3968, 3968, 3968, 3968, 3968, 3968, 3968, 3968, 
  3968, 3968, 3968, 3968, 3968, 3968, 3968, 3968, 
  3968, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3970, 3971, 3972, 3973, 3974, 3975, 3976, 
  3977, 3977, 3978, 3979, 3980, 3981, 3982, 3983, 
  3984, 3985, 3986, 3987, 3988, 3989, 3990, 3991, 
  3992, 3993, 3994, 3995, 3996, 3997, 3998, 3999, 
  4000, 4001, 4002, 4003, 4004, 4005, 4006, 4007, 
  4008, 4009, 4010, 4011, 4012, 4013, 4014, 4015, 
  4016, 4017, 4018, 4019, 4020, 4021, 4022, 4023, 
  4024, 4025, 4026, 4027, 4028, 4029, 4030, 4031, 
  4032, 4033, 4034, 4035, 4036, 4037, 4038, 4039, 
  4040, 4041, 4042, 4043, 4044, 4045, 4046, 4047, 
  4048, 4049, 4050, 4051, 4052, 4053, 4054, 4055, 
  4056, 4057, 4058, 4059, 4060, 3989, 4061, 4062, 
  4063, 4064, 4065, 4066, 4067, 4068, 4069, 4070, 
  4071, 4072, 4073, 4074, 4075, 4076, 4077, 4078, 
  4079, 4080, 4081, 4082, 4083, 4084, 4085, 4086, 
  4087, 4088, 4089, 4090, 4091, 4092, 4093, 4094, 
  4095, 4096, 4097, 4098, 4099, 4100, 4101, 4102, 
  4103, 4104, 4105, 4106, 4107, 4108, 4109, 4110, 
  4111, 4112, 4113, 4114, 4115, 4116, 4117, 4118, 
  4119, 4120, 4121, 4122, 4123, 4124, 4125, 4126, 
  4127, 4128, 4079, 4129, 4130, 4131, 4132, 4133, 
  4134, 4135, 4136, 4063, 4137, 4138, 4139, 4140, 
  4141, 4142, 4143, 4144, 4145, 4146, 4147, 4148, 
  4149, 4150, 4151, 4152, 4153, 4154, 4155, 4156, 
  3989, 4157, 4158, 4159, 4160, 4161, 4162, 4163, 
  4164, 4165, 4166, 4167, 4168, 4169, 4170, 4171, 
  4172, 4173, 4174, 4175, 4176, 4177, 4178, 4179, 
  4180, 4181, 4182, 4183, 4065, 4184, 4185, 4186, 
  4187, 4188, 4189, 4190, 4191, 4192, 4193, 4194, 
  4195, 4196, 4197, 4198, 4199, 4200, 4201, 4202, 
  4203, 4204, 4205, 4206, 4207, 4208, 4209, 4210, 
  4211, 4212, 4213, 4214, 4215, 4216, 4217, 4218, 
  4219, 4220, 4221, 4222, 4223, 4224, 4225, 4226, 
  4227, 4228, 4229, 4230, 4231, 4232, 4233, 1159, 
  1159, 4234, 1159, 4235, 1159, 1159, 4236, 4237, 
  4238, 4239, 4240, 4241, 4242, 4243, 4244, 4245, 
  1159, 4246, 1159, 4247, 1159, 1159, 4248, 4249, 
  1159, 1159, 1159, 4250, 4251, 4252, 4253, 4254, 
  4255, 4256, 4257, 4258, 4259, 4260, 4261, 4262, 
  4263, 4264, 4265, 4266, 4267, 4268, 4269, 4270, 
  4271, 4272, 4273, 4274, 4275, 4276, 4277, 4278, 
  4279, 4280, 4281, 4282, 4283, 4284, 4285, 4286, 
  4287, 4288, 4289, 4290, 4291, 4292, 4293, 4294, 
  4118, 4295, 4296, 4297, 4298, 4299, 4300, 4300, 
  4301, 4302, 4303, 4304, 4305, 4306, 4307, 4308, 
  4248, 4309, 4310, 4311, 4312, 4313, 4314, 0, 
  0, 4315, 4316, 4317, 4318, 4319, 4320, 4321, 
  4322, 4262, 4323, 4324, 4325, 4234, 4326, 4327, 
  4328, 4329, 4330, 4331, 4332, 4333, 4334, 4335, 
  4336, 4337, 4271, 4338, 4272, 4339, 4340, 4341, 
  4342, 4343, 4235, 4010, 4344, 4345, 4346, 4080, 
  4167, 4347, 4348, 4279, 4349, 4280, 4350, 4351, 
  4352, 4237, 4353, 4354, 4355, 4356, 4357, 4238, 
  4358, 4359, 4360, 4361, 4362, 4363, 4294, 4364, 
  4365, 4118, 4366, 4298, 4367, 4368, 4369, 4370, 
  4371, 4303, 4372, 4247, 4373, 4304, 4061, 4374, 
  4305, 4375, 4307, 4376, 4377, 4378, 4379, 4380, 
  4309, 4243, 4381, 4310, 4382, 4311, 4383, 3977, 
  4384, 4385, 4386, 4387, 4388, 4389, 4390, 4391, 
  4392, 4393, 4394, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 4395, 4396, 4397, 4398, 4399, 4400, 4401, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 4402, 4403, 4404, 4405, 
  4406, 0, 0, 0, 0, 0, 4407, 4408, 
  4409, 4410, 4411, 4412, 4413, 4414, 4415, 4416, 
  4417, 4418, 4419, 4420, 4421, 4422, 4423, 4424, 
  4425, 4426, 4427, 4428, 4429, 4430, 4431, 4432, 
  0, 4433, 4434, 4435, 4436, 4437, 0, 4438, 
  0, 4439, 4440, 0, 4441, 4442, 0, 4443, 
  4444, 4445, 4446, 4447, 4448, 4449, 4450, 4451, 
  4452, 4453, 4454, 4455, 4456, 4457, 4458, 4459, 
  4460, 4461, 4462, 4463, 4464, 4465, 4466, 4467, 
  4468, 4469, 4470, 4471, 4472, 4473, 4474, 4475, 
  4476, 4477, 4478, 4479, 4480, 4481, 4482, 4483, 
  4484, 4485, 4486, 4487, 4488, 4489, 4490, 4491, 
  4492, 4493, 4494, 4495, 4496, 4497, 4498, 4499, 
  4500, 4501, 4502, 4503, 4504, 4505, 4506, 4507, 
  4508, 4509, 4510, 4511, 4512, 4513, 4514, 4515, 
  4516, 4517, 4518, 4519, 4520, 4521, 4522, 4523, 
  4524, 4525, 4526, 4527, 4528, 4529, 4530, 4531, 
  4532, 4533, 4534, 4535, 4536, 4537, 4538, 4539, 
  4540, 4541, 4542, 4543, 4544, 4545, 4546, 4547, 
  4548, 4549, 4550, 4551, 4551, 4551, 4551, 4551, 
  4551, 4551, 4551, 4551, 4551, 4551, 4551, 4551, 
  4551, 4551, 4551, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 4552, 4553, 4554, 4555, 
  4556, 4557, 4558, 4559, 4560, 4561, 4562, 4563, 
  4564, 4565, 4566, 4567, 4568, 4569, 4570, 4571, 
  4572, 4573, 4574, 4575, 4576, 4577, 4578, 4579, 
  4580, 4581, 4582, 4583, 4584, 4585, 4586, 4587, 
  4588, 4589, 4590, 4591, 4592, 4593, 4594, 4595, 
  4596, 4597, 4598, 4599, 4590, 4600, 4601, 4602, 
  4603, 4604, 4605, 4606, 4607, 4608, 4609, 4610, 
  4611, 4612, 4613, 4614, 4615, 4616, 4617, 4618, 
  4619, 4620, 4621, 4622, 4623, 4624, 4625, 4626, 
  4627, 4628, 4629, 4630, 4631, 4632, 4633, 4634, 
  4635, 4636, 4637, 4638, 4639, 4640, 4641, 4642, 
  4643, 4644, 4645, 4646, 4647, 4648, 4649, 4650, 
  4651, 4652, 4653, 4654, 4655, 4656, 4657, 4658, 
  4659, 4660, 4661, 4662, 4663, 4664, 4665, 4666, 
  4667, 4668, 4669, 4670, 4671, 4672, 4673, 4674, 
  4675, 4676, 4677, 4678, 4679, 4680, 4681, 4682, 
  4683, 4684, 4685, 4686, 4687, 4688, 4689, 4690, 
  4691, 4692, 4693, 4694, 4695, 4696, 4697, 4698, 
  4699, 4591, 4700, 4701, 4702, 4703, 4704, 4705, 
  4706, 4707, 4708, 4709, 4710, 4711, 4712, 4713, 
  4714, 4715, 4716, 4717, 4718, 4719, 4720, 4721, 
  4722, 4723, 4724, 4725, 4726, 4727, 4728, 4729, 
  4730, 4731, 4732, 4733, 4734, 4735, 4736, 4737, 
  4738, 4739, 4740, 4741, 4742, 4743, 4744, 4745, 
  4746, 4747, 4748, 4749, 4750, 4751, 4752, 4753, 
  4754, 4755, 4756, 4757, 4758, 4759, 4760, 4761, 
  4762, 4763, 4764, 4765, 4766, 4767, 4768, 4769, 
  4770, 4771, 4772, 4773, 4774, 4775, 4776, 4777, 
  4778, 4779, 4780, 4781, 4782, 4783, 4784, 4785, 
  4786, 4787, 4788, 4789, 4790, 4791, 4792, 4793, 
  4794, 4795, 4796, 4797, 4798, 4799, 4800, 4801, 
  4802, 4803, 4804, 4805, 4806, 4807, 4808, 4809, 
  4810, 4811, 4812, 4813, 4814, 4815, 4816, 4817, 
  4818, 4819, 4820, 4821, 4822, 4823, 4824, 4825, 
  4826, 4827, 4828, 4829, 4830, 4831, 4832, 4833, 
  4834, 4835, 4836, 4837, 4838, 4839, 4840, 4841, 
  4842, 4843, 4844, 4845, 4846, 4847, 4848, 4849, 
  4850, 4851, 4852, 4853, 4854, 4855, 4856, 4857, 
  4858, 4859, 4860, 4861, 4862, 4863, 4864, 4865, 
  4866, 4867, 4868, 4869, 4870, 4871, 4872, 4873, 
  4874, 4875, 4876, 4877, 4878, 4879, 4880, 4881, 
  4882, 4883, 4884, 4885, 4886, 4887, 4888, 4889, 
  4890, 4891, 4892, 4893, 4894, 4895, 4896, 4897, 
  4898, 4899, 4900, 4901, 4902, 4903, 4904, 4905, 
  4906, 4907, 4908, 4909, 4910, 4911, 4912, 2942, 
  2941, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 4913, 4914, 4915, 4916, 4917, 4918, 4919, 
  4920, 4921, 4922, 4923, 4924, 4925, 4926, 4927, 
  4928, 4929, 4930, 4931, 4932, 4933, 4934, 4935, 
  4936, 4937, 4938, 4939, 4940, 4941, 4942, 4943, 
  4944, 4945, 4946, 4947, 4948, 4949, 4950, 4951, 
  4952, 4953, 4954, 4955, 4956, 4957, 4958, 4959, 
  4960, 4961, 4962, 4963, 4964, 4965, 4966, 4967, 
  4968, 4969, 4970, 4971, 4972, 4973, 4974, 4975, 
  4976, 0, 0, 4977, 4978, 4979, 4980, 4981, 
  4982, 4983, 4984, 4985, 4986, 4987, 4988, 4989, 
  4990, 4991, 4992, 4993, 4994, 4995, 4996, 4997, 
  4998, 4999, 5000, 5001, 5002, 5003, 5004, 5005, 
  5006, 5007, 5008, 5009, 5010, 5011, 5012, 5013, 
  5014, 5015, 5016, 5017, 5018, 5019, 5020, 5021, 
  5022, 5023, 5024, 5025, 5026, 5027, 5028, 5029, 
  5030, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 5031, 5032, 5033, 5034, 5035, 5036, 5037, 
  5038, 5039, 5040, 5041, 5042, 5043, 1084, 0, 
  0, 573, 573, 573, 573, 573, 573, 573, 
  573, 573, 573, 573, 573, 573, 573, 573, 
  573, 5044, 5045, 5046, 5047, 5048, 5049, 5050, 
  5051, 5052, 5053, 0, 0, 0, 0, 0, 
  0, 539, 539, 539, 539, 539, 539, 539, 
  552, 552, 552, 552, 552, 552, 552, 539, 
  539, 5054, 5055, 5056, 5057, 5057, 5058, 5059, 
  5060, 5061, 5062, 5063, 5064, 5065, 5066, 5067, 
  5068, 5069, 5070, 5071, 5072, 5073, 1425, 1425, 
  5074, 5075, 5076, 5076, 5076, 5076, 5077, 5077, 
  5077, 5078, 5079, 5080, 0, 5081, 5082, 5083, 
  5084, 5085, 5086, 5087, 5088, 5089, 5090, 5091, 
  5092, 5093, 5094, 5095, 5096, 5097, 5098, 5099, 
  0, 5100, 5101, 5102, 5103, 0, 0, 0, 
  0, 5104, 5105, 5106, 1117, 5107, 0, 5108, 
  5109, 5110, 5111, 5112, 5113, 5114, 5115, 5116, 
  5117, 5118, 5119, 5120, 5121, 5122, 5123, 5124, 
  5125, 5126, 5127, 5128, 5129, 5130, 5131, 5132, 
  5133, 5134, 5135, 5136, 5137, 5138, 5139, 5140, 
  5141, 5142, 5143, 5144, 5145, 5146, 5147, 5148, 
  5149, 5150, 5151, 5152, 5153, 5154, 5155, 5156, 
  5157, 5158, 5159, 5160, 5161, 5162, 5163, 5164, 
  5165, 5166, 5167, 5168, 5169, 5170, 5171, 5172, 
  5173, 5174, 5175, 5176, 5177, 5178, 5179, 5180, 
  5181, 5182, 5183, 5184, 5185, 5186, 5187, 5188, 
  5189, 5190, 5191, 5192, 5193, 5194, 5195, 5196, 
  5197, 5198, 5199, 5200, 5201, 5202, 5203, 5204, 
  5205, 5206, 5207, 5208, 5209, 5210, 5211, 5212, 
  5213, 5214, 5215, 5216, 5217, 5218, 5219, 5220, 
  5221, 5222, 5223, 5224, 5225, 5226, 5227, 5228, 
  5229, 5230, 5231, 5232, 5233, 5234, 5235, 5236, 
  5237, 5238, 5239, 5240, 5241, 5242, 0, 0, 
  81, 0, 5243, 5244, 5245, 5246, 5247, 5248, 
  5249, 5250, 5251, 5252, 5253, 5254, 5255, 5256, 
  5257, 5258, 5259, 5260, 5261, 5262, 5263, 5264, 
  5265, 5266, 5267, 5268, 5269, 5270, 5271, 5272, 
  5273, 5274, 5275, 5276, 5277, 5278, 5279, 5280, 
  5281, 5282, 5283, 5284, 5285, 5286, 5287, 5288, 
  5289, 5290, 5291, 5292, 5293, 5294, 5295, 5296, 
  5297, 5298, 5299, 5300, 5301, 5302, 5303, 5304, 
  5305, 5306, 5307, 5308, 5309, 5310, 5311, 5312, 
  5313, 5314, 5315, 5316, 5317, 5318, 5319, 5320, 
  5321, 5322, 5323, 5324, 5325, 5326, 5327, 5328, 
  5329, 5330, 5331, 5332, 5333, 5334, 5335, 5336, 
  5337, 5338, 5339, 5340, 5341, 5342, 5343, 5344, 
  5345, 5346, 5347, 5348, 5349, 5350, 5351, 5352, 
  5353, 5354, 5355, 5356, 5357, 5358, 5359, 5360, 
  5361, 5362, 5363, 5364, 5365, 5366, 5367, 5368, 
  5369, 5370, 5371, 5372, 5373, 5374, 5375, 5376, 
  5377, 5378, 5379, 5380, 5381, 5382, 5383, 5384, 
  5385, 5386, 5387, 5388, 5389, 5390, 5391, 5392, 
  5393, 5394, 5395, 5396, 5397, 5398, 5399, 5400, 
  5401, 5402, 5403, 5404, 5405, 5406, 5407, 5408, 
  5409, 5410, 5411, 5412, 5413, 5414, 5415, 5416, 
  5417, 5418, 5419, 5420, 5421, 5422, 5423, 5424, 
  5425, 5426, 5427, 5428, 5429, 5430, 5431, 5432, 
  0, 0, 0, 5433, 5434, 5435, 5436, 5437, 
  5438, 0, 0, 5439, 5440, 5441, 5442, 5443, 
  5444, 0, 0, 5445, 5446, 5447, 5448, 5449, 
  5450, 0, 0, 5451, 5452, 5453, 0, 0, 
  0, 5454, 5455, 5456, 5457, 5458, 5459, 5460, 
  0, 5461, 5462, 5463, 5464, 5465, 5466, 5467, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 5468, 5468, 5468, 1084, 77, 0, 
  0, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 0, 340, 1159, 
  1159, 340, 340, 340, 1159, 340, 340, 340, 
  340, 340, 340, 340, 340, 1159, 340, 340, 
  340, 340, 340, 1159, 1159, 1159, 340, 340, 
  0, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 1159, 
  340, 340, 340, 340, 0, 340, 340, 0, 
  340, 340, 1159, 340, 340, 1159, 1159, 1159, 
  340, 340, 340, 1159, 1159, 340, 1159, 0, 
  0, 340, 340, 1159, 340, 340, 1159, 340, 
  1159, 1159, 1159, 340, 1159, 1159, 1159, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 340, 340, 1159, 1159, 1159, 1159, 340, 
  340, 340, 340, 1159, 1159, 1159, 1159, 1159, 
  340, 1159, 340, 340, 340, 340, 1159, 1159, 
  1159, 1159, 1159, 340, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  340, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 340, 1159, 340, 1159, 
  1159, 1159, 1159, 1159, 340, 340, 1159, 1159, 
  1159, 1159, 1159, 1159, 340, 1159, 1159, 1159, 
  1159, 1159, 340, 340, 340, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  340, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 0, 0, 0, 0, 
  0, 1043, 9, 1043, 0, 0, 0, 0, 
  5469, 5469, 5469, 5469, 5469, 5469, 5469, 5469, 
  5469, 5469, 5469, 5469, 5469, 5469, 5469, 5469, 
  5469, 5469, 5469, 5469, 5469, 5469, 5469, 5469, 
  5469, 5469, 1189, 5469, 1189, 5469, 1189, 1189, 
  1189, 1189, 1189, 1189, 5469, 1189, 5469, 1189, 
  1189, 1189, 1189, 1189, 1189, 0, 0, 0, 
  1190, 837, 1190, 837, 837, 837, 837, 837, 
  1190, 5470, 5470, 5470, 5470, 5470, 5470, 5470, 
  5470, 5470, 5470, 5470, 5470, 5470, 5470, 5470, 
  5470, 5470, 5470, 5470, 5470, 5470, 5470, 5470, 
  5470, 5470, 5470, 5470, 5470, 5470, 5470, 5470, 
  5470, 5470, 5470, 5470, 5470, 5470, 5470, 5470, 
  5470, 5470, 5471, 5471, 5471, 5471, 5471, 5471, 
  5470, 5471, 5470, 5470, 5470, 5470, 1424, 1424, 
  1219, 1424, 77, 77, 77, 77, 77, 77, 
  77, 77, 77, 77, 77, 77, 77, 77, 
  77, 1084, 77, 1424, 1424, 77, 0, 0, 
  0, 77, 77, 77, 77, 77, 77, 77, 
  1084, 1084, 1084, 77, 77, 0, 0, 0, 
  0, 77, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1190, 1190, 1190, 1190, 1190, 1190, 1190, 
  1190, 1190, 1190, 1190, 1190, 1190, 1190, 1190, 
  1190, 1190, 1190, 1190, 1190, 1190, 1190, 1190, 
  1190, 1190, 1190, 1190, 1190, 1190, 1190, 1190, 
  1190, 1190, 1190, 1190, 1190, 1190, 1190, 1190, 
  1190, 1190, 1190, 1190, 1190, 1190, 552, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 1159, 
  1159, 340, 340, 340, 340, 340, 340, 340, 
  340, 1159, 340, 1159, 340, 340, 0, 0, 
  0, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 1159, 340, 340, 340, 340, 340, 340, 
  1159, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 552, 5472, 5472, 5472, 5472, 5472, 5472, 
  5472, 5472, 5472, 5472, 5472, 5472, 5472, 5472, 
  5472, 5472, 5472, 5472, 5472, 5472, 5472, 5472, 
  5472, 5472, 5472, 5472, 5472, 0, 0, 0, 
  0, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 5469, 5469, 5469, 5469, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 1423, 340, 340, 340, 340, 340, 
  340, 340, 340, 1423, 0, 0, 0, 0, 
  0, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 539, 
  539, 539, 539, 539, 0, 0, 0, 0, 
  0, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 0, 
  1176, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 0, 0, 0, 
  0, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1176, 2216, 2216, 2216, 2216, 2216, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 5473, 5474, 5475, 5476, 5477, 5478, 5479, 
  5480, 5481, 5482, 5483, 5484, 5485, 5486, 5487, 
  5488, 5489, 5490, 5491, 5492, 5493, 5494, 5495, 
  5496, 5497, 5498, 5499, 5500, 5501, 5502, 5503, 
  5504, 5505, 5506, 5507, 5508, 5509, 5510, 5511, 
  5512, 5513, 5514, 5515, 5516, 5517, 5518, 5519, 
  5520, 5521, 5522, 5523, 5524, 5525, 5526, 5527, 
  5528, 5529, 5530, 5531, 5532, 5533, 5534, 5535, 
  5536, 5537, 5538, 5539, 5540, 5541, 5542, 5543, 
  5544, 5545, 5546, 5547, 5548, 5549, 5550, 5551, 
  5552, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 1159, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 1159, 
  340, 1159, 340, 340, 1159, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 1159, 0, 
  0, 1248, 1248, 1248, 1248, 1248, 1248, 1248, 
  1248, 1248, 1248, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 0, 0, 0, 0, 0, 0, 0, 
  0, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  1043, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 1159, 340, 340, 340, 
  340, 1159, 340, 1159, 1159, 1159, 340, 340, 
  340, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 340, 340, 1159, 340, 340, 1159, 1159, 
  340, 340, 1159, 1159, 1159, 1159, 340, 1159, 
  340, 340, 340, 340, 340, 1159, 1159, 1159, 
  340, 1159, 340, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 340, 1159, 1159, 1159, 340, 
  1159, 1159, 340, 340, 1159, 1159, 1159, 1159, 
  1159, 1159, 340, 340, 1159, 1159, 1159, 340, 
  340, 340, 340, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 340, 1159, 1159, 1159, 1159, 
  340, 1159, 1159, 340, 340, 340, 1159, 1159, 
  1159, 1159, 340, 340, 340, 1159, 1159, 1159, 
  1159, 340, 1159, 1159, 1159, 1159, 1159, 1159, 
  340, 1159, 1159, 1159, 1159, 1159, 340, 340, 
  1159, 1159, 340, 1159, 1159, 340, 1159, 1159, 
  1159, 1159, 1159, 340, 1159, 1159, 1159, 340, 
  1159, 1159, 340, 1159, 1159, 340, 1159, 340, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 340, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  340, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 340, 340, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 340, 1159, 
  340, 340, 340, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 340, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  340, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 1159, 1159, 1159, 1159, 1159, 1159, 
  340, 340, 1159, 1159, 340, 1159, 340, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1155, 1155, 1155, 1105, 1155, 1105, 0, 
  0, 1155, 0, 1105, 1155, 1155, 1155, 1155, 
  1155, 1105, 1155, 1105, 1155, 1155, 1155, 1155, 
  1155, 1155, 1105, 1155, 1155, 1155, 1155, 1105, 
  1155, 1105, 1155, 1155, 1105, 1105, 1155, 1105, 
  1155, 1105, 1105, 1105, 1105, 1155, 1105, 1105, 
  1105, 1105, 1105, 1155, 1105, 1155, 1105, 0, 
  1155, 1105, 0, 0, 0, 1155, 0, 0, 
  1155, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 1105, 1105, 1105, 1105, 1105, 0, 
  1102, 5553, 5553, 5553, 5553, 5553, 5553, 5553, 
  5553, 1155, 1155, 1155, 1105, 1105, 1105, 1105, 
  1155, 1105, 1105, 1155, 1105, 1155, 1105, 1105, 
  1155, 1155, 1105, 1155, 1155, 1105, 1155, 1155, 
  5554, 5554, 5553, 5553, 5555, 5555, 5555, 5555, 
  5553, 1155, 1105, 1155, 1155, 1155, 1105, 1105, 
  1105, 1105, 1105, 1155, 1155, 1105, 1105, 1105, 
  1105, 1105, 1105, 1105, 1105, 1105, 1105, 1155, 
  1155, 1105, 1155, 1155, 1105, 1105, 1105, 1105, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  5553, 5553, 5553, 5553, 5553, 5553, 5553, 5553, 
  5553, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 1105, 1105, 0, 1105, 1105, 0, 
  0, 0, 0, 0, 5553, 5553, 5553, 5553, 
  5553, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 1105, 1105, 1105, 1105, 1105, 5553, 
  5553, 5553, 5553, 5553, 5553, 0, 0, 0, 
  9, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 1105, 0, 0, 0, 0, 0, 
  1102, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1155, 1105, 1155, 1155, 1155, 1155, 1155, 
  1105, 1155, 1155, 1155, 1155, 1155, 1155, 1155, 
  1155, 1155, 1155, 1155, 1155, 1155, 1155, 1155, 
  1105, 1155, 1155, 1155, 1155, 1155, 1155, 1105, 
  1155, 1155, 1105, 1155, 1105, 1155, 1105, 1105, 
  1105, 1105, 1155, 1105, 1155, 1105, 1155, 1105, 
  1105, 1105, 1155, 1105, 1155, 1105, 1155, 1155, 
  1105, 0, 0, 0, 0, 5555, 5553, 1105, 
  1155, 5553, 5553, 5553, 5553, 5555, 5555, 5555, 
  5553, 5553, 5555, 5555, 5555, 5555, 5555, 5555, 
  5555, 0, 0, 5555, 5555, 5555, 5555, 5555, 
  5555, 5555, 5555, 5555, 5555, 5555, 5555, 5555, 
  5555, 5555, 5555, 5555, 5555, 5555, 5555, 5555, 
  5555, 5555, 5555, 5555, 5555, 5555, 5555, 5555, 
  5555, 5555, 5555, 5555, 5555, 5555, 5555, 5553, 
  5553, 5553, 5553, 5555, 5553, 5555, 5555, 5555, 
  5555, 1155, 1152, 1152, 1152, 0, 1152, 1152, 
  0, 0, 0, 0, 0, 1152, 552, 1152, 
  539, 1155, 1155, 1155, 1155, 0, 1155, 1155, 
  1155, 0, 1155, 1155, 1155, 1155, 1155, 1155, 
  1155, 1155, 1155, 1155, 1155, 1155, 1155, 1155, 
  1155, 1155, 1155, 1155, 1155, 1155, 1155, 1155, 
  1155, 1155, 1155, 1155, 1155, 0, 0, 0, 
  0, 539, 565, 552, 0, 0, 0, 0, 
  1167, 5555, 5555, 5555, 5555, 5555, 5555, 5555, 
  5555, 0, 0, 0, 0, 0, 0, 0, 
  0, 1157, 1157, 1157, 1157, 1157, 1157, 1157, 
  1157, 1157, 0, 0, 0, 0, 0, 0, 
  0, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 1105, 1105, 1105, 1105, 5553, 5553, 
  1102, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 1105, 1105, 1105, 1105, 5553, 5553, 
  5553, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1105, 1155, 1155, 1105, 1105, 1105, 1155, 
  1105, 5556, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1155, 1155, 1155, 1105, 1155, 1155, 1155, 
  1105, 1155, 1155, 1155, 1155, 1155, 1155, 1155, 
  1155, 1155, 1105, 1155, 1155, 1105, 539, 552, 
  0, 0, 0, 0, 5553, 5555, 5555, 5555, 
  5555, 1157, 1157, 1157, 1157, 1102, 1102, 1102, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1105, 1155, 1155, 1155, 1155, 1105, 1105, 
  1105, 1155, 1155, 1155, 1155, 1105, 1105, 1105, 
  1105, 1105, 1155, 1155, 1155, 1155, 1105, 1155, 
  1105, 1105, 1105, 1105, 1155, 1105, 1105, 1105, 
  1105, 1155, 1155, 1105, 1105, 1105, 1105, 1105, 
  1155, 1105, 1105, 1155, 1155, 1105, 1105, 1105, 
  1105, 1105, 1155, 1155, 1155, 1155, 1155, 0, 
  0, 0, 9, 9, 9, 9, 9, 9, 
  9, 1155, 1155, 1105, 1105, 1155, 1105, 1105, 
  1105, 1155, 1105, 1155, 1105, 1155, 1155, 1105, 
  1105, 1155, 1155, 1105, 1105, 1105, 1105, 0, 
  0, 5553, 5553, 5553, 5553, 5553, 5553, 5555, 
  5553, 1105, 1105, 1105, 1105, 1155, 1105, 1105, 
  1155, 1105, 1105, 1105, 1105, 1155, 1105, 1155, 
  1105, 1105, 1155, 1105, 0, 0, 0, 0, 
  0, 5553, 5553, 5553, 5553, 5553, 5553, 5553, 
  5553, 1105, 1155, 1105, 1155, 1105, 1105, 1105, 
  1155, 1105, 1155, 1105, 1105, 1105, 1155, 1105, 
  1105, 1155, 1105, 0, 0, 0, 0, 0, 
  0, 0, 1157, 1157, 1157, 1157, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 5553, 5553, 5553, 5555, 5553, 5553, 
  5555, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 5557, 5558, 5559, 5560, 5561, 5562, 5563, 
  5564, 5565, 5566, 5567, 5568, 5569, 5570, 5571, 
  5572, 5573, 5574, 5575, 5576, 5577, 5578, 5579, 
  5580, 5581, 5582, 5583, 5584, 5585, 5586, 5587, 
  5588, 5589, 5590, 5591, 5592, 5593, 5594, 5595, 
  5596, 5597, 5598, 5599, 5600, 5601, 5602, 5603, 
  5604, 5605, 5606, 5607, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 5608, 5609, 5610, 5611, 5612, 5613, 5614, 
  5615, 5616, 5617, 5618, 5619, 5620, 5621, 5622, 
  5623, 5624, 5625, 5626, 5627, 5628, 5629, 5630, 
  5631, 5632, 5633, 5634, 5635, 5636, 5637, 5638, 
  5639, 5640, 5641, 5642, 5643, 5644, 5645, 5646, 
  5647, 5648, 5649, 5650, 5651, 5652, 5653, 5654, 
  5655, 5656, 5657, 5658, 0, 0, 0, 0, 
  0, 0, 0, 5553, 5553, 5553, 5553, 5553, 
  5553, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 5659, 5659, 5660, 5659, 5659, 5659, 5659, 
  5659, 5660, 5659, 5659, 5660, 5660, 5660, 5659, 
  5659, 5660, 5659, 5659, 5659, 5660, 5660, 5659, 
  5660, 5660, 5659, 5659, 5660, 5660, 5660, 5660, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1158, 1152, 1158, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 
  1152, 1152, 1152, 1152, 1152, 1152, 1152, 1167, 
  1176, 1176, 1176, 1176, 1176, 1176, 1176, 0, 
  0, 0, 0, 1219, 1219, 1219, 1219, 1219, 
  1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 
  1219, 1219, 1219, 1219, 1219, 1219, 1219, 1177, 
  1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 
  1177, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  1167, 1152, 1152, 1158, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 5661, 5662, 5663, 5664, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 5665, 1159, 
  1159, 1159, 1159, 1159, 5666, 1159, 1159, 1159, 
  1159, 1158, 1158, 1158, 1152, 1152, 1152, 1152, 
  1158, 1158, 1167, 5667, 1176, 1176, 5668, 1176, 
  1176, 1176, 1176, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 0, 0, 0, 0, 0, 0, 
  0, 1248, 1248, 1248, 1248, 1248, 1248, 1248, 
  1248, 1248, 1248, 0, 0, 0, 0, 0, 
  0, 539, 539, 539, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  5669, 1152, 1152, 1152, 1152, 1158, 1152, 5670, 
  5671, 1152, 5672, 5673, 1167, 1167, 0, 1177, 
  1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 
  1177, 1176, 1176, 1176, 1176, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1159, 340, 340, 340, 1159, 340, 340, 
  340, 340, 1159, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 1159, 340, 1159, 
  1159, 1159, 1159, 1159, 340, 1159, 340, 1159, 
  340, 340, 340, 340, 1179, 1043, 1043, 1159, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1152, 1152, 1158, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1158, 1158, 1158, 1152, 
  1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 
  1158, 1450, 1159, 1159, 1159, 1159, 1176, 1176, 
  1176, 1176, 1176, 1179, 1152, 1152, 1176, 0, 
  0, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 
  1177, 1177, 1177, 1159, 1176, 1159, 1176, 1176, 
  1176, 0, 1189, 1189, 1189, 1189, 1189, 1189, 
  1189, 1189, 1189, 1189, 1189, 1189, 1189, 1189, 
  1189, 1189, 1189, 1189, 1189, 1189, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 0, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1158, 1158, 1158, 
  1152, 1152, 1152, 1158, 1158, 1152, 1450, 1179, 
  1152, 1176, 1176, 1176, 1176, 1176, 1176, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 340, 340, 340, 340, 340, 340, 340, 
  0, 340, 0, 340, 340, 340, 340, 0, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 0, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 1043, 0, 0, 0, 0, 0, 
  0, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  1152, 1158, 1158, 1158, 1152, 1152, 1152, 1152, 
  1152, 1152, 1179, 1167, 0, 0, 0, 0, 
  0, 1248, 1248, 1248, 1248, 1248, 1248, 1248, 
  1248, 1248, 1248, 0, 0, 0, 0, 0, 
  0, 1152, 1152, 1158, 1158, 0, 340, 340, 
  340, 340, 340, 340, 340, 340, 0, 0, 
  340, 340, 0, 0, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 0, 340, 340, 340, 340, 340, 
  340, 340, 0, 340, 340, 0, 340, 340, 
  340, 340, 340, 0, 0, 1179, 340, 5674, 
  1158, 1152, 1158, 1158, 1158, 1158, 0, 0, 
  5675, 1158, 0, 0, 5676, 5677, 1450, 0, 
  0, 340, 0, 0, 0, 0, 0, 0, 
  5678, 0, 0, 0, 0, 0, 340, 340, 
  340, 340, 340, 1158, 1158, 0, 0, 539, 
  539, 539, 539, 539, 539, 539, 0, 0, 
  0, 539, 539, 539, 539, 539, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 5679, 1158, 1158, 1152, 1152, 1152, 1152, 
  1152, 1152, 5680, 5681, 5682, 5683, 5684, 5685, 
  1152, 1152, 1158, 1167, 1179, 340, 340, 1043, 
  340, 0, 0, 0, 0, 0, 0, 0, 
  0, 1248, 1248, 1248, 1248, 1248, 1248, 1248, 
  1248, 1248, 1248, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  5686, 1158, 1158, 1152, 1152, 1152, 1152, 0, 
  0, 5687, 5688, 5689, 5690, 1152, 1152, 1158, 
  1167, 1179, 1176, 1176, 1176, 1176, 1176, 1176, 
  1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 
  1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 
  1176, 1159, 1159, 1159, 1159, 1152, 1152, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 1158, 1158, 1158, 1152, 1152, 1152, 1152, 
  1152, 1152, 1152, 1152, 1158, 1158, 1152, 1158, 
  1167, 1152, 1043, 1043, 1043, 340, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1248, 1248, 1248, 1248, 1248, 1248, 1248, 
  1248, 1248, 1248, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1152, 1158, 1152, 1158, 
  1158, 1152, 1152, 1152, 1152, 1152, 1152, 1450, 
  1179, 0, 0, 0, 0, 0, 0, 0, 
  0, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 
  1177, 1177, 1177, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 0, 0, 0, 1152, 1152, 
  1152, 1158, 1158, 1152, 1152, 1152, 1152, 1158, 
  1152, 1152, 1152, 1152, 1167, 0, 0, 0, 
  0, 1248, 1248, 1248, 1248, 1248, 1248, 1248, 
  1248, 1248, 1248, 5469, 5469, 1043, 1043, 1043, 
  837, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 5691, 5692, 5693, 5694, 5695, 5696, 5697, 
  5698, 5699, 5700, 5701, 5702, 5703, 5704, 5705, 
  5706, 5707, 5708, 5709, 5710, 5711, 5712, 5713, 
  5714, 5715, 5716, 5717, 5718, 5719, 5720, 5721, 
  5722, 5723, 5724, 5725, 5726, 5727, 5728, 5729, 
  5730, 5731, 5732, 5733, 5734, 5735, 5736, 5737, 
  5738, 5739, 5740, 5741, 5742, 5743, 5744, 5745, 
  5746, 5747, 5748, 5749, 5750, 5751, 5752, 5753, 
  5754, 1248, 1248, 1248, 1248, 1248, 1248, 1248, 
  1248, 1248, 1248, 5469, 5469, 5469, 5469, 5469, 
  5469, 5469, 5469, 5469, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  340, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 0, 0, 0, 0, 0, 0, 
  0, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
  1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
  1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
  1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
  1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
  1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
  1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
  1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
  1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
  1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
  1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
  1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
  1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
  1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
  0, 1043, 1043, 1043, 1043, 1043, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 0, 0, 0, 0, 0, 0, 
  0, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  0, 1248, 1248, 1248, 1248, 1248, 1248, 1248, 
  1248, 1248, 1248, 0, 0, 0, 0, 1043, 
  1043, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 0, 
  0, 565, 565, 565, 565, 565, 1043, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 539, 539, 539, 539, 539, 539, 539, 
  1043, 1043, 1043, 1043, 1043, 837, 837, 837, 
  837, 522, 522, 522, 522, 1043, 837, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1248, 1248, 1248, 1248, 1248, 1248, 1248, 
  1248, 1248, 1248, 0, 5469, 5469, 5469, 5469, 
  5469, 5469, 5469, 0, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 0, 0, 0, 0, 0, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1159, 1158, 1158, 1158, 1158, 1158, 1158, 
  1158, 1158, 1158, 1158, 1158, 1158, 1158, 1158, 
  1158, 1158, 1158, 1158, 1158, 1158, 1158, 1158, 
  1158, 1158, 1158, 1158, 1158, 1158, 1158, 1158, 
  1158, 1158, 1158, 1158, 1158, 1158, 1158, 1158, 
  1158, 1158, 1158, 1158, 1158, 1158, 1158, 1158, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  1152, 1152, 1152, 1152, 1178, 1178, 1178, 1178, 
  1178, 1178, 1178, 1178, 1178, 1178, 1178, 1178, 
  1178, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1159, 1159, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 0, 0, 0, 0, 
  0, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 340, 340, 340, 0, 0, 
  0, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 0, 0, 0, 0, 0, 0, 
  0, 340, 340, 340, 340, 340, 340, 340, 
  340, 340, 340, 0, 0, 837, 1152, 565, 
  1043, 81, 81, 81, 81, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 837, 837, 837, 837, 837, 837, 837, 
  837, 1190, 1190, 837, 837, 837, 837, 837, 
  837, 837, 837, 837, 1190, 837, 1190, 837, 
  837, 837, 1190, 837, 837, 837, 1190, 1190, 
  1190, 837, 1190, 837, 1190, 837, 1190, 1190, 
  1190, 1190, 1190, 1190, 1190, 1190, 1190, 1190, 
  1190, 837, 1190, 1190, 1190, 1190, 1190, 1190, 
  1190, 1190, 837, 1190, 1190, 1190, 1190, 1190, 
  1190, 1190, 1190, 1190, 1190, 1190, 1190, 1190, 
  837, 837, 1190, 1190, 1190, 1190, 1190, 837, 
  837, 837, 837, 1190, 837, 1190, 1190, 1190, 
  837, 837, 837, 1190, 1190, 1190, 1190, 1190, 
  837, 1190, 1190, 1190, 837, 1190, 1190, 1190, 
  1190, 1190, 1190, 1190, 1190, 1190, 1190, 1190, 
  1190, 1190, 1190, 1190, 1190, 1190, 1190, 1190, 
  1190, 1190, 1190, 837, 1190, 1190, 1190, 837, 
  837, 837, 1190, 1190, 837, 837, 837, 837, 
  1190, 1190, 837, 837, 837, 1190, 1190, 837, 
  837, 837, 837, 1190, 1190, 1190, 1190, 1190, 
  837, 837, 837, 837, 837, 837, 1190, 837, 
  837, 1190, 1190, 1190, 837, 1190, 1190, 1190, 
  1190, 837, 837, 1190, 837, 1190, 837, 1190, 
  1190, 1190, 1190, 1190, 1190, 837, 837, 837, 
  1190, 1190, 837, 837, 837, 1190, 837, 1190, 
  837, 1190, 837, 837, 1190, 1190, 1190, 1190, 
  837, 1190, 1190, 1190, 837, 1190, 1190, 1190, 
  1190, 837, 1190, 1190, 1190, 837, 1190, 1190, 
  1190, 837, 837, 837, 837, 837, 837, 837, 
  837, 837, 837, 837, 837, 837, 837, 1190, 
  837, 1190, 837, 837, 837, 837, 837, 837, 
  837, 1190, 837, 1190, 837, 837, 837, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 837, 837, 837, 837, 837, 837, 837, 
  837, 837, 1190, 1190, 1190, 1190, 1190, 1190, 
  1190, 1190, 1190, 837, 1190, 837, 837, 1190, 
  1190, 1190, 1190, 1190, 1190, 1190, 1190, 837, 
  837, 837, 1190, 1190, 1190, 1190, 837, 837, 
  0, 0, 1190, 837, 1190, 837, 837, 837, 
  837, 837, 837, 837, 837, 837, 837, 1190, 
  1190, 1190, 1190, 837, 837, 837, 837, 837, 
  837, 837, 837, 837, 837, 837, 837, 837, 
  837, 837, 837, 837, 837, 837, 837, 837, 
  837, 837, 837, 837, 837, 837, 837, 837, 
  5755, 5756, 1190, 837, 837, 1190, 837, 5757, 
  5758, 5759, 5760, 5761, 5762, 5763, 5764, 5765, 
  565, 565, 565, 1190, 1190, 1190, 5766, 5767, 
  5768, 5769, 5770, 5771, 81, 81, 81, 81, 
  81, 81, 81, 81, 552, 552, 552, 552, 
  552, 552, 552, 552, 837, 837, 539, 539, 
  539, 539, 539, 552, 552, 837, 837, 837, 
  837, 837, 837, 1190, 1190, 837, 837, 1190, 
  1190, 1190, 1190, 837, 837, 1190, 1190, 837, 
  837, 837, 837, 837, 1190, 1190, 837, 1190, 
  1190, 837, 837, 539, 539, 539, 539, 1190, 
  1190, 1190, 1190, 1190, 1190, 837, 1190, 1190, 
  1190, 1190, 5772, 5773, 5774, 5775, 5776, 5777, 
  5778, 5779, 837, 837, 837, 837, 837, 837, 
  1190, 1190, 1190, 1190, 1190, 1190, 1190, 1190, 
  1190, 837, 837, 837, 837, 837, 837, 837, 
  1190, 1190, 1190, 1190, 1190, 1190, 1190, 1190, 
  1190, 1190, 1190, 1190, 1190, 1190, 1190, 1190, 
  1190, 1190, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 539, 539, 539, 1084, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1189, 1189, 1189, 1189, 1189, 1189, 1189, 
  1189, 1189, 5469, 1189, 1189, 1189, 1189, 1189, 
  1189, 1189, 1189, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 5780, 2146, 2121, 5781, 2148, 2149, 5782, 
  2128, 2131, 5783, 5784, 2132, 2151, 2134, 5785, 
  2136, 2137, 2138, 5786, 5787, 5788, 5789, 5790, 
  5791, 5792, 2142, 5793, 5794, 5795, 5796, 2147, 
  5797, 2127, 2129, 2157, 2166, 5798, 2133, 5799, 
  5800, 2152, 5801, 5802, 5803, 5804, 5805, 5806, 
  5807, 5808, 5809, 5810, 5811, 5812, 5813, 5814, 
  2164, 5815, 5816, 5817, 5818, 5819, 5820, 5821, 
  5822, 5823, 5824, 5825, 5826, 5827, 5828, 5829, 
  5830, 5831, 5832, 5833, 5834, 5835, 5836, 5837, 
  5838, 5839, 2165, 5840, 5841, 5842, 0, 5843, 
  5844, 5845, 5846, 5847, 5848, 5849, 5850, 5851, 
  5852, 5853, 5854, 5855, 5856, 5857, 5858, 5859, 
  5860, 5812, 5813, 5814, 2164, 5815, 5816, 5817, 
  5818, 5819, 5820, 5821, 5822, 5823, 5824, 5825, 
  5826, 5827, 5828, 5829, 5830, 5831, 5832, 5833, 
  5834, 5835, 5836, 5837, 5838, 5839, 2165, 5840, 
  5841, 5842, 5861, 5843, 5844, 5845, 5846, 5847, 
  5848, 5849, 5850, 5851, 5852, 5853, 5854, 5855, 
  5856, 5857, 5858, 5859, 5860, 5812, 0, 5814, 
  2164, 0, 0, 5817, 0, 0, 5820, 5821, 
  0, 0, 5824, 5825, 5826, 5827, 0, 5829, 
  5830, 5831, 5832, 5833, 5834, 5835, 5836, 5837, 
  5838, 5839, 2165, 0, 5841, 0, 5861, 5843, 
  5844, 5845, 5846, 5847, 5848, 0, 5850, 5851, 
  5852, 5853, 5854, 5855, 5856, 5857, 5858, 5859, 
  5860, 5812, 5813, 5814, 2164, 5815, 5816, 5817, 
  5818, 5819, 5820, 5821, 5822, 5823, 5824, 5825, 
  5826, 5827, 5828, 5829, 5830, 5831, 5832, 5833, 
  5834, 5835, 5836, 5837, 5838, 5839, 2165, 5840, 
  5841, 5842, 5861, 5843, 5844, 5845, 5846, 5847, 
  5848, 5849, 5850, 5851, 5852, 5853, 5854, 5855, 
  5856, 5857, 5858, 5859, 5860, 5780, 2146, 0, 
  5781, 2148, 2149, 5782, 0, 0, 5783, 5784, 
  2132, 2151, 2134, 5785, 2136, 2137, 0, 5786, 
  5787, 5788, 5789, 5790, 5791, 5792, 0, 5793, 
  5794, 5795, 5796, 2147, 5797, 2127, 2129, 2157, 
  2166, 5798, 2133, 5799, 5800, 2152, 5801, 5802, 
  5803, 5804, 5805, 5806, 5807, 5808, 5809, 5810, 
  5811, 5780, 2146, 0, 5781, 2148, 2149, 5782, 
  0, 2131, 5783, 5784, 2132, 2151, 0, 5785, 
  0, 0, 0, 5786, 5787, 5788, 5789, 5790, 
  5791, 5792, 0, 5793, 5794, 5795, 5796, 2147, 
  5797, 2127, 2129, 2157, 2166, 5798, 2133, 5799, 
  5800, 2152, 5801, 5802, 5803, 5804, 5805, 5806, 
  5807, 5808, 5809, 5810, 5811, 5780, 2146, 2121, 
  5781, 2148, 2149, 5782, 2128, 2131, 5783, 5784, 
  2132, 2151, 2134, 5785, 2136, 2137, 2138, 5786, 
  5787, 5788, 5789, 5790, 5791, 5792, 2142, 5793, 
  5794, 5795, 5796, 2147, 5797, 2127, 2129, 2157, 
  2166, 5798, 2133, 5799, 5800, 2152, 5801, 5802, 
  5803, 5804, 5805, 5806, 5807, 5808, 5809, 5810, 
  5811, 5780, 2146, 2121, 5781, 2148, 2149, 5782, 
  2128, 2131, 5783, 5784, 2132, 2151, 2134, 5785, 
  2136, 2137, 2138, 5786, 5787, 5788, 5789, 5790, 
  5791, 5792, 2142, 5793, 5794, 5795, 5796, 2147, 
  5797, 2127, 2129, 2157, 2166, 5798, 2133, 5799, 
  5800, 2152, 5801, 5802, 5803, 5804, 5805, 5806, 
  5807, 5808, 5809, 5810, 5811, 5780, 2146, 2121, 
  5781, 2148, 2149, 5782, 2128, 2131, 5783, 5784, 
  2132, 2151, 2134, 5785, 2136, 2137, 2138, 5786, 
  5787, 5788, 5789, 5790, 5791, 5792, 2142, 5793, 
  5794, 5795, 5796, 2147, 5797, 2127, 2129, 2157, 
  2166, 5798, 2133, 5799, 5800, 2152, 5801, 5802, 
  5803, 5804, 5805, 5806, 5807, 5808, 5809, 5810, 
  5811, 5812, 5813, 5814, 2164, 5815, 5816, 5817, 
  5818, 5819, 5820, 5821, 5822, 5823, 5824, 5825, 
  5826, 5827, 5828, 5829, 5830, 5831, 5832, 5833, 
  5834, 5835, 5836, 5837, 5838, 5839, 2165, 5840, 
  5841, 5842, 5861, 5843, 5844, 5845, 5846, 5847, 
  5848, 5849, 5850, 5851, 5852, 5853, 5854, 5855, 
  5856, 5857, 5858, 5859, 5860, 5812, 5813, 5814, 
  2164, 5815, 5816, 5817, 5818, 5819, 5820, 5821, 
  5822, 5823, 5824, 5825, 5826, 5827, 5828, 5829, 
  5830, 5831, 5832, 5833, 5834, 5835, 5836, 5837, 
  5838, 5839, 2165, 5840, 5841, 5842, 5861, 5843, 
  5844, 5845, 5846, 5847, 5848, 5849, 5850, 5851, 
  5852, 5853, 5854, 5855, 5856, 5857, 5858, 5859, 
  5860, 5812, 5813, 5814, 2164, 5815, 5816, 5817, 
  5818, 5819, 5820, 5821, 5822, 5823, 5824, 5825, 
  5826, 5827, 5828, 5829, 5830, 5831, 5832, 5833, 
  5834, 5835, 5836, 5837, 5838, 5839, 2165, 5840, 
  5841, 5842, 5861, 5843, 5844, 5845, 5846, 5847, 
  5848, 5849, 5850, 5851, 5852, 5853, 5854, 5855, 
  5856, 5857, 5858, 5859, 5860, 5862, 5863, 0, 
  0, 5864, 5865, 2161, 5866, 5867, 5868, 5869, 
  5870, 5871, 5872, 5873, 5874, 5875, 5876, 5877, 
  5878, 5879, 5880, 5881, 5882, 5883, 5884, 5885, 
  5886, 5887, 5888, 5889, 5890, 5891, 5892, 5893, 
  5894, 5895, 5896, 5897, 5898, 5899, 5900, 5901, 
  5902, 5903, 5904, 5905, 5906, 5907, 5908, 5909, 
  5910, 5911, 5912, 5913, 5914, 5915, 5916, 5917, 
  5918, 5919, 5920, 5921, 5922, 5923, 5924, 5925, 
  5926, 5927, 5928, 5929, 5930, 5931, 5932, 5933, 
  5934, 5935, 2162, 5936, 5937, 5938, 5939, 5940, 
  5941, 5942, 5943, 5944, 5945, 5946, 5947, 2160, 
  5948, 5949, 5950, 5951, 5952, 5953, 5954, 5955, 
  5956, 5957, 5958, 5959, 2159, 5960, 5961, 5962, 
  5963, 5964, 5965, 5966, 5967, 5968, 5969, 5970, 
  5916, 5971, 5972, 5973, 5974, 5921, 5922, 5923, 
  5924, 5925, 5926, 5927, 5928, 5929, 5930, 5931, 
  5932, 5933, 5934, 5935, 2162, 5936, 5937, 5938, 
  5939, 5940, 5941, 5942, 5943, 5944, 5945, 5946, 
  5947, 2160, 5948, 5949, 5950, 5951, 5952, 5953, 
  5954, 5955, 5956, 5957, 5958, 5959, 2159, 5960, 
  5961, 5962, 5963, 5964, 5965, 5966, 5967, 5968, 
  5969, 5970, 5975, 5971, 5972, 5973, 5974, 5864, 
  5865, 2161, 5866, 5867, 5868, 5869, 5870, 5871, 
  5872, 5873, 5874, 5875, 5876, 5877, 5878, 5879, 
  5880, 5881, 5882, 5883, 5884, 5885, 5886, 5887, 
  5888, 5889, 5890, 5891, 5892, 5893, 5894, 5895, 
  5896, 5897, 5898, 5899, 5900, 5901, 5902, 5903, 
  5904, 5905, 5906, 5907, 5908, 5909, 5910, 5911, 
  5912, 5913, 5914, 5915, 5916, 5917, 5918, 5919, 
  5920, 5921, 5922, 5923, 5924, 5925, 5926, 5927, 
  5928, 5929, 5930, 5931, 5932, 5933, 5934, 5935, 
  2162, 5936, 5937, 5938, 5939, 5940, 5941, 5942, 
  5943, 5944, 5945, 5946, 5947, 2160, 5948, 5949, 
  5950, 5951, 5952, 5953, 5954, 5955, 5956, 5957, 
  5958, 5959, 2159, 5960, 5961, 5962, 5963, 5964, 
  5965, 5966, 5967, 5968, 5969, 5970, 5975, 5971, 
  5972, 5973, 5974, 5976, 5977, 0, 0, 5978, 
  5979, 5980, 5981, 5982, 5983, 5984, 5985, 5986, 
  5987, 5978, 5979, 5980, 5981, 5982, 5983, 5984, 
  5985, 5986, 5987, 5978, 5979, 5980, 5981, 5982, 
  5983, 5984, 5985, 5986, 5987, 5978, 5979, 5980, 
  5981, 5982, 5983, 5984, 5985, 5986, 5987, 5988, 
  5989, 5990, 5991, 5992, 5993, 5994, 5995, 5996, 
  5997, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 
  1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 
  1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 
  1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 
  1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 
  1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 
  1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 
  837, 837, 837, 837, 1152, 1152, 1152, 1152, 
  1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 
  1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 
  1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 
  1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 
  1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 
  1152, 1152, 1152, 1152, 1152, 1152, 837, 837, 
  837, 837, 837, 837, 837, 837, 1152, 837, 
  837, 837, 837, 837, 837, 837, 837, 837, 
  837, 837, 837, 837, 837, 1152, 837, 837, 
  1043, 1043, 1043, 1043, 1043, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 1152, 1152, 1152, 1152, 
  1152, 0, 1152, 1152, 1152, 1152, 1152, 1152, 
  1152, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 
  1152, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
  1105, 1105, 1105, 1105, 1105, 1105, 0, 0, 
  5553, 5553, 5553, 5553, 5553, 5553, 5553, 5553, 
  5553, 552, 552, 552, 552, 552, 552, 552, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 5998, 5999, 6000, 6001, 0, 6002, 6003, 
  6004, 6005, 6006, 6007, 6008, 6009, 6010, 6011, 
  6012, 6013, 6014, 6015, 6016, 6017, 6018, 6019, 
  6020, 6021, 6022, 6023, 6024, 6025, 6026, 6027, 
  6028, 0, 5999, 6000, 0, 6029, 0, 0, 
  6004, 0, 6006, 6007, 6008, 6009, 6010, 6011, 
  6012, 6013, 6014, 6015, 0, 6017, 6018, 6019, 
  6020, 0, 6022, 0, 6024, 0, 0, 0, 
  0, 0, 0, 6000, 0, 0, 0, 0, 
  6004, 0, 6006, 0, 6008, 0, 6010, 6011, 
  6012, 0, 6014, 6015, 0, 6017, 0, 0, 
  6020, 0, 6022, 0, 6024, 0, 6026, 0, 
  6028, 0, 5999, 6000, 0, 6030, 0, 0, 
  6004, 6005, 6006, 6007, 0, 6009, 6010, 6011, 
  6012, 6013, 6014, 6015, 0, 6017, 6018, 6019, 
  6020, 0, 6022, 6023, 6024, 6025, 0, 6027, 
  0, 5998, 5999, 6000, 6001, 6030, 6002, 6003, 
  6004, 6005, 6006, 0, 6008, 6009, 6010, 6011, 
  6012, 6013, 6014, 6015, 6016, 6017, 6018, 6019, 
  6020, 6021, 6022, 6023, 6024, 0, 0, 0, 
  0, 0, 6031, 6032, 6033, 0, 6034, 6035, 
  6036, 6037, 6038, 0, 6039, 6040, 6041, 6042, 
  6043, 6044, 6045, 6046, 6047, 6048, 6049, 6050, 
  6051, 6052, 6053, 6054, 6055, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1108, 1108, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 0, 0, 0, 
  0, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 77, 77, 77, 77, 77, 
  77, 77, 77, 77, 77, 77, 77, 77, 
  77, 77, 77, 77, 77, 77, 77, 77, 
  77, 77, 77, 77, 77, 77, 77, 77, 
  77, 77, 77, 77, 77, 77, 77, 77, 
  77, 77, 77, 77, 77, 77, 77, 77, 
  77, 77, 77, 77, 77, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  0, 0, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 0, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 0, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 6056, 6057, 6058, 6059, 6060, 6061, 6062, 
  6063, 6064, 6065, 6066, 1219, 1219, 0, 0, 
  0, 6067, 6068, 6069, 6070, 6071, 6072, 6073, 
  6074, 6075, 6076, 6077, 6078, 6079, 6080, 6081, 
  6082, 6083, 6084, 6085, 6086, 6087, 6088, 6089, 
  6090, 6091, 6092, 6093, 6094, 6095, 6096, 6097, 
  0, 6098, 6099, 6100, 6101, 6102, 6103, 6104, 
  6105, 6106, 6107, 6108, 6109, 6110, 6111, 6112, 
  6113, 6114, 6115, 6116, 6117, 6118, 6119, 6120, 
  6121, 6122, 6123, 6124, 3599, 6125, 6126, 6127, 
  6128, 1190, 1190, 1190, 1190, 1190, 1190, 1190, 
  1190, 1190, 1190, 1190, 1190, 1190, 1190, 1190, 
  1190, 1190, 1190, 1190, 1190, 1190, 1190, 1190, 
  1190, 1190, 1190, 6129, 6130, 0, 0, 0, 
  0, 1190, 1190, 1190, 1190, 1190, 1190, 1190, 
  1190, 1190, 1190, 1190, 1190, 1190, 1190, 1190, 
  1190, 1190, 1190, 1190, 1190, 1190, 1190, 1190, 
  1190, 1190, 1190, 1190, 1190, 1190, 1190, 1190, 
  1190, 6131, 1190, 1190, 1190, 1190, 1190, 1190, 
  1190, 1190, 1190, 1190, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 6132, 
  6132, 6132, 6132, 6132, 6132, 6132, 6132, 6132, 
  6132, 6132, 6132, 6132, 6132, 6132, 6132, 6132, 
  6132, 6132, 6132, 6132, 6132, 6132, 6132, 6132, 
  6132, 6133, 6134, 6135, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 6136, 6137, 6138, 6139, 6140, 6141, 6142, 
  6143, 6144, 6145, 6146, 6147, 6148, 6149, 6150, 
  6151, 6152, 6153, 6154, 6155, 6156, 6157, 6158, 
  6159, 6160, 6161, 6162, 6163, 6164, 6165, 6166, 
  6167, 6168, 6169, 6170, 6171, 6172, 6173, 6174, 
  6175, 6176, 6177, 6178, 0, 0, 0, 0, 
  0, 6179, 6180, 6181, 6182, 6183, 6184, 6185, 
  6186, 6187, 0, 0, 0, 0, 0, 0, 
  0, 6188, 6189, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 77, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 6190, 6190, 6190, 6190, 
  6190, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 0, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 0, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  77, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 77, 
  77, 77, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 77, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 0, 0, 
  0, 1084, 1084, 1084, 1084, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 77, 77, 1084, 77, 77, 
  77, 1084, 1084, 1084, 1084, 77, 77, 77, 
  1084, 1084, 77, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 77, 1084, 77, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1084, 1084, 1084, 1084, 77, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 77, 77, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  77, 77, 77, 1084, 1084, 1084, 77, 77, 
  77, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 0, 0, 0, 
  0, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 77, 77, 77, 77, 77, 77, 77, 
  77, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 0, 0, 0, 0, 0, 0, 0, 
  0, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 0, 0, 0, 0, 0, 
  0, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 0, 0, 0, 0, 0, 0, 0, 
  0, 77, 77, 77, 77, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 77, 77, 77, 
  77, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
  1084, 1084, 1084, 1084, 1084, 77, 77, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 77, 77, 77, 77, 77, 77, 77, 
  77, 77, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 77, 77, 77, 77, 77, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 77, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 0, 
  0, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
  1159, 1159, 1159, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 6191, 6192, 6193, 6194, 6195, 4256, 6196, 
  6197, 6198, 6199, 4257, 6200, 6201, 6202, 4258, 
  6203, 6204, 6205, 6206, 6207, 6208, 6209, 6210, 
  6211, 6212, 6213, 6214, 4316, 6215, 6216, 6217, 
  6218, 6219, 6220, 6221, 6222, 6223, 4321, 4259, 
  4260, 4322, 6224, 6225, 4067, 6226, 4261, 6227, 
  6228, 6229, 6230, 6230, 6230, 6231, 6232, 6233, 
  6234, 6235, 6236, 6237, 6238, 6239, 6240, 6241, 
  6242, 6243, 6244, 6245, 6246, 6247, 6248, 6248, 
  4324, 6249, 6250, 6251, 6252, 4263, 6253, 6254, 
  6255, 4220, 6256, 6257, 6258, 6259, 6260, 6261, 
  6262, 6263, 6264, 6265, 6266, 6267, 6268, 6269, 
  6270, 6271, 6272, 6273, 6274, 6275, 6276, 6277, 
  6278, 6279, 6280, 6281, 6281, 6282, 6283, 6284, 
  4063, 6285, 6286, 6287, 6288, 6289, 6290, 6291, 
  6292, 4268, 6293, 6294, 6295, 6296, 6297, 6298, 
  6299, 6300, 6301, 6302, 6303, 6304, 6305, 6306, 
  6307, 6308, 6309, 6310, 6311, 6312, 6313, 4009, 
  6314, 6315, 6316, 6316, 6317, 6318, 6318, 6319, 
  6320, 6321, 6322, 6323, 6324, 6325, 6326, 6327, 
  6328, 6329, 6330, 6331, 4269, 6332, 6333, 6334, 
  6335, 4336, 6335, 6336, 4271, 6337, 6338, 6339, 
  6340, 4272, 3982, 6341, 6342, 6343, 6344, 6345, 
  6346, 6347, 6348, 6349, 6350, 6351, 6352, 6353, 
  6354, 6355, 6356, 6357, 6358, 6359, 6360, 6361, 
  6362, 4273, 6363, 6364, 6365, 6366, 6367, 6368, 
  4275, 6369, 6370, 6371, 6372, 6373, 6374, 6375, 
  6376, 4010, 4344, 6377, 6378, 6379, 6380, 6381, 
  6382, 6383, 6384, 4276, 6385, 6386, 6387, 6388, 
  4387, 6389, 6390, 6391, 6392, 6393, 6394, 6395, 
  6396, 6397, 6398, 6399, 6400, 6401, 4080, 6402, 
  6403, 6404, 6405, 6406, 6407, 6408, 6409, 6410, 
  6411, 6412, 4277, 4167, 6413, 6414, 6415, 6416, 
  6417, 6418, 6419, 6420, 4348, 6421, 6422, 6423, 
  6424, 6425, 6426, 6427, 6428, 4349, 6429, 6430, 
  6431, 6432, 6433, 6434, 6435, 6436, 6437, 6438, 
  6439, 6440, 4351, 6441, 6442, 6443, 6444, 6445, 
  6446, 6447, 6448, 6449, 6450, 6451, 6451, 6452, 
  6453, 4353, 6454, 6455, 6456, 6457, 6458, 6459, 
  6460, 4066, 6461, 6462, 6463, 6464, 6465, 6466, 
  6467, 4359, 6468, 6469, 6470, 6471, 6472, 6473, 
  6473, 4360, 4389, 6474, 6475, 6476, 6477, 6478, 
  4028, 4362, 6479, 6480, 4288, 6481, 6482, 4242, 
  6483, 6484, 4292, 6485, 6486, 6487, 6488, 6488, 
  6489, 6490, 6491, 6492, 6493, 6494, 6495, 6496, 
  6497, 6498, 6499, 6500, 6501, 6502, 6503, 6504, 
  6505, 6506, 6507, 6508, 6509, 6510, 6511, 6512, 
  6513, 6514, 6515, 4298, 6516, 6517, 6518, 6519, 
  6520, 6521, 6522, 6523, 6524, 6525, 6526, 6527, 
  6528, 6529, 6530, 6531, 6317, 6532, 6533, 6534, 
  6535, 6536, 6537, 6538, 6539, 6540, 6541, 6542, 
  6543, 4084, 6544, 6545, 6546, 6547, 6548, 6549, 
  4301, 6550, 6551, 6552, 6553, 6554, 6555, 6556, 
  6557, 6558, 6559, 6560, 6561, 6562, 6563, 6564, 
  6565, 6566, 6567, 6568, 6569, 4023, 6570, 6571, 
  6572, 6573, 6574, 6575, 4369, 6576, 6577, 6578, 
  6579, 6580, 6581, 6582, 6583, 6584, 6585, 6586, 
  6587, 6588, 6589, 6590, 6591, 6592, 6593, 6594, 
  6595, 4374, 4375, 6596, 6597, 6598, 6599, 6600, 
  6601, 6602, 6603, 6604, 6605, 6606, 6607, 6608, 
  4376, 6609, 6610, 6611, 6612, 6613, 6614, 6615, 
  6616, 6617, 6618, 6619, 6620, 6621, 6622, 6623, 
  6624, 6625, 6626, 6627, 6628, 6629, 6630, 6631, 
  6632, 6633, 6634, 6635, 6636, 6637, 6638, 4382, 
  4382, 6639, 6640, 6641, 6642, 6643, 6644, 6645, 
  6646, 6647, 6648, 4383, 6649, 6650, 6651, 6652, 
  6653, 6654, 6655, 6656, 6657, 6658, 6659, 6660, 
  6661, 6662, 6663, 6664, 6665, 6666, 6667, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 81, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 81, 81, 81, 81, 81, 81, 81, 
  81, 81, 81, 81, 81, 81, 81, 81, 
  81, 81, 81, 81, 81, 81, 81, 81, 
  81, 81, 81, 81, 81, 81, 81, 81, 
  81, 81, 81, 81, 81, 81, 81, 81, 
  81, 81, 81, 81, 81, 81, 81, 81, 
  81, 81, 81, 81, 81, 81, 81, 81, 
  81, 81, 81, 81, 81, 81, 81, 81, 
  81, 81, 81, 81, 81, 81, 81, 81, 
  81, 81, 81, 81, 81, 81, 81, 81, 
  81, 81, 81, 81, 81, 81, 81, 81, 
  81, 81, 81, 81, 81, 81, 81, 81, 
  81, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 573, 573, 573, 573, 573, 573, 573, 
  573, 573, 573, 573, 573, 573, 573, 573, 
  573, 573, 573, 573, 573, 573, 573, 573, 
  573, 573, 573, 573, 573, 573, 573, 573, 
  573, 573, 573, 573, 573, 573, 573, 573, 
  573, 573, 573, 573, 573, 573, 573, 573, 
  573, 573, 573, 573, 573, 573, 573, 573, 
  573, 573, 573, 573, 573, 573, 573, 573, 
  573, 573, 573, 573, 573, 573, 573, 573, 
  573, 573, 573, 573, 573, 573, 573, 573, 
  573, 573, 573, 573, 573, 573, 573, 573, 
  573, 573, 573, 573, 573, 573, 573, 573, 
  573, 573, 573, 573, 573, 573, 573, 573, 
  573, 573, 573, 573, 573, 573, 573, 573, 
  573, 573, 573, 573, 573, 573, 573, 573, 
  573, 573, 573, 573, 573, 573, 573, 573, 
  573, 573, 573, 573, 573, 573, 573, 573, 
  573, 573, 573, 573, 573, 573, 573, 573, 
  573, 573, 573, 573, 573, 573, 573, 573, 
  573, 573, 573, 573, 573, 573, 573, 573, 
  573, 573, 573, 573, 573, 573, 573, 573, 
  573, 573, 573, 573, 573, 573, 573, 573, 
  573, 573, 573, 573, 573, 573, 573, 573, 
  573, 573, 573, 573, 573, 573, 573, 573, 
  573, 573, 573, 573, 573, 573, 573, 573, 
  573, 573, 573, 573, 573, 573, 573, 573, 
  573, 573, 573, 573, 573, 573, 573, 573, 
  573, 573, 573, 573, 573, 573, 573, 573, 
  573, 573, 573, 573, 573, 573, 573, 573, 
  573, 573, 573, 573, 573, 573, 573, 573, 
  573, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 3969, 
  3969, 3969, 3969, 3969, 3969, 3969, 3969, 0, 
  0, };

const utf8proc_property_t utf8proc_properties[] = {
  {0, 0, 0, 0, NULL, NULL, -1, -1, -1, -1, -1, false,false,false,false, UTF8PROC_BOUNDCLASS_OTHER, 0},
  {UTF8PROC_CATEGORY_CC, 0, UTF8PROC_BIDI_CLASS_BN, 0, NULL, NULL, -1, -1, -1, -1, -1, false, true, false, true, UTF8PROC_BOUNDCLASS_CONTROL, 0},
  {UTF8PROC_CATEGORY_CC, 0, UTF8PROC_BIDI_CLASS_BN, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, true, UTF8PROC_BOUNDCLASS_CONTROL, 0},
  {UTF8PROC_CATEGORY_CC, 0, UTF8PROC_BIDI_CLASS_S, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, true, UTF8PROC_BOUNDCLASS_CONTROL, 0},
  {UTF8PROC_CATEGORY_CC, 0, UTF8PROC_BIDI_CLASS_B, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, true, UTF8PROC_BOUNDCLASS_LF, 0},
  {UTF8PROC_CATEGORY_CC, 0, UTF8PROC_BIDI_CLASS_WS, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, true, UTF8PROC_BOUNDCLASS_CONTROL, 0},
  {UTF8PROC_CATEGORY_CC, 0, UTF8PROC_BIDI_CLASS_B, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, true, UTF8PROC_BOUNDCLASS_CR, 0},
  {UTF8PROC_CATEGORY_CC, 0, UTF8PROC_BIDI_CLASS_B, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, true, UTF8PROC_BOUNDCLASS_CONTROL, 0},
  {UTF8PROC_CATEGORY_ZS, 0, UTF8PROC_BIDI_CLASS_WS, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ET, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SC, 0, UTF8PROC_BIDI_CLASS_ET, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_PS, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_PE, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ES, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_CS, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_PD, 0, UTF8PROC_BIDI_CLASS_ES, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_ND, 0, UTF8PROC_BIDI_CLASS_EN, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, 19924, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, 19720, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, 19992, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 0, -1, 97, -1, 0, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2, -1, 98, -1, 9792, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 4, -1, 99, -1, 68, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 6, -1, 100, -1, 1088, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8, -1, 101, -1, 136, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 10, -1, 102, -1, 10336, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 12, -1, 103, -1, 1224, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 14, -1, 104, -1, 1360, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 16, -1, 105, -1, 204, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 18, -1, 106, -1, 1496, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 20, -1, 107, -1, 1632, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 22, -1, 108, -1, 1768, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 24, -1, 109, -1, 10744, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 26, -1, 110, -1, 272, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 28, -1, 111, -1, 340, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 30, -1, 112, -1, 11016, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 32, -1, 113, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 34, -1, 114, -1, 1904, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 36, -1, 115, -1, 2040, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 38, -1, 116, -1, 2176, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 40, -1, 117, -1, 408, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 42, -1, 118, -1, 11968, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 44, -1, 119, -1, 2312, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 46, -1, 120, -1, 12104, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 48, -1, 121, -1, 476, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 50, -1, 122, -1, 2448, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_PC, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 65, -1, 65, 544, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 66, -1, 66, 9860, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 67, -1, 67, 612, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 68, -1, 68, 1156, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 69, -1, 69, 680, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 70, -1, 70, 10404, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 71, -1, 71, 1292, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 72, -1, 72, 1428, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 73, -1, 73, 748, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 74, -1, 74, 1564, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 75, -1, 75, 1700, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 76, -1, 76, 1836, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 77, -1, 77, 10812, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 78, -1, 78, 816, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 79, -1, 79, 884, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 80, -1, 80, 11084, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 81, -1, 81, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 82, -1, 82, 1972, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 83, -1, 83, 2108, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 84, -1, 84, 2244, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 85, -1, 85, 952, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 86, -1, 86, 12036, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 87, -1, 87, 2380, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 88, -1, 88, 12172, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 89, -1, 89, 1020, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 90, -1, 90, 2516, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_ZS, 0, UTF8PROC_BIDI_CLASS_CS, UTF8PROC_DECOMP_TYPE_NOBREAK, utf8proc_sequences + 52, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 54, NULL, -1, -1, -1, 4080, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 0, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_PI, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_CF, 0, UTF8PROC_BIDI_CLASS_BN, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, true, true, UTF8PROC_BOUNDCLASS_CONTROL, 0},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 57, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ET, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ET, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 60, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 62, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 64, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 67, utf8proc_sequences + 67, 924, -1, 924, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 69, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 72, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 28, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_PF, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_FRACTION, utf8proc_sequences + 74, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_FRACTION, utf8proc_sequences + 78, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_FRACTION, utf8proc_sequences + 82, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 86, utf8proc_sequences + 89, -1, 224, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 91, utf8proc_sequences + 94, -1, 225, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 96, utf8proc_sequences + 99, -1, 226, -1, 12308, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 101, utf8proc_sequences + 104, -1, 227, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 106, utf8proc_sequences + 109, -1, 228, -1, 2720, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 111, utf8proc_sequences + 114, -1, 229, -1, 3400, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 116, -1, 230, -1, 2992, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 118, utf8proc_sequences + 121, -1, 231, -1, 9928, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 123, utf8proc_sequences + 126, -1, 232, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 128, utf8proc_sequences + 131, -1, 233, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 133, utf8proc_sequences + 136, -1, 234, -1, 12716, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 138, utf8proc_sequences + 141, -1, 235, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 143, utf8proc_sequences + 146, -1, 236, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 148, utf8proc_sequences + 151, -1, 237, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 153, utf8proc_sequences + 156, -1, 238, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 158, utf8proc_sequences + 161, -1, 239, -1, 10472, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 163, -1, 240, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 165, utf8proc_sequences + 168, -1, 241, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 170, utf8proc_sequences + 173, -1, 242, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 175, utf8proc_sequences + 178, -1, 243, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 180, utf8proc_sequences + 183, -1, 244, -1, 12988, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 185, utf8proc_sequences + 188, -1, 245, -1, 3808, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 190, utf8proc_sequences + 193, -1, 246, -1, 3672, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 195, -1, 248, -1, 3536, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 197, utf8proc_sequences + 200, -1, 249, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 202, utf8proc_sequences + 205, -1, 250, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 207, utf8proc_sequences + 210, -1, 251, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 212, utf8proc_sequences + 215, -1, 252, -1, 2584, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 217, utf8proc_sequences + 220, -1, 253, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 222, -1, 254, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 224, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 227, NULL, 192, -1, 192, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 230, NULL, 193, -1, 193, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 233, NULL, 194, -1, 194, 12376, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 236, NULL, 195, -1, 195, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 239, NULL, 196, -1, 196, 2788, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 242, NULL, 197, -1, 197, 3468, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 198, -1, 198, 3060, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 245, NULL, 199, -1, 199, 9996, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 248, NULL, 200, -1, 200, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 251, NULL, 201, -1, 201, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 254, NULL, 202, -1, 202, 12784, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 257, NULL, 203, -1, 203, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 260, NULL, 204, -1, 204, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 263, NULL, 205, -1, 205, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 266, NULL, 206, -1, 206, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 269, NULL, 207, -1, 207, 10540, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 208, -1, 208, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 272, NULL, 209, -1, 209, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 275, NULL, 210, -1, 210, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 278, NULL, 211, -1, 211, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 281, NULL, 212, -1, 212, 13056, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 284, NULL, 213, -1, 213, 3876, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 287, NULL, 214, -1, 214, 3740, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 216, -1, 216, 3604, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 290, NULL, 217, -1, 217, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 293, NULL, 218, -1, 218, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 296, NULL, 219, -1, 219, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 299, NULL, 220, -1, 220, 2652, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 302, NULL, 221, -1, 221, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 222, -1, 222, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 305, NULL, 376, -1, 376, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 308, utf8proc_sequences + 311, -1, 257, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 313, NULL, 256, -1, 256, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 316, utf8proc_sequences + 319, -1, 259, -1, 12580, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 321, NULL, 258, -1, 258, 12648, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 324, utf8proc_sequences + 327, -1, 261, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 329, NULL, 260, -1, 260, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 332, utf8proc_sequences + 335, -1, 263, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 337, NULL, 262, -1, 262, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 340, utf8proc_sequences + 343, -1, 265, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 345, NULL, 264, -1, 264, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 348, utf8proc_sequences + 351, -1, 267, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 353, NULL, 266, -1, 266, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 356, utf8proc_sequences + 359, -1, 269, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 361, NULL, 268, -1, 268, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 364, utf8proc_sequences + 367, -1, 271, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 369, NULL, 270, -1, 270, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 372, -1, 273, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 272, -1, 272, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 374, utf8proc_sequences + 377, -1, 275, -1, 10064, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 379, NULL, 274, -1, 274, 10132, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 382, utf8proc_sequences + 385, -1, 277, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 387, NULL, 276, -1, 276, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 390, utf8proc_sequences + 393, -1, 279, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 395, NULL, 278, -1, 278, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 398, utf8proc_sequences + 401, -1, 281, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 403, NULL, 280, -1, 280, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 406, utf8proc_sequences + 409, -1, 283, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 411, NULL, 282, -1, 282, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 414, utf8proc_sequences + 417, -1, 285, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 419, NULL, 284, -1, 284, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 422, utf8proc_sequences + 425, -1, 287, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 427, NULL, 286, -1, 286, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 430, utf8proc_sequences + 433, -1, 289, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 435, NULL, 288, -1, 288, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 438, utf8proc_sequences + 441, -1, 291, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 443, NULL, 290, -1, 290, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 446, utf8proc_sequences + 449, -1, 293, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 451, NULL, 292, -1, 292, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 454, -1, 295, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 294, -1, 294, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 456, utf8proc_sequences + 459, -1, 297, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 461, NULL, 296, -1, 296, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 464, utf8proc_sequences + 467, -1, 299, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 469, NULL, 298, -1, 298, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 472, utf8proc_sequences + 475, -1, 301, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 477, NULL, 300, -1, 300, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 480, utf8proc_sequences + 483, -1, 303, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 485, NULL, 302, -1, 302, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 488, utf8proc_sequences + 491, -1, 105, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 73, -1, 73, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 494, utf8proc_sequences + 497, -1, 307, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 499, NULL, 306, -1, 306, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 502, utf8proc_sequences + 505, -1, 309, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 507, NULL, 308, -1, 308, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 510, utf8proc_sequences + 513, -1, 311, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 515, NULL, 310, -1, 310, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 518, utf8proc_sequences + 521, -1, 314, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 523, NULL, 313, -1, 313, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 526, utf8proc_sequences + 529, -1, 316, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 531, NULL, 315, -1, 315, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 534, utf8proc_sequences + 537, -1, 318, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 539, NULL, 317, -1, 317, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 542, utf8proc_sequences + 545, -1, 320, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 547, NULL, 319, -1, 319, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 550, -1, 322, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 321, -1, 321, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 552, utf8proc_sequences + 555, -1, 324, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 557, NULL, 323, -1, 323, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 560, utf8proc_sequences + 563, -1, 326, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 565, NULL, 325, -1, 325, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 568, utf8proc_sequences + 571, -1, 328, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 573, NULL, 327, -1, 327, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 576, utf8proc_sequences + 576, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 579, -1, 331, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 330, -1, 330, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 581, utf8proc_sequences + 584, -1, 333, -1, 10880, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 586, NULL, 332, -1, 332, 10948, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 589, utf8proc_sequences + 592, -1, 335, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 594, NULL, 334, -1, 334, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 597, utf8proc_sequences + 600, -1, 337, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 602, NULL, 336, -1, 336, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 605, -1, 339, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 338, -1, 338, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 607, utf8proc_sequences + 610, -1, 341, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 612, NULL, 340, -1, 340, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 615, utf8proc_sequences + 618, -1, 343, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 620, NULL, 342, -1, 342, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 623, utf8proc_sequences + 626, -1, 345, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 628, NULL, 344, -1, 344, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 631, utf8proc_sequences + 634, -1, 347, -1, 11288, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 636, NULL, 346, -1, 346, 11356, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 639, utf8proc_sequences + 642, -1, 349, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 644, NULL, 348, -1, 348, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 647, utf8proc_sequences + 650, -1, 351, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 652, NULL, 350, -1, 350, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 655, utf8proc_sequences + 658, -1, 353, -1, 11424, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 660, NULL, 352, -1, 352, 11492, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 663, utf8proc_sequences + 666, -1, 355, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 668, NULL, 354, -1, 354, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 671, utf8proc_sequences + 674, -1, 357, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 676, NULL, 356, -1, 356, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 679, -1, 359, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 358, -1, 358, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 681, utf8proc_sequences + 684, -1, 361, -1, 11696, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 686, NULL, 360, -1, 360, 11764, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 689, utf8proc_sequences + 692, -1, 363, -1, 11832, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 694, NULL, 362, -1, 362, 11900, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 697, utf8proc_sequences + 700, -1, 365, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 702, NULL, 364, -1, 364, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 705, utf8proc_sequences + 708, -1, 367, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 710, NULL, 366, -1, 366, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 713, utf8proc_sequences + 716, -1, 369, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 718, NULL, 368, -1, 368, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 721, utf8proc_sequences + 724, -1, 371, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 726, NULL, 370, -1, 370, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 729, utf8proc_sequences + 732, -1, 373, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 734, NULL, 372, -1, 372, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 737, utf8proc_sequences + 740, -1, 375, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 742, NULL, 374, -1, 374, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 745, utf8proc_sequences + 748, -1, 255, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 750, utf8proc_sequences + 753, -1, 378, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 755, NULL, 377, -1, 377, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 758, utf8proc_sequences + 761, -1, 380, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 763, NULL, 379, -1, 379, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 766, utf8proc_sequences + 769, -1, 382, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 771, NULL, 381, -1, 381, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 36, utf8proc_sequences + 36, 83, -1, 83, 12240, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 579, -1, 579, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 774, -1, 595, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 776, -1, 387, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 386, -1, 386, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 778, -1, 389, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 388, -1, 388, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 780, -1, 596, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 782, -1, 392, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 391, -1, 391, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 784, -1, 598, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 786, -1, 599, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 788, -1, 396, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 395, -1, 395, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 790, -1, 477, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 792, -1, 601, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 794, -1, 603, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 796, -1, 402, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 401, -1, 401, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 798, -1, 608, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 800, -1, 611, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 502, -1, 502, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 802, -1, 617, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 804, -1, 616, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 806, -1, 409, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 408, -1, 408, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 573, -1, 573, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 808, -1, 623, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 810, -1, 626, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 544, -1, 544, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 812, -1, 629, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 814, utf8proc_sequences + 817, -1, 417, -1, 13260, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 819, NULL, 416, -1, 416, 13328, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 822, -1, 419, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 418, -1, 418, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 824, -1, 421, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 420, -1, 420, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 826, -1, 640, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 828, -1, 424, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 423, -1, 423, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 830, -1, 643, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 832, -1, 429, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 428, -1, 428, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 834, -1, 648, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 836, utf8proc_sequences + 839, -1, 432, -1, 13396, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 841, NULL, 431, -1, 431, 13464, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 844, -1, 650, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 846, -1, 651, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 848, -1, 436, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 435, -1, 435, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 850, -1, 438, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 437, -1, 437, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 852, -1, 658, -1, 3264, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 854, -1, 441, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 440, -1, 440, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 856, -1, 445, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 444, -1, 444, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 503, -1, 503, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 858, utf8proc_sequences + 861, -1, 454, 453, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 863, utf8proc_sequences + 861, 452, 454, 453, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 866, NULL, 452, -1, 453, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 869, utf8proc_sequences + 872, -1, 457, 456, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 874, utf8proc_sequences + 872, 455, 457, 456, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 877, NULL, 455, -1, 456, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 880, utf8proc_sequences + 883, -1, 460, 459, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 885, utf8proc_sequences + 883, 458, 460, 459, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 888, NULL, 458, -1, 459, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 891, utf8proc_sequences + 894, -1, 462, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 896, NULL, 461, -1, 461, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 899, utf8proc_sequences + 902, -1, 464, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 904, NULL, 463, -1, 463, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 907, utf8proc_sequences + 910, -1, 466, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 912, NULL, 465, -1, 465, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 915, utf8proc_sequences + 918, -1, 468, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 920, NULL, 467, -1, 467, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 923, utf8proc_sequences + 926, -1, 470, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 928, NULL, 469, -1, 469, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 931, utf8proc_sequences + 934, -1, 472, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 936, NULL, 471, -1, 471, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 939, utf8proc_sequences + 942, -1, 474, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 944, NULL, 473, -1, 473, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 947, utf8proc_sequences + 950, -1, 476, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 952, NULL, 475, -1, 475, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 398, -1, 398, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 955, utf8proc_sequences + 958, -1, 479, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 960, NULL, 478, -1, 478, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 963, utf8proc_sequences + 966, -1, 481, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 968, NULL, 480, -1, 480, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 971, utf8proc_sequences + 974, -1, 483, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 976, NULL, 482, -1, 482, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 979, -1, 485, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 484, -1, 484, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 981, utf8proc_sequences + 984, -1, 487, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 986, NULL, 486, -1, 486, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 989, utf8proc_sequences + 992, -1, 489, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 994, NULL, 488, -1, 488, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 997, utf8proc_sequences + 1000, -1, 491, -1, 3128, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1002, NULL, 490, -1, 490, 3196, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1005, utf8proc_sequences + 1008, -1, 493, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1010, NULL, 492, -1, 492, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1013, utf8proc_sequences + 1016, -1, 495, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1018, NULL, 494, -1, 494, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1021, utf8proc_sequences + 1021, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 1024, utf8proc_sequences + 1027, -1, 499, 498, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 1029, utf8proc_sequences + 1027, 497, 499, 498, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 1032, NULL, 497, -1, 498, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1035, utf8proc_sequences + 1038, -1, 501, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1040, NULL, 500, -1, 500, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1043, -1, 405, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1045, -1, 447, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1047, utf8proc_sequences + 1050, -1, 505, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1052, NULL, 504, -1, 504, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1055, utf8proc_sequences + 1058, -1, 507, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1060, NULL, 506, -1, 506, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1063, utf8proc_sequences + 1066, -1, 509, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1068, NULL, 508, -1, 508, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1071, utf8proc_sequences + 1074, -1, 511, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1076, NULL, 510, -1, 510, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1079, utf8proc_sequences + 1082, -1, 513, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1084, NULL, 512, -1, 512, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1087, utf8proc_sequences + 1090, -1, 515, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1092, NULL, 514, -1, 514, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1095, utf8proc_sequences + 1098, -1, 517, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1100, NULL, 516, -1, 516, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1103, utf8proc_sequences + 1106, -1, 519, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1108, NULL, 518, -1, 518, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1111, utf8proc_sequences + 1114, -1, 521, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1116, NULL, 520, -1, 520, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1119, utf8proc_sequences + 1122, -1, 523, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1124, NULL, 522, -1, 522, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1127, utf8proc_sequences + 1130, -1, 525, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1132, NULL, 524, -1, 524, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1135, utf8proc_sequences + 1138, -1, 527, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1140, NULL, 526, -1, 526, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1143, utf8proc_sequences + 1146, -1, 529, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1148, NULL, 528, -1, 528, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1151, utf8proc_sequences + 1154, -1, 531, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1156, NULL, 530, -1, 530, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1159, utf8proc_sequences + 1162, -1, 533, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1164, NULL, 532, -1, 532, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1167, utf8proc_sequences + 1170, -1, 535, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1172, NULL, 534, -1, 534, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1175, utf8proc_sequences + 1178, -1, 537, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1180, NULL, 536, -1, 536, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1183, utf8proc_sequences + 1186, -1, 539, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1188, NULL, 538, -1, 538, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1191, -1, 541, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 540, -1, 540, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1193, utf8proc_sequences + 1196, -1, 543, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1198, NULL, 542, -1, 542, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1201, -1, 414, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1203, -1, 547, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 546, -1, 546, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1205, -1, 549, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 548, -1, 548, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1207, utf8proc_sequences + 1210, -1, 551, -1, 2856, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1212, NULL, 550, -1, 550, 2924, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1215, utf8proc_sequences + 1218, -1, 553, -1, 10200, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1220, NULL, 552, -1, 552, 10268, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1223, utf8proc_sequences + 1226, -1, 555, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1228, NULL, 554, -1, 554, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1231, utf8proc_sequences + 1234, -1, 557, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1236, NULL, 556, -1, 556, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1239, utf8proc_sequences + 1242, -1, 559, -1, 3944, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1244, NULL, 558, -1, 558, 4012, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1247, utf8proc_sequences + 1250, -1, 561, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1252, NULL, 560, -1, 560, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1255, utf8proc_sequences + 1258, -1, 563, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1260, NULL, 562, -1, 562, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1263, -1, 11365, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1265, -1, 572, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 571, -1, 571, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1267, -1, 410, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1269, -1, 11366, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11390, -1, 11390, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11391, -1, 11391, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1271, -1, 578, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 577, -1, 577, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1273, -1, 384, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1275, -1, 649, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1277, -1, 652, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1279, -1, 583, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 582, -1, 582, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1281, -1, 585, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 584, -1, 584, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1283, -1, 587, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 586, -1, 586, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1285, -1, 589, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 588, -1, 588, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1287, -1, 591, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 590, -1, 590, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11375, -1, 11375, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11373, -1, 11373, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11376, -1, 11376, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 385, -1, 385, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 390, -1, 390, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 393, -1, 393, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 394, -1, 394, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 399, -1, 399, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 400, -1, 400, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42923, -1, 42923, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 403, -1, 403, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42924, -1, 42924, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 404, -1, 404, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42893, -1, 42893, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42922, -1, 42922, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 407, -1, 407, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 406, -1, 406, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11362, -1, 11362, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42925, -1, 42925, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 412, -1, 412, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11374, -1, 11374, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 413, -1, 413, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 415, -1, 415, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11364, -1, 11364, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 422, -1, 422, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 425, -1, 425, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42929, -1, 42929, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 430, -1, 430, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 580, -1, 580, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 433, -1, 433, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 434, -1, 434, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 581, -1, 581, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 439, -1, 439, 3332, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42930, -1, 42930, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42928, -1, 42928, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 14, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 1289, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 18, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 34, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 1291, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 1293, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 1295, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 44, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 48, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 1297, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 1300, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 1303, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 1306, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 1309, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 1312, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 800, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 22, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 36, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 46, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 1315, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_MN, 230, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, 0, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 230, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, 1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 230, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, 2, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 230, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, 3, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 230, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, 7, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 230, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 230, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, 8, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 230, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, 10, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 230, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, 4, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 230, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, 46, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 230, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, 5, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 230, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, 12, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 230, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, 11, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 230, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, 14, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 230, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, 15, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 230, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, 47, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 230, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, 48, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 232, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 220, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 216, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, 13, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 202, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 220, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, 40, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 220, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, 45, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 220, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, 39, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 220, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, 16, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 202, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, 6, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 202, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, 9, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 220, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, 42, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 220, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, 44, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 220, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, 43, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 220, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, 41, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 1, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 1, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, 51, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 230, UTF8PROC_BIDI_CLASS_NSM, 0, utf8proc_sequences + 1317, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 230, UTF8PROC_BIDI_CLASS_NSM, 0, utf8proc_sequences + 1319, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 230, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, 49, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 230, UTF8PROC_BIDI_CLASS_NSM, 0, utf8proc_sequences + 1321, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 230, UTF8PROC_BIDI_CLASS_NSM, 0, utf8proc_sequences + 1323, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 240, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, utf8proc_sequences + 1326, 921, -1, 921, -1, 50, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 0, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, true, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 233, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 234, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1328, -1, 881, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 880, -1, 880, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1330, -1, 883, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 882, -1, 882, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 1332, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1334, -1, 887, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 886, -1, 886, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 1336, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1021, -1, 1021, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1022, -1, 1022, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1023, -1, 1023, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 1339, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1341, -1, 1011, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 1343, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1346, utf8proc_sequences + 1349, -1, 940, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 1351, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1353, utf8proc_sequences + 1356, -1, 941, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1358, utf8proc_sequences + 1361, -1, 942, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1363, utf8proc_sequences + 1366, -1, 943, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1368, utf8proc_sequences + 1371, -1, 972, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1373, utf8proc_sequences + 1376, -1, 973, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1378, utf8proc_sequences + 1381, -1, 974, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1383, utf8proc_sequences + 1386, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1390, -1, 945, -1, 4148, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1392, -1, 946, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1394, -1, 947, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1396, -1, 948, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1398, -1, 949, -1, 4216, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1400, -1, 950, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1402, -1, 951, -1, 4284, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1404, -1, 952, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1326, -1, 953, -1, 4352, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1406, -1, 954, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1408, -1, 955, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 67, -1, 956, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1410, -1, 957, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1412, -1, 958, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1414, -1, 959, -1, 4420, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1416, -1, 960, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1418, -1, 961, -1, 18428, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1420, -1, 963, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1422, -1, 964, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1424, -1, 965, -1, 4488, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1426, -1, 966, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1428, -1, 967, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1430, -1, 968, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1432, -1, 969, -1, 4556, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1434, utf8proc_sequences + 1437, -1, 970, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1439, utf8proc_sequences + 1442, -1, 971, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1444, NULL, 902, -1, 902, 17884, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1447, NULL, 904, -1, 904, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1450, NULL, 905, -1, 905, 18088, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1453, NULL, 906, -1, 906, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1456, utf8proc_sequences + 1459, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 913, -1, 913, 4692, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 914, -1, 914, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 915, -1, 915, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 916, -1, 916, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 917, -1, 917, 4760, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 918, -1, 918, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 919, -1, 919, 4828, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 920, -1, 920, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 921, -1, 921, 4896, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 922, -1, 922, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 923, -1, 923, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 924, -1, 924, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 925, -1, 925, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 926, -1, 926, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 927, -1, 927, 5100, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 928, -1, 928, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 929, -1, 929, 18360, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1420, 931, -1, 931, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 931, -1, 931, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 932, -1, 932, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 933, -1, 933, 5032, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 934, -1, 934, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 935, -1, 935, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 936, -1, 936, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 937, -1, 937, 5168, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1463, NULL, 938, -1, 938, 4624, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1466, NULL, 939, -1, 939, 4964, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1469, NULL, 908, -1, 908, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1472, NULL, 910, -1, 910, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1475, NULL, 911, -1, 911, 18564, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1478, -1, 983, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 1392, utf8proc_sequences + 1392, 914, -1, 914, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 1404, utf8proc_sequences + 1404, 920, -1, 920, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 1480, NULL, -1, -1, -1, 5236, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1482, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1485, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 1426, utf8proc_sequences + 1426, 934, -1, 934, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 1416, utf8proc_sequences + 1416, 928, -1, 928, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 975, -1, 975, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1488, -1, 985, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 984, -1, 984, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1490, -1, 987, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 986, -1, 986, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1492, -1, 989, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 988, -1, 988, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1494, -1, 991, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 990, -1, 990, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1496, -1, 993, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 992, -1, 992, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1498, -1, 995, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 994, -1, 994, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1500, -1, 997, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 996, -1, 996, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1502, -1, 999, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 998, -1, 998, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1504, -1, 1001, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1000, -1, 1000, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1506, -1, 1003, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1002, -1, 1002, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1508, -1, 1005, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1004, -1, 1004, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1510, -1, 1007, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1006, -1, 1006, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 1406, utf8proc_sequences + 1406, 922, -1, 922, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 1418, utf8proc_sequences + 1418, 929, -1, 929, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 1512, NULL, 1017, -1, 1017, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 895, -1, 895, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 1514, utf8proc_sequences + 1404, -1, 952, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 1398, utf8proc_sequences + 1398, 917, -1, 917, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1516, -1, 1016, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1015, -1, 1015, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 1518, utf8proc_sequences + 1520, -1, 1010, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1522, -1, 1019, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1018, -1, 1018, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1524, -1, 891, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1526, -1, 892, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1528, -1, 893, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1530, utf8proc_sequences + 1533, -1, 1104, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1535, utf8proc_sequences + 1538, -1, 1105, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1540, -1, 1106, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1542, utf8proc_sequences + 1545, -1, 1107, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1547, -1, 1108, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1549, -1, 1109, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1551, -1, 1110, -1, 5440, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1553, utf8proc_sequences + 1556, -1, 1111, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1558, -1, 1112, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1560, -1, 1113, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1562, -1, 1114, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1564, -1, 1115, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1566, utf8proc_sequences + 1569, -1, 1116, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1571, utf8proc_sequences + 1574, -1, 1117, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1576, utf8proc_sequences + 1579, -1, 1118, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1581, -1, 1119, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1583, -1, 1072, -1, 6392, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1585, -1, 1073, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1587, -1, 1074, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1589, -1, 1075, -1, 5372, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1591, -1, 1076, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1593, -1, 1077, -1, 5304, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1595, -1, 1078, -1, 6256, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1597, -1, 1079, -1, 6664, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1599, -1, 1080, -1, 5576, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1601, utf8proc_sequences + 1604, -1, 1081, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1606, -1, 1082, -1, 5508, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1608, -1, 1083, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1610, -1, 1084, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1612, -1, 1085, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1614, -1, 1086, -1, 6800, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1616, -1, 1087, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1618, -1, 1088, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1620, -1, 1089, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1622, -1, 1090, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1624, -1, 1091, -1, 5644, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1626, -1, 1092, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1628, -1, 1093, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1630, -1, 1094, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1632, -1, 1095, -1, 7208, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1634, -1, 1096, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1636, -1, 1097, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1638, -1, 1098, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1640, -1, 1099, -1, 7344, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1642, -1, 1100, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1644, -1, 1101, -1, 7072, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1646, -1, 1102, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1648, -1, 1103, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1040, -1, 1040, 6460, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1041, -1, 1041, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1042, -1, 1042, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1043, -1, 1043, 5848, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1044, -1, 1044, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1045, -1, 1045, 5780, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1046, -1, 1046, 6324, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1047, -1, 1047, 6732, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1048, -1, 1048, 5712, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1650, NULL, 1049, -1, 1049, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1050, -1, 1050, 5984, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1051, -1, 1051, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1052, -1, 1052, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1053, -1, 1053, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1054, -1, 1054, 6868, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1055, -1, 1055, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1056, -1, 1056, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1057, -1, 1057, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1058, -1, 1058, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1059, -1, 1059, 6052, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1060, -1, 1060, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1061, -1, 1061, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1062, -1, 1062, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1063, -1, 1063, 7276, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1064, -1, 1064, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1065, -1, 1065, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1066, -1, 1066, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1067, -1, 1067, 7412, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1068, -1, 1068, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1069, -1, 1069, 7140, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1070, -1, 1070, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1071, -1, 1071, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1653, NULL, 1024, -1, 1024, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1656, NULL, 1025, -1, 1025, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1026, -1, 1026, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1659, NULL, 1027, -1, 1027, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1028, -1, 1028, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1029, -1, 1029, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1030, -1, 1030, 5916, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1662, NULL, 1031, -1, 1031, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1032, -1, 1032, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1033, -1, 1033, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1034, -1, 1034, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1035, -1, 1035, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1665, NULL, 1036, -1, 1036, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1668, NULL, 1037, -1, 1037, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1671, NULL, 1038, -1, 1038, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1039, -1, 1039, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1674, -1, 1121, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1120, -1, 1120, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1676, -1, 1123, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1122, -1, 1122, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1678, -1, 1125, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1124, -1, 1124, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1680, -1, 1127, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1126, -1, 1126, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1682, -1, 1129, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1128, -1, 1128, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1684, -1, 1131, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1130, -1, 1130, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1686, -1, 1133, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1132, -1, 1132, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1688, -1, 1135, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1134, -1, 1134, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1690, -1, 1137, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1136, -1, 1136, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1692, -1, 1139, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1138, -1, 1138, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1694, -1, 1141, -1, 6120, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1140, -1, 1140, 6188, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1696, utf8proc_sequences + 1699, -1, 1143, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1701, NULL, 1142, -1, 1142, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1704, -1, 1145, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1144, -1, 1144, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1706, -1, 1147, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1146, -1, 1146, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1708, -1, 1149, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1148, -1, 1148, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1710, -1, 1151, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1150, -1, 1150, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1712, -1, 1153, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1152, -1, 1152, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_ME, 0, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1714, -1, 1163, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1162, -1, 1162, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1716, -1, 1165, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1164, -1, 1164, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1718, -1, 1167, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1166, -1, 1166, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1720, -1, 1169, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1168, -1, 1168, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1722, -1, 1171, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1170, -1, 1170, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1724, -1, 1173, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1172, -1, 1172, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1726, -1, 1175, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1174, -1, 1174, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1728, -1, 1177, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1176, -1, 1176, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1730, -1, 1179, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1178, -1, 1178, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1732, -1, 1181, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1180, -1, 1180, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1734, -1, 1183, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1182, -1, 1182, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1736, -1, 1185, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1184, -1, 1184, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1738, -1, 1187, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1186, -1, 1186, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1740, -1, 1189, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1188, -1, 1188, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1742, -1, 1191, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1190, -1, 1190, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1744, -1, 1193, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1192, -1, 1192, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1746, -1, 1195, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1194, -1, 1194, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1748, -1, 1197, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1196, -1, 1196, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1750, -1, 1199, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1198, -1, 1198, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1752, -1, 1201, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1200, -1, 1200, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1754, -1, 1203, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1202, -1, 1202, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1756, -1, 1205, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1204, -1, 1204, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1758, -1, 1207, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1206, -1, 1206, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1760, -1, 1209, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1208, -1, 1208, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1762, -1, 1211, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1210, -1, 1210, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1764, -1, 1213, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1212, -1, 1212, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1766, -1, 1215, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1214, -1, 1214, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1768, -1, 1231, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1770, utf8proc_sequences + 1773, -1, 1218, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1775, NULL, 1217, -1, 1217, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1778, -1, 1220, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1219, -1, 1219, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1780, -1, 1222, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1221, -1, 1221, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1782, -1, 1224, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1223, -1, 1223, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1784, -1, 1226, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1225, -1, 1225, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1786, -1, 1228, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1227, -1, 1227, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1788, -1, 1230, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1229, -1, 1229, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1216, -1, 1216, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1790, utf8proc_sequences + 1793, -1, 1233, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1795, NULL, 1232, -1, 1232, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1798, utf8proc_sequences + 1801, -1, 1235, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1803, NULL, 1234, -1, 1234, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1806, -1, 1237, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1236, -1, 1236, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1808, utf8proc_sequences + 1811, -1, 1239, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1813, NULL, 1238, -1, 1238, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1816, -1, 1241, -1, 6528, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1240, -1, 1240, 6596, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1818, utf8proc_sequences + 1821, -1, 1243, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1823, NULL, 1242, -1, 1242, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1826, utf8proc_sequences + 1829, -1, 1245, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1831, NULL, 1244, -1, 1244, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1834, utf8proc_sequences + 1837, -1, 1247, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1839, NULL, 1246, -1, 1246, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1842, -1, 1249, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1248, -1, 1248, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1844, utf8proc_sequences + 1847, -1, 1251, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1849, NULL, 1250, -1, 1250, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1852, utf8proc_sequences + 1855, -1, 1253, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1857, NULL, 1252, -1, 1252, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1860, utf8proc_sequences + 1863, -1, 1255, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1865, NULL, 1254, -1, 1254, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1868, -1, 1257, -1, 6936, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1256, -1, 1256, 7004, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1870, utf8proc_sequences + 1873, -1, 1259, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1875, NULL, 1258, -1, 1258, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1878, utf8proc_sequences + 1881, -1, 1261, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1883, NULL, 1260, -1, 1260, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1886, utf8proc_sequences + 1889, -1, 1263, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1891, NULL, 1262, -1, 1262, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1894, utf8proc_sequences + 1897, -1, 1265, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1899, NULL, 1264, -1, 1264, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1902, utf8proc_sequences + 1905, -1, 1267, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1907, NULL, 1266, -1, 1266, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1910, utf8proc_sequences + 1913, -1, 1269, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1915, NULL, 1268, -1, 1268, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1918, -1, 1271, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1270, -1, 1270, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1920, utf8proc_sequences + 1923, -1, 1273, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1925, NULL, 1272, -1, 1272, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1928, -1, 1275, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1274, -1, 1274, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1930, -1, 1277, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1276, -1, 1276, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1932, -1, 1279, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1278, -1, 1278, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1934, -1, 1281, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1280, -1, 1280, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1936, -1, 1283, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1282, -1, 1282, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1938, -1, 1285, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1284, -1, 1284, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1940, -1, 1287, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1286, -1, 1286, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1942, -1, 1289, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1288, -1, 1288, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1944, -1, 1291, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1290, -1, 1290, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1946, -1, 1293, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1292, -1, 1292, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1948, -1, 1295, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1294, -1, 1294, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1950, -1, 1297, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1296, -1, 1296, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1952, -1, 1299, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1298, -1, 1298, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1954, -1, 1301, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1300, -1, 1300, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1956, -1, 1303, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1302, -1, 1302, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1958, -1, 1305, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1304, -1, 1304, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1960, -1, 1307, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1306, -1, 1306, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1962, -1, 1309, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1308, -1, 1308, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1964, -1, 1311, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1310, -1, 1310, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1966, -1, 1313, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1312, -1, 1312, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1968, -1, 1315, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1314, -1, 1314, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1970, -1, 1317, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1316, -1, 1316, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1972, -1, 1319, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1318, -1, 1318, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1974, -1, 1321, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1320, -1, 1320, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1976, -1, 1323, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1322, -1, 1322, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1978, -1, 1325, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1324, -1, 1324, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1980, -1, 1327, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1326, -1, 1326, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1982, -1, 1377, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1984, -1, 1378, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1986, -1, 1379, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1988, -1, 1380, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1990, -1, 1381, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1992, -1, 1382, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1994, -1, 1383, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1996, -1, 1384, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1998, -1, 1385, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2000, -1, 1386, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2002, -1, 1387, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2004, -1, 1388, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2006, -1, 1389, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2008, -1, 1390, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2010, -1, 1391, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2012, -1, 1392, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2014, -1, 1393, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2016, -1, 1394, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2018, -1, 1395, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2020, -1, 1396, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2022, -1, 1397, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2024, -1, 1398, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2026, -1, 1399, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2028, -1, 1400, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2030, -1, 1401, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2032, -1, 1402, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2034, -1, 1403, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2036, -1, 1404, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2038, -1, 1405, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2040, -1, 1406, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2042, -1, 1407, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2044, -1, 1408, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2046, -1, 1409, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2048, -1, 1410, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2050, -1, 1411, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2052, -1, 1412, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2054, -1, 1413, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2056, -1, 1414, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1329, -1, 1329, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1330, -1, 1330, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1331, -1, 1331, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1332, -1, 1332, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1333, -1, 1333, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1334, -1, 1334, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1335, -1, 1335, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1336, -1, 1336, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1337, -1, 1337, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1338, -1, 1338, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1339, -1, 1339, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1340, -1, 1340, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1341, -1, 1341, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1342, -1, 1342, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1343, -1, 1343, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1344, -1, 1344, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1345, -1, 1345, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1346, -1, 1346, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1347, -1, 1347, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1348, -1, 1348, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1349, -1, 1349, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1350, -1, 1350, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1351, -1, 1351, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1352, -1, 1352, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1353, -1, 1353, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1354, -1, 1354, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1355, -1, 1355, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1356, -1, 1356, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1357, -1, 1357, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1358, -1, 1358, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1359, -1, 1359, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1360, -1, 1360, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1361, -1, 1361, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1362, -1, 1362, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1363, -1, 1363, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1364, -1, 1364, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1365, -1, 1365, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 1366, -1, 1366, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 2058, utf8proc_sequences + 2058, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_PD, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_MN, 222, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 228, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 10, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 11, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 12, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 13, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 14, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 15, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 16, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 17, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 18, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 19, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 20, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 21, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 22, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_PD, 0, UTF8PROC_BIDI_CLASS_R, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_MN, 23, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_R, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_MN, 24, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 25, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_R, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_CF, 0, UTF8PROC_BIDI_CLASS_AN, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, true, UTF8PROC_BOUNDCLASS_CONTROL, 0},
  {UTF8PROC_CATEGORY_CF, 0, UTF8PROC_BIDI_CLASS_AN, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, true, UTF8PROC_BOUNDCLASS_CONTROL, 2},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_AL, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SC, 0, UTF8PROC_BIDI_CLASS_AL, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_AL, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_MN, 30, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 31, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 32, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_CF, 0, UTF8PROC_BIDI_CLASS_AL, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, true, true, UTF8PROC_BOUNDCLASS_CONTROL, 0},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_AL, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, 0, utf8proc_sequences + 2061, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, 0, utf8proc_sequences + 2064, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, 0, utf8proc_sequences + 2067, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, 0, utf8proc_sequences + 2070, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, 0, utf8proc_sequences + 2073, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, 0, NULL, NULL, -1, -1, -1, 7480, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_AL, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, 0, NULL, NULL, -1, -1, -1, 7548, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, 0, NULL, NULL, -1, -1, -1, 7616, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_MN, 27, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 28, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 29, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 33, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 34, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 230, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, 17, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 230, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, 18, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 220, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, 19, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_ND, 0, UTF8PROC_BIDI_CLASS_AN, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_AN, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_MN, 35, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 2076, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 2079, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 2082, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 2085, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, 0, utf8proc_sequences + 2088, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, 0, NULL, NULL, -1, -1, -1, 7752, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, 0, utf8proc_sequences + 2091, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, 0, NULL, NULL, -1, -1, -1, 7820, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, 0, utf8proc_sequences + 2094, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, 0, NULL, NULL, -1, -1, -1, 7684, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_AL, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_CF, 0, UTF8PROC_BIDI_CLASS_AL, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, true, UTF8PROC_BOUNDCLASS_CONTROL, 0},
  {UTF8PROC_CATEGORY_MN, 36, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 0, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_ND, 0, UTF8PROC_BIDI_CLASS_R, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_R, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_R, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_R, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_R, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_SPACINGMARK, 0},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 7888, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2097, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 7956, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2100, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 8024, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2103, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_MN, 7, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, 20, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 9, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2106, NULL, -1, -1, -1, -1, -1, false, true, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2109, NULL, -1, -1, -1, -1, -1, false, true, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2112, NULL, -1, -1, -1, -1, -1, false, true, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2115, NULL, -1, -1, -1, -1, -1, false, true, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2118, NULL, -1, -1, -1, -1, -1, false, true, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2121, NULL, -1, -1, -1, -1, -1, false, true, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2124, NULL, -1, -1, -1, -1, -1, false, true, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2127, NULL, -1, -1, -1, -1, -1, false, true, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_ND, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_MN, 7, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, -1, 21, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 8092, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_SPACINGMARK, 0},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2130, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_SPACINGMARK, 0},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2133, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_SPACINGMARK, 0},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, -1, 22, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2136, NULL, -1, -1, -1, -1, -1, false, true, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2139, NULL, -1, -1, -1, -1, -1, false, true, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2142, NULL, -1, -1, -1, -1, -1, false, true, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SC, 0, UTF8PROC_BIDI_CLASS_ET, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2145, NULL, -1, -1, -1, -1, -1, false, true, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2148, NULL, -1, -1, -1, -1, -1, false, true, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2151, NULL, -1, -1, -1, -1, -1, false, true, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2154, NULL, -1, -1, -1, -1, -1, false, true, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2157, NULL, -1, -1, -1, -1, -1, false, true, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2160, NULL, -1, -1, -1, -1, -1, false, true, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, -1, 24, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 8160, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_SPACINGMARK, 0},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2163, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_SPACINGMARK, 0},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2166, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_SPACINGMARK, 0},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2169, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_SPACINGMARK, 0},
  {UTF8PROC_CATEGORY_MN, 0, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, 23, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, -1, 25, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2172, NULL, -1, -1, -1, -1, -1, false, true, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2175, NULL, -1, -1, -1, -1, -1, false, true, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 8228, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2178, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, -1, 27, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 8296, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_SPACINGMARK, 0},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 8364, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_SPACINGMARK, 0},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2181, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_SPACINGMARK, 0},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2184, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_SPACINGMARK, 0},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2187, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_SPACINGMARK, 0},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, -1, 26, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 0, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, 8432, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 0, UTF8PROC_BIDI_CLASS_NSM, 0, utf8proc_sequences + 2190, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 84, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 91, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, 28, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_MN, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 8500, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2193, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_SPACINGMARK, 0},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, -1, 31, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 8568, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2196, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_SPACINGMARK, 0},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2199, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_SPACINGMARK, 0},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2202, NULL, -1, -1, -1, 8636, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_SPACINGMARK, 0},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2205, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_SPACINGMARK, 0},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, -1, 29, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, -1, 30, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, -1, 32, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 8704, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_SPACINGMARK, 0},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 8772, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_SPACINGMARK, 0},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2208, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_SPACINGMARK, 0},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2211, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_SPACINGMARK, 0},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2214, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_SPACINGMARK, 0},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, -1, 33, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 9, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, 34, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, -1, 35, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 8840, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_SPACINGMARK, 0},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2217, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_SPACINGMARK, 0},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2220, NULL, -1, -1, -1, 8908, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_SPACINGMARK, 0},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2223, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_SPACINGMARK, 0},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2226, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_SPACINGMARK, 0},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, -1, 36, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 2229, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_SPACINGMARK, 1},
  {UTF8PROC_CATEGORY_MN, 103, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 107, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_ND, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 2232, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_SPACINGMARK, 1},
  {UTF8PROC_CATEGORY_MN, 118, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 122, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 2235, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 2238, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NOBREAK, utf8proc_sequences + 2241, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_MN, 216, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_PS, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_PE, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2243, NULL, -1, -1, -1, -1, -1, false, true, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2246, NULL, -1, -1, -1, -1, -1, false, true, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2249, NULL, -1, -1, -1, -1, -1, false, true, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2252, NULL, -1, -1, -1, -1, -1, false, true, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2255, NULL, -1, -1, -1, -1, -1, false, true, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2258, NULL, -1, -1, -1, -1, -1, false, true, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_MN, 129, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 130, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 0, UTF8PROC_BIDI_CLASS_NSM, 0, utf8proc_sequences + 2261, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 132, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 0, UTF8PROC_BIDI_CLASS_NSM, 0, utf8proc_sequences + 2264, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 0, UTF8PROC_BIDI_CLASS_NSM, 0, utf8proc_sequences + 2267, NULL, -1, -1, -1, -1, -1, false, true, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 0, UTF8PROC_BIDI_CLASS_NSM, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 2270, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 0, UTF8PROC_BIDI_CLASS_NSM, 0, utf8proc_sequences + 2273, NULL, -1, -1, -1, -1, -1, false, true, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 0, UTF8PROC_BIDI_CLASS_NSM, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 2276, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 0, UTF8PROC_BIDI_CLASS_NSM, 0, utf8proc_sequences + 2279, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 0, UTF8PROC_BIDI_CLASS_NSM, 0, utf8proc_sequences + 2282, NULL, -1, -1, -1, -1, -1, false, true, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 0, UTF8PROC_BIDI_CLASS_NSM, 0, utf8proc_sequences + 2285, NULL, -1, -1, -1, -1, -1, false, true, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 0, UTF8PROC_BIDI_CLASS_NSM, 0, utf8proc_sequences + 2288, NULL, -1, -1, -1, -1, -1, false, true, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 0, UTF8PROC_BIDI_CLASS_NSM, 0, utf8proc_sequences + 2291, NULL, -1, -1, -1, -1, -1, false, true, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 0, UTF8PROC_BIDI_CLASS_NSM, 0, utf8proc_sequences + 2294, NULL, -1, -1, -1, -1, -1, false, true, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 0, UTF8PROC_BIDI_CLASS_NSM, 0, utf8proc_sequences + 2297, NULL, -1, -1, -1, -1, -1, false, true, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 8976, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2300, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 0},
  {UTF8PROC_CATEGORY_MN, 0, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, 37, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2303, -1, 11520, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2305, -1, 11521, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2307, -1, 11522, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2309, -1, 11523, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2311, -1, 11524, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2313, -1, 11525, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2315, -1, 11526, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2317, -1, 11527, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2319, -1, 11528, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2321, -1, 11529, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2323, -1, 11530, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2325, -1, 11531, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2327, -1, 11532, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2329, -1, 11533, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2331, -1, 11534, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2333, -1, 11535, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2335, -1, 11536, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2337, -1, 11537, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2339, -1, 11538, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2341, -1, 11539, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2343, -1, 11540, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2345, -1, 11541, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2347, -1, 11542, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2349, -1, 11543, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2351, -1, 11544, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2353, -1, 11545, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2355, -1, 11546, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2357, -1, 11547, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2359, -1, 11548, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2361, -1, 11549, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2363, -1, 11550, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2365, -1, 11551, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2367, -1, 11552, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2369, -1, 11553, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2371, -1, 11554, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2373, -1, 11555, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2375, -1, 11556, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2377, -1, 11557, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2379, -1, 11559, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2381, -1, 11565, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 2383, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_L, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, true, false, UTF8PROC_BOUNDCLASS_L, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, true, false, UTF8PROC_BOUNDCLASS_V, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_V, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_T, 2},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43888, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43889, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43890, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43891, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43892, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43893, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43894, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43895, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43896, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43897, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43898, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43899, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43900, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43901, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43902, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43903, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43904, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43905, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43906, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43907, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43908, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43909, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43910, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43911, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43912, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43913, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43914, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43915, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43916, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43917, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43918, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43919, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43920, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43921, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43922, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43923, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43924, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43925, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43926, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43927, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43928, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43929, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43930, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43931, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43932, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43933, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43934, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43935, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43936, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43937, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43938, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43939, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43940, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43941, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43942, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43943, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43944, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43945, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43946, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43947, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43948, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43949, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43950, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43951, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43952, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43953, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43954, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43955, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43956, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43957, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43958, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43959, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43960, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43961, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43962, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43963, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43964, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43965, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43966, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 43967, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 5112, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 5113, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 5114, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 5115, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 5116, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, 5117, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2385, 5104, -1, 5104, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2387, 5105, -1, 5105, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2389, 5106, -1, 5106, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2391, 5107, -1, 5107, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2393, 5108, -1, 5108, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2395, 5109, -1, 5109, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_ZS, 0, UTF8PROC_BIDI_CLASS_WS, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_PD, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 9044, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2397, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 9112, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2400, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 9180, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2403, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 9248, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2406, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 9316, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2409, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 9384, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2412, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, -1, 38, false, false, false, false, UTF8PROC_BOUNDCLASS_SPACINGMARK, 0},
  {UTF8PROC_CATEGORY_MN, 0, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, 9452, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2415, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_SPACINGMARK, 0},
  {UTF8PROC_CATEGORY_MN, 0, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, 9520, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2418, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_SPACINGMARK, 0},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 9588, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_SPACINGMARK, 0},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 9656, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_SPACINGMARK, 0},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2421, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_SPACINGMARK, 0},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2424, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_SPACINGMARK, 0},
  {UTF8PROC_CATEGORY_MN, 0, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, 9724, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2427, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_SPACINGMARK, 0},
  {UTF8PROC_CATEGORY_MC, 9, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_SPACINGMARK, 0},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 2430, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 2432, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 2434, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 2436, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 2438, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 2440, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 2442, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 2444, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 2446, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 2448, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 2450, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 2452, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 2454, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 2456, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 2458, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 2460, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 2462, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 2464, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 2466, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 2468, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 2470, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 0, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 2472, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 2474, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 2476, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 2, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 6, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 8, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 792, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 794, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 2478, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 12, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 20, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 24, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 579, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 28, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 780, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 2480, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 2482, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 30, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 38, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 40, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 2484, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 808, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 42, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 2486, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 1392, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 1394, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 1396, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 1426, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 1428, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUB, utf8proc_sequences + 16, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUB, utf8proc_sequences + 34, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUB, utf8proc_sequences + 40, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUB, utf8proc_sequences + 42, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUB, utf8proc_sequences + 1392, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUB, utf8proc_sequences + 1394, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUB, utf8proc_sequences + 1418, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUB, utf8proc_sequences + 1426, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUB, utf8proc_sequences + 1428, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 1612, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42877, -1, 42877, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11363, -1, 11363, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 2488, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 4, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 2490, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 163, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 10, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 2492, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 2494, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 2496, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 804, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 802, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 2498, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 2500, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 2502, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 2504, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 2506, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 2508, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 2510, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 2512, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 810, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 2514, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 2516, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 812, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 2518, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 2520, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 830, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 2522, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 1275, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 844, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 2524, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 846, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 1277, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 50, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 2526, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 2528, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 852, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 1404, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_MN, 214, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2530, utf8proc_sequences + 2533, -1, 7681, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2535, NULL, 7680, -1, 7680, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2538, utf8proc_sequences + 2541, -1, 7683, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2543, NULL, 7682, -1, 7682, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2546, utf8proc_sequences + 2549, -1, 7685, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2551, NULL, 7684, -1, 7684, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2554, utf8proc_sequences + 2557, -1, 7687, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2559, NULL, 7686, -1, 7686, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2562, utf8proc_sequences + 2565, -1, 7689, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2567, NULL, 7688, -1, 7688, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2570, utf8proc_sequences + 2573, -1, 7691, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2575, NULL, 7690, -1, 7690, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2578, utf8proc_sequences + 2581, -1, 7693, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2583, NULL, 7692, -1, 7692, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2586, utf8proc_sequences + 2589, -1, 7695, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2591, NULL, 7694, -1, 7694, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2594, utf8proc_sequences + 2597, -1, 7697, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2599, NULL, 7696, -1, 7696, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2602, utf8proc_sequences + 2605, -1, 7699, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2607, NULL, 7698, -1, 7698, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2610, utf8proc_sequences + 2613, -1, 7701, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2615, NULL, 7700, -1, 7700, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2618, utf8proc_sequences + 2621, -1, 7703, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2623, NULL, 7702, -1, 7702, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2626, utf8proc_sequences + 2629, -1, 7705, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2631, NULL, 7704, -1, 7704, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2634, utf8proc_sequences + 2637, -1, 7707, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2639, NULL, 7706, -1, 7706, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2642, utf8proc_sequences + 2645, -1, 7709, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2647, NULL, 7708, -1, 7708, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2650, utf8proc_sequences + 2653, -1, 7711, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2655, NULL, 7710, -1, 7710, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2658, utf8proc_sequences + 2661, -1, 7713, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2663, NULL, 7712, -1, 7712, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2666, utf8proc_sequences + 2669, -1, 7715, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2671, NULL, 7714, -1, 7714, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2674, utf8proc_sequences + 2677, -1, 7717, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2679, NULL, 7716, -1, 7716, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2682, utf8proc_sequences + 2685, -1, 7719, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2687, NULL, 7718, -1, 7718, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2690, utf8proc_sequences + 2693, -1, 7721, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2695, NULL, 7720, -1, 7720, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2698, utf8proc_sequences + 2701, -1, 7723, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2703, NULL, 7722, -1, 7722, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2706, utf8proc_sequences + 2709, -1, 7725, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2711, NULL, 7724, -1, 7724, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2714, utf8proc_sequences + 2717, -1, 7727, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2719, NULL, 7726, -1, 7726, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2722, utf8proc_sequences + 2725, -1, 7729, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2727, NULL, 7728, -1, 7728, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2730, utf8proc_sequences + 2733, -1, 7731, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2735, NULL, 7730, -1, 7730, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2738, utf8proc_sequences + 2741, -1, 7733, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2743, NULL, 7732, -1, 7732, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2746, utf8proc_sequences + 2749, -1, 7735, -1, 10608, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2751, NULL, 7734, -1, 7734, 10676, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2754, utf8proc_sequences + 2757, -1, 7737, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2759, NULL, 7736, -1, 7736, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2762, utf8proc_sequences + 2765, -1, 7739, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2767, NULL, 7738, -1, 7738, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2770, utf8proc_sequences + 2773, -1, 7741, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2775, NULL, 7740, -1, 7740, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2778, utf8proc_sequences + 2781, -1, 7743, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2783, NULL, 7742, -1, 7742, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2786, utf8proc_sequences + 2789, -1, 7745, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2791, NULL, 7744, -1, 7744, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2794, utf8proc_sequences + 2797, -1, 7747, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2799, NULL, 7746, -1, 7746, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2802, utf8proc_sequences + 2805, -1, 7749, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2807, NULL, 7748, -1, 7748, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2810, utf8proc_sequences + 2813, -1, 7751, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2815, NULL, 7750, -1, 7750, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2818, utf8proc_sequences + 2821, -1, 7753, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2823, NULL, 7752, -1, 7752, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2826, utf8proc_sequences + 2829, -1, 7755, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2831, NULL, 7754, -1, 7754, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2834, utf8proc_sequences + 2837, -1, 7757, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2839, NULL, 7756, -1, 7756, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2842, utf8proc_sequences + 2845, -1, 7759, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2847, NULL, 7758, -1, 7758, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2850, utf8proc_sequences + 2853, -1, 7761, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2855, NULL, 7760, -1, 7760, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2858, utf8proc_sequences + 2861, -1, 7763, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2863, NULL, 7762, -1, 7762, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2866, utf8proc_sequences + 2869, -1, 7765, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2871, NULL, 7764, -1, 7764, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2874, utf8proc_sequences + 2877, -1, 7767, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2879, NULL, 7766, -1, 7766, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2882, utf8proc_sequences + 2885, -1, 7769, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2887, NULL, 7768, -1, 7768, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2890, utf8proc_sequences + 2893, -1, 7771, -1, 11152, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2895, NULL, 7770, -1, 7770, 11220, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2898, utf8proc_sequences + 2901, -1, 7773, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2903, NULL, 7772, -1, 7772, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2906, utf8proc_sequences + 2909, -1, 7775, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2911, NULL, 7774, -1, 7774, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2914, utf8proc_sequences + 2917, -1, 7777, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2919, NULL, 7776, -1, 7776, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2922, utf8proc_sequences + 2925, -1, 7779, -1, 11560, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2927, NULL, 7778, -1, 7778, 11628, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2930, utf8proc_sequences + 2933, -1, 7781, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2935, NULL, 7780, -1, 7780, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2938, utf8proc_sequences + 2941, -1, 7783, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2943, NULL, 7782, -1, 7782, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2946, utf8proc_sequences + 2949, -1, 7785, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2951, NULL, 7784, -1, 7784, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2954, utf8proc_sequences + 2957, -1, 7787, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2959, NULL, 7786, -1, 7786, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2962, utf8proc_sequences + 2965, -1, 7789, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2967, NULL, 7788, -1, 7788, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2970, utf8proc_sequences + 2973, -1, 7791, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2975, NULL, 7790, -1, 7790, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2978, utf8proc_sequences + 2981, -1, 7793, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2983, NULL, 7792, -1, 7792, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2986, utf8proc_sequences + 2989, -1, 7795, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2991, NULL, 7794, -1, 7794, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2994, utf8proc_sequences + 2997, -1, 7797, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2999, NULL, 7796, -1, 7796, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3002, utf8proc_sequences + 3005, -1, 7799, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3007, NULL, 7798, -1, 7798, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3010, utf8proc_sequences + 3013, -1, 7801, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3015, NULL, 7800, -1, 7800, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3018, utf8proc_sequences + 3021, -1, 7803, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3023, NULL, 7802, -1, 7802, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3026, utf8proc_sequences + 3029, -1, 7805, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3031, NULL, 7804, -1, 7804, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3034, utf8proc_sequences + 3037, -1, 7807, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3039, NULL, 7806, -1, 7806, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3042, utf8proc_sequences + 3045, -1, 7809, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3047, NULL, 7808, -1, 7808, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3050, utf8proc_sequences + 3053, -1, 7811, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3055, NULL, 7810, -1, 7810, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3058, utf8proc_sequences + 3061, -1, 7813, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3063, NULL, 7812, -1, 7812, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3066, utf8proc_sequences + 3069, -1, 7815, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3071, NULL, 7814, -1, 7814, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3074, utf8proc_sequences + 3077, -1, 7817, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3079, NULL, 7816, -1, 7816, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3082, utf8proc_sequences + 3085, -1, 7819, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3087, NULL, 7818, -1, 7818, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3090, utf8proc_sequences + 3093, -1, 7821, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3095, NULL, 7820, -1, 7820, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3098, utf8proc_sequences + 3101, -1, 7823, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3103, NULL, 7822, -1, 7822, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3106, utf8proc_sequences + 3109, -1, 7825, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3111, NULL, 7824, -1, 7824, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3114, utf8proc_sequences + 3117, -1, 7827, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3119, NULL, 7826, -1, 7826, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3122, utf8proc_sequences + 3125, -1, 7829, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3127, NULL, 7828, -1, 7828, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3130, utf8proc_sequences + 3130, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3133, utf8proc_sequences + 3133, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3136, utf8proc_sequences + 3136, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3139, utf8proc_sequences + 3139, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 3142, utf8proc_sequences + 3142, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3145, utf8proc_sequences + 2917, 7776, -1, 7776, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 3148, -1, 223, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3150, utf8proc_sequences + 3153, -1, 7841, -1, 12444, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3155, NULL, 7840, -1, 7840, 12512, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3158, utf8proc_sequences + 3161, -1, 7843, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3163, NULL, 7842, -1, 7842, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3166, utf8proc_sequences + 3169, -1, 7845, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3171, NULL, 7844, -1, 7844, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3174, utf8proc_sequences + 3177, -1, 7847, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3179, NULL, 7846, -1, 7846, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3182, utf8proc_sequences + 3185, -1, 7849, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3187, NULL, 7848, -1, 7848, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3190, utf8proc_sequences + 3193, -1, 7851, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3195, NULL, 7850, -1, 7850, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3198, utf8proc_sequences + 3201, -1, 7853, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3203, NULL, 7852, -1, 7852, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3206, utf8proc_sequences + 3209, -1, 7855, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3211, NULL, 7854, -1, 7854, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3214, utf8proc_sequences + 3217, -1, 7857, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3219, NULL, 7856, -1, 7856, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3222, utf8proc_sequences + 3225, -1, 7859, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3227, NULL, 7858, -1, 7858, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3230, utf8proc_sequences + 3233, -1, 7861, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3235, NULL, 7860, -1, 7860, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3238, utf8proc_sequences + 3241, -1, 7863, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3243, NULL, 7862, -1, 7862, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3246, utf8proc_sequences + 3249, -1, 7865, -1, 12852, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3251, NULL, 7864, -1, 7864, 12920, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3254, utf8proc_sequences + 3257, -1, 7867, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3259, NULL, 7866, -1, 7866, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3262, utf8proc_sequences + 3265, -1, 7869, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3267, NULL, 7868, -1, 7868, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3270, utf8proc_sequences + 3273, -1, 7871, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3275, NULL, 7870, -1, 7870, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3278, utf8proc_sequences + 3281, -1, 7873, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3283, NULL, 7872, -1, 7872, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3286, utf8proc_sequences + 3289, -1, 7875, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3291, NULL, 7874, -1, 7874, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3294, utf8proc_sequences + 3297, -1, 7877, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3299, NULL, 7876, -1, 7876, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3302, utf8proc_sequences + 3305, -1, 7879, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3307, NULL, 7878, -1, 7878, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3310, utf8proc_sequences + 3313, -1, 7881, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3315, NULL, 7880, -1, 7880, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3318, utf8proc_sequences + 3321, -1, 7883, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3323, NULL, 7882, -1, 7882, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3326, utf8proc_sequences + 3329, -1, 7885, -1, 13124, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3331, NULL, 7884, -1, 7884, 13192, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3334, utf8proc_sequences + 3337, -1, 7887, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3339, NULL, 7886, -1, 7886, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3342, utf8proc_sequences + 3345, -1, 7889, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3347, NULL, 7888, -1, 7888, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3350, utf8proc_sequences + 3353, -1, 7891, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3355, NULL, 7890, -1, 7890, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3358, utf8proc_sequences + 3361, -1, 7893, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3363, NULL, 7892, -1, 7892, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3366, utf8proc_sequences + 3369, -1, 7895, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3371, NULL, 7894, -1, 7894, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3374, utf8proc_sequences + 3377, -1, 7897, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3379, NULL, 7896, -1, 7896, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3382, utf8proc_sequences + 3385, -1, 7899, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3387, NULL, 7898, -1, 7898, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3390, utf8proc_sequences + 3393, -1, 7901, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3395, NULL, 7900, -1, 7900, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3398, utf8proc_sequences + 3401, -1, 7903, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3403, NULL, 7902, -1, 7902, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3406, utf8proc_sequences + 3409, -1, 7905, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3411, NULL, 7904, -1, 7904, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3414, utf8proc_sequences + 3417, -1, 7907, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3419, NULL, 7906, -1, 7906, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3422, utf8proc_sequences + 3425, -1, 7909, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3427, NULL, 7908, -1, 7908, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3430, utf8proc_sequences + 3433, -1, 7911, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3435, NULL, 7910, -1, 7910, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3438, utf8proc_sequences + 3441, -1, 7913, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3443, NULL, 7912, -1, 7912, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3446, utf8proc_sequences + 3449, -1, 7915, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3451, NULL, 7914, -1, 7914, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3454, utf8proc_sequences + 3457, -1, 7917, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3459, NULL, 7916, -1, 7916, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3462, utf8proc_sequences + 3465, -1, 7919, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3467, NULL, 7918, -1, 7918, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3470, utf8proc_sequences + 3473, -1, 7921, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3475, NULL, 7920, -1, 7920, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3478, utf8proc_sequences + 3481, -1, 7923, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3483, NULL, 7922, -1, 7922, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3486, utf8proc_sequences + 3489, -1, 7925, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3491, NULL, 7924, -1, 7924, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3494, utf8proc_sequences + 3497, -1, 7927, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3499, NULL, 7926, -1, 7926, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3502, utf8proc_sequences + 3505, -1, 7929, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3507, NULL, 7928, -1, 7928, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 3510, -1, 7931, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 7930, -1, 7930, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 3512, -1, 7933, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 7932, -1, 7932, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 3514, -1, 7935, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 7934, -1, 7934, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3516, NULL, 7944, -1, 7944, 13532, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3519, NULL, 7945, -1, 7945, 13600, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3522, NULL, 7946, -1, 7946, 15368, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3525, NULL, 7947, -1, 7947, 15436, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3528, NULL, 7948, -1, 7948, 15504, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3531, NULL, 7949, -1, 7949, 15572, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3534, NULL, 7950, -1, 7950, 15640, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3537, NULL, 7951, -1, 7951, 15708, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3540, utf8proc_sequences + 3543, -1, 7936, -1, 13668, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3545, utf8proc_sequences + 3548, -1, 7937, -1, 13736, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3550, utf8proc_sequences + 3553, -1, 7938, -1, 15776, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3555, utf8proc_sequences + 3558, -1, 7939, -1, 15844, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3560, utf8proc_sequences + 3563, -1, 7940, -1, 15912, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3565, utf8proc_sequences + 3568, -1, 7941, -1, 15980, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3570, utf8proc_sequences + 3573, -1, 7942, -1, 16048, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3575, utf8proc_sequences + 3578, -1, 7943, -1, 16116, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3580, NULL, 7960, -1, 7960, 13804, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3583, NULL, 7961, -1, 7961, 13872, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3586, NULL, 7962, -1, 7962, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3589, NULL, 7963, -1, 7963, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3592, NULL, 7964, -1, 7964, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3595, NULL, 7965, -1, 7965, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3598, utf8proc_sequences + 3601, -1, 7952, -1, 13940, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3603, utf8proc_sequences + 3606, -1, 7953, -1, 14008, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3608, utf8proc_sequences + 3611, -1, 7954, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3613, utf8proc_sequences + 3616, -1, 7955, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3618, utf8proc_sequences + 3621, -1, 7956, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3623, utf8proc_sequences + 3626, -1, 7957, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3628, NULL, 7976, -1, 7976, 14076, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3631, NULL, 7977, -1, 7977, 14144, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3634, NULL, 7978, -1, 7978, 16184, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3637, NULL, 7979, -1, 7979, 16252, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3640, NULL, 7980, -1, 7980, 16320, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3643, NULL, 7981, -1, 7981, 16388, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3646, NULL, 7982, -1, 7982, 16456, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3649, NULL, 7983, -1, 7983, 16524, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3652, utf8proc_sequences + 3655, -1, 7968, -1, 14212, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3657, utf8proc_sequences + 3660, -1, 7969, -1, 14280, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3662, utf8proc_sequences + 3665, -1, 7970, -1, 16592, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3667, utf8proc_sequences + 3670, -1, 7971, -1, 16660, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3672, utf8proc_sequences + 3675, -1, 7972, -1, 16728, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3677, utf8proc_sequences + 3680, -1, 7973, -1, 16796, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3682, utf8proc_sequences + 3685, -1, 7974, -1, 16864, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3687, utf8proc_sequences + 3690, -1, 7975, -1, 16932, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3692, NULL, 7992, -1, 7992, 14348, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3695, NULL, 7993, -1, 7993, 14416, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3698, NULL, 7994, -1, 7994, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3701, NULL, 7995, -1, 7995, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3704, NULL, 7996, -1, 7996, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3707, NULL, 7997, -1, 7997, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3710, NULL, 7998, -1, 7998, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3713, NULL, 7999, -1, 7999, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3716, utf8proc_sequences + 3719, -1, 7984, -1, 14484, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3721, utf8proc_sequences + 3724, -1, 7985, -1, 14552, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3726, utf8proc_sequences + 3729, -1, 7986, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3731, utf8proc_sequences + 3734, -1, 7987, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3736, utf8proc_sequences + 3739, -1, 7988, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3741, utf8proc_sequences + 3744, -1, 7989, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3746, utf8proc_sequences + 3749, -1, 7990, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3751, utf8proc_sequences + 3754, -1, 7991, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3756, NULL, 8008, -1, 8008, 14620, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3759, NULL, 8009, -1, 8009, 14688, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3762, NULL, 8010, -1, 8010, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3765, NULL, 8011, -1, 8011, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3768, NULL, 8012, -1, 8012, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3771, NULL, 8013, -1, 8013, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3774, utf8proc_sequences + 3777, -1, 8000, -1, 14756, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3779, utf8proc_sequences + 3782, -1, 8001, -1, 14824, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3784, utf8proc_sequences + 3787, -1, 8002, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3789, utf8proc_sequences + 3792, -1, 8003, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3794, utf8proc_sequences + 3797, -1, 8004, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3799, utf8proc_sequences + 3802, -1, 8005, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3804, utf8proc_sequences + 3804, -1, -1, -1, 14892, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3807, NULL, 8025, -1, 8025, 14960, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3810, utf8proc_sequences + 3813, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3817, NULL, 8027, -1, 8027, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3820, utf8proc_sequences + 3823, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3827, NULL, 8029, -1, 8029, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3830, utf8proc_sequences + 3833, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3837, NULL, 8031, -1, 8031, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3840, utf8proc_sequences + 3843, -1, 8017, -1, 15028, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3845, utf8proc_sequences + 3848, -1, 8019, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3850, utf8proc_sequences + 3853, -1, 8021, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3855, utf8proc_sequences + 3858, -1, 8023, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3860, NULL, 8040, -1, 8040, 15096, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3863, NULL, 8041, -1, 8041, 15164, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3866, NULL, 8042, -1, 8042, 17000, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3869, NULL, 8043, -1, 8043, 17068, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3872, NULL, 8044, -1, 8044, 17136, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3875, NULL, 8045, -1, 8045, 17204, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3878, NULL, 8046, -1, 8046, 17272, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3881, NULL, 8047, -1, 8047, 17340, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3884, utf8proc_sequences + 3887, -1, 8032, -1, 15232, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3889, utf8proc_sequences + 3892, -1, 8033, -1, 15300, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3894, utf8proc_sequences + 3897, -1, 8034, -1, 17408, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3899, utf8proc_sequences + 3902, -1, 8035, -1, 17476, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3904, utf8proc_sequences + 3907, -1, 8036, -1, 17544, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3909, utf8proc_sequences + 3912, -1, 8037, -1, 17612, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3914, utf8proc_sequences + 3917, -1, 8038, -1, 17680, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3919, utf8proc_sequences + 3922, -1, 8039, -1, 17748, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3924, NULL, 8122, -1, 8122, 17816, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1349, NULL, 8123, -1, 8123, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3927, NULL, 8136, -1, 8136, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1356, NULL, 8137, -1, 8137, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3930, NULL, 8138, -1, 8138, 18020, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1361, NULL, 8139, -1, 8139, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3933, NULL, 8154, -1, 8154, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1366, NULL, 8155, -1, 8155, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3936, NULL, 8184, -1, 8184, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1371, NULL, 8185, -1, 8185, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3939, NULL, 8170, -1, 8170, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1376, NULL, 8171, -1, 8171, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3942, NULL, 8186, -1, 8186, 18496, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1381, NULL, 8187, -1, 8187, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3945, utf8proc_sequences + 3948, 8072, -1, 8072, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3951, utf8proc_sequences + 3954, 8073, -1, 8073, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3957, utf8proc_sequences + 3960, 8074, -1, 8074, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3963, utf8proc_sequences + 3966, 8075, -1, 8075, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3969, utf8proc_sequences + 3972, 8076, -1, 8076, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3975, utf8proc_sequences + 3978, 8077, -1, 8077, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3981, utf8proc_sequences + 3984, 8078, -1, 8078, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3987, utf8proc_sequences + 3990, 8079, -1, 8079, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3993, utf8proc_sequences + 3996, -1, 8064, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 3998, utf8proc_sequences + 4001, -1, 8065, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4003, utf8proc_sequences + 4006, -1, 8066, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4008, utf8proc_sequences + 4011, -1, 8067, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4013, utf8proc_sequences + 4016, -1, 8068, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4018, utf8proc_sequences + 4021, -1, 8069, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4023, utf8proc_sequences + 4026, -1, 8070, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4028, utf8proc_sequences + 4031, -1, 8071, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4033, utf8proc_sequences + 4036, 8088, -1, 8088, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4039, utf8proc_sequences + 4042, 8089, -1, 8089, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4045, utf8proc_sequences + 4048, 8090, -1, 8090, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4051, utf8proc_sequences + 4054, 8091, -1, 8091, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4057, utf8proc_sequences + 4060, 8092, -1, 8092, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4063, utf8proc_sequences + 4066, 8093, -1, 8093, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4069, utf8proc_sequences + 4072, 8094, -1, 8094, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4075, utf8proc_sequences + 4078, 8095, -1, 8095, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4081, utf8proc_sequences + 4084, -1, 8080, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4086, utf8proc_sequences + 4089, -1, 8081, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4091, utf8proc_sequences + 4094, -1, 8082, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4096, utf8proc_sequences + 4099, -1, 8083, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4101, utf8proc_sequences + 4104, -1, 8084, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4106, utf8proc_sequences + 4109, -1, 8085, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4111, utf8proc_sequences + 4114, -1, 8086, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4116, utf8proc_sequences + 4119, -1, 8087, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4121, utf8proc_sequences + 4124, 8104, -1, 8104, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4127, utf8proc_sequences + 4130, 8105, -1, 8105, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4133, utf8proc_sequences + 4136, 8106, -1, 8106, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4139, utf8proc_sequences + 4142, 8107, -1, 8107, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4145, utf8proc_sequences + 4148, 8108, -1, 8108, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4151, utf8proc_sequences + 4154, 8109, -1, 8109, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4157, utf8proc_sequences + 4160, 8110, -1, 8110, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4163, utf8proc_sequences + 4166, 8111, -1, 8111, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4169, utf8proc_sequences + 4172, -1, 8096, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4174, utf8proc_sequences + 4177, -1, 8097, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4179, utf8proc_sequences + 4182, -1, 8098, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4184, utf8proc_sequences + 4187, -1, 8099, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4189, utf8proc_sequences + 4192, -1, 8100, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4194, utf8proc_sequences + 4197, -1, 8101, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4199, utf8proc_sequences + 4202, -1, 8102, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4204, utf8proc_sequences + 4207, -1, 8103, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4209, NULL, 8120, -1, 8120, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4212, NULL, 8121, -1, 8121, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4215, utf8proc_sequences + 4218, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4221, utf8proc_sequences + 4224, 8124, -1, 8124, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4227, utf8proc_sequences + 4230, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4233, utf8proc_sequences + 4233, -1, -1, -1, 17952, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4236, utf8proc_sequences + 4239, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4243, utf8proc_sequences + 4246, -1, 8112, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4248, utf8proc_sequences + 4251, -1, 8113, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4253, utf8proc_sequences + 4256, -1, 8048, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4258, utf8proc_sequences + 4260, -1, 8049, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4262, utf8proc_sequences + 4265, -1, 8115, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4267, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 1326, utf8proc_sequences + 1326, 921, -1, 921, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4267, NULL, -1, -1, -1, 18224, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4270, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4273, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4276, utf8proc_sequences + 4279, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4282, utf8proc_sequences + 4285, 8140, -1, 8140, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4288, utf8proc_sequences + 4291, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4294, utf8proc_sequences + 4294, -1, -1, -1, 18156, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4297, utf8proc_sequences + 4300, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4304, utf8proc_sequences + 4307, -1, 8050, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4309, utf8proc_sequences + 4311, -1, 8051, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4313, utf8proc_sequences + 4316, -1, 8052, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4318, utf8proc_sequences + 4320, -1, 8053, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4322, utf8proc_sequences + 4325, -1, 8131, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4327, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4330, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4333, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4336, NULL, 8152, -1, 8152, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4339, NULL, 8153, -1, 8153, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4342, utf8proc_sequences + 4345, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4349, utf8proc_sequences + 1386, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4351, utf8proc_sequences + 4351, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4354, utf8proc_sequences + 4357, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4361, utf8proc_sequences + 4364, -1, 8144, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4366, utf8proc_sequences + 4369, -1, 8145, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4371, utf8proc_sequences + 4374, -1, 8054, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4376, utf8proc_sequences + 4378, -1, 8055, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4380, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4383, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4386, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4389, NULL, 8168, -1, 8168, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4392, NULL, 8169, -1, 8169, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4395, utf8proc_sequences + 4398, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4402, utf8proc_sequences + 1459, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4404, utf8proc_sequences + 4404, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4407, NULL, 8172, -1, 8172, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4410, utf8proc_sequences + 4410, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4413, utf8proc_sequences + 4416, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4420, utf8proc_sequences + 4423, -1, 8160, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4425, utf8proc_sequences + 4428, -1, 8161, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4430, utf8proc_sequences + 4433, -1, 8058, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4435, utf8proc_sequences + 4437, -1, 8059, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4439, utf8proc_sequences + 4442, -1, 8165, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4444, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4447, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4449, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4451, utf8proc_sequences + 4454, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4457, utf8proc_sequences + 4460, 8188, -1, 8188, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4463, utf8proc_sequences + 4466, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4469, utf8proc_sequences + 4469, -1, -1, -1, 18632, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4472, utf8proc_sequences + 4475, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4479, utf8proc_sequences + 4482, -1, 8056, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4484, utf8proc_sequences + 4486, -1, 8057, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4488, utf8proc_sequences + 4491, -1, 8060, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4493, utf8proc_sequences + 4495, -1, 8061, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4497, utf8proc_sequences + 4500, -1, 8179, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4502, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4504, NULL, -1, -1, -1, 18292, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_ZS, 0, UTF8PROC_BIDI_CLASS_WS, 0, utf8proc_sequences + 4507, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_ZS, 0, UTF8PROC_BIDI_CLASS_WS, 0, utf8proc_sequences + 4509, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_ZS, 0, UTF8PROC_BIDI_CLASS_WS, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 52, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_ZS, 0, UTF8PROC_BIDI_CLASS_WS, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 52, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_ZS, 0, UTF8PROC_BIDI_CLASS_WS, UTF8PROC_DECOMP_TYPE_NOBREAK, utf8proc_sequences + 52, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_CF, 0, UTF8PROC_BIDI_CLASS_BN, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, true, true, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_CF, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, true, true, UTF8PROC_BOUNDCLASS_CONTROL, 0},
  {UTF8PROC_CATEGORY_CF, 0, UTF8PROC_BIDI_CLASS_R, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, true, true, UTF8PROC_BOUNDCLASS_CONTROL, 0},
  {UTF8PROC_CATEGORY_PD, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_NOBREAK, utf8proc_sequences + 4511, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4513, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_PI, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_PF, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_PS, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4516, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4518, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4521, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_ZL, 0, UTF8PROC_BIDI_CLASS_WS, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, true, UTF8PROC_BOUNDCLASS_CONTROL, 0},
  {UTF8PROC_CATEGORY_ZP, 0, UTF8PROC_BIDI_CLASS_B, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, true, UTF8PROC_BOUNDCLASS_CONTROL, 0},
  {UTF8PROC_CATEGORY_CF, 0, UTF8PROC_BIDI_CLASS_LRE, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, true, true, UTF8PROC_BOUNDCLASS_CONTROL, 0},
  {UTF8PROC_CATEGORY_CF, 0, UTF8PROC_BIDI_CLASS_RLE, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, true, true, UTF8PROC_BOUNDCLASS_CONTROL, 0},
  {UTF8PROC_CATEGORY_CF, 0, UTF8PROC_BIDI_CLASS_PDF, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, true, true, UTF8PROC_BOUNDCLASS_CONTROL, 0},
  {UTF8PROC_CATEGORY_CF, 0, UTF8PROC_BIDI_CLASS_LRO, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, true, true, UTF8PROC_BOUNDCLASS_CONTROL, 0},
  {UTF8PROC_CATEGORY_CF, 0, UTF8PROC_BIDI_CLASS_RLO, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, true, true, UTF8PROC_BOUNDCLASS_CONTROL, 0},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ET, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4525, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ET, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4528, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4532, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4535, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4539, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4542, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_CS, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4545, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4548, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4551, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4554, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_CF, 0, UTF8PROC_BIDI_CLASS_LRI, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, true, true, UTF8PROC_BOUNDCLASS_CONTROL, 0},
  {UTF8PROC_CATEGORY_CF, 0, UTF8PROC_BIDI_CLASS_RLI, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, true, true, UTF8PROC_BOUNDCLASS_CONTROL, 0},
  {UTF8PROC_CATEGORY_CF, 0, UTF8PROC_BIDI_CLASS_FSI, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, true, true, UTF8PROC_BOUNDCLASS_CONTROL, 0},
  {UTF8PROC_CATEGORY_CF, 0, UTF8PROC_BIDI_CLASS_PDI, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, true, true, UTF8PROC_BOUNDCLASS_CONTROL, 0},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 4559, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 16, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 4561, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 4563, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 4565, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 4567, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 4569, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 4571, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ES, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 4573, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ES, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 4575, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 4577, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_PS, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 4579, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_PE, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 4581, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 26, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_SUB, utf8proc_sequences + 4559, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_SUB, utf8proc_sequences + 72, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_SUB, utf8proc_sequences + 60, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_SUB, utf8proc_sequences + 62, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_SUB, utf8proc_sequences + 4561, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_SUB, utf8proc_sequences + 4563, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_SUB, utf8proc_sequences + 4565, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_SUB, utf8proc_sequences + 4567, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_SUB, utf8proc_sequences + 4569, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_SUB, utf8proc_sequences + 4571, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ES, UTF8PROC_DECOMP_TYPE_SUB, utf8proc_sequences + 4573, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ES, UTF8PROC_DECOMP_TYPE_SUB, utf8proc_sequences + 4575, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SUB, utf8proc_sequences + 4577, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_PS, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SUB, utf8proc_sequences + 4579, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_PE, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SUB, utf8proc_sequences + 4581, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUB, utf8proc_sequences + 0, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUB, utf8proc_sequences + 8, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUB, utf8proc_sequences + 28, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUB, utf8proc_sequences + 46, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUB, utf8proc_sequences + 792, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUB, utf8proc_sequences + 14, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUB, utf8proc_sequences + 20, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUB, utf8proc_sequences + 22, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUB, utf8proc_sequences + 24, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUB, utf8proc_sequences + 26, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUB, utf8proc_sequences + 30, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUB, utf8proc_sequences + 36, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUB, utf8proc_sequences + 38, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SC, 0, UTF8PROC_BIDI_CLASS_ET, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4583, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4586, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4590, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, utf8proc_sequences + 4594, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4596, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4599, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4603, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4607, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4609, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, utf8proc_sequences + 12, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, utf8proc_sequences + 2444, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, utf8proc_sequences + 14, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, utf8proc_sequences + 454, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, utf8proc_sequences + 2446, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, utf8proc_sequences + 2452, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, utf8proc_sequences + 22, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, utf8proc_sequences + 2456, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4612, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, utf8proc_sequences + 2462, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, utf8proc_sequences + 4615, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, utf8proc_sequences + 2464, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 4617, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4620, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 4624, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, utf8proc_sequences + 4627, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4629, utf8proc_sequences + 1432, -1, 969, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 2450, utf8proc_sequences + 20, -1, 107, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 4631, utf8proc_sequences + 114, -1, 229, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, utf8proc_sequences + 2434, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, utf8proc_sequences + 8, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, utf8proc_sequences + 2438, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, utf8proc_sequences + 4633, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 4635, -1, 8526, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, utf8proc_sequences + 2454, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, utf8proc_sequences + 28, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4637, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4639, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4641, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4643, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, utf8proc_sequences + 16, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4645, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, utf8proc_sequences + 1416, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, utf8proc_sequences + 1394, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, utf8proc_sequences + 4649, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, utf8proc_sequences + 4651, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_FONT, utf8proc_sequences + 4653, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, utf8proc_sequences + 2436, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, utf8proc_sequences + 6, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, utf8proc_sequences + 18, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 8498, -1, 8498, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_FRACTION, utf8proc_sequences + 4655, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_FRACTION, utf8proc_sequences + 4659, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_FRACTION, utf8proc_sequences + 4663, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_FRACTION, utf8proc_sequences + 4668, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_FRACTION, utf8proc_sequences + 4672, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_FRACTION, utf8proc_sequences + 4676, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_FRACTION, utf8proc_sequences + 4680, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_FRACTION, utf8proc_sequences + 4684, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_FRACTION, utf8proc_sequences + 4688, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_FRACTION, utf8proc_sequences + 4692, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_FRACTION, utf8proc_sequences + 4696, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_FRACTION, utf8proc_sequences + 4700, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_FRACTION, utf8proc_sequences + 4704, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_FRACTION, utf8proc_sequences + 4708, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_FRACTION, utf8proc_sequences + 4712, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_FRACTION, utf8proc_sequences + 4716, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 2446, utf8proc_sequences + 4719, -1, 8560, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4721, utf8proc_sequences + 4724, -1, 8561, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4726, utf8proc_sequences + 4730, -1, 8562, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4732, utf8proc_sequences + 4735, -1, 8563, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4737, utf8proc_sequences + 4739, -1, 8564, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4741, utf8proc_sequences + 4744, -1, 8565, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4746, utf8proc_sequences + 4750, -1, 8566, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4752, utf8proc_sequences + 4757, -1, 8567, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4759, utf8proc_sequences + 4762, -1, 8568, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4764, utf8proc_sequences + 4766, -1, 8569, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4768, utf8proc_sequences + 4771, -1, 8570, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4773, utf8proc_sequences + 4777, -1, 8571, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 2452, utf8proc_sequences + 4779, -1, 8572, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4594, utf8proc_sequences + 4781, -1, 8573, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 2436, utf8proc_sequences + 4783, -1, 8574, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 2454, utf8proc_sequences + 4785, -1, 8575, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 16, NULL, 8544, -1, 8544, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4787, NULL, 8545, -1, 8545, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4790, NULL, 8546, -1, 8546, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4794, NULL, 8547, -1, 8547, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 42, NULL, 8548, -1, 8548, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4797, NULL, 8549, -1, 8549, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4800, NULL, 8550, -1, 8550, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4804, NULL, 8551, -1, 8551, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4809, NULL, 8552, -1, 8552, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 46, NULL, 8553, -1, 8553, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4812, NULL, 8554, -1, 8554, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4815, NULL, 8555, -1, 8555, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 22, NULL, 8556, -1, 8556, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4, NULL, 8557, -1, 8557, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6, NULL, 8558, -1, 8558, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 24, NULL, 8559, -1, 8559, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 4819, -1, 8580, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 8579, -1, 8579, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_FRACTION, utf8proc_sequences + 4821, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, 18700, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, 18768, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, 18836, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4825, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4828, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4831, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4834, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4837, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4840, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, 18904, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, 19040, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, 18972, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, 19108, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4843, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, 19176, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4846, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, 19244, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4849, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, 19312, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4852, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, 19380, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4855, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4858, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4861, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4865, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 4868, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, 19448, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4872, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, 19516, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4875, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, 19584, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4878, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, 19652, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4881, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, 19856, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4884, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, 19788, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4887, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, 20060, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, 20128, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4890, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4893, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4896, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4899, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4902, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, 20196, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, 20264, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4905, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4908, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, 20332, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, 20400, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4911, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4914, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, 20468, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, 20536, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, 21148, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, 21216, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4917, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4920, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, 20604, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, 20672, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4923, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4926, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, 20740, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, 20808, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4929, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4932, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, 21284, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, 21352, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, 20876, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, 20944, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, 21012, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, 21080, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4935, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4938, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4941, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4944, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, 21420, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, 21488, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, 21556, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, 21624, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4947, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4950, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4953, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4956, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4959, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4962, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4965, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4968, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_PS, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4971, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_PE, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 4973, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 72, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 60, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 62, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 4561, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 4563, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 4565, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 4567, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 4569, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 4571, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 4975, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 4978, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 4981, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 4984, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 4987, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 4990, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 4993, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 4996, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 4999, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 5002, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 5005, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5008, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5012, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5016, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5020, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5024, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5028, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5032, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5036, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5040, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5044, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5049, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5054, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5059, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5064, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5069, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5074, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5079, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5084, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5089, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5094, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5099, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5102, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5105, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5108, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5111, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5114, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5117, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5120, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5123, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5126, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5130, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5134, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5138, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5142, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5146, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5150, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5154, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5158, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5162, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5166, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5170, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5174, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5178, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5182, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5186, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5190, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5194, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5198, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5202, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5206, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5210, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5214, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5218, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5222, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5226, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5230, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5234, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5238, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5242, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5246, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5250, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5254, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5258, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5262, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5266, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5270, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 2430, utf8proc_sequences + 5274, -1, 9424, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 2434, utf8proc_sequences + 5276, -1, 9425, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 4594, utf8proc_sequences + 5278, -1, 9426, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 2436, utf8proc_sequences + 5280, -1, 9427, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 2438, utf8proc_sequences + 5282, -1, 9428, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 4633, utf8proc_sequences + 5284, -1, 9429, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 2442, utf8proc_sequences + 5286, -1, 9430, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 2444, utf8proc_sequences + 5288, -1, 9431, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 2446, utf8proc_sequences + 5290, -1, 9432, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 2448, utf8proc_sequences + 5292, -1, 9433, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 2450, utf8proc_sequences + 5294, -1, 9434, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 2452, utf8proc_sequences + 5296, -1, 9435, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 2454, utf8proc_sequences + 5298, -1, 9436, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 2456, utf8proc_sequences + 5300, -1, 9437, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 2458, utf8proc_sequences + 5302, -1, 9438, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 2462, utf8proc_sequences + 5304, -1, 9439, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 4615, utf8proc_sequences + 5306, -1, 9440, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 2464, utf8proc_sequences + 5308, -1, 9441, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 5310, utf8proc_sequences + 5312, -1, 9442, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 2466, utf8proc_sequences + 5314, -1, 9443, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 2468, utf8proc_sequences + 5316, -1, 9444, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 4737, utf8proc_sequences + 5318, -1, 9445, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 2470, utf8proc_sequences + 5320, -1, 9446, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 4764, utf8proc_sequences + 5322, -1, 9447, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 5324, utf8proc_sequences + 5326, -1, 9448, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 4627, utf8proc_sequences + 5328, -1, 9449, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 0, NULL, 9398, -1, 9398, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 2, NULL, 9399, -1, 9399, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 4, NULL, 9400, -1, 9400, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6, NULL, 9401, -1, 9401, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 8, NULL, 9402, -1, 9402, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 10, NULL, 9403, -1, 9403, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 12, NULL, 9404, -1, 9404, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 14, NULL, 9405, -1, 9405, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 16, NULL, 9406, -1, 9406, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 18, NULL, 9407, -1, 9407, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 20, NULL, 9408, -1, 9408, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 22, NULL, 9409, -1, 9409, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 24, NULL, 9410, -1, 9410, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 26, NULL, 9411, -1, 9411, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 28, NULL, 9412, -1, 9412, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 30, NULL, 9413, -1, 9413, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 32, NULL, 9414, -1, 9414, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 34, NULL, 9415, -1, 9415, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 36, NULL, 9416, -1, 9416, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 38, NULL, 9417, -1, 9417, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 40, NULL, 9418, -1, 9418, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 42, NULL, 9419, -1, 9419, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 44, NULL, 9420, -1, 9420, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 46, NULL, 9421, -1, 9421, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 48, NULL, 9422, -1, 9422, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 50, NULL, 9423, -1, 9423, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 4559, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5330, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5335, NULL, -1, -1, -1, -1, -1, true, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5339, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5342, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, utf8proc_sequences + 5346, NULL, -1, -1, -1, -1, -1, true, true, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, 21692, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5349, -1, 11312, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5351, -1, 11313, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5353, -1, 11314, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5355, -1, 11315, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5357, -1, 11316, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5359, -1, 11317, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5361, -1, 11318, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5363, -1, 11319, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5365, -1, 11320, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5367, -1, 11321, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5369, -1, 11322, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5371, -1, 11323, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5373, -1, 11324, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5375, -1, 11325, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5377, -1, 11326, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5379, -1, 11327, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5381, -1, 11328, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5383, -1, 11329, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5385, -1, 11330, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5387, -1, 11331, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5389, -1, 11332, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5391, -1, 11333, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5393, -1, 11334, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5395, -1, 11335, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5397, -1, 11336, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5399, -1, 11337, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5401, -1, 11338, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5403, -1, 11339, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5405, -1, 11340, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5407, -1, 11341, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5409, -1, 11342, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5411, -1, 11343, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5413, -1, 11344, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5415, -1, 11345, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5417, -1, 11346, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5419, -1, 11347, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5421, -1, 11348, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5423, -1, 11349, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5425, -1, 11350, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5427, -1, 11351, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5429, -1, 11352, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5431, -1, 11353, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5433, -1, 11354, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5435, -1, 11355, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5437, -1, 11356, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5439, -1, 11357, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5441, -1, 11358, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11264, -1, 11264, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11265, -1, 11265, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11266, -1, 11266, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11267, -1, 11267, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11268, -1, 11268, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11269, -1, 11269, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11270, -1, 11270, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11271, -1, 11271, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11272, -1, 11272, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11273, -1, 11273, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11274, -1, 11274, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11275, -1, 11275, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11276, -1, 11276, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11277, -1, 11277, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11278, -1, 11278, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11279, -1, 11279, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11280, -1, 11280, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11281, -1, 11281, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11282, -1, 11282, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11283, -1, 11283, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11284, -1, 11284, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11285, -1, 11285, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11286, -1, 11286, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11287, -1, 11287, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11288, -1, 11288, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11289, -1, 11289, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11290, -1, 11290, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11291, -1, 11291, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11292, -1, 11292, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11293, -1, 11293, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11294, -1, 11294, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11295, -1, 11295, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11296, -1, 11296, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11297, -1, 11297, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11298, -1, 11298, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11299, -1, 11299, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11300, -1, 11300, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11301, -1, 11301, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11302, -1, 11302, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11303, -1, 11303, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11304, -1, 11304, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11305, -1, 11305, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11306, -1, 11306, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11307, -1, 11307, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11308, -1, 11308, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11309, -1, 11309, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11310, -1, 11310, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5443, -1, 11361, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11360, -1, 11360, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5445, -1, 619, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5447, -1, 7549, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5449, -1, 637, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 570, -1, 570, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 574, -1, 574, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5451, -1, 11368, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11367, -1, 11367, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5453, -1, 11370, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11369, -1, 11369, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5455, -1, 11372, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11371, -1, 11371, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2474, -1, 593, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2510, -1, 625, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2472, -1, 592, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2488, -1, 594, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5457, -1, 11379, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11378, -1, 11378, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5459, -1, 11382, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11381, -1, 11381, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUB, utf8proc_sequences + 18, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 4737, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5461, -1, 575, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5463, -1, 576, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5465, -1, 11393, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11392, -1, 11392, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5467, -1, 11395, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11394, -1, 11394, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5469, -1, 11397, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11396, -1, 11396, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5471, -1, 11399, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11398, -1, 11398, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5473, -1, 11401, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11400, -1, 11400, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5475, -1, 11403, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11402, -1, 11402, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5477, -1, 11405, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11404, -1, 11404, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5479, -1, 11407, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11406, -1, 11406, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5481, -1, 11409, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11408, -1, 11408, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5483, -1, 11411, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11410, -1, 11410, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5485, -1, 11413, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11412, -1, 11412, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5487, -1, 11415, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11414, -1, 11414, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5489, -1, 11417, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11416, -1, 11416, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5491, -1, 11419, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11418, -1, 11418, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5493, -1, 11421, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11420, -1, 11420, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5495, -1, 11423, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11422, -1, 11422, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5497, -1, 11425, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11424, -1, 11424, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5499, -1, 11427, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11426, -1, 11426, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5501, -1, 11429, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11428, -1, 11428, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5503, -1, 11431, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11430, -1, 11430, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5505, -1, 11433, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11432, -1, 11432, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5507, -1, 11435, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11434, -1, 11434, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5509, -1, 11437, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11436, -1, 11436, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5511, -1, 11439, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11438, -1, 11438, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5513, -1, 11441, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11440, -1, 11440, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5515, -1, 11443, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11442, -1, 11442, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5517, -1, 11445, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11444, -1, 11444, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5519, -1, 11447, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11446, -1, 11446, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5521, -1, 11449, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11448, -1, 11448, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5523, -1, 11451, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11450, -1, 11450, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5525, -1, 11453, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11452, -1, 11452, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5527, -1, 11455, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11454, -1, 11454, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5529, -1, 11457, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11456, -1, 11456, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5531, -1, 11459, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11458, -1, 11458, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5533, -1, 11461, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11460, -1, 11460, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5535, -1, 11463, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11462, -1, 11462, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5537, -1, 11465, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11464, -1, 11464, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5539, -1, 11467, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11466, -1, 11466, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5541, -1, 11469, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11468, -1, 11468, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5543, -1, 11471, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11470, -1, 11470, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5545, -1, 11473, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11472, -1, 11472, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5547, -1, 11475, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11474, -1, 11474, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5549, -1, 11477, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11476, -1, 11476, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5551, -1, 11479, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11478, -1, 11478, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5553, -1, 11481, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11480, -1, 11480, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5555, -1, 11483, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11482, -1, 11482, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5557, -1, 11485, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11484, -1, 11484, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5559, -1, 11487, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11486, -1, 11486, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5561, -1, 11489, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11488, -1, 11488, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5563, -1, 11491, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11490, -1, 11490, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5565, -1, 11500, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11499, -1, 11499, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5567, -1, 11502, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11501, -1, 11501, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 5569, -1, 11507, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 11506, -1, 11506, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 4256, -1, 4256, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 4257, -1, 4257, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 4258, -1, 4258, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 4259, -1, 4259, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 4260, -1, 4260, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 4261, -1, 4261, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 4262, -1, 4262, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 4263, -1, 4263, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 4264, -1, 4264, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 4265, -1, 4265, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 4266, -1, 4266, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 4267, -1, 4267, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 4268, -1, 4268, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 4269, -1, 4269, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 4270, -1, 4270, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 4271, -1, 4271, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 4272, -1, 4272, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 4273, -1, 4273, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 4274, -1, 4274, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 4275, -1, 4275, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 4276, -1, 4276, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 4277, -1, 4277, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 4278, -1, 4278, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 4279, -1, 4279, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 4280, -1, 4280, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 4281, -1, 4281, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 4282, -1, 4282, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 4283, -1, 4283, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 4284, -1, 4284, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 4285, -1, 4285, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 4286, -1, 4286, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 4287, -1, 4287, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 4288, -1, 4288, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 4289, -1, 4289, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 4290, -1, 4290, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 4291, -1, 4291, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 4292, -1, 4292, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 4293, -1, 4293, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 4295, -1, 4295, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 4301, -1, 4301, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 5571, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5573, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5575, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5577, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5579, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5581, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5583, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5585, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5587, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5589, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5591, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5593, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5595, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5597, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5599, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5601, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5603, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5605, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5607, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5609, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5611, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5613, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5615, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5617, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5619, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5621, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5623, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5625, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5627, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5629, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5631, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5633, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5635, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5637, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5639, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5641, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5643, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5645, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5647, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5649, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5651, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5653, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5655, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5657, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5659, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5661, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5663, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5665, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5667, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5669, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5671, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5673, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5675, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5677, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5679, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5681, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5683, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5685, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5687, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5689, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5691, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5693, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5695, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5697, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5699, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5701, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5703, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5705, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5707, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5709, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5711, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5713, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5715, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5717, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5719, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5721, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5723, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5725, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5727, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5729, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5731, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5733, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5735, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5737, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5739, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5741, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5743, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5745, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5747, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5749, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5751, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5753, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5755, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5757, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5759, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5761, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5763, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5765, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5767, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5769, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5771, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5773, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5775, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5777, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5779, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5781, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5783, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5785, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5787, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5789, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5791, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5793, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5795, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5797, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5799, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5801, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5803, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5805, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5807, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5809, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5811, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5813, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5815, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5817, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5819, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5821, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5823, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5825, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5827, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5829, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5831, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5833, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5835, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5837, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5839, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5841, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5843, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5845, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5847, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5849, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5851, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5853, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5855, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5857, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5859, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5861, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5863, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5865, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5867, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5869, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5871, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5873, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5875, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5877, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5879, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5881, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5883, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5885, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5887, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5889, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5891, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5893, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5895, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5897, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5899, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5901, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5903, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5905, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5907, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5909, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5911, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5913, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5915, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5917, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5919, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5921, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5923, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5925, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5927, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5929, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5931, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5933, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5935, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5937, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5939, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5941, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5943, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5945, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5947, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5949, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5951, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5953, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5955, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5957, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5959, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5961, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5963, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5965, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5967, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5969, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5971, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5973, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5975, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5977, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5979, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5981, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5983, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5985, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5987, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5989, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5991, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5993, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5995, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5997, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5999, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6001, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6003, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_ZS, 0, UTF8PROC_BIDI_CLASS_WS, UTF8PROC_DECOMP_TYPE_WIDE, utf8proc_sequences + 52, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_PS, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_PE, 0, UTF8PROC_BIDI_CLASS_ON, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_MN, 218, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MC, 224, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6005, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 5623, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6007, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6009, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 23120, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 21760, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6011, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 21828, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6014, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 21896, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6017, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 21964, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6020, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 22032, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6023, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 22100, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6026, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 22168, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6029, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 22236, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6032, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 22304, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6035, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 22372, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6038, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 22440, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6041, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 22508, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6044, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 22576, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6047, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 22644, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6050, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 22712, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6053, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 22780, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6056, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6059, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 22848, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6062, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6065, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 22916, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6068, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6071, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 22984, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6074, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6077, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 23052, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6080, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6083, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6086, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_MN, 8, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, 52, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_MN, 8, UTF8PROC_BIDI_CLASS_NSM, 0, NULL, NULL, -1, -1, -1, -1, 53, false, false, false, false, UTF8PROC_BOUNDCLASS_EXTEND, 0},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6089, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6092, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 23188, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6095, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_VERTICAL, utf8proc_sequences + 6098, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 24616, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 23256, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6101, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 23324, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6104, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 23392, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6107, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 23460, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6110, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 23528, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6113, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 23596, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6116, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 23664, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6119, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 23732, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6122, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 23800, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6125, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 23868, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6128, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 23936, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6131, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 24004, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6134, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 24072, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6137, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 24140, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6140, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 24208, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6143, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 24276, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6146, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6149, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 24344, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6152, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6155, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 24412, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6158, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6161, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 24480, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6164, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6167, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 24548, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6170, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6173, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 24684, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 24752, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 24820, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 24888, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6176, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6179, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6182, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6185, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6188, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, 24956, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6191, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_VERTICAL, utf8proc_sequences + 6194, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6197, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6199, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6201, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6203, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6205, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6207, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6209, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6211, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6213, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6215, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6217, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6219, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6221, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6223, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6225, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6227, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6229, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6231, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6233, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6235, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6237, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6239, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6241, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6243, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6245, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6247, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6249, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6251, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6253, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6255, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6257, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6259, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6261, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6263, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6265, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6267, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6269, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6271, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6273, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6275, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6277, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6279, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6281, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6283, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6285, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6287, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6289, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6291, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6293, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6295, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6297, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6299, NULL, -1, -1, -1, -1, -1, false, false, true, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6301, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6303, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6305, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6307, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6309, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6311, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6313, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6315, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6317, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6319, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6321, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6323, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6325, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6327, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6329, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6331, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6333, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6335, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6337, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6339, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6341, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6343, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6345, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6347, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6349, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6351, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6353, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6355, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6357, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6359, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6361, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6363, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6365, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6367, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6369, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6371, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6373, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6375, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6377, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6379, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6381, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6383, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 5577, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 5589, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 6385, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 6387, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 6389, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 6391, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 6393, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 6395, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 5585, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 6397, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 6399, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 6401, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 6403, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 5593, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6405, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6409, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6413, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6417, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6421, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6425, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6429, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6433, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6437, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6441, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6445, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6449, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6453, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6457, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6461, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6466, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6471, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6476, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6481, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6486, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6491, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6496, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6501, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6506, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6511, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6516, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6521, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6526, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6531, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6536, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6544, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6551, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6555, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6559, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6563, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6567, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6571, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6575, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6579, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6583, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6587, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6591, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6595, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6599, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6603, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6607, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6611, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6615, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6619, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6623, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6627, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6631, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6635, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6639, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6643, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6647, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6651, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6655, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6659, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6663, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6667, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6671, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6675, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6679, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6683, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6687, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6691, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6695, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6697, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 5709, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6699, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 6701, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6705, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6708, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6711, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6714, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6717, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6720, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6723, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6726, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6729, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6732, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6735, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6738, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6741, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6744, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6747, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6197, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6203, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6209, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6213, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6229, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6231, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6237, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6241, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6243, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6247, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6249, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6251, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6253, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6255, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6750, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6753, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6756, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6759, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6762, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6765, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6768, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6771, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6774, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6777, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6780, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6783, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6786, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6789, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6792, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6798, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6803, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 5577, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 5589, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6385, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6387, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6806, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6808, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6810, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 5599, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6812, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 5623, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 5723, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 5747, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 5745, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 5725, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 5909, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 5639, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 5719, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6814, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6816, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6818, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6820, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6822, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6824, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6826, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6828, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6830, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6832, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 5651, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6834, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6836, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6838, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6840, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6842, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6844, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6846, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6848, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6389, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6391, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6393, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6850, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6852, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6854, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6856, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6858, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6860, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6862, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6864, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6866, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6868, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6870, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6873, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6876, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6879, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6882, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6885, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6888, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6891, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6894, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6897, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6900, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6903, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6906, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6909, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6912, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6915, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6918, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6921, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6924, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6927, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6930, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6933, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6936, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6939, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6942, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6946, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 6950, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 6954, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 6957, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 6961, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 6964, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6968, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6970, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6972, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6974, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6976, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6978, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6980, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6982, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6984, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6986, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6988, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6990, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6992, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6994, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6996, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 6998, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 7000, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 7002, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 7004, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 7006, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 7008, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 7010, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 7012, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 7014, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 7016, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 7018, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 7020, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 7022, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 7024, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 7026, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 7028, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 7030, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 7032, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 7034, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 7036, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 7038, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 7040, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 7042, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 7044, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 7046, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 7048, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 7050, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 7052, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 7054, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 7056, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 7058, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, utf8proc_sequences + 7060, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7062, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7067, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7072, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7077, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7081, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7086, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7090, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7094, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7100, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7105, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7109, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7113, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7117, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7122, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7127, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7131, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7135, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7138, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7142, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7147, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7152, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7155, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7161, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7168, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7174, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7178, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7184, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7190, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7195, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7199, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7203, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7207, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7212, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7218, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7223, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7227, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7231, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7235, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7238, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7241, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7244, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7247, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7251, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7255, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7261, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7265, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7270, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7276, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7280, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7283, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7286, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7292, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7297, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7303, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7307, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7313, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7316, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7320, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7324, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7328, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7332, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7336, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7341, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7345, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7348, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7352, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7356, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7360, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7365, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7369, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7373, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7377, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7383, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7388, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7391, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7397, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7400, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7405, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7410, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7414, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7418, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7422, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7427, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7430, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7434, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7439, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7442, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7448, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 7452, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 7455, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 7458, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 7461, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 7464, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 7467, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 7470, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 7473, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 7476, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 7479, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 7482, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 7486, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 7490, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 7494, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 7498, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 7502, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 7506, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 7510, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 7514, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 7518, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 7522, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 7526, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 7530, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 7534, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 7538, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7542, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7546, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7549, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7552, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7556, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7559, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7562, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7565, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7569, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7573, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7576, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7579, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7582, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7585, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7588, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7593, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7596, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7599, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7602, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7605, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7608, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7611, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7614, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7617, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7621, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7626, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7629, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7632, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7635, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7638, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7641, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7644, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7647, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7651, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7655, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7659, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7663, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7666, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7669, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7672, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7675, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7678, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7681, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7684, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7687, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7690, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7693, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7697, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7701, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7704, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7708, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7712, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7716, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7719, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7723, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7727, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7732, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7735, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7739, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7743, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7747, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7751, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7757, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7764, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7767, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7770, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7773, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7776, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7779, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7782, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7785, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7788, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7791, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7794, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7797, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7800, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7803, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7806, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7809, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7812, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7815, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7818, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7823, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7826, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7829, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7832, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7837, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7841, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7844, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7847, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7850, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7853, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7856, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7859, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7862, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7865, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7868, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7871, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7875, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7878, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7881, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7885, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7889, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7892, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7897, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7901, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7904, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7907, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7910, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7913, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 7917, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 7921, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 7924, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 7927, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 7930, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 7933, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 7936, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 7939, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 7942, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 7945, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 7948, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 7952, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 7956, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 7960, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 7964, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 7968, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 7972, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 7976, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 7980, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 7984, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 7988, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 7992, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 7996, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 8000, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 8004, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 8008, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 8012, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 8016, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 8020, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 8024, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 8028, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, utf8proc_sequences + 8032, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SQUARE, utf8proc_sequences + 8036, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8040, -1, 42561, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42560, -1, 42560, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8042, -1, 42563, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42562, -1, 42562, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8044, -1, 42565, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42564, -1, 42564, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8046, -1, 42567, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42566, -1, 42566, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8048, -1, 42569, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42568, -1, 42568, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8050, -1, 42571, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42570, -1, 42570, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8052, -1, 42573, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42572, -1, 42572, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8054, -1, 42575, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42574, -1, 42574, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8056, -1, 42577, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42576, -1, 42576, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8058, -1, 42579, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42578, -1, 42578, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8060, -1, 42581, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42580, -1, 42580, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8062, -1, 42583, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42582, -1, 42582, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8064, -1, 42585, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42584, -1, 42584, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8066, -1, 42587, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42586, -1, 42586, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8068, -1, 42589, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42588, -1, 42588, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8070, -1, 42591, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42590, -1, 42590, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8072, -1, 42593, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42592, -1, 42592, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8074, -1, 42595, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42594, -1, 42594, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8076, -1, 42597, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42596, -1, 42596, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8078, -1, 42599, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42598, -1, 42598, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8080, -1, 42601, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42600, -1, 42600, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8082, -1, 42603, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42602, -1, 42602, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8084, -1, 42605, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42604, -1, 42604, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8086, -1, 42625, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42624, -1, 42624, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8088, -1, 42627, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42626, -1, 42626, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8090, -1, 42629, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42628, -1, 42628, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8092, -1, 42631, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42630, -1, 42630, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8094, -1, 42633, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42632, -1, 42632, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8096, -1, 42635, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42634, -1, 42634, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8098, -1, 42637, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42636, -1, 42636, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8100, -1, 42639, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42638, -1, 42638, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8102, -1, 42641, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42640, -1, 42640, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8104, -1, 42643, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42642, -1, 42642, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8106, -1, 42645, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42644, -1, 42644, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8108, -1, 42647, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42646, -1, 42646, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8110, -1, 42649, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42648, -1, 42648, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8112, -1, 42651, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42650, -1, 42650, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 1638, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 1642, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8114, -1, 42787, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42786, -1, 42786, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8116, -1, 42789, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42788, -1, 42788, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8118, -1, 42791, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42790, -1, 42790, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8120, -1, 42793, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42792, -1, 42792, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8122, -1, 42795, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42794, -1, 42794, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8124, -1, 42797, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42796, -1, 42796, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8126, -1, 42799, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42798, -1, 42798, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8128, -1, 42803, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42802, -1, 42802, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8130, -1, 42805, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42804, -1, 42804, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8132, -1, 42807, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42806, -1, 42806, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8134, -1, 42809, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42808, -1, 42808, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8136, -1, 42811, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42810, -1, 42810, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8138, -1, 42813, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42812, -1, 42812, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8140, -1, 42815, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42814, -1, 42814, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8142, -1, 42817, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42816, -1, 42816, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8144, -1, 42819, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42818, -1, 42818, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8146, -1, 42821, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42820, -1, 42820, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8148, -1, 42823, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42822, -1, 42822, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8150, -1, 42825, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42824, -1, 42824, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8152, -1, 42827, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42826, -1, 42826, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8154, -1, 42829, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42828, -1, 42828, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8156, -1, 42831, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42830, -1, 42830, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8158, -1, 42833, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42832, -1, 42832, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8160, -1, 42835, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42834, -1, 42834, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8162, -1, 42837, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42836, -1, 42836, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8164, -1, 42839, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42838, -1, 42838, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8166, -1, 42841, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42840, -1, 42840, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8168, -1, 42843, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42842, -1, 42842, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8170, -1, 42845, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42844, -1, 42844, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8172, -1, 42847, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42846, -1, 42846, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8174, -1, 42849, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42848, -1, 42848, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8176, -1, 42851, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42850, -1, 42850, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8178, -1, 42853, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42852, -1, 42852, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8180, -1, 42855, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42854, -1, 42854, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8182, -1, 42857, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42856, -1, 42856, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8184, -1, 42859, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42858, -1, 42858, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8186, -1, 42861, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42860, -1, 42860, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8188, -1, 42863, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42862, -1, 42862, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 8188, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8190, -1, 42874, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42873, -1, 42873, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8192, -1, 42876, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42875, -1, 42875, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8194, -1, 7545, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8196, -1, 42879, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42878, -1, 42878, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8198, -1, 42881, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42880, -1, 42880, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8200, -1, 42883, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42882, -1, 42882, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8202, -1, 42885, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42884, -1, 42884, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8204, -1, 42887, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42886, -1, 42886, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8206, -1, 42892, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42891, -1, 42891, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2496, -1, 613, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8208, -1, 42897, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42896, -1, 42896, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8210, -1, 42899, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42898, -1, 42898, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8212, -1, 42903, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42902, -1, 42902, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8214, -1, 42905, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42904, -1, 42904, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8216, -1, 42907, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42906, -1, 42906, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8218, -1, 42909, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42908, -1, 42908, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8220, -1, 42911, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42910, -1, 42910, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8222, -1, 42913, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42912, -1, 42912, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8224, -1, 42915, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42914, -1, 42914, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8226, -1, 42917, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42916, -1, 42916, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8228, -1, 42919, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42918, -1, 42918, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8230, -1, 42921, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42920, -1, 42920, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 1289, -1, 614, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2478, -1, 604, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2494, -1, 609, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8232, -1, 620, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8234, -1, 670, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8236, -1, 647, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 2502, -1, 669, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8238, -1, 43859, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8240, -1, 42933, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42932, -1, 42932, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8242, -1, 42935, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42934, -1, 42934, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 8244, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 605, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ET, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, 42931, -1, 42931, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 8118, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 8246, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 5445, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, utf8proc_sequences + 8248, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8250, 5024, -1, 5024, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8252, 5025, -1, 5025, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8254, 5026, -1, 5026, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8256, 5027, -1, 5027, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8258, 5028, -1, 5028, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8260, 5029, -1, 5029, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8262, 5030, -1, 5030, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8264, 5031, -1, 5031, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8266, 5032, -1, 5032, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8268, 5033, -1, 5033, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8270, 5034, -1, 5034, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8272, 5035, -1, 5035, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8274, 5036, -1, 5036, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8276, 5037, -1, 5037, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8278, 5038, -1, 5038, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8280, 5039, -1, 5039, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8282, 5040, -1, 5040, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8284, 5041, -1, 5041, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8286, 5042, -1, 5042, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8288, 5043, -1, 5043, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8290, 5044, -1, 5044, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8292, 5045, -1, 5045, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8294, 5046, -1, 5046, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8296, 5047, -1, 5047, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8298, 5048, -1, 5048, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8300, 5049, -1, 5049, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8302, 5050, -1, 5050, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8304, 5051, -1, 5051, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8306, 5052, -1, 5052, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8308, 5053, -1, 5053, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8310, 5054, -1, 5054, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8312, 5055, -1, 5055, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8314, 5056, -1, 5056, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8316, 5057, -1, 5057, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8318, 5058, -1, 5058, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8320, 5059, -1, 5059, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8322, 5060, -1, 5060, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8324, 5061, -1, 5061, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8326, 5062, -1, 5062, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8328, 5063, -1, 5063, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8330, 5064, -1, 5064, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8332, 5065, -1, 5065, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8334, 5066, -1, 5066, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8336, 5067, -1, 5067, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8338, 5068, -1, 5068, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8340, 5069, -1, 5069, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8342, 5070, -1, 5070, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8344, 5071, -1, 5071, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8346, 5072, -1, 5072, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8348, 5073, -1, 5073, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8350, 5074, -1, 5074, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8352, 5075, -1, 5075, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8354, 5076, -1, 5076, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8356, 5077, -1, 5077, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8358, 5078, -1, 5078, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8360, 5079, -1, 5079, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8362, 5080, -1, 5080, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8364, 5081, -1, 5081, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8366, 5082, -1, 5082, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8368, 5083, -1, 5083, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8370, 5084, -1, 5084, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8372, 5085, -1, 5085, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8374, 5086, -1, 5086, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8376, 5087, -1, 5087, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8378, 5088, -1, 5088, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8380, 5089, -1, 5089, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8382, 5090, -1, 5090, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8384, 5091, -1, 5091, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8386, 5092, -1, 5092, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8388, 5093, -1, 5093, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8390, 5094, -1, 5094, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8392, 5095, -1, 5095, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8394, 5096, -1, 5096, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8396, 5097, -1, 5097, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8398, 5098, -1, 5098, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8400, 5099, -1, 5099, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8402, 5100, -1, 5100, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8404, 5101, -1, 5101, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8406, 5102, -1, 5102, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, utf8proc_sequences + 8408, 5103, -1, 5103, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 1},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_LV, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_LVT, 2},
  {UTF8PROC_CATEGORY_CS, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_CONTROL, 0},
  {UTF8PROC_CATEGORY_CO, 0, UTF8PROC_BIDI_CLASS_L, 0, NULL, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 0},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 8410, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 8412, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 5893, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 8414, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 8416, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 8418, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 8420, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 6001, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 8422, NULL, -1, -1, -1, -1, -1, false, false, false, false, UTF8PROC_BOUNDCLASS_OTHER, 2},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, utf8proc_sequences + 