/*
 * Decompiled with CFR 0.152.
 */
package yuku.bintex;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

public class BintexWriter
implements Closeable {
    private OutputStream os_;
    private int pos_ = 0;

    public BintexWriter(OutputStream os) {
        this.os_ = os;
    }

    public BintexWriter reuse(OutputStream os) {
        this.os_ = os;
        this.pos_ = 0;
        return this;
    }

    public void writeShortString(String s) throws IOException {
        int len = s.length();
        if (len > 255) {
            throw new IllegalArgumentException("string must not more than 255 chars. String is: " + s);
        }
        this.os_.write(len);
        ++this.pos_;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            this.writeChar(c);
        }
    }

    public void writeLongString(String s) throws IOException {
        this.writeInt(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            this.writeChar(c);
        }
    }

    public void writeAutoString(String s) throws IOException {
        char c;
        int i;
        boolean semua8bit = true;
        int len = s.length();
        for (i = 0; i < len; ++i) {
            c = s.charAt(i);
            if (c <= '\u00ff') continue;
            semua8bit = false;
            break;
        }
        if (len <= 255 && semua8bit) {
            this.writeUint8(1);
        }
        if (len > 255 && semua8bit) {
            this.writeUint8(17);
        }
        if (len <= 255 && !semua8bit) {
            this.writeUint8(2);
        }
        if (len > 255 && !semua8bit) {
            this.writeUint8(18);
        }
        if (len <= 255) {
            this.writeUint8(len);
        } else {
            this.writeInt(len);
        }
        if (semua8bit) {
            for (i = 0; i < s.length(); ++i) {
                c = s.charAt(i);
                this.writeUint8(c);
            }
        } else {
            for (i = 0; i < s.length(); ++i) {
                c = s.charAt(i);
                this.writeChar(c);
            }
        }
    }

    public void writeInt(int a) throws IOException {
        this.os_.write((a & 0xFF000000) >> 24);
        this.os_.write((a & 0xFF0000) >> 16);
        this.os_.write((a & 0xFF00) >> 8);
        this.os_.write(a & 0xFF);
        this.pos_ += 4;
    }

    public void writeChar(char c) throws IOException {
        this.os_.write((c & 0xFF00) >> 8);
        this.os_.write(c & 0xFF);
        this.pos_ += 2;
    }

    public void writeUint8(int a) throws IOException {
        if (a < 0 || a > 255) {
            throw new IllegalArgumentException("uint8 must be 0 to 255");
        }
        this.os_.write(a);
        ++this.pos_;
    }

    public void writeUint16(int a) throws IOException {
        if (a < 0 || a > 65535) {
            throw new IllegalArgumentException("uint16 must be 0 to 65535");
        }
        this.os_.write((a & 0xFF00) >> 8);
        this.os_.write((a & 0xFF) >> 0);
        this.pos_ += 2;
    }

    public void writeFloat(float f) throws IOException {
        int a = Float.floatToIntBits(f);
        this.writeInt(a);
    }

    public void writeRaw(byte[] buf) throws IOException {
        this.writeRaw(buf, 0, buf.length);
    }

    public void writeRaw(byte[] buf, int off, int len) throws IOException {
        this.os_.write(buf, off, len);
        this.pos_ += len;
    }

    public void writeVarUint(int a) throws IOException {
        if (a < 0) {
            throw new RuntimeException("uint must be non-negative");
        }
        if (a <= 127) {
            this.os_.write(a);
            ++this.pos_;
        } else if (a <= 16383) {
            this.os_.write((a & 0xFF00) >> 8 | 0x80);
            this.os_.write((a & 0xFF) >> 0);
            this.pos_ += 2;
        } else if (a <= 0x1FFFFF) {
            this.os_.write((a & 0xFF0000) >> 16 | 0xC0);
            this.os_.write((a & 0xFF00) >> 8);
            this.os_.write(a & 0xFF);
            this.pos_ += 3;
        } else if (a <= 0xFFFFFFF) {
            this.os_.write((a & 0xFF000000) >> 24 | 0xE0);
            this.os_.write((a & 0xFF0000) >> 16);
            this.os_.write((a & 0xFF00) >> 8);
            this.os_.write(a & 0xFF);
            this.pos_ += 4;
        } else {
            this.os_.write(240);
            this.os_.write((a & 0xFF000000) >> 24);
            this.os_.write((a & 0xFF0000) >> 16);
            this.os_.write((a & 0xFF00) >> 8);
            this.os_.write(a & 0xFF);
            this.pos_ += 5;
        }
    }

    public void writeValueInt(int a) throws IOException {
        if (a == 0) {
            this.os_.write(14);
            ++this.pos_;
        } else if (a >= 1 && a <= 7) {
            this.os_.write(a);
            ++this.pos_;
        } else if (a == -1) {
            this.os_.write(15);
            ++this.pos_;
        } else if (a > 0) {
            if (a < 256) {
                this.os_.write(16);
                this.os_.write(a);
                this.pos_ += 2;
            } else if (a < 65536) {
                this.os_.write(32);
                this.os_.write((a & 0xFF00) >> 8);
                this.os_.write(a & 0xFF);
                this.pos_ += 3;
            } else if (a < 0x1000000) {
                this.os_.write(48);
                this.os_.write((a & 0xFF0000) >> 16);
                this.os_.write((a & 0xFF00) >> 8);
                this.os_.write(a & 0xFF);
                this.pos_ += 4;
            } else {
                this.os_.write(64);
                this.os_.write((a & 0xFF000000) >> 24);
                this.os_.write((a & 0xFF0000) >> 16);
                this.os_.write((a & 0xFF00) >> 8);
                this.os_.write(a & 0xFF);
                this.pos_ += 5;
            }
        } else if ((a ^= 0xFFFFFFFF) < 256) {
            this.os_.write(17);
            this.os_.write(a);
            this.pos_ += 2;
        } else if (a < 65536) {
            this.os_.write(33);
            this.os_.write((a & 0xFF00) >> 8);
            this.os_.write(a & 0xFF);
            this.pos_ += 3;
        } else if (a < 0x1000000) {
            this.os_.write(49);
            this.os_.write((a & 0xFF0000) >> 16);
            this.os_.write((a & 0xFF00) >> 8);
            this.os_.write(a & 0xFF);
            this.pos_ += 4;
        } else {
            this.os_.write(65);
            this.os_.write((a & 0xFF000000) >> 24);
            this.os_.write((a & 0xFF0000) >> 16);
            this.os_.write((a & 0xFF00) >> 8);
            this.os_.write(a & 0xFF);
            this.pos_ += 5;
        }
    }

    public void writeValueString(String s) throws IOException {
        if (s == null) {
            this.os_.write(12);
            ++this.pos_;
        } else if (s.length() == 0) {
            this.os_.write(13);
            ++this.pos_;
        } else {
            char c;
            int i;
            boolean all8bits = true;
            int len = s.length();
            for (i = 0; i < len; ++i) {
                c = s.charAt(i);
                if (c <= '\u00ff') continue;
                all8bits = false;
                break;
            }
            if (len < 16) {
                if (all8bits) {
                    this.os_.write(0x50 | len);
                } else {
                    this.os_.write(0x60 | len);
                }
                ++this.pos_;
            } else if (len < 256) {
                if (all8bits) {
                    this.os_.write(112);
                    this.os_.write(len);
                } else {
                    this.os_.write(113);
                    this.os_.write(len);
                }
                this.pos_ += 2;
            } else {
                if (all8bits) {
                    this.os_.write(114);
                } else {
                    this.os_.write(115);
                }
                ++this.pos_;
                this.writeInt(len);
            }
            if (all8bits) {
                for (i = 0; i < s.length(); ++i) {
                    c = s.charAt(i);
                    this.os_.write(c);
                }
                this.pos_ += len;
            } else {
                for (i = 0; i < s.length(); ++i) {
                    c = s.charAt(i);
                    this.os_.write((c & 0xFF00) >> 8);
                    this.os_.write(c & 0xFF);
                }
                this.pos_ += len << 1;
            }
        }
    }

    public void writeValueUint8Array(int[] a) throws IOException {
        int len = a.length;
        if (len < 256) {
            this.writeUint8(192);
            this.writeUint8(len);
        } else {
            this.writeUint8(200);
            this.writeInt(len);
        }
        for (int e : a) {
            if (e > 255) {
                throw new RuntimeException("element is larger than 255");
            }
            this.os_.write(e);
        }
        this.pos_ += len;
    }

    public void writeValueUint16Array(int[] a) throws IOException {
        int len = a.length;
        if (len < 256) {
            this.writeUint8(193);
            this.writeUint8(len);
        } else {
            this.writeUint8(201);
            this.writeInt(len);
        }
        for (int e : a) {
            if (e > 65535) {
                throw new RuntimeException("element is larger than 0xffff");
            }
            this.os_.write((e & 0xFF00) >> 8);
            this.os_.write((e & 0xFF) >> 0);
        }
        this.pos_ += len + len;
    }

    public void writeValueIntArray(int[] a) throws IOException {
        boolean allUint16;
        boolean allUint8;
        block7: {
            int e;
            int n;
            allUint8 = true;
            allUint16 = true;
            int[] nArray = a;
            int n2 = nArray.length;
            for (n = 0; n < n2; ++n) {
                e = nArray[n];
                if (e >= 0 && e <= 65535) continue;
                allUint16 = false;
                allUint8 = false;
                break block7;
            }
            nArray = a;
            n2 = nArray.length;
            for (n = 0; n < n2; ++n) {
                e = nArray[n];
                if (e <= 255) continue;
                allUint8 = false;
                break;
            }
        }
        if (allUint8) {
            this.writeValueUint8Array(a);
            return;
        }
        if (allUint16) {
            this.writeValueUint16Array(a);
            return;
        }
        int len = a.length;
        if (len < 256) {
            this.writeUint8(196);
            this.writeUint8(len);
        } else {
            this.writeUint8(204);
            this.writeInt(len);
        }
        for (int e : a) {
            this.os_.write((e & 0xFF000000) >> 24);
            this.os_.write((e & 0xFF0000) >> 16);
            this.os_.write((e & 0xFF00) >> 8);
            this.os_.write(e & 0xFF);
        }
        this.pos_ += len << 2;
    }

    public void writeValueSimpleMap(Map<String, Object> map) throws IOException {
        int size = map.size();
        if (size == 0) {
            this.os_.write(144);
            ++this.pos_;
            return;
        }
        if (size > 255) {
            throw new RuntimeException("entries of map max 255");
        }
        for (Map.Entry<String, Object> e : map.entrySet()) {
            Object v = e.getValue();
            if (!(v instanceof String || v instanceof Number || v instanceof int[] || v instanceof Map)) {
                throw new RuntimeException("map entry values must be string, or int, or int array, or simple map");
            }
            String k = e.getKey();
            if (k == null || k.length() > 255) {
                throw new RuntimeException("map entry keys must be string with length max 255");
            }
            for (int i = 0; i < k.length(); ++i) {
                char c = k.charAt(i);
                if (c <= '\u00ff') continue;
                throw new RuntimeException("map entry keys must be string with 8-bit characters");
            }
        }
        this.os_.write(145);
        this.os_.write(size);
        this.pos_ += 2;
        for (Map.Entry<String, Object> e : map.entrySet()) {
            String k = e.getKey();
            this.os_.write(k.length());
            ++this.pos_;
            for (int i = 0; i < k.length(); ++i) {
                this.os_.write(k.charAt(i));
            }
            this.pos_ += k.length();
            Object v = e.getValue();
            if (v instanceof String) {
                this.writeValueString((String)v);
                continue;
            }
            if (v instanceof Number) {
                this.writeValueInt(((Number)v).intValue());
                continue;
            }
            if (v instanceof int[]) {
                this.writeValueIntArray((int[])v);
                continue;
            }
            if (!(v instanceof Map)) continue;
            Map v_map = (Map)v;
            this.writeValueSimpleMap(v_map);
        }
    }

    @Override
    public void close() throws IOException {
        this.os_.close();
    }

    public int getPos() {
        return this.pos_;
    }

    public OutputStream getOutputStream() {
        return new OutputStream(){

            @Override
            public void write(int oneByte) throws IOException {
                BintexWriter.this.writeUint8(oneByte);
            }

            @Override
            public void write(byte[] buffer, int offset, int count) throws IOException {
                BintexWriter.this.writeRaw(buffer, offset, count);
            }
        };
    }
}

