/*
 * Decompiled with CFR 0.152.
 */
package yuku.alkitabconverter.yes1;

import java.io.FileInputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import yuku.alkitabconverter.yes1.RandomOutputStream;
import yuku.bintex.BintexWriter;

@Deprecated
public class Yes1File {
    private static final byte FILE_VERSI = 1;
    private static final String TAG = Yes1File.class.getSimpleName();
    byte[] FILE_HEADER = new byte[]{-104, 88, 13, 10, 0, 93, -32, 1};
    public Seksi[] xseksi;
    static Boolean bisaLog = null;

    public void output(RandomAccessFile file) throws Exception {
        RandomOutputStream ros = new RandomOutputStream(file);
        BintexWriter os2 = new BintexWriter(ros);
        os2.writeRaw(this.FILE_HEADER);
        long pos = file.getFilePointer();
        for (Seksi seksi : this.xseksi) {
            pos = file.getFilePointer();
            byte[] nama = seksi.nama();
            if (Yes1File.bisaLog()) {
                Log.d(TAG, "[pos=" + pos + "] tulis nama seksi: " + new String(nama));
            }
            os2.writeRaw(nama);
            pos = file.getFilePointer();
            byte[] palsu = new byte[]{-1, -1, -1, -1};
            if (Yes1File.bisaLog()) {
                Log.d(TAG, "[pos=" + pos + "] tulis placeholder ukuran");
            }
            os2.writeRaw(palsu);
            int posSebelumIsi = os2.getPos();
            if (Yes1File.bisaLog()) {
                Log.d(TAG, "[pos=" + file.getFilePointer() + "] tulis isi seksi");
            }
            seksi.isi().toBytes(os2);
            int posSesudahIsi = os2.getPos();
            int ukuranIsi = posSesudahIsi - posSebelumIsi;
            if (Yes1File.bisaLog()) {
                Log.d(TAG, "[pos=" + file.getFilePointer() + "] isi seksi selesai ditulis, sebesar " + ukuranIsi);
            }
            long posUntukMelanjutkan = file.getFilePointer();
            file.seek(pos);
            if (Yes1File.bisaLog()) {
                Log.d(TAG, "[pos=" + pos + "] tulis ukuran: " + ukuranIsi);
            }
            os2.writeInt(ukuranIsi);
            file.seek(posUntukMelanjutkan);
        }
        pos = file.getFilePointer();
        if (Yes1File.bisaLog()) {
            Log.d(TAG, "[pos=" + pos + "] tulis penanda tidak ada seksi lagi (____________)");
        }
        os2.writeRaw("____________".getBytes("ascii"));
        os2.close();
        pos = file.getFilePointer();
        if (Yes1File.bisaLog()) {
            Log.d(TAG, "[pos=" + pos + "] selesai");
        }
    }

    private static boolean bisaLog() {
        if (bisaLog == null) {
            try {
                Class.forName("android.util.Log");
                bisaLog = true;
            }
            catch (Exception e) {
                bisaLog = false;
            }
        }
        return bisaLog;
    }

    static class Log {
        Log() {
        }

        public static void d(String tag, String msg) {
            System.out.println(tag + "\t" + msg);
        }
    }

    public static class PericopeData {
        public List<Entry> entries;

        public void addEntry(Entry e) {
            if (this.entries == null) {
                this.entries = new ArrayList<Entry>();
            }
            this.entries.add(e);
        }

        public static class Block {
            public int version;
            public String title;
            public List<String> parallels;
            int _offset = -1;

            public void addParallel(String parallel) {
                if (this.parallels == null) {
                    this.parallels = new ArrayList<String>();
                }
                this.parallels.add(parallel);
            }
        }

        public static class Entry {
            public int ari;
            public Block block;
        }
    }

    public static class PerikopIndex
    implements IsiSeksi {
        private final PericopeData data;

        public PerikopIndex(PericopeData data) {
            this.data = data;
        }

        @Override
        public void toBytes(BintexWriter writer) throws Exception {
            writer.writeInt(this.data.entries.size());
            for (PericopeData.Entry entry : this.data.entries) {
                if (entry.block._offset == -1) {
                    throw new RuntimeException("offset entri perikop belum dihitung");
                }
                writer.writeInt(entry.ari);
                writer.writeInt(entry.block._offset);
            }
        }
    }

    public static class PerikopBlok
    implements IsiSeksi {
        private final PericopeData data;

        public PerikopBlok(PericopeData data) {
            this.data = data;
        }

        @Override
        public void toBytes(BintexWriter writer) throws Exception {
            int offsetAwalSeksi = writer.getPos();
            for (PericopeData.Entry entry : this.data.entries) {
                int offsetAwalEntri = writer.getPos();
                writer.writeUint8(entry.block.version);
                if (entry.block.version == 2) {
                    writer.writeLongString(entry.block.title);
                    writer.writeUint8(entry.block.parallels == null ? 0 : entry.block.parallels.size());
                    if (entry.block.parallels != null) {
                        for (String paralel : entry.block.parallels) {
                            writer.writeShortString(paralel);
                        }
                    }
                } else if (entry.block.version == 3) {
                    writer.writeAutoString(entry.block.title);
                    writer.writeUint8(entry.block.parallels == null ? 0 : entry.block.parallels.size());
                    if (entry.block.parallels != null) {
                        for (String paralel : entry.block.parallels) {
                            writer.writeAutoString(paralel);
                        }
                    }
                } else {
                    throw new RuntimeException("pericope entry.block.version " + entry.block.version + " not supported yet");
                }
                entry.block._offset = offsetAwalEntri - offsetAwalSeksi;
            }
        }
    }

    public static class NemplokSeksi
    implements IsiSeksi {
        private String nf;

        public NemplokSeksi(String nf) {
            this.nf = nf;
        }

        @Override
        public void toBytes(BintexWriter writer) throws Exception {
            int r;
            FileInputStream in = new FileInputStream(this.nf);
            byte[] b = new byte[10000];
            while ((r = in.read(b)) > 0) {
                writer.writeRaw(b, 0, r);
            }
            in.close();
        }
    }

    public static class Teks
    implements IsiSeksi {
        private final String encoding;
        int ayatLoncat = 0;
        public String[] xisi;

        public Teks(String encoding) {
            this.encoding = encoding;
        }

        @Override
        public void toBytes(BintexWriter writer) throws Exception {
            if (this.ayatLoncat != 0) {
                throw new RuntimeException("ayatLoncat ga 0");
            }
            for (String isi : this.xisi) {
                writer.writeRaw(isi.getBytes(this.encoding));
                writer.writeUint8(10);
            }
        }
    }

    public static class InfoKitab
    implements IsiSeksi {
        public Kitab[] xkitab;

        @Override
        public void toBytes(BintexWriter writer) throws Exception {
            for (Kitab kitab : this.xkitab) {
                if (kitab != null) {
                    kitab.toBytes(writer);
                    continue;
                }
                Kitab.nullToBytes(writer);
            }
        }
    }

    public static class Kitab {
        public int versi;
        public int pos;
        public int pdbBookNumber;
        public String nama;
        public String judul;
        public int npasal;
        public int[] nayat;
        public int ayatLoncat;
        public int[] pasal_offset;
        public int encoding;
        public int offset;

        public void toBytes(BintexWriter writer) throws Exception {
            writer.writeShortString("versi");
            writer.writeInt(this.versi);
            writer.writeShortString("pos");
            writer.writeInt(this.pos);
            writer.writeShortString("nama");
            writer.writeShortString(this.nama);
            writer.writeShortString("judul");
            writer.writeShortString(this.judul);
            writer.writeShortString("npasal");
            writer.writeInt(this.npasal);
            writer.writeShortString("nayat");
            for (int a : this.nayat) {
                writer.writeUint8(a);
            }
            writer.writeShortString("ayatLoncat");
            writer.writeInt(this.ayatLoncat);
            writer.writeShortString("pasal_offset");
            for (int a : this.pasal_offset) {
                writer.writeInt(a);
            }
            if (this.encoding != 0) {
                writer.writeShortString("encoding");
                writer.writeInt(this.encoding);
            }
            writer.writeShortString("offset");
            writer.writeInt(this.offset);
            if (this.pdbBookNumber != 0) {
                writer.writeShortString("pdbBookNumber");
                writer.writeInt(this.pdbBookNumber);
            }
            writer.writeShortString("end");
        }

        public static void nullToBytes(BintexWriter writer) throws Exception {
            writer.writeShortString("end");
        }
    }

    public static abstract class InfoEdisi
    implements IsiSeksi {
        public int versi;
        public String nama;
        public String shortName;
        public String longName;
        public String keterangan;
        public String locale;
        public int nkitab;
        public int perikopAda;
        public int encoding;

        @Override
        public void toBytes(BintexWriter writer) throws Exception {
            writer.writeShortString("versi");
            writer.writeInt(this.versi);
            if (this.nama != null) {
                writer.writeShortString("nama");
                writer.writeShortString(this.nama);
            }
            writer.writeShortString("judul");
            writer.writeShortString(this.longName);
            if (this.shortName != null) {
                writer.writeShortString("shortName");
                writer.writeShortString(this.shortName);
            }
            writer.writeShortString("keterangan");
            writer.writeLongString(this.keterangan);
            writer.writeShortString("nkitab");
            writer.writeInt(this.nkitab);
            writer.writeShortString("perikopAda");
            writer.writeInt(this.perikopAda);
            writer.writeShortString("encoding");
            writer.writeInt(this.encoding);
            if (this.locale != null) {
                writer.writeShortString("locale");
                writer.writeShortString(this.locale);
            }
            writer.writeShortString("end");
        }
    }

    public static interface IsiSeksi {
        public void toBytes(BintexWriter var1) throws Exception;
    }

    public abstract class SeksiBernama
    implements Seksi {
        private byte[] nama;

        public SeksiBernama(String nama) {
            try {
                this.nama = nama.getBytes("ascii");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }

        @Override
        public final byte[] nama() {
            return this.nama;
        }
    }

    public static interface Seksi {
        public byte[] nama();

        public IsiSeksi isi();
    }
}

