/*
 * Decompiled with CFR 0.152.
 */
package yuku.alkitab.yes2.section;

import java.io.IOException;
import yuku.alkitab.model.PericopeBlock;
import yuku.alkitab.model.PericopeIndex;
import yuku.alkitab.yes2.io.RandomInputStream;
import yuku.alkitab.yes2.io.RandomOutputStream;
import yuku.alkitab.yes2.model.PericopeData;
import yuku.alkitab.yes2.model.Yes2PericopeBlock;
import yuku.alkitab.yes2.section.base.SectionContent;
import yuku.bintex.BintexReader;
import yuku.bintex.BintexWriter;

public class PericopesSection
extends SectionContent
implements SectionContent.Writer {
    public static final String SECTION_NAME = "pericopes";
    PericopeData data_;
    RandomInputStream input_;
    int data_offset_ = 0;
    PericopeIndex index_;

    private PericopesSection() {
        super(SECTION_NAME);
    }

    public PericopesSection(PericopeData data) {
        super(SECTION_NAME);
        this.data_ = data;
    }

    public Yes2PericopeBlock readBlock(int position) throws IOException {
        int offset = this.index_.offsets[position];
        this.input_.seek(this.data_offset_ + offset);
        return Yes2PericopeBlock.read(this.input_);
    }

    @Override
    public void write(RandomOutputStream output) throws IOException {
        BintexWriter bw = new BintexWriter(output);
        long savedpos_sectionBegin = output.getFilePointer();
        bw.writeUint8(3);
        long savedpos_indexSize = output.getFilePointer();
        bw.writeInt(-1);
        int entry_count = this.data_.entries.size();
        bw.writeInt(entry_count);
        long[] savedpos_entryOffsets = new long[entry_count];
        int last_entry_ari = 0;
        for (int i = 0; i < entry_count; ++i) {
            PericopeData.Entry entry = this.data_.entries.get(i);
            int diff_ari = entry.ari - last_entry_ari;
            if (last_entry_ari == 0 || diff_ari < 0 || diff_ari > Short.MAX_VALUE) {
                bw.writeInt(0 | 0xFFFFFF & entry.ari);
            } else {
                bw.writeUint16(0x8000 | diff_ari);
            }
            last_entry_ari = entry.ari;
            savedpos_entryOffsets[i] = output.getFilePointer();
            bw.writeUint16(65535);
        }
        long dataBeginOffset = output.getFilePointer();
        int[] savedoffset_entryOffsets = new int[entry_count];
        for (int i = 0; i < entry_count; ++i) {
            PericopeData.Entry entry = this.data_.entries.get(i);
            savedoffset_entryOffsets[i] = (int)(output.getFilePointer() - dataBeginOffset);
            bw.writeUint8(4);
            bw.writeValueString(entry.block.title);
            bw.writeUint8(entry.block.parallels == null ? 0 : entry.block.parallels.size());
            if (entry.block.parallels == null) continue;
            for (String parallel : entry.block.parallels) {
                bw.writeValueString(parallel);
            }
        }
        long savedpos_sectionEnd = output.getFilePointer();
        int section_size = (int)(savedpos_sectionEnd - savedpos_sectionBegin);
        output.seek(savedpos_indexSize);
        bw.writeInt(section_size);
        int last_offset = 0;
        for (int i = 0; i < entry_count; ++i) {
            int diff_offset = savedoffset_entryOffsets[i] - last_offset;
            if (diff_offset > 65535) {
                throw new RuntimeException("a pericope entry can't be larger than 65535 bytes");
            }
            output.seek(savedpos_entryOffsets[i]);
            bw.writeUint16(diff_offset);
            last_offset = savedoffset_entryOffsets[i];
        }
        output.seek(savedpos_sectionEnd);
    }

    public int getPericopesForAris(int ari_from, int ari_to, int[] aris, PericopeBlock[] blocks, int max) throws IOException {
        int ari;
        int first = this.index_.findFirst(ari_from, ari_to);
        if (first == -1) {
            return 0;
        }
        int cur = first;
        int res = 0;
        while ((ari = this.index_.getAri(cur)) < ari_to) {
            Yes2PericopeBlock block = this.readBlock(cur);
            ++cur;
            if (res >= max) break;
            aris[res] = ari;
            blocks[res] = block;
            ++res;
        }
        return res;
    }

    public static class Reader
    implements SectionContent.Reader<PericopesSection> {
        @Override
        public PericopesSection read(RandomInputStream input) throws Exception {
            BintexReader br = new BintexReader(input);
            int version = br.readUint8();
            if (version != 2 && version != 3) {
                throw new RuntimeException("PericopeIndex version not supported: " + version);
            }
            br.readInt();
            int entry_count = br.readInt();
            PericopesSection res = new PericopesSection();
            res.index_ = new PericopeIndex();
            int[] aris = new int[entry_count];
            res.index_.aris = aris;
            int[] offsets = new int[entry_count];
            res.index_.offsets = offsets;
            if (version == 2) {
                for (int i = 0; i < entry_count; ++i) {
                    aris[i] = br.readInt();
                    offsets[i] = br.readInt();
                }
            } else if (version == 3) {
                int last_entry_ari = 0;
                int last_entry_offset = 0;
                for (int i = 0; i < entry_count; ++i) {
                    int offset;
                    int data_ari = br.readUint16();
                    int ari = (data_ari & 0x8000) == 0 ? data_ari << 16 | br.readUint16() : last_entry_ari + (data_ari & Short.MAX_VALUE);
                    aris[i] = last_entry_ari = ari;
                    int data_offset = br.readUint16();
                    offsets[i] = last_entry_offset = (offset = last_entry_offset + data_offset);
                }
            }
            res.input_ = input;
            res.data_offset_ = (int)input.getFilePointer();
            return res;
        }
    }
}

