/*
 * Decompiled with CFR 0.152.
 */
package yuku.alkitab.yes2;

import android.util.Log;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import yuku.alkitab.yes2.io.RandomOutputStream;
import yuku.alkitab.yes2.section.base.SectionContent;
import yuku.bintex.BintexWriter;
import yuku.bintex.ValueMap;

public class Yes2Writer {
    private static final String TAG = Yes2Writer.class.getSimpleName();
    private static final byte YES_VERSION = 2;
    private static final byte[] YES_HEADER = new byte[]{-104, 88, 13, 10, 0, 93, -32, 2};
    private static Boolean androidLogPossible = null;
    public List<SectionContent> sections = new ArrayList<SectionContent>();

    private static void alog(long pos, String msg) {
        Yes2Writer.alog("[pos=" + pos + "] " + msg, null);
    }

    private static void alog(String msg, Throwable t) {
        if (androidLogPossible == null) {
            try {
                Class.forName("android.util.Log");
                androidLogPossible = true;
            }
            catch (Exception e) {
                androidLogPossible = false;
            }
        }
        if (androidLogPossible.booleanValue()) {
            if (t != null) {
                Log.e((String)TAG, (String)msg, (Throwable)t);
            } else {
                Log.d((String)TAG, (String)msg);
            }
        } else {
            System.err.println(msg);
            if (t != null) {
                t.printStackTrace();
            }
        }
    }

    public void writeToFile(RandomOutputStream output) throws IOException {
        SectionContent section;
        BintexWriter bw = new BintexWriter(output);
        int section_count = this.sections.size();
        Yes2Writer.alog(output.getFilePointer(), "write yes header");
        bw.writeRaw(YES_HEADER);
        long[] savedpos_sectionIndexSizeEntries = new long[section_count];
        int[] saved_sectionOffset = new int[section_count];
        int[] savedsizes_sectionAttributes = new int[section_count];
        int[] savedsizes_sectionContent = new int[section_count];
        long savedpos_sectionIndexSize = output.getFilePointer();
        bw.writeInt(-1);
        Yes2Writer.alog(output.getFilePointer(), "write sectionIndexVersion: 1");
        bw.writeUint8(1);
        Yes2Writer.alog(output.getFilePointer(), "write section_count: " + section_count);
        bw.writeInt(section_count);
        long savedpos_startOfSectionIndex = output.getFilePointer();
        for (int i = 0; i < section_count; ++i) {
            section = this.sections.get(i);
            String name = section.getName();
            byte[] name_bytes = section.getNameAsBytesWithLength();
            Yes2Writer.alog(output.getFilePointer(), "write sectionName: " + name);
            bw.writeRaw(name_bytes);
            savedpos_sectionIndexSizeEntries[i] = output.getFilePointer();
            bw.writeInt(-1);
            bw.writeInt(-1);
            bw.writeInt(-1);
            bw.writeInt(0);
        }
        long lastPos = output.getFilePointer();
        output.seek(savedpos_sectionIndexSize);
        int size = (int)(lastPos - savedpos_startOfSectionIndex);
        Yes2Writer.alog(output.getFilePointer(), "write section index size: " + size);
        bw.writeInt(size);
        output.seek(lastPos);
        long savedpos_startOfSections = output.getFilePointer();
        for (int i = 0; i < section_count; ++i) {
            section = this.sections.get(i);
            String section_name = section.getName();
            saved_sectionOffset[i] = (int)(output.getFilePointer() - savedpos_startOfSections);
            int posBeforeAttributes = (int)output.getFilePointer();
            Yes2Writer.alog(output.getFilePointer(), "write section attributes: " + section_name);
            ValueMap attributes = section.getAttributes();
            bw.writeValueSimpleMap(attributes == null ? new ValueMap() : attributes);
            savedsizes_sectionAttributes[i] = (int)output.getFilePointer() - posBeforeAttributes;
            int posBeforeContent = (int)output.getFilePointer();
            Yes2Writer.alog(output.getFilePointer(), "write section content: " + section_name);
            ((SectionContent.Writer)((Object)section)).write(output);
            savedsizes_sectionContent[i] = (int)output.getFilePointer() - posBeforeContent;
        }
        lastPos = output.getFilePointer();
        for (int i = 0; i < section_count; ++i) {
            SectionContent section2 = this.sections.get(i);
            String section_name = section2.getName();
            int offset = saved_sectionOffset[i];
            int attributes_size = savedsizes_sectionAttributes[i];
            int content_size = savedsizes_sectionContent[i];
            output.seek(savedpos_sectionIndexSizeEntries[i]);
            Yes2Writer.alog(output.getFilePointer(), "write offset, attributes_size, content_size of section " + section_name + ": " + offset + ", " + attributes_size + ", " + content_size);
            bw.writeInt(offset);
            bw.writeInt(attributes_size);
            bw.writeInt(content_size);
        }
        output.seek(lastPos);
        Yes2Writer.alog(output.getFilePointer(), "write footer");
        bw.writeUint8(0);
        Yes2Writer.alog(output.getFilePointer(), "done");
        bw.close();
    }
}

