/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.jsnappy;

import de.jarnbjo.jsnappy.IntIterator;

class IntListHashMap {
    private int[][] content;
    private int buckets;
    private IntIterator iterator = new IntIterator();

    IntListHashMap(int buckets) {
        this.buckets = buckets;
        this.content = new int[buckets][];
    }

    void put(int key, int value) {
        int off;
        int[] data;
        int bucket = key % this.buckets;
        if (bucket < 0) {
            bucket = -bucket;
        }
        if ((data = this.content[bucket]) == null) {
            data = new int[33];
            this.content[bucket] = data;
        }
        if ((off = data[0] * 2 + 1) == 1 || data[off - 2] != key || data[off - 1] != value) {
            if (off >= data.length) {
                int[] ndata = new int[(data.length - 1) * 2 + 1];
                System.arraycopy(data, 0, ndata, 0, off);
                data = ndata;
                this.content[bucket] = data;
            }
            data[off++] = key;
            data[off++] = value;
            data[0] = data[0] + 1;
        }
    }

    IntIterator getReverse(int key) {
        int[] data;
        int bucket = key % this.buckets;
        if (bucket < 0) {
            bucket = -bucket;
        }
        if ((data = this.content[bucket]) == null) {
            return IntIterator.EMTPY_ITERATOR;
        }
        this.iterator.data = data;
        this.iterator.offset = data[0] * 2 + 1;
        this.iterator.key = key;
        return this.iterator;
    }

    int getFirstHit(int key, int maxValue) {
        int[] data;
        int bucket = key % this.buckets;
        if (bucket < 0) {
            bucket = -bucket;
        }
        if ((data = this.content[bucket]) == null) {
            return -1;
        }
        for (int offset = data[0] * 2 - 1; offset > 0; offset -= 2) {
            if (data[offset] != key || data[offset + 1] > maxValue) continue;
            return data[offset + 1];
        }
        return -1;
    }
}

