/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.image.rendered.AbstractTiledRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.rendered.TileStore;

public class TileCacheRed
extends AbstractTiledRed {
    public TileCacheRed(CachableRed cachableRed) {
        super(cachableRed, null);
    }

    public TileCacheRed(CachableRed cachableRed, int n, int n2) {
        ColorModel colorModel = cachableRed.getColorModel();
        Rectangle rectangle = cachableRed.getBounds();
        if (n > rectangle.width) {
            n = rectangle.width;
        }
        if (n2 > rectangle.height) {
            n2 = rectangle.height;
        }
        SampleModel sampleModel = colorModel.createCompatibleSampleModel(n, n2);
        this.init(cachableRed, cachableRed.getBounds(), colorModel, sampleModel, cachableRed.getTileGridXOffset(), cachableRed.getTileGridYOffset(), null);
    }

    public void genRect(WritableRaster writableRaster) {
        CachableRed cachableRed = (CachableRed)this.getSources().get(0);
        cachableRed.copyData(writableRaster);
    }

    public void flushCache(Rectangle rectangle) {
        int n = this.getXTile(rectangle.x);
        int n2 = this.getYTile(rectangle.y);
        int n3 = this.getXTile(rectangle.x + rectangle.width - 1);
        int n4 = this.getYTile(rectangle.y + rectangle.height - 1);
        if (n < this.minTileX) {
            n = this.minTileX;
        }
        if (n2 < this.minTileY) {
            n2 = this.minTileY;
        }
        if (n3 >= this.minTileX + this.numXTiles) {
            n3 = this.minTileX + this.numXTiles - 1;
        }
        if (n4 >= this.minTileY + this.numYTiles) {
            n4 = this.minTileY + this.numYTiles - 1;
        }
        if (n3 < n || n4 < n2) {
            return;
        }
        TileStore tileStore = this.getTileStore();
        for (int i = n2; i <= n4; ++i) {
            for (int j = n; j <= n3; ++j) {
                tileStore.setTile(j, i, null);
            }
        }
    }
}

